/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.ui.common.BaseCardController;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.model.DevicesStatistics;
import com.intel.stl.ui.model.GroupStatistics;
import com.intel.stl.ui.monitor.PSNodesDetailsController;
import com.intel.stl.ui.monitor.PSPortsDetailsController;
import com.intel.stl.ui.monitor.view.PSStatisticsCardView;
import java.awt.Component;
import net.engio.mbassy.bus.MBassador;

public class PSStatisticsCard
extends BaseCardController<ICardListener, PSStatisticsCardView> {
    private final PSNodesDetailsController nodeController;
    private final PSPortsDetailsController portController;

    public PSStatisticsCard(PSStatisticsCardView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.nodeController = new PSNodesDetailsController(STLConstants.K0014_ACTIVE_NODES.getValue(), view.getNodesPanel());
        this.portController = new PSPortsDetailsController(STLConstants.K0024_ACTIVE_PORTS.getValue(), view.getPortsPanel());
        HelpAction helpAction = HelpAction.getInstance();
        helpAction.getHelpBroker().enableHelpOnButton((Component)view.getHelpButton(), helpAction.getPerformanceStatistics(), helpAction.getHelpSet());
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getPerformanceStatistics();
    }

    public PSNodesDetailsController getNodesController() {
        return this.nodeController;
    }

    public PSPortsDetailsController getPortsController() {
        return this.portController;
    }

    public void updateStatistics(DevicesStatistics dgStats) {
        long totalPorts = dgStats.getNumAtivePorts();
        this.portController.setDeviceTypes(totalPorts, dgStats.getPortTypesDist());
        this.portController.setFlowType(dgStats.getInternalPorts(), dgStats.getExternalPorts());
        int totalNodes = dgStats.getNumNodes();
        this.nodeController.setTypes(totalNodes, dgStats.getOtherPorts(), dgStats.getNodeTypesDist());
    }

    public String getTitle(GroupStatistics stats) {
        return STLConstants.K0007_SUBNET.getValue() + ": " + stats.getName();
    }

    @Override
    public void clear() {
        this.nodeController.clear();
        this.portController.clear();
    }

    @Override
    public ICardListener getCardListener() {
        return this;
    }
}

