/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.ui.common.BaseSectionController;
import com.intel.stl.ui.common.ChartsCard;
import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ObserverAdapter;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.ILabelListener;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.configuration.view.IPropertyListener;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.PerfDescCard;
import com.intel.stl.ui.main.PerfErrorsCard;
import com.intel.stl.ui.main.view.PerfErrorsItem;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.monitor.view.PerformanceErrorsSectionView;
import com.intel.stl.ui.performance.PortCounterGroupController;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.item.PCDataItem;
import com.intel.stl.ui.performance.item.PCErrItem;
import com.intel.stl.ui.performance.item.PCPacketItem;
import com.intel.stl.ui.performance.observer.PCDataObserver;
import com.intel.stl.ui.performance.observer.PCErrObserver;
import com.intel.stl.ui.performance.observer.PCPacketObserver;
import com.intel.stl.ui.performance.observer.VFPCDataObserver;
import com.intel.stl.ui.performance.observer.VFPCErrObserver;
import com.intel.stl.ui.performance.observer.VFPCPacketObserver;
import com.intel.stl.ui.performance.provider.DataProviderName;
import com.intel.stl.ui.performance.provider.PortCounterFieldProvider;
import com.intel.stl.ui.performance.provider.VFPortCounterFieldProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import net.engio.mbassy.bus.MBassador;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceErrorsSection
extends BaseSectionController<ISectionListener, PerformanceErrorsSectionView>
implements IPropertyListener,
ILabelListener {
    private static final Logger log = LoggerFactory.getLogger(PerformanceErrorsSection.class);
    private PerfErrorsCard errorsCard;
    private final ChartsCard chartCard;
    private PerfDescCard descCard;
    PCErrItem errItem;
    PCDataItem dataItem;
    PCPacketItem packetItem;
    private final PortCounterGroupController groupController;
    private final LinkedHashMap<String, PerfErrorsItem> errorMap = new LinkedHashMap();
    private final PropertyVizStyle style = new PropertyVizStyle();
    private HelpAction helpAction;
    private String oldSelectedLabel;

    public PerformanceErrorsSection(PerformanceErrorsSectionView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        view.setStyleListener(this);
        this.initErrorsCard();
        this.createItems();
        this.groupController = new PortCounterGroupController(eventBus, STLConstants.K0200_PERFORMANCE.getValue(), this.errItem, this.dataItem, this.packetItem, HistoryType.values());
        this.chartCard = this.groupController.getPortCounterChartCard();
        if (view.getErrorsCardView() != null) {
            view.getErrorsCardView().setLabelListener(this);
        }
        if (this.chartCard != null) {
            view.installChartView((ChartsView)this.chartCard.getView());
        }
        view.invalidate();
        this.groupController.setSleepMode(false);
    }

    private void createItems() {
        PortCounterFieldProvider provider = new PortCounterFieldProvider();
        VFPortCounterFieldProvider vfProvider = new VFPortCounterFieldProvider();
        this.errItem = new PCErrItem();
        PCErrObserver errObserver = new PCErrObserver(this.errItem);
        VFPCErrObserver errVfObserver = new VFPCErrObserver(this.errItem);
        this.errItem.registerDataProvider(DataProviderName.PORT, provider, errObserver);
        this.errItem.registerDataProvider(DataProviderName.VF_PORT, vfProvider, errVfObserver);
        this.dataItem = new PCDataItem();
        PCDataObserver dataObserver = new PCDataObserver(this.dataItem);
        VFPCDataObserver vfDataObserver = new VFPCDataObserver(this.dataItem);
        this.dataItem.registerDataProvider(DataProviderName.PORT, provider, dataObserver);
        this.dataItem.registerDataProvider(DataProviderName.VF_PORT, vfProvider, vfDataObserver);
        this.packetItem = new PCPacketItem();
        PCPacketObserver packetObserver = new PCPacketObserver(this.packetItem);
        VFPCPacketObserver vfPacketObserver = new VFPCPacketObserver(this.packetItem);
        this.packetItem.registerDataProvider(DataProviderName.PORT, provider, packetObserver);
        this.packetItem.registerDataProvider(DataProviderName.VF_PORT, vfProvider, vfPacketObserver);
    }

    public void setPinID(PinDescription.PinID pinID) {
        this.groupController.setPinID(pinID);
    }

    @Override
    public String getHelpID() {
        this.helpAction = HelpAction.getInstance();
        return this.helpAction.getCounters();
    }

    private void initErrorsCard() {
        this.initErrItemMap();
        this.errorsCard = new PerfErrorsCard(((PerformanceErrorsSectionView)this.view).getErrorsCardView(), (MBassador<IAppEvent>)this.eventBus, this.errorMap.values());
        this.errorsCard.setHelpID(this.helpAction.getPortCounters());
        this.descCard = new PerfDescCard(((PerformanceErrorsSectionView)this.view).getDescCardView(), (MBassador<IAppEvent>)this.eventBus);
    }

    private void initErrItemMap() {
        if (this.helpAction != null) {
            this.errorMap.put(STLConstants.K0746_RECEIVE.getValue(), new PerfErrorsItem(STLConstants.K0746_RECEIVE.getValue(), -1L, true));
            this.errorMap.put(STLConstants.K0730_RX_CUMULATIVE_DATA.getValue(), new PerfErrorsItem(STLConstants.K0730_RX_CUMULATIVE_DATA.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getRcvData(), false));
            this.errorMap.put(STLConstants.K0728_RX_CUMULATIVE_PACKETS.getValue(), new PerfErrorsItem(STLConstants.K0728_RX_CUMULATIVE_PACKETS.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getRcvPkts(), false));
            this.errorMap.put(STLConstants.K0834_RX_MULTICAST_PACKETS.getValue(), new PerfErrorsItem(STLConstants.K0834_RX_MULTICAST_PACKETS.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getMulticastRcvPkts(), false));
            this.errorMap.put(STLConstants.K0519_RX_ERRORS.getValue(), new PerfErrorsItem(STLConstants.K0519_RX_ERRORS.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getRcvErrs(), false));
            this.errorMap.put(STLConstants.K0522_RX_PORT_CONSTRAINT.getValue(), new PerfErrorsItem(STLConstants.K0522_RX_PORT_CONSTRAINT.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getRcvConstraintErrs(), true));
            this.errorMap.put(STLConstants.K0717_REC_SW_REL_ERR.getValue(), new PerfErrorsItem(STLConstants.K0717_REC_SW_REL_ERR.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getRcvSwRelErrs(), false));
            this.errorMap.put(STLConstants.K0520_RX_REMOTE_PHY_ERRORS.getValue(), new PerfErrorsItem(STLConstants.K0520_RX_REMOTE_PHY_ERRORS.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getRcvRemPhyErrs(), false));
            this.errorMap.put(STLConstants.K0837_RX_FECN.getValue(), new PerfErrorsItem(STLConstants.K0837_RX_FECN.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getRcvFECN(), true));
            this.errorMap.put(STLConstants.K0838_RX_BECN.getValue(), new PerfErrorsItem(STLConstants.K0838_RX_BECN.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getRcvBECN(), false));
            this.errorMap.put(STLConstants.K0842_RX_BUBBLE.getValue(), new PerfErrorsItem(STLConstants.K0842_RX_BUBBLE.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getRcvBubble(), true));
            this.errorMap.put(STLConstants.K0745_TRANSMIT.getValue(), new PerfErrorsItem(STLConstants.K0745_TRANSMIT.getValue(), -1L, true));
            this.errorMap.put(STLConstants.K0732_TX_CUMULATIVE_DATA.getValue(), new PerfErrorsItem(STLConstants.K0732_TX_CUMULATIVE_DATA.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getXmitData(), false));
            this.errorMap.put(STLConstants.K0734_TX_CUMULATIVE_PACKETS.getValue(), new PerfErrorsItem(STLConstants.K0734_TX_CUMULATIVE_PACKETS.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getXmitPkts(), false));
            this.errorMap.put(STLConstants.K0833_TX_MULTICAST_PACKETS.getValue(), new PerfErrorsItem(STLConstants.K0833_TX_MULTICAST_PACKETS.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getMulticastXmitPkts(), false));
            this.errorMap.put(STLConstants.K0714_TRAN_DISCARDS.getValue(), new PerfErrorsItem(STLConstants.K0714_TRAN_DISCARDS.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getXmitDiscards(), false));
            this.errorMap.put(STLConstants.K0521_TX_PORT_CONSTRAINT.getValue(), new PerfErrorsItem(STLConstants.K0521_TX_PORT_CONSTRAINT.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getXmitConstraintErrs(), false));
            this.errorMap.put(STLConstants.K0836_TX_WAIT.getValue(), new PerfErrorsItem(STLConstants.K0836_TX_WAIT.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getXmitWait(), false));
            this.errorMap.put(STLConstants.K0839_TX_TIME_CONG.getValue(), new PerfErrorsItem(STLConstants.K0839_TX_TIME_CONG.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getXmitTimeCong(), false));
            this.errorMap.put(STLConstants.K0840_TX_WASTED_BW.getValue(), new PerfErrorsItem(STLConstants.K0840_TX_WASTED_BW.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getXmitWastedBw(), false));
            this.errorMap.put(STLConstants.K0841_TX_WAIT_DATA.getValue(), new PerfErrorsItem(STLConstants.K0841_TX_WAIT_DATA.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getXmitWaitData(), false));
            this.errorMap.put(STLConstants.K0715_OTHER_COUNTERS.getValue(), new PerfErrorsItem(STLConstants.K0715_OTHER_COUNTERS.getValue(), -1L, true));
            this.errorMap.put(STLConstants.K0718_LOCAL_LINK_INTEG_ERR.getValue(), new PerfErrorsItem(STLConstants.K0718_LOCAL_LINK_INTEG_ERR.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getLocalLinkIntegErrs(), false));
            this.errorMap.put(STLConstants.K0720_FM_CONFIG_ERR.getValue(), new PerfErrorsItem(STLConstants.K0720_FM_CONFIG_ERR.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getFMConfigErrs(), false));
            this.errorMap.put(STLConstants.K0719_EXCESS_BUFF_OVERRUNS.getValue(), new PerfErrorsItem(STLConstants.K0719_EXCESS_BUFF_OVERRUNS.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getExcBufferOver(), true));
            this.errorMap.put(STLConstants.K0835_SW_PORT_CONG.getValue(), new PerfErrorsItem(STLConstants.K0835_SW_PORT_CONG.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getSwPortCong(), false));
            this.errorMap.put(STLConstants.K0843_MARK_FECN.getValue(), new PerfErrorsItem(STLConstants.K0843_MARK_FECN.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getMarkFECN(), true));
            this.errorMap.put(STLConstants.K0517_LINK_RECOVERIES.getValue(), new PerfErrorsItem(STLConstants.K0517_LINK_RECOVERIES.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getLinkErrRec(), false));
            this.errorMap.put(STLConstants.K0518_LINK_DOWN.getValue(), new PerfErrorsItem(STLConstants.K0518_LINK_DOWN.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getLinkDown(), false));
            this.errorMap.put(STLConstants.K0716_UNCORR_ERR.getValue(), new PerfErrorsItem(STLConstants.K0716_UNCORR_ERR.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getUncorrErrs(), false));
            this.errorMap.put(STLConstants.K2068_LINK_QUALITY.getValue(), new PerfErrorsItem(STLConstants.K2068_LINK_QUALITY.getValue(), STLConstants.K0039_NOT_AVAILABLE.getValue(), this.helpAction.getLinkQual(), false));
        }
    }

    private void insertIntoErrItemMap(PortCountersBean bean) {
        this.setConvertedValStr(this.errorMap, STLConstants.K0730_RX_CUMULATIVE_DATA.getValue(), bean.getPortRcvData());
        this.setValStr(this.errorMap, STLConstants.K0728_RX_CUMULATIVE_PACKETS.getValue(), bean.getPortRcvPkts());
        this.setValStr(this.errorMap, STLConstants.K0834_RX_MULTICAST_PACKETS.getValue(), bean.getPortMulticastRcvPkts());
        this.setValStr(this.errorMap, STLConstants.K0519_RX_ERRORS.getValue(), bean.getPortRcvErrors());
        this.setValStr(this.errorMap, STLConstants.K0522_RX_PORT_CONSTRAINT.getValue(), bean.getPortRcvConstraintErrors());
        this.setValStr(this.errorMap, STLConstants.K0717_REC_SW_REL_ERR.getValue(), bean.getPortRcvSwitchRelayErrors());
        this.setValStr(this.errorMap, STLConstants.K0520_RX_REMOTE_PHY_ERRORS.getValue(), bean.getPortRcvRemotePhysicalErrors());
        this.setValStr(this.errorMap, STLConstants.K0837_RX_FECN.getValue(), bean.getPortRcvFECN());
        this.setValStr(this.errorMap, STLConstants.K0838_RX_BECN.getValue(), bean.getPortRcvBECN());
        this.setValStr(this.errorMap, STLConstants.K0842_RX_BUBBLE.getValue(), bean.getPortRcvBubble());
        this.setConvertedValStr(this.errorMap, STLConstants.K0732_TX_CUMULATIVE_DATA.getValue(), bean.getPortXmitData());
        this.setValStr(this.errorMap, STLConstants.K0734_TX_CUMULATIVE_PACKETS.getValue(), bean.getPortXmitPkts());
        this.setValStr(this.errorMap, STLConstants.K0833_TX_MULTICAST_PACKETS.getValue(), bean.getPortMulticastXmitPkts());
        this.setValStr(this.errorMap, STLConstants.K0714_TRAN_DISCARDS.getValue(), bean.getPortXmitDiscards());
        this.setValStr(this.errorMap, STLConstants.K0521_TX_PORT_CONSTRAINT.getValue(), bean.getPortXmitConstraintErrors());
        this.setValStr(this.errorMap, STLConstants.K0836_TX_WAIT.getValue(), bean.getPortXmitWait());
        this.setValStr(this.errorMap, STLConstants.K0839_TX_TIME_CONG.getValue(), bean.getPortXmitTimeCong());
        this.setValStr(this.errorMap, STLConstants.K0840_TX_WASTED_BW.getValue(), bean.getPortXmitWastedBW());
        this.setValStr(this.errorMap, STLConstants.K0841_TX_WAIT_DATA.getValue(), bean.getPortXmitWaitData());
        this.setValStr(this.errorMap, STLConstants.K0718_LOCAL_LINK_INTEG_ERR.getValue(), bean.getLocalLinkIntegrityErrors());
        this.setValStr(this.errorMap, STLConstants.K0720_FM_CONFIG_ERR.getValue(), bean.getFmConfigErrors());
        this.setValStr(this.errorMap, STLConstants.K0719_EXCESS_BUFF_OVERRUNS.getValue(), bean.getExcessiveBufferOverruns());
        this.setValStr(this.errorMap, STLConstants.K0835_SW_PORT_CONG.getValue(), bean.getSwPortCongestion());
        this.setValStr(this.errorMap, STLConstants.K0843_MARK_FECN.getValue(), bean.getPortMarkFECN());
        this.setValStr(this.errorMap, STLConstants.K0517_LINK_RECOVERIES.getValue(), bean.getLinkErrorRecovery());
        this.setValStr(this.errorMap, STLConstants.K0518_LINK_DOWN.getValue(), bean.getLinkDowned());
        this.setValStr(this.errorMap, STLConstants.K0716_UNCORR_ERR.getValue(), bean.getUncorrectableErrors());
        this.setValStr(this.errorMap, STLConstants.K2068_LINK_QUALITY.getValue(), bean.getLinkQualityIndicator());
    }

    private void insertIntoErrItemMap(VFPortCountersBean bean) {
        this.setConvertedValStr(this.errorMap, STLConstants.K0730_RX_CUMULATIVE_DATA.getValue(), bean.getPortVFRcvData());
        this.setValStr(this.errorMap, STLConstants.K0728_RX_CUMULATIVE_PACKETS.getValue(), bean.getPortVFRcvPkts());
        this.setValStr(this.errorMap, STLConstants.K0837_RX_FECN.getValue(), bean.getPortVFRcvFECN());
        this.setValStr(this.errorMap, STLConstants.K0838_RX_BECN.getValue(), bean.getPortVFRcvBECN());
        this.setValStr(this.errorMap, STLConstants.K0842_RX_BUBBLE.getValue(), bean.getPortVFRcvBubble());
        this.setConvertedValStr(this.errorMap, STLConstants.K0732_TX_CUMULATIVE_DATA.getValue(), bean.getPortVFXmitData());
        this.setValStr(this.errorMap, STLConstants.K0734_TX_CUMULATIVE_PACKETS.getValue(), bean.getPortVFXmitPkts());
        this.setValStr(this.errorMap, STLConstants.K0714_TRAN_DISCARDS.getValue(), bean.getPortVFXmitDiscards());
        this.setValStr(this.errorMap, STLConstants.K0836_TX_WAIT.getValue(), bean.getPortVFXmitWait());
        this.setValStr(this.errorMap, STLConstants.K0839_TX_TIME_CONG.getValue(), bean.getPortVFXmitTimeCong());
        this.setValStr(this.errorMap, STLConstants.K0840_TX_WASTED_BW.getValue(), bean.getPortVFXmitWastedBW());
        this.setValStr(this.errorMap, STLConstants.K0841_TX_WAIT_DATA.getValue(), bean.getPortVFXmitWaitData());
        this.setValStr(this.errorMap, STLConstants.K0835_SW_PORT_CONG.getValue(), bean.getSwPortVFCongestion());
        this.setValStr(this.errorMap, STLConstants.K0843_MARK_FECN.getValue(), bean.getPortVFMarkFECN());
    }

    protected void setValStr(LinkedHashMap<String, PerfErrorsItem> map, String key, long value) {
        PerfErrorsItem item = map.get(key);
        if (item != null) {
            item.setValStr(UIConstants.INTEGER.format(value));
        } else {
            log.warn("Couldn't find item '" + key + "'");
        }
    }

    private void setConvertedValStr(LinkedHashMap<String, PerfErrorsItem> map, String key, long value) {
        PerfErrorsItem item = map.get(key);
        if (item != null) {
            item.setValStr(UIConstants.INTEGER.format(value) + " " + STLConstants.K0748_FLITS.getValue());
        } else {
            log.warn("Couldn't find item '" + key + "'");
        }
    }

    @Override
    public ICardController<?>[] getCards() {
        return new ICardController[]{this.errorsCard, this.descCard};
    }

    public void updateErrors(PortCountersBean portCountersBean) {
        if (portCountersBean.isDelta()) {
            throw new IllegalArgumentException("We do not support delta style PortCounters");
        }
        this.insertIntoErrItemMap(portCountersBean);
        this.errorsCard.updateErrorsItems(this.errorMap.values());
    }

    public void updateErrors(VFPortCountersBean result) {
        if (result.isDelta()) {
            throw new IllegalArgumentException("We do not support delta style PortCounters");
        }
        this.insertIntoErrItemMap(result);
        this.errorsCard.updateErrorsItems(this.errorMap.values());
    }

    @Override
    protected ISectionListener getSectionListener() {
        return this;
    }

    @Override
    public void clear() {
        this.initErrItemMap();
        this.errorsCard.updateErrorsItems(this.errorMap.values());
    }

    @Override
    public void onShowBorder(boolean isSelected) {
        this.style.setShowBorder(isSelected);
        this.setStyle(this.style);
    }

    @Override
    public void onShowAlternation(boolean isSelected) {
        this.style.setAlternateRows(isSelected);
        this.setStyle(this.style);
    }

    private void setStyle(PropertyVizStyle style) {
        this.errorsCard.setStyle(style);
    }

    @Override
    public void onDisplayChanged(Map<String, Boolean> newSelections) {
    }

    @Override
    public void onLabelClick(String fieldName, String helpID) {
        String label = fieldName.replace("*", "");
        if (!label.equals(this.oldSelectedLabel)) {
            this.descCard.onLabelClick(helpID);
            this.groupController.onFieldNameChange(label);
        }
        this.oldSelectedLabel = label;
    }

    public void setContext(Context context, IProgressObserver observer) {
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        this.groupController.setContext(context, observer);
        observer.onFinish();
    }

    public void onRefresh(IProgressObserver observer) {
        if (observer == null) {
            observer = new ObserverAdapter();
        }
        this.groupController.onRefresh(observer);
        observer.onFinish();
    }

    public void setSource(PortCounterSourceName source) {
        if (source.getVfName() != null) {
            this.groupController.setDataProvider(DataProviderName.VF_PORT);
        } else {
            this.groupController.setDataProvider(DataProviderName.PORT);
        }
        String filedName = this.oldSelectedLabel == null ? STLConstants.K0732_TX_CUMULATIVE_DATA.getValue() : this.oldSelectedLabel;
        source.setFieldName(filedName);
        this.groupController.setDataSources(new PortCounterSourceName[]{source});
        ((PerformanceErrorsSectionView)this.view).getErrorsCardView().selectLabel(filedName);
    }
}

