/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.event.GroupsSelectedEvent;
import com.intel.stl.ui.event.JumpToEvent;
import com.intel.stl.ui.event.NodeUpdateEvent;
import com.intel.stl.ui.event.NodesSelectedEvent;
import com.intel.stl.ui.event.PortUpdateEvent;
import com.intel.stl.ui.event.PortsSelectedEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.main.UndoableSelection;
import com.intel.stl.ui.monitor.TreeControllerInterface;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.TreeSelection;
import com.intel.stl.ui.monitor.TreeTypeEnum;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.FVTreeManager;
import com.intel.stl.ui.monitor.tree.FVTreeModel;
import com.intel.stl.ui.monitor.tree.InactivePortVizIndicator;
import com.intel.stl.ui.monitor.view.TreeViewInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;

public abstract class TreeController<E extends TreeViewInterface>
implements TreeControllerInterface,
TreeSelectionListener {
    protected E view;
    private final Map<TreeTypeEnum, FVTreeModel> treeModels;
    protected FVTreeModel currentTreeModel;
    protected Context mContext;
    protected FVTreeManager mTreeBuilder;
    protected final MBassador<IAppEvent> eventBus;
    protected UndoHandler undoHandler;
    protected boolean isSystemUpdate;
    private TreeSelection currentSelection;
    private final InactivePortVizIndicator treeIndicator = new InactivePortVizIndicator();

    public TreeController(E pTreeView, MBassador<IAppEvent> eventBus, FVTreeManager treeBuilder) {
        this.view = pTreeView;
        this.view.addTreeSelectionListener(this);
        this.mTreeBuilder = treeBuilder;
        this.eventBus = eventBus;
        this.treeModels = new HashMap<TreeTypeEnum, FVTreeModel>();
        eventBus.subscribe((Object)this);
    }

    public E getView() {
        return this.view;
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.mContext = context;
        this.treeIndicator.setContext(context);
        this.isSystemUpdate = true;
        this.buildTrees(observer);
        this.view.clear();
        if (context != null && context.getController() != null) {
            this.undoHandler = context.getController().getUndoHandler();
        }
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        this.isSystemUpdate = true;
        this.updateTrees(observer);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                TreeTypeEnum currentTreeType = TreeController.this.getTreeType(TreeController.this.getCurrentTreeModel());
                TreeController.this.view.setTreeSelection(currentTreeType);
            }
        });
    }

    @Override
    public void onNodeUpdate(NodeUpdateEvent evt) {
        int[] lids;
        if (evt instanceof PortUpdateEvent) {
            return;
        }
        this.isSystemUpdate = true;
        for (int lid : lids = evt.getNodeLids()) {
            this.updateTreeNode(lid);
        }
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                TreeTypeEnum currentTreeType = TreeController.this.getTreeType(TreeController.this.getCurrentTreeModel());
                TreeController.this.view.setTreeSelection(currentTreeType);
            }
        });
    }

    public void buildTrees(IProgressObserver observer) {
        IProgressObserver[] subObservers = observer.createSubObservers(4);
        this.buildTree(TreeTypeEnum.DEVICE_TYPES_TREE, subObservers[0]);
        subObservers[0].onFinish();
        this.buildTree(TreeTypeEnum.DEVICE_GROUPS_TREE, subObservers[1]);
        subObservers[1].onFinish();
        this.buildTree(TreeTypeEnum.VIRTUAL_FABRICS_TREE, subObservers[2]);
        subObservers[2].onFinish();
        subObservers[3].onFinish();
    }

    protected void buildTree(TreeTypeEnum type, IProgressObserver observer) {
        FVTreeModel oldModel = this.treeModels.get((Object)type);
        if (oldModel != null) {
            this.mTreeBuilder.removeMonitor(type, oldModel);
        }
        FVResourceNode tree = this.mTreeBuilder.buildTree(type, observer);
        if (observer.isCancelled()) {
            return;
        }
        FVTreeModel treeModel = new FVTreeModel(tree);
        treeModel.filter(this.treeIndicator);
        this.view.setTreeModel(type, treeModel);
        this.treeModels.put(type, treeModel);
        this.mTreeBuilder.addMonitor(type, treeModel);
    }

    public void updateTrees(IProgressObserver observer) {
        IProgressObserver[] subObservers = observer.createSubObservers(4);
        this.updateTree(TreeTypeEnum.DEVICE_TYPES_TREE, subObservers[0]);
        this.updateTree(TreeTypeEnum.DEVICE_GROUPS_TREE, subObservers[1]);
        this.updateTree(TreeTypeEnum.VIRTUAL_FABRICS_TREE, subObservers[2]);
        subObservers[3].onFinish();
    }

    protected void updateTree(TreeTypeEnum type, IProgressObserver observer) {
        FVTreeModel treeModel = this.treeModels.get((Object)type);
        if (treeModel != null) {
            this.mTreeBuilder.updateTree(type, observer);
            treeModel.filter(this.treeIndicator);
            this.view.setTreeModel(type, treeModel);
        }
    }

    public void updateTreeNode(int lid) {
        this.updateTreeNode(lid, TreeTypeEnum.DEVICE_TYPES_TREE);
        this.updateTreeNode(lid, TreeTypeEnum.DEVICE_GROUPS_TREE);
        this.updateTreeNode(lid, TreeTypeEnum.VIRTUAL_FABRICS_TREE);
    }

    protected void updateTreeNode(int lid, TreeTypeEnum type) {
        FVTreeModel treeModel = this.treeModels.get((Object)type);
        if (treeModel != null) {
            this.mTreeBuilder.updateTreeNode(lid, type);
            treeModel.filter(this.treeIndicator);
            this.view.setTreeModel(type, treeModel);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        JTree tree = (JTree)e.getSource();
        if (tree.getSelectionCount() == 0) {
            return;
        }
        TreeSelection oldSelection = this.currentSelection;
        this.currentTreeModel = (FVTreeModel)tree.getModel();
        if (tree.getSelectionCount() == 1) {
            Object node = tree.getLastSelectedPathComponent();
            if (node != null && node instanceof FVResourceNode) {
                this.currentSelection = new TreeSelection(this.currentTreeModel);
                this.currentSelection.addNode((FVResourceNode)node, tree.isExpanded(tree.getSelectionPath()));
                this.showNode((FVResourceNode)node);
            }
        } else {
            TreePath[] paths = tree.getSelectionPaths();
            FVResourceNode[] nodes = new FVResourceNode[paths.length];
            this.currentSelection = new TreeSelection(this.currentTreeModel);
            for (int i = 0; i < nodes.length; ++i) {
                Object node = paths[i].getLastPathComponent();
                if (node == null || !(node instanceof FVResourceNode)) continue;
                nodes[i] = (FVResourceNode)node;
                this.currentSelection.addNode(nodes[i], tree.isExpanded(paths[i]));
            }
            this.showNodes(nodes);
        }
        if (!this.isSystemUpdate && this.undoHandler != null && !this.undoHandler.isInProgress()) {
            UndoableSelection<?> undoSel = this.getUndoableSelection(oldSelection, this.currentSelection);
            this.undoHandler.addUndoAction(undoSel);
        }
        if (this.isSystemUpdate) {
            this.isSystemUpdate = false;
        }
    }

    protected abstract UndoableSelection<?> getUndoableSelection(TreeSelection var1, TreeSelection var2);

    public void showNode(TreeTypeEnum type, FVResourceNode node) {
        this.showNode(this.treeModels.get((Object)type), node, false);
    }

    public synchronized void showNode(FVTreeModel treeModel, FVResourceNode node, boolean isExpanded) {
        this.showNode(treeModel, new TreePath[]{node.getPath()}, new boolean[]{isExpanded});
    }

    public synchronized void showNode(FVTreeModel treeModel, TreePath[] paths, boolean[] isExpanded) {
        this.currentTreeModel = treeModel;
        this.view.expandAndSelectTreePath(this.currentTreeModel, paths, isExpanded);
    }

    public FVTreeModel getCurrentTreeModel() {
        if (this.currentTreeModel == null) {
            this.currentTreeModel = this.treeModels.get((Object)TreeTypeEnum.DEVICE_TYPES_TREE);
        }
        return this.currentTreeModel;
    }

    public FVTreeModel getTreeModel(TreeTypeEnum type) {
        return this.treeModels.get((Object)type);
    }

    public TreeTypeEnum getTreeType(FVTreeModel model) {
        if (model == null) {
            return TreeTypeEnum.DEVICE_TYPES_TREE;
        }
        for (TreeTypeEnum type : this.treeModels.keySet()) {
            if (this.treeModels.get((Object)type) != model) continue;
            return type;
        }
        throw new RuntimeException("Unknown FVTreeModel " + model);
    }

    protected abstract void showNode(FVResourceNode var1);

    protected abstract void showNodes(FVResourceNode[] var1);

    protected abstract FVResourceNode getCurrentNode();

    @Handler
    protected void onGroupSelected(GroupsSelectedEvent event) {
        if (!this.acceptEvent(event)) {
            return;
        }
        FVTreeModel deviceTypesTreeModel = this.getCurrentTreeModel();
        if (deviceTypesTreeModel == null) {
            return;
        }
        TreePath[] paths = new TreePath[event.getNumGroups()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = deviceTypesTreeModel.getTreePath(event.getName(i), event.getType(i));
        }
        this.isSystemUpdate = true;
        this.view.expandAndSelectTreePath(deviceTypesTreeModel, paths, new boolean[paths.length]);
    }

    @Handler
    protected void onNodesSelected(NodesSelectedEvent event) {
        if (!this.acceptEvent(event)) {
            return;
        }
        FVTreeModel deviceTypesTreeModel = this.getCurrentTreeModel();
        if (deviceTypesTreeModel == null) {
            return;
        }
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (int i = 0; i < event.numberOfNodes(); ++i) {
            NodeType nodeType = event.getType(i);
            TreeNodeType treeNodeType = null;
            boolean nodeTypeValid = true;
            switch (nodeType) {
                case HFI: {
                    treeNodeType = TreeNodeType.HFI;
                    break;
                }
                case SWITCH: {
                    treeNodeType = TreeNodeType.SWITCH;
                    break;
                }
                case ROUTER: {
                    treeNodeType = TreeNodeType.ROUTER;
                    break;
                }
                default: {
                    nodeTypeValid = false;
                }
            }
            if (!nodeTypeValid) continue;
            TreePath path = deviceTypesTreeModel.getTreePath(event.getLid(i), treeNodeType, this.getCurrentNode());
            paths.add(path);
        }
        if (!paths.isEmpty()) {
            this.isSystemUpdate = true;
            this.view.expandAndSelectTreePath(deviceTypesTreeModel, paths.toArray(new TreePath[0]), new boolean[paths.size()]);
        }
    }

    @Handler
    protected void onPortsSelected(PortsSelectedEvent event) {
        if (!this.acceptEvent(event)) {
            return;
        }
        FVTreeModel deviceTypesTreeModel = this.getCurrentTreeModel();
        if (deviceTypesTreeModel == null) {
            return;
        }
        TreePath[] paths = new TreePath[event.numberOfPorts()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = deviceTypesTreeModel.getTreePathForPort(event.getLid(i), event.getPortNum(i), this.getCurrentNode());
        }
        this.isSystemUpdate = true;
        this.view.expandAndSelectTreePath(deviceTypesTreeModel, paths, new boolean[paths.length]);
    }

    public abstract String getName();

    protected boolean acceptEvent(JumpToEvent event) {
        return event.getDestination().equals(this.getName());
    }
}

