/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.monitor.tree.FVTreeModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

public class TreeSelection {
    private final FVTreeModel treeModel;
    private final List<FVResourceNode> nodes = new ArrayList<FVResourceNode>();
    private final List<Boolean> isExpanded = new ArrayList<Boolean>();

    public TreeSelection(FVTreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public void addNode(FVResourceNode node, boolean isExpanded) {
        this.nodes.add(node);
        this.isExpanded.add(isExpanded);
    }

    public FVTreeModel getTreeModel() {
        return this.treeModel;
    }

    public List<FVResourceNode> getNodes() {
        return this.nodes;
    }

    public TreePath[] getPaths() {
        TreePath[] paths = new TreePath[this.nodes.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.nodes.get(i).getPath();
        }
        return paths;
    }

    public boolean[] isExpanded() {
        boolean[] res = new boolean[this.isExpanded.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.isExpanded.get(i);
        }
        return res;
    }

    public boolean isValid() {
        if (this.treeModel == null || this.nodes.isEmpty()) {
            return false;
        }
        for (FVResourceNode node : this.nodes) {
            if (node == null) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isExpanded == null ? 0 : this.isExpanded.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        result = 31 * result + (this.treeModel == null ? 0 : this.treeModel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeSelection other = (TreeSelection)obj;
        if (this.isExpanded == null ? other.isExpanded != null : !this.isExpanded.equals(other.isExpanded)) {
            return false;
        }
        if (this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes)) {
            return false;
        }
        return !(this.treeModel == null ? other.treeModel != null : !this.treeModel.equals(other.treeModel));
    }

    public String toString() {
        return "TreeSelection [treeModel=" + this.treeModel + ", nodes=" + this.nodes + ", isExpanded=" + this.isExpanded + "]";
    }
}

