/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.api.StringUtils;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.INodeVisbilityIndicator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FVResourceNode
implements TreeNode {
    private TreeNodeType mType;
    private String mTitle;
    private Vector<FVResourceNode> mChildren = new Vector();
    private FVResourceNode mParent;
    private int id;
    private final long guid;
    private final String guidStr;

    public FVResourceNode(String pTitle, TreeNodeType pType, int id) {
        this(pTitle, pType, id, -1L);
    }

    public FVResourceNode(String pTitle, TreeNodeType pType, int id, long guid) {
        this.mTitle = pTitle;
        this.mType = pType;
        this.id = id;
        this.guid = guid;
        this.guidStr = StringUtils.longHexString(guid);
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public long getGuid() {
        return this.guid;
    }

    public String getGuidStr() {
        return this.guidStr;
    }

    public void addChild(FVResourceNode child) {
        this.mChildren.add(child);
        child.setParent(this);
    }

    public void addChild(int index, FVResourceNode child) {
        this.mChildren.add(index, child);
        child.setParent(this);
    }

    public FVResourceNode removeChild(int index) {
        FVResourceNode node = this.mChildren.remove(index);
        if (node != null) {
            node.setParent(null);
        }
        return node;
    }

    public void setParent(FVResourceNode pParent) {
        this.mParent = pParent;
    }

    @Override
    public FVResourceNode getChildAt(int pChildIndex) {
        return this.mChildren.elementAt(pChildIndex);
    }

    @Override
    public int getChildCount() {
        return this.mChildren.size();
    }

    @Override
    public FVResourceNode getParent() {
        return this.mParent;
    }

    public FVResourceNode getRoot() {
        FVResourceNode res = this;
        while (res.getParent() != null) {
            res = res.getParent();
        }
        return res;
    }

    @Override
    public int getIndex(TreeNode pNode) {
        return this.mChildren.indexOf(pNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.mChildren.size() == 0;
    }

    public boolean isTypeMatched(TreeNodeType type) {
        if (this.mType == type) {
            return true;
        }
        return type == TreeNodeType.NODE && (this.mType == TreeNodeType.HFI || this.mType == TreeNodeType.SWITCH);
    }

    public boolean isNode() {
        return this.mType == TreeNodeType.HFI || this.mType == TreeNodeType.SWITCH;
    }

    public boolean isPort() {
        return this.mType == TreeNodeType.ACTIVE_PORT || this.mType == TreeNodeType.INACTIVE_PORT;
    }

    public Enumeration<FVResourceNode> children() {
        return this.mChildren.elements();
    }

    public Vector<FVResourceNode> getChildren() {
        return this.mChildren;
    }

    public TreePath getPath() {
        ArrayList<FVResourceNode> path = new ArrayList<FVResourceNode>();
        FVResourceNode tmp = this;
        path.add(tmp);
        while ((tmp = tmp.getParent()) != null) {
            path.add(0, tmp);
        }
        return new TreePath(path.toArray(new FVResourceNode[0]));
    }

    public String toString() {
        return this.mTitle;
    }

    public String getName() {
        return this.mTitle;
    }

    public TreeNodeType getType() {
        return this.mType;
    }

    public void setType(TreeNodeType pType) {
        this.mType = pType;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String mTitle) {
        this.mTitle = mTitle;
    }

    public FVResourceNode copy() {
        FVResourceNode res = null;
        res = this.isNode() ? new FVResourceNode(this.mTitle, this.mType, this.id, this.guid) : new FVResourceNode(this.mTitle, this.mType, this.id);
        res.mParent = this.mParent;
        res.mChildren = new Vector();
        for (FVResourceNode child : this.mChildren) {
            res.addChild(child.copy());
        }
        return res;
    }

    public FVResourceNode filter(INodeVisbilityIndicator indicator) {
        FVResourceNode res = null;
        res = this.isNode() ? new FVResourceNode(this.mTitle, this.mType, this.id, this.guid) : new FVResourceNode(this.mTitle, this.mType, this.id);
        res.mParent = this.mParent;
        res.mChildren = new Vector();
        for (int i = 0; i < this.mChildren.size(); ++i) {
            FVResourceNode child = this.mChildren.get(i);
            if (!indicator.isVisible(child)) continue;
            res.addChild(child.filter(indicator));
        }
        return res;
    }

    public void dump(PrintStream out, String prefix) {
        out.println(prefix + this.mTitle + " " + (Object)((Object)this.mType) + "[" + this.id + ":" + this.guid + "]");
        for (FVResourceNode child : this.mChildren) {
            child.dump(out, prefix + "  ");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.guid ^ this.guid >>> 32);
        result = 31 * result + (this.mTitle == null ? 0 : this.mTitle.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FVResourceNode)) {
            return false;
        }
        FVResourceNode other = (FVResourceNode)obj;
        if (this.guid != other.guid) {
            return false;
        }
        return !(this.mTitle == null ? other.mTitle != null : !this.mTitle.equals(other.mTitle));
    }

    public boolean hasSamePath(FVResourceNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        TreePath path = this.getPath();
        TreePath anotherPath = anotherNode.getPath();
        return path.equals(anotherPath);
    }
}

