/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.tree;

import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.NameSorter;
import com.intel.stl.ui.model.NodeTypeViz;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.util.Comparator;
import java.util.Map;

public class TreeNodeFactory {
    public static FVResourceNode createTypeNode(TreeNodeType type) {
        if (type == TreeNodeType.HCA_GROUP) {
            return new FVResourceNode(NodeTypeViz.HFI.getPluralName(), TreeNodeType.HCA_GROUP, TreeNodeType.HCA_GROUP.ordinal());
        }
        if (type == TreeNodeType.SWITCH_GROUP) {
            return new FVResourceNode(NodeTypeViz.SWITCH.getPluralName(), TreeNodeType.SWITCH_GROUP, TreeNodeType.SWITCH_GROUP.ordinal());
        }
        if (type == TreeNodeType.ROUTER_GROUP) {
            return new FVResourceNode(NodeTypeViz.ROUTER.getName(), TreeNodeType.ROUTER_GROUP, TreeNodeType.ROUTER_GROUP.ordinal());
        }
        throw new IllegalArgumentException("Unsupported Device Type " + (Object)((Object)type));
    }

    public static FVResourceNode createGroupNode(String groupName, int id) {
        return new FVResourceNode(groupName, TreeNodeType.DEVICE_GROUP, id);
    }

    public static FVResourceNode createVfNode(String groupName, int id) {
        return new FVResourceNode(groupName, TreeNodeType.VIRTUAL_FABRIC, id);
    }

    public static FVResourceNode createNode(NodeRecordBean bean) {
        NodeType type = bean.getNodeType();
        if (type == NodeType.HFI) {
            return new FVResourceNode(bean.getNodeDesc(), TreeNodeType.HFI, bean.getLid(), bean.getNodeInfo().getNodeGUID());
        }
        if (type == NodeType.SWITCH) {
            return new FVResourceNode(bean.getNodeDesc(), TreeNodeType.SWITCH, bean.getLid(), bean.getNodeInfo().getNodeGUID());
        }
        if (type == NodeType.ROUTER) {
            return new FVResourceNode(bean.getNodeDesc(), TreeNodeType.ROUTER, bean.getLid(), bean.getNodeInfo().getNodeGUID());
        }
        throw new RuntimeException("Unknown node type " + (Object)((Object)type));
    }

    public static Comparator<FVResourceNode> getTypeNodeComparator() {
        return new Comparator<FVResourceNode>(){

            @Override
            public int compare(FVResourceNode node1, FVResourceNode node2) {
                TreeNodeType type1 = node1.getType();
                TreeNodeType type2 = node2.getType();
                return TreeNodeFactory.comapreTreeNodeType(type1, type2);
            }
        };
    }

    public static int comapreTreeNodeType(TreeNodeType type1, TreeNodeType type2) {
        int o2;
        int o1 = type1.ordinal();
        return o1 > (o2 = type2.ordinal()) ? 1 : (o1 < o2 ? -1 : 0);
    }

    public static Comparator<FVResourceNode> getGroupNodeComparator(final Map<String, Integer> groupIndices) {
        return new Comparator<FVResourceNode>(){

            @Override
            public int compare(FVResourceNode node1, FVResourceNode node2) {
                return TreeNodeFactory.compareNameByIndex(node1.getName(), node2.getName(), groupIndices);
            }
        };
    }

    public static Comparator<FVResourceNode> getVfNodeComparator(final Map<String, Integer> vfIndices) {
        return new Comparator<FVResourceNode>(){

            @Override
            public int compare(FVResourceNode node1, FVResourceNode node2) {
                return TreeNodeFactory.compareNameByIndex(node1.getName(), node2.getName(), vfIndices);
            }
        };
    }

    public static int compareNameByIndex(String name1, String name2, Map<String, Integer> nameIndices) {
        Integer o1 = nameIndices.get(name1);
        Integer o2 = nameIndices.get(name2);
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1 > o2 ? 1 : (o1 < o2 ? -1 : 0);
    }

    public static Comparator<FVResourceNode> getNodeComparator() {
        return new Comparator<FVResourceNode>(){

            @Override
            public int compare(FVResourceNode o1, FVResourceNode o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return TreeNodeFactory.comapreNodeName(o1.getTitle(), o2.getTitle());
            }
        };
    }

    public static int comapreNodeName(String name1, String name2) {
        return NameSorter.instance().compare(name1, name2);
    }

    public static TreeNodeType getTreeNodeType(NodeType type) {
        if (type == NodeType.HFI) {
            return TreeNodeType.HCA_GROUP;
        }
        if (type == NodeType.SWITCH) {
            return TreeNodeType.SWITCH_GROUP;
        }
        if (type == NodeType.ROUTER) {
            return TreeNodeType.ROUTER_GROUP;
        }
        throw new IllegalArgumentException("Unsupported NodeType " + (Object)((Object)type));
    }
}

