/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.api.configuration.ResourceCategory;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.model.ConnectivityTableColumns;
import com.intel.stl.ui.model.ConnectivityTableModel;
import com.intel.stl.ui.model.DevicePropertyGroup;
import com.intel.stl.ui.model.PropertySet;
import com.intel.stl.ui.monitor.ICableInfoListener;
import com.intel.stl.ui.monitor.view.CableInfoPopup;
import com.intel.stl.ui.monitor.view.ConnectivitySubpageView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CableInfoPopupView {
    private static final Logger log = LoggerFactory.getLogger(CableInfoPopupView.class);
    protected ICableInfoListener cableInfoListener;
    private final CableInfoPopup popupComp;
    private final PopupFactory popupFactory = PopupFactory.getSharedInstance();
    private Popup popup;
    private JLabel lastFocusedCell;
    private MouseEvent mouseEvent;
    private final ConnectivitySubpageView view;

    public CableInfoPopupView(ConnectivitySubpageView view) {
        this.popupComp = new CableInfoPopup();
        this.view = view;
    }

    public void onCableInfoSelection(JXTable table, int row, int col, ConnectivityTableModel model, MouseEvent e) {
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CableInfoPopupView.this.popupComp.hidePopup();
            }
        };
        if (this.lastFocusedCell != null) {
            this.lastFocusedCell.removeFocusListener(focusListener);
        }
        JLabel cell = (JLabel)((Object)table.getCellRenderer(row, col));
        cell.addFocusListener(focusListener);
        long portGuid = Long.decode((String)model.getValueAt(row, ConnectivityTableColumns.NODE_GUID.getId()));
        String value = (String)model.getValueAt(row, ConnectivityTableColumns.PORT_NUMBER.getId());
        if (value != null) {
            short portNum = Short.valueOf(value.split(" ")[0]);
            NodeType nodeType = (NodeType)((Object)model.getValueAt(row, ConnectivityTableColumns.NODE_TYPE.getId()));
            int lid = (Integer)model.getValueAt(row, ConnectivityTableColumns.NODE_LID.getId());
            this.cableInfoListener.onCableInfoSelection(lid, portGuid, portNum, nodeType);
        } else {
            log.error(UILabels.STL50202_CONNECTIVITY_PORT_IS_NULL.getDescription());
        }
        this.mouseEvent = e;
        this.lastFocusedCell = cell;
    }

    public void setPopup() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                Point p = CableInfoPopupView.this.getPopupLocation(CableInfoPopupView.this.mouseEvent, CableInfoPopupView.this.popupComp);
                CableInfoPopupView.this.popup = CableInfoPopupView.this.popupFactory.getPopup(CableInfoPopupView.this.mouseEvent.getComponent(), CableInfoPopupView.this.popupComp, p.x, p.y);
                CableInfoPopupView.this.popupComp.setPopup(CableInfoPopupView.this.popup);
            }
        });
    }

    public void showPopup() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                CableInfoPopupView.this.popup.show();
            }
        });
    }

    public void updatePopup(final PropertySet<DevicePropertyGroup> model, final boolean isFinal) {
        model.getGroups().get(0).getCategory(ResourceCategory.CABLE_INFO);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                CableInfoPopupView.this.popupComp.setModel(model);
                CableInfoPopupView.this.popupComp.setPopupIcon(isFinal ? UIImages.CABLE.getImageIcon() : UIImages.RUNNING.getImageIcon(), STLConstants.K3049_CABLE_INFO.getValue());
                CableInfoPopupView.this.setPopup();
                CableInfoPopupView.this.showPopup();
            }
        });
    }

    protected Point getPopupLocation(MouseEvent e, Component comp) {
        Point p = e.getPoint();
        SwingUtilities.convertPointToScreen(p, e.getComponent());
        p.x = Math.max(0, p.x - 5);
        p.y = Math.max(0, p.y - 5);
        Dimension d = comp.getPreferredSize();
        Rectangle rec = new Rectangle(p.x, p.y, d.width, d.height);
        p = Util.adjustPoint(rec, SwingUtilities.getWindowAncestor(this.view));
        return p;
    }

    public void setCableInfoListener(ICableInfoListener cableInfoListener) {
        this.cableInfoListener = cableInfoListener;
    }
}

