/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.model.StateLongTypeViz;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PSEventsPieChart
extends JPanel {
    private static final long serialVersionUID = 7866706629944517223L;
    private DefaultPieDataset pieDataset;
    private JLabel[] stateLabels;
    private ChartPanel pieChartPanel;

    public PSEventsPieChart() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.pieDataset = new DefaultPieDataset();
        StateLongTypeViz[] states = StateLongTypeViz.values();
        for (int i = 0; i < states.length; ++i) {
            this.pieDataset.setValue((Comparable)((Object)states[i]), 0.0);
        }
        this.pieChartPanel = new ChartPanel(ComponentFactory.createPlainPieChart((PieDataset)this.pieDataset, StateLongTypeViz.colors));
        this.pieChartPanel.setPreferredSize(new Dimension(80, 8));
        this.add((Component)this.pieChartPanel);
        JPanel legendPanel = this.getLengendPanel();
        this.add((Component)legendPanel, "East");
    }

    protected JPanel getLengendPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        StateLongTypeViz[] states = StateLongTypeViz.values();
        this.stateLabels = new JLabel[states.length];
        for (int i = 0; i < states.length; ++i) {
            StateLongTypeViz state = states[i];
            gc.insets = new Insets(2, 5, 2, 2);
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            JLabel label = new JLabel(state.getName(), Util.generateImageIcon(state.getColor(), 8, new Insets(1, 1, 1, 1)), 2);
            label.setFont(UIConstants.H5_FONT);
            label.setForeground(UIConstants.INTEL_DARK_GRAY);
            panel.add((Component)label, gc);
            gc.gridwidth = 0;
            gc.weightx = 0.0;
            this.stateLabels[i] = new JLabel();
            this.stateLabels[i].setForeground(UIConstants.INTEL_DARK_GRAY);
            this.stateLabels[i].setFont(UIConstants.H5_FONT);
            panel.add((Component)this.stateLabels[i], gc);
        }
        return panel;
    }

    public void setTypeDataset(DefaultPieDataset dataset) {
        JFreeChart chart = ComponentFactory.createPlainPieChart((PieDataset)dataset, StateLongTypeViz.colors);
        this.pieChartPanel.setChart(chart);
    }

    public void setTypes(double[] values, String[] labels, String[] tooltips) {
        if (values.length != this.stateLabels.length) {
            throw new IllegalArgumentException("Incorrect array size. Expected " + this.stateLabels.length + " values, got " + values.length + " values.");
        }
        if (labels.length != this.stateLabels.length) {
            throw new IllegalArgumentException("Incorrect array size. Expected " + this.stateLabels.length + " labels, got " + labels.length + " labels.");
        }
        if (tooltips.length != this.stateLabels.length) {
            throw new IllegalArgumentException("Incorrect array size. Expected " + this.stateLabels.length + " tooltips, got " + tooltips.length + " tooltips.");
        }
        StateLongTypeViz[] states = StateLongTypeViz.values();
        for (int i = 0; i < values.length; ++i) {
            this.pieDataset.setValue((Comparable)((Object)states[i]), values[i]);
            this.stateLabels[i].setText(labels[i]);
            this.stateLabels[i].setToolTipText(tooltips[i]);
        }
    }
}

