/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.model.FlowTypeViz;
import com.intel.stl.ui.model.NodeTypeViz;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PSPortsDetailsPanel
extends JPanel {
    private static final long serialVersionUID = -8248761594760146918L;
    private final NodeTypeViz[] nodeTypes;
    private final FlowTypeViz[] flowTypes;
    private JLabel numberLabel;
    private JLabel nameLabel;
    private ChartPanel deviceTypeChartPanel;
    private JLabel[] typeNumberLabels;
    private JLabel[] typeNameLabels;
    private ChartPanel flowTypeChartPanel;
    private JLabel[] flowNumberLabels;
    private JLabel[] flowNameLabels;

    public PSPortsDetailsPanel(NodeTypeViz[] nodeTypes, FlowTypeViz[] flowTypes) {
        this.nodeTypes = nodeTypes;
        this.flowTypes = flowTypes;
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.setBorder(BorderFactory.createTitledBorder((Border)null));
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.gridwidth = 0;
        JPanel titlePanel = this.createTitlePanel();
        this.add((Component)titlePanel, gc);
        gc.gridwidth = 1;
        JPanel deviceTypePanel = this.createDeviceTypePanel();
        this.add((Component)deviceTypePanel, gc);
        gc.gridwidth = 0;
        JPanel flowTypePanel = this.createFlowTypePanel();
        this.add((Component)flowTypePanel, gc);
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add(Box.createGlue(), gc);
    }

    protected JPanel createTitlePanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 1));
        panel.setOpaque(false);
        this.numberLabel = ComponentFactory.getH1Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 0);
        this.numberLabel.setHorizontalAlignment(4);
        panel.add((Component)this.numberLabel, "Center");
        this.nameLabel = ComponentFactory.getH3Label("", 0);
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setVerticalAlignment(3);
        panel.add((Component)this.nameLabel, "East");
        return panel;
    }

    protected JPanel createDeviceTypePanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        GridBagLayout gridBag = new GridBagLayout();
        panel.setLayout(gridBag);
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(8, 2, 2, 2);
        gc.weighty = 0.0;
        gc.weightx = 1.0;
        gc.gridwidth = 0;
        gc.gridheight = 1;
        this.deviceTypeChartPanel = new ChartPanel(null);
        this.deviceTypeChartPanel.setPreferredSize(new Dimension(80, 60));
        panel.add((Component)this.deviceTypeChartPanel, gc);
        this.typeNumberLabels = new JLabel[this.nodeTypes.length];
        this.typeNameLabels = new JLabel[this.nodeTypes.length];
        gc.fill = 1;
        gc.insets = new Insets(2, 2, 2, 2);
        for (int i = 0; i < this.nodeTypes.length; ++i) {
            gc.weightx = 1.0;
            gc.gridwidth = 1;
            this.typeNumberLabels[i] = this.createNumberLabel();
            panel.add((Component)this.typeNumberLabels[i], gc);
            gc.weightx = 0.0;
            gc.gridwidth = 0;
            this.typeNameLabels[i] = this.createNameLabel(this.nodeTypes[i].getName());
            panel.add((Component)this.typeNameLabels[i], gc);
        }
        return panel;
    }

    protected JPanel createFlowTypePanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        GridBagLayout gridBag = new GridBagLayout();
        panel.setLayout(gridBag);
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(8, 2, 2, 2);
        gc.weighty = 0.0;
        gc.weightx = 1.0;
        gc.gridwidth = 0;
        gc.gridheight = 1;
        this.flowTypeChartPanel = new ChartPanel(null);
        this.flowTypeChartPanel.setPreferredSize(new Dimension(80, 60));
        panel.add((Component)this.flowTypeChartPanel, gc);
        this.flowNumberLabels = new JLabel[this.flowTypes.length];
        this.flowNameLabels = new JLabel[this.flowTypes.length];
        gc.fill = 1;
        gc.insets = new Insets(2, 2, 2, 2);
        for (int i = 0; i < this.flowTypes.length; ++i) {
            gc.weightx = 1.0;
            gc.gridwidth = 1;
            this.flowNumberLabels[i] = this.createNumberLabel();
            panel.add((Component)this.flowNumberLabels[i], gc);
            gc.weightx = 0.0;
            gc.gridwidth = 0;
            this.flowNameLabels[i] = this.createNameLabel(this.flowTypes[i].getName());
            panel.add((Component)this.flowNameLabels[i], gc);
        }
        return panel;
    }

    private JLabel createNumberLabel() {
        JLabel label = ComponentFactory.getH4Label(STLConstants.K0039_NOT_AVAILABLE.getValue(), 0);
        label.setHorizontalAlignment(4);
        label.setVerticalAlignment(3);
        return label;
    }

    private JLabel createNameLabel(String name) {
        JLabel label = ComponentFactory.getH5Label(name, 0);
        label.setVerticalAlignment(3);
        return label;
    }

    public NodeTypeViz[] getNodeTypes() {
        return this.nodeTypes;
    }

    public FlowTypeViz[] getFlowTypes() {
        return this.flowTypes;
    }

    @Override
    public void setName(String name) {
        this.nameLabel.setText(name);
    }

    public void setTotalNumber(String value) {
        this.numberLabel.setText(value);
    }

    public void setTypeInfo(NodeTypeViz type, String number, String label) {
        for (int i = 0; i < this.nodeTypes.length; ++i) {
            if (this.nodeTypes[i] != type) continue;
            this.typeNumberLabels[i].setText(number);
            this.typeNameLabels[i].setText(label);
            return;
        }
        throw new IllegalArgumentException("Unsupported Node Type " + (Object)((Object)type));
    }

    public void setFlowInfo(FlowTypeViz type, String number) {
        for (int i = 0; i < this.flowTypes.length; ++i) {
            if (this.flowTypes[i] != type) continue;
            this.flowNumberLabels[i].setText(number);
            return;
        }
        throw new IllegalArgumentException("Unsupported Flow Type " + (Object)((Object)type));
    }

    public void setDeviceTypeDataset(DefaultPieDataset dataset, Color[] colors) {
        JFreeChart chart = ComponentFactory.createPlainPieChart((PieDataset)dataset, colors);
        this.deviceTypeChartPanel.setChart(chart);
    }

    public void setFlowTypeDataset(DefaultPieDataset dataset, Color[] colors) {
        JFreeChart chart = ComponentFactory.createPlainPieChart((PieDataset)dataset, colors);
        this.flowTypeChartPanel.setChart(chart);
    }

    public void clear() {
        String na = STLConstants.K0039_NOT_AVAILABLE.getValue();
        this.setTotalNumber(na);
        for (JLabel label : this.typeNumberLabels) {
            label.setText(na);
        }
        for (JLabel label : this.flowNumberLabels) {
            label.setText(na);
        }
    }
}

