/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.model.FlowTypeViz;
import com.intel.stl.ui.model.NodeTypeViz;
import com.intel.stl.ui.monitor.view.PSNodesDetailsPanel;
import com.intel.stl.ui.monitor.view.PSPortsDetailsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PSStatisticsCardView
extends JCardView<ICardListener> {
    private static final long serialVersionUID = -5447526254155197323L;
    private JPanel mainPanel;
    private PSNodesDetailsPanel nodesPanel;
    private PSPortsDetailsPanel portsPanel;

    public PSStatisticsCardView(String title) {
        super(title);
    }

    @Override
    protected JPanel getMainComponent() {
        if (this.mainPanel != null) {
            return this.mainPanel;
        }
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 5));
        JPanel body = new JPanel(new GridLayout(1, 2, 15, 1));
        body.setOpaque(false);
        this.nodesPanel = new PSNodesDetailsPanel();
        body.add(this.nodesPanel);
        NodeTypeViz[] nodeTypes = new NodeTypeViz[]{NodeTypeViz.SWITCH, NodeTypeViz.HFI};
        FlowTypeViz[] flowTypes = new FlowTypeViz[]{FlowTypeViz.INTERNAL, FlowTypeViz.EXTERNAL};
        this.portsPanel = new PSPortsDetailsPanel(nodeTypes, flowTypes);
        body.add(this.portsPanel);
        this.mainPanel.add((Component)body, "Center");
        return this.mainPanel;
    }

    protected JLabel createNumberLabel(String text) {
        JLabel label = ComponentFactory.getH2Label(text, 1);
        label.setHorizontalAlignment(2);
        return label;
    }

    protected JLabel createNameLabel(String text) {
        JLabel label = ComponentFactory.getH5Label(text, 0);
        label.setHorizontalAlignment(2);
        return label;
    }

    public PSNodesDetailsPanel getNodesPanel() {
        return this.nodesPanel;
    }

    public PSPortsDetailsPanel getPortsPanel() {
        return this.portsPanel;
    }
}

