/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ButtonPopup;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.ExJXList;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.main.view.IDataTypeListener;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.model.LinkQualityViz;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class PerformanceChartsSectionView
extends JSectionView<ISectionListener> {
    private static final long serialVersionUID = 6166893610476283350L;
    private JPanel mainPanel;
    private ChartsView rxCardView;
    private ChartsView txCardView;
    private ExJXList<HistoryType> historyTypeList;
    private IDataTypeListener<HistoryType> historyTypeListener;
    private MouseListener historyTypeListSelectionListener;
    private JButton historyTypeBtn;
    private ButtonPopup historyPopupOptions;
    private HistoryType historyType;
    private HistoryType prevHistoryType;
    private String title = null;
    private ImageIcon linkQualityIcon = UIImages.LINK_QUALITY_NONE.getImageIcon();

    public PerformanceChartsSectionView(String title) {
        super(title);
        this.title = title;
        this.setHistoryTypes(HistoryType.values());
        super.setIcon(this.linkQualityIcon);
    }

    private void setHistoryTypes(HistoryType ... types) {
        if (types != null && types.length > 0) {
            JPanel ctrPanel = new JPanel(new FlowLayout(0));
            this.getTitlePanel(this.title, this.linkQualityIcon).add((Component)ctrPanel, "Center");
            this.historyTypeList = new ExJXList<HistoryType>(types);
            this.historyTypeList.setDisabledColor(UIConstants.INTEL_LIGHT_GRAY);
            this.historyType = types[0];
            this.prevHistoryType = types[0];
            this.setHistoryTypeListener(this.historyTypeListener);
            this.addHistoryTypeButton(ctrPanel);
        }
    }

    public void setHistoryTypeListener(final IDataTypeListener<HistoryType> listener) {
        this.historyTypeListener = listener;
        if (listener != null) {
            if (this.historyTypeListSelectionListener != null) {
                this.historyTypeList.removeMouseListener(this.historyTypeListSelectionListener);
            }
            this.historyTypeListSelectionListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                        HistoryType type = (HistoryType)((Object)PerformanceChartsSectionView.this.historyTypeList.getSelectedValue());
                        if (PerformanceChartsSectionView.this.prevHistoryType != type) {
                            HistoryType oldType = PerformanceChartsSectionView.this.prevHistoryType;
                            PerformanceChartsSectionView.this.prevHistoryType = type;
                            if (PerformanceChartsSectionView.this.historyTypeBtn != null) {
                                PerformanceChartsSectionView.this.historyTypeBtn.setText(PerformanceChartsSectionView.this.historyTypeList.getSelectedValue().toString());
                            }
                            listener.onDataTypeChange(oldType, type);
                        }
                        if (PerformanceChartsSectionView.this.historyPopupOptions != null && PerformanceChartsSectionView.this.historyPopupOptions.isVisible()) {
                            PerformanceChartsSectionView.this.historyPopupOptions.hide();
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            };
            this.historyTypeList.addMouseListener(this.historyTypeListSelectionListener);
            this.setHistoryType(this.historyType);
        }
    }

    public void setHistoryType(HistoryType type) {
        this.historyTypeList.setSelectedValue((Object)type, true);
        if (this.historyTypeBtn != null) {
            this.historyTypeBtn.setText(this.historyTypeList.getSelectedValue().toString());
        }
    }

    protected void addHistoryTypeButton(JPanel controlPanel) {
        JToolBar toolBar = new JToolBar();
        toolBar.setLayout(new GridBagLayout());
        toolBar.setFloatable(false);
        this.historyTypeBtn = new JButton(this.historyType.getName(), UIImages.HISTORY_ICON.getImageIcon());
        this.historyTypeBtn.setFocusable(false);
        this.historyTypeBtn.setOpaque(false);
        this.historyTypeBtn.setToolTipText(STLConstants.K1113_HISTORY_SCOPE.getValue());
        this.historyTypeBtn.setBackground(UIConstants.INTEL_BACKGROUND_GRAY);
        ActionListener usrOptionsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!PerformanceChartsSectionView.this.historyPopupOptions.isVisible()) {
                    PerformanceChartsSectionView.this.historyPopupOptions.show();
                } else {
                    PerformanceChartsSectionView.this.historyPopupOptions.hide();
                }
            }
        };
        this.historyTypeBtn.addActionListener(usrOptionsListener);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.gridx = 1;
        gc.weightx = 1.0;
        toolBar.add((Component)this.historyTypeBtn, gc);
        controlPanel.add(toolBar);
        this.historyTypeList.setLayout(new GridBagLayout());
        this.historyTypeList.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.historyPopupOptions = new ButtonPopup(this.historyTypeBtn, (JComponent)((Object)this.historyTypeList)){

            @Override
            public void onShow() {
            }

            @Override
            public void onHide() {
            }
        };
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        }
        return this.mainPanel;
    }

    public void installCardViews(ChartsView rxCardView, ChartsView txCardView) {
        this.rxCardView = rxCardView;
        this.txCardView = txCardView;
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
            this.mainPanel.setLayout(new GridLayout(1, 2, 5, 5));
            this.mainPanel.add(rxCardView);
            this.mainPanel.add(txCardView);
            this.revalidate();
        }
    }

    public ChartsView getRxCardView() {
        return this.rxCardView;
    }

    public ChartsView getTxCardView() {
        return this.txCardView;
    }

    public void setLinkQualityValue(byte linkQuality) {
        this.linkQualityIcon = (ImageIcon)LinkQualityViz.getLinkQualityIcon(linkQuality);
        this.linkQualityIcon.setDescription(LinkQualityViz.getLinkQualityDescription(linkQuality));
        super.setIcon(this.linkQualityIcon);
    }

    public void clearQualityValue() {
        this.setIcon(null);
    }
}

