/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.IChartCreator;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.IntervalXYDataset;

public class TrafficChartsCreator
implements IChartCreator {
    private static final TrafficChartsCreator instance = new TrafficChartsCreator();

    private TrafficChartsCreator() {
    }

    public static TrafficChartsCreator instance() {
        return instance;
    }

    @Override
    public JFreeChart createChart(String name, Dataset dataset) {
        if (STLConstants.K0828_REC_PACKETS_RATE.getValue().equals(name) || STLConstants.K0829_TRAN_PACKETS_RATE.getValue().equals(name)) {
            return this.getPacketsRateChart(dataset);
        }
        if (STLConstants.K0830_REC_DATA_RATE.getValue().equals(name) || STLConstants.K0831_TRAN_DATA_RATE.getValue().equals(name)) {
            return this.getDataRateChart(dataset);
        }
        return null;
    }

    protected JFreeChart getPacketsRateChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createXYTrendChart(STLConstants.K0035_TIME.getValue(), STLConstants.K0750_PPS.getValue(), (IntervalXYDataset)dataset, false);
        NumberAxis rangeAxis = (NumberAxis)chart.getXYPlot().getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRangeIncludesZero(false);
        return chart;
    }

    protected JFreeChart getDataRateChart(Dataset dataset) {
        JFreeChart chart = ComponentFactory.createXYTrendChart(STLConstants.K0035_TIME.getValue(), STLConstants.K0701_BYTE_PER_SEC.getValue(), (IntervalXYDataset)dataset, false);
        NumberAxis rangeAxis = (NumberAxis)chart.getXYPlot().getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRangeIncludesZero(false);
        return chart;
    }
}

