/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.model.GraphEdge;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.network.LayoutChange;
import com.intel.stl.ui.network.NodesVisibilityChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyTreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgesVisibilityChange
extends LayoutChange {
    private static final Logger log = LoggerFactory.getLogger(NodesVisibilityChange.class);
    private GraphEdge[] toInspect;

    public EdgesVisibilityChange(LayoutType type, TopologyTreeModel topTreeModel, GraphEdge[] toInspect) {
        super(type, topTreeModel);
        this.toInspect = toInspect;
    }

    @Override
    public boolean execute(TopGraph graph, ICancelIndicator indicator) {
        boolean hasChange = false;
        for (GraphEdge edge : this.toInspect) {
            GraphNode fromNode = (GraphNode)graph.getVertex(edge.getFromLid()).getValue();
            GraphNode toNode = (GraphNode)graph.getVertex(edge.getToLid()).getValue();
            if (fromNode.isEndNode() && toNode.isCollapsed()) {
                toNode.setCollapsed(false);
                if (hasChange) continue;
                hasChange = true;
                continue;
            }
            if (!toNode.isEndNode() || !fromNode.isCollapsed()) continue;
            fromNode.setCollapsed(false);
            if (hasChange) continue;
            hasChange = true;
        }
        if (hasChange) {
            super.execute(graph, indicator);
        }
        return hasChange;
    }
}

