/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.task.ITopologyUpdateTask;
import com.intel.stl.ui.network.view.TopologyGraphView;
import com.intel.stl.ui.network.view.TopologyView;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.CancellableCall;
import com.intel.stl.ui.publisher.SingleTaskManager;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUndoManager;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyUpdateController {
    private static final Logger log = LoggerFactory.getLogger(TopologyUpdateController.class);
    private TopGraph graph;
    private final TopologyView topView;
    private final TopologyGraphView graphView;
    private final mxUndoManager undoManager = new mxUndoManager();
    private final mxEventSource.mxIEventListener undoHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object source, mxEventObject evt) {
            TopologyUpdateController.this.undoManager.undoableEditHappened((mxUndoableEdit)evt.getProperty("edit"));
        }
    };
    private final SingleTaskManager taskMgr;
    private final AtomicInteger taskCounter = new AtomicInteger();
    private final AtomicBoolean isCancelled = new AtomicBoolean();
    private final AtomicInteger modelUpdatingCounter = new AtomicInteger();

    public TopologyUpdateController(TopGraph graph, TopologyView topView) {
        this.graph = graph;
        this.topView = topView;
        this.graphView = topView.getGraphView();
        this.taskMgr = new SingleTaskManager();
        this.taskMgr.setMayInterruptIfRunning(false);
    }

    public void setGraph(TopGraph graph) {
        this.graph = graph;
    }

    public TopGraph getGraph() {
        return this.graph;
    }

    public GraphNode getGraphNode(int lid) {
        mxCell cell = this.graph.getVertex(lid);
        if (cell != null) {
            return (GraphNode)cell.getValue();
        }
        return null;
    }

    public mxCell getVertex(int lid) {
        return this.graph.getVertex(lid);
    }

    public mxCell getEdge(int fromLid, int toLid) {
        return this.graph.getEdge(fromLid, toLid);
    }

    public boolean undo() {
        this.undoManager.undo();
        return this.undoManager.canUndo();
    }

    public boolean redo() {
        this.undoManager.redo();
        return this.undoManager.canRedo();
    }

    public void cancel() {
        this.isCancelled.set(true);
    }

    public synchronized void update(final ITopologyUpdateTask task) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (TopologyUpdateController.this.modelUpdatingCounter.getAndIncrement() == 0) {
                    TopologyUpdateController.this.graphView.showLayoutUpdating(true);
                }
            }
        });
        final int taskId = this.taskCounter.incrementAndGet();
        task.setId(taskId);
        log.info("Current topology update task " + taskId + " " + task);
        final ICancelIndicator indicator = new ICancelIndicator(){

            @Override
            public boolean isCancelled() {
                return taskId != TopologyUpdateController.this.taskCounter.get() || TopologyUpdateController.this.isCancelled.get();
            }
        };
        CancellableCall<TopGraph> caller = new CancellableCall<TopGraph>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TopGraph call(ICancelIndicator cancelIndicator) throws Exception {
                TopGraph newGraph;
                block4: {
                    if (indicator.isCancelled()) {
                        log.info("topology update task " + taskId + " cancelled");
                        return null;
                    }
                    log.info("topology update task " + taskId + " started");
                    task.preBackgroundTask(cancelIndicator, TopologyUpdateController.this.graph);
                    newGraph = null;
                    try {
                        newGraph = task.createNewGraph(indicator, TopologyUpdateController.this.graph);
                        task.applyChanges(indicator, newGraph);
                        TopGraph oldGraph = TopologyUpdateController.this.graphView.getGraph();
                        TopologyUpdateController.this.uninstallUndoManager(oldGraph);
                        TopologyUpdateController.this.installUndoManager(newGraph);
                        if (!indicator.isCancelled()) break block4;
                        log.info("topology update task " + taskId + " cancelled");
                        TopGraph topGraph = null;
                        task.postBackgroundTask(cancelIndicator, newGraph);
                        return topGraph;
                    }
                    catch (Throwable throwable) {
                        task.postBackgroundTask(cancelIndicator, newGraph);
                        throw throwable;
                    }
                }
                TopGraph topGraph = newGraph;
                task.postBackgroundTask(cancelIndicator, newGraph);
                return topGraph;
            }
        };
        caller.setCancelIndicator(indicator);
        CallbackAdapter<TopGraph> realCallback = new CallbackAdapter<TopGraph>(){

            @Override
            public void onDone(TopGraph result) {
                if (result == null || indicator.isCancelled()) {
                    return;
                }
                task.onSuccess(indicator, result);
            }

            @Override
            public void onError(Throwable ... errors) {
                task.onError(indicator, errors);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onFinally() {
                try {
                    task.onFinally(indicator);
                    if (TopologyUpdateController.this.modelUpdatingCounter.decrementAndGet() != 0) return;
                }
                catch (Throwable throwable) {
                    if (TopologyUpdateController.this.modelUpdatingCounter.decrementAndGet() != 0) throw throwable;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TopologyUpdateController.this.graphView.showLayoutUpdating(false);
                            TopologyUpdateController.this.topView.checkDivider();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        this.taskMgr.submit(caller, realCallback);
    }

    protected void uninstallUndoManager(mxGraph graph) {
        try {
            mxGraphView view;
            mxIGraphModel model = graph.getModel();
            if (model != null) {
                model.removeListener(this.undoHandler);
            }
            if ((view = graph.getView()) != null) {
                view.removeListener(this.undoHandler);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void installUndoManager(mxGraph graph) {
        if (graph != null) {
            this.undoManager.clear();
            graph.getModel().addListener("undo", this.undoHandler);
            graph.getView().addListener("undo", this.undoHandler);
        }
    }
}

