/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.task;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.model.GraphEdge;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.LayoutChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyGraphController;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.intel.stl.ui.network.task.TopologyUpdateTask;
import com.mxgraph.model.mxCell;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ShowEdgesTask
extends TopologyUpdateTask {
    private final List<GraphEdge> edges;
    private final String vfName;
    private TopologyTreeModel tmpTreeMode;
    private final LayoutType defaultLayout = LayoutType.TREE_SLASH;

    public ShowEdgesTask(TopologyGraphController controller, Object source, FVResourceNode[] selectedResources, List<GraphEdge> edges) {
        super(controller, source, selectedResources);
        this.edges = edges;
        this.vfName = this.getVFName(selectedResources);
        this.setIncludeNeighbors(false);
    }

    protected String getVFName(FVResourceNode[] selectedResources) {
        String res = null;
        FVResourceNode refGroup = null;
        String vfName = null;
        for (int i = 0; i < selectedResources.length; ++i) {
            vfName = null;
            FVResourceNode parent = selectedResources[i].getParent();
            FVResourceNode group = parent.getParent();
            if (refGroup != null && group != refGroup) {
                throw new IllegalArgumentException(STLConstants.K0808_DIFFERENT_PARENTS_ERROR.getValue());
            }
            if (group.getType() == TreeNodeType.VIRTUAL_FABRIC) {
                vfName = group.getTitle();
            }
            if (i != 0) continue;
            res = vfName;
            refGroup = group;
        }
        return res;
    }

    @Override
    public void preBackgroundTask(ICancelIndicator indicator, TopGraph oldGraph) {
        this.resourceController.showLinks(this.edges, this.vfName);
    }

    @Override
    protected Collection<Integer> getInvolvedNodes(ICancelIndicator indicator, TopGraph oldGraph) {
        HashSet<Integer> involvedNodes = new HashSet<Integer>();
        if (this.edges != null) {
            for (GraphEdge edge : this.edges) {
                involvedNodes.add(edge.getFromLid());
                involvedNodes.add(edge.getToLid());
            }
        } else {
            for (FVResourceNode node : this.selectedResources) {
                involvedNodes.add(node.getId());
            }
        }
        return involvedNodes;
    }

    @Override
    public boolean applyChanges(ICancelIndicator indicator, TopGraph newGraph) {
        this.tmpTreeMode = this.controller.getFullTopTreeModel().filterBy(newGraph);
        LayoutChange change = new LayoutChange(this.defaultLayout, this.tmpTreeMode);
        change.execute(newGraph, indicator);
        return true;
    }

    @Override
    public void onSuccess(final ICancelIndicator indicator, TopGraph newGraph) {
        super.onSuccess(indicator, newGraph);
        this.controller.setTopTreeModel(this.tmpTreeMode);
        FVResourceNode[] selectedNodes = this.selectedResources;
        if (!indicator.isCancelled() && this.source != this.controller && this.edges != null) {
            selectedNodes = this.controller.selectTreePorts(this.edges, indicator);
        }
        final mxCell[] cells = this.getEdgeCells(this.edges, newGraph);
        this.submitGraphTask(new Runnable(){

            @Override
            public void run() {
                ShowEdgesTask.this.graphView.clearEdges();
                if (!indicator.isCancelled()) {
                    ShowEdgesTask.this.graphView.selectNodes(cells);
                }
                ShowEdgesTask.this.graphView.updateGraph();
            }
        });
        this.submitOutlineTask(new Runnable(){

            @Override
            public void run() {
                ShowEdgesTask.this.guideView.clearEdges();
                if (!indicator.isCancelled()) {
                    ShowEdgesTask.this.guideView.selectNodes(cells);
                }
                ShowEdgesTask.this.guideView.updateGraph();
            }
        });
        this.guideView.setSelectedResources(selectedNodes);
        this.setLayout(this.defaultLayout);
    }

    protected mxCell[] getEdgeCells(List<GraphEdge> edges, TopGraph graph) {
        if (edges == null) {
            return new mxCell[0];
        }
        mxCell[] cells = new mxCell[edges.size()];
        for (int i = 0; i < edges.size(); ++i) {
            mxCell cell;
            GraphEdge edge = edges.get(i);
            cells[i] = cell = graph.getEdge(edge.getFromLid(), edge.getToLid());
        }
        return cells;
    }
}

