/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.network.task;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.TraceRecordBean;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.model.GraphEdge;
import com.intel.stl.ui.model.GraphNode;
import com.intel.stl.ui.model.LayoutType;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import com.intel.stl.ui.network.LayoutChange;
import com.intel.stl.ui.network.TopGraph;
import com.intel.stl.ui.network.TopologyGraphController;
import com.intel.stl.ui.network.TopologyTreeModel;
import com.intel.stl.ui.network.task.TopologyUpdateTask;
import com.mxgraph.model.mxCell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowRoutesTask
extends TopologyUpdateTask {
    private static final Logger log = LoggerFactory.getLogger(ShowRoutesTask.class);
    private static final boolean DEBUG = true;
    private final List<GraphNode> nodes;
    private final String vfName;
    private TopologyTreeModel tmpTreeMode;
    private Map<GraphEdge, List<GraphEdge>> traceMap;
    private List<mxCell> edges;
    private final LayoutType defaultLayout = LayoutType.TREE_SLASH;

    public ShowRoutesTask(TopologyGraphController controller, Object source, FVResourceNode[] selectedResources, List<GraphNode> nodes) {
        super(controller, source, selectedResources);
        this.nodes = nodes;
        this.vfName = this.getVFName(selectedResources);
        this.setIncludeNeighbors(false);
    }

    protected String getVFName(FVResourceNode[] selectedResources) {
        String res = null;
        FVResourceNode refGroup = null;
        String vfName = null;
        for (int i = 0; i < selectedResources.length; ++i) {
            vfName = null;
            FVResourceNode parent = selectedResources[i].getParent();
            FVResourceNode group = parent.getParent();
            if (refGroup != null && group != refGroup) {
                throw new IllegalArgumentException("Nodes have no the same parent!");
            }
            if (group.getType() == TreeNodeType.VIRTUAL_FABRIC) {
                vfName = group.getTitle();
            }
            if (i != 0) continue;
            res = vfName;
            refGroup = group;
        }
        return res;
    }

    @Override
    protected Collection<Integer> getInvolvedNodes(ICancelIndicator indicator, TopGraph oldGraph) {
        this.traceMap = this.getTraceMap(this.nodes, indicator);
        if (indicator != null && indicator.isCancelled()) {
            throw new CancellationException();
        }
        this.resourceController.showPath(this.traceMap, this.vfName);
        if (this.traceMap == null) {
            return Collections.emptyList();
        }
        Map<Integer, Set<Integer>> links = this.getUniqueLinks(this.traceMap);
        this.edges = new ArrayList<mxCell>();
        HashSet<Integer> involvedNodes = new HashSet<Integer>();
        for (int fromLid : links.keySet()) {
            Set<Integer> nbr = links.get(fromLid);
            for (int toLid : nbr) {
                if (indicator != null && indicator.isCancelled()) {
                    throw new CancellationException();
                }
                mxCell cell = oldGraph.getEdge(fromLid, toLid);
                this.edges.add(cell);
            }
            involvedNodes.add(fromLid);
            involvedNodes.addAll(nbr);
        }
        return involvedNodes;
    }

    @Override
    public boolean applyChanges(ICancelIndicator indicator, TopGraph newGraph) {
        this.tmpTreeMode = this.controller.getFullTopTreeModel().filterBy(newGraph);
        LayoutChange change = new LayoutChange(this.defaultLayout, this.tmpTreeMode);
        change.execute(newGraph, indicator);
        return true;
    }

    @Override
    public void onSuccess(final ICancelIndicator indicator, TopGraph newGraph) {
        super.onSuccess(indicator, newGraph);
        this.controller.setTopTreeModel(this.tmpTreeMode);
        FVResourceNode[] selectedNodes = this.selectedResources;
        if (!indicator.isCancelled() && this.source != this.controller) {
            selectedNodes = this.controller.selectTreeNodes(this.nodes, indicator);
        }
        final mxCell[] cells = new mxCell[this.nodes.size()];
        for (int i = 0; i < cells.length; ++i) {
            cells[i] = newGraph.getVertex(this.nodes.get(i).getLid());
        }
        this.submitGraphTask(new Runnable(){

            @Override
            public void run() {
                ShowRoutesTask.this.graphView.clearEdges();
                ShowRoutesTask.this.graphView.selectEdges(ShowRoutesTask.this.edges, true);
                if (!indicator.isCancelled()) {
                    ShowRoutesTask.this.graphView.selectNodes(cells);
                }
                ShowRoutesTask.this.graphView.updateGraph();
            }
        });
        FVResourceNode[] nodes = selectedNodes;
        this.submitOutlineTask(new Runnable(){

            @Override
            public void run() {
                ShowRoutesTask.this.guideView.clearEdges();
                ShowRoutesTask.this.guideView.selectEdges(ShowRoutesTask.this.edges, true);
                if (!indicator.isCancelled()) {
                    ShowRoutesTask.this.guideView.selectNodes(cells);
                }
                ShowRoutesTask.this.guideView.updateGraph();
            }
        });
        this.guideView.setSelectedResources(nodes);
        this.setLayout(this.defaultLayout);
    }

    protected Map<GraphEdge, List<GraphEdge>> getTraceMap(List<GraphNode> nodes, ICancelIndicator indicator) {
        ISubnetApi subnetApi = this.controller.getSubnetApi();
        LinkedHashMap<GraphEdge, List<GraphEdge>> traceMap = new LinkedHashMap<GraphEdge, List<GraphEdge>>();
        for (int i = 0; i < nodes.size() - 1; ++i) {
            GraphNode source = nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                if (indicator.isCancelled()) {
                    log.info("getTraceMap cancelled " + nodes);
                    return null;
                }
                GraphNode target = nodes.get(j);
                List<TraceRecordBean> trace = subnetApi.getTrace(source.getLid(), target.getLid());
                if (trace == null) {
                    log.warn("No trace found on link Lid " + StringUtils.intHexString(source.getLid()) + " - Lid " + StringUtils.intHexString(target.getLid()));
                    continue;
                }
                System.out.println(source + " -> " + target);
                GraphEdge edge = new GraphEdge(source.getLid(), source.getType(), target.getLid(), target.getType(), source.getLinkPorts(target));
                ArrayList<GraphEdge> edges = new ArrayList<GraphEdge>(trace.size() - 1);
                TraceRecordBean start = null;
                NodeRecordBean startNode = null;
                for (TraceRecordBean bean : trace) {
                    if (indicator.isCancelled()) {
                        return null;
                    }
                    NodeRecordBean node = null;
                    try {
                        node = subnetApi.getNode(bean.getNodeId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    if (start == null) {
                        start = bean;
                        startNode = node;
                        continue;
                    }
                    GraphEdge nextEdge = new GraphEdge(startNode.getLid(), startNode.getNodeType().getId(), node.getLid(), node.getNodeType().getId(), Collections.singletonMap(Integer.valueOf(start.getExitPort()), Integer.valueOf(bean.getEntryPort())));
                    edges.add(nextEdge);
                    System.out.println("  " + startNode.getNodeDesc() + "-" + node.getNodeDesc() + " " + nextEdge);
                    start = bean;
                    startNode = node;
                }
                traceMap.put(edge, edges);
            }
        }
        return traceMap;
    }

    protected Map<Integer, Set<Integer>> getUniqueLinks(Map<GraphEdge, List<GraphEdge>> traceMap) {
        HashMap<Integer, Set<Integer>> res = new HashMap<Integer, Set<Integer>>();
        for (List<GraphEdge> trace : traceMap.values()) {
            for (GraphEdge edge : trace) {
                GraphEdge tmp = edge.normalize();
                HashSet<Integer> nbr = (HashSet<Integer>)res.get(tmp.getFromLid());
                if (nbr == null) {
                    nbr = new HashSet<Integer>();
                    res.put(tmp.getFromLid(), nbr);
                }
                nbr.add(tmp.getToLid());
            }
        }
        return res;
    }
}

