/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.api.performance.UtilStatsBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.model.TrendSeries;
import com.intel.stl.ui.model.UtilDataset;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.PmaNoRespGroupSource;
import com.intel.stl.ui.performance.TopoNoRespGroupSource;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.TrendItem;
import com.intel.stl.ui.performance.observer.UtilTrendDataObserver;
import com.intel.stl.ui.performance.observer.VFUtilTrendDataObserver;
import com.intel.stl.ui.performance.provider.CombinedGroupInfoProvider;
import com.intel.stl.ui.performance.provider.CombinedVFInfoProvider;
import com.intel.stl.ui.performance.provider.DataProviderName;
import java.util.List;
import org.jfree.data.time.TimePeriodValuesCollection;

public class PRTrendItem
extends TrendItem<GroupSource> {
    public PRTrendItem() {
        super(STLConstants.K0853_SHORT_PKT_RATE_TREND.getValue(), STLConstants.K0872_PACKECT_RATE_TREND.getValue());
    }

    public PRTrendItem(int maxDataPoints) {
        super(STLConstants.K0853_SHORT_PKT_RATE_TREND.getValue(), STLConstants.K0065_PACKET_RATE.getValue(), maxDataPoints);
    }

    public PRTrendItem(PRTrendItem item) {
        super(item);
    }

    @Override
    protected void initDataProvider() {
        CombinedGroupInfoProvider provider = new CombinedGroupInfoProvider();
        UtilTrendDataObserver observer = new UtilTrendDataObserver(this){

            @Override
            protected long getValue(UtilStatsBean util) {
                return util.getTotalKPps();
            }
        };
        this.registerDataProvider(DataProviderName.PORT_GROUP, provider, observer);
        CombinedVFInfoProvider vfProvider = new CombinedVFInfoProvider();
        VFUtilTrendDataObserver vfObserver = new VFUtilTrendDataObserver(this){

            @Override
            protected long getValue(UtilStatsBean util) {
                return util.getTotalKPps();
            }
        };
        this.registerDataProvider(DataProviderName.VIRTUAL_FABRIC, vfProvider, vfObserver);
    }

    @Override
    protected TimePeriodValuesCollection createTrendDataset() {
        return new UtilDataset();
    }

    protected List<TrendSeries> createTrendSeries(GroupSource[] series) {
        if (series != null) {
            GroupSource[] newSeries = new GroupSource[series.length * 3];
            int i = 0;
            for (GroupSource gs : series) {
                newSeries[i++] = gs;
                newSeries[i++] = new PmaNoRespGroupSource(gs);
                newSeries[i++] = new TopoNoRespGroupSource(gs);
            }
            series = newSeries;
        }
        return super.createTrendSeries((ISource[])series);
    }

    @Override
    public IPerformanceItem<GroupSource> copy() {
        return new PRTrendItem(this);
    }
}

