/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.CategoryStatBean;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.item.TrendItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;
import java.util.Date;

public abstract class ErrorDataObserver
extends AbstractDataObserver<GroupInfoBean[], TrendItem<GroupSource>> {
    public ErrorDataObserver(TrendItem<GroupSource> controller) {
        this(controller, DataType.ALL);
    }

    public ErrorDataObserver(TrendItem<GroupSource> controller, DataType type) {
        super(controller, type);
    }

    @Override
    public void processData(GroupInfoBean[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        for (GroupInfoBean bean : data) {
            if (bean == null) continue;
            Date time = bean.getTimestampDate();
            int interval = bean.getImageInterval();
            CategoryStatBean[] errors = this.getCategoryStatBeans(bean, this.type);
            long value = 0L;
            for (CategoryStatBean error : errors) {
                value += this.getValue(error);
            }
            GroupSource sourceName = new GroupSource(bean.getGroupName());
            ((TrendItem)this.controller).updateTrend(value, time, interval, sourceName);
        }
    }

    protected abstract long getValue(CategoryStatBean var1);
}

