/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.UtilStatsBean;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.PmaNoRespGroupSource;
import com.intel.stl.ui.performance.TopoNoRespGroupSource;
import com.intel.stl.ui.performance.item.TrendItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;
import java.util.Date;

public abstract class UtilTrendDataObserver
extends AbstractDataObserver<GroupInfoBean[], TrendItem<GroupSource>> {
    public UtilTrendDataObserver(TrendItem<GroupSource> controller) {
        this(controller, DataType.ALL);
    }

    public UtilTrendDataObserver(TrendItem<GroupSource> controller, DataType type) {
        super(controller, type);
    }

    @Override
    public void processData(GroupInfoBean[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        for (GroupInfoBean bean : data) {
            if (bean == null) continue;
            Date time = bean.getTimestampDate();
            int interval = bean.getImageInterval();
            UtilStatsBean[] utils = this.getUtilStatsBeans(bean, this.type);
            long value = 0L;
            long pmaNoResp = 0L;
            long topoNoResp = 0L;
            for (UtilStatsBean util : utils) {
                value += this.getValue(util);
                pmaNoResp += (long)util.getPmaNoRespPorts();
                topoNoResp += (long)util.getTopoIncompPorts();
            }
            GroupSource sourceName = new GroupSource(bean.getGroupName());
            ((TrendItem)this.controller).updateTrend(value, time, interval, sourceName);
            if (pmaNoResp != 0L) {
                PmaNoRespGroupSource pfSource = new PmaNoRespGroupSource(sourceName);
                ((TrendItem)this.controller).updateTrend(pmaNoResp, time, interval, pfSource);
            }
            if (topoNoResp == 0L) continue;
            TopoNoRespGroupSource tfSource = new TopoNoRespGroupSource(sourceName);
            ((TrendItem)this.controller).updateTrend(topoNoResp, time, interval, tfSource);
        }
    }

    protected abstract long getValue(UtilStatsBean var1);
}

