/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.VFPortCountersBean;
import com.intel.stl.ui.monitor.DeltaConverter;
import com.intel.stl.ui.performance.PortSourceName;
import com.intel.stl.ui.performance.item.PortCountersItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;
import java.util.Date;

public abstract class VFCounterRateObserver
extends AbstractDataObserver<VFPortCountersBean, PortCountersItem> {
    private final DeltaConverter converter;

    public VFCounterRateObserver(PortCountersItem controller) {
        super(controller);
        this.converter = new DeltaConverter(controller.getFullName());
    }

    @Override
    public void processData(VFPortCountersBean bean) {
        if (bean == null) {
            return;
        }
        PortSourceName sourceName = new PortSourceName(bean.getVfName(), null, bean.getNodeLid(), bean.getPortNumber());
        Date time = bean.getTimestampDate();
        int interval = bean.getImageInterval();
        DeltaConverter.Delta delta = this.converter.addValue(this.getValue(bean), time);
        if (delta != null) {
            ((PortCountersItem)this.controller).updateTrend(delta.getRate(), time, interval, sourceName);
        }
    }

    protected abstract long getValue(VFPortCountersBean var1);
}

