/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.performance.PerformanceRequestCancelledException;
import com.intel.stl.ui.publisher.ICallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackAdapter<E>
implements ICallback<E> {
    private static Logger log = LoggerFactory.getLogger(CallbackAdapter.class);

    @Override
    public void onDone(E result) {
    }

    @Override
    public void onError(Throwable ... errors) {
        for (Throwable e : errors) {
            if (e instanceof PerformanceRequestCancelledException) continue;
            log.error(StringUtils.getErrorMessage(e), e);
        }
    }

    @Override
    public void onProgress(double progress) {
    }

    @Override
    public void onFinally() {
    }

    @Override
    public void reset() {
    }

    public static <E> ICallback<E[]> asArrayCallbak(final ICallback<E> callback) {
        return new CallbackAdapter<E[]>(){

            @Override
            public void onDone(E[] result) {
                callback.onDone(result[0]);
            }
        };
    }
}

