/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher;

import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.api.notice.IEventListener;
import com.intel.stl.api.notice.IEventSource;
import com.intel.stl.api.notice.NodeSource;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.subnet.FabricInfoBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.model.HealthScoreAttribute;
import com.intel.stl.ui.model.NodeScore;
import com.intel.stl.ui.model.StateSummary;
import com.intel.stl.ui.model.TimedScore;
import com.intel.stl.ui.model.UserPreference;
import com.intel.stl.ui.publisher.IStateChangeListener;
import com.intel.stl.ui.publisher.IStateMonitor;
import com.intel.stl.ui.publisher.NodeEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventCalculator
implements IEventListener<EventDescription>,
IStateMonitor {
    private static Logger log = LoggerFactory.getLogger(EventCalculator.class);
    private static final boolean DEBUG = false;
    public static EnumMap<NoticeSeverity, Double> HEALTH_WEIGHTS = new EnumMap<NoticeSeverity, Double>(NoticeSeverity.class){
        private static final long serialVersionUID = 2065678798638714805L;
        {
            this.put(NoticeSeverity.INFO, 1.0);
            this.put(NoticeSeverity.WARNING, 0.8);
            this.put(NoticeSeverity.ERROR, 0.3);
            this.put(NoticeSeverity.CRITICAL, 0.1);
        }
    };
    private final Map<NodeType, Integer> baseNodesDist;
    private final int totalNodes;
    private volatile int numWorstNodes;
    private volatile int timeWindow;
    private LinkedList<NodeEvents> events;
    private final int[] switchStates;
    private final int[] hfiStates;
    private final Object critical = new Object();
    private List<NodeEvents> eventsImage;
    private int[] switchStatesImage;
    private int[] hfiStatesImage;
    private long sweepTime;
    private boolean hasSweep;
    private boolean weightsChanged = false;
    private final EnumMap<HealthScoreAttribute, Long> values;
    private final EnumMap<HealthScoreAttribute, Long> totals;
    private final EnumMap<HealthScoreAttribute, Integer> weightSettings;
    private final EnumMap<HealthScoreAttribute, Integer> weights;
    private final long[] baseline = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
    private int totalWeight;
    private final List<IStateChangeListener> stateChangeListeners = new CopyOnWriteArrayList<IStateChangeListener>();

    public EventCalculator(EnumMap<NodeType, Integer> nodes, UserPreference userPreference) {
        this.setTimeWindowInSeconds(userPreference.getTimeWindowInSeconds());
        this.baseNodesDist = nodes != null ? Collections.unmodifiableMap(nodes) : Collections.emptyMap();
        int sum = 0;
        for (Integer count : this.baseNodesDist.values()) {
            if (count == null) continue;
            sum += count.intValue();
        }
        this.totalNodes = sum;
        this.setNumWorstNodes(userPreference.getNumWorstNodes());
        this.switchStates = new int[NoticeSeverity.values().length];
        this.hfiStates = new int[NoticeSeverity.values().length];
        this.events = new LinkedList();
        this.weightSettings = new EnumMap(HealthScoreAttribute.class);
        this.values = new EnumMap(HealthScoreAttribute.class);
        this.totals = new EnumMap(HealthScoreAttribute.class);
        this.weights = new EnumMap(HealthScoreAttribute.class);
        this.setHealthScoreWeights(userPreference);
        this.sweep();
    }

    public int getTimeWindowInSeconds() {
        return this.timeWindow / 1000;
    }

    public void setTimeWindowInSeconds(int timeWindowInSeconds) {
        this.timeWindow = timeWindowInSeconds * 1000;
    }

    public int getNumWorstNodes() {
        return this.numWorstNodes;
    }

    public void setNumWorstNodes(int numWorstNodes) {
        this.numWorstNodes = numWorstNodes;
    }

    public int getTotalNodes() {
        return this.totalNodes;
    }

    public Map<NodeType, Integer> getBaseNodesDist() {
        return this.baseNodesDist;
    }

    public void onNewEvent(EventDescription[] data) {
        for (EventDescription ed : data) {
            IEventSource source = ed.getSource();
            if (!(source instanceof NodeSource)) continue;
            NodeSource nodeSource = (NodeSource)source;
            this.addEvent(nodeSource, ed.getDate().getTime(), ed.getType(), ed.getSeverity());
        }
        this.sweep();
        this.updateListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvent(NodeSource nodeSource, long time, EventType type, NoticeSeverity severity) {
        LinkedList<NodeEvents> linkedList = this.events;
        synchronized (linkedList) {
            NodeEvents ne = new NodeEvents(nodeSource);
            NoticeSeverity oldSeverity = null;
            int index = this.events.indexOf(ne);
            if (index >= 0) {
                ne = this.events.get(index);
                oldSeverity = ne.getOverallSeverity();
            } else {
                this.events.add(ne);
            }
            NoticeSeverity newSeverity = ne.addEvent(time, type, severity);
            this.updateStates(nodeSource.getNodeType(), oldSeverity, newSeverity);
        }
    }

    public void updateListeners() {
        StateSummary summary = this.getSummary();
        for (IStateChangeListener listener : this.stateChangeListeners) {
            listener.onStateChange(summary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.events != null && !this.events.isEmpty()) {
            LinkedList<NodeEvents> linkedList = this.events;
            synchronized (linkedList) {
                this.events.clear();
                Object object = this.critical;
                synchronized (object) {
                    int i;
                    this.eventsImage.clear();
                    for (i = 0; i < this.switchStatesImage.length; ++i) {
                        this.switchStatesImage[i] = 0;
                        this.switchStates[i] = 0;
                    }
                    for (i = 0; i < this.hfiStatesImage.length; ++i) {
                        this.hfiStatesImage[i] = 0;
                        this.hfiStates[i] = 0;
                    }
                    this.updateListeners();
                }
            }
        }
    }

    protected void updateStates(NodeType type, NoticeSeverity oldSeverity, NoticeSeverity newSeverity) {
        if (type == NodeType.SWITCH) {
            if (oldSeverity != null) {
                int n = oldSeverity.ordinal();
                this.switchStates[n] = this.switchStates[n] - 1;
            }
            if (newSeverity != null) {
                int n = newSeverity.ordinal();
                this.switchStates[n] = this.switchStates[n] + 1;
            }
        } else if (type == NodeType.HFI) {
            if (oldSeverity != null) {
                int n = oldSeverity.ordinal();
                this.hfiStates[n] = this.hfiStates[n] - 1;
            }
            if (newSeverity != null) {
                int n = newSeverity.ordinal();
                this.hfiStates[n] = this.hfiStates[n] + 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearEvents(long cutTime) {
        LinkedList<NodeEvents> linkedList = this.events;
        synchronized (linkedList) {
            while (!this.events.isEmpty() && this.events.get(0).getEarlistTime() < cutTime) {
                NodeEvents ne = this.events.remove(0);
                NoticeSeverity oldSeverity = ne.getOverallSeverity();
                NoticeSeverity newSeverity = ne.clear(cutTime);
                if (newSeverity != oldSeverity) {
                    this.updateStates(ne.getNodeType(), oldSeverity, newSeverity);
                }
                if (newSeverity == null) continue;
                int index = Collections.binarySearch(this.events, ne);
                if (index >= 0) {
                    this.events.add(index, ne);
                    continue;
                }
                this.events.add(-index - 1, ne);
            }
        }
    }

    protected void sweep() {
        this.sweep(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sweep(long time) {
        this.sweepTime = time;
        LinkedList<NodeEvents> linkedList = this.events;
        synchronized (linkedList) {
            this.clearEvents(this.sweepTime - (long)this.timeWindow);
            ArrayList<NodeEvents> eventsCopy = new ArrayList<NodeEvents>();
            for (NodeEvents ne : this.events) {
                eventsCopy.add(ne.copy());
            }
            int[] switchStatesCopy = new int[this.switchStates.length];
            System.arraycopy(this.switchStates, 0, switchStatesCopy, 0, switchStatesCopy.length);
            int[] hfiStatesCopy = new int[this.hfiStates.length];
            System.arraycopy(this.hfiStates, 0, hfiStatesCopy, 0, hfiStatesCopy.length);
            Object object = this.critical;
            synchronized (object) {
                this.eventsImage = eventsCopy;
                this.switchStatesImage = switchStatesCopy;
                this.hfiStatesImage = hfiStatesCopy;
            }
        }
        if (!this.hasSweep) {
            this.hasSweep = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimedScore getHealthScore() {
        if (this.totalNodes <= 0 || !this.hasSweep) {
            return null;
        }
        double healthScore = 0.0;
        StringBuffer tipBuff = new StringBuffer();
        tipBuff.append("<html>");
        Object object = this.critical;
        synchronized (object) {
            for (HealthScoreAttribute attr : this.values.keySet()) {
                double value = this.values.get((Object)attr).longValue();
                double weight = this.weights.get((Object)attr).intValue();
                double score = value / (double)this.totalWeight * weight;
                healthScore += score;
                if (this.totals.get((Object)attr) <= 0L) continue;
                long total = this.totals.get((Object)attr);
                String desc = attr.getDescription();
                tipBuff.append(String.format("%1$-25s : %2$6.0f / %3$d", desc, value, total));
                tipBuff.append("<br>");
            }
        }
        tipBuff.append("</html>");
        return new TimedScore(this.sweepTime, (healthScore += 1.0E-12) * 100.0, tipBuff.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumMap<NoticeSeverity, Integer> getSwitchStates() {
        if (!this.hasSweep) {
            return null;
        }
        EnumMap<NoticeSeverity, Integer> res = new EnumMap<NoticeSeverity, Integer>(NoticeSeverity.class);
        Object object = this.critical;
        synchronized (object) {
            for (int i = 0; i < this.switchStatesImage.length; ++i) {
                res.put(NoticeSeverity.values()[i], this.switchStatesImage[i]);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumMap<NoticeSeverity, Integer> getHFIStates() {
        if (!this.hasSweep) {
            return null;
        }
        EnumMap<NoticeSeverity, Integer> res = new EnumMap<NoticeSeverity, Integer>(NoticeSeverity.class);
        Object object = this.critical;
        synchronized (object) {
            for (int i = 0; i < this.hfiStatesImage.length; ++i) {
                res.put(NoticeSeverity.values()[i], this.hfiStatesImage[i]);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeScore[] getWorstNodes(int size) {
        if (!this.hasSweep) {
            return null;
        }
        ArrayList<NodeEvents> nodes = null;
        Object object = this.critical;
        synchronized (object) {
            nodes = new ArrayList<NodeEvents>(this.eventsImage);
        }
        size = Math.min(size, nodes.size());
        Object[] res = new NodeScore[size];
        for (int i = 0; i < size; ++i) {
            NodeEvents ne = (NodeEvents)nodes.get(i);
            NodeEvents.EventItem item = ne.getLatestEvent();
            if (item == null) continue;
            res[i] = new NodeScore(ne.getName(), ne.getNodeType(), ne.getLid(), item.getType(), this.sweepTime, item.getHealthScore());
        }
        Arrays.sort(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateSummary getSummary() {
        if (!this.hasSweep) {
            return null;
        }
        this.sweep();
        StateSummary res = new StateSummary(this.baseNodesDist);
        LinkedList<NodeEvents> linkedList = this.events;
        synchronized (linkedList) {
            res.setHealthScore(this.getHealthScore());
            res.setSwitchStates(this.getSwitchStates());
            res.setHfiStates(this.getHFIStates());
            res.setWorstNodes(this.getWorstNodes(this.numWorstNodes));
            res.setEvents(this.eventsImage);
        }
        return res;
    }

    public boolean updateUserPreference(UserPreference oldUserPreference, UserPreference newUserPreference) {
        int oldTimeWindow = oldUserPreference.getTimeWindowInSeconds();
        int newTimeWindow = newUserPreference.getTimeWindowInSeconds();
        boolean userPrefChanged = false;
        if (oldTimeWindow < newTimeWindow) {
            this.setTimeWindowInSeconds(newTimeWindow);
            userPrefChanged = true;
        } else if (oldTimeWindow > newTimeWindow) {
            this.setTimeWindowInSeconds(newTimeWindow);
            this.sweep();
            this.updateListeners();
            userPrefChanged = true;
        }
        int oldWorstNodes = oldUserPreference.getNumWorstNodes();
        int newWorstNodes = newUserPreference.getNumWorstNodes();
        if (oldWorstNodes != newWorstNodes) {
            this.setNumWorstNodes(newUserPreference.getNumWorstNodes());
            this.updateListeners();
            userPrefChanged = true;
        }
        this.setHealthScoreWeights(newUserPreference);
        return userPrefChanged;
    }

    public void processHealthScoreStats(FabricInfoBean fabricInfo, ImageInfoBean imageInfo) {
        if (fabricInfo == null || imageInfo == null) {
            return;
        }
        long numSwitches = fabricInfo.getNumSwitches();
        long numHFIs = fabricInfo.getNumHFIs();
        long numSwitchPorts = imageInfo.getNumSwitchPorts();
        long numHFIPorts = imageInfo.getNumHFIPorts();
        long numISLs = fabricInfo.getNumInternalISLs() + fabricInfo.getNumExternalISLs() + fabricInfo.getNumDegradedISLs();
        long numHFILinks = fabricInfo.getNumInternalHFILinks() + fabricInfo.getNumExternalHFILinks() + fabricInfo.getNumDegradedHFILinks();
        long[] newTotal = new long[]{numSwitches, numHFIs, numSwitchPorts, numHFIPorts, numISLs, numHFILinks};
        boolean baselineChanged = false;
        for (int i = 0; i < this.baseline.length; ++i) {
            if (newTotal[i] <= this.baseline[i]) continue;
            baselineChanged = true;
            this.baseline[i] = newTotal[i];
        }
        if (this.weightsChanged || baselineChanged) {
            this.resetWeights();
        }
        this.values.put(HealthScoreAttribute.NUM_SWITCHES, numSwitches);
        this.values.put(HealthScoreAttribute.NUM_HFIS, numHFIs);
        this.values.put(HealthScoreAttribute.NUM_ISLINKS, numISLs);
        this.values.put(HealthScoreAttribute.NUM_HFILINKS, numHFILinks);
        this.values.put(HealthScoreAttribute.NUM_PORTS, numSwitchPorts + numHFIPorts);
        this.values.put(HealthScoreAttribute.NUM_NONDEGRADED_ISLINKS, this.baseline[4] - fabricInfo.getNumDegradedISLs());
        this.values.put(HealthScoreAttribute.NUM_NONDEGRADED_HFILINKS, this.baseline[5] - fabricInfo.getNumDegradedHFILinks());
    }

    private void resetWeights() {
        int sumBaselinesWeights = 0;
        int setting = this.weightSettings.get((Object)HealthScoreAttribute.NUM_SWITCHES);
        int newWeight = this.baseline[0] == 0L ? 0 : (int)(setting == -1 ? this.baseline[2] / this.baseline[0] + 1L : (long)setting);
        this.weights.put(HealthScoreAttribute.NUM_SWITCHES, newWeight);
        this.totals.put(HealthScoreAttribute.NUM_SWITCHES, this.baseline[0]);
        sumBaselinesWeights = (int)((long)sumBaselinesWeights + this.baseline[0] * (long)newWeight);
        setting = this.weightSettings.get((Object)HealthScoreAttribute.NUM_HFIS);
        newWeight = this.baseline[1] == 0L ? 0 : (int)(setting == -1 ? this.baseline[3] / this.baseline[1] + 1L : (long)setting);
        this.weights.put(HealthScoreAttribute.NUM_HFIS, newWeight);
        this.totals.put(HealthScoreAttribute.NUM_HFIS, this.baseline[1]);
        sumBaselinesWeights = (int)((long)sumBaselinesWeights + this.baseline[1] * (long)newWeight);
        setting = this.weightSettings.get((Object)HealthScoreAttribute.NUM_PORTS);
        this.weights.put(HealthScoreAttribute.NUM_PORTS, setting);
        this.totals.put(HealthScoreAttribute.NUM_PORTS, this.baseline[2] + this.baseline[3]);
        sumBaselinesWeights = (int)((long)sumBaselinesWeights + (this.baseline[2] + this.baseline[3]) * (long)setting);
        setting = this.weightSettings.get((Object)HealthScoreAttribute.NUM_ISLINKS);
        this.weights.put(HealthScoreAttribute.NUM_ISLINKS, setting);
        this.totals.put(HealthScoreAttribute.NUM_ISLINKS, this.baseline[4]);
        sumBaselinesWeights = (int)((long)sumBaselinesWeights + this.baseline[4] * (long)setting);
        setting = this.weightSettings.get((Object)HealthScoreAttribute.NUM_HFILINKS);
        this.weights.put(HealthScoreAttribute.NUM_HFILINKS, setting);
        this.totals.put(HealthScoreAttribute.NUM_HFILINKS, this.baseline[5]);
        sumBaselinesWeights = (int)((long)sumBaselinesWeights + this.baseline[5] * (long)setting);
        setting = this.weightSettings.get((Object)HealthScoreAttribute.NUM_NONDEGRADED_ISLINKS);
        this.weights.put(HealthScoreAttribute.NUM_NONDEGRADED_ISLINKS, setting);
        this.totals.put(HealthScoreAttribute.NUM_NONDEGRADED_ISLINKS, this.baseline[4]);
        sumBaselinesWeights = (int)((long)sumBaselinesWeights + this.baseline[4] * (long)setting);
        setting = this.weightSettings.get((Object)HealthScoreAttribute.NUM_NONDEGRADED_HFILINKS);
        this.weights.put(HealthScoreAttribute.NUM_NONDEGRADED_HFILINKS, setting);
        this.totals.put(HealthScoreAttribute.NUM_NONDEGRADED_HFILINKS, this.baseline[5]);
        this.totalWeight = sumBaselinesWeights = (int)((long)sumBaselinesWeights + this.baseline[5] * (long)setting);
    }

    public void addListener(IStateChangeListener listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeListener(IStateChangeListener listener) {
        this.stateChangeListeners.remove(listener);
    }

    public void cleanup() {
        this.events = null;
        this.eventsImage = null;
    }

    protected void setHealthScoreWeights(UserPreference userPreference) {
        this.weightsChanged = true;
        for (HealthScoreAttribute attr : HealthScoreAttribute.values()) {
            int weight = userPreference.getWeightForHealthScoreAttribute(attr);
            this.weightSettings.put(attr, weight);
        }
    }

    protected long[] getBaseline() {
        return this.baseline;
    }

    protected EnumMap<HealthScoreAttribute, Long> getValues() {
        return this.values;
    }

    protected EnumMap<HealthScoreAttribute, Long> getTotals() {
        return this.totals;
    }

    protected int getTotalWeight() {
        return this.totalWeight;
    }
}

