/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher;

import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.notice.NodeSource;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.publisher.EventCalculator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class NodeEvents
implements Serializable,
Comparable<NodeEvents> {
    private static final long serialVersionUID = 8632566237911275093L;
    private int lid;
    private String name;
    private NodeType nodeType;
    private List<EventItem> events = new ArrayList<EventItem>();
    private NoticeSeverity overallSeverity;

    public NodeEvents() {
    }

    public NodeEvents(NodeSource source) {
        this.lid = source.getLid();
        this.nodeType = source.getNodeType();
        this.name = source.getNodeName();
    }

    public int getLid() {
        return this.lid;
    }

    public String getName() {
        return this.name;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public synchronized long getEarlistTime() {
        if (!this.events.isEmpty()) {
            return this.events.get(0).getTime();
        }
        return -1L;
    }

    public synchronized int getSize() {
        return this.events.size();
    }

    public synchronized NoticeSeverity getOverallSeverity() {
        return this.overallSeverity;
    }

    public synchronized NoticeSeverity clear(long earliestTime) {
        boolean recalculateSeverity = false;
        while (!this.events.isEmpty() && this.events.get(0).getTime() < earliestTime) {
            NoticeSeverity severity = this.events.remove(0).getSeverity();
            if (recalculateSeverity || severity != this.overallSeverity) continue;
            recalculateSeverity = true;
        }
        if (recalculateSeverity) {
            this.overallSeverity = this.calculateSeverity();
        }
        return this.overallSeverity;
    }

    public synchronized NoticeSeverity addEvent(long time, EventType type, NoticeSeverity severity) {
        EventItem item = new EventItem(time, type, severity);
        this.events.add(item);
        if (this.overallSeverity == null || severity.ordinal() > this.overallSeverity.ordinal()) {
            this.overallSeverity = severity;
        }
        return this.overallSeverity;
    }

    protected NoticeSeverity calculateSeverity() {
        NoticeSeverity res = null;
        for (EventItem item : this.events) {
            NoticeSeverity severity = item.getSeverity();
            if (res != null && severity.ordinal() <= res.ordinal()) continue;
            res = severity;
        }
        return res;
    }

    public double getHealthScore() {
        NoticeSeverity severity = this.getOverallSeverity();
        if (severity == null) {
            return 0.0;
        }
        return EventCalculator.HEALTH_WEIGHTS.get((Object)severity) * 100.0;
    }

    public synchronized EventItem getLatestEvent() {
        if (!this.events.isEmpty()) {
            return this.events.get(this.events.size() - 1);
        }
        return null;
    }

    public NodeEvents copy() {
        NodeEvents res = new NodeEvents();
        res.lid = this.lid;
        res.name = new String(this.name);
        res.nodeType = this.nodeType;
        res.events = new ArrayList<EventItem>(this.events);
        res.overallSeverity = this.overallSeverity;
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lid;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeEvents other = (NodeEvents)obj;
        return this.lid == other.lid;
    }

    @Override
    public int compareTo(NodeEvents o) {
        long t2;
        long t1 = this.getEarlistTime();
        return t1 > (t2 = o.getEarlistTime()) ? 1 : (t1 < t2 ? -1 : 0);
    }

    public String toString() {
        return "NodeEvents [lid=" + this.lid + ", name=" + this.name + ", nodeType=" + (Object)((Object)this.nodeType) + ", events=" + this.events + ", overallSeverity=" + (Object)((Object)this.overallSeverity) + "]";
    }

    public static class EventItem
    implements Serializable {
        private final long time;
        private final EventType type;
        private final NoticeSeverity severity;

        public EventItem(long time, EventType type, NoticeSeverity severity) {
            this.time = time;
            this.type = type;
            this.severity = severity;
        }

        public long getTime() {
            return this.time;
        }

        public EventType getType() {
            return this.type;
        }

        public NoticeSeverity getSeverity() {
            return this.severity;
        }

        public double getHealthScore() {
            return EventCalculator.HEALTH_WEIGHTS.get((Object)this.severity) * 100.0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
            result = 31 * result + (int)(this.time ^ this.time >>> 32);
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventItem other = (EventItem)obj;
            if (this.severity != other.severity) {
                return false;
            }
            if (this.time != other.time) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return "Item [time=" + this.time + ", type=" + (Object)((Object)this.type) + ", severity=" + (Object)((Object)this.severity) + "]";
        }
    }
}

