/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher;

import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.UserPreference;
import com.intel.stl.ui.publisher.EventCalculator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserSettingsProcessor {
    private UserPreference userPreference;
    private final Context context;
    private final Map<EventType, NoticeSeverity> eventSeverityMap = new HashMap<EventType, NoticeSeverity>();

    public UserSettingsProcessor(UserSettings userSettings, Context context) {
        this.context = context;
        List<EventRule> eventRules = null;
        this.userPreference = new UserPreference(userSettings);
        if (userSettings != null) {
            eventRules = userSettings.getEventRules();
        }
        if (eventRules != null) {
            for (EventRule er : eventRules) {
                this.eventSeverityMap.put(er.getEventType(), er.getEventSeverity());
            }
        }
    }

    public void process(UserSettings newSettings) {
        boolean refreshRateChanged;
        List<EventRule> newList = null;
        if (newSettings != null) {
            newList = newSettings.getEventRules();
        }
        boolean severityChanged = false;
        if (newList != null) {
            for (EventRule er : newList) {
                NoticeSeverity newSeverity;
                EventType eventType = er.getEventType();
                NoticeSeverity oldSeverity = this.eventSeverityMap.get((Object)eventType);
                if (oldSeverity == (newSeverity = er.getEventSeverity())) continue;
                this.eventSeverityMap.put(eventType, newSeverity);
                severityChanged = true;
            }
        }
        EventCalculator evtCal = this.context.getEvtCal();
        if (severityChanged) {
            evtCal.clear();
        }
        UserPreference newPreference = new UserPreference(newSettings);
        boolean userPrefChanged = evtCal.updateUserPreference(this.userPreference, newPreference);
        boolean bl = refreshRateChanged = newPreference.getRefreshRateInSeconds() != this.userPreference.getRefreshRateInSeconds();
        if (refreshRateChanged) {
            this.context.getTaskScheduler().updateRefreshRate(newPreference.getRefreshRateInSeconds());
        }
        if (severityChanged || userPrefChanged || refreshRateChanged) {
            this.userPreference = newPreference;
        }
    }
}

