/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.impl.preferences;

import com.intel.stl.api.IMessage;
import com.intel.stl.ui.common.UILabels;
import java.util.HashMap;

public enum PreferencesValidatorError {
    REFRESH_RATE_MISSING(0, UILabels.STL50064_REFRESH_RATE_MISSING),
    REFRESH_RATE_INVALID_TYPE(1, UILabels.STL50065_REFRESH_RATE_INVALID_TYPE),
    REFRESH_RATE_OUT_OF_RANGE(2, UILabels.STL50066_REFRESH_RATE_OUT_OF_RANGE),
    REFRESH_RATE_THRESHOLD_ERROR(3, UILabels.STL50067_REFRESH_RATE_THRESHOLD_ERROR),
    REFRESH_RATE_FORMAT_EXCEPTION(4, UILabels.STL50068_REFRESH_RATE_FORMAT_EXCEPTION),
    REFRESH_RATE_UNITS_MISSING(5, UILabels.STL50069_REFRESH_RATE_UNITS_MISSING),
    REFRESH_RATE_UNITS_INVALID_TYPE(6, UILabels.STL50070_REFRESH_RATE_UNITS_INVALID_TYPE),
    REFRESH_RATE_UNITS_OUT_OF_RANGE(7, UILabels.STL50071_REFRESH_RATE_UNITS_OUT_OF_RANGE),
    REFRESH_RATE_UNITS_FORMAT_EXCEPTION(8, UILabels.STL50072_REFRESH_RATE_UNITS_FORMAT_EXCEPTION),
    TIMING_WINDOW_MISSING(9, UILabels.STL50073_TIMING_WINDOW_MISSING),
    TIMING_WINDOW_INVALID_TYPE(10, UILabels.STL50074_TIMING_WINDOW_INVALID_TYPE),
    TIMING_WINDOW_OUT_OF_RANGE(11, UILabels.STL50075_TIMING_WINDOW_OUT_OF_RANGE),
    TIMING_WINDOW_FORMAT_EXCEPTION(12, UILabels.STL50076_TIMING_WINDOW_FORMAT_EXCEPTION),
    NUM_WORST_NODES_MISSING(13, UILabels.STL50077_NUM_WORST_NODES_MISSING),
    NUM_WORST_NODES_INVALID_TYPE(14, UILabels.STL50078_NUM_WORST_NODES_INVALID_TYPE),
    NUM_WORST_NODES_OUT_OF_RANGE(15, UILabels.STL50079_NUM_WORST_NODES_OUT_OF_RANGE),
    NUM_WORST_NODES_FORMAT_EXCEPTION(16, UILabels.STL50080_NUM_WORST_NODES_FORMAT_EXCEPTION),
    UNABLE_TO_VALIDATE(17, UILabels.STL50089_UNABLE_TO_VALIDATE),
    OK(18, UILabels.STL50063_OK),
    UNKNOWN_ERROR(19, UILabels.STL50100_UNKNOWN_ERROR);

    private static final HashMap<Integer, PreferencesValidatorError> validateErrorMap;
    private final int id;
    private final String value;
    public final UILabels label;
    public Object[] data;

    private PreferencesValidatorError(int id, UILabels label) {
        this.id = id;
        this.label = label;
        this.value = label.getDescription();
    }

    public UILabels getLabel() {
        return this.label;
    }

    public int getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public void setData(Object[] data) {
        this.data = data;
    }

    public Object[] getData() {
        return this.data;
    }

    public static String getValue(int id) {
        PreferencesValidatorError err = validateErrorMap.get(id);
        String description = null;
        if (err != null) {
            description = err.getLabel().getDescription(err.getData());
        }
        return description;
    }

    public static IMessage getMessage(int id) {
        PreferencesValidatorError err = validateErrorMap.get(id);
        if (err != null) {
            return err.getLabel();
        }
        return null;
    }

    public static Object[] getData(int id) {
        PreferencesValidatorError err = validateErrorMap.get(id);
        if (err != null) {
            return err.getData();
        }
        return null;
    }

    static {
        validateErrorMap = new HashMap();
        for (PreferencesValidatorError type : PreferencesValidatorError.values()) {
            validateErrorMap.put(type.getId(), type);
        }
    }
}

