/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.impl.subnet;

import com.intel.stl.api.CertsDescription;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.main.ISubnetManager;
import com.intel.stl.ui.wizards.impl.IMultinetWizardListener;
import com.intel.stl.ui.wizards.impl.IMultinetWizardTask;
import com.intel.stl.ui.wizards.impl.IWizardListener;
import com.intel.stl.ui.wizards.impl.InteractionType;
import com.intel.stl.ui.wizards.impl.WizardValidationException;
import com.intel.stl.ui.wizards.impl.subnet.ISubnetControl;
import com.intel.stl.ui.wizards.impl.subnet.ISubnetListener;
import com.intel.stl.ui.wizards.model.IModelChangeListener;
import com.intel.stl.ui.wizards.model.IWizardModel;
import com.intel.stl.ui.wizards.model.MultinetWizardModel;
import com.intel.stl.ui.wizards.model.subnet.SubnetModel;
import com.intel.stl.ui.wizards.view.subnet.HostInfoPanel;
import com.intel.stl.ui.wizards.view.subnet.SubnetWizardView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubnetWizardController
implements IMultinetWizardTask,
ISubnetControl,
IModelChangeListener<IWizardModel> {
    private static Logger log = LoggerFactory.getLogger(SubnetWizardController.class);
    private LinkedHashMap<String, SubnetDescription> subnets;
    private SubnetWizardView view = null;
    private final ISubnetManager subnetMgr;
    private boolean done;
    private IMultinetWizardListener multinetWizardController;
    private SubnetModel subnetModel;
    private SubnetDescription newSubnet;
    private boolean connectable;
    private boolean connectionTest = false;

    public SubnetWizardController(SubnetWizardView view, ISubnetManager subnetMgr) {
        this.subnetMgr = subnetMgr;
        this.loadSubnets();
        if (view != null) {
            this.view = view;
            view.setControlListener(this);
            view.setWizardListener(this);
            view.setDirty(false);
        } else {
            log.error(STLConstants.K3045_SUBNET_VIEW_NULL.getValue());
        }
    }

    public SubnetWizardController(SubnetWizardView view, SubnetModel subnetModel, ISubnetManager subnetMgr) {
        this(view, subnetMgr);
        this.subnetModel = subnetModel;
    }

    @Override
    public void addSubnetListener(ISubnetListener listener) {
    }

    @Override
    public String getName() {
        return STLConstants.K0052_HOSTS.getValue();
    }

    @Override
    public JComponent getView() {
        return this.view;
    }

    @Override
    public void init() {
        this.view.setDirty(false);
        this.view.enableNext(false);
        this.done = false;
    }

    @Override
    public void setDone(boolean done) {
        this.done = done;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean validateUserEntry() throws WizardValidationException {
        boolean success = false;
        List<HostInfoPanel> hostPanelList = this.view.getHostPanelList();
        for (HostInfoPanel pnl : hostPanelList) {
            try {
                int portNum = Integer.valueOf(pnl.getPortNum());
                if (portNum > 0) continue;
                throw new WizardValidationException((IMessage)UILabels.STL80002_INVALID_PORT_NUMBER, portNum);
            }
            catch (NumberFormatException nfe) {
                WizardValidationException wve = new WizardValidationException((IMessage)UILabels.STL80007_PORT_INVALID_FORMAT, pnl.getPortNum());
                throw wve;
            }
        }
        if (!this.connectionTest) {
            this.updateModel();
        }
        this.done = true;
        success = true;
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectActionPerformed(final HostInfo hostInfo) {
        final SubnetDescription subnet = new SubnetDescription(hostInfo.getHost(), hostInfo.getHost(), hostInfo.getPort());
        ArrayList<HostInfo> hostInfoList = new ArrayList<HostInfo>();
        hostInfoList.add(hostInfo);
        subnet.setFEList(hostInfoList);
        subnet.setCurrentFEIndex(0);
        try {
            this.connectionTest = true;
            if (this.validateUserEntry()) {
                SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        boolean isConnected = SubnetWizardController.this.multinetWizardController.tryToConnect(subnet);
                        return isConnected;
                    }

                    @Override
                    protected void done() {
                        Boolean isConnected = false;
                        Throwable error = null;
                        try {
                            isConnected = (Boolean)this.get();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                            error = e.getCause();
                        }
                        subnet.setLastStatus(isConnected != false ? SubnetDescription.Status.VALID : SubnetDescription.Status.INVALID);
                        if (isConnected.booleanValue()) {
                            SubnetWizardController.this.multinetWizardController.getView().enableApply(true);
                            SubnetWizardController.this.multinetWizardController.getView().enableNext(true);
                            SubnetWizardController.this.view.setConnectionStatus(hostInfo.getHost(), STLConstants.K3031_PASS.getValue());
                            SubnetWizardController.this.view.logMessage(UILabels.STL50017_CONNECTION_EST.getDescription());
                        } else if (error != null) {
                            SubnetWizardController.this.view.setConnectionStatus(hostInfo.getHost(), STLConstants.K3032_FAIL.getValue());
                            SubnetWizardController.this.view.showMessage(UILabels.STL50059_CONNECTION_FAILURE_PROCEED.getDescription(subnet.getName(), subnet.getCurrentFE().getHost(), StringUtils.getErrorMessage(error)), 2);
                        } else {
                            SubnetWizardController.this.view.setConnectionStatus(hostInfo.getHost(), STLConstants.K3032_FAIL.getValue());
                            SubnetWizardController.this.view.showMessage(UILabels.STL50059_CONNECTION_FAILURE_PROCEED.getDescription(subnet.getName(), subnet.getCurrentFE().getHost(), STLConstants.K0016_UNKNOWN.getValue()), 2);
                        }
                    }
                };
                worker.execute();
            } else {
                this.view.setConnectionStatus(subnet.getName(), STLConstants.K3032_FAIL.getValue());
            }
        }
        catch (WizardValidationException e) {
            e.printStackTrace();
        }
        finally {
            this.connectionTest = false;
        }
    }

    protected void loadSubnets() {
        List<SubnetDescription> dbSubnets = null;
        dbSubnets = this.subnetMgr.getSubnets();
        if (dbSubnets != null) {
            this.subnets = new LinkedHashMap();
            for (SubnetDescription dbSubnet : dbSubnets) {
                this.subnets.put(dbSubnet.getName(), dbSubnet);
            }
            log.info("Subnets: " + this.subnets);
        }
    }

    @Override
    public SubnetDescription getSubnet() {
        return this.subnetModel.getSubnet();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void selectStep(String taskName) {
        this.multinetWizardController.selectStep(taskName);
    }

    @Override
    public void onPrevious() {
        this.view.enableNext(false);
    }

    @Override
    public void onReset() {
        this.view.update(this.subnetModel);
        this.view.setDirty(false);
    }

    @Override
    public void clear() {
        this.view.clearPanel();
        this.subnetModel.clear();
    }

    @Override
    public boolean isDirty() {
        return this.view.isDirty();
    }

    @Override
    public void setDirty(boolean dirty) {
        this.view.setDirty(dirty);
    }

    @Override
    public void doInteractiveAction(InteractionType action, Object ... data) {
        switch (action) {
            case CHANGE_WIZARDS: {
                if (data == null) {
                    return;
                }
                String taskName = (String)data[0];
                if (taskName == null) break;
                this.onReset();
                this.view.closeStatusPanel();
                this.selectStep(taskName);
                break;
            }
            case SAVE_LOGGING: {
                break;
            }
        }
    }

    @Override
    public synchronized void updateModel() {
        if (this.subnetModel == null) {
            return;
        }
        if (this.subnetModel.getSubnet() != null) {
            this.newSubnet = this.subnetModel.getSubnet();
            this.newSubnet.setAutoConnect(this.view.isAutoConnected());
            ArrayList<HostInfo> feList = new ArrayList<HostInfo>();
            for (HostInfoPanel hostInfoPanel : this.view.getHostPanelList()) {
                HostInfo hostInfo = new HostInfo();
                hostInfo.setHost(hostInfoPanel.getHostName());
                hostInfo.setPort(Integer.valueOf(hostInfoPanel.getPortNum()));
                hostInfo.setSecureConnect(hostInfoPanel.isSecureConnection());
                CertsDescription certs = new CertsDescription();
                certs.setKeyStoreFile(hostInfoPanel.getKeyStoreFile());
                certs.setTrustStoreFile(hostInfoPanel.getTrustStoreFile());
                hostInfo.setCertsDescription(certs);
                feList.add(hostInfo);
            }
            this.newSubnet.setFEList(feList);
            this.subnetModel.setSubnet(this.newSubnet);
        }
    }

    @Override
    public SubnetDescription getNewSubnet() {
        return this.newSubnet;
    }

    @Override
    public void promoteModel(MultinetWizardModel topModel) {
        topModel.setSubnetModel(this.subnetModel);
    }

    @Override
    public void onModelChange(IWizardModel m) {
        MultinetWizardModel model = (MultinetWizardModel)m;
        this.view.updateView(model);
    }

    @Override
    public void setWizardController(IWizardListener controller) {
    }

    @Override
    public void setWizardController(IMultinetWizardListener controller) {
        this.multinetWizardController = controller;
    }

    @Override
    public SubnetModel getSubnetModel() {
        return this.subnetModel;
    }

    @Override
    public void setConnectable(boolean connectable) {
        this.connectable = connectable;
    }

    @Override
    public boolean isEditValid() {
        return this.view.isEditValid();
    }
}

