/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.model;

import com.intel.stl.ui.wizards.impl.WizardType;
import com.intel.stl.ui.wizards.model.IModelChangeListener;
import com.intel.stl.ui.wizards.model.IWizardModel;
import com.intel.stl.ui.wizards.model.event.EventsModel;
import com.intel.stl.ui.wizards.model.preferences.PreferencesModel;
import com.intel.stl.ui.wizards.model.subnet.SubnetModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultinetWizardModel
implements IWizardModel {
    private SubnetModel subnetModel;
    private EventsModel eventsModel;
    private PreferencesModel preferencesModel;
    private final List<IModelChangeListener<IWizardModel>> listeners = new ArrayList<IModelChangeListener<IWizardModel>>();
    private final Map<WizardType, IModelChangeListener<IWizardModel>> listenerMap = new LinkedHashMap<WizardType, IModelChangeListener<IWizardModel>>();

    public SubnetModel getSubnetModel() {
        return this.subnetModel;
    }

    public void setSubnetModel(SubnetModel subnetModel) {
        this.subnetModel = subnetModel;
    }

    public EventsModel getEventsModel() {
        return this.eventsModel;
    }

    public void setEventsModel(EventsModel eventsModel) {
        this.eventsModel = eventsModel;
    }

    public PreferencesModel getPreferencesModel() {
        return this.preferencesModel;
    }

    public void setPreferencesModel(PreferencesModel preferencesModel) {
        this.preferencesModel = preferencesModel;
    }

    @Override
    public void addModelListener(IModelChangeListener<IWizardModel> listener, WizardType wizardType) {
        this.listeners.add(listener);
        if (wizardType != null) {
            this.listenerMap.put(wizardType, listener);
        }
    }

    @Override
    public void notifyModelChange() {
        for (IModelChangeListener<IWizardModel> listener : this.listeners) {
            listener.onModelChange(this);
        }
    }

    @Override
    public void notifyModelChange(WizardType wizardType) {
        IModelChangeListener<IWizardModel> listener = this.listenerMap.get((Object)wizardType);
        if (listener != null) {
            listener.onModelChange(this);
        }
    }

    @Override
    public void clearModel() {
    }
}

