/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.model.event;

import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.ui.common.FVTableModel;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.model.EventClassViz;
import com.intel.stl.ui.model.EventTypeViz;
import com.intel.stl.ui.wizards.impl.event.EventRulesTableColumns;
import com.intel.stl.ui.wizards.view.event.ITableListener;
import java.util.ArrayList;
import java.util.List;

public class EventRulesTableModel
extends FVTableModel<EventRule>
implements ITableListener {
    private static final long serialVersionUID = 5546605189508267737L;
    private int selectedRow;

    public EventRulesTableModel() {
        String[] columnNames = new String[EventRulesTableColumns.values().length];
        for (int i = 0; i < EventRulesTableColumns.values().length; ++i) {
            columnNames[i] = EventRulesTableColumns.values()[i].getTitle();
        }
        this.setColumnNames(columnNames);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2 || columnIndex == 3;
    }

    @Override
    public String getColumnName(int column) {
        return this.mColumnNames[column];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int col) {
        Object value = null;
        EventRule eventRule = null;
        Object object = this.critical;
        synchronized (object) {
            eventRule = (EventRule)this.mEntryList.get(row);
        }
        switch (EventRulesTableColumns.values()[col]) {
            case EVENT_CLASS: {
                value = EventClassViz.getEventTypeClassFor(eventRule.getEventType().getEventClass());
                break;
            }
            case EVENT_TYPE: {
                value = EventTypeViz.getEventTypeVizFor(eventRule.getEventType());
                break;
            }
            case EVENT_SEVERITY: {
                value = eventRule.getEventSeverity().name();
                break;
            }
            case EVENT_ACTION: {
                if (eventRule.getEventActions().size() <= 0) {
                    value = STLConstants.K0799_NO_ACTIONS.getValue();
                    break;
                }
                value = STLConstants.K0675_ACTION.getValue();
                break;
            }
        }
        return value;
    }

    public void clear() {
        this.mEntryList.clear();
    }

    public int getEntrySize() {
        return this.mEntryList.size();
    }

    @Override
    public void updateTable(final List<EventRule> rules) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                EventRulesTableModel.this.setEntries(rules);
                EventRulesTableModel.this.fireTableDataChanged();
            }
        });
    }

    @Override
    public List<EventRule> getEventRules() {
        ArrayList<EventRule> eventRules = new ArrayList<EventRule>();
        for (int row = 0; row < this.getEntrySize(); ++row) {
            eventRules.add((EventRule)this.getEntry(row));
        }
        return eventRules;
    }

    @Override
    public int getSelectedRow() {
        return this.selectedRow;
    }

    @Override
    public void setSelectedRow(int row) {
        this.selectedRow = row;
    }
}

