/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.view;

import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.DocumentDirtyListener;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ExFormattedTextField;
import com.intel.stl.ui.common.view.IntelButtonUI;
import com.intel.stl.ui.common.view.IntelTabbedPaneUI;
import com.intel.stl.ui.common.view.ProgressPanel;
import com.intel.stl.ui.common.view.RoundedCornersBorder;
import com.intel.stl.ui.main.view.IFabricView;
import com.intel.stl.ui.wizards.impl.ConfigTaskStatus;
import com.intel.stl.ui.wizards.impl.ConfigTaskType;
import com.intel.stl.ui.wizards.impl.IMultinetWizardListener;
import com.intel.stl.ui.wizards.impl.IMultinetWizardTask;
import com.intel.stl.ui.wizards.impl.IWizardListener;
import com.intel.stl.ui.wizards.impl.IWizardTask;
import com.intel.stl.ui.wizards.model.MultinetWizardModel;
import com.intel.stl.ui.wizards.view.IMultinetWizardView;
import com.intel.stl.ui.wizards.view.WizardControlType;
import com.intel.stl.ui.wizards.view.WizardViewType;
import com.intel.stl.ui.wizards.view.WizardWelcomeType;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.VerticalLayout;

public class MultinetWizardView
extends JDialog
implements IMultinetWizardView {
    private static final long serialVersionUID = 6898168781808453167L;
    public static final Color CONTENT_COLOR = UIConstants.INTEL_WHITE;
    public static final Color WIZARD_COLOR = UIConstants.INTEL_WHITE;
    public static final int DIALOG_WIDTH = 800;
    public static final int DIALOG_HEIGHT = 500;
    private static final String CLIENT_KEY = "SUBNET";
    private final int MAX_SUBNET_NAME_LEN = 56;
    private IMultinetWizardListener wizardListener;
    private JPanel pnlNavigation;
    private JPanel pnlNavigationButtons;
    private JPanel pnlSubwizard;
    private JPanel pnlMainCtrl;
    private JButton btnAddSubnet;
    private JButton btnDeleteSubnet;
    private JButton btnApply;
    private JButton btnReset;
    private JButton btnPrevious;
    private JButton btnNext;
    private JButton btnRun;
    private JButton btnClose;
    private JButton helpBtn;
    private JTabbedPane tabbedPane;
    private JPanel pnlMain;
    private JPanel pnlHeading;
    private JPanel pnlSubwizardCtrl;
    private JPanel pnlExistingSubnet;
    private ExFormattedTextField txtFldSubnetName;
    private Border originalSubnetNameBorder;
    private boolean nextSelected = false;
    private boolean subnetBtnSelected = false;
    private JButton btnSelected;
    private boolean manualSelect = false;
    private boolean newWizardInProgress = false;
    private final CardLayout wizardLayout = new CardLayout();
    private final CardLayout controlLayout = new CardLayout();
    private final CardLayout welcomeLayout = new CardLayout();
    private JPanel pnlWelcomeContent;
    private ProgressPanel progressPanel;
    private JLabel lblEntryValidation;
    private JLabel lblEntryValidationIcon;
    private JLabel lblEntryValidationStatus;
    private JLabel lblEntryValidationNotes;
    private JLabel lblHostReachability;
    private JLabel lblHostReachabilityIcon;
    private JLabel lblHostReachabilityStatus;
    private JLabel lblHostReachabilityNotes;
    private JLabel lblDatabaseUpdate;
    private JLabel lblDatabaseUpdateIcon;
    private JLabel lblDatabaseUpdateStatus;
    private JLabel lblDatabaseUpdateNotes;
    private JButton btnWelcomeOk;
    private JLabel lblWelcomeError;
    private boolean ignoreEditCheck;
    private WizardViewType wizardViewType;
    private boolean dirty;

    public MultinetWizardView(IFabricView owner) {
        super((JFrame)((Object)owner), STLConstants.K0667_CONFIG_SETUP_WIZARD.getValue(), true);
        this.initComponents();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MultinetWizardView.this.onClose(false);
            }
        });
    }

    protected void initComponents() {
        this.setResizable(false);
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.setLayout(new BorderLayout(5, 0));
        pnlContent.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY, 2, true));
        pnlContent.setPreferredSize(new Dimension(800, 500));
        JPanel pnlNavigation = this.getNavigationPanel();
        pnlContent.add((Component)pnlNavigation, "West");
        JPanel pnlMain = this.getConfPanel();
        pnlContent.add((Component)pnlMain, "Center");
        JPanel pnlMainCtrl = this.getControlPanel();
        pnlContent.add((Component)pnlMainCtrl, "South");
    }

    protected JPanel getNavigationPanel() {
        if (this.pnlNavigation == null) {
            this.pnlNavigation = new JPanel(new BorderLayout(5, 5));
            this.pnlNavigation.setBackground(UIConstants.INTEL_WHITE);
            this.pnlNavigation.setBorder(new RoundedCornersBorder(UIConstants.INTEL_BORDER_GRAY, 2, 5));
            JLabel pnlNavigationHeader = ComponentFactory.getH4Label(STLConstants.K3013_SUBNETS.getValue(), 1);
            pnlNavigationHeader.setHorizontalAlignment(0);
            pnlNavigationHeader.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, UIConstants.INTEL_ORANGE));
            this.pnlNavigation.add((Component)pnlNavigationHeader, "North");
            this.pnlNavigationButtons = new JPanel((LayoutManager)new VerticalLayout(2));
            this.pnlNavigationButtons.setName(WidgetName.SW_SUBNETS.name());
            JScrollPane scrpnNavigation = new JScrollPane(this.pnlNavigationButtons, 20, 30);
            scrpnNavigation.setBorder(null);
            scrpnNavigation.getVerticalScrollBar().setPreferredSize(new Dimension(10, 0));
            scrpnNavigation.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 10));
            scrpnNavigation.setPreferredSize(new Dimension(160, 500));
            this.pnlNavigation.add((Component)scrpnNavigation, "Center");
        }
        return this.pnlNavigation;
    }

    protected JPanel getConfPanel() {
        if (this.pnlMain == null) {
            this.pnlMain = new JPanel(this.wizardLayout);
            this.pnlMain.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY, 2, true));
            JPanel wizardPanel = this.getWizardPanel();
            this.pnlMain.add((Component)wizardPanel, WizardViewType.WIZARD.getName());
            JPanel pnlWelcome = this.createWelcomePanel();
            this.pnlMain.add((Component)pnlWelcome, WizardViewType.WELCOME.getName());
        }
        return this.pnlMain;
    }

    protected JPanel getWizardPanel() {
        if (this.pnlSubwizard == null) {
            this.pnlSubwizard = new JPanel(new BorderLayout());
            this.pnlSubwizard.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_WHITE, 5));
            JLabel lblSubnetName = ComponentFactory.getH5Label(STLConstants.K2111_NAME.getValue() + ":", 1);
            this.txtFldSubnetName = ComponentFactory.createTextField("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqsrtuvwxyz .-=_", false, 56, null);
            this.txtFldSubnetName.setName(WidgetName.SW_SUBNET_NAME.name());
            this.originalSubnetNameBorder = this.txtFldSubnetName.getBorder();
            this.txtFldSubnetName.getDocument().addDocumentListener(this.createDocumentListener());
            this.txtFldSubnetName.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MultinetWizardView.this.txtFldSubnetName.selectAll();
                        }
                    });
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (MultinetWizardView.this.btnSelected != null) {
                        String name = MultinetWizardView.this.txtFldSubnetName.getText();
                        MultinetWizardView.this.btnSelected.setText(name);
                    }
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MultinetWizardView.this.txtFldSubnetName.requestFocusInWindow();
                        }
                    });
                }
            });
            this.pnlHeading = new JPanel();
            this.pnlHeading.setBackground(CONTENT_COLOR);
            this.pnlHeading.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.insets = new Insets(3, 2, 5, 2);
            gc.weighty = 1.0;
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            this.pnlHeading.add((Component)lblSubnetName, gc);
            gc.weightx = 1.0;
            this.pnlHeading.add((Component)this.txtFldSubnetName, gc);
            gc.weighty = 1.0;
            gc.weightx = 0.0;
            gc.gridwidth = 0;
            this.helpBtn = ComponentFactory.getImageButton(UIImages.HELP_ICON.getImageIcon());
            this.helpBtn.setName(WidgetName.SW_HELP.name());
            this.helpBtn.setToolTipText(STLConstants.K0037_HELP.getValue());
            this.pnlHeading.add((Component)this.helpBtn, gc);
            this.pnlSubwizard.add((Component)this.pnlHeading, "North");
            this.tabbedPane = new JTabbedPane(){
                private static final long serialVersionUID = -4351718652903653728L;

                @Override
                public void setSelectedIndex(int index) {
                    if (MultinetWizardView.this.isEditValid()) {
                        super.setSelectedIndex(index);
                    }
                }
            };
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int tabIndex;
                    String str;
                    int maxIndex = MultinetWizardView.this.tabbedPane.getTabCount() - 1;
                    if (MultinetWizardView.this.tabbedPane.getSelectedIndex() == maxIndex) {
                        MultinetWizardView.this.btnPrevious.setEnabled(true);
                        str = STLConstants.K0627_FINISH.getValue();
                    } else {
                        str = STLConstants.K0622_NEXT.getValue();
                        if (MultinetWizardView.this.tabbedPane.getSelectedIndex() == 0) {
                            MultinetWizardView.this.btnPrevious.setEnabled(false);
                        }
                    }
                    MultinetWizardView.this.updateNextButton(str);
                    Component[] comps = MultinetWizardView.this.pnlNavigationButtons.getComponents();
                    if (!MultinetWizardView.this.nextSelected && !MultinetWizardView.this.subnetBtnSelected && comps.length > 0 && (tabIndex = MultinetWizardView.this.tabbedPane.getSelectedIndex()) >= 0) {
                        MultinetWizardView.this.wizardListener.setCurrentTask(tabIndex);
                        Component component = MultinetWizardView.this.tabbedPane.getTabComponentAt(tabIndex);
                        String tabName = component != null ? MultinetWizardView.this.tabbedPane.getTabComponentAt(tabIndex).getName() : null;
                        MultinetWizardView.this.wizardListener.onTab(tabName);
                    }
                }
            });
            this.tabbedPane.setUI(new IntelTabbedPaneUI());
            this.tabbedPane.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY, 2));
            this.pnlSubwizard.add(this.tabbedPane);
            this.pnlSubwizardCtrl = new JPanel(this.controlLayout);
            this.pnlSubwizardCtrl.setBackground(WIZARD_COLOR);
            this.pnlSubwizardCtrl.add((Component)this.creationControlPanel(), WizardControlType.CREATION.getName());
            this.pnlSubwizardCtrl.add((Component)this.existingControlPanel(), WizardControlType.EXISTING.getName());
            this.pnlSubwizard.add((Component)this.pnlSubwizardCtrl, "South");
        }
        return this.pnlSubwizard;
    }

    protected JPanel createWelcomePanel() {
        JPanel pnlWelcome = new JPanel(new BorderLayout());
        pnlWelcome.setBackground(WIZARD_COLOR);
        JLabel lblWelcome = ComponentFactory.getH2Label(STLConstants.K3019_WELCOME_MESSAGE.getValue(), 2);
        lblWelcome.setHorizontalAlignment(0);
        lblWelcome.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        pnlWelcome.add((Component)lblWelcome, "North");
        this.pnlWelcomeContent = new JPanel(this.welcomeLayout);
        pnlWelcome.add((Component)this.pnlWelcomeContent, "Center");
        JPanel pnlInstructions = this.createWelcomeInstructionsPanel();
        this.pnlWelcomeContent.add((Component)pnlInstructions, WizardWelcomeType.INSTRUCTIONS.getName());
        JPanel pnlStatus = this.createWelcomeStatusPanel();
        this.pnlWelcomeContent.add((Component)pnlStatus, WizardWelcomeType.STATUS.getName());
        JPanel pnlError = this.createWelcomeErrorPanel();
        this.pnlWelcomeContent.add((Component)pnlError, WizardWelcomeType.ERROR.getName());
        return pnlWelcome;
    }

    protected JPanel createWelcomeInstructionsPanel() {
        JPanel pnlInstructions = new JPanel(new GridBagLayout());
        pnlInstructions.setBackground(WIZARD_COLOR);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.weightx = 1.0;
        JLabel lblInstructions = ComponentFactory.getH3Label(UILabels.STL50083_WELCOME_MESSAGE.getDescription(), 2);
        lblInstructions.setHorizontalAlignment(0);
        pnlInstructions.add((Component)lblInstructions, gc);
        return pnlInstructions;
    }

    protected JPanel createWelcomeStatusPanel() {
        JPanel pnlStatus = new JPanel(new BorderLayout());
        pnlStatus.setBackground(WIZARD_COLOR);
        JPanel pnlContent = new JPanel();
        pnlContent.setLayout(new BoxLayout(pnlContent, 1));
        pnlContent.setBackground(WIZARD_COLOR);
        this.progressPanel = new ProgressPanel(false, null);
        this.progressPanel.setName(WidgetName.SW_VAL_PROGRESS.name());
        this.progressPanel.setBorder(BorderFactory.createEmptyBorder(20, 50, 20, 50));
        pnlContent.add(this.progressPanel);
        pnlContent.add(Box.createVerticalStrut(25));
        this.lblHostReachabilityIcon = new JLabel(UIImages.DASH.getImageIcon());
        this.lblHostReachabilityIcon.setName(WidgetName.SW_HOST_REACHABILITY_STATUS_ICON.name());
        this.lblHostReachability = ComponentFactory.getH3Label(STLConstants.K3022_HOST_CONNECTIVITY.getValue(), 2);
        this.lblHostReachability.setHorizontalAlignment(2);
        this.lblHostReachabilityStatus = ComponentFactory.getH3Label("**********", 2);
        this.lblHostReachabilityStatus.setName(WidgetName.SW_HOST_REACHABILITY_STATUS.name());
        this.lblHostReachabilityNotes = ComponentFactory.getH5Label("", 1);
        this.lblHostReachabilityNotes.setName(WidgetName.SW_HOST_REACHABILITY_NOTES.name());
        pnlContent.add(this.getStatusPanel(this.lblHostReachabilityIcon, this.lblHostReachability, this.lblHostReachabilityStatus, this.lblHostReachabilityNotes));
        pnlContent.add(Box.createVerticalStrut(50));
        this.lblEntryValidationIcon = new JLabel(UIImages.DASH.getImageIcon());
        this.lblEntryValidationIcon.setName(WidgetName.SW_ENTRY_VALIDATION_STATUS_ICON.name());
        this.lblEntryValidation = ComponentFactory.getH3Label(STLConstants.K3023_ENTRY_VALIDATION.getValue(), 2);
        this.lblEntryValidation.setHorizontalAlignment(2);
        this.lblEntryValidationStatus = ComponentFactory.getH3Label("**********", 2);
        this.lblEntryValidationStatus.setName(WidgetName.SW_ENTRY_VALIDATION_STATUS.name());
        this.lblEntryValidationNotes = ComponentFactory.getH5Label("", 1);
        this.lblEntryValidationNotes.setName(WidgetName.SW_ENTRY_VALIDATION_NOTES.name());
        pnlContent.add(this.getStatusPanel(this.lblEntryValidationIcon, this.lblEntryValidation, this.lblEntryValidationStatus, this.lblEntryValidationNotes));
        pnlContent.add(Box.createVerticalStrut(50));
        this.lblDatabaseUpdateIcon = new JLabel(UIImages.DASH.getImageIcon());
        this.lblDatabaseUpdateIcon.setName(WidgetName.SW_DB_UPDATE_STATUS_ICON.name());
        this.lblDatabaseUpdate = ComponentFactory.getH3Label(STLConstants.K3024_DATABASE_UPDATE.getValue(), 2);
        this.lblDatabaseUpdate.setHorizontalAlignment(2);
        this.lblDatabaseUpdateStatus = ComponentFactory.getH3Label("**********", 2);
        this.lblDatabaseUpdateStatus.setName(WidgetName.SW_DB_UPDATE_STATUS.name());
        this.lblDatabaseUpdateNotes = ComponentFactory.getH5Label("", 1);
        this.lblDatabaseUpdateNotes.setName(WidgetName.SW_DB_UPDATE_NOTES.name());
        pnlContent.add(this.getStatusPanel(this.lblDatabaseUpdateIcon, this.lblDatabaseUpdate, this.lblDatabaseUpdateStatus, this.lblDatabaseUpdateNotes));
        pnlContent.add(Box.createVerticalStrut(50));
        pnlStatus.add((Component)pnlContent, "North");
        JPanel pnlControl = new JPanel(new BorderLayout());
        pnlControl.setBackground(WIZARD_COLOR);
        pnlControl.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 2));
        this.btnWelcomeOk = ComponentFactory.getIntelActionButton(STLConstants.K0645_OK.getValue());
        this.btnWelcomeOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultinetWizardView.this.manualSelect = true;
                MultinetWizardView.this.setSelectedTask(0);
                MultinetWizardView.this.onSubnetButtonClick(MultinetWizardView.this.btnSelected);
            }
        });
        pnlControl.add((Component)this.btnWelcomeOk, "East");
        pnlStatus.add((Component)pnlControl, "South");
        return pnlStatus;
    }

    protected JPanel createWelcomeErrorPanel() {
        JPanel pnlError = new JPanel(new GridBagLayout());
        pnlError.setBackground(WIZARD_COLOR);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.weightx = 1.0;
        this.lblWelcomeError = ComponentFactory.getH3Label(UILabels.STL50094_WELCOME_ERROR.getDescription(), 2);
        this.lblWelcomeError.setName(WidgetName.SW_SUBNET_ERROR.name());
        this.lblWelcomeError.setHorizontalAlignment(0);
        this.lblWelcomeError.setVerticalAlignment(1);
        pnlError.add((Component)this.lblWelcomeError, gc);
        return pnlError;
    }

    protected JPanel getControlPanel() {
        if (this.pnlMainCtrl == null) {
            this.pnlMainCtrl = new JPanel();
            this.pnlMainCtrl.setLayout(new BoxLayout(this.pnlMainCtrl, 0));
            this.pnlMainCtrl.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
            this.btnAddSubnet = ComponentFactory.getIntelActionButton(" " + STLConstants.K3011_PLUS.getValue() + " ");
            this.btnAddSubnet.setName(WidgetName.SW_ADD_SUBNET.name());
            this.btnAddSubnet.setBorder(new RoundedCornersBorder(UIConstants.INTEL_BLUE, 1, 4));
            this.btnAddSubnet.setAlignmentX(0.0f);
            this.btnAddSubnet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MultinetWizardView.this.onAddSubnet();
                        }
                    });
                }
            });
            this.pnlMainCtrl.add(this.btnAddSubnet);
            this.pnlMainCtrl.add(Box.createHorizontalStrut(2));
            this.btnDeleteSubnet = ComponentFactory.getIntelActionButton(" " + STLConstants.K3012_MINUS.getValue() + " ");
            this.btnDeleteSubnet.setName(WidgetName.SW_DELETE_SUBNET.name());
            this.btnDeleteSubnet.setBorder(new RoundedCornersBorder(UIConstants.INTEL_BLUE, 1, 4));
            this.btnDeleteSubnet.setAlignmentX(0.0f);
            this.btnDeleteSubnet.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MultinetWizardView.this.ignoreEditCheck = true;
                        MultinetWizardView.this.onDeleteSubnet();
                    }
                    finally {
                        MultinetWizardView.this.ignoreEditCheck = false;
                    }
                }
            });
            this.pnlMainCtrl.add(this.btnDeleteSubnet);
            ComponentFactory.makeSameWidthButtons(new JButton[]{this.btnAddSubnet, this.btnDeleteSubnet});
            this.pnlMainCtrl.add(Box.createGlue());
            this.btnRun = ComponentFactory.getIntelActionButton(STLConstants.K3014_RUN.getValue());
            this.btnRun.setName(WidgetName.SW_RUN.name());
            this.btnRun.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultinetWizardView.this.onRun();
                }
            });
            this.btnRun.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                }
            });
            this.pnlMainCtrl.add(this.btnRun);
            this.pnlMainCtrl.add(Box.createHorizontalStrut(5));
            this.btnClose = ComponentFactory.getIntelActionButton(STLConstants.K0740_CLOSE.getValue());
            this.btnClose.setName(WidgetName.SW_CLOSE.name());
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultinetWizardView.this.onClose(false);
                }
            });
            this.pnlMainCtrl.add(this.btnClose);
            ComponentFactory.makeSameWidthButtons(new JButton[]{this.btnRun, this.btnClose});
        }
        return this.pnlMainCtrl;
    }

    private DocumentListener createDocumentListener() {
        DocumentDirtyListener listener = new DocumentDirtyListener(){

            @Override
            public void setDirty(DocumentEvent e) {
                MultinetWizardView.this.dirty = true;
                MultinetWizardView.this.wizardListener.setDirty(true);
            }
        };
        return listener;
    }

    public void setWelcomeOkEnabled(boolean enable) {
        this.btnWelcomeOk.setEnabled(enable);
    }

    protected JPanel getStatusPanel(JLabel ... labels) {
        int numLabels = labels.length;
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBackground(WIZARD_COLOR);
        JPanel pnlStatus = new JPanel();
        pnlStatus.setBackground(WIZARD_COLOR);
        pnlStatus.setAlignmentX(0.0f);
        pnlStatus.setLayout(new BoxLayout(pnlStatus, 0));
        for (int i = 0; i < numLabels - 1; ++i) {
            labels[i].setAlignmentX(0.0f);
            labels[i].setBorder(BorderFactory.createEmptyBorder(5, 60, 5, 65));
            pnlStatus.add(labels[i]);
        }
        mainPanel.add((Component)pnlStatus, "North");
        JPanel pnlNotes = new JPanel();
        pnlNotes.setBackground(WIZARD_COLOR);
        pnlNotes.setLayout(new BoxLayout(pnlNotes, 0));
        pnlNotes.add(Box.createHorizontalStrut(60));
        pnlNotes.add(labels[numLabels - 1]);
        mainPanel.add((Component)pnlNotes, "Center");
        return mainPanel;
    }

    protected void addGlue(JPanel panel, int direction) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 11;
        gc.fill = direction;
        gc.gridwidth = 0;
        gc.insets = new Insets(2, 2, 2, 2);
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        switch (direction) {
            case 3: {
                panel.add(Box.createVerticalGlue(), gc);
                break;
            }
            case 2: {
                panel.add(Box.createVerticalGlue(), gc);
            }
        }
    }

    protected JPanel existingControlPanel() {
        this.pnlExistingSubnet = new JPanel(new FlowLayout(4));
        this.pnlExistingSubnet.setOpaque(false);
        this.btnApply = ComponentFactory.getIntelActionButton(STLConstants.K0672_APPLY.getValue());
        this.btnApply.setName(WidgetName.SW_APPLY.name());
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MultinetWizardView.this.isEditValid()) {
                    return;
                }
                if (MultinetWizardView.this.tabbedPane.getSelectedIndex() >= 0) {
                    MultinetWizardView.this.wizardListener.setCurrentTask(MultinetWizardView.this.tabbedPane.getSelectedIndex());
                }
                MultinetWizardView.this.onFinish();
            }
        });
        this.btnApply.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((JButton)e.getSource()).requestFocusInWindow();
            }
        });
        this.pnlExistingSubnet.add((Component)this.btnApply, "East");
        this.btnReset = ComponentFactory.getIntelActionButton(STLConstants.K1006_RESET.getValue());
        this.btnReset.setName(WidgetName.SW_RESET.name());
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultinetWizardView.this.onReset();
            }
        });
        this.btnReset.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((JButton)e.getSource()).requestFocusInWindow();
            }
        });
        this.pnlExistingSubnet.add((Component)this.btnReset, "East");
        return this.pnlExistingSubnet;
    }

    protected JPanel creationControlPanel() {
        JPanel pnlCreateSubnet = new JPanel(new FlowLayout(4));
        pnlCreateSubnet.setOpaque(false);
        this.btnPrevious = ComponentFactory.getIntelActionButton(STLConstants.K0624_BACK.getValue());
        this.btnPrevious.setName(WidgetName.SW_PREVIOUS.name());
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultinetWizardView.this.onPrevious();
            }
        });
        pnlCreateSubnet.add((Component)this.btnPrevious, "East");
        this.btnNext = ComponentFactory.getIntelActionButton(STLConstants.K0622_NEXT.getValue());
        this.btnNext.setName(WidgetName.SW_NEXT.name());
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultinetWizardView.this.onNext();
            }
        });
        pnlCreateSubnet.add((Component)this.btnNext, "East");
        return pnlCreateSubnet;
    }

    public JButton getHelpButton() {
        return this.helpBtn;
    }

    @Override
    public void onEmailTest(String recipients) {
        this.wizardListener.onEmailTest(recipients);
    }

    @Override
    public void setSubnets(final List<SubnetDescription> subnets) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                MultinetWizardView.this.pnlNavigationButtons.removeAll();
                if (subnets != null) {
                    for (SubnetDescription subnet : subnets) {
                        JButton btn = MultinetWizardView.this.createSubnetButton();
                        btn.setText(subnet.getName());
                        btn.putClientProperty(MultinetWizardView.CLIENT_KEY, subnet);
                        MultinetWizardView.this.pnlNavigationButtons.add(btn);
                    }
                }
                MultinetWizardView.this.revalidate();
                MultinetWizardView.this.pnlNavigationButtons.repaint();
            }
        });
    }

    @Override
    public void addSubnet(final SubnetDescription subnet) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                JButton btn = MultinetWizardView.this.createSubnetButton();
                btn.setText(subnet.getName());
                btn.putClientProperty(MultinetWizardView.CLIENT_KEY, subnet);
                MultinetWizardView.this.pnlNavigationButtons.add(btn);
                MultinetWizardView.this.revalidate();
                MultinetWizardView.this.pnlNavigationButtons.repaint();
                MultinetWizardView.this.tabbedPane.setSelectedIndex(0);
                if (subnet.getSubnetId() == 0L) {
                    MultinetWizardView.this.updateNextButton(STLConstants.K0622_NEXT.getValue());
                }
                MultinetWizardView.this.txtFldSubnetName.setText(subnet.getName());
            }
        });
    }

    @Override
    public void resetSubnet(final SubnetDescription subnet) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                MultinetWizardView.this.btnSelected.putClientProperty(MultinetWizardView.CLIENT_KEY, subnet);
            }
        });
    }

    public void setNewWizardInProgress(boolean newWizardInProgress) {
        this.newWizardInProgress = newWizardInProgress;
    }

    public boolean getNewWizardStatus() {
        return this.newWizardInProgress;
    }

    private JButton createSubnetButton() {
        JButton btnUnknown = new JButton(STLConstants.K3018_UNKNOWN_SUBNET.getValue());
        btnUnknown.setUI(new IntelButtonUI(UIConstants.INTEL_MEDIUM_BLUE, UIConstants.INTEL_PALE_BLUE));
        btnUnknown.setHorizontalAlignment(10);
        btnUnknown.setFont(UIConstants.H4_FONT);
        btnUnknown.setRolloverEnabled(false);
        btnUnknown.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_GRAY), BorderFactory.createEmptyBorder(5, 10, 5, 5)));
        btnUnknown.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JButton buttonSource = (JButton)e.getSource();
                if (buttonSource.isEnabled()) {
                    MultinetWizardView.this.subnetBtnSelected = true;
                    MultinetWizardView.this.onSubnetButtonClick(buttonSource);
                }
                MultinetWizardView.this.subnetBtnSelected = false;
            }
        });
        return btnUnknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSubnetButtonClick(JButton buttonSource) {
        if (buttonSource == null || !this.isEditValid()) {
            return;
        }
        if (!this.manualSelect && buttonSource.equals(this.btnSelected)) {
            return;
        }
        this.manualSelect = false;
        if (this.newWizardInProgress || this.haveUnsavedChanges()) {
            int result = this.showWarningDialog(UILabels.STL50081_ABANDON_CHANGES_MESSAGE.getDescription());
            if (result == 1) {
                return;
            }
            this.onReset();
            this.btnAddSubnet.setEnabled(true);
            if (this.btnSelected != null && ((SubnetDescription)this.btnSelected.getClientProperty(CLIENT_KEY)).getSubnetId() == 0L) {
                this.newWizardCleanup();
            }
        }
        SubnetDescription subnet = (SubnetDescription)buttonSource.getClientProperty(CLIENT_KEY);
        this.ignoreEditCheck = true;
        try {
            this.wizardListener.onSelectSubnet(subnet);
        }
        catch (Exception e) {
            this.onSubnetError(buttonSource);
        }
        finally {
            this.ignoreEditCheck = false;
        }
    }

    private void onSubnetError(final JButton subnetButton) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                MultinetWizardView.this.btnRun.setEnabled(false);
                String subnetName = subnetButton.getText();
                MultinetWizardView.this.lblWelcomeError.setText(UILabels.STL50094_WELCOME_ERROR.getDescription(subnetName));
                MultinetWizardView.this.welcomeLayout.show(MultinetWizardView.this.pnlWelcomeContent, WizardWelcomeType.ERROR.getName());
                MultinetWizardView.this.wizardLayout.show(MultinetWizardView.this.pnlMain, WizardViewType.WELCOME.getName());
            }
        });
    }

    public void enableNavPanel(boolean enable) {
        for (Component c : this.pnlNavigationButtons.getComponents()) {
            c.setEnabled(enable);
        }
    }

    public void enableSubnetModifiers(boolean enable) {
        this.btnAddSubnet.setEnabled(enable);
        this.btnDeleteSubnet.setEnabled(enable);
        this.btnRun.setEnabled(enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAddSubnet() {
        try {
            boolean abandoningEdits = this.onAbandonEdits();
            if (!abandoningEdits) {
                return;
            }
            if (this.pnlNavigationButtons.getComponents().length == 0) {
                this.ignoreEditCheck = true;
                this.txtFldSubnetName.setBackground(UIConstants.INTEL_WHITE);
                this.txtFldSubnetName.setBorder(this.originalSubnetNameBorder);
            }
            if (!this.isEditValid()) {
                return;
            }
            this.btnAddSubnet.setEnabled(false);
            this.btnPrevious.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnRun.setEnabled(false);
            this.wizardListener.onNewSubnet();
            this.newWizardInProgress = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.ignoreEditCheck = false;
        }
    }

    private void onDeleteSubnet() {
        int result;
        if (this.btnSelected == null) {
            return;
        }
        int position = -1;
        boolean found = false;
        Component[] comps = this.pnlNavigationButtons.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            JButton btn = (JButton)comps[i];
            if (!btn.equals(this.btnSelected)) continue;
            position = i;
            found = true;
            break;
        }
        JButton nextBtn = null;
        if (found && (result = this.showWarningDialog(UILabels.STL50082_DELETE_SUBNET_MESSAGE.getDescription())) == 0) {
            this.newWizardInProgress = false;
            SubnetDescription subnet = (SubnetDescription)this.btnSelected.getClientProperty(CLIENT_KEY);
            this.wizardListener.deleteSubnet(subnet);
            if (position < comps.length - 1) {
                nextBtn = (JButton)comps[position + 1];
            } else if (comps.length > 0) {
                nextBtn = (JButton)comps[0];
            }
            this.pnlNavigationButtons.remove(this.btnSelected);
            this.revalidate();
            this.pnlNavigationButtons.repaint();
            comps = this.pnlNavigationButtons.getComponents();
            this.pnlHeading.setVisible(false);
            this.btnAddSubnet.setEnabled(true);
            if (nextBtn != null) {
                this.manualSelect = true;
                this.onSubnetButtonClick(nextBtn);
            }
        }
        if (comps.length == 0) {
            this.newWizardInProgress = false;
            this.btnApply.setEnabled(false);
            this.btnReset.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnRun.setEnabled(false);
            this.welcomeLayout.show(this.pnlWelcomeContent, WizardWelcomeType.INSTRUCTIONS.getName());
            this.wizardLayout.show(this.pnlMain, WizardViewType.WELCOME.getName());
        }
    }

    private void onApply(boolean finished) {
        if (this.isEditValid()) {
            this.wizardListener.onFinish();
        }
    }

    protected void onReset() {
        SubnetDescription subnet = (SubnetDescription)this.btnSelected.getClientProperty(CLIENT_KEY);
        String name = subnet.getName();
        this.btnSelected.setText(name);
        this.txtFldSubnetName.setText(name);
        this.wizardListener.onReset();
    }

    protected void onPrevious() {
        if (this.isEditValid()) {
            this.wizardListener.onPrevious();
        }
    }

    private void onNext() {
        if (!this.isEditValid()) {
            return;
        }
        if (this.isNextButton()) {
            if (this.wizardListener.getSubnetView().hasDuplicateHosts()) {
                Util.showErrorMessage(this, UILabels.STL50086_DUPLICATE_HOSTS.getDescription());
                return;
            }
            this.nextSelected = true;
            boolean success = this.wizardListener.onNext();
            if (success) {
                this.btnAddSubnet.setEnabled(true);
            }
        } else {
            this.onFinish();
        }
        this.nextSelected = false;
    }

    private void onFinish() {
        if (this.wizardListener.getSubnetView().hasDuplicateHosts()) {
            Util.showErrorMessage(this, UILabels.STL50086_DUPLICATE_HOSTS.getDescription());
            return;
        }
        String newName = this.txtFldSubnetName.getText();
        if (this.hasDuplicateSubnetNames(newName)) {
            Util.showErrorMessage(this, UILabels.STL50087_DUPLICATE_SUBNETS.getDescription());
            return;
        }
        this.btnSelected.setText(newName);
        this.pnlNavigationButtons.repaint();
        this.enableNavPanel(false);
        this.enableSubnetModifiers(false);
        this.initConfigLabels();
        this.welcomeLayout.show(this.pnlWelcomeContent, WizardWelcomeType.STATUS.getName());
        this.wizardLayout.show(this.pnlMain, WizardViewType.WELCOME.getName());
        this.wizardListener.onFinish();
    }

    protected boolean isEditValid() {
        if (this.ignoreEditCheck) {
            return true;
        }
        IWizardTask task = this.wizardListener.getCurrentTask();
        if (!(task == null || this.txtFldSubnetName.isEditValid() && task.isEditValid())) {
            this.showErrorMessage(STLConstants.K0030_ERROR.getValue(), UILabels.STL81053_INVALID_EDIT.getDescription());
            return false;
        }
        return true;
    }

    private boolean hasDuplicateSubnets() {
        HashSet<String> subnetNameSet = new HashSet<String>();
        for (Component comp : this.pnlNavigationButtons.getComponents()) {
            JButton btn = (JButton)comp;
            SubnetDescription subnet = (SubnetDescription)btn.getClientProperty(CLIENT_KEY);
            if (subnetNameSet.add(subnet.getName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDuplicateSubnetNames(String newName) {
        HashSet<String> subnetNameSet = new HashSet<String>();
        for (Component comp : this.pnlNavigationButtons.getComponents()) {
            SubnetDescription subnet;
            JButton btn = (JButton)comp;
            if (btn.equals(this.btnSelected) || subnetNameSet.add((subnet = (SubnetDescription)btn.getClientProperty(CLIENT_KEY)).getName().toLowerCase())) continue;
            return true;
        }
        return !subnetNameSet.add(newName.toLowerCase());
    }

    protected void initConfigLabels() {
        this.progressPanel.setProgress(0);
        this.progressPanel.setProgressNote("");
        this.lblHostReachabilityIcon.setIcon(UIImages.DASH.getImageIcon());
        this.lblHostReachabilityStatus.setText("**********");
        this.lblHostReachabilityNotes.setText("");
        this.lblEntryValidationIcon.setIcon(UIImages.DASH.getImageIcon());
        this.lblEntryValidationStatus.setText("**********");
        this.lblEntryValidationNotes.setText("");
        this.lblDatabaseUpdateIcon.setIcon(UIImages.DASH.getImageIcon());
        this.lblDatabaseUpdateStatus.setText("**********");
        this.lblDatabaseUpdateNotes.setText("");
    }

    public void updateConfigStatus(ConfigTaskStatus status) {
        ImageIcon icon = status.isSuccess() ? UIImages.CHECK_MARK.getImageIcon() : UIImages.X_MARK.getImageIcon();
        String resultStr = status.isSuccess() ? STLConstants.K3026_SUCCESSFUL.getValue() : STLConstants.K0020_FAILED.getValue();
        switch (status.getType()) {
            case CHECK_HOST: {
                icon = status.isSuccess() ? UIImages.CHECK_MARK.getImageIcon() : UIImages.WARNING2_ICON.getImageIcon();
                this.lblHostReachabilityIcon.setIcon(icon);
                this.lblHostReachabilityStatus.setText(resultStr);
                if (status.isSuccess()) break;
                this.lblHostReachabilityNotes.setText(UILabels.STL50088_HOST_NOT_FOUND.getDescription());
                break;
            }
            case VALIDATE_ENTRY: {
                icon = status.isSuccess() ? UIImages.CHECK_MARK.getImageIcon() : UIImages.WARNING2_ICON.getImageIcon();
                this.lblEntryValidationIcon.setIcon(icon);
                this.lblEntryValidationStatus.setText(resultStr);
                if (status.isSuccess()) break;
                List<? extends Exception> errors = status.getErrors();
                StringBuffer sb = new StringBuffer("<html>");
                for (Exception exception : errors) {
                    sb.append(exception.getMessage() + "<br>");
                }
                sb.append("<html>");
                this.lblEntryValidationNotes.setText(sb.toString());
                break;
            }
            case UPDATE_DATABASE: {
                this.lblDatabaseUpdateIcon.setIcon(icon);
                this.lblDatabaseUpdateStatus.setText(resultStr);
                if (!status.isSuccess()) {
                    this.lblDatabaseUpdateNotes.setText(UILabels.STL50090_DB_SAVE_FAILURE.getDescription());
                }
                this.setProgress(ConfigTaskType.CONFIGURATION_COMPLETE);
                break;
            }
        }
    }

    public void setProgress(ConfigTaskType taskType) {
        switch (taskType) {
            case CHECK_HOST: {
                this.progressPanel.setProgress(33);
                break;
            }
            case VALIDATE_ENTRY: {
                this.progressPanel.setProgress(66);
                break;
            }
            case UPDATE_DATABASE: {
                this.progressPanel.setProgress(99);
                break;
            }
            case CONFIGURATION_COMPLETE: {
                this.progressPanel.setProgress(100);
            }
        }
        this.progressPanel.setProgressNote(taskType.getName());
    }

    private void onRun() {
        if (!this.isEditValid()) {
            return;
        }
        if (this.haveUnsavedChanges()) {
            this.onApply(true);
        }
        if (this.newWizardInProgress) {
            this.controlLayout.show(this.pnlSubwizardCtrl, WizardControlType.EXISTING.getName());
        }
        if (this.wizardListener.onRun()) {
            this.onClose(true);
        }
    }

    private void onClose(boolean running) {
        boolean okayToClose = true;
        if (this.newWizardInProgress) {
            int result = this.showWarningDialog(UILabels.STL50081_ABANDON_CHANGES_MESSAGE.getDescription());
            if (result == 0) {
                this.onReset();
                this.newWizardCleanup();
                okayToClose = true;
            } else {
                okayToClose = false;
            }
        } else if (!running && this.haveUnsavedChanges()) {
            int result = this.showWarningDialog(UILabels.STL50081_ABANDON_CHANGES_MESSAGE.getDescription());
            if (result == 0) {
                this.onReset();
                this.newWizardCleanup();
                okayToClose = true;
            } else {
                okayToClose = false;
            }
        }
        if (okayToClose) {
            this.enableNavPanel(true);
            this.enableSubnetModifiers(true);
            this.wizardListener.closeStatusPanels();
            this.btnSelected = null;
            this.closeWizard();
            if (!running) {
                this.wizardListener.cancelConfiguration();
            }
        }
    }

    private boolean haveUnsavedChanges() {
        return this.wizardListener.haveUnsavedChanges();
    }

    protected boolean onAbandonEdits() {
        boolean abandoningEdits = true;
        if (this.haveUnsavedChanges()) {
            int result = this.showWarningDialog(UILabels.STL50081_ABANDON_CHANGES_MESSAGE.getDescription());
            if (result == 0) {
                abandoningEdits = true;
                this.onReset();
            } else {
                abandoningEdits = false;
            }
        }
        return abandoningEdits;
    }

    protected int showWarningDialog(String message) {
        int result = Util.showConfirmDialog(this, message);
        return result;
    }

    private void newWizardCleanup() {
        this.newWizardInProgress = false;
        this.pnlNavigationButtons.remove(this.btnSelected);
        this.revalidate();
        this.pnlNavigationButtons.repaint();
        this.wizardListener.clearTasks();
    }

    @Override
    public boolean nextTab() {
        int maxIndex;
        boolean result = false;
        int currentIndex = this.tabbedPane.getSelectedIndex();
        if (currentIndex == (maxIndex = this.tabbedPane.getTabCount() - 1)) {
            result = false;
        } else if (0 <= currentIndex && currentIndex < maxIndex) {
            int newIndex = currentIndex + 1;
            this.tabbedPane.setEnabledAt(newIndex, true);
            this.tabbedPane.setSelectedIndex(newIndex);
            result = true;
        }
        return result;
    }

    @Override
    public boolean previousTab() {
        boolean result = false;
        int currentIndex = this.tabbedPane.getSelectedIndex();
        if (currentIndex == 0) {
            result = true;
        } else if (currentIndex > 0) {
            int newIndex = currentIndex - 1;
            this.tabbedPane.setSelectedIndex(newIndex);
            if (newIndex == 0) {
                this.btnPrevious.setEnabled(false);
            }
            result = true;
        }
        return result;
    }

    private void centerDialog(IFabricView mainFrame) {
        this.pack();
        Point dialogLocation = new Point(0, 0);
        dialogLocation.x = mainFrame.getScreenPosition().x + mainFrame.getScreenSize().width / 2 - this.getWidth() / 2;
        dialogLocation.y = mainFrame.getScreenPosition().y + mainFrame.getScreenSize().height / 2 - this.getHeight() / 2;
        this.setLocation(dialogLocation);
    }

    @Override
    public void showWizard(SubnetDescription subnet, boolean isFirstRun, final IFabricView mainFrame) {
        Util.runInEDT(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String type = MultinetWizardView.this.wizardViewType.getName();
                    MultinetWizardView.this.wizardLayout.show(MultinetWizardView.this.pnlMain, type);
                    MultinetWizardView.this.btnNext.setEnabled(false);
                    MultinetWizardView.this.btnRun.setEnabled(false);
                    if (MultinetWizardView.this.wizardViewType == WizardViewType.WIZARD) {
                        MultinetWizardView.this.pnlHeading.setVisible(true);
                    } else {
                        MultinetWizardView.this.pnlHeading.setVisible(false);
                    }
                    MultinetWizardView.this.manualSelect = true;
                    MultinetWizardView.this.onSubnetButtonClick(MultinetWizardView.this.btnSelected);
                }
                finally {
                    MultinetWizardView.this.centerDialog(mainFrame);
                    MultinetWizardView.this.showWindow(true);
                }
            }
        });
    }

    private void showWindow(boolean show) {
        this.setVisible(true);
    }

    @Override
    public void showTaskView(String name) {
    }

    @Override
    public void enablePrevious(boolean enable) {
        this.btnPrevious.setEnabled(enable);
    }

    @Override
    public void enableNext(boolean enable) {
        this.btnNext.setEnabled(enable);
    }

    @Override
    public void enableApply(boolean enable) {
        this.btnApply.setEnabled(enable);
    }

    @Override
    public void enableReset(boolean enable) {
        this.btnReset.setEnabled(enable);
    }

    @Override
    public void enableRun(boolean enable) {
        this.btnRun.setEnabled(enable);
    }

    @Override
    public void closeWizard() {
        this.setVisible(false);
    }

    @Override
    public void updateNextButton(String name) {
        this.btnNext.setText(name);
    }

    @Override
    public boolean isNextButton() {
        return this.btnNext.getText().equals(STLConstants.K0622_NEXT.getValue());
    }

    @Override
    public void update(MultinetWizardModel model) {
    }

    @Override
    public void setWizardListener(IWizardListener listener) {
    }

    @Override
    public void setWizardListener(IMultinetWizardListener listener) {
        this.wizardListener = listener;
    }

    @Override
    public void showErrorMessage(String title, String ... msgs) {
        StringBuffer message = new StringBuffer();
        for (String msg : msgs) {
            if (message.length() == 0) {
                message.append(msg);
                continue;
            }
            message.append("\n" + msg);
        }
        Util.showErrorMessage(this, message.toString());
    }

    @Override
    public void showErrorMessage(String title, Throwable ... errors) {
        Util.showErrors(this, Arrays.asList(errors));
    }

    @Override
    public void setSelectedSubnet(final SubnetDescription subnet) {
        final Component[] comps = this.pnlNavigationButtons.getComponents();
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                MultinetWizardView.this.btnSelected = null;
                MultinetWizardView.this.dirty = false;
                MultinetWizardView.this.txtFldSubnetName.setText(subnet.getName());
                for (Component comp : comps) {
                    JButton btn = (JButton)comp;
                    SubnetDescription btnSubnet = (SubnetDescription)btn.getClientProperty(MultinetWizardView.CLIENT_KEY);
                    if (btnSubnet.equals(subnet)) {
                        MultinetWizardView.this.btnSelected = btn;
                        btn.setBackground(UIConstants.INTEL_LIGHT_BLUE);
                        btn.setForeground(UIConstants.INTEL_WHITE);
                        continue;
                    }
                    btn.setBackground(UIConstants.INTEL_WHITE);
                    btn.setForeground(UIConstants.INTEL_DARK_GRAY);
                }
                MultinetWizardView.this.resetButtons(subnet.getSubnetId() == 0L);
                MultinetWizardView.this.txtFldSubnetName.requestFocusInWindow();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetButtons(boolean isNewSubnet) {
        this.ignoreEditCheck = true;
        try {
            this.stopSubnetConnectionTest();
            this.pnlHeading.setVisible(true);
            this.wizardLayout.show(this.pnlMain, WizardViewType.WIZARD.getName());
            WizardControlType controlType = isNewSubnet ? WizardControlType.CREATION : WizardControlType.EXISTING;
            this.controlLayout.show(this.pnlSubwizardCtrl, controlType.getName());
            this.btnApply.setEnabled(false);
            this.btnReset.setEnabled(false);
            if (isNewSubnet) {
                this.setEnableForAllTasks(false);
                this.tabbedPane.setEnabledAt(0, true);
                this.btnRun.setEnabled(false);
            } else {
                this.setEnableForAllTasks(true);
                this.btnRun.setEnabled(true);
            }
        }
        finally {
            this.ignoreEditCheck = false;
        }
    }

    @Override
    public void setTasks(List<IMultinetWizardTask> tasks) {
        this.tabbedPane.removeAll();
        for (IMultinetWizardTask task : tasks) {
            this.tabbedPane.add(task.getName(), task.getView());
        }
    }

    @Override
    public void setEnableForAllTasks(boolean enable) {
        int tabs = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabs; ++i) {
            this.tabbedPane.setEnabledAt(i, enable);
        }
    }

    @Override
    public int getSelectedTask() {
        return this.tabbedPane.getSelectedIndex();
    }

    @Override
    public void setSelectedTask(int taskNum) {
        if (0 <= taskNum && taskNum < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setEnabledAt(taskNum, true);
            this.tabbedPane.setSelectedIndex(taskNum);
        }
    }

    @Override
    public void setWizardViewType(WizardViewType type) {
        this.wizardViewType = type;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public String getSubnetName() {
        return this.txtFldSubnetName.getText();
    }

    @Override
    public void stopSubnetConnectionTest() {
        this.wizardListener.getSubnetView().stopConnectionTest();
    }

    @Override
    public boolean isEmailValid(String email) {
        return this.wizardListener.isEmailValid(email);
    }
}

