/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.wizards.impl.IWizardTask;
import com.intel.stl.ui.wizards.impl.InteractionType;
import com.intel.stl.ui.wizards.view.IStatusView;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jdesktop.swingx.JXCollapsiblePane;

public class StatusPanel
extends JXCollapsiblePane
implements IStatusView {
    private static final long serialVersionUID = 7169689232956883008L;
    private IWizardTask wizardTaskController;
    private boolean isStatusOpen = true;
    private JTextArea txtAreaStatus;
    private JButton collapseButton;
    private Object[] data;
    private JPanel pnlAnswer;
    private InteractionType action;
    private final int maxHeight;

    public StatusPanel() {
        this.initComponents();
        this.maxHeight = this.getPreferredSize().height;
        this.closeStatusPanel();
        this.setAnimated(true);
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.collapseButton = new JButton(this.getActionMap().get("toggle"));
        this.txtAreaStatus = new JTextArea(3, 30);
        this.txtAreaStatus.setOpaque(true);
        this.txtAreaStatus.setEditable(false);
        this.txtAreaStatus.setLineWrap(true);
        this.txtAreaStatus.setWrapStyleWord(true);
        this.txtAreaStatus.setFont(UIConstants.H5_FONT.deriveFont(1));
        this.txtAreaStatus.setBorder(BorderFactory.createLoweredBevelBorder());
        this.txtAreaStatus.setBackground(UIConstants.INTEL_RED);
        this.add(this.txtAreaStatus, "Center");
        this.pnlAnswer = new JPanel();
        this.pnlAnswer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlAnswer.setOpaque(false);
        this.pnlAnswer.setLayout(new GridLayout(2, 5, 0, 5));
        JButton btnYes = ComponentFactory.getIntelActionButton(STLConstants.K0081_YES.getValue());
        btnYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.wizardTaskController.doInteractiveAction(StatusPanel.this.action, StatusPanel.this.data);
            }
        });
        this.pnlAnswer.add(btnYes);
        JButton btnNo = ComponentFactory.getIntelActionButton(STLConstants.K0082_NO.getValue());
        btnNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.wizardTaskController.setDone(false);
                StatusPanel.this.closeStatusPanel();
                StatusPanel.this.wizardTaskController.doInteractiveAction(StatusPanel.this.action, new Object[]{null});
            }
        });
        this.pnlAnswer.add(btnNo);
        this.add(this.pnlAnswer, "East");
    }

    @Override
    public void openStatusPanel() {
        if (!this.isStatusOpen) {
            this.collapseButton.doClick();
            this.isStatusOpen = true;
        }
    }

    @Override
    public void closeStatusPanel() {
        if (this.isStatusOpen) {
            this.collapseButton.doClick();
            this.isStatusOpen = false;
        }
    }

    @Override
    public void toggleStatusPanel() {
        this.collapseButton.doClick();
        this.isStatusOpen = !this.isStatusOpen;
    }

    @Override
    public void showMessage(String message, InteractionType action, int messageType, Object ... data) {
        this.action = action;
        boolean interactive = action != null;
        this.data = data;
        this.pnlAnswer.setVisible(interactive);
        this.setMessageType(messageType);
        this.txtAreaStatus.setText(message);
        this.openStatusPanel();
    }

    protected void setMessageType(int messageType) {
        if (messageType == 0) {
            this.txtAreaStatus.setBackground(UIConstants.INTEL_RED);
            this.txtAreaStatus.setForeground(UIConstants.INTEL_DARK_GRAY);
        } else if (messageType == 2) {
            this.txtAreaStatus.setBackground(UIConstants.INTEL_LIGHT_YELLOW);
            this.txtAreaStatus.setForeground(UIConstants.INTEL_DARK_GRAY);
        } else {
            this.txtAreaStatus.setBackground(UIConstants.INTEL_DARK_GREEN);
            this.txtAreaStatus.setForeground(UIConstants.INTEL_DARK_GRAY);
        }
    }

    @Override
    public void setWizardTaskController(IWizardTask wizardTaskController) {
        this.wizardTaskController = wizardTaskController;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }
}

