/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.xml;

import com.intel.stl.api.configuration.PropertyCategory;
import com.intel.stl.api.configuration.PropertyGroup;
import com.intel.stl.api.configuration.ResourceCategory;
import com.intel.stl.api.configuration.ResourceType;
import com.intel.stl.xml.GroupType;
import com.intel.stl.xml.HfiCategory;
import com.intel.stl.xml.HfiCategoryType;
import com.intel.stl.xml.HfiGroupType;
import com.intel.stl.xml.HfiType;
import com.intel.stl.xml.PortCategory;
import com.intel.stl.xml.PortCategoryType;
import com.intel.stl.xml.PortGroupType;
import com.intel.stl.xml.PortType;
import com.intel.stl.xml.PropertiesDisplay;
import com.intel.stl.xml.ResourceCategoryType;
import com.intel.stl.xml.ResourceClassType;
import com.intel.stl.xml.SwitchCategory;
import com.intel.stl.xml.SwitchCategoryType;
import com.intel.stl.xml.SwitchGroupType;
import com.intel.stl.xml.SwitchType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.MarshalException;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class PropertiesDisplayAdapter
extends XmlAdapter<PropertiesDisplay, Map<ResourceType, List<PropertyGroup>>> {
    public Map<ResourceType, List<PropertyGroup>> unmarshal(PropertiesDisplay displayOptions) throws Exception {
        HashMap<ResourceType, List<PropertyGroup>> options = new HashMap<ResourceType, List<PropertyGroup>>();
        List<ResourceClassType> resources = displayOptions.getResourceClassTypes();
        for (ResourceClassType resource : resources) {
            ResourceType resourceType = resource.getResourceType();
            List<GroupType> groups = resource.getGroups();
            ArrayList<PropertyGroup> propertyGroups = new ArrayList<PropertyGroup>(groups.size());
            for (GroupType group : groups) {
                PropertyGroup propertyGroup = new PropertyGroup();
                propertyGroup.setName(group.getName());
                propertyGroup.setTitle(group.getTitle());
                propertyGroup.setDisplayed(group.getDisplayed());
                List<ResourceCategoryType> categories = group.getCategory();
                ArrayList<PropertyCategory> resourceCategories = new ArrayList<PropertyCategory>(categories.size());
                for (ResourceCategoryType category : categories) {
                    PropertyCategory resourceCategory = new PropertyCategory();
                    resourceCategory.setResourceCategory(category.getResourceCategory());
                    resourceCategory.setKeyHeader(category.getValue());
                    resourceCategory.setShowHeader(category.isShowHeader());
                    resourceCategory.setValueHeader(category.getValueHeader());
                    resourceCategories.add(resourceCategory);
                }
                propertyGroup.setCategories(resourceCategories);
                propertyGroups.add(propertyGroup);
            }
            options.put(resourceType, propertyGroups);
        }
        return options;
    }

    public PropertiesDisplay marshal(Map<ResourceType, List<PropertyGroup>> options) throws Exception {
        PropertiesDisplay displayOptions = new PropertiesDisplay();
        List<ResourceClassType> classTypes = displayOptions.getResourceClassTypes();
        for (ResourceType resourceType : options.keySet()) {
            ResourceClassType resource;
            List<PropertyGroup> groups = options.get((Object)resourceType);
            switch (resourceType) {
                case HFI: {
                    resource = new HfiType();
                    resource.setGroups(this.createGroups(groups, new HfiTypeFactory()));
                    break;
                }
                case PORT: {
                    resource = new PortType();
                    resource.setGroups(this.createGroups(groups, new PortTypeFactory()));
                    break;
                }
                case SWITCH: {
                    resource = new SwitchType();
                    resource.setGroups(this.createGroups(groups, new SwitchTypeFactory()));
                    break;
                }
                default: {
                    resource = null;
                }
            }
            classTypes.add(resource);
        }
        return displayOptions;
    }

    private List<GroupType> createGroups(List<PropertyGroup> propertyGroups, XmlTypeFactory factory) throws Exception {
        ArrayList<GroupType> groups = new ArrayList<GroupType>(propertyGroups.size());
        for (PropertyGroup propertyGroup : propertyGroups) {
            GroupType group = factory.createGroupTypeFrom(propertyGroup);
            List<PropertyCategory> propertyCategories = propertyGroup.getCategories();
            if (propertyCategories != null) {
                List<ResourceCategoryType> categories = group.getCategory();
                for (PropertyCategory propertyCategory : propertyCategories) {
                    ResourceCategoryType category = factory.createResourceCategoryTypeFrom(propertyCategory);
                    categories.add(category);
                }
            }
            groups.add(group);
        }
        return groups;
    }

    private class SwitchTypeFactory
    extends XmlTypeFactory {
        private SwitchTypeFactory() {
        }

        @Override
        public GroupType createGroupTypeFrom(PropertyGroup group) {
            SwitchGroupType switchGroup = new SwitchGroupType();
            this.populateGroupType(switchGroup, group);
            return switchGroup;
        }

        @Override
        public ResourceCategoryType createResourceCategoryTypeFrom(PropertyCategory category) throws MarshalException {
            SwitchCategoryType switchCategory = new SwitchCategoryType();
            this.populateResourceCategoryType(switchCategory, category);
            ResourceCategory rc = category.getResourceCategory();
            if (rc != null) {
                SwitchCategory value = SwitchCategory.fromValue(rc.name());
                switchCategory.setName(value);
            }
            return switchCategory;
        }
    }

    private class PortTypeFactory
    extends XmlTypeFactory {
        private PortTypeFactory() {
        }

        @Override
        public GroupType createGroupTypeFrom(PropertyGroup group) {
            PortGroupType portGroup = new PortGroupType();
            this.populateGroupType(portGroup, group);
            return portGroup;
        }

        @Override
        public ResourceCategoryType createResourceCategoryTypeFrom(PropertyCategory category) throws Exception {
            PortCategoryType portCategory = new PortCategoryType();
            this.populateResourceCategoryType(portCategory, category);
            ResourceCategory rc = category.getResourceCategory();
            if (rc != null) {
                PortCategory value = PortCategory.fromValue(rc.name());
                portCategory.setName(value);
            }
            return portCategory;
        }
    }

    private class HfiTypeFactory
    extends XmlTypeFactory {
        private HfiTypeFactory() {
        }

        @Override
        public GroupType createGroupTypeFrom(PropertyGroup group) {
            HfiGroupType hfiGroup = new HfiGroupType();
            this.populateGroupType(hfiGroup, group);
            return hfiGroup;
        }

        @Override
        public ResourceCategoryType createResourceCategoryTypeFrom(PropertyCategory category) throws Exception {
            HfiCategoryType hfiCategory = new HfiCategoryType();
            this.populateResourceCategoryType(hfiCategory, category);
            ResourceCategory rc = category.getResourceCategory();
            if (rc != null) {
                HfiCategory value = HfiCategory.fromValue(rc.name());
                hfiCategory.setName(value);
            }
            return hfiCategory;
        }
    }

    private abstract class XmlTypeFactory {
        private XmlTypeFactory() {
        }

        protected void populateGroupType(GroupType groupType, PropertyGroup group) {
            groupType.setName(group.getName());
            groupType.setTitle(group.getTitle());
            groupType.setDisplayed(group.isDisplayed());
        }

        protected void populateResourceCategoryType(ResourceCategoryType categoryType, PropertyCategory category) {
            categoryType.setShowHeader(category.isShowHeader());
            categoryType.setValue(category.getKeyHeader());
            categoryType.setValueHeader(category.getValueHeader());
        }

        protected abstract GroupType createGroupTypeFrom(PropertyGroup var1);

        protected abstract ResourceCategoryType createResourceCategoryTypeFrom(PropertyCategory var1) throws Exception;
    }
}

