/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import com.mxgraph.io.mxCodecRegistry;
import com.mxgraph.model.mxCellPath;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxBase64;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxHtmlColor;
import com.mxgraph.util.mxLightweightLabel;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxStyleUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxCellState;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.text.html.HTMLDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class mxUtils {
    public static boolean IS_MAC = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    public static boolean IS_LINUX = System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0;
    protected static transient Graphics fontGraphics;

    public static mxRectangle getLabelSize(String string, Map<String, Object> map, boolean bl, double d) {
        return mxUtils.getLabelSize(string, map, bl, d, 0.0);
    }

    public static mxRectangle getLabelSize(String string, Map<String, Object> map, boolean bl, double d, double d2) {
        mxRectangle mxRectangle2 = bl ? mxUtils.getSizeForHtml(mxUtils.getBodyMarkup(string, true), map, d, d2) : mxUtils.getSizeForString(string, mxUtils.getFont(map), d);
        return mxRectangle2;
    }

    public static String getBodyMarkup(String string, boolean bl) {
        int n;
        String string2 = string.toLowerCase();
        int n2 = string2.indexOf("<body>");
        if (n2 >= 0 && (n = string2.lastIndexOf("</body>")) > (n2 += 7)) {
            string = string.substring(n2, n).trim();
        }
        if (bl) {
            string = string.replaceAll("\n", "<br>");
        }
        return string;
    }

    public static mxRectangle getLabelPaintBounds(String string, Map<String, Object> map, boolean bl, mxPoint mxPoint2, mxRectangle mxRectangle2, double d) {
        return mxUtils.getLabelPaintBounds(string, map, bl, mxPoint2, mxRectangle2, d, false);
    }

    public static mxRectangle getLabelPaintBounds(String string, Map<String, Object> map, boolean bl, mxPoint mxPoint2, mxRectangle mxRectangle2, double d, boolean bl2) {
        double d2 = 0.0;
        if (bl && mxRectangle2 != null && mxUtils.getString(map, mxConstants.STYLE_WHITE_SPACE, "nowrap").equals("wrap")) {
            d2 = mxRectangle2.getWidth();
        }
        mxRectangle mxRectangle3 = mxUtils.getLabelSize(string, map, bl, d, d2);
        mxRectangle3.setWidth(mxRectangle3.getWidth() / d);
        mxRectangle3.setHeight(mxRectangle3.getHeight() / d);
        double d3 = mxPoint2.getX();
        double d4 = mxPoint2.getY();
        double d5 = 0.0;
        double d6 = 0.0;
        if (mxRectangle2 != null) {
            d3 += mxRectangle2.getX();
            d4 += mxRectangle2.getY();
            if (mxUtils.getString(map, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                boolean bl3 = mxUtils.isTrue(map, mxConstants.STYLE_HORIZONTAL, true);
                double d7 = mxUtils.getDouble(map, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * d;
                if (bl3) {
                    d5 += mxRectangle2.getWidth();
                    d6 += d7;
                } else {
                    d5 += d7;
                    d6 += mxRectangle2.getHeight();
                }
            } else {
                d5 += bl2 ? 0.0 : mxRectangle2.getWidth();
                d6 += mxRectangle2.getHeight();
            }
        }
        return mxUtils.getScaledLabelBounds(d3, d4, mxRectangle3, d5, d6, map, d);
    }

    public static mxRectangle getScaledLabelBounds(double d, double d2, mxRectangle mxRectangle2, double d3, double d4, Map<String, Object> map, double d5) {
        double d6 = (double)mxConstants.LABEL_INSET * d5;
        double d7 = mxRectangle2.getWidth() * d5 + 2.0 * d6;
        double d8 = mxRectangle2.getHeight() * d5 + 2.0 * d6;
        boolean bl = mxUtils.isTrue(map, mxConstants.STYLE_HORIZONTAL, true);
        int n = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_SPACING) * d5);
        String string = mxUtils.getString(map, mxConstants.STYLE_ALIGN, "center");
        String string2 = mxUtils.getString(map, mxConstants.STYLE_VERTICAL_ALIGN, "middle");
        int n2 = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_SPACING_TOP) * d5);
        int n3 = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_SPACING_BOTTOM) * d5);
        int n4 = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_SPACING_LEFT) * d5);
        int n5 = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_SPACING_RIGHT) * d5);
        if (!bl) {
            int n6 = n2;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n6;
            double d9 = d7;
            d7 = d8;
            d8 = d9;
        }
        d = bl && string.equals("center") || !bl && string2.equals("middle") ? (d += (d3 - d7) / 2.0 + (double)n4 - (double)n5) : (bl && string.equals("right") || !bl && string2.equals("bottom") ? (d += d3 - d7 - (double)n - (double)n5) : (d += (double)(n + n4)));
        d2 = !bl && string.equals("center") || bl && string2.equals("middle") ? (d2 += (d4 - d8) / 2.0 + (double)n2 - (double)n3) : (!bl && string.equals("left") || bl && string2.equals("bottom") ? (d2 += d4 - d8 - (double)n - (double)n3) : (d2 += (double)(n + n2)));
        return new mxRectangle(d, d2, d7, d8);
    }

    public static FontMetrics getFontMetrics(Font font) {
        if (fontGraphics != null) {
            return fontGraphics.getFontMetrics(font);
        }
        return null;
    }

    public static mxRectangle getSizeForString(String string, Font font, double d) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        font = font.deriveFont((float)((double)font.getSize2D() * d));
        FontMetrics fontMetrics = null;
        if (fontGraphics != null) {
            fontMetrics = fontGraphics.getFontMetrics(font);
        }
        double d2 = mxConstants.LINESPACING;
        d2 = fontMetrics != null ? (d2 += (double)fontMetrics.getHeight()) : (d2 += (double)font.getSize2D() * 1.27);
        String[] stringArray = string.split("\n");
        Rectangle2D rectangle2D = null;
        if (stringArray.length == 0) {
            rectangle2D = font.getStringBounds("", fontRenderContext);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                Rectangle2D rectangle2D2 = font.getStringBounds(stringArray[i], fontRenderContext);
                if (rectangle2D == null) {
                    rectangle2D = rectangle2D2;
                    continue;
                }
                rectangle2D.setFrame(0.0, 0.0, Math.max(rectangle2D.getWidth(), rectangle2D2.getWidth()), rectangle2D.getHeight() + d2);
            }
        }
        return new mxRectangle(rectangle2D);
    }

    public static String[] wordWrap(String string, FontMetrics fontMetrics, double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 0;
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray2 = stringArray[i].split("\\s+");
            Stack<String> stack = new Stack<String>();
            for (int j = stringArray2.length - 1; j >= 0; --j) {
                stack.push(stringArray2[j]);
            }
            block2: while (!stack.isEmpty()) {
                double d2;
                String string2 = (String)stack.pop();
                int n3 = 0;
                if (string2.length() > 0) {
                    char c = string2.charAt(0);
                    int n4 = stringArray[i].indexOf(c, n2);
                    String string3 = stringArray[i].substring(n2, n4);
                    n3 = string3.length();
                    string2 = string3.concat(string2);
                }
                if ((double)n + (d2 = n > 0 ? (double)fontMetrics.stringWidth(string2) : (double)fontMetrics.stringWidth(string2.trim())) > d) {
                    if (n > 0) {
                        arrayList.add(stringBuilder.toString());
                        stringBuilder = new StringBuilder();
                        stack.push(string2.trim());
                        n = 0;
                        continue;
                    }
                    if (mxConstants.SPLIT_WORDS) {
                        string2 = string2.trim();
                        for (int j = 1; j <= string2.length(); ++j) {
                            d2 = fontMetrics.stringWidth(string2.substring(0, j));
                            if (!((double)n + d2 > d)) continue;
                            j = j > 1 ? j - 1 : j;
                            String string4 = string2.substring(0, j);
                            stringBuilder = stringBuilder.append(string4);
                            stack.push(string2.substring(j, string2.length()));
                            arrayList.add(stringBuilder.toString());
                            stringBuilder = new StringBuilder();
                            n = 0;
                            n2 = n2 + string4.length() + n3;
                            continue block2;
                        }
                        continue;
                    }
                    string2 = string2.trim();
                    arrayList.add(string2);
                    stringBuilder = new StringBuilder();
                    n = 0;
                    n2 = string2.length() + n3;
                    continue;
                }
                stringBuilder = n > 0 ? stringBuilder.append(string2) : stringBuilder.append(string2.trim());
                n = (int)((double)n + d2);
                n2 += string2.length();
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static mxRectangle getSizeForHtml(String string, Map<String, Object> map, double d, double d2) {
        mxLightweightLabel mxLightweightLabel2 = mxLightweightLabel.getSharedInstance();
        if (mxLightweightLabel2 != null) {
            mxLightweightLabel2.setText(mxUtils.createHtmlDocument(map, string));
            Dimension dimension = mxLightweightLabel2.getPreferredSize();
            if (d2 > 0.0) {
                mxLightweightLabel2.setText(mxUtils.createHtmlDocument(map, string, 1.0, (int)Math.ceil(d2 - (double)mxConstants.LABEL_INSET * d)));
                Dimension dimension2 = mxLightweightLabel2.getPreferredSize();
                if (dimension2.width < dimension.width) {
                    dimension = dimension2;
                }
            }
            return new mxRectangle(0.0, 0.0, (double)dimension.width * d, (double)dimension.height * d);
        }
        return mxUtils.getSizeForString(string, mxUtils.getFont(map), d);
    }

    public static double[] arcToCurves(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        d8 -= d;
        d9 -= d2;
        if (d3 == 0.0 || d4 == 0.0) {
            return new double[0];
        }
        double d18 = d7;
        double d19 = d5;
        d3 = Math.abs(d3);
        d4 = Math.abs(d4);
        double d20 = -d8 / 2.0;
        double d21 = -d9 / 2.0;
        double d22 = Math.cos(d19 * Math.PI / 180.0);
        double d23 = d22 * d20 + (d17 = Math.sin(d19 * Math.PI / 180.0)) * d21;
        double d24 = d23 * d23;
        double d25 = d24 / (d16 = d3 * d3) + (d15 = (d14 = -1.0 * d17 * d20 + d22 * d21) * d14) / (d13 = d4 * d4);
        if (d25 > 1.0) {
            d3 = Math.sqrt(d25) * d3;
            d4 = Math.sqrt(d25) * d4;
            d12 = 0.0;
        } else {
            d11 = 1.0;
            if (d6 == d18) {
                d11 = -1.0;
            }
            d12 = d11 * Math.sqrt((d16 * d13 - d16 * d15 - d13 * d24) / (d16 * d15 + d13 * d24));
        }
        d11 = d12 * d3 * d14 / d4;
        double d26 = -1.0 * d12 * d4 * d23 / d3;
        double d27 = d22 * d11 - d17 * d26 + d8 / 2.0;
        double d28 = d17 * d11 + d22 * d26 + d9 / 2.0;
        double d29 = Math.atan2((d14 - d26) / d4, (d23 - d11) / d3) - Math.atan2(0.0, 1.0);
        double d30 = d29 >= 0.0 ? d29 : Math.PI * 2 + d29;
        d29 = Math.atan2((-d14 - d26) / d4, (-d23 - d11) / d3) - Math.atan2((d14 - d26) / d4, (d23 - d11) / d3);
        double d31 = d10 = d29 >= 0.0 ? d29 : Math.PI * 2 + d29;
        if (d18 == 0.0 && d10 > 0.0) {
            d10 -= Math.PI * 2;
        } else if (d18 != 0.0 && d10 < 0.0) {
            d10 += Math.PI * 2;
        }
        double d32 = d10 * 2.0 / Math.PI;
        int n = (int)Math.ceil(d32 < 0.0 ? -1.0 * d32 : d32);
        double d33 = d10 / (double)n;
        double d34 = 2.0 * Math.sin(d33 / 4.0) * Math.sin(d33 / 4.0) / Math.sin(d33 / 2.0);
        double d35 = d22 * d3;
        double d36 = d22 * d4;
        double d37 = d17 * d3;
        double d38 = d17 * d4;
        double d39 = Math.cos(d30);
        double d40 = Math.sin(d30);
        double d41 = -d34 * (d35 * d40 + d38 * d39);
        double d42 = -d34 * (d37 * d40 - d36 * d39);
        double d43 = 0.0;
        double d44 = 0.0;
        double[] dArray = new double[n * 6];
        for (int i = 0; i < n; ++i) {
            d39 = Math.cos(d30 += d33);
            d40 = Math.sin(d30);
            d43 = d35 * d39 - d38 * d40 + d27;
            d44 = d37 * d39 + d36 * d40 + d28;
            double d45 = -d34 * (d35 * d40 + d38 * d39);
            double d46 = -d34 * (d37 * d40 - d36 * d39);
            int n2 = i * 6;
            dArray[n2] = d41 + d;
            dArray[n2 + 1] = d42 + d2;
            dArray[n2 + 2] = d43 - d45 + d;
            dArray[n2 + 3] = d44 - d46 + d2;
            dArray[n2 + 4] = d43 + d;
            dArray[n2 + 5] = d44 + d2;
            d41 = d43 + d45;
            d42 = d44 + d46;
        }
        return dArray;
    }

    public static mxRectangle getBoundingBox(mxRectangle mxRectangle2, double d) {
        mxRectangle mxRectangle3 = null;
        if (mxRectangle2 != null && d != 0.0) {
            double d2 = Math.toRadians(d);
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            mxPoint mxPoint2 = new mxPoint(mxRectangle2.getX() + mxRectangle2.getWidth() / 2.0, mxRectangle2.getY() + mxRectangle2.getHeight() / 2.0);
            mxPoint mxPoint3 = new mxPoint(mxRectangle2.getX(), mxRectangle2.getY());
            mxPoint mxPoint4 = new mxPoint(mxRectangle2.getX() + mxRectangle2.getWidth(), mxRectangle2.getY());
            mxPoint mxPoint5 = new mxPoint(mxPoint4.getX(), mxRectangle2.getY() + mxRectangle2.getHeight());
            mxPoint mxPoint6 = new mxPoint(mxRectangle2.getX(), mxPoint5.getY());
            mxPoint3 = mxUtils.getRotatedPoint(mxPoint3, d3, d4, mxPoint2);
            mxPoint4 = mxUtils.getRotatedPoint(mxPoint4, d3, d4, mxPoint2);
            mxPoint5 = mxUtils.getRotatedPoint(mxPoint5, d3, d4, mxPoint2);
            mxPoint6 = mxUtils.getRotatedPoint(mxPoint6, d3, d4, mxPoint2);
            Rectangle rectangle = new Rectangle((int)mxPoint3.getX(), (int)mxPoint3.getY(), 0, 0);
            rectangle.add(mxPoint4.getPoint());
            rectangle.add(mxPoint5.getPoint());
            rectangle.add(mxPoint6.getPoint());
            mxRectangle3 = new mxRectangle(rectangle);
        } else if (mxRectangle2 != null) {
            mxRectangle3 = (mxRectangle)mxRectangle2.clone();
        }
        return mxRectangle3;
    }

    public static int firstCharAt(String string, int n, int n2) {
        int n3 = 0;
        while (n3 >= 0) {
            n3 = string.indexOf(n, n2);
            if (n3 == 0) {
                return n3;
            }
            if (n3 <= 0) continue;
            if (Character.isLetter(string.codePointAt(n3 - 1))) {
                if (++n2 >= string.length()) {
                    return -1;
                }
                n3 = string.indexOf(n, n2);
                continue;
            }
            return n3;
        }
        return n3;
    }

    public static mxPoint getRotatedPoint(mxPoint mxPoint2, double d, double d2) {
        return mxUtils.getRotatedPoint(mxPoint2, d, d2, new mxPoint());
    }

    public static int findNearestSegment(mxCellState mxCellState2, double d, double d2) {
        int n = -1;
        if (mxCellState2.getAbsolutePointCount() > 0) {
            mxPoint mxPoint2 = mxCellState2.getAbsolutePoint(0);
            double d3 = Double.MAX_VALUE;
            for (int i = 1; i < mxCellState2.getAbsolutePointCount(); ++i) {
                mxPoint mxPoint3 = mxCellState2.getAbsolutePoint(i);
                double d4 = new Line2D.Double(mxPoint2.x, mxPoint2.y, mxPoint3.x, mxPoint3.y).ptSegDistSq(d, d2);
                if (d4 < d3) {
                    d3 = d4;
                    n = i - 1;
                }
                mxPoint2 = mxPoint3;
            }
        }
        return n;
    }

    public static mxPoint getRotatedPoint(mxPoint mxPoint2, double d, double d2, mxPoint mxPoint3) {
        double d3 = mxPoint2.getX() - mxPoint3.getX();
        double d4 = mxPoint2.getY() - mxPoint3.getY();
        double d5 = d3 * d - d4 * d2;
        double d6 = d4 * d + d3 * d2;
        return new mxPoint(d5 + mxPoint3.getX(), d6 + mxPoint3.getY());
    }

    public static int getPortConstraints(mxCellState mxCellState2, mxCellState mxCellState3, boolean bl) {
        return mxUtils.getPortConstraints(mxCellState2, mxCellState3, bl, 15);
    }

    public static int getPortConstraints(mxCellState mxCellState2, mxCellState mxCellState3, boolean bl, int n) {
        Object object = mxCellState2.getStyle().get(mxConstants.STYLE_PORT_CONSTRAINT);
        if (object == null) {
            return n;
        }
        String string = object.toString();
        int n2 = 0;
        if (string.indexOf("north") >= 0) {
            n2 |= 2;
        }
        if (string.indexOf("west") >= 0) {
            n2 |= 1;
        }
        if (string.indexOf("south") >= 0) {
            n2 |= 4;
        }
        if (string.indexOf("east") >= 0) {
            n2 |= 8;
        }
        return n2;
    }

    public static int reversePortConstraints(int n) {
        int n2 = 0;
        n2 = (n & 1) << 3;
        n2 |= (n & 2) << 1;
        n2 |= (n & 4) >> 1;
        return n2 |= (n & 8) >> 3;
    }

    public static void drawImageClip(Graphics graphics, BufferedImage bufferedImage, ImageObserver imageObserver) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int n3 = Math.max(0, Math.min(rectangle.x, n));
            int n4 = Math.max(0, Math.min(rectangle.y, n2));
            n = Math.min(rectangle.width, n - n3);
            n2 = Math.min(rectangle.height, n2 - n4);
            if (n > 0 && n2 > 0) {
                graphics.drawImage(bufferedImage.getSubimage(n3, n4, n, n2), rectangle.x, rectangle.y, imageObserver);
            }
        } else {
            graphics.drawImage(bufferedImage, 0, 0, imageObserver);
        }
    }

    public static void fillClippedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        try {
            if (graphics.getClipBounds() != null) {
                rectangle = rectangle.intersection(graphics.getClipBounds());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static List<mxPoint> translatePoints(List<mxPoint> list, double d, double d2) {
        ArrayList<mxPoint> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<mxPoint>(list.size());
            Iterator<mxPoint> iterator = list.iterator();
            while (iterator.hasNext()) {
                mxPoint mxPoint2 = (mxPoint)iterator.next().clone();
                mxPoint2.setX(mxPoint2.getX() + d);
                mxPoint2.setY(mxPoint2.getY() + d2);
                arrayList.add(mxPoint2);
            }
        }
        return arrayList;
    }

    public static mxPoint intersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d8 - d6) * (d3 - d) - (d7 - d5) * (d4 - d2);
        double d10 = (d7 - d5) * (d2 - d6) - (d8 - d6) * (d - d5);
        double d11 = (d3 - d) * (d2 - d6) - (d4 - d2) * (d - d5);
        double d12 = d10 / d9;
        double d13 = d11 / d9;
        if (d12 >= 0.0 && d12 <= 1.0 && d13 >= 0.0 && d13 <= 1.0) {
            double d14 = d + d12 * (d3 - d);
            double d15 = d2 + d12 * (d4 - d2);
            return new mxPoint(d14, d15);
        }
        return null;
    }

    public static Object[] sortCells(Object[] objectArray, boolean bl) {
        return mxUtils.sortCells(Arrays.asList(objectArray), bl).toArray();
    }

    public static Collection<Object> sortCells(Collection<Object> collection, final boolean bl) {
        TreeSet<Object> treeSet = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                int n = mxCellPath.compare(mxCellPath.create((mxICell)object), mxCellPath.create((mxICell)object2));
                return n == 0 ? 0 : (n > 0 == bl ? 1 : -1);
            }
        });
        treeSet.addAll(collection);
        return treeSet;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        return mxUtils.indexOf(objectArray, object) >= 0;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        if (object != null && objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != object) continue;
                return i;
            }
        }
        return -1;
    }

    public static String getStylename(String string) {
        return mxStyleUtils.getStylename(string);
    }

    public static String[] getStylenames(String string) {
        return mxStyleUtils.getStylenames(string);
    }

    public static int indexOfStylename(String string, String string2) {
        return mxStyleUtils.indexOfStylename(string, string2);
    }

    public static String removeAllStylenames(String string) {
        return mxStyleUtils.removeAllStylenames(string);
    }

    public static void setCellStyles(mxIGraphModel mxIGraphModel2, Object[] objectArray, String string, String string2) {
        mxStyleUtils.setCellStyles(mxIGraphModel2, objectArray, string, string2);
    }

    public static String setStyle(String string, String string2, String string3) {
        return mxStyleUtils.setStyle(string, string2, string3);
    }

    public static void setCellStyleFlags(mxIGraphModel mxIGraphModel2, Object[] objectArray, String string, int n, Boolean bl) {
        mxStyleUtils.setCellStyleFlags(mxIGraphModel2, objectArray, string, n, bl);
    }

    public static String setStyleFlag(String string, String string2, int n, Boolean bl) {
        return mxStyleUtils.setStyleFlag(string, string2, n, bl);
    }

    public static boolean intersectsHotspot(mxCellState mxCellState2, int n, int n2, double d) {
        return mxUtils.intersectsHotspot(mxCellState2, n, n2, d, 0, 0);
    }

    public static boolean intersectsHotspot(mxCellState mxCellState2, int n, int n2, double d, int n3, int n4) {
        if (d > 0.0) {
            int n5;
            int n6 = (int)Math.round(mxCellState2.getCenterX());
            int n7 = (int)Math.round(mxCellState2.getCenterY());
            int n8 = (int)Math.round(mxCellState2.getWidth());
            int n9 = (int)Math.round(mxCellState2.getHeight());
            if (mxUtils.getString(mxCellState2.getStyle(), mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                n5 = mxUtils.getInt(mxCellState2.getStyle(), mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE);
                if (mxUtils.isTrue(mxCellState2.getStyle(), mxConstants.STYLE_HORIZONTAL, true)) {
                    n7 = (int)Math.round(mxCellState2.getY() + (double)(n5 / 2));
                    n9 = n5;
                } else {
                    n6 = (int)Math.round(mxCellState2.getX() + (double)(n5 / 2));
                    n8 = n5;
                }
            }
            n5 = (int)Math.max((double)n3, (double)n8 * d);
            int n10 = (int)Math.max((double)n3, (double)n9 * d);
            if (n4 > 0) {
                n5 = Math.min(n5, n4);
                n10 = Math.min(n10, n4);
            }
            Rectangle rectangle = new Rectangle(Math.round(n6 - n5 / 2), Math.round(n7 - n10 / 2), n5, n10);
            return rectangle.contains(n, n2);
        }
        return true;
    }

    public static boolean isTrue(Map<String, Object> map, String string) {
        return mxUtils.isTrue(map, string, false);
    }

    public static boolean isTrue(Map<String, Object> map, String string, boolean bl) {
        Object object = map.get(string);
        if (object == null) {
            return bl;
        }
        return object.equals("1") || object.toString().toLowerCase().equals("true");
    }

    public static int getInt(Map<String, Object> map, String string) {
        return mxUtils.getInt(map, string, 0);
    }

    public static int getInt(Map<String, Object> map, String string, int n) {
        Object object = map.get(string);
        if (object == null) {
            return n;
        }
        return (int)Float.parseFloat(object.toString());
    }

    public static float getFloat(Map<String, Object> map, String string) {
        return mxUtils.getFloat(map, string, 0.0f);
    }

    public static float getFloat(Map<String, Object> map, String string, float f) {
        Object object = map.get(string);
        if (object == null) {
            return f;
        }
        return Float.parseFloat(object.toString());
    }

    public static float[] getFloatArray(Map<String, Object> map, String string, float[] fArray) {
        return mxUtils.getFloatArray(map, string, fArray, ",");
    }

    public static float[] getFloatArray(Map<String, Object> map, String string, float[] fArray, String string2) {
        Object object = map.get(string);
        if (object == null) {
            return fArray;
        }
        String[] stringArray = object.toString().split(string2);
        float[] fArray2 = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fArray2[i] = Float.parseFloat(stringArray[i]);
        }
        return fArray2;
    }

    public static double getDouble(Map<String, Object> map, String string) {
        return mxUtils.getDouble(map, string, 0.0);
    }

    public static double getDouble(Map<String, Object> map, String string, double d) {
        Object object = map.get(string);
        if (object == null) {
            return d;
        }
        return Double.parseDouble(object.toString());
    }

    public static String getString(Map<String, Object> map, String string) {
        return mxUtils.getString(map, string, null);
    }

    public static String getString(Map<String, Object> map, String string, String string2) {
        Object object = map.get(string);
        if (object == null) {
            return string2;
        }
        return object.toString();
    }

    public static Color getColor(Map<String, Object> map, String string) {
        return mxUtils.getColor(map, string, null);
    }

    public static Color getColor(Map<String, Object> map, String string, Color color) {
        Object object = map.get(string);
        if (object == null) {
            return color;
        }
        return mxUtils.parseColor(object.toString());
    }

    public static Font getFont(Map<String, Object> map) {
        return mxUtils.getFont(map, 1.0);
    }

    public static Font getFont(Map<String, Object> map, double d) {
        String string = mxUtils.getString(map, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILY);
        int n = mxUtils.getInt(map, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE);
        int n2 = mxUtils.getInt(map, mxConstants.STYLE_FONTSTYLE);
        int n3 = (n2 & 1) == 1 ? 1 : 0;
        return new Font(string, n3 += (n2 & 2) == 2 ? 2 : 0, (int)((double)n * d));
    }

    public static String hexString(Color color) {
        return mxHtmlColor.hexString(color);
    }

    public static Color parseColor(String string) throws NumberFormatException {
        return mxHtmlColor.parseColor(string);
    }

    public static Color parseColor(String string, double d) throws NumberFormatException {
        return mxHtmlColor.parseColor(string, d);
    }

    public static String getHexColorString(Color color) {
        return mxHtmlColor.getHexColorString(color);
    }

    public static float[] parseDashPattern(String string) throws NumberFormatException {
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(" ");
            float[] fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                float f = Float.parseFloat(stringArray[i]);
                if (!(f > 0.0f)) {
                    throw new NumberFormatException("Dash width must be positive");
                }
                fArray[i] = f;
            }
            return fArray;
        }
        return null;
    }

    public static String readFile(String string) throws IOException {
        return mxUtils.readInputStream(new FileInputStream(string));
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuffer.append(string + "\n");
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static void writeFile(String string, String string2) throws IOException {
        FileWriter fileWriter = new FileWriter(string2);
        fileWriter.write(string);
        fileWriter.flush();
        fileWriter.close();
    }

    public static String getMd5Hash(String string) {
        StringBuffer stringBuffer = new StringBuffer(32);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            Formatter formatter = new Formatter(stringBuffer);
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < byArray.length; ++i) {
                formatter.format("%02x", new Byte(byArray[i]));
            }
            formatter.close();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static boolean isNode(Object object, String string) {
        return mxUtils.isNode(object, string, null, null);
    }

    public static boolean isNode(Object object, String string, String string2, String string3) {
        if (object instanceof Element) {
            Element element = (Element)object;
            if (string == null || element.getNodeName().equalsIgnoreCase(string)) {
                String string4 = string2 != null ? element.getAttribute(string2) : null;
                return string2 == null || string4 != null && string4.equals(string3);
            }
        }
        return false;
    }

    public static void setAntiAlias(Graphics2D graphics2D, boolean bl, boolean bl2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, bl ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl2 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public static void clearRect(Graphics2D graphics2D, Rectangle rectangle, Color color) {
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setComposite(AlphaComposite.SrcOver);
        }
    }

    public static BufferedImage createBufferedImage(int n, int n2, Color color) {
        return mxUtils.createBufferedImage(n, n2, color, color != null ? 1 : 2);
    }

    public static BufferedImage createBufferedImage(int n, int n2, Color color, int n3) {
        BufferedImage bufferedImage = null;
        if (n > 0 && n2 > 0) {
            bufferedImage = new BufferedImage(n, n2, n3);
            if (color != null) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                mxUtils.clearRect(graphics2D, new Rectangle(n, n2), color);
                graphics2D.dispose();
            }
        }
        return bufferedImage;
    }

    public static BufferedImage loadImage(String string) {
        BufferedImage bufferedImage = null;
        if (string != null) {
            if (string.startsWith("data:image/")) {
                try {
                    int n = string.indexOf(44);
                    byte[] byArray = mxBase64.decode(string.substring(n + 1));
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    bufferedImage = ImageIO.read(byteArrayInputStream);
                }
                catch (Exception exception) {}
            } else {
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (Exception exception) {
                    uRL = mxUtils.class.getResource(string);
                }
                if (uRL != null) {
                    try {
                        bufferedImage = ImageIO.read(uRL);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return bufferedImage;
    }

    public static Element createTable(Document document, String string, int n, int n2, int n3, int n4, double d, Map<String, Object> map) {
        Element element = document.createElement("table");
        if (string != null && string.length() > 0) {
            float f;
            String string2;
            String string3;
            Element element2 = document.createElement("tr");
            Element element3 = document.createElement("td");
            element.setAttribute("cellspacing", "0");
            element.setAttribute("border", "0");
            element3.setAttribute("align", mxUtils.getString(map, mxConstants.STYLE_ALIGN, "center"));
            String string4 = mxUtils.getString(map, mxConstants.STYLE_FONTCOLOR, "black");
            String string5 = mxUtils.getString(map, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES);
            int n5 = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * d);
            String string6 = "position:absolute;left:" + String.valueOf(n) + "px;" + "top:" + String.valueOf(n2) + "px;" + "width:" + String.valueOf(n3) + "px;" + "height:" + String.valueOf(n4) + "px;" + "font-size:" + String.valueOf(n5) + "px;" + "font-family:" + string5 + ";" + "color:" + string4 + ";";
            if (mxUtils.getString(map, mxConstants.STYLE_WHITE_SPACE, "nowrap").equals("wrap")) {
                string6 = string6 + "white-space:normal;";
            }
            if ((string3 = mxUtils.getString(map, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR)) != null) {
                string6 = string6 + "background:" + string3 + ";";
            }
            if ((string2 = mxUtils.getString(map, mxConstants.STYLE_LABEL_BORDERCOLOR)) != null) {
                string6 = string6 + "border:" + string2 + " solid 1pt;";
            }
            if ((f = mxUtils.getFloat(map, mxConstants.STYLE_TEXT_OPACITY, 100.0f)) < 100.0f) {
                string6 = string6 + "filter:alpha(opacity=" + f + ");";
                string6 = string6 + "opacity:" + f / 100.0f + ";";
            }
            element3.setAttribute("style", string6);
            String[] stringArray = string.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                element3.appendChild(document.createTextNode(stringArray[i]));
                element3.appendChild(document.createElement("br"));
            }
            element2.appendChild(element3);
            element.appendChild(element2);
        }
        return element;
    }

    public static Document createDocument() {
        return mxDomUtils.createDocument();
    }

    public static Document createSvgDocument(int n, int n2) {
        return mxDomUtils.createSvgDocument(n, n2);
    }

    public static Document createVmlDocument() {
        return mxDomUtils.createVmlDocument();
    }

    public static Document createHtmlDocument() {
        return mxDomUtils.createHtmlDocument();
    }

    public static String createHtmlDocument(Map<String, Object> map, String string) {
        return mxUtils.createHtmlDocument(map, string, 1.0, 0);
    }

    public static String createHtmlDocument(Map<String, Object> map, String string, double d) {
        return mxUtils.createHtmlDocument(map, string, d, 0);
    }

    public static String createHtmlDocument(Map<String, Object> map, String string, double d, int n) {
        return mxUtils.createHtmlDocument(map, string, d, n, null);
    }

    public static String createHtmlDocument(Map<String, Object> map, String string, double d, int n, String string2) {
        return mxUtils.createHtmlDocument(map, string, d, n, null, null);
    }

    public static String createHtmlDocument(Map<String, Object> map, String string, double d, int n, String string2, String string3) {
        String string4;
        int n2;
        StringBuffer stringBuffer = string3 != null ? new StringBuffer(string3) : new StringBuffer();
        stringBuffer.append("font-family:" + mxUtils.getString(map, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES) + ";");
        stringBuffer.append("font-size:" + (int)((double)mxUtils.getInt(map, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * d) + "pt;");
        String string5 = mxUtils.getString(map, mxConstants.STYLE_FONTCOLOR);
        if (string5 != null) {
            stringBuffer.append("color:" + string5 + ";");
        }
        if (((n2 = mxUtils.getInt(map, mxConstants.STYLE_FONTSTYLE)) & 1) == 1) {
            stringBuffer.append("font-weight:bold;");
        }
        if ((n2 & 2) == 2) {
            stringBuffer.append("font-style:italic;");
        }
        if ((n2 & 4) == 4) {
            stringBuffer.append("text-decoration:underline;");
        }
        if ((string4 = mxUtils.getString(map, mxConstants.STYLE_ALIGN, "left")).equals("center")) {
            stringBuffer.append("text-align:center;");
        } else if (string4.equals("right")) {
            stringBuffer.append("text-align:right;");
        }
        if (n > 0) {
            stringBuffer.append("width:" + n + "pt;");
        }
        String string6 = "<html>";
        if (string2 != null) {
            string6 = string6 + "<head>" + string2 + "</head>";
        }
        return string6 + "<body style=\"" + stringBuffer.toString() + "\">" + string + "</body></html>";
    }

    public static HTMLDocument createHtmlDocumentObject(Map<String, Object> map, double d) {
        String string;
        int n;
        HTMLDocument hTMLDocument = new HTMLDocument();
        StringBuffer stringBuffer = new StringBuffer("body {");
        stringBuffer.append("font-family:" + mxUtils.getString(map, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES) + ";");
        stringBuffer.append("font-size:" + (int)((double)mxUtils.getInt(map, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * d) + "pt;");
        String string2 = mxUtils.getString(map, mxConstants.STYLE_FONTCOLOR);
        if (string2 != null) {
            stringBuffer.append("color:" + string2 + ";");
        }
        if (((n = mxUtils.getInt(map, mxConstants.STYLE_FONTSTYLE)) & 1) == 1) {
            stringBuffer.append("font-weight:bold;");
        }
        if ((n & 2) == 2) {
            stringBuffer.append("font-style:italic;");
        }
        if ((n & 4) == 4) {
            stringBuffer.append("text-decoration:underline;");
        }
        if ((string = mxUtils.getString(map, mxConstants.STYLE_ALIGN, "left")).equals("center")) {
            stringBuffer.append("text-align:center;");
        } else if (string.equals("right")) {
            stringBuffer.append("text-align:right;");
        }
        stringBuffer.append("}");
        hTMLDocument.getStyleSheet().addRule(stringBuffer.toString());
        return hTMLDocument;
    }

    public static Document loadDocument(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Document parseXml(String string) {
        return mxXmlUtils.parseXml(string);
    }

    public static Object eval(String string) {
        Class<?> clazz;
        int n = string.lastIndexOf(".");
        if (n > 0 && (clazz = mxCodecRegistry.getClassForName(string.substring(0, n))) != null) {
            try {
                return clazz.getField(string.substring(n + 1)).get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static Node findNode(Node node, String string, String string2) {
        String string3;
        String string4 = string3 = node instanceof Element ? ((Element)node).getAttribute(string) : null;
        if (string3 != null && string3.equals(string2)) {
            return node;
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node node2 = mxUtils.findNode(node, string, string2);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    public static String htmlEntities(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&prime;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String getXml(Node node) {
        return mxXmlUtils.getXml(node);
    }

    public static String getPrettyXml(Node node) {
        return mxUtils.getPrettyXml(node, "  ", "");
    }

    public static String getPrettyXml(Node node, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (node != null) {
            if (node.getNodeType() == 3) {
                stringBuffer.append(node.getNodeValue());
            } else {
                Node node2;
                stringBuffer.append(string2 + "<" + node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        String string3 = namedNodeMap.item(i).getNodeValue();
                        string3 = mxUtils.htmlEntities(string3);
                        stringBuffer.append(" " + namedNodeMap.item(i).getNodeName() + "=\"" + string3 + "\"");
                    }
                }
                if ((node2 = node.getFirstChild()) != null) {
                    stringBuffer.append(">\n");
                    while (node2 != null) {
                        stringBuffer.append(mxUtils.getPrettyXml(node2, string, string2 + string));
                        node2 = node2.getNextSibling();
                    }
                    stringBuffer.append(string2 + "</" + node.getNodeName() + ">\n");
                } else {
                    stringBuffer.append("/>\n");
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        try {
            fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

