#!/bin/bash
#
# Intel VCA Software Stack (VCASS)
#
# Copyright(c) 2017 Intel Corporation.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License, version 2, as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# The full GNU General Public License is included in this distribution in
# the file called "COPYING".
#
# Intel VCA Scripts.
#
set -eu

STEP="$1"			; shift
PHASE="$1"			; shift
ARCHIVE_DIR="$1"	; shift
SCRIPTS_DIR="$1"	; shift
CHROOT_DIR="$1"		; shift

. "${SCRIPTS_DIR}/library_image_creation.sh"

# TODO: reconsider bind mounting (ro?rw?) before running the pre/postadd scripts. This requires ARCHIVE_DIR relative to CHROOT_DIR
CHROOT_MSS_MNT_POINT="$(cd "${CHROOT_DIR}"; mktemp --directory --tmpdir=./tmp mss_mount_point.XXXXXX)"
mount --bind "${ARCHIVE_DIR}/${_CONST_CUSTOM_DIR}" "${CHROOT_DIR}/${CHROOT_MSS_MNT_POINT}"

CURNT_KER_VER="$(cd "${CHROOT_DIR}"/lib/modules ; ls)" # there should only be one subdirectory in .../modules
CURNT_OS_VER="$(chroot "${CHROOT_DIR}" /usr/bin/lsb_release -rs)"

# If needed, get the MSS verion from a file like: MssVersionFile_2017_16.5.2_PV3_<otherSymbols>_CENTOS.quickbuild | awk -F_ '{ printf("%s_%s_%s",$4, $5, $6)}')
# Such file has to be added to every CHROOT_MSS_MNT_POINT
case "${CURNT_KER_VER}" in
	3.10.0-693*)
		FAKED_KER_VER="3.10.0-693.el7.x86_64"
		FAKED_OS_VER="7.4.1708"
	;;
	4.4.*)	# the below is with the assumption that the kernel has been previously patched
		FAKED_KER_VER="3.10.0-229.el7.x86_64"
		FAKED_OS_VER="7.1.1503"
	;;
	*)	# do not fake anything; unbelievable
		FAKED_KER_VER="${CURNT_KER_VER}"
		FAKED_OS_VER="${CURNT_OS_VER}"
	;;
esac

ln -s /lib/modules/"${CURNT_KER_VER}" "${CHROOT_DIR}"/lib/modules/"${FAKED_KER_VER}"
#ln -s /usr/src/kernels/"${CURNT_KER_VER}" "${CHROOT_DIR}"/usr/src/kernels/"${FAKED_KER_VER}"

CHROOT_MSS_USABLE_MNT_POINT="${CHROOT_MSS_MNT_POINT}"

# TODO: Make the below conform to remaining faking cases:
# Faking depmod on CentOS 7.4 causes two challenges:
# 1. It is a link to a binary /usr/bin/kmod, which should not be overwritten
# 2. The /usr/bin/kmod uses argv[0], so depmod cannot be renamed
mkdir  "${CHROOT_DIR}"/tmp/bin
ln -s "$(chroot "${CHROOT_DIR}" readlink -f /usr/sbin/depmod)" "${CHROOT_DIR}"/tmp/bin/depmod
rm "${CHROOT_DIR}"/usr/sbin/depmod	# this is only a link to /usr/bin/kmod
cat > "${CHROOT_DIR}"/usr/sbin/depmod <<EOF
#!/bin/bash
        case "\$1" in
          -a)
             /tmp/bin/depmod -a "${FAKED_KER_VER}"
             ;;
          *)
             /tmp/bin/depmod \$@
             ;;
        esac
EOF
chmod 755 "${CHROOT_DIR}"/usr/sbin/depmod

fakeAndRegisterCommand "${CHROOT_DIR}"/usr/bin/yum <<< "exit 0" >/dev/null
fakeAndRegisterCommand "${CHROOT_DIR}"/bin/uname <<EOF >/dev/null
	case "\$1" in
		-r)
			echo ${FAKED_KER_VER}
			;;
		*)
			"$(getFakedCommandSavedName /bin/uname)" \$@
			;;
	esac
EOF
fakeAndRegisterCommand "${CHROOT_DIR}"/usr/bin/lsb_release <<EOF >/dev/null
	case "\$1" in
		-is)
			echo CentOS
			;;
		-rs)
			echo ${FAKED_OS_VER}
			;;
		-ds)
			echo "CentOS Linux release ${FAKED_OS_VER} (Core) "
			;;
		*)
			"$(getFakedCommandSavedName /usr/bin/lsb_release)" \$@
			;;
	esac
EOF
echo "Configuring MSS in ${CHROOT_DIR}" >&2
do_chroot "${CHROOT_DIR}" /bin/bash << EOF || die "Could not configure operating environment in ${CHROOT_DIR}"
	set -eu

	cd "/${CHROOT_MSS_USABLE_MNT_POINT}"
	if [[  ${FAKED_KER_VER} == 3.10.0-229.el7.x86_64 ]] ; then
		cd Generic
		./install_media.sh <<< y > /dev/null
	else
		export OS=CENTOS	# referenced in makefiles
		./install.sh <<< "y" >/dev/null	# "yes" to "install firmwares for SKL?"
	fi
EOF

# cleanup after src.rpm rpmbuild
/bin/rm -fr "${CHROOT_DIR}"/root/rpmbuild
/bin/rm -fr "${CHROOT_DIR}"/backports-i915-driver

restoreFakedRegisteredCommands LASTONLY	# restore lsb_release
restoreFakedRegisteredCommands LASTONLY	# restore uname
restoreFakedRegisteredCommands LASTONLY	# restore yum
rm /usr/sbin/depmod; ln /usr/bin/kmod /usr/sbin/depmod

umount "${CHROOT_DIR}/${CHROOT_MSS_MNT_POINT}"
/bin/rm -r "${CHROOT_DIR}/${CHROOT_MSS_MNT_POINT}"