#!/bin/bash
#
# Intel VCA Software Stack (VCASS)
#
# Copyright(c) 2017 Intel Corporation.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License, version 2, as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# The full GNU General Public License is included in this distribution in
# the file called "COPYING".
#
# Intel VCA Scripts.
#
set -eu

STEP="$1"			; shift
PHASE="$1"			; shift
ARCHIVE_DIR="$1"	; shift
SCRIPTS_DIR="$1"	; shift
CHROOT_DIR="$1"		; shift

. "${SCRIPTS_DIR}/library_image_creation.sh"

# TODO: reconsider bind mounting (ro?rw?) before running the pre/postadd scripts. This requires ARCHIVE_DIR relative to CHROOT_DIR
CHROOT_MSS_MNT_POINT="$(cd "${CHROOT_DIR}"; mktemp --directory --tmpdir=./tmp mss_mount_point.XXXXXX)"
mount --bind "${ARCHIVE_DIR}/${_CONST_CUSTOM_DIR}" "${CHROOT_DIR}/${CHROOT_MSS_MNT_POINT}"

#KER_VER="$(get_from_archive_info_file "${ARCHIVE_DIR}" "Target kernel" )"
KER_VER="$(cd "${CHROOT_DIR}"/lib/modules ; ls)" # there should only be one subdirectory in .../modules

# enabing currently needed kernel using 4.4.0 sources in MSS:
CHROOT_MSS_USABLE_MNT_POINT="${CHROOT_MSS_MNT_POINT}"
if [[ "${KER_VER}" == 4.4.* || "${KER_VER}" == 4.13.* ]] ; then
	CHROOT_MSS_USABLE_MNT_POINT="$(cd "${CHROOT_DIR}"; mktemp --directory --tmpdir=./tmp mss_usable_mount_point.XXXXXX)"
	cp -rp "${CHROOT_DIR}/${CHROOT_MSS_MNT_POINT}" "${CHROOT_DIR}/${CHROOT_MSS_USABLE_MNT_POINT}"
	CHROOT_MSS_USABLE_MNT_POINT="${CHROOT_MSS_USABLE_MNT_POINT}/$(basename "${CHROOT_DIR}/${CHROOT_MSS_MNT_POINT}")"
	ln -s "${CHROOT_DIR}/${CHROOT_MSS_USABLE_MNT_POINT}"/Generic/lib/modules/4.4.0-vpg20160125-gcc4.7.2/ "${CHROOT_DIR}/${CHROOT_MSS_USABLE_MNT_POINT}"/Generic/lib/modules/${KER_VER}-vpg20160125-gcc4.7.2 || true
fi

# /usr/sbin/grub-mkconfig wants to create /boot/grub/grub.cfg.new in CHROOT:
mkdir "${CHROOT_DIR}"/boot/grub/

# disable the initrd update script "${CHROOT_DIR}"/backports-i915-driver/scripts/update-initramfs.sh, calling 'update-grub'. This script is called from:
#	CHROOT/backports-i915-driver/Makefile.real
# which is called from:
#	CHROOT/var/lib/dpkg/info/backports-i915-driver.postinst
# which is called (by means of  dpkg -i kmd_for_ubuntu.deb) from:
#	CHROOT/tmp/mss_mount_point.DUoWKh/mss/install.sh
fakeAndRegisterCommand "${CHROOT_DIR}"/usr/sbin/update-grub <<< "exit 0" >/dev/null

echo "Configuring MSS in ${CHROOT_DIR}" >&2
do_chroot "${CHROOT_DIR}" /bin/bash << EOF || die "Could not configure operating environment in ${CHROOT_DIR}"
	set -eu

	cd "/${CHROOT_MSS_USABLE_MNT_POINT}"
	export OS=UBUNTU	# referenced in makefiles
	./install.sh <<< "y" >/dev/null	# "yes" to install firmware
EOF

# [[ "${KER_VER}" == 4.4.* ]] && mv "${CHROOT_DIR}"/bin/uname.ORG.ORG "${CHROOT_DIR}"/bin/uname.ORG

# cleanup after src.rpm rpmbuild:
/bin/rm -fr "${CHROOT_DIR}"/root/rpmbuild
/bin/rm -fr "${CHROOT_DIR}"/backports-i915-driver

restoreFakedRegisteredCommands LASTONLY

# TODO: is it still useful? enabing currently needed kernel using 4.4.0 sources in MSS:
[[ "${KER_VER}" == 4.4.* || "${KER_VER}" == 4.13.* ]] && /bin/rm -fr "$(dirname "${CHROOT_MSS_USABLE_MNT_POINT}")"

umount "${CHROOT_DIR}/${CHROOT_MSS_MNT_POINT}"
/bin/rm -r "${CHROOT_DIR}/${CHROOT_MSS_MNT_POINT}"
