/*
* Intel VCA Software Stack (VCASS)
*
* Copyright(c) 2015-2017 Intel Corporation.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* The full GNU General Public License is included in this distribution in
* the file called "COPYING".
*
* Intel VCA User Space Tools.
*/

#define _GNU_SOURCE

#include "helper_funcs.h"
#include "vcassd_virtio_backend.h"

void add_virtio_device(struct vca_info *vca, enum virtio_types type)
{
	char path[PATH_MAX];
	struct vca_device_desc * dd;
	filehandle_t fd;
	int err;

	switch (type) {
	case VIRTIO_TYPE_NET:
		dd = &virtnet_dev_page.dd;
		break;
	case VIRTIO_TYPE_CONSOLE:
	case VIRTIO_TYPE_BLOCK:
	default:
		vcasslog("Error: Invalid type passed to add_virtio_device!\n");
		assert(0);
		return;
	}
	snprintf(path, PATH_MAX, "/dev/vop_virtio%d%d", vca->card_id, vca->cpu_id);
	fd = open(path, O_RDWR|O_CLOEXEC);
	if (fd < 0) {
		vcasslog("Could not open %s %s\n", path, strerror(errno));
		return;
	}

	err = ioctl(fd, VCA_VIRTIO_ADD_DEVICE, dd);
	if (err < 0) {
		vcasslog("Could not add %d %s\n", dd->type, strerror(errno));
		close(fd);
		return;
	}
	switch (dd->type) {
	case VIRTIO_ID_NET:
		vca->vca_net.virtio_net_fd = fd;
		vcasslog("Added VIRTIO_ID_NET for %s\n", vca->name);
		break;
	case VIRTIO_ID_CONSOLE:
	case VIRTIO_ID_BLOCK:
	default:
		vcasslog("Could not add %d\n", dd->type);
		close(fd);
		assert(0);
		return;
	}
}
