/* This file is autogenerated by tracetool, do not edit. */

#ifndef TRACE_BLOCK_GENERATED_TRACERS_H
#define TRACE_BLOCK_GENERATED_TRACERS_H

#include "qemu-common.h"
#include "trace/control.h"

extern TraceEvent _TRACE_BDRV_OPEN_COMMON_EVENT;
extern TraceEvent _TRACE_BDRV_LOCK_MEDIUM_EVENT;
extern TraceEvent _TRACE_BLK_CO_PREADV_EVENT;
extern TraceEvent _TRACE_BLK_CO_PWRITEV_EVENT;
extern TraceEvent _TRACE_BDRV_AIO_FLUSH_EVENT;
extern TraceEvent _TRACE_BDRV_AIO_READV_EVENT;
extern TraceEvent _TRACE_BDRV_AIO_WRITEV_EVENT;
extern TraceEvent _TRACE_BDRV_CO_READV_EVENT;
extern TraceEvent _TRACE_BDRV_CO_WRITEV_EVENT;
extern TraceEvent _TRACE_BDRV_CO_PWRITE_ZEROES_EVENT;
extern TraceEvent _TRACE_BDRV_CO_DO_COPY_ON_READV_EVENT;
extern TraceEvent _TRACE_STREAM_ONE_ITERATION_EVENT;
extern TraceEvent _TRACE_STREAM_START_EVENT;
extern TraceEvent _TRACE_COMMIT_ONE_ITERATION_EVENT;
extern TraceEvent _TRACE_COMMIT_START_EVENT;
extern TraceEvent _TRACE_MIRROR_START_EVENT;
extern TraceEvent _TRACE_MIRROR_RESTART_ITER_EVENT;
extern TraceEvent _TRACE_MIRROR_BEFORE_FLUSH_EVENT;
extern TraceEvent _TRACE_MIRROR_BEFORE_DRAIN_EVENT;
extern TraceEvent _TRACE_MIRROR_BEFORE_SLEEP_EVENT;
extern TraceEvent _TRACE_MIRROR_ONE_ITERATION_EVENT;
extern TraceEvent _TRACE_MIRROR_ITERATION_DONE_EVENT;
extern TraceEvent _TRACE_MIRROR_YIELD_EVENT;
extern TraceEvent _TRACE_MIRROR_YIELD_IN_FLIGHT_EVENT;
extern TraceEvent _TRACE_BACKUP_DO_COW_ENTER_EVENT;
extern TraceEvent _TRACE_BACKUP_DO_COW_RETURN_EVENT;
extern TraceEvent _TRACE_BACKUP_DO_COW_SKIP_EVENT;
extern TraceEvent _TRACE_BACKUP_DO_COW_PROCESS_EVENT;
extern TraceEvent _TRACE_BACKUP_DO_COW_READ_FAIL_EVENT;
extern TraceEvent _TRACE_BACKUP_DO_COW_WRITE_FAIL_EVENT;
extern TraceEvent _TRACE_QMP_BLOCK_JOB_CANCEL_EVENT;
extern TraceEvent _TRACE_QMP_BLOCK_JOB_PAUSE_EVENT;
extern TraceEvent _TRACE_QMP_BLOCK_JOB_RESUME_EVENT;
extern TraceEvent _TRACE_QMP_BLOCK_JOB_COMPLETE_EVENT;
extern TraceEvent _TRACE_QMP_BLOCK_STREAM_EVENT;
extern TraceEvent _TRACE_PAIO_SUBMIT_CO_EVENT;
extern TraceEvent _TRACE_PAIO_SUBMIT_EVENT;
extern TraceEvent _TRACE_QCOW2_WRITEV_START_REQ_EVENT;
extern TraceEvent _TRACE_QCOW2_WRITEV_DONE_REQ_EVENT;
extern TraceEvent _TRACE_QCOW2_WRITEV_START_PART_EVENT;
extern TraceEvent _TRACE_QCOW2_WRITEV_DONE_PART_EVENT;
extern TraceEvent _TRACE_QCOW2_WRITEV_DATA_EVENT;
extern TraceEvent _TRACE_QCOW2_PWRITE_ZEROES_START_REQ_EVENT;
extern TraceEvent _TRACE_QCOW2_PWRITE_ZEROES_EVENT;
extern TraceEvent _TRACE_QCOW2_ALLOC_CLUSTERS_OFFSET_EVENT;
extern TraceEvent _TRACE_QCOW2_HANDLE_COPIED_EVENT;
extern TraceEvent _TRACE_QCOW2_HANDLE_ALLOC_EVENT;
extern TraceEvent _TRACE_QCOW2_DO_ALLOC_CLUSTERS_OFFSET_EVENT;
extern TraceEvent _TRACE_QCOW2_CLUSTER_ALLOC_PHYS_EVENT;
extern TraceEvent _TRACE_QCOW2_CLUSTER_LINK_L2_EVENT;
extern TraceEvent _TRACE_QCOW2_L2_ALLOCATE_EVENT;
extern TraceEvent _TRACE_QCOW2_L2_ALLOCATE_GET_EMPTY_EVENT;
extern TraceEvent _TRACE_QCOW2_L2_ALLOCATE_WRITE_L2_EVENT;
extern TraceEvent _TRACE_QCOW2_L2_ALLOCATE_WRITE_L1_EVENT;
extern TraceEvent _TRACE_QCOW2_L2_ALLOCATE_DONE_EVENT;
extern TraceEvent _TRACE_QCOW2_CACHE_GET_EVENT;
extern TraceEvent _TRACE_QCOW2_CACHE_GET_REPLACE_ENTRY_EVENT;
extern TraceEvent _TRACE_QCOW2_CACHE_GET_READ_EVENT;
extern TraceEvent _TRACE_QCOW2_CACHE_GET_DONE_EVENT;
extern TraceEvent _TRACE_QCOW2_CACHE_FLUSH_EVENT;
extern TraceEvent _TRACE_QCOW2_CACHE_ENTRY_FLUSH_EVENT;
extern TraceEvent _TRACE_QED_ALLOC_L2_CACHE_ENTRY_EVENT;
extern TraceEvent _TRACE_QED_UNREF_L2_CACHE_ENTRY_EVENT;
extern TraceEvent _TRACE_QED_FIND_L2_CACHE_ENTRY_EVENT;
extern TraceEvent _TRACE_QED_READ_TABLE_EVENT;
extern TraceEvent _TRACE_QED_READ_TABLE_CB_EVENT;
extern TraceEvent _TRACE_QED_WRITE_TABLE_EVENT;
extern TraceEvent _TRACE_QED_WRITE_TABLE_CB_EVENT;
extern TraceEvent _TRACE_QED_NEED_CHECK_TIMER_CB_EVENT;
extern TraceEvent _TRACE_QED_START_NEED_CHECK_TIMER_EVENT;
extern TraceEvent _TRACE_QED_CANCEL_NEED_CHECK_TIMER_EVENT;
extern TraceEvent _TRACE_QED_AIO_COMPLETE_EVENT;
extern TraceEvent _TRACE_QED_AIO_SETUP_EVENT;
extern TraceEvent _TRACE_QED_AIO_NEXT_IO_EVENT;
extern TraceEvent _TRACE_QED_AIO_READ_DATA_EVENT;
extern TraceEvent _TRACE_QED_AIO_WRITE_DATA_EVENT;
extern TraceEvent _TRACE_QED_AIO_WRITE_PREFILL_EVENT;
extern TraceEvent _TRACE_QED_AIO_WRITE_POSTFILL_EVENT;
extern TraceEvent _TRACE_QED_AIO_WRITE_MAIN_EVENT;
extern uint16_t _TRACE_BDRV_OPEN_COMMON_DSTATE;
extern uint16_t _TRACE_BDRV_LOCK_MEDIUM_DSTATE;
extern uint16_t _TRACE_BLK_CO_PREADV_DSTATE;
extern uint16_t _TRACE_BLK_CO_PWRITEV_DSTATE;
extern uint16_t _TRACE_BDRV_AIO_FLUSH_DSTATE;
extern uint16_t _TRACE_BDRV_AIO_READV_DSTATE;
extern uint16_t _TRACE_BDRV_AIO_WRITEV_DSTATE;
extern uint16_t _TRACE_BDRV_CO_READV_DSTATE;
extern uint16_t _TRACE_BDRV_CO_WRITEV_DSTATE;
extern uint16_t _TRACE_BDRV_CO_PWRITE_ZEROES_DSTATE;
extern uint16_t _TRACE_BDRV_CO_DO_COPY_ON_READV_DSTATE;
extern uint16_t _TRACE_STREAM_ONE_ITERATION_DSTATE;
extern uint16_t _TRACE_STREAM_START_DSTATE;
extern uint16_t _TRACE_COMMIT_ONE_ITERATION_DSTATE;
extern uint16_t _TRACE_COMMIT_START_DSTATE;
extern uint16_t _TRACE_MIRROR_START_DSTATE;
extern uint16_t _TRACE_MIRROR_RESTART_ITER_DSTATE;
extern uint16_t _TRACE_MIRROR_BEFORE_FLUSH_DSTATE;
extern uint16_t _TRACE_MIRROR_BEFORE_DRAIN_DSTATE;
extern uint16_t _TRACE_MIRROR_BEFORE_SLEEP_DSTATE;
extern uint16_t _TRACE_MIRROR_ONE_ITERATION_DSTATE;
extern uint16_t _TRACE_MIRROR_ITERATION_DONE_DSTATE;
extern uint16_t _TRACE_MIRROR_YIELD_DSTATE;
extern uint16_t _TRACE_MIRROR_YIELD_IN_FLIGHT_DSTATE;
extern uint16_t _TRACE_BACKUP_DO_COW_ENTER_DSTATE;
extern uint16_t _TRACE_BACKUP_DO_COW_RETURN_DSTATE;
extern uint16_t _TRACE_BACKUP_DO_COW_SKIP_DSTATE;
extern uint16_t _TRACE_BACKUP_DO_COW_PROCESS_DSTATE;
extern uint16_t _TRACE_BACKUP_DO_COW_READ_FAIL_DSTATE;
extern uint16_t _TRACE_BACKUP_DO_COW_WRITE_FAIL_DSTATE;
extern uint16_t _TRACE_QMP_BLOCK_JOB_CANCEL_DSTATE;
extern uint16_t _TRACE_QMP_BLOCK_JOB_PAUSE_DSTATE;
extern uint16_t _TRACE_QMP_BLOCK_JOB_RESUME_DSTATE;
extern uint16_t _TRACE_QMP_BLOCK_JOB_COMPLETE_DSTATE;
extern uint16_t _TRACE_QMP_BLOCK_STREAM_DSTATE;
extern uint16_t _TRACE_PAIO_SUBMIT_CO_DSTATE;
extern uint16_t _TRACE_PAIO_SUBMIT_DSTATE;
extern uint16_t _TRACE_QCOW2_WRITEV_START_REQ_DSTATE;
extern uint16_t _TRACE_QCOW2_WRITEV_DONE_REQ_DSTATE;
extern uint16_t _TRACE_QCOW2_WRITEV_START_PART_DSTATE;
extern uint16_t _TRACE_QCOW2_WRITEV_DONE_PART_DSTATE;
extern uint16_t _TRACE_QCOW2_WRITEV_DATA_DSTATE;
extern uint16_t _TRACE_QCOW2_PWRITE_ZEROES_START_REQ_DSTATE;
extern uint16_t _TRACE_QCOW2_PWRITE_ZEROES_DSTATE;
extern uint16_t _TRACE_QCOW2_ALLOC_CLUSTERS_OFFSET_DSTATE;
extern uint16_t _TRACE_QCOW2_HANDLE_COPIED_DSTATE;
extern uint16_t _TRACE_QCOW2_HANDLE_ALLOC_DSTATE;
extern uint16_t _TRACE_QCOW2_DO_ALLOC_CLUSTERS_OFFSET_DSTATE;
extern uint16_t _TRACE_QCOW2_CLUSTER_ALLOC_PHYS_DSTATE;
extern uint16_t _TRACE_QCOW2_CLUSTER_LINK_L2_DSTATE;
extern uint16_t _TRACE_QCOW2_L2_ALLOCATE_DSTATE;
extern uint16_t _TRACE_QCOW2_L2_ALLOCATE_GET_EMPTY_DSTATE;
extern uint16_t _TRACE_QCOW2_L2_ALLOCATE_WRITE_L2_DSTATE;
extern uint16_t _TRACE_QCOW2_L2_ALLOCATE_WRITE_L1_DSTATE;
extern uint16_t _TRACE_QCOW2_L2_ALLOCATE_DONE_DSTATE;
extern uint16_t _TRACE_QCOW2_CACHE_GET_DSTATE;
extern uint16_t _TRACE_QCOW2_CACHE_GET_REPLACE_ENTRY_DSTATE;
extern uint16_t _TRACE_QCOW2_CACHE_GET_READ_DSTATE;
extern uint16_t _TRACE_QCOW2_CACHE_GET_DONE_DSTATE;
extern uint16_t _TRACE_QCOW2_CACHE_FLUSH_DSTATE;
extern uint16_t _TRACE_QCOW2_CACHE_ENTRY_FLUSH_DSTATE;
extern uint16_t _TRACE_QED_ALLOC_L2_CACHE_ENTRY_DSTATE;
extern uint16_t _TRACE_QED_UNREF_L2_CACHE_ENTRY_DSTATE;
extern uint16_t _TRACE_QED_FIND_L2_CACHE_ENTRY_DSTATE;
extern uint16_t _TRACE_QED_READ_TABLE_DSTATE;
extern uint16_t _TRACE_QED_READ_TABLE_CB_DSTATE;
extern uint16_t _TRACE_QED_WRITE_TABLE_DSTATE;
extern uint16_t _TRACE_QED_WRITE_TABLE_CB_DSTATE;
extern uint16_t _TRACE_QED_NEED_CHECK_TIMER_CB_DSTATE;
extern uint16_t _TRACE_QED_START_NEED_CHECK_TIMER_DSTATE;
extern uint16_t _TRACE_QED_CANCEL_NEED_CHECK_TIMER_DSTATE;
extern uint16_t _TRACE_QED_AIO_COMPLETE_DSTATE;
extern uint16_t _TRACE_QED_AIO_SETUP_DSTATE;
extern uint16_t _TRACE_QED_AIO_NEXT_IO_DSTATE;
extern uint16_t _TRACE_QED_AIO_READ_DATA_DSTATE;
extern uint16_t _TRACE_QED_AIO_WRITE_DATA_DSTATE;
extern uint16_t _TRACE_QED_AIO_WRITE_PREFILL_DSTATE;
extern uint16_t _TRACE_QED_AIO_WRITE_POSTFILL_DSTATE;
extern uint16_t _TRACE_QED_AIO_WRITE_MAIN_DSTATE;
#define TRACE_BDRV_OPEN_COMMON_ENABLED 1
#define TRACE_BDRV_LOCK_MEDIUM_ENABLED 1
#define TRACE_BLK_CO_PREADV_ENABLED 1
#define TRACE_BLK_CO_PWRITEV_ENABLED 1
#define TRACE_BDRV_AIO_FLUSH_ENABLED 1
#define TRACE_BDRV_AIO_READV_ENABLED 1
#define TRACE_BDRV_AIO_WRITEV_ENABLED 1
#define TRACE_BDRV_CO_READV_ENABLED 1
#define TRACE_BDRV_CO_WRITEV_ENABLED 1
#define TRACE_BDRV_CO_PWRITE_ZEROES_ENABLED 1
#define TRACE_BDRV_CO_DO_COPY_ON_READV_ENABLED 1
#define TRACE_STREAM_ONE_ITERATION_ENABLED 1
#define TRACE_STREAM_START_ENABLED 1
#define TRACE_COMMIT_ONE_ITERATION_ENABLED 1
#define TRACE_COMMIT_START_ENABLED 1
#define TRACE_MIRROR_START_ENABLED 1
#define TRACE_MIRROR_RESTART_ITER_ENABLED 1
#define TRACE_MIRROR_BEFORE_FLUSH_ENABLED 1
#define TRACE_MIRROR_BEFORE_DRAIN_ENABLED 1
#define TRACE_MIRROR_BEFORE_SLEEP_ENABLED 1
#define TRACE_MIRROR_ONE_ITERATION_ENABLED 1
#define TRACE_MIRROR_ITERATION_DONE_ENABLED 1
#define TRACE_MIRROR_YIELD_ENABLED 1
#define TRACE_MIRROR_YIELD_IN_FLIGHT_ENABLED 1
#define TRACE_BACKUP_DO_COW_ENTER_ENABLED 1
#define TRACE_BACKUP_DO_COW_RETURN_ENABLED 1
#define TRACE_BACKUP_DO_COW_SKIP_ENABLED 1
#define TRACE_BACKUP_DO_COW_PROCESS_ENABLED 1
#define TRACE_BACKUP_DO_COW_READ_FAIL_ENABLED 1
#define TRACE_BACKUP_DO_COW_WRITE_FAIL_ENABLED 1
#define TRACE_QMP_BLOCK_JOB_CANCEL_ENABLED 1
#define TRACE_QMP_BLOCK_JOB_PAUSE_ENABLED 1
#define TRACE_QMP_BLOCK_JOB_RESUME_ENABLED 1
#define TRACE_QMP_BLOCK_JOB_COMPLETE_ENABLED 1
#define TRACE_QMP_BLOCK_STREAM_ENABLED 1
#define TRACE_PAIO_SUBMIT_CO_ENABLED 1
#define TRACE_PAIO_SUBMIT_ENABLED 1
#define TRACE_QCOW2_WRITEV_START_REQ_ENABLED 1
#define TRACE_QCOW2_WRITEV_DONE_REQ_ENABLED 1
#define TRACE_QCOW2_WRITEV_START_PART_ENABLED 1
#define TRACE_QCOW2_WRITEV_DONE_PART_ENABLED 1
#define TRACE_QCOW2_WRITEV_DATA_ENABLED 1
#define TRACE_QCOW2_PWRITE_ZEROES_START_REQ_ENABLED 1
#define TRACE_QCOW2_PWRITE_ZEROES_ENABLED 1
#define TRACE_QCOW2_ALLOC_CLUSTERS_OFFSET_ENABLED 1
#define TRACE_QCOW2_HANDLE_COPIED_ENABLED 1
#define TRACE_QCOW2_HANDLE_ALLOC_ENABLED 1
#define TRACE_QCOW2_DO_ALLOC_CLUSTERS_OFFSET_ENABLED 1
#define TRACE_QCOW2_CLUSTER_ALLOC_PHYS_ENABLED 1
#define TRACE_QCOW2_CLUSTER_LINK_L2_ENABLED 1
#define TRACE_QCOW2_L2_ALLOCATE_ENABLED 1
#define TRACE_QCOW2_L2_ALLOCATE_GET_EMPTY_ENABLED 1
#define TRACE_QCOW2_L2_ALLOCATE_WRITE_L2_ENABLED 1
#define TRACE_QCOW2_L2_ALLOCATE_WRITE_L1_ENABLED 1
#define TRACE_QCOW2_L2_ALLOCATE_DONE_ENABLED 1
#define TRACE_QCOW2_CACHE_GET_ENABLED 1
#define TRACE_QCOW2_CACHE_GET_REPLACE_ENTRY_ENABLED 1
#define TRACE_QCOW2_CACHE_GET_READ_ENABLED 1
#define TRACE_QCOW2_CACHE_GET_DONE_ENABLED 1
#define TRACE_QCOW2_CACHE_FLUSH_ENABLED 1
#define TRACE_QCOW2_CACHE_ENTRY_FLUSH_ENABLED 1
#define TRACE_QED_ALLOC_L2_CACHE_ENTRY_ENABLED 1
#define TRACE_QED_UNREF_L2_CACHE_ENTRY_ENABLED 1
#define TRACE_QED_FIND_L2_CACHE_ENTRY_ENABLED 1
#define TRACE_QED_READ_TABLE_ENABLED 1
#define TRACE_QED_READ_TABLE_CB_ENABLED 1
#define TRACE_QED_WRITE_TABLE_ENABLED 1
#define TRACE_QED_WRITE_TABLE_CB_ENABLED 1
#define TRACE_QED_NEED_CHECK_TIMER_CB_ENABLED 1
#define TRACE_QED_START_NEED_CHECK_TIMER_ENABLED 1
#define TRACE_QED_CANCEL_NEED_CHECK_TIMER_ENABLED 1
#define TRACE_QED_AIO_COMPLETE_ENABLED 1
#define TRACE_QED_AIO_SETUP_ENABLED 1
#define TRACE_QED_AIO_NEXT_IO_ENABLED 1
#define TRACE_QED_AIO_READ_DATA_ENABLED 1
#define TRACE_QED_AIO_WRITE_DATA_ENABLED 1
#define TRACE_QED_AIO_WRITE_PREFILL_ENABLED 1
#define TRACE_QED_AIO_WRITE_POSTFILL_ENABLED 1
#define TRACE_QED_AIO_WRITE_MAIN_ENABLED 1
#include "qemu/log.h"


static inline void trace_bdrv_open_common(void * bs, const char * filename, int flags, const char * format_name)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_OPEN_COMMON)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_open_common " "bs %p filename \"%s\" flags %#x format_name \"%s\"" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, filename, flags, format_name);
        }
    }
}

static inline void trace_bdrv_lock_medium(void * bs, bool locked)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_LOCK_MEDIUM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_lock_medium " "bs %p locked %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, locked);
        }
    }
}

static inline void trace_blk_co_preadv(void * blk, void * bs, int64_t offset, unsigned int bytes, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_BLK_CO_PREADV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:blk_co_preadv " "blk %p bs %p offset %"PRId64" bytes %u flags %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , blk, bs, offset, bytes, flags);
        }
    }
}

static inline void trace_blk_co_pwritev(void * blk, void * bs, int64_t offset, unsigned int bytes, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_BLK_CO_PWRITEV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:blk_co_pwritev " "blk %p bs %p offset %"PRId64" bytes %u flags %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , blk, bs, offset, bytes, flags);
        }
    }
}

static inline void trace_bdrv_aio_flush(void * bs, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_AIO_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_aio_flush " "bs %p opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, opaque);
        }
    }
}

static inline void trace_bdrv_aio_readv(void * bs, int64_t sector_num, int nb_sectors, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_AIO_READV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_aio_readv " "bs %p sector_num %"PRId64" nb_sectors %d opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, sector_num, nb_sectors, opaque);
        }
    }
}

static inline void trace_bdrv_aio_writev(void * bs, int64_t sector_num, int nb_sectors, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_AIO_WRITEV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_aio_writev " "bs %p sector_num %"PRId64" nb_sectors %d opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, sector_num, nb_sectors, opaque);
        }
    }
}

static inline void trace_bdrv_co_readv(void * bs, int64_t sector_num, int nb_sector)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_CO_READV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_co_readv " "bs %p sector_num %"PRId64" nb_sectors %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, sector_num, nb_sector);
        }
    }
}

static inline void trace_bdrv_co_writev(void * bs, int64_t sector_num, int nb_sector)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_CO_WRITEV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_co_writev " "bs %p sector_num %"PRId64" nb_sectors %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, sector_num, nb_sector);
        }
    }
}

static inline void trace_bdrv_co_pwrite_zeroes(void * bs, int64_t offset, int count, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_CO_PWRITE_ZEROES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_co_pwrite_zeroes " "bs %p offset %"PRId64" count %d flags %#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, offset, count, flags);
        }
    }
}

static inline void trace_bdrv_co_do_copy_on_readv(void * bs, int64_t offset, unsigned int bytes, int64_t cluster_offset, unsigned int cluster_bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_CO_DO_COPY_ON_READV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_co_do_copy_on_readv " "bs %p offset %"PRId64" bytes %u cluster_offset %"PRId64" cluster_bytes %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, offset, bytes, cluster_offset, cluster_bytes);
        }
    }
}

static inline void trace_stream_one_iteration(void * s, int64_t sector_num, int nb_sectors, int is_allocated)
{
    if (true) {
        if (trace_event_get_state(TRACE_STREAM_ONE_ITERATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:stream_one_iteration " "s %p sector_num %"PRId64" nb_sectors %d is_allocated %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, sector_num, nb_sectors, is_allocated);
        }
    }
}

static inline void trace_stream_start(void * bs, void * base, void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_STREAM_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:stream_start " "bs %p base %p s %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, base, s);
        }
    }
}

static inline void trace_commit_one_iteration(void * s, int64_t sector_num, int nb_sectors, int is_allocated)
{
    if (true) {
        if (trace_event_get_state(TRACE_COMMIT_ONE_ITERATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:commit_one_iteration " "s %p sector_num %"PRId64" nb_sectors %d is_allocated %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, sector_num, nb_sectors, is_allocated);
        }
    }
}

static inline void trace_commit_start(void * bs, void * base, void * top, void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_COMMIT_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:commit_start " "bs %p base %p top %p s %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, base, top, s);
        }
    }
}

static inline void trace_mirror_start(void * bs, void * s, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_start " "bs %p s %p opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, s, opaque);
        }
    }
}

static inline void trace_mirror_restart_iter(void * s, int64_t cnt)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_RESTART_ITER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_restart_iter " "s %p dirty count %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, cnt);
        }
    }
}

static inline void trace_mirror_before_flush(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_BEFORE_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_before_flush " "s %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_mirror_before_drain(void * s, int64_t cnt)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_BEFORE_DRAIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_before_drain " "s %p dirty count %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, cnt);
        }
    }
}

static inline void trace_mirror_before_sleep(void * s, int64_t cnt, int synced, uint64_t delay_ns)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_BEFORE_SLEEP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_before_sleep " "s %p dirty count %"PRId64" synced %d delay %"PRIu64"ns" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, cnt, synced, delay_ns);
        }
    }
}

static inline void trace_mirror_one_iteration(void * s, int64_t sector_num, int nb_sectors)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_ONE_ITERATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_one_iteration " "s %p sector_num %"PRId64" nb_sectors %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, sector_num, nb_sectors);
        }
    }
}

static inline void trace_mirror_iteration_done(void * s, int64_t sector_num, int nb_sectors, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_ITERATION_DONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_iteration_done " "s %p sector_num %"PRId64" nb_sectors %d ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, sector_num, nb_sectors, ret);
        }
    }
}

static inline void trace_mirror_yield(void * s, int64_t cnt, int buf_free_count, int in_flight)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_YIELD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_yield " "s %p dirty count %"PRId64" free buffers %d in_flight %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, cnt, buf_free_count, in_flight);
        }
    }
}

static inline void trace_mirror_yield_in_flight(void * s, int64_t sector_num, int in_flight)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_YIELD_IN_FLIGHT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_yield_in_flight " "s %p sector_num %"PRId64" in_flight %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, sector_num, in_flight);
        }
    }
}

static inline void trace_backup_do_cow_enter(void * job, int64_t start, int64_t sector_num, int nb_sectors)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_ENTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_enter " "job %p start %"PRId64" sector_num %"PRId64" nb_sectors %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, start, sector_num, nb_sectors);
        }
    }
}

static inline void trace_backup_do_cow_return(void * job, int64_t sector_num, int nb_sectors, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_return " "job %p sector_num %"PRId64" nb_sectors %d ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, sector_num, nb_sectors, ret);
        }
    }
}

static inline void trace_backup_do_cow_skip(void * job, int64_t start)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_SKIP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_skip " "job %p start %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, start);
        }
    }
}

static inline void trace_backup_do_cow_process(void * job, int64_t start)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_PROCESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_process " "job %p start %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, start);
        }
    }
}

static inline void trace_backup_do_cow_read_fail(void * job, int64_t start, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_READ_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_read_fail " "job %p start %"PRId64" ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, start, ret);
        }
    }
}

static inline void trace_backup_do_cow_write_fail(void * job, int64_t start, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_WRITE_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_write_fail " "job %p start %"PRId64" ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, start, ret);
        }
    }
}

static inline void trace_qmp_block_job_cancel(void * job)
{
    if (true) {
        if (trace_event_get_state(TRACE_QMP_BLOCK_JOB_CANCEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qmp_block_job_cancel " "job %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job);
        }
    }
}

static inline void trace_qmp_block_job_pause(void * job)
{
    if (true) {
        if (trace_event_get_state(TRACE_QMP_BLOCK_JOB_PAUSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qmp_block_job_pause " "job %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job);
        }
    }
}

static inline void trace_qmp_block_job_resume(void * job)
{
    if (true) {
        if (trace_event_get_state(TRACE_QMP_BLOCK_JOB_RESUME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qmp_block_job_resume " "job %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job);
        }
    }
}

static inline void trace_qmp_block_job_complete(void * job)
{
    if (true) {
        if (trace_event_get_state(TRACE_QMP_BLOCK_JOB_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qmp_block_job_complete " "job %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job);
        }
    }
}

static inline void trace_qmp_block_stream(void * bs, void * job)
{
    if (true) {
        if (trace_event_get_state(TRACE_QMP_BLOCK_STREAM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qmp_block_stream " "bs %p job %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, job);
        }
    }
}

static inline void trace_paio_submit_co(int64_t offset, int count, int type)
{
    if (true) {
        if (trace_event_get_state(TRACE_PAIO_SUBMIT_CO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:paio_submit_co " "offset %"PRId64" count %d type %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offset, count, type);
        }
    }
}

static inline void trace_paio_submit(void * acb, void * opaque, int64_t offset, int count, int type)
{
    if (true) {
        if (trace_event_get_state(TRACE_PAIO_SUBMIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:paio_submit " "acb %p opaque %p offset %"PRId64" count %d type %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , acb, opaque, offset, count, type);
        }
    }
}

static inline void trace_qcow2_writev_start_req(void * co, int64_t offset, int bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_WRITEV_START_REQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_writev_start_req " "co %p offset %" PRIx64 " bytes %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, offset, bytes);
        }
    }
}

static inline void trace_qcow2_writev_done_req(void * co, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_WRITEV_DONE_REQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_writev_done_req " "co %p ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, ret);
        }
    }
}

static inline void trace_qcow2_writev_start_part(void * co)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_WRITEV_START_PART)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_writev_start_part " "co %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co);
        }
    }
}

static inline void trace_qcow2_writev_done_part(void * co, int cur_bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_WRITEV_DONE_PART)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_writev_done_part " "co %p cur_bytes %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, cur_bytes);
        }
    }
}

static inline void trace_qcow2_writev_data(void * co, uint64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_WRITEV_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_writev_data " "co %p offset %" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, offset);
        }
    }
}

static inline void trace_qcow2_pwrite_zeroes_start_req(void * co, int64_t offset, int count)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_PWRITE_ZEROES_START_REQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_pwrite_zeroes_start_req " "co %p offset %" PRIx64 " count %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, offset, count);
        }
    }
}

static inline void trace_qcow2_pwrite_zeroes(void * co, int64_t offset, int count)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_PWRITE_ZEROES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_pwrite_zeroes " "co %p offset %" PRIx64 " count %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, offset, count);
        }
    }
}

static inline void trace_qcow2_alloc_clusters_offset(void * co, uint64_t offset, int bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_ALLOC_CLUSTERS_OFFSET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_alloc_clusters_offset " "co %p offset %" PRIx64 " bytes %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, offset, bytes);
        }
    }
}

static inline void trace_qcow2_handle_copied(void * co, uint64_t guest_offset, uint64_t host_offset, uint64_t bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_HANDLE_COPIED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_handle_copied " "co %p guest_offset %" PRIx64 " host_offset %" PRIx64 " bytes %" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, guest_offset, host_offset, bytes);
        }
    }
}

static inline void trace_qcow2_handle_alloc(void * co, uint64_t guest_offset, uint64_t host_offset, uint64_t bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_HANDLE_ALLOC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_handle_alloc " "co %p guest_offset %" PRIx64 " host_offset %" PRIx64 " bytes %" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, guest_offset, host_offset, bytes);
        }
    }
}

static inline void trace_qcow2_do_alloc_clusters_offset(void * co, uint64_t guest_offset, uint64_t host_offset, int nb_clusters)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_DO_ALLOC_CLUSTERS_OFFSET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_do_alloc_clusters_offset " "co %p guest_offset %" PRIx64 " host_offset %" PRIx64 " nb_clusters %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, guest_offset, host_offset, nb_clusters);
        }
    }
}

static inline void trace_qcow2_cluster_alloc_phys(void * co)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CLUSTER_ALLOC_PHYS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cluster_alloc_phys " "co %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co);
        }
    }
}

static inline void trace_qcow2_cluster_link_l2(void * co, int nb_clusters)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CLUSTER_LINK_L2)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cluster_link_l2 " "co %p nb_clusters %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, nb_clusters);
        }
    }
}

static inline void trace_qcow2_l2_allocate(void * bs, int l1_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_L2_ALLOCATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_l2_allocate " "bs %p l1_index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, l1_index);
        }
    }
}

static inline void trace_qcow2_l2_allocate_get_empty(void * bs, int l1_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_L2_ALLOCATE_GET_EMPTY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_l2_allocate_get_empty " "bs %p l1_index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, l1_index);
        }
    }
}

static inline void trace_qcow2_l2_allocate_write_l2(void * bs, int l1_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_L2_ALLOCATE_WRITE_L2)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_l2_allocate_write_l2 " "bs %p l1_index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, l1_index);
        }
    }
}

static inline void trace_qcow2_l2_allocate_write_l1(void * bs, int l1_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_L2_ALLOCATE_WRITE_L1)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_l2_allocate_write_l1 " "bs %p l1_index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, l1_index);
        }
    }
}

static inline void trace_qcow2_l2_allocate_done(void * bs, int l1_index, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_L2_ALLOCATE_DONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_l2_allocate_done " "bs %p l1_index %d ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, l1_index, ret);
        }
    }
}

static inline void trace_qcow2_cache_get(void * co, int c, uint64_t offset, bool read_from_disk)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_GET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_get " "co %p is_l2_cache %d offset %" PRIx64 " read_from_disk %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c, offset, read_from_disk);
        }
    }
}

static inline void trace_qcow2_cache_get_replace_entry(void * co, int c, int i)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_GET_REPLACE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_get_replace_entry " "co %p is_l2_cache %d index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c, i);
        }
    }
}

static inline void trace_qcow2_cache_get_read(void * co, int c, int i)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_GET_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_get_read " "co %p is_l2_cache %d index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c, i);
        }
    }
}

static inline void trace_qcow2_cache_get_done(void * co, int c, int i)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_GET_DONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_get_done " "co %p is_l2_cache %d index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c, i);
        }
    }
}

static inline void trace_qcow2_cache_flush(void * co, int c)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_flush " "co %p is_l2_cache %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c);
        }
    }
}

static inline void trace_qcow2_cache_entry_flush(void * co, int c, int i)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_ENTRY_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_entry_flush " "co %p is_l2_cache %d index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c, i);
        }
    }
}

static inline void trace_qed_alloc_l2_cache_entry(void * l2_cache, void * entry)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_ALLOC_L2_CACHE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_alloc_l2_cache_entry " "l2_cache %p entry %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , l2_cache, entry);
        }
    }
}

static inline void trace_qed_unref_l2_cache_entry(void * entry, int ref)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_UNREF_L2_CACHE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_unref_l2_cache_entry " "entry %p ref %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , entry, ref);
        }
    }
}

static inline void trace_qed_find_l2_cache_entry(void * l2_cache, void * entry, uint64_t offset, int ref)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_FIND_L2_CACHE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_find_l2_cache_entry " "l2_cache %p entry %p offset %"PRIu64" ref %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , l2_cache, entry, offset, ref);
        }
    }
}

static inline void trace_qed_read_table(void * s, uint64_t offset, void * table)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_READ_TABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_read_table " "s %p offset %"PRIu64" table %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, offset, table);
        }
    }
}

static inline void trace_qed_read_table_cb(void * s, void * table, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_READ_TABLE_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_read_table_cb " "s %p table %p ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, table, ret);
        }
    }
}

static inline void trace_qed_write_table(void * s, uint64_t offset, void * table, unsigned int index, unsigned int n)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_WRITE_TABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_write_table " "s %p offset %"PRIu64" table %p index %u n %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, offset, table, index, n);
        }
    }
}

static inline void trace_qed_write_table_cb(void * s, void * table, int flush, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_WRITE_TABLE_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_write_table_cb " "s %p table %p flush %d ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, table, flush, ret);
        }
    }
}

static inline void trace_qed_need_check_timer_cb(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_NEED_CHECK_TIMER_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_need_check_timer_cb " "s %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_qed_start_need_check_timer(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_START_NEED_CHECK_TIMER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_start_need_check_timer " "s %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_qed_cancel_need_check_timer(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_CANCEL_NEED_CHECK_TIMER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_cancel_need_check_timer " "s %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_qed_aio_complete(void * s, void * acb, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_complete " "s %p acb %p ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, ret);
        }
    }
}

static inline void trace_qed_aio_setup(void * s, void * acb, int64_t sector_num, int nb_sectors, void * opaque, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_SETUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_setup " "s %p acb %p sector_num %"PRId64" nb_sectors %d opaque %p flags %#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, sector_num, nb_sectors, opaque, flags);
        }
    }
}

static inline void trace_qed_aio_next_io(void * s, void * acb, int ret, uint64_t cur_pos)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_NEXT_IO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_next_io " "s %p acb %p ret %d cur_pos %"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, ret, cur_pos);
        }
    }
}

static inline void trace_qed_aio_read_data(void * s, void * acb, int ret, uint64_t offset, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_READ_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_read_data " "s %p acb %p ret %d offset %"PRIu64" len %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, ret, offset, len);
        }
    }
}

static inline void trace_qed_aio_write_data(void * s, void * acb, int ret, uint64_t offset, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_WRITE_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_write_data " "s %p acb %p ret %d offset %"PRIu64" len %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, ret, offset, len);
        }
    }
}

static inline void trace_qed_aio_write_prefill(void * s, void * acb, uint64_t start, size_t len, uint64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_WRITE_PREFILL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_write_prefill " "s %p acb %p start %"PRIu64" len %zu offset %"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, start, len, offset);
        }
    }
}

static inline void trace_qed_aio_write_postfill(void * s, void * acb, uint64_t start, size_t len, uint64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_WRITE_POSTFILL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_write_postfill " "s %p acb %p start %"PRIu64" len %zu offset %"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, start, len, offset);
        }
    }
}

static inline void trace_qed_aio_write_main(void * s, void * acb, int ret, uint64_t offset, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_WRITE_MAIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_write_main " "s %p acb %p ret %d offset %"PRIu64" len %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, ret, offset, len);
        }
    }
}
#endif /* TRACE_BLOCK_GENERATED_TRACERS_H */
