/* This file is autogenerated by tracetool, do not edit. */

#ifndef TRACE_HW_I386_GENERATED_TRACERS_H
#define TRACE_HW_I386_GENERATED_TRACERS_H

#include "qemu-common.h"
#include "trace/control.h"

extern TraceEvent _TRACE_X86_IOMMU_IEC_NOTIFY_EVENT;
extern TraceEvent _TRACE_VTD_SWITCH_ADDRESS_SPACE_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_INVALID_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_CC_DOMAIN_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_CC_GLOBAL_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_CC_DEVICE_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_CC_DEVICES_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_CC_INVALID_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_IOTLB_GLOBAL_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_IOTLB_DOMAIN_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_IOTLB_PAGES_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_IOTLB_INVALID_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_WAIT_SW_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_WAIT_IRQ_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_WAIT_INVALID_EVENT;
extern TraceEvent _TRACE_VTD_INV_DESC_WAIT_WRITE_FAIL_EVENT;
extern TraceEvent _TRACE_VTD_RE_NOT_PRESENT_EVENT;
extern TraceEvent _TRACE_VTD_RE_INVALID_EVENT;
extern TraceEvent _TRACE_VTD_CE_NOT_PRESENT_EVENT;
extern TraceEvent _TRACE_VTD_CE_INVALID_EVENT;
extern TraceEvent _TRACE_VTD_IOTLB_PAGE_HIT_EVENT;
extern TraceEvent _TRACE_VTD_IOTLB_PAGE_UPDATE_EVENT;
extern TraceEvent _TRACE_VTD_IOTLB_CC_HIT_EVENT;
extern TraceEvent _TRACE_VTD_IOTLB_CC_UPDATE_EVENT;
extern TraceEvent _TRACE_VTD_IOTLB_RESET_EVENT;
extern TraceEvent _TRACE_VTD_FAULT_DISABLED_EVENT;
extern TraceEvent _TRACE_AMDVI_EVNTLOG_FAIL_EVENT;
extern TraceEvent _TRACE_AMDVI_CACHE_UPDATE_EVENT;
extern TraceEvent _TRACE_AMDVI_COMPLETION_WAIT_FAIL_EVENT;
extern TraceEvent _TRACE_AMDVI_MMIO_WRITE_EVENT;
extern TraceEvent _TRACE_AMDVI_MMIO_READ_EVENT;
extern TraceEvent _TRACE_AMDVI_MMIO_READ_INVALID_EVENT;
extern TraceEvent _TRACE_AMDVI_COMMAND_ERROR_EVENT;
extern TraceEvent _TRACE_AMDVI_COMMAND_READ_FAIL_EVENT;
extern TraceEvent _TRACE_AMDVI_COMMAND_EXEC_EVENT;
extern TraceEvent _TRACE_AMDVI_UNHANDLED_COMMAND_EVENT;
extern TraceEvent _TRACE_AMDVI_INTR_INVAL_EVENT;
extern TraceEvent _TRACE_AMDVI_IOTLB_INVAL_EVENT;
extern TraceEvent _TRACE_AMDVI_PREFETCH_PAGES_EVENT;
extern TraceEvent _TRACE_AMDVI_PAGES_INVAL_EVENT;
extern TraceEvent _TRACE_AMDVI_ALL_INVAL_EVENT;
extern TraceEvent _TRACE_AMDVI_PPR_EXEC_EVENT;
extern TraceEvent _TRACE_AMDVI_DEVTAB_INVAL_EVENT;
extern TraceEvent _TRACE_AMDVI_COMPLETION_WAIT_EVENT;
extern TraceEvent _TRACE_AMDVI_CONTROL_STATUS_EVENT;
extern TraceEvent _TRACE_AMDVI_IOTLB_RESET_EVENT;
extern TraceEvent _TRACE_AMDVI_DTE_GET_FAIL_EVENT;
extern TraceEvent _TRACE_AMDVI_INVALID_DTE_EVENT;
extern TraceEvent _TRACE_AMDVI_GET_PTE_HWERROR_EVENT;
extern TraceEvent _TRACE_AMDVI_MODE_INVALID_EVENT;
extern TraceEvent _TRACE_AMDVI_PAGE_FAULT_EVENT;
extern TraceEvent _TRACE_AMDVI_IOTLB_HIT_EVENT;
extern TraceEvent _TRACE_AMDVI_TRANSLATION_RESULT_EVENT;
extern uint16_t _TRACE_X86_IOMMU_IEC_NOTIFY_DSTATE;
extern uint16_t _TRACE_VTD_SWITCH_ADDRESS_SPACE_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_INVALID_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_CC_DOMAIN_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_CC_GLOBAL_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_CC_DEVICE_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_CC_DEVICES_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_CC_INVALID_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_IOTLB_GLOBAL_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_IOTLB_DOMAIN_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_IOTLB_PAGES_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_IOTLB_INVALID_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_WAIT_SW_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_WAIT_IRQ_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_WAIT_INVALID_DSTATE;
extern uint16_t _TRACE_VTD_INV_DESC_WAIT_WRITE_FAIL_DSTATE;
extern uint16_t _TRACE_VTD_RE_NOT_PRESENT_DSTATE;
extern uint16_t _TRACE_VTD_RE_INVALID_DSTATE;
extern uint16_t _TRACE_VTD_CE_NOT_PRESENT_DSTATE;
extern uint16_t _TRACE_VTD_CE_INVALID_DSTATE;
extern uint16_t _TRACE_VTD_IOTLB_PAGE_HIT_DSTATE;
extern uint16_t _TRACE_VTD_IOTLB_PAGE_UPDATE_DSTATE;
extern uint16_t _TRACE_VTD_IOTLB_CC_HIT_DSTATE;
extern uint16_t _TRACE_VTD_IOTLB_CC_UPDATE_DSTATE;
extern uint16_t _TRACE_VTD_IOTLB_RESET_DSTATE;
extern uint16_t _TRACE_VTD_FAULT_DISABLED_DSTATE;
extern uint16_t _TRACE_AMDVI_EVNTLOG_FAIL_DSTATE;
extern uint16_t _TRACE_AMDVI_CACHE_UPDATE_DSTATE;
extern uint16_t _TRACE_AMDVI_COMPLETION_WAIT_FAIL_DSTATE;
extern uint16_t _TRACE_AMDVI_MMIO_WRITE_DSTATE;
extern uint16_t _TRACE_AMDVI_MMIO_READ_DSTATE;
extern uint16_t _TRACE_AMDVI_MMIO_READ_INVALID_DSTATE;
extern uint16_t _TRACE_AMDVI_COMMAND_ERROR_DSTATE;
extern uint16_t _TRACE_AMDVI_COMMAND_READ_FAIL_DSTATE;
extern uint16_t _TRACE_AMDVI_COMMAND_EXEC_DSTATE;
extern uint16_t _TRACE_AMDVI_UNHANDLED_COMMAND_DSTATE;
extern uint16_t _TRACE_AMDVI_INTR_INVAL_DSTATE;
extern uint16_t _TRACE_AMDVI_IOTLB_INVAL_DSTATE;
extern uint16_t _TRACE_AMDVI_PREFETCH_PAGES_DSTATE;
extern uint16_t _TRACE_AMDVI_PAGES_INVAL_DSTATE;
extern uint16_t _TRACE_AMDVI_ALL_INVAL_DSTATE;
extern uint16_t _TRACE_AMDVI_PPR_EXEC_DSTATE;
extern uint16_t _TRACE_AMDVI_DEVTAB_INVAL_DSTATE;
extern uint16_t _TRACE_AMDVI_COMPLETION_WAIT_DSTATE;
extern uint16_t _TRACE_AMDVI_CONTROL_STATUS_DSTATE;
extern uint16_t _TRACE_AMDVI_IOTLB_RESET_DSTATE;
extern uint16_t _TRACE_AMDVI_DTE_GET_FAIL_DSTATE;
extern uint16_t _TRACE_AMDVI_INVALID_DTE_DSTATE;
extern uint16_t _TRACE_AMDVI_GET_PTE_HWERROR_DSTATE;
extern uint16_t _TRACE_AMDVI_MODE_INVALID_DSTATE;
extern uint16_t _TRACE_AMDVI_PAGE_FAULT_DSTATE;
extern uint16_t _TRACE_AMDVI_IOTLB_HIT_DSTATE;
extern uint16_t _TRACE_AMDVI_TRANSLATION_RESULT_DSTATE;
#define TRACE_X86_IOMMU_IEC_NOTIFY_ENABLED 1
#define TRACE_VTD_SWITCH_ADDRESS_SPACE_ENABLED 1
#define TRACE_VTD_INV_DESC_ENABLED 1
#define TRACE_VTD_INV_DESC_INVALID_ENABLED 1
#define TRACE_VTD_INV_DESC_CC_DOMAIN_ENABLED 1
#define TRACE_VTD_INV_DESC_CC_GLOBAL_ENABLED 1
#define TRACE_VTD_INV_DESC_CC_DEVICE_ENABLED 1
#define TRACE_VTD_INV_DESC_CC_DEVICES_ENABLED 1
#define TRACE_VTD_INV_DESC_CC_INVALID_ENABLED 1
#define TRACE_VTD_INV_DESC_IOTLB_GLOBAL_ENABLED 1
#define TRACE_VTD_INV_DESC_IOTLB_DOMAIN_ENABLED 1
#define TRACE_VTD_INV_DESC_IOTLB_PAGES_ENABLED 1
#define TRACE_VTD_INV_DESC_IOTLB_INVALID_ENABLED 1
#define TRACE_VTD_INV_DESC_WAIT_SW_ENABLED 1
#define TRACE_VTD_INV_DESC_WAIT_IRQ_ENABLED 1
#define TRACE_VTD_INV_DESC_WAIT_INVALID_ENABLED 1
#define TRACE_VTD_INV_DESC_WAIT_WRITE_FAIL_ENABLED 1
#define TRACE_VTD_RE_NOT_PRESENT_ENABLED 1
#define TRACE_VTD_RE_INVALID_ENABLED 1
#define TRACE_VTD_CE_NOT_PRESENT_ENABLED 1
#define TRACE_VTD_CE_INVALID_ENABLED 1
#define TRACE_VTD_IOTLB_PAGE_HIT_ENABLED 1
#define TRACE_VTD_IOTLB_PAGE_UPDATE_ENABLED 1
#define TRACE_VTD_IOTLB_CC_HIT_ENABLED 1
#define TRACE_VTD_IOTLB_CC_UPDATE_ENABLED 1
#define TRACE_VTD_IOTLB_RESET_ENABLED 1
#define TRACE_VTD_FAULT_DISABLED_ENABLED 1
#define TRACE_AMDVI_EVNTLOG_FAIL_ENABLED 1
#define TRACE_AMDVI_CACHE_UPDATE_ENABLED 1
#define TRACE_AMDVI_COMPLETION_WAIT_FAIL_ENABLED 1
#define TRACE_AMDVI_MMIO_WRITE_ENABLED 1
#define TRACE_AMDVI_MMIO_READ_ENABLED 1
#define TRACE_AMDVI_MMIO_READ_INVALID_ENABLED 1
#define TRACE_AMDVI_COMMAND_ERROR_ENABLED 1
#define TRACE_AMDVI_COMMAND_READ_FAIL_ENABLED 1
#define TRACE_AMDVI_COMMAND_EXEC_ENABLED 1
#define TRACE_AMDVI_UNHANDLED_COMMAND_ENABLED 1
#define TRACE_AMDVI_INTR_INVAL_ENABLED 1
#define TRACE_AMDVI_IOTLB_INVAL_ENABLED 1
#define TRACE_AMDVI_PREFETCH_PAGES_ENABLED 1
#define TRACE_AMDVI_PAGES_INVAL_ENABLED 1
#define TRACE_AMDVI_ALL_INVAL_ENABLED 1
#define TRACE_AMDVI_PPR_EXEC_ENABLED 1
#define TRACE_AMDVI_DEVTAB_INVAL_ENABLED 1
#define TRACE_AMDVI_COMPLETION_WAIT_ENABLED 1
#define TRACE_AMDVI_CONTROL_STATUS_ENABLED 1
#define TRACE_AMDVI_IOTLB_RESET_ENABLED 1
#define TRACE_AMDVI_DTE_GET_FAIL_ENABLED 1
#define TRACE_AMDVI_INVALID_DTE_ENABLED 1
#define TRACE_AMDVI_GET_PTE_HWERROR_ENABLED 1
#define TRACE_AMDVI_MODE_INVALID_ENABLED 1
#define TRACE_AMDVI_PAGE_FAULT_ENABLED 1
#define TRACE_AMDVI_IOTLB_HIT_ENABLED 1
#define TRACE_AMDVI_TRANSLATION_RESULT_ENABLED 1
#include "qemu/log.h"


static inline void trace_x86_iommu_iec_notify(bool global, uint32_t index, uint32_t mask)
{
    if (true) {
        if (trace_event_get_state(TRACE_X86_IOMMU_IEC_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:x86_iommu_iec_notify " "Notify IEC invalidation: global=%d index=%" PRIu32 " mask=%" PRIu32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , global, index, mask);
        }
    }
}

static inline void trace_vtd_switch_address_space(uint8_t bus, uint8_t slot, uint8_t fn, bool on)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_SWITCH_ADDRESS_SPACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_switch_address_space " "Device %02x:%02x.%x switching address space (iommu enabled=%d)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, slot, fn, on);
        }
    }
}

static inline void trace_vtd_inv_desc(const char * type, uint64_t hi, uint64_t lo)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc " "invalidate desc type %s high 0x%"PRIx64" low 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , type, hi, lo);
        }
    }
}

static inline void trace_vtd_inv_desc_invalid(uint64_t hi, uint64_t lo)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_invalid " "invalid inv desc hi 0x%"PRIx64" lo 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hi, lo);
        }
    }
}

static inline void trace_vtd_inv_desc_cc_domain(uint16_t domain)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_CC_DOMAIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_cc_domain " "context invalidate domain 0x%"PRIx16 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , domain);
        }
    }
}

static inline void trace_vtd_inv_desc_cc_global(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_CC_GLOBAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_cc_global " "context invalidate globally" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_vtd_inv_desc_cc_device(uint8_t bus, uint8_t dev, uint8_t fn)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_CC_DEVICE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_cc_device " "context invalidate device %02"PRIx8":%02"PRIx8".%02"PRIx8 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, dev, fn);
        }
    }
}

static inline void trace_vtd_inv_desc_cc_devices(uint16_t sid, uint16_t fmask)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_CC_DEVICES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_cc_devices " "context invalidate devices sid 0x%"PRIx16" fmask 0x%"PRIx16 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , sid, fmask);
        }
    }
}

static inline void trace_vtd_inv_desc_cc_invalid(uint64_t hi, uint64_t lo)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_CC_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_cc_invalid " "invalid context-cache desc hi 0x%"PRIx64" lo 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hi, lo);
        }
    }
}

static inline void trace_vtd_inv_desc_iotlb_global(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_IOTLB_GLOBAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_iotlb_global " "iotlb invalidate global" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_vtd_inv_desc_iotlb_domain(uint16_t domain)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_IOTLB_DOMAIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_iotlb_domain " "iotlb invalidate whole domain 0x%"PRIx16 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , domain);
        }
    }
}

static inline void trace_vtd_inv_desc_iotlb_pages(uint16_t domain, uint64_t addr, uint8_t mask)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_IOTLB_PAGES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_iotlb_pages " "iotlb invalidate domain 0x%"PRIx16" addr 0x%"PRIx64" mask 0x%"PRIx8 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , domain, addr, mask);
        }
    }
}

static inline void trace_vtd_inv_desc_iotlb_invalid(uint64_t hi, uint64_t lo)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_IOTLB_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_iotlb_invalid " "invalid iotlb desc hi 0x%"PRIx64" lo 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hi, lo);
        }
    }
}

static inline void trace_vtd_inv_desc_wait_sw(uint64_t addr, uint32_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_WAIT_SW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_wait_sw " "wait invalidate status write addr 0x%"PRIx64" data 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, data);
        }
    }
}

static inline void trace_vtd_inv_desc_wait_irq(const char * msg)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_WAIT_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_wait_irq " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , msg);
        }
    }
}

static inline void trace_vtd_inv_desc_wait_invalid(uint64_t hi, uint64_t lo)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_WAIT_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_wait_invalid " "invalid wait desc hi 0x%"PRIx64" lo 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hi, lo);
        }
    }
}

static inline void trace_vtd_inv_desc_wait_write_fail(uint64_t hi, uint64_t lo)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_INV_DESC_WAIT_WRITE_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_inv_desc_wait_write_fail " "write fail for wait desc hi 0x%"PRIx64" lo 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hi, lo);
        }
    }
}

static inline void trace_vtd_re_not_present(uint8_t bus)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_RE_NOT_PRESENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_re_not_present " "Root entry bus %"PRIu8" not present" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus);
        }
    }
}

static inline void trace_vtd_re_invalid(uint64_t hi, uint64_t lo)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_RE_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_re_invalid " "invalid root entry hi 0x%"PRIx64" lo 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hi, lo);
        }
    }
}

static inline void trace_vtd_ce_not_present(uint8_t bus, uint8_t devfn)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_CE_NOT_PRESENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_ce_not_present " "Context entry bus %"PRIu8" devfn %"PRIu8" not present" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, devfn);
        }
    }
}

static inline void trace_vtd_ce_invalid(uint64_t hi, uint64_t lo)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_CE_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_ce_invalid " "invalid context entry hi 0x%"PRIx64" lo 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hi, lo);
        }
    }
}

static inline void trace_vtd_iotlb_page_hit(uint16_t sid, uint64_t addr, uint64_t slpte, uint16_t domain)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_IOTLB_PAGE_HIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_iotlb_page_hit " "IOTLB page hit sid 0x%"PRIx16" iova 0x%"PRIx64" slpte 0x%"PRIx64" domain 0x%"PRIx16 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , sid, addr, slpte, domain);
        }
    }
}

static inline void trace_vtd_iotlb_page_update(uint16_t sid, uint64_t addr, uint64_t slpte, uint16_t domain)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_IOTLB_PAGE_UPDATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_iotlb_page_update " "IOTLB page update sid 0x%"PRIx16" iova 0x%"PRIx64" slpte 0x%"PRIx64" domain 0x%"PRIx16 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , sid, addr, slpte, domain);
        }
    }
}

static inline void trace_vtd_iotlb_cc_hit(uint8_t bus, uint8_t devfn, uint64_t high, uint64_t low, uint32_t gen)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_IOTLB_CC_HIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_iotlb_cc_hit " "IOTLB context hit bus 0x%"PRIx8" devfn 0x%"PRIx8" high 0x%"PRIx64" low 0x%"PRIx64" gen %"PRIu32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, devfn, high, low, gen);
        }
    }
}

static inline void trace_vtd_iotlb_cc_update(uint8_t bus, uint8_t devfn, uint64_t high, uint64_t low, uint32_t gen1, uint32_t gen2)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_IOTLB_CC_UPDATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_iotlb_cc_update " "IOTLB context update bus 0x%"PRIx8" devfn 0x%"PRIx8" high 0x%"PRIx64" low 0x%"PRIx64" gen %"PRIu32" -> gen %"PRIu32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, devfn, high, low, gen1, gen2);
        }
    }
}

static inline void trace_vtd_iotlb_reset(const char * reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_IOTLB_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_iotlb_reset " "IOTLB reset (reason: %s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reason);
        }
    }
}

static inline void trace_vtd_fault_disabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_VTD_FAULT_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vtd_fault_disabled " "Fault processing disabled for context entry" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_amdvi_evntlog_fail(uint64_t addr, uint32_t head)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_EVNTLOG_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_evntlog_fail " "error: fail to write at addr 0x%"PRIx64" +  offset 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, head);
        }
    }
}

static inline void trace_amdvi_cache_update(uint16_t domid, uint8_t bus, uint8_t slot, uint8_t func, uint64_t gpa, uint64_t txaddr)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_CACHE_UPDATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_cache_update " " update iotlb domid 0x%"PRIx16" devid: %02x:%02x.%x gpa 0x%"PRIx64" hpa 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , domid, bus, slot, func, gpa, txaddr);
        }
    }
}

static inline void trace_amdvi_completion_wait_fail(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_COMPLETION_WAIT_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_completion_wait_fail " "error: fail to write at address 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_amdvi_mmio_write(const char * reg, uint64_t addr, unsigned size, uint64_t val, uint64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_MMIO_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_mmio_write " "%s write addr 0x%"PRIx64", size %u, val 0x%"PRIx64", offset 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg, addr, size, val, offset);
        }
    }
}

static inline void trace_amdvi_mmio_read(const char * reg, uint64_t addr, unsigned size, uint64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_MMIO_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_mmio_read " "%s read addr 0x%"PRIx64", size %u offset 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg, addr, size, offset);
        }
    }
}

static inline void trace_amdvi_mmio_read_invalid(int max, uint64_t addr, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_MMIO_READ_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_mmio_read_invalid " "error: addr outside region (max 0x%x): read addr 0x%" PRIx64 ", size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , max, addr, size);
        }
    }
}

static inline void trace_amdvi_command_error(uint64_t status)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_COMMAND_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_command_error " "error: Executing commands with command buffer disabled 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , status);
        }
    }
}

static inline void trace_amdvi_command_read_fail(uint64_t addr, uint32_t head)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_COMMAND_READ_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_command_read_fail " "error: fail to access memory at 0x%"PRIx64" + 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, head);
        }
    }
}

static inline void trace_amdvi_command_exec(uint32_t head, uint32_t tail, uint64_t buf)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_COMMAND_EXEC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_command_exec " "command buffer head at 0x%"PRIx32" command buffer tail at 0x%"PRIx32" command buffer base at 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , head, tail, buf);
        }
    }
}

static inline void trace_amdvi_unhandled_command(uint8_t type)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_UNHANDLED_COMMAND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_unhandled_command " "unhandled command 0x%"PRIx8 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , type);
        }
    }
}

static inline void trace_amdvi_intr_inval(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_INTR_INVAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_intr_inval " "Interrupt table invalidated" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_amdvi_iotlb_inval(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_IOTLB_INVAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_iotlb_inval " "IOTLB pages invalidated" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_amdvi_prefetch_pages(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_PREFETCH_PAGES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_prefetch_pages " "Pre-fetch of AMD-Vi pages requested" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_amdvi_pages_inval(uint16_t domid)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_PAGES_INVAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_pages_inval " "AMD-Vi pages for domain 0x%"PRIx16 " invalidated" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , domid);
        }
    }
}

static inline void trace_amdvi_all_inval(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_ALL_INVAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_all_inval " "Invalidation of all AMD-Vi cache requested " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_amdvi_ppr_exec(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_PPR_EXEC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_ppr_exec " "Execution of PPR queue requested " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_amdvi_devtab_inval(uint8_t bus, uint8_t slot, uint8_t func)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_DEVTAB_INVAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_devtab_inval " "device table entry for devid: %02x:%02x.%x invalidated" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, slot, func);
        }
    }
}

static inline void trace_amdvi_completion_wait(uint64_t addr, uint64_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_COMPLETION_WAIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_completion_wait " "completion wait requested with store address 0x%"PRIx64" and store data 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, data);
        }
    }
}

static inline void trace_amdvi_control_status(uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_CONTROL_STATUS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_control_status " "MMIO_STATUS state 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_amdvi_iotlb_reset(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_IOTLB_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_iotlb_reset " "IOTLB exceed size limit - reset " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_amdvi_dte_get_fail(uint64_t addr, uint32_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_DTE_GET_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_dte_get_fail " "error: failed to access Device Entry devtab 0x%"PRIx64" offset 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, offset);
        }
    }
}

static inline void trace_amdvi_invalid_dte(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_INVALID_DTE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_invalid_dte " "PTE entry at 0x%"PRIx64" is invalid " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_amdvi_get_pte_hwerror(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_GET_PTE_HWERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_get_pte_hwerror " "hardware error eccessing PTE at addr 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_amdvi_mode_invalid(uint8_t level, uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_MODE_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_mode_invalid " "error: translation level 0x%"PRIx8" translating addr 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , level, addr);
        }
    }
}

static inline void trace_amdvi_page_fault(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_PAGE_FAULT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_page_fault " "error: page fault accessing guest physical address 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_amdvi_iotlb_hit(uint8_t bus, uint8_t slot, uint8_t func, uint64_t addr, uint64_t txaddr)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_IOTLB_HIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_iotlb_hit " "hit iotlb devid %02x:%02x.%x gpa 0x%"PRIx64" hpa 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, slot, func, addr, txaddr);
        }
    }
}

static inline void trace_amdvi_translation_result(uint8_t bus, uint8_t slot, uint8_t func, uint64_t addr, uint64_t txaddr)
{
    if (true) {
        if (trace_event_get_state(TRACE_AMDVI_TRANSLATION_RESULT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:amdvi_translation_result " "devid: %02x:%02x.%x gpa 0x%"PRIx64" hpa 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, slot, func, addr, txaddr);
        }
    }
}
#endif /* TRACE_HW_I386_GENERATED_TRACERS_H */
