/* This file is autogenerated by tracetool, do not edit. */

#ifndef TRACE_ROOT_GENERATED_TRACERS_H
#define TRACE_ROOT_GENERATED_TRACERS_H

#include "qemu-common.h"
#include "trace/control.h"

extern TraceEvent _TRACE_CPU_IN_EVENT;
extern TraceEvent _TRACE_CPU_OUT_EVENT;
extern TraceEvent _TRACE_BALLOON_EVENT_EVENT;
extern TraceEvent _TRACE_VM_STATE_NOTIFY_EVENT;
extern TraceEvent _TRACE_LOAD_FILE_EVENT;
extern TraceEvent _TRACE_RUNSTATE_SET_EVENT;
extern TraceEvent _TRACE_SYSTEM_WAKEUP_REQUEST_EVENT;
extern TraceEvent _TRACE_QEMU_SYSTEM_SHUTDOWN_REQUEST_EVENT;
extern TraceEvent _TRACE_QEMU_SYSTEM_POWERDOWN_REQUEST_EVENT;
extern TraceEvent _TRACE_SPICE_VMC_WRITE_EVENT;
extern TraceEvent _TRACE_SPICE_VMC_READ_EVENT;
extern TraceEvent _TRACE_SPICE_VMC_REGISTER_INTERFACE_EVENT;
extern TraceEvent _TRACE_SPICE_VMC_UNREGISTER_INTERFACE_EVENT;
extern TraceEvent _TRACE_SPICE_VMC_EVENT_EVENT;
extern TraceEvent _TRACE_XEN_RAM_ALLOC_EVENT;
extern TraceEvent _TRACE_XEN_CLIENT_SET_MEMORY_EVENT;
extern TraceEvent _TRACE_HANDLE_IOREQ_EVENT;
extern TraceEvent _TRACE_HANDLE_IOREQ_READ_EVENT;
extern TraceEvent _TRACE_HANDLE_IOREQ_WRITE_EVENT;
extern TraceEvent _TRACE_CPU_IOREQ_PIO_EVENT;
extern TraceEvent _TRACE_CPU_IOREQ_PIO_READ_REG_EVENT;
extern TraceEvent _TRACE_CPU_IOREQ_PIO_WRITE_REG_EVENT;
extern TraceEvent _TRACE_CPU_IOREQ_MOVE_EVENT;
extern TraceEvent _TRACE_XEN_MAP_CACHE_EVENT;
extern TraceEvent _TRACE_XEN_REMAP_BUCKET_EVENT;
extern TraceEvent _TRACE_XEN_MAP_CACHE_RETURN_EVENT;
extern TraceEvent _TRACE_MONITOR_PROTOCOL_EVENT_HANDLER_EVENT;
extern TraceEvent _TRACE_MONITOR_PROTOCOL_EVENT_EMIT_EVENT;
extern TraceEvent _TRACE_MONITOR_PROTOCOL_EVENT_QUEUE_EVENT;
extern TraceEvent _TRACE_DMA_BLK_IO_EVENT;
extern TraceEvent _TRACE_DMA_AIO_CANCEL_EVENT;
extern TraceEvent _TRACE_DMA_COMPLETE_EVENT;
extern TraceEvent _TRACE_DMA_BLK_CB_EVENT;
extern TraceEvent _TRACE_DMA_MAP_WAIT_EVENT;
extern TraceEvent _TRACE_KVM_IOCTL_EVENT;
extern TraceEvent _TRACE_KVM_VM_IOCTL_EVENT;
extern TraceEvent _TRACE_KVM_VCPU_IOCTL_EVENT;
extern TraceEvent _TRACE_KVM_RUN_EXIT_EVENT;
extern TraceEvent _TRACE_KVM_DEVICE_IOCTL_EVENT;
extern TraceEvent _TRACE_KVM_FAILED_REG_GET_EVENT;
extern TraceEvent _TRACE_KVM_FAILED_REG_SET_EVENT;
extern TraceEvent _TRACE_KVM_IRQCHIP_COMMIT_ROUTES_EVENT;
extern TraceEvent _TRACE_KVM_IRQCHIP_ADD_MSI_ROUTE_EVENT;
extern TraceEvent _TRACE_KVM_IRQCHIP_UPDATE_MSI_ROUTE_EVENT;
extern TraceEvent _TRACE_EXEC_TB_EVENT;
extern TraceEvent _TRACE_EXEC_TB_NOCACHE_EVENT;
extern TraceEvent _TRACE_EXEC_TB_EXIT_EVENT;
extern TraceEvent _TRACE_TRANSLATE_BLOCK_EVENT;
extern TraceEvent _TRACE_MEMORY_REGION_OPS_READ_EVENT;
extern TraceEvent _TRACE_MEMORY_REGION_OPS_WRITE_EVENT;
extern TraceEvent _TRACE_MEMORY_REGION_SUBPAGE_READ_EVENT;
extern TraceEvent _TRACE_MEMORY_REGION_SUBPAGE_WRITE_EVENT;
extern TraceEvent _TRACE_MEMORY_REGION_TB_READ_EVENT;
extern TraceEvent _TRACE_MEMORY_REGION_TB_WRITE_EVENT;
extern TraceEvent _TRACE_MEMORY_REGION_RAM_DEVICE_READ_EVENT;
extern TraceEvent _TRACE_MEMORY_REGION_RAM_DEVICE_WRITE_EVENT;
extern TraceEvent _TRACE_GUEST_CPU_ENTER_EVENT;
extern TraceEvent _TRACE_GUEST_CPU_EXIT_EVENT;
extern TraceEvent _TRACE_GUEST_CPU_RESET_EVENT;
extern TraceEvent _TRACE_GUEST_MEM_BEFORE_TRANS_EVENT;
extern TraceEvent _TRACE_GUEST_MEM_BEFORE_EXEC_EVENT;
extern TraceEvent _TRACE_GUEST_USER_SYSCALL_EVENT;
extern TraceEvent _TRACE_GUEST_USER_SYSCALL_RET_EVENT;
extern uint16_t _TRACE_CPU_IN_DSTATE;
extern uint16_t _TRACE_CPU_OUT_DSTATE;
extern uint16_t _TRACE_BALLOON_EVENT_DSTATE;
extern uint16_t _TRACE_VM_STATE_NOTIFY_DSTATE;
extern uint16_t _TRACE_LOAD_FILE_DSTATE;
extern uint16_t _TRACE_RUNSTATE_SET_DSTATE;
extern uint16_t _TRACE_SYSTEM_WAKEUP_REQUEST_DSTATE;
extern uint16_t _TRACE_QEMU_SYSTEM_SHUTDOWN_REQUEST_DSTATE;
extern uint16_t _TRACE_QEMU_SYSTEM_POWERDOWN_REQUEST_DSTATE;
extern uint16_t _TRACE_SPICE_VMC_WRITE_DSTATE;
extern uint16_t _TRACE_SPICE_VMC_READ_DSTATE;
extern uint16_t _TRACE_SPICE_VMC_REGISTER_INTERFACE_DSTATE;
extern uint16_t _TRACE_SPICE_VMC_UNREGISTER_INTERFACE_DSTATE;
extern uint16_t _TRACE_SPICE_VMC_EVENT_DSTATE;
extern uint16_t _TRACE_XEN_RAM_ALLOC_DSTATE;
extern uint16_t _TRACE_XEN_CLIENT_SET_MEMORY_DSTATE;
extern uint16_t _TRACE_HANDLE_IOREQ_DSTATE;
extern uint16_t _TRACE_HANDLE_IOREQ_READ_DSTATE;
extern uint16_t _TRACE_HANDLE_IOREQ_WRITE_DSTATE;
extern uint16_t _TRACE_CPU_IOREQ_PIO_DSTATE;
extern uint16_t _TRACE_CPU_IOREQ_PIO_READ_REG_DSTATE;
extern uint16_t _TRACE_CPU_IOREQ_PIO_WRITE_REG_DSTATE;
extern uint16_t _TRACE_CPU_IOREQ_MOVE_DSTATE;
extern uint16_t _TRACE_XEN_MAP_CACHE_DSTATE;
extern uint16_t _TRACE_XEN_REMAP_BUCKET_DSTATE;
extern uint16_t _TRACE_XEN_MAP_CACHE_RETURN_DSTATE;
extern uint16_t _TRACE_MONITOR_PROTOCOL_EVENT_HANDLER_DSTATE;
extern uint16_t _TRACE_MONITOR_PROTOCOL_EVENT_EMIT_DSTATE;
extern uint16_t _TRACE_MONITOR_PROTOCOL_EVENT_QUEUE_DSTATE;
extern uint16_t _TRACE_DMA_BLK_IO_DSTATE;
extern uint16_t _TRACE_DMA_AIO_CANCEL_DSTATE;
extern uint16_t _TRACE_DMA_COMPLETE_DSTATE;
extern uint16_t _TRACE_DMA_BLK_CB_DSTATE;
extern uint16_t _TRACE_DMA_MAP_WAIT_DSTATE;
extern uint16_t _TRACE_KVM_IOCTL_DSTATE;
extern uint16_t _TRACE_KVM_VM_IOCTL_DSTATE;
extern uint16_t _TRACE_KVM_VCPU_IOCTL_DSTATE;
extern uint16_t _TRACE_KVM_RUN_EXIT_DSTATE;
extern uint16_t _TRACE_KVM_DEVICE_IOCTL_DSTATE;
extern uint16_t _TRACE_KVM_FAILED_REG_GET_DSTATE;
extern uint16_t _TRACE_KVM_FAILED_REG_SET_DSTATE;
extern uint16_t _TRACE_KVM_IRQCHIP_COMMIT_ROUTES_DSTATE;
extern uint16_t _TRACE_KVM_IRQCHIP_ADD_MSI_ROUTE_DSTATE;
extern uint16_t _TRACE_KVM_IRQCHIP_UPDATE_MSI_ROUTE_DSTATE;
extern uint16_t _TRACE_EXEC_TB_DSTATE;
extern uint16_t _TRACE_EXEC_TB_NOCACHE_DSTATE;
extern uint16_t _TRACE_EXEC_TB_EXIT_DSTATE;
extern uint16_t _TRACE_TRANSLATE_BLOCK_DSTATE;
extern uint16_t _TRACE_MEMORY_REGION_OPS_READ_DSTATE;
extern uint16_t _TRACE_MEMORY_REGION_OPS_WRITE_DSTATE;
extern uint16_t _TRACE_MEMORY_REGION_SUBPAGE_READ_DSTATE;
extern uint16_t _TRACE_MEMORY_REGION_SUBPAGE_WRITE_DSTATE;
extern uint16_t _TRACE_MEMORY_REGION_TB_READ_DSTATE;
extern uint16_t _TRACE_MEMORY_REGION_TB_WRITE_DSTATE;
extern uint16_t _TRACE_MEMORY_REGION_RAM_DEVICE_READ_DSTATE;
extern uint16_t _TRACE_MEMORY_REGION_RAM_DEVICE_WRITE_DSTATE;
extern uint16_t _TRACE_GUEST_CPU_ENTER_DSTATE;
extern uint16_t _TRACE_GUEST_CPU_EXIT_DSTATE;
extern uint16_t _TRACE_GUEST_CPU_RESET_DSTATE;
extern uint16_t _TRACE_GUEST_MEM_BEFORE_TRANS_DSTATE;
extern uint16_t _TRACE_GUEST_MEM_BEFORE_EXEC_DSTATE;
extern uint16_t _TRACE_GUEST_USER_SYSCALL_DSTATE;
extern uint16_t _TRACE_GUEST_USER_SYSCALL_RET_DSTATE;
#define TRACE_CPU_IN_ENABLED 1
#define TRACE_CPU_OUT_ENABLED 1
#define TRACE_BALLOON_EVENT_ENABLED 1
#define TRACE_VM_STATE_NOTIFY_ENABLED 1
#define TRACE_LOAD_FILE_ENABLED 1
#define TRACE_RUNSTATE_SET_ENABLED 1
#define TRACE_SYSTEM_WAKEUP_REQUEST_ENABLED 1
#define TRACE_QEMU_SYSTEM_SHUTDOWN_REQUEST_ENABLED 1
#define TRACE_QEMU_SYSTEM_POWERDOWN_REQUEST_ENABLED 1
#define TRACE_SPICE_VMC_WRITE_ENABLED 1
#define TRACE_SPICE_VMC_READ_ENABLED 1
#define TRACE_SPICE_VMC_REGISTER_INTERFACE_ENABLED 1
#define TRACE_SPICE_VMC_UNREGISTER_INTERFACE_ENABLED 1
#define TRACE_SPICE_VMC_EVENT_ENABLED 1
#define TRACE_XEN_RAM_ALLOC_ENABLED 1
#define TRACE_XEN_CLIENT_SET_MEMORY_ENABLED 1
#define TRACE_HANDLE_IOREQ_ENABLED 1
#define TRACE_HANDLE_IOREQ_READ_ENABLED 1
#define TRACE_HANDLE_IOREQ_WRITE_ENABLED 1
#define TRACE_CPU_IOREQ_PIO_ENABLED 1
#define TRACE_CPU_IOREQ_PIO_READ_REG_ENABLED 1
#define TRACE_CPU_IOREQ_PIO_WRITE_REG_ENABLED 1
#define TRACE_CPU_IOREQ_MOVE_ENABLED 1
#define TRACE_XEN_MAP_CACHE_ENABLED 1
#define TRACE_XEN_REMAP_BUCKET_ENABLED 1
#define TRACE_XEN_MAP_CACHE_RETURN_ENABLED 1
#define TRACE_MONITOR_PROTOCOL_EVENT_HANDLER_ENABLED 1
#define TRACE_MONITOR_PROTOCOL_EVENT_EMIT_ENABLED 1
#define TRACE_MONITOR_PROTOCOL_EVENT_QUEUE_ENABLED 1
#define TRACE_DMA_BLK_IO_ENABLED 1
#define TRACE_DMA_AIO_CANCEL_ENABLED 1
#define TRACE_DMA_COMPLETE_ENABLED 1
#define TRACE_DMA_BLK_CB_ENABLED 1
#define TRACE_DMA_MAP_WAIT_ENABLED 1
#define TRACE_KVM_IOCTL_ENABLED 1
#define TRACE_KVM_VM_IOCTL_ENABLED 1
#define TRACE_KVM_VCPU_IOCTL_ENABLED 1
#define TRACE_KVM_RUN_EXIT_ENABLED 1
#define TRACE_KVM_DEVICE_IOCTL_ENABLED 1
#define TRACE_KVM_FAILED_REG_GET_ENABLED 1
#define TRACE_KVM_FAILED_REG_SET_ENABLED 1
#define TRACE_KVM_IRQCHIP_COMMIT_ROUTES_ENABLED 1
#define TRACE_KVM_IRQCHIP_ADD_MSI_ROUTE_ENABLED 1
#define TRACE_KVM_IRQCHIP_UPDATE_MSI_ROUTE_ENABLED 1
#define TRACE_EXEC_TB_ENABLED 0
#define TRACE_EXEC_TB_NOCACHE_ENABLED 0
#define TRACE_EXEC_TB_EXIT_ENABLED 0
#define TRACE_TRANSLATE_BLOCK_ENABLED 1
#define TRACE_MEMORY_REGION_OPS_READ_ENABLED 1
#define TRACE_MEMORY_REGION_OPS_WRITE_ENABLED 1
#define TRACE_MEMORY_REGION_SUBPAGE_READ_ENABLED 1
#define TRACE_MEMORY_REGION_SUBPAGE_WRITE_ENABLED 1
#define TRACE_MEMORY_REGION_TB_READ_ENABLED 1
#define TRACE_MEMORY_REGION_TB_WRITE_ENABLED 1
#define TRACE_MEMORY_REGION_RAM_DEVICE_READ_ENABLED 1
#define TRACE_MEMORY_REGION_RAM_DEVICE_WRITE_ENABLED 1
#define TRACE_GUEST_CPU_ENTER_ENABLED 1
#define TRACE_GUEST_CPU_EXIT_ENABLED 1
#define TRACE_GUEST_CPU_RESET_ENABLED 1
#define TRACE_GUEST_MEM_BEFORE_TRANS_ENABLED 0
#define TRACE_GUEST_MEM_BEFORE_ENABLED 0
#define TRACE_GUEST_MEM_BEFORE_EXEC_ENABLED 0
#define TRACE_GUEST_USER_SYSCALL_ENABLED 0
#define TRACE_GUEST_USER_SYSCALL_RET_ENABLED 0
#include "qemu/log.h"


static inline void trace_cpu_in(unsigned int addr, char size, unsigned int val)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_IN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_in " "addr %#x(%c) value %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, size, val);
        }
    }
}

static inline void trace_cpu_out(unsigned int addr, char size, unsigned int val)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_OUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_out " "addr %#x(%c) value %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, size, val);
        }
    }
}

static inline void trace_balloon_event(void * opaque, unsigned long addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_BALLOON_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:balloon_event " "opaque %p addr %lu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr);
        }
    }
}

static inline void trace_vm_state_notify(int running, int reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_VM_STATE_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vm_state_notify " "running %d reason %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , running, reason);
        }
    }
}

static inline void trace_load_file(const char * name, const char * path)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOAD_FILE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:load_file " "name %s location %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, path);
        }
    }
}

static inline void trace_runstate_set(int new_state)
{
    if (true) {
        if (trace_event_get_state(TRACE_RUNSTATE_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:runstate_set " "new state %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , new_state);
        }
    }
}

static inline void trace_system_wakeup_request(int reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_SYSTEM_WAKEUP_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:system_wakeup_request " "reason=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reason);
        }
    }
}

static inline void trace_qemu_system_shutdown_request(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SYSTEM_SHUTDOWN_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_system_shutdown_request " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_system_powerdown_request(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SYSTEM_POWERDOWN_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_system_powerdown_request " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_spice_vmc_write(ssize_t out, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPICE_VMC_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spice_vmc_write " "spice wrote %zd of requested %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , out, len);
        }
    }
}

static inline void trace_spice_vmc_read(int bytes, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPICE_VMC_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spice_vmc_read " "spice read %d of requested %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bytes, len);
        }
    }
}

static inline void trace_spice_vmc_register_interface(void * scd)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPICE_VMC_REGISTER_INTERFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spice_vmc_register_interface " "spice vmc registered interface %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , scd);
        }
    }
}

static inline void trace_spice_vmc_unregister_interface(void * scd)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPICE_VMC_UNREGISTER_INTERFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spice_vmc_unregister_interface " "spice vmc unregistered interface %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , scd);
        }
    }
}

static inline void trace_spice_vmc_event(int event)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPICE_VMC_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spice_vmc_event " "spice vmc event %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event);
        }
    }
}

static inline void trace_xen_ram_alloc(unsigned long ram_addr, unsigned long size)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_RAM_ALLOC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_ram_alloc " "requested: %#lx, size %#lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ram_addr, size);
        }
    }
}

static inline void trace_xen_client_set_memory(uint64_t start_addr, unsigned long size, bool log_dirty)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_CLIENT_SET_MEMORY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_client_set_memory " "%#"PRIx64" size %#lx, log_dirty %i" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start_addr, size, log_dirty);
        }
    }
}

static inline void trace_handle_ioreq(void * req, uint32_t type, uint32_t dir, uint32_t df, uint32_t data_is_ptr, uint64_t addr, uint64_t data, uint32_t count, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_HANDLE_IOREQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:handle_ioreq " "I/O=%p type=%d dir=%d df=%d ptr=%d port=%#"PRIx64" data=%#"PRIx64" count=%d size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, type, dir, df, data_is_ptr, addr, data, count, size);
        }
    }
}

static inline void trace_handle_ioreq_read(void * req, uint32_t type, uint32_t df, uint32_t data_is_ptr, uint64_t addr, uint64_t data, uint32_t count, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_HANDLE_IOREQ_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:handle_ioreq_read " "I/O=%p read type=%d df=%d ptr=%d port=%#"PRIx64" data=%#"PRIx64" count=%d size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, type, df, data_is_ptr, addr, data, count, size);
        }
    }
}

static inline void trace_handle_ioreq_write(void * req, uint32_t type, uint32_t df, uint32_t data_is_ptr, uint64_t addr, uint64_t data, uint32_t count, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_HANDLE_IOREQ_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:handle_ioreq_write " "I/O=%p write type=%d df=%d ptr=%d port=%#"PRIx64" data=%#"PRIx64" count=%d size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, type, df, data_is_ptr, addr, data, count, size);
        }
    }
}

static inline void trace_cpu_ioreq_pio(void * req, uint32_t dir, uint32_t df, uint32_t data_is_ptr, uint64_t addr, uint64_t data, uint32_t count, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_IOREQ_PIO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_ioreq_pio " "I/O=%p pio dir=%d df=%d ptr=%d port=%#"PRIx64" data=%#"PRIx64" count=%d size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, dir, df, data_is_ptr, addr, data, count, size);
        }
    }
}

static inline void trace_cpu_ioreq_pio_read_reg(void * req, uint64_t data, uint64_t addr, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_IOREQ_PIO_READ_REG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_ioreq_pio_read_reg " "I/O=%p pio read reg data=%#"PRIx64" port=%#"PRIx64" size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, data, addr, size);
        }
    }
}

static inline void trace_cpu_ioreq_pio_write_reg(void * req, uint64_t data, uint64_t addr, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_IOREQ_PIO_WRITE_REG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_ioreq_pio_write_reg " "I/O=%p pio write reg data=%#"PRIx64" port=%#"PRIx64" size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, data, addr, size);
        }
    }
}

static inline void trace_cpu_ioreq_move(void * req, uint32_t dir, uint32_t df, uint32_t data_is_ptr, uint64_t addr, uint64_t data, uint32_t count, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_IOREQ_MOVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_ioreq_move " "I/O=%p copy dir=%d df=%d ptr=%d port=%#"PRIx64" data=%#"PRIx64" count=%d size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, dir, df, data_is_ptr, addr, data, count, size);
        }
    }
}

static inline void trace_xen_map_cache(uint64_t phys_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_MAP_CACHE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_map_cache " "want %#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , phys_addr);
        }
    }
}

static inline void trace_xen_remap_bucket(uint64_t index)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_REMAP_BUCKET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_remap_bucket " "index %#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_xen_map_cache_return(void* ptr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_MAP_CACHE_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_map_cache_return " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ptr);
        }
    }
}

static inline void trace_monitor_protocol_event_handler(uint32_t event, void * qdict)
{
    if (true) {
        if (trace_event_get_state(TRACE_MONITOR_PROTOCOL_EVENT_HANDLER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:monitor_protocol_event_handler " "event=%d data=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event, qdict);
        }
    }
}

static inline void trace_monitor_protocol_event_emit(uint32_t event, void * data)
{
    if (true) {
        if (trace_event_get_state(TRACE_MONITOR_PROTOCOL_EVENT_EMIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:monitor_protocol_event_emit " "event=%d data=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event, data);
        }
    }
}

static inline void trace_monitor_protocol_event_queue(uint32_t event, void * qdict, uint64_t rate)
{
    if (true) {
        if (trace_event_get_state(TRACE_MONITOR_PROTOCOL_EVENT_QUEUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:monitor_protocol_event_queue " "event=%d data=%p rate=%" PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event, qdict, rate);
        }
    }
}

static inline void trace_dma_blk_io(void * dbs, void * bs, int64_t offset, bool to_dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_DMA_BLK_IO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:dma_blk_io " "dbs=%p bs=%p offset=%" PRId64 " to_dev=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dbs, bs, offset, to_dev);
        }
    }
}

static inline void trace_dma_aio_cancel(void * dbs)
{
    if (true) {
        if (trace_event_get_state(TRACE_DMA_AIO_CANCEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:dma_aio_cancel " "dbs=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dbs);
        }
    }
}

static inline void trace_dma_complete(void * dbs, int ret, void * cb)
{
    if (true) {
        if (trace_event_get_state(TRACE_DMA_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:dma_complete " "dbs=%p ret=%d cb=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dbs, ret, cb);
        }
    }
}

static inline void trace_dma_blk_cb(void * dbs, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_DMA_BLK_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:dma_blk_cb " "dbs=%p ret=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dbs, ret);
        }
    }
}

static inline void trace_dma_map_wait(void * dbs)
{
    if (true) {
        if (trace_event_get_state(TRACE_DMA_MAP_WAIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:dma_map_wait " "dbs=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dbs);
        }
    }
}

static inline void trace_kvm_ioctl(int type, void * arg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_IOCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_ioctl " "type 0x%x, arg %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , type, arg);
        }
    }
}

static inline void trace_kvm_vm_ioctl(int type, void * arg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_VM_IOCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_vm_ioctl " "type 0x%x, arg %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , type, arg);
        }
    }
}

static inline void trace_kvm_vcpu_ioctl(int cpu_index, int type, void * arg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_VCPU_IOCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_vcpu_ioctl " "cpu_index %d, type 0x%x, arg %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, type, arg);
        }
    }
}

static inline void trace_kvm_run_exit(int cpu_index, uint32_t reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_RUN_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_run_exit " "cpu_index %d, reason %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, reason);
        }
    }
}

static inline void trace_kvm_device_ioctl(int fd, int type, void * arg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_DEVICE_IOCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_device_ioctl " "dev fd %d, type 0x%x, arg %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fd, type, arg);
        }
    }
}

static inline void trace_kvm_failed_reg_get(uint64_t id, const char * msg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_FAILED_REG_GET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_failed_reg_get " "Warning: Unable to retrieve ONEREG %" PRIu64 " from KVM: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, msg);
        }
    }
}

static inline void trace_kvm_failed_reg_set(uint64_t id, const char * msg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_FAILED_REG_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_failed_reg_set " "Warning: Unable to set ONEREG %" PRIu64 " to KVM: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, msg);
        }
    }
}

static inline void trace_kvm_irqchip_commit_routes(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_IRQCHIP_COMMIT_ROUTES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_irqchip_commit_routes " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_kvm_irqchip_add_msi_route(int virq)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_IRQCHIP_ADD_MSI_ROUTE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_irqchip_add_msi_route " "Adding MSI route virq=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , virq);
        }
    }
}

static inline void trace_kvm_irqchip_update_msi_route(int virq)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_IRQCHIP_UPDATE_MSI_ROUTE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_irqchip_update_msi_route " "Updating MSI route virq=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , virq);
        }
    }
}

static inline void trace_exec_tb(void * tb, uintptr_t pc)
{
    if (true) {
    }
}

static inline void trace_exec_tb_nocache(void * tb, uintptr_t pc)
{
    if (true) {
    }
}

static inline void trace_exec_tb_exit(void * last_tb, unsigned int flags)
{
    if (true) {
    }
}

static inline void trace_translate_block(void * tb, uintptr_t pc, uint8_t * tb_code)
{
    if (true) {
        if (trace_event_get_state(TRACE_TRANSLATE_BLOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:translate_block " "tb:%p, pc:0x%"PRIxPTR", tb_code:%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tb, pc, tb_code);
        }
    }
}

static inline void trace_memory_region_ops_read(int cpu_index, void * mr, uint64_t addr, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_OPS_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_ops_read " "cpu %d mr %p addr %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, mr, addr, value, size);
        }
    }
}

static inline void trace_memory_region_ops_write(int cpu_index, void * mr, uint64_t addr, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_OPS_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_ops_write " "cpu %d mr %p addr %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, mr, addr, value, size);
        }
    }
}

static inline void trace_memory_region_subpage_read(int cpu_index, void * mr, uint64_t offset, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_SUBPAGE_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_subpage_read " "cpu %d mr %p offset %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, mr, offset, value, size);
        }
    }
}

static inline void trace_memory_region_subpage_write(int cpu_index, void * mr, uint64_t offset, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_SUBPAGE_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_subpage_write " "cpu %d mr %p offset %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, mr, offset, value, size);
        }
    }
}

static inline void trace_memory_region_tb_read(int cpu_index, uint64_t addr, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_TB_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_tb_read " "cpu %d addr %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, addr, value, size);
        }
    }
}

static inline void trace_memory_region_tb_write(int cpu_index, uint64_t addr, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_TB_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_tb_write " "cpu %d addr %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, addr, value, size);
        }
    }
}

static inline void trace_memory_region_ram_device_read(int cpu_index, void * mr, uint64_t addr, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_RAM_DEVICE_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_ram_device_read " "cpu %d mr %p addr %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, mr, addr, value, size);
        }
    }
}

static inline void trace_memory_region_ram_device_write(int cpu_index, void * mr, uint64_t addr, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_RAM_DEVICE_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_ram_device_write " "cpu %d mr %p addr %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, mr, addr, value, size);
        }
    }
}

static inline void trace_guest_cpu_enter(CPUState * __cpu)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_CPU_ENTER)) {
        if (true) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:guest_cpu_enter " "cpu=%p " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , __cpu);
        }
    }
}

static inline void trace_guest_cpu_exit(CPUState * __cpu)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_CPU_EXIT)) {
        if (true) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:guest_cpu_exit " "cpu=%p " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , __cpu);
        }
    }
}

static inline void trace_guest_cpu_reset(CPUState * __cpu)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_CPU_RESET)) {
        if (true) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:guest_cpu_reset " "cpu=%p " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , __cpu);
        }
    }
}

static inline void trace_guest_mem_before_trans(CPUState * __cpu, uint8_t info)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_MEM_BEFORE_TRANS)) {
    }
}

static inline void trace_guest_mem_before_exec(CPUState * __cpu, uint64_t vaddr, uint8_t info)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_MEM_BEFORE_EXEC)) {
    }
}

static inline void trace_guest_user_syscall(CPUState * __cpu, uint64_t num, uint64_t arg1, uint64_t arg2, uint64_t arg3, uint64_t arg4, uint64_t arg5, uint64_t arg6, uint64_t arg7, uint64_t arg8)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_USER_SYSCALL)) {
    }
}

static inline void trace_guest_user_syscall_ret(CPUState * __cpu, uint64_t num, uint64_t ret)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_USER_SYSCALL_RET)) {
    }
}
#endif /* TRACE_ROOT_GENERATED_TRACERS_H */
