# FORCE_EFI_BOOT

echo -off
# +
# + ============================================================== +
#  Copyright (c) 2018, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  Startup.nsh

#  Abstract:  UEFI Script file for invoking system software updates.

# + ============================================================== +
#    Program all blocks of BIOS from capsule file 
# + ============================================================== +

@echo -off
mode 80 25
;foundimage section is simply to locate the correct drive
cls

for %d in fs0 fs1 fs2 fs3 fs4 fs5 fs6 fs7 fs8 fs9
    set -v drive %d
    # echo Searching for %drive%:\Startup.nsh
    if exist %drive%:\startup.nsh then
        echo Located STARTUP.nsh in %drive%:\
        goto FOUNDIMAGE
    endif
endfor
 echo "Unable to find test Packages".  
 echo "Please mount the drive with the Utilities package".
 echo ""
 goto END
:FOUNDIMAGE
%drive%:

if exist BMC.flg then
 goto continue
endif

echo ==========================================================================
echo "This utility will update the BMC firmware, system BIOS, ME firmware,"
echo "and FRU & SDR data on the following Intel products: 
echo ""
echo "      - Intel(R) Server Board S1400xx, S1600xx, S2400xx, S2600xx, W2600xx,
echo "                            & S4600xx V1 & V2
echo ""
echo "Press 'ESC' to abort updates or they will start automatically in 10 seconds"
echo ""
echo ""
echo "Do NOT reboot the server during any update process. Updates that have"
echo "completed successfully will display an update completion message "
echo ==========================================================================
stall 10000000

echo ""
echo "BMC_i_0128r11044 is being installed."
echo "BMC_i_0128r11044 is being installed." > BMC.flg
echo ""
FWPIAUPD -u -bin -ni -b -o -pia -nopc -if=usb BMC_i_0128r11044.bin
echo ""
echo "BMC update completed"
:continue
echo ""
echo "BIOS 02.06.E006 is being installed."
  iflash32 /u /ni R02.06.E006.cap
echo ""
echo "BIOS update completed."

set -v ME MEComplete_02.01.07.328.cap
frusdr /d fru > fru.txt
Grepx64.efi fru.txt "Product Name(ASCII)             :" Greplog.log *

if %GREPVALUE1% == S2600JF then
   set -v ME MEComplete_02.01.07.328_HFW.cap
endif

if %GREPVALUE1% == S2600WP then
   set -v ME MEComplete_02.01.07.328_HFW.cap
endif

if %GREPVALUE1% == S2600LP then
   set -v ME MEComplete_02.01.07.328_HFW.cap
endif

if %GREPVALUE1% == SVRBD-LAN_T then
   set -v ME MEComplete_02.01.07.328_LHP.cap
endif

if %GREPVALUE1% == SVRBD-ROW_P then
   set -v ME MEComplete_02.01.07.328_LHP.cap
endif

if %GREPVALUE1% == SVRBD-ROW_T then
   set -v ME MEComplete_02.01.07.328_LHP.cap
endif

echo ""
echo "ME firmware 02.01.07.328 is being installed."
  iflash32 /u /ni %ME% 
echo ""
echo "ME firmware update completed."


echo ""
echo "FRUSDR being installed."

cd %Grepvalue1%
%drive%:\frusdr.efi -cfg master.cfg
echo ""
echo "FRUSDR update completed."
echo ""
echo ""
cd \
del BMC.flg 
del Greplog.log
del fru.txt
echo "Updates completed. Please remove the USB key and reboot using the front panel button."
echo ""

:END

