/*
 * This Source is licenced under the NASA OPEN SOURCE AGREEMENT VERSION 1.3
 *
 * Copyright (C) 2012 United States Government as represented by the Administrator of the
 * National Aeronautics and Space Administration.
 * All Rights Reserved.
 *
 * Modifications by MAVinci GmbH, Germany (C) 2009-2016:
 * adapted from nasa sources to support own credit types
 */
package eu.mavinci.desktop.gui.wwext;

import gov.nasa.worldwind.avlist.AVList;

import java.awt.Point;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class MScreenCreditAnnotation extends ScreenCreditAnnotation implements ICreditIndivSize {

    MScreenCreditAnnotation(String text, String link, boolean isLocalized) {
        super(text, new Point(100, 100), link, isLocalized);
    }

    @Override
    public int getPreferredHeight() {
        return HEIGHT;
    }

    @Override
    public int getPreferredWidth() {
        return WIDTH;
    }

    static HashMap<String, WeakReference<MScreenCreditAnnotation>> hashMap =
        new HashMap<String, WeakReference<MScreenCreditAnnotation>>(2000);
    static ReferenceQueue<MScreenCreditAnnotation> queue = new ReferenceQueue<MScreenCreditAnnotation>();

    public static MScreenCreditAnnotation create(AVList configParams) {
        return create(
            configParams.getStringValue(WWFactory.KEY_AV_ScreencreditText),
            configParams.getStringValue(WWFactory.KEY_AV_ScreencreditLink),
            false);
    }

    /**
     * use caching of ScreenCredits this delivers the same object if it is called a second time with the same text this
     * will enable WWJ to show identical credits only once, even if multiple data sources (e.g. different geoTiffs) like
     * to show the same credit
     *
     * @param text
     * @param link
     * @return
     */
    public static MScreenCreditAnnotation create(String text, String link, boolean isLocalized) {
        // cleanup cache
        Reference<? extends MScreenCreditAnnotation> oldRef = queue.poll();
        while (oldRef != null) {
            hashMap.remove(oldRef);
            oldRef = queue.poll();
        }

        WeakReference<MScreenCreditAnnotation> ref = hashMap.get(text);

        MScreenCreditAnnotation screenCredit = null;
        if (ref != null) {
            screenCredit = ref.get();
        }
        // System.out.println("get img for from cache:" + f);
        if (screenCredit == null) {
            // System.out.println(" cache miss!");
            screenCredit = new MScreenCreditAnnotation(text, link, isLocalized);
            hashMap.put(text, new WeakReference<MScreenCreditAnnotation>(screenCredit, queue));
        }

        return screenCredit;
    }

}
