/*
 * This Source is licenced under the NASA OPEN SOURCE AGREEMENT VERSION 1.3
 *
 * Copyright (C) 2012 United States Government as represented by the Administrator of the
 * National Aeronautics and Space Administration.
 * All Rights Reserved.
 *
 * Modifications by MAVinci GmbH, Germany (C) 2009-2016:
 * adapted from nasa sources to support own credit types
 */
package eu.mavinci.desktop.gui.wwext;

import eu.mavinci.desktop.helper.FileHelper;
import eu.mavinci.desktop.main.debug.Debug;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenCredit;
import gov.nasa.worldwind.render.ScreenCreditController;
import gov.nasa.worldwind.render.ScreenCreditImage;
import gov.nasa.worldwind.util.Logging;
import eu.mavinci.desktop.helper.FileHelper;
import eu.mavinci.desktop.main.debug.Debug;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class MScreenCreditController extends ScreenCreditController {

    private int creditWidth = ScreenCreditAnnotation.WIDTH;
    private int creditHeight = ScreenCreditAnnotation.HEIGHT;
    private int leftMargin = 12;
    private int bottomMargin = 12;
    private int separation = 5;
    private double baseOpacity = 0.5;
    private double baseOpacityImage = 0.9;
    private double highlightOpacity = 1;

    public MScreenCreditController(WorldWindow wwd) {
        super(wwd);
    }

    public void pick(DrawContext dc, Point pickPoint) {
        if (dc == null) {
            String msg = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }

        if (dc.getScreenCredits() == null || dc.getScreenCredits().size() < 1) {
            return;
        }

        Set<Map.Entry<ScreenCredit, Long>> credits = dc.getScreenCredits().entrySet();

        // int y = dc.getDrawableHeight() - (bottomMargin + creditHeight / 2);
        int y = (bottomMargin);
        int x = leftMargin; // + creditWidth / 2;

        for (Map.Entry<ScreenCredit, Long> entry : credits) {
            ScreenCredit credit = entry.getKey();
            int prevHeight = creditHeight;
            int prevWidth = creditWidth;
            if (credit instanceof ICreditIndivSize) {
                ICreditIndivSize indHeight = (ICreditIndivSize)credit;
                prevHeight = indHeight.getPreferredHeight();
                prevWidth = indHeight.getPreferredWidth();
            }

            if (credit instanceof ScreenCreditImage) {
                // System.out.println(dc.getView().getViewport());
                credit.setViewport(
                    new Rectangle(
                        x + prevWidth / 2,
                        dc.getView().getViewport().height - y - prevHeight / 2,
                        prevWidth,
                        prevHeight));
            } else {
                credit.setViewport(new Rectangle(x, y, prevWidth, prevHeight));
            }

            credit.pick(dc, pickPoint);

            y += (separation + prevHeight);
            // x += (separation + creditWidth);
        }
    }

    public void selected(SelectEvent event) {
        // overloading to trigger opening directly on FIRST click!

        Object po = event.getTopObject();

        if (po != null && po instanceof ScreenCredit) {
            if (event.getEventAction().equals(SelectEvent.LEFT_CLICK)) {
                ScreenCredit credit = (ScreenCredit)po;
                // openBrowser((ScreenCredit) po);
                // FIXME return to WWJ function later
                try {
                    FileHelper.openFileOrURL(credit.getLink());
                } catch (Exception e) {
                    Debug.getLog().log(Level.WARNING, "Could not asssureStarted Browser for this URL", e);
                }
            }
        }
    };

    public void render(DrawContext dc) {
        if (dc == null) {
            String msg = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }

        if (dc.getScreenCredits() == null || dc.getScreenCredits().size() < 1) {
            return;
        }

        Set<Map.Entry<ScreenCredit, Long>> credits = dc.getScreenCredits().entrySet();

        // int y = dc.getDrawableHeight() - (bottomMargin + creditHeight / 2);
        int y = (bottomMargin);
        int x = leftMargin; // + creditWidth / 2;

        for (Map.Entry<ScreenCredit, Long> entry : credits) {
            ScreenCredit credit = entry.getKey();
            int prevHeight = creditHeight;
            int prevWidth = creditWidth;
            if (credit instanceof ICreditIndivSize) {
                ICreditIndivSize indHeight = (ICreditIndivSize)credit;
                prevHeight = indHeight.getPreferredHeight();
                prevWidth = indHeight.getPreferredWidth();
            }

            if (credit instanceof ScreenCreditImage) {
                // System.out.println(dc.getView().getViewport());
                credit.setViewport(
                    new Rectangle(
                        x + prevWidth / 2,
                        dc.getView().getViewport().height - y - prevHeight / 2,
                        prevWidth,
                        prevHeight));
            } else {
                credit.setViewport(new Rectangle(x, y, prevWidth, prevHeight));
            }

            if (entry.getValue() == dc.getFrameTimeStamp()) {
                Object po = dc.getPickedObjects().getTopObject();
                if (credit instanceof ScreenCreditImage) {
                    credit.setOpacity(
                        po != null && po instanceof ScreenCredit ? this.highlightOpacity : this.baseOpacityImage);
                } else {
                    credit.setOpacity(
                        po != null && po instanceof ScreenCredit ? this.highlightOpacity : this.baseOpacity);
                }

                credit.render(dc);
            }

            y += (separation + prevHeight);
            // x += (separation + creditWidth);
        }
    }

}
