set TV=RES3TV360
set FV=RES3FV288
set model=NONE

@echo off
cls
REM # Check for arguments
if [%1] == [] (GOTO NOARG)
REM # Pass in device name from arg
set dn=%~1
set mf="B010"
REM # Print device name to screen
REM #echo.
REM echo "%dn%"
if exist exp_found.txt del exp_found.txt
REM storcli -adpsetprop exposeEnclDevicesEnbl 1 -aall > NULL
storcli /c0 set backplane expose=on > NULL
ping localhost > null
REM # Check minimum firmware level is on expander
sg_inq "%dn%" | findstr %mf% >NUL

if %errorlevel% equ 0 (
	echo.
	echo "The expander doesn't meet the minimum firmware version required."
	echo "Flash the expander firmware up to B011 before updating any further"
	goto END
)

REM # Check expander model
sg_inq "%dn%" | findstr "RES3" >> exp_found.txt
rem sg_scan -s | findstr "JBOD"
rem sg_scan -s | findstr "RES3" > exp_found.txt
for /f "tokens=3,4 delims= " %%Z in (exp_found.txt) do set model=%%Z
REM echo expander found: %model%
if %model%==NONE goto WRONG
echo updating the CPLD code on expander model %model% on SCSI address %dn%
echo:
if %model%==%TV% (call fw_tool2.bat --cpld_update ..\..\cpld\TV_p00363_20171130.bin %dn%
                      goto FINE )
if %model%==%FV% (call fw_tool2.bat --cpld_update ..\..\cpld\FV_p00361_20171130.bin %dn%
                      goto FINE )

:WRONG
cls
echo:
echo:
echo SCSI address provided is wrong.  Please verify and make sure its double quoted !
echo:
echo:
echo:
goto END
:FINE
TIMEOUT 10 /NOBREAK
echo.
echo POWER CYCLE THE EXPANDER !
echo:
REM storcli -adpsetprop exposeEnclDevicesEnbl 0 -aall > NULL
storcli /c0 set backplane expose=off > NULL
ping localhost > null
goto END
:NOARG
echo no arguments provided, please read the Windows_CPLD_Update_README file for instructions.
:END

