# We have to override the new %%install behavior because, well... the kernel is special.
%global __spec_install_pre %{___build_pre}

Summary: The Linux kernel

# % define buildid .local

# For a kernel released for public testing, released_kernel should be 1.
# For internal testing builds during development, it should be 0.
%global released_kernel 1

%global distro_build 693
%define vcarevision .2.2.29.VCA

%define rpmversion 3.10.0
%define orig_pkgrelease 693.11.6.el7
%define pkgrelease 693.11.6.el7%{vcarevision}

%define pkg_release %{pkgrelease}%{?buildid}

# The kernel tarball/base version
%define rheltarball %{rpmversion}-%{orig_pkgrelease}

# What parts do we want to build?  We must build at least one kernel.
# These are the kernels that are built IF the architecture allows it.
# All should default to 1 (enabled) and be flipped to 0 (disabled)
# by later arch-specific checks.

# The following build options are enabled by default.
# Use either --without <opt> in your rpmbuild command or force values
# to 0 in here to disable them.
#
# kernel
%define with_default   %{?_without_default:   0} %{?!_without_default:   1}
# kernel-debug
%define with_debug     %{?_without_debug:     0} %{?!_without_debug:     1}
# kernel-doc
%define with_doc       %{?_without_doc:       0} %{?!_without_doc:       1}
# kernel-headers
%define with_headers   %{?_without_headers:   0} %{?!_without_headers:   1}
# perf
%define with_perf      %{?_without_perf:      0} %{?!_without_perf:      1}
# tools
%define with_tools     %{?_without_tools:     0} %{?!_without_tools:     1}
# kernel-debuginfo
%define with_debuginfo %{?_without_debuginfo: 0} %{?!_without_debuginfo: 1}
# kernel-kdump (only for s390x)
%define with_kdump     %{?_without_kdump:     0} %{?!_without_kdump:     0}
# kernel-bootwrapper (for creating zImages from kernel + initrd)
%define with_bootwrapper %{?_without_bootwrapper: 0} %{?!_without_bootwrapper: 0}
# kernel-abi-whitelists
%define with_kernel_abi_whitelists %{?_with_kernel_abi_whitelists: 0} %{?!_with_kernel_abi_whitelists: 1}

# In RHEL, we always want the doc build failing to build to be a failure,
# which means settings this to false.
%define doc_build_fail false

# Additional options for user-friendly one-off kernel building:
#
# Only build the base kernel (--with baseonly):
%define with_baseonly  %{?_with_baseonly:     1} %{?!_with_baseonly:     0}
# Only build the debug kernel (--with dbgonly):
%define with_dbgonly   %{?_with_dbgonly:      1} %{?!_with_dbgonly:      0}

# Control whether we perform a compat. check against published ABI.
%define with_kabichk   %{?_without_kabichk:   0} %{?!_without_kabichk:   1}

# Control whether we perform a compat. check against DUP ABI.
%define with_kabidupchk 1

# should we do C=1 builds with sparse
%define with_sparse    %{?_with_sparse:       1} %{?!_with_sparse:       0}

# Cross compile requested?
%define with_cross    %{?_with_cross:         1} %{?!_with_cross:        0}

# Control wheter we package git stats for the last commit or not
%define with_commitstats %{?_with_commitstats: 1} %{?!_with_commitstats: 0}

# Set debugbuildsenabled to 1 for production (build separate debug kernels)
#  and 0 for rawhide (all kernels are debug kernels).
# See also 'make debug' and 'make release'. RHEL only ever does 1.
%define debugbuildsenabled 1

%define with_gcov %{?_with_gcov: 1} %{?!_with_gcov: 0}

# turn off debug kernel and kabichk for gcov builds
%if %{with_gcov}
%define with_debug 0
%define with_kabichk 0
%endif

# turn off kABI DUP check if kABI check is disabled
%if !%{with_kabichk}
%define with_kabidupchk 0
%endif

%define make_target bzImage

# Kernel Version Release + Arch -> KVRA
%define KVRA %{version}-%{release}.%{_target_cpu}
%define hdrarch %{_target_cpu}
%define asmarch %{_target_cpu}
%define cross_target %{_target_cpu}

%if !%{debugbuildsenabled}
%define with_debug 0
%endif

%if !%{with_debuginfo}
%define _enable_debug_packages 0
%endif
%define debuginfodir /usr/lib/debug

# if requested, only build base kernel
%if %{with_baseonly}
%define with_debug 0
%define with_kdump 0
%endif

# if requested, only build debug kernel
%if %{with_dbgonly}
%define with_default 0
%define with_kdump 0
%define with_tools 0
%define with_perf 0
%endif

# These arches install vdso/ directories.
%define vdso_arches %{all_x86} x86_64 ppc ppc64 ppc64le s390 s390x

# Overrides for generic default options

# only build kernel-debug on x86_64, s390x, ppc64 ppc64le
%ifnarch x86_64 s390x ppc64 ppc64le
%define with_debug 0
%endif

# only package docs noarch
%ifnarch noarch
%define with_doc 0
%define with_kernel_abi_whitelists 0
%endif

# don't build noarch kernels or headers (duh)
%ifarch noarch
%define with_default 0
%define with_headers 0
%define with_tools 0
%define with_perf 0
%define all_arch_configs kernel-%{version}-*.config
%endif

# sparse blows up on ppc64
%ifarch ppc64 ppc64le ppc
%define with_sparse 0
%endif

# Per-arch tweaks

%ifarch i686
%define asmarch x86
%define hdrarch i386
%endif

%ifarch x86_64
%define asmarch x86
%define all_arch_configs kernel-%{version}-x86_64*.config
%define image_install_path boot
%define kernel_image arch/x86/boot/bzImage
%endif

%ifarch ppc
%define asmarch powerpc
%define hdrarch powerpc
%endif

%ifarch ppc64 ppc64le
%define asmarch powerpc
%define hdrarch powerpc
%define all_arch_configs kernel-%{version}-ppc64*.config
%define image_install_path boot
%define make_target vmlinux
%define kernel_image vmlinux
%define kernel_image_elf 1
%define with_bootwrapper 1
%define cross_target powerpc64
%define kcflags -O3
%endif

%ifarch s390x
%define asmarch s390
%define hdrarch s390
%define all_arch_configs kernel-%{version}-s390x*.config
%define image_install_path boot
%define kernel_image arch/s390/boot/bzImage
%define with_tools 0
%define with_kdump 1
%endif

#cross compile make
%if %{with_cross}
%define cross_opts CROSS_COMPILE=%{cross_target}-linux-gnu-
%define with_perf 0
%define with_tools 0
%endif

# Should make listnewconfig fail if there's config options
# printed out?
%define listnewconfig_fail 1

# To temporarily exclude an architecture from being built, add it to
# %%nobuildarches. Do _NOT_ use the ExclusiveArch: line, because if we
# don't build kernel-headers then the new build system will no longer let
# us use the previous build of that package -- it'll just be completely AWOL.
# Which is a BadThing(tm).

# We only build kernel-headers on the following...
%define nobuildarches i686 s390 ppc

%ifarch %nobuildarches
%define with_default 0
%define with_debuginfo 0
%define with_kdump 0
%define with_tools 0
%define with_perf 0
%define _enable_debug_packages 0
%endif

# Architectures we build tools/cpupower on
%define cpupowerarchs x86_64 ppc64 ppc64le

# Architectures where we compress modules
%ifarch x86_64
%define zipmodules 1
%else
%define zipmodules 0
%endif

#
# Three sets of minimum package version requirements in the form of Conflicts:
# to versions below the minimum
#

#
# First the general kernel 2.6 required versions as per
# Documentation/Changes
#
%define kernel_dot_org_conflicts  ppp < 2.4.3-3, isdn4k-utils < 3.2-32, nfs-utils < 1.0.7-12, e2fsprogs < 1.37-4, util-linux < 2.12, jfsutils < 1.1.7-2, reiserfs-utils < 3.6.19-2, xfsprogs < 2.6.13-4, procps < 3.2.5-6.3, oprofile < 0.9.1-2, device-mapper-libs < 1.02.63-2, mdadm < 3.2.1-5

#
# Then a series of requirements that are distribution specific, either
# because we add patches for something, or the older versions have
# problems with the newer kernel or lack certain things that make
# integration in the distro harder than needed.
#
%define package_conflicts initscripts < 7.23, udev < 063-6, iptables < 1.3.2-1, ipw2200-firmware < 2.4, iwl4965-firmware < 228.57.2, selinux-policy-targeted < 1.25.3-14, squashfs-tools < 4.0, wireless-tools < 29-3, xfsprogs < 4.3.0, kmod < 20-9, kexec-tools < 2.0.14-3

# We moved the drm include files into kernel-headers, make sure there's
# a recent enough libdrm-devel on the system that doesn't have those.
%define kernel_headers_conflicts libdrm-devel < 2.4.0-0.15

#
# Packages that need to be installed before the kernel is, because the %%post
# scripts use them.
#
%define kernel_prereq  fileutils, module-init-tools >= 3.16-2, initscripts >= 8.11.1-1, grubby >= 8.28-2
%define initrd_prereq  dracut >= 033-502

#
# This macro does requires, provides, conflicts, obsoletes for a kernel package.
#	%%kernel_reqprovconf <subpackage>
# It uses any kernel_<subpackage>_conflicts and kernel_<subpackage>_obsoletes
# macros defined above.
#
%define kernel_reqprovconf \
Provides: kernel = %{rpmversion}-%{pkg_release}\
Provides: kernel-%{_target_cpu} = %{rpmversion}-%{pkg_release}%{?1:.%{1}}\
Provides: kernel-drm = 4.3.0\
Provides: kernel-drm-nouveau = 16\
Provides: kernel-modeset = 1\
Provides: kernel-uname-r = %{KVRA}%{?1:.%{1}}\
Requires(pre): %{kernel_prereq}\
Requires(pre): %{initrd_prereq}\
Requires(pre): linux-firmware >= 20170606-55\
Requires(post): %{_sbindir}/new-kernel-pkg\
Requires(post): system-release\
Requires(preun): %{_sbindir}/new-kernel-pkg\
Conflicts: %{kernel_dot_org_conflicts}\
Conflicts: %{package_conflicts}\
%{expand:%%{?kernel%{?1:_%{1}}_conflicts:Conflicts: %%{kernel%{?1:_%{1}}_conflicts}}}\
%{expand:%%{?kernel%{?1:_%{1}}_obsoletes:Obsoletes: %%{kernel%{?1:_%{1}}_obsoletes}}}\
%{expand:%%{?kernel%{?1:_%{1}}_provides:Provides: %%{kernel%{?1:_%{1}}_provides}}}\
# We can't let RPM do the dependencies automatic because it'll then pick up\
# a correct but undesirable perl dependency from the module headers which\
# isn't required for the kernel proper to function\
AutoReq: no\
AutoProv: yes\
%{nil}

Name: kernel%{?variant}
Group: System Environment/Kernel
License: GPLv2
URL: http://www.kernel.org/
Version: %{rpmversion}
Release: %{pkg_release}
# DO NOT CHANGE THE 'ExclusiveArch' LINE TO TEMPORARILY EXCLUDE AN ARCHITECTURE BUILD.
# SET %%nobuildarches (ABOVE) INSTEAD
ExclusiveArch: noarch i686 x86_64 ppc ppc64 ppc64le s390 s390x
ExclusiveOS: Linux

%kernel_reqprovconf

#
# List the packages used during the kernel build
#
BuildRequires: module-init-tools, patch >= 2.5.4, bash >= 2.03, sh-utils, tar
BuildRequires: xz, findutils, gzip, m4, perl, make >= 3.78, diffutils, gawk
BuildRequires: gcc >= 3.4.2, binutils >= 2.25, redhat-rpm-config >= 9.1.0-55
BuildRequires: hostname, net-tools, bc
BuildRequires: xmlto, asciidoc
BuildRequires: openssl
BuildRequires: hmaccalc
BuildRequires: python-devel, newt-devel, perl(ExtUtils::Embed)
%ifarch x86_64
BuildRequires: pesign >= 0.109-4
%endif
%if %{with_sparse}
BuildRequires: sparse >= 0.4.1
%endif
%if %{with_perf}
BuildRequires: elfutils-devel zlib-devel binutils-devel bison
BuildRequires: audit-libs-devel
BuildRequires: java-devel
%ifnarch s390 s390x
BuildRequires: numactl-devel
%endif
%endif
%if %{with_tools}
BuildRequires: pciutils-devel gettext ncurses-devel
%endif
%if %{with_debuginfo}
# Fancy new debuginfo generation introduced in Fedora 8/RHEL 6.
# The -r flag to find-debuginfo.sh invokes eu-strip --reloc-debug-sections
# which reduces the number of relocations in kernel module .ko.debug files and
# was introduced with rpm 4.9 and elfutils 0.153.
BuildRequires: rpm-build >= 4.9.0-1, elfutils >= 0.153-1
%define debuginfo_args --strict-build-id -r
%endif
%ifarch s390x
# required for zfcpdump
BuildRequires: glibc-static
%endif

Source0: linux-%{rpmversion}-%{orig_pkgrelease}.tar.xz

Source1: Makefile.common

Source10: sign-modules
%define modsign_cmd %{SOURCE10}
Source11: x509.genkey
Source12: extra_certificates
%if %{?released_kernel}
Source13: centos.cer
Source14: secureboot.cer
%define pesign_name redhatsecureboot301
%else
Source13: centos.cer
Source14: secureboot.cer
%define pesign_name redhatsecureboot003
%endif
Source15: centos-ldup.x509
Source16: centos-kpatch.x509

Source18: check-kabi

Source20: Module.kabi_x86_64
Source21: Module.kabi_ppc64
Source22: Module.kabi_ppc64le
Source23: Module.kabi_s390x
Source24: Module.kabi_dup_x86_64
Source25: Module.kabi_dup_ppc64
Source26: Module.kabi_dup_ppc64le
Source27: Module.kabi_dup_s390x

Source30: kernel-abi-whitelists-%{distro_build}.tar.bz2

Source50: kernel-%{version}-x86_64.config
Source51: kernel-%{version}-x86_64-debug.config

Source60: kernel-%{version}-ppc64.config
Source61: kernel-%{version}-ppc64-debug.config
Source62: kernel-%{version}-ppc64le.config
Source63: kernel-%{version}-ppc64le-debug.config

Source70: kernel-%{version}-s390x.config
Source71: kernel-%{version}-s390x-debug.config
Source72: kernel-%{version}-s390x-kdump.config

# Sources for kernel-tools
Source2000: cpupower.service
Source2001: cpupower.config

# git stats for last commits can be used as source for smart tests
%if %{with_commitstats}
Source9999: lastcommit.stat
%endif

# empty final patch to facilitate testing of kernel patches
Patch999999: linux-kernel-test.patch
Patch1000: debrand-single-cpu.patch
Patch1001: debrand-rh_taint.patch
Patch1002: debrand-rh-i686-cpu.patch
Patch2000: vca_patches.patch

BuildRoot: %{_tmppath}/kernel-%{KVRA}-root

%description
The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system: memory allocation, process allocation, device
input and output, etc.


%package doc
Summary: Various documentation bits found in the kernel source
Group: Documentation
AutoReqProv: no
%description doc
This package contains documentation files from the kernel
source. Various bits of information about the Linux kernel and the
device drivers shipped with it are documented in these files.

You'll want to install this package if you need a reference to the
options that can be passed to Linux kernel modules at load time.


%package headers
Summary: Header files for the Linux kernel for use by glibc
Group: Development/System
Obsoletes: glibc-kernheaders < 3.0-46
Provides: glibc-kernheaders = 3.0-46
%description headers
Kernel-headers includes the C header files that specify the interface
between the Linux kernel and userspace libraries and programs.  The
header files define structures and constants that are needed for
building most standard programs and are also needed for rebuilding the
glibc package.

%package bootwrapper
Summary: Boot wrapper files for generating combined kernel + initrd images
Group: Development/System
Requires: gzip binutils
%description bootwrapper
Kernel-bootwrapper contains the wrapper code which makes bootable "zImage"
files combining both kernel and initial ramdisk.

%package debuginfo-common-%{_target_cpu}
Summary: Kernel source files used by %{name}-debuginfo packages
Group: Development/Debug
%description debuginfo-common-%{_target_cpu}
This package is required by %{name}-debuginfo subpackages.
It provides the kernel source files common to all builds.

%if %{with_perf}
%package -n perf
Summary: Performance monitoring for the Linux kernel
Group: Development/System
License: GPLv2
%description -n perf
This package contains the perf tool, which enables performance monitoring
of the Linux kernel.

%package -n perf-debuginfo
Summary: Debug information for package perf
Group: Development/Debug
Requires: %{name}-debuginfo-common-%{_target_cpu} = %{version}-%{release}
AutoReqProv: no
%description -n perf-debuginfo
This package provides debug information for the perf package.

# Note that this pattern only works right to match the .build-id
# symlinks because of the trailing nonmatching alternation and
# the leading .*, because of find-debuginfo.sh's buggy handling
# of matching the pattern against the symlinks file.
%{expand:%%global debuginfo_args %{?debuginfo_args} -p '.*%%{_bindir}/perf(\.debug)?|.*%%{_libexecdir}/perf-core/.*|XXX' -o perf-debuginfo.list}

%package -n python-perf
Summary: Python bindings for apps which will manipulate perf events
Group: Development/Libraries
%description -n python-perf
The python-perf package contains a module that permits applications
written in the Python programming language to use the interface
to manipulate perf events.

%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

%package -n python-perf-debuginfo
Summary: Debug information for package perf python bindings
Group: Development/Debug
Requires: %{name}-debuginfo-common-%{_target_cpu} = %{version}-%{release}
AutoReqProv: no
%description -n python-perf-debuginfo
This package provides debug information for the perf python bindings.

# the python_sitearch macro should already be defined from above
%{expand:%%global debuginfo_args %{?debuginfo_args} -p '.*%%{python_sitearch}/perf.so(\.debug)?|XXX' -o python-perf-debuginfo.list}


%endif # with_perf

%if %{with_tools}

%package -n kernel-tools
Summary: Assortment of tools for the Linux kernel
Group: Development/System
License: GPLv2
Provides:  cpupowerutils = 1:009-0.6.p1
Obsoletes: cpupowerutils < 1:009-0.6.p1
Provides:  cpufreq-utils = 1:009-0.6.p1
Provides:  cpufrequtils = 1:009-0.6.p1
Obsoletes: cpufreq-utils < 1:009-0.6.p1
Obsoletes: cpufrequtils < 1:009-0.6.p1
Obsoletes: cpuspeed < 1:2.0
Requires: kernel-tools-libs = %{version}-%{release}
%description -n kernel-tools
This package contains the tools/ directory from the kernel source
and the supporting documentation.

%package -n kernel-tools-libs
Summary: Libraries for the kernels-tools
Group: Development/System
License: GPLv2
%description -n kernel-tools-libs
This package contains the libraries built from the tools/ directory
from the kernel source.

%package -n kernel-tools-libs-devel
Summary: Assortment of tools for the Linux kernel
Group: Development/System
License: GPLv2
Requires: kernel-tools = %{version}-%{release}
Provides:  cpupowerutils-devel = 1:009-0.6.p1
Obsoletes: cpupowerutils-devel < 1:009-0.6.p1
Requires: kernel-tools-libs = %{version}-%{release}
Provides: kernel-tools-devel
%description -n kernel-tools-libs-devel
This package contains the development files for the tools/ directory from
the kernel source.

%package -n kernel-tools-debuginfo
Summary: Debug information for package kernel-tools
Group: Development/Debug
Requires: %{name}-debuginfo-common-%{_target_cpu} = %{version}-%{release}
AutoReqProv: no
%description -n kernel-tools-debuginfo
This package provides debug information for package kernel-tools.

# Note that this pattern only works right to match the .build-id
# symlinks because of the trailing nonmatching alternation and
# the leading .*, because of find-debuginfo.sh's buggy handling
# of matching the pattern against the symlinks file.
%{expand:%%global debuginfo_args %{?debuginfo_args} -p '.*%%{_bindir}/centrino-decode(\.debug)?|.*%%{_bindir}/powernow-k8-decode(\.debug)?|.*%%{_bindir}/cpupower(\.debug)?|.*%%{_libdir}/libcpupower.*|.*%%{_libdir}/libcpupower.*|.*%%{_bindir}/turbostat(\.debug)?|.*%%{_bindir}/x86_energy_perf_policy(\.debug)?|.*%%{_bindir}/tmon(\.debug)?|XXX' -o kernel-tools-debuginfo.list}

%endif # with_tools

%if %{with_gcov}
%package gcov
Summary: gcov graph and source files for coverage data collection.
Group: Development/System
%description gcov
kernel-gcov includes the gcov graph and source files for gcov coverage collection.
%endif

%package -n kernel-abi-whitelists
Summary: The CentOS Linux kernel ABI symbol whitelists
Group: System Environment/Kernel
AutoReqProv: no
%description -n kernel-abi-whitelists
The kABI package contains information pertaining to the CentOS
Linux kernel ABI, including lists of kernel symbols that are needed by
external Linux kernel modules, and a yum plugin to aid enforcement.

#
# This macro creates a kernel-<subpackage>-debuginfo package.
#	%%kernel_debuginfo_package <subpackage>
#
%define kernel_debuginfo_package() \
%package %{?1:%{1}-}debuginfo\
Summary: Debug information for package %{name}%{?1:-%{1}}\
Group: Development/Debug\
Requires: %{name}-debuginfo-common-%{_target_cpu} = %{version}-%{release}\
Provides: %{name}%{?1:-%{1}}-debuginfo-%{_target_cpu} = %{version}-%{release}\
AutoReqProv: no\
%description -n %{name}%{?1:-%{1}}-debuginfo\
This package provides debug information for package %{name}%{?1:-%{1}}.\
This is required to use SystemTap with %{name}%{?1:-%{1}}-%{KVRA}.\
%{expand:%%global debuginfo_args %{?debuginfo_args} -p '/.*/%%{KVRA}%{?1:\.%{1}}/.*|/.*%%{KVRA}%{?1:\.%{1}}(\.debug)?' -o debuginfo%{?1}.list}\
%{nil}

#
# This macro creates a kernel-<subpackage>-devel package.
#	%%kernel_devel_package <subpackage> <pretty-name>
#
%define kernel_devel_package() \
%package %{?1:%{1}-}devel\
Summary: Development package for building kernel modules to match the %{?2:%{2} }kernel\
Group: System Environment/Kernel\
Provides: kernel%{?1:-%{1}}-devel-%{_target_cpu} = %{version}-%{release}\
Provides: kernel-devel-%{_target_cpu} = %{version}-%{release}%{?1:.%{1}}\
Provides: kernel-devel-uname-r = %{KVRA}%{?1:.%{1}}\
AutoReqProv: no\
Requires(pre): /usr/bin/find\
Requires: perl\
%description -n kernel%{?variant}%{?1:-%{1}}-devel\
This package provides kernel headers and makefiles sufficient to build modules\
against the %{?2:%{2} }kernel package.\
%{nil}

#
# This macro creates a kernel-<subpackage> and its -devel and -debuginfo too.
#	%%define variant_summary The Linux kernel compiled for <configuration>
#	%%kernel_variant_package [-n <pretty-name>] <subpackage>
#
%define kernel_variant_package(n:) \
%package %1\
Summary: %{variant_summary}\
Group: System Environment/Kernel\
%kernel_reqprovconf\
%{expand:%%kernel_devel_package %1 %{!?-n:%1}%{?-n:%{-n*}}}\
%{expand:%%kernel_debuginfo_package %1}\
%{nil}


# First the auxiliary packages of the main kernel package.
%kernel_devel_package
%kernel_debuginfo_package


# Now, each variant package.

%define variant_summary The Linux kernel compiled with extra debugging enabled
%kernel_variant_package debug
%description debug
The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

This variant of the kernel has numerous debugging options enabled.
It should only be installed when trying to gather additional information
on kernel bugs, as some of these options impact performance noticably.

%define variant_summary A minimal Linux kernel compiled for crash dumps
%kernel_variant_package kdump
%description kdump
This package includes a kdump version of the Linux kernel. It is
required only on machines which will use the kexec-based kernel crash dump
mechanism.

%prep
# do a few sanity-checks for --with *only builds
%if %{with_baseonly}
%if !%{with_default}
echo "Cannot build --with baseonly, default kernel build is disabled"
exit 1
%endif
%endif

# more sanity checking; do it quietly
if [ "%{patches}" != "%%{patches}" ] ; then
  for patch in %{patches} ; do
    if [ ! -f $patch ] ; then
      echo "ERROR: Patch  ${patch##/*/}  listed in specfile but is missing"
      exit 1
    fi
  done
fi 2>/dev/null

patch_command='patch -p1 -F1 -s'
ApplyPatch()
{
  local patch=$1
  shift
  if [ ! -f $RPM_SOURCE_DIR/$patch ]; then
    exit 1
  fi
  if ! grep -E "^Patch[0-9]+: $patch\$" %{_specdir}/${RPM_PACKAGE_NAME%%%%%{?variant}}.spec ; then
    if [ "${patch:0:8}" != "patch-3." ] ; then
      echo "ERROR: Patch  $patch  not listed as a source patch in specfile"
      exit 1
    fi
  fi 2>/dev/null
  case "$patch" in
  *.bz2) bunzip2 < "$RPM_SOURCE_DIR/$patch" | $patch_command ${1+"$@"} ;;
  *.gz) gunzip < "$RPM_SOURCE_DIR/$patch" | $patch_command ${1+"$@"} ;;
  *) $patch_command ${1+"$@"} < "$RPM_SOURCE_DIR/$patch" ;;
  esac
}

# don't apply patch if it's empty
ApplyOptionalPatch()
{
  local patch=$1
  shift
  if [ ! -f $RPM_SOURCE_DIR/$patch ]; then
    exit 1
  fi
  local C=$(wc -l $RPM_SOURCE_DIR/$patch | awk '{print $1}')
  if [ "$C" -gt 9 ]; then
    ApplyPatch $patch ${1+"$@"}
  fi
}

%setup -q -n kernel-%{rheltarball} -c
mv linux-%{rheltarball} linux-%{KVRA}
cd linux-%{KVRA}

# Drop some necessary files from the source dir into the buildroot
cp $RPM_SOURCE_DIR/kernel-%{version}-*.config .

ApplyOptionalPatch linux-kernel-test.patch
ApplyOptionalPatch debrand-single-cpu.patch
ApplyOptionalPatch debrand-rh_taint.patch
ApplyOptionalPatch debrand-rh-i686-cpu.patch
ApplyOptionalPatch vca_patches.patch

# Any further pre-build tree manipulations happen here.

chmod +x scripts/checkpatch.pl

# This Prevents scripts/setlocalversion from mucking with our version numbers.
touch .scmversion

# only deal with configs if we are going to build for the arch
%ifnarch %nobuildarches

if [ -L configs ]; then
	rm -f configs
	mkdir configs
fi

# Remove configs not for the buildarch
for cfg in kernel-%{version}-*.config; do
  if [ `echo %{all_arch_configs} | grep -c $cfg` -eq 0 ]; then
    rm -f $cfg
  fi
done

%if !%{debugbuildsenabled}
rm -f kernel-%{version}-*debug.config
%endif

# enable GCOV kernel config options if gcov is on
%if %{with_gcov}
for i in *.config
do
  sed -i 's/# CONFIG_GCOV_KERNEL is not set/CONFIG_GCOV_KERNEL=y\nCONFIG_GCOV_PROFILE_ALL=y\n/' $i
done
%endif

# now run oldconfig over all the config files
for i in *.config
do
  mv $i .config
  Arch=`head -1 .config | cut -b 3-`
  make %{?cross_opts} ARCH=$Arch listnewconfig | grep -E '^CONFIG_' >.newoptions || true
%if %{listnewconfig_fail}
  if [ -s .newoptions ]; then
    cat .newoptions
    exit 1
  fi
%endif
  rm -f .newoptions
  make %{?cross_opts} ARCH=$Arch oldnoconfig
  echo "# $Arch" > configs/$i
  cat .config >> configs/$i
done
# end of kernel config
%endif

# get rid of unwanted files resulting from patch fuzz
find . \( -name "*.orig" -o -name "*~" \) -exec rm -f {} \; >/dev/null

# remove unnecessary SCM files
find . -name .gitignore -exec rm -f {} \; >/dev/null

cd ..

###
### build
###
%build

%if %{with_sparse}
%define sparse_mflags	C=1
%endif

%if %{with_debuginfo}
# This override tweaks the kernel makefiles so that we run debugedit on an
# object before embedding it.  When we later run find-debuginfo.sh, it will
# run debugedit again.  The edits it does change the build ID bits embedded
# in the stripped object, but repeating debugedit is a no-op.  We do it
# beforehand to get the proper final build ID bits into the embedded image.
# This affects the vDSO images in vmlinux, and the vmlinux image in bzImage.
export AFTER_LINK='sh -xc "/usr/lib/rpm/debugedit -b $$RPM_BUILD_DIR -d /usr/src/debug -i $@ > $@.id"'
%endif

cp_vmlinux()
{
  eu-strip --remove-comment -o "$2" "$1"
}

BuildKernel() {
    MakeTarget=$1
    KernelImage=$2
    Flavour=$3
    InstallName=${4:-vmlinuz}

    # Pick the right config file for the kernel we're building
    Config=kernel-%{version}-%{_target_cpu}${Flavour:+-${Flavour}}.config
    DevelDir=/usr/src/kernels/%{KVRA}${Flavour:+.${Flavour}}

    # When the bootable image is just the ELF kernel, strip it.
    # We already copy the unstripped file into the debuginfo package.
    if [ "$KernelImage" = vmlinux ]; then
      CopyKernel=cp_vmlinux
    else
      CopyKernel=cp
    fi

    KernelVer=%{KVRA}${Flavour:+.${Flavour}}
    echo BUILDING A KERNEL FOR ${Flavour} %{_target_cpu}...

    # make sure EXTRAVERSION says what we want it to say
    perl -p -i -e "s/^EXTRAVERSION.*/EXTRAVERSION = -%{release}.%{_target_cpu}${Flavour:+.${Flavour}}/" Makefile

    # and now to start the build process

    make %{?cross_opts} -s mrproper

    cp %{SOURCE11} .	# x509.genkey
    cp %{SOURCE12} .	# extra_certificates
    cp %{SOURCE15} .	# rheldup3.x509
    cp %{SOURCE16} .	# rhelkpatch1.x509

    cp configs/$Config .config

    Arch=`head -1 .config | cut -b 3-`
    echo USING ARCH=$Arch

%ifarch s390x
    if [ "$Flavour" == "kdump" ]; then
        pushd arch/s390/boot
        gcc -static -o zfcpdump zfcpdump.c
        popd
    fi
%endif

    make -s %{?cross_opts} ARCH=$Arch oldnoconfig >/dev/null
    make -s %{?cross_opts} ARCH=$Arch V=1 %{?_smp_mflags} KCFLAGS="%{?kcflags}" WITH_GCOV="%{?with_gcov}" $MakeTarget %{?sparse_mflags}

    if [ "$Flavour" != "kdump" ]; then
        make -s %{?cross_opts} ARCH=$Arch V=1 %{?_smp_mflags} KCFLAGS="%{?kcflags}" WITH_GCOV="%{?with_gcov}" modules %{?sparse_mflags} || exit 1
    fi

    # Start installing the results
%if %{with_debuginfo}
    mkdir -p $RPM_BUILD_ROOT%{debuginfodir}/boot
    mkdir -p $RPM_BUILD_ROOT%{debuginfodir}/%{image_install_path}
%endif
    mkdir -p $RPM_BUILD_ROOT/%{image_install_path}
    install -m 644 .config $RPM_BUILD_ROOT/boot/config-$KernelVer
    install -m 644 System.map $RPM_BUILD_ROOT/boot/System.map-$KernelVer

    # We estimate the size of the initramfs because rpm needs to take this size
    # into consideration when performing disk space calculations. (See bz #530778)
    dd if=/dev/zero of=$RPM_BUILD_ROOT/boot/initramfs-$KernelVer.img bs=1M count=20

    if [ -f arch/$Arch/boot/zImage.stub ]; then
      cp arch/$Arch/boot/zImage.stub $RPM_BUILD_ROOT/%{image_install_path}/zImage.stub-$KernelVer || :
    fi
# EFI SecureBoot signing, x86_64-only
%ifarch x86_64
    %pesign -s -i $KernelImage -o $KernelImage.signed -a %{SOURCE13} -c %{SOURCE13}
    mv $KernelImage.signed $KernelImage
%endif
    $CopyKernel $KernelImage $RPM_BUILD_ROOT/%{image_install_path}/$InstallName-$KernelVer
    chmod 755 $RPM_BUILD_ROOT/%{image_install_path}/$InstallName-$KernelVer

    # hmac sign the kernel for FIPS
    echo "Creating hmac file: $RPM_BUILD_ROOT/%{image_install_path}/.vmlinuz-$KernelVer.hmac"
    ls -l $RPM_BUILD_ROOT/%{image_install_path}/$InstallName-$KernelVer
    sha512hmac $RPM_BUILD_ROOT/%{image_install_path}/$InstallName-$KernelVer | sed -e "s,$RPM_BUILD_ROOT,," > $RPM_BUILD_ROOT/%{image_install_path}/.vmlinuz-$KernelVer.hmac;

    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/kernel
    if [ "$Flavour" != "kdump" ]; then
        # Override $(mod-fw) because we don't want it to install any firmware
        # we'll get it from the linux-firmware package and we don't want conflicts
        make -s %{?cross_opts} ARCH=$Arch INSTALL_MOD_PATH=$RPM_BUILD_ROOT modules_install KERNELRELEASE=$KernelVer mod-fw=
%if %{with_gcov}
	# install gcov-needed files to $BUILDROOT/$BUILD/...:
	#   gcov_info->filename is absolute path
	#   gcno references to sources can use absolute paths (e.g. in out-of-tree builds)
	#   sysfs symlink targets (set up at compile time) use absolute paths to BUILD dir
	find . \( -name '*.gcno' -o -name '*.[chS]' \) -exec install -D '{}' "$RPM_BUILD_ROOT/$(pwd)/{}" \;
%endif
    fi
%ifarch %{vdso_arches}
    make -s %{?cross_opts} ARCH=$Arch INSTALL_MOD_PATH=$RPM_BUILD_ROOT vdso_install KERNELRELEASE=$KernelVer
    if [ ! -s ldconfig-kernel.conf ]; then
      echo > ldconfig-kernel.conf "\
# Placeholder file, no vDSO hwcap entries used in this kernel."
    fi
    %{__install} -D -m 444 ldconfig-kernel.conf $RPM_BUILD_ROOT/etc/ld.so.conf.d/kernel-$KernelVer.conf
%endif

    # And save the headers/makefiles etc for building modules against
    #
    # This all looks scary, but the end result is supposed to be:
    # * all arch relevant include/ files
    # * all Makefile/Kconfig files
    # * all script/ files

    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/source
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    (cd $RPM_BUILD_ROOT/lib/modules/$KernelVer ; ln -s build source)
    # dirs for additional modules per module-init-tools, kbuild/modules.txt
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/extra
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/updates
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/weak-updates
    # first copy everything
    cp --parents `find  -type f -name "Makefile*" -o -name "Kconfig*"` $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    cp Module.symvers $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    cp System.map $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    if [ -s Module.markers ]; then
      cp Module.markers $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    fi

    # create the kABI metadata for use in packaging
    # NOTENOTE: the name symvers is used by the rpm backend
    # NOTENOTE: to discover and run the /usr/lib/rpm/fileattrs/kabi.attr
    # NOTENOTE: script which dynamically adds exported kernel symbol
    # NOTENOTE: checksums to the rpm metadata provides list.
    # NOTENOTE: if you change the symvers name, update the backend too
    echo "**** GENERATING kernel ABI metadata ****"
    gzip -c9 < Module.symvers > $RPM_BUILD_ROOT/boot/symvers-$KernelVer.gz

%if %{with_kabichk}
    echo "**** kABI checking is enabled in kernel SPEC file. ****"
    chmod 0755 $RPM_SOURCE_DIR/check-kabi
    if [ -e $RPM_SOURCE_DIR/Module.kabi_%{_target_cpu}$Flavour ]; then
        cp $RPM_SOURCE_DIR/Module.kabi_%{_target_cpu}$Flavour $RPM_BUILD_ROOT/Module.kabi
        $RPM_SOURCE_DIR/check-kabi -k $RPM_BUILD_ROOT/Module.kabi -s Module.symvers || exit 1
        rm $RPM_BUILD_ROOT/Module.kabi # for now, don't keep it around.
    else
        echo "**** NOTE: Cannot find reference Module.kabi file. ****"
    fi
%endif

%if %{with_kabidupchk}
    echo "**** kABI DUP checking is enabled in kernel SPEC file. ****"
    if [ -e $RPM_SOURCE_DIR/Module.kabi_dup_%{_target_cpu}$Flavour ]; then
        cp $RPM_SOURCE_DIR/Module.kabi_dup_%{_target_cpu}$Flavour $RPM_BUILD_ROOT/Module.kabi
        $RPM_SOURCE_DIR/check-kabi -k $RPM_BUILD_ROOT/Module.kabi -s Module.symvers || exit 1
        rm $RPM_BUILD_ROOT/Module.kabi # for now, don't keep it around.
    else
        echo "**** NOTE: Cannot find DUP reference Module.kabi file. ****"
    fi
%endif

    # then drop all but the needed Makefiles/Kconfig files
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/Documentation
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    cp .config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    cp -a scripts $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    if [ -d arch/$Arch/scripts ]; then
      cp -a arch/$Arch/scripts $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{_arch} || :
    fi
    if [ -f arch/$Arch/*lds ]; then
      cp -a arch/$Arch/*lds $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{_arch}/ || :
    fi
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/*.o
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/*/*.o
%ifarch ppc64 ppc64le
    cp -a --parents arch/powerpc/lib/crtsavres.[So] $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/
%endif
    if [ -d arch/%{asmarch}/include ]; then
      cp -a --parents arch/%{asmarch}/include $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/
    fi
    cp -a include $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include

    # copy objtool for kernel-devel (needed for building external modules)
    if grep -q CONFIG_STACK_VALIDATION=y .config; then
      mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/tools/objtool
      cp -a tools/objtool/objtool $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/tools/objtool
    fi

    # Make sure the Makefile and version.h have a matching timestamp so that
    # external modules can be built
    touch -r $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/Makefile $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/generated/uapi/linux/version.h
    touch -r $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/.config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/generated/autoconf.h
    # Copy .config to include/config/auto.conf so "make prepare" is unnecessary.
    cp $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/.config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/config/auto.conf

%if %{with_debuginfo}
    if test -s vmlinux.id; then
      cp vmlinux.id $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/vmlinux.id
    else
      echo >&2 "*** ERROR *** no vmlinux build ID! ***"
      exit 1
    fi

    #
    # save the vmlinux file for kernel debugging into the kernel-debuginfo rpm
    #
    mkdir -p $RPM_BUILD_ROOT%{debuginfodir}/lib/modules/$KernelVer
    cp vmlinux $RPM_BUILD_ROOT%{debuginfodir}/lib/modules/$KernelVer
%endif

    find $RPM_BUILD_ROOT/lib/modules/$KernelVer -name "*.ko" -type f >modnames

    # mark modules executable so that strip-to-file can strip them
    xargs --no-run-if-empty chmod u+x < modnames

    # Generate a list of modules for block and networking.

    grep -F /drivers/ modnames | xargs --no-run-if-empty nm -upA |
    sed -n 's,^.*/\([^/]*\.ko\):  *U \(.*\)$,\1 \2,p' > drivers.undef

    collect_modules_list()
    {
      sed -r -n -e "s/^([^ ]+) \\.?($2)\$/\\1/p" drivers.undef |
      LC_ALL=C sort -u > $RPM_BUILD_ROOT/lib/modules/$KernelVer/modules.$1
      if [ ! -z "$3" ]; then
        sed -r -e "/^($3)\$/d" -i $RPM_BUILD_ROOT/lib/modules/$KernelVer/modules.$1
      fi
    }

    collect_modules_list networking 'register_netdev|ieee80211_register_hw|usbnet_probe|phy_driver_register|rt2x00(pci|usb)_probe|register_netdevice'
    collect_modules_list block 'ata_scsi_ioctl|scsi_add_host|scsi_add_host_with_dma|blk_alloc_queue|blk_init_queue|register_mtd_blktrans|scsi_esp_register|scsi_register_device_handler|blk_queue_physical_block_size' 'pktcdvd.ko|dm-mod.ko'
    collect_modules_list drm 'drm_open|drm_init'
    collect_modules_list modesetting 'drm_crtc_init'

    # detect missing or incorrect license tags
    rm -f modinfo
    while read i
    do
      echo -n "${i#$RPM_BUILD_ROOT/lib/modules/$KernelVer/} " >> modinfo
      /sbin/modinfo -l $i >> modinfo
    done < modnames

    grep -E -v 'GPL( v2)?$|Dual BSD/GPL$|Dual MPL/GPL$|GPL and additional rights$' modinfo && exit 1

    rm -f modinfo modnames

    # Save off the .tmp_versions/ directory.  We'll use it in the
    # __debug_install_post macro below to sign the right things
    # Also save the signing keys so we actually sign the modules with the
    # right key.
    cp -r .tmp_versions .tmp_versions.sign${Flavour:+.${Flavour}}
    cp signing_key.priv signing_key.priv.sign${Flavour:+.${Flavour}}
    cp signing_key.x509 signing_key.x509.sign${Flavour:+.${Flavour}}

    # remove files that will be auto generated by depmod at rpm -i time
    for i in alias alias.bin builtin.bin ccwmap dep dep.bin ieee1394map inputmap isapnpmap ofmap pcimap seriomap symbols symbols.bin usbmap softdep devname
    do
      rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/modules.$i
    done

    # Move the devel headers out of the root file system
    mkdir -p $RPM_BUILD_ROOT/usr/src/kernels
    mv $RPM_BUILD_ROOT/lib/modules/$KernelVer/build $RPM_BUILD_ROOT/$DevelDir
    ln -sf $DevelDir $RPM_BUILD_ROOT/lib/modules/$KernelVer/build

    # prune junk from kernel-devel
    find $RPM_BUILD_ROOT/usr/src/kernels -name ".*.cmd" -exec rm -f {} \;
}

###
# DO it...
###

# prepare directories
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/boot
mkdir -p $RPM_BUILD_ROOT%{_libexecdir}

cd linux-%{KVRA}

%if %{with_default}
BuildKernel %make_target %kernel_image
%endif

%if %{with_debug}
BuildKernel %make_target %kernel_image debug
%endif

%if %{with_kdump}
BuildKernel %make_target %kernel_image kdump
%endif

%global perf_make make %{?_smp_mflags} -C tools/perf -s V=1 WERROR=0 NO_LIBUNWIND=1 HAVE_CPLUS_DEMANGLE=1 NO_GTK2=1 NO_STRLCPY=1 NO_PERF_READ_VDSO32=1 NO_PERF_READ_VDSOX32=1 prefix=%{_prefix} lib=%{_lib}
%if %{with_perf}
# perf
%{perf_make} all
%{perf_make} man || %{doc_build_fail}
%endif

%if %{with_tools}
%ifarch %{cpupowerarchs}
# cpupower
# make sure version-gen.sh is executable.
chmod +x tools/power/cpupower/utils/version-gen.sh
make %{?cross_opts} %{?_smp_mflags} -C tools/power/cpupower CPUFREQ_BENCH=false
%ifarch x86_64
    pushd tools/power/cpupower/debug/x86_64
    make %{?_smp_mflags} centrino-decode powernow-k8-decode
    popd
%endif
%ifarch x86_64
   pushd tools/power/x86/x86_energy_perf_policy/
   make
   popd
   pushd tools/power/x86/turbostat
   make
   popd
%endif #turbostat/x86_energy_perf_policy
%endif
pushd tools
make tmon
popd
%endif

%if %{with_doc}
# Make the HTML and man pages.
make htmldocs mandocs || %{doc_build_fail}

# sometimes non-world-readable files sneak into the kernel source tree
chmod -R a=rX Documentation
find Documentation -type d | xargs chmod u+w
%endif

# In the modsign case, we do 3 things.  1) We check the "flavour" and hard
# code the value in the following invocations.  This is somewhat sub-optimal
# but we're doing this inside of an RPM macro and it isn't as easy as it
# could be because of that.  2) We restore the .tmp_versions/ directory from
# the one we saved off in BuildKernel above.  This is to make sure we're
# signing the modules we actually built/installed in that flavour.  3) We
# grab the arch and invoke 'make modules_sign' and the mod-extra-sign.sh
# commands to actually sign the modules.
#
# We have to do all of those things _after_ find-debuginfo runs, otherwise
# that will strip the signature off of the modules.
#
# Finally, pick a module at random and check that it's signed and fail the build
# if it isn't.

%define __modsign_install_post \
  if [ "%{with_debug}" -ne "0" ]; then \
    Arch=`head -1 configs/kernel-%{version}-%{_target_cpu}-debug.config | cut -b 3-` \
    rm -rf .tmp_versions \
    mv .tmp_versions.sign.debug .tmp_versions \
    mv signing_key.priv.sign.debug signing_key.priv \
    mv signing_key.x509.sign.debug signing_key.x509 \
    %{modsign_cmd} $RPM_BUILD_ROOT/lib/modules/%{KVRA}.debug || exit 1 \
  fi \
    if [ "%{with_default}" -ne "0" ]; then \
    Arch=`head -1 configs/kernel-%{version}-%{_target_cpu}.config | cut -b 3-` \
    rm -rf .tmp_versions \
    mv .tmp_versions.sign .tmp_versions \
    mv signing_key.priv.sign signing_key.priv \
    mv signing_key.x509.sign signing_key.x509 \
    %{modsign_cmd} $RPM_BUILD_ROOT/lib/modules/%{KVRA} || exit 1 \
  fi \
  if [ "%{zipmodules}" -eq "1" ]; then \
    find $RPM_BUILD_ROOT/lib/modules/ -type f -name '*.ko' | xargs xz; \
  fi \
%{nil}

###
### Special hacks for debuginfo subpackages.
###

# This macro is used by %%install, so we must redefine it before that.
%define debug_package %{nil}

%if %{with_debuginfo}

%define __debug_install_post \
  /usr/lib/rpm/find-debuginfo.sh %{debuginfo_args} %{_builddir}/%{?buildsubdir}\
%{nil}

%ifnarch noarch
%global __debug_package 1
%files -f debugfiles.list debuginfo-common-%{_target_cpu}
%defattr(-,root,root)
%endif

%endif

#
# Disgusting hack alert! We need to ensure we sign modules *after* all
# invocations of strip occur, which is in __debug_install_post if
# find-debuginfo.sh runs, and __os_install_post if not.
#
%define __spec_install_post \
  %{?__debug_package:%{__debug_install_post}}\
  %{__arch_install_post}\
  %{__os_install_post}\
  %{__modsign_install_post}

###
### install
###

%install

cd linux-%{KVRA}

%if %{with_doc}
docdir=$RPM_BUILD_ROOT%{_datadir}/doc/kernel-doc-%{rpmversion}
man9dir=$RPM_BUILD_ROOT%{_datadir}/man/man9

# copy the source over
mkdir -p $docdir
tar -f - --exclude=man --exclude='.*' -c Documentation | tar xf - -C $docdir

# Install man pages for the kernel API.
mkdir -p $man9dir
find Documentation/DocBook/man -name '*.9.gz' -print0 |
xargs -0 --no-run-if-empty %{__install} -m 444 -t $man9dir $m
ls $man9dir | grep -q '' || > $man9dir/BROKEN
%endif # with_doc

# We have to do the headers install before the tools install because the
# kernel headers_install will remove any header files in /usr/include that
# it doesn't install itself.

%if %{with_headers}
# Install kernel headers
make %{?cross_opts} ARCH=%{hdrarch} INSTALL_HDR_PATH=$RPM_BUILD_ROOT/usr headers_install

# Do headers_check but don't die if it fails.
make %{?cross_opts} ARCH=%{hdrarch} INSTALL_HDR_PATH=$RPM_BUILD_ROOT/usr headers_check > hdrwarnings.txt || :
if grep -q exist hdrwarnings.txt; then
   sed s:^$RPM_BUILD_ROOT/usr/include/:: hdrwarnings.txt
   # Temporarily cause a build failure if header inconsistencies.
   # exit 1
fi

find $RPM_BUILD_ROOT/usr/include \( -name .install -o -name .check -o -name ..install.cmd -o -name ..check.cmd \) | xargs rm -f

%endif

%if %{with_kernel_abi_whitelists}
# kabi directory
INSTALL_KABI_PATH=$RPM_BUILD_ROOT/lib/modules/
mkdir -p $INSTALL_KABI_PATH

# install kabi releases directories
tar xjvf %{SOURCE30} -C $INSTALL_KABI_PATH
%endif  # with_kernel_abi_whitelists

%if %{with_perf}
# perf tool binary and supporting scripts/binaries
%{perf_make} DESTDIR=$RPM_BUILD_ROOT install
# remove the 'trace' symlink.
rm -f $RPM_BUILD_ROOT/%{_bindir}/trace

# perf-python extension
%{perf_make} DESTDIR=$RPM_BUILD_ROOT install-python_ext

# perf man pages (note: implicit rpm magic compresses them later)
%{perf_make} DESTDIR=$RPM_BUILD_ROOT try-install-man || %{doc_build_fail}
%endif

%if %{with_tools}
%ifarch %{cpupowerarchs}
make -C tools/power/cpupower DESTDIR=$RPM_BUILD_ROOT libdir=%{_libdir} mandir=%{_mandir} CPUFREQ_BENCH=false install
rm -f %{buildroot}%{_libdir}/*.{a,la}
%find_lang cpupower
mv cpupower.lang ../
%ifarch x86_64
    pushd tools/power/cpupower/debug/x86_64
    install -m755 centrino-decode %{buildroot}%{_bindir}/centrino-decode
    install -m755 powernow-k8-decode %{buildroot}%{_bindir}/powernow-k8-decode
    popd
%endif
chmod 0755 %{buildroot}%{_libdir}/libcpupower.so*
mkdir -p %{buildroot}%{_unitdir} %{buildroot}%{_sysconfdir}/sysconfig
install -m644 %{SOURCE2000} %{buildroot}%{_unitdir}/cpupower.service
install -m644 %{SOURCE2001} %{buildroot}%{_sysconfdir}/sysconfig/cpupower
%ifarch %{ix86} x86_64
   mkdir -p %{buildroot}%{_mandir}/man8
   pushd tools/power/x86/x86_energy_perf_policy
   make DESTDIR=%{buildroot} install
   popd
   pushd tools/power/x86/turbostat
   make DESTDIR=%{buildroot} install
   popd
%endif #turbostat/x86_energy_perf_policy
pushd tools/thermal/tmon
make INSTALL_ROOT=%{buildroot} install
popd
%endif

%endif

%if %{with_bootwrapper}
make %{?cross_opts} ARCH=%{hdrarch} DESTDIR=$RPM_BUILD_ROOT bootwrapper_install WRAPPER_OBJDIR=%{_libdir}/kernel-wrapper WRAPPER_DTSDIR=%{_libdir}/kernel-wrapper/dts
%endif

%if %{with_doc}
# Red Hat UEFI Secure Boot CA cert, which can be used to authenticate the kernel
mkdir -p $RPM_BUILD_ROOT%{_datadir}/doc/kernel-keys/%{rpmversion}-%{pkgrelease}
install -m 0644 %{SOURCE13} $RPM_BUILD_ROOT%{_datadir}/doc/kernel-keys/%{rpmversion}-%{pkgrelease}/kernel-signing-ca.cer
%endif

###
### clean
###

%clean
rm -rf $RPM_BUILD_ROOT

###
### scripts
###

%if %{with_tools}
%post -n kernel-tools
/sbin/ldconfig

%postun -n kernel-tools
/sbin/ldconfig
%endif

#
# This macro defines a %%post script for a kernel*-devel package.
#	%%kernel_devel_post [<subpackage>]
#
%define kernel_devel_post() \
%{expand:%%post %{?1:%{1}-}devel}\
if [ -f /etc/sysconfig/kernel ]\
then\
    . /etc/sysconfig/kernel || exit $?\
fi\
if [ "$HARDLINK" != "no" -a -x /usr/sbin/hardlink ]\
then\
    (cd /usr/src/kernels/%{KVRA}%{?1:.%{1}} &&\
     /usr/bin/find . -type f | while read f; do\
       hardlink -c /usr/src/kernels/*.%{?dist}.*/$f $f\
     done)\
fi\
%{nil}


# This macro defines a %%posttrans script for a kernel package.
#	%%kernel_variant_posttrans [<subpackage>]
# More text can follow to go at the end of this variant's %%post.
#
%define kernel_variant_posttrans() \
%{expand:%%posttrans %{?1}}\
if [ -x %{_sbindir}/weak-modules ]\
then\
    %{_sbindir}/weak-modules --add-kernel %{KVRA}%{?1:.%{1}} || exit $?\
fi\
%{_sbindir}/new-kernel-pkg --package kernel%{?-v:-%{-v*}} --mkinitrd --dracut --depmod --update %{KVRA}%{?-v:.%{-v*}} || exit $?\
%{_sbindir}/new-kernel-pkg --package kernel%{?1:-%{1}} --rpmposttrans %{KVRA}%{?1:.%{1}} || exit $?\
%{nil}

#
# This macro defines a %%post script for a kernel package and its devel package.
#	%%kernel_variant_post [-v <subpackage>] [-r <replace>]
# More text can follow to go at the end of this variant's %%post.
#
%define kernel_variant_post(v:r:) \
%{expand:%%kernel_devel_post %{?-v*}}\
%{expand:%%kernel_variant_posttrans %{?-v*}}\
%{expand:%%post %{?-v*}}\
%{-r:\
if [ `uname -i` == "x86_64" ] &&\
   [ -f /etc/sysconfig/kernel ]; then\
  /bin/sed -r -i -e 's/^DEFAULTKERNEL=%{-r*}$/DEFAULTKERNEL=kernel%{?-v:-%{-v*}}/' /etc/sysconfig/kernel || exit $?\
fi}\
%{expand:\
%{_sbindir}/new-kernel-pkg --package kernel%{?-v:-%{-v*}} --install %{KVRA}%{?-v:.%{-v*}} || exit $?\
}\
%{nil}

#
# This macro defines a %%preun script for a kernel package.
#	%%kernel_variant_preun <subpackage>
#
%define kernel_variant_preun() \
%{expand:%%preun %{?1}}\
%{_sbindir}/new-kernel-pkg --rminitrd --rmmoddep --remove %{KVRA}%{?1:.%{1}} || exit $?\
if [ -x %{_sbindir}/weak-modules ]\
then\
    %{_sbindir}/weak-modules --remove-kernel %{KVRA}%{?1:.%{1}} || exit $?\
fi\
%{nil}

%kernel_variant_preun
%kernel_variant_post 

%kernel_variant_preun debug
%kernel_variant_post -v debug

%ifarch s390x
%postun kdump
    # Create softlink to latest remaining kdump kernel.
    # If no more kdump kernel is available, remove softlink.
    if [ "$(readlink /boot/zfcpdump)" == "/boot/vmlinuz-%{KVRA}.kdump" ]
    then
        vmlinuz_next=$(ls /boot/vmlinuz-*.kdump 2> /dev/null | sort | tail -n1)
        if [ $vmlinuz_next ]
        then
            ln -sf $vmlinuz_next /boot/zfcpdump
        else
            rm -f /boot/zfcpdump
        fi
    fi

%post kdump
    ln -sf /boot/vmlinuz-%{KVRA}.kdump /boot/zfcpdump
%endif # s390x

if [ -x /sbin/ldconfig ]
then
    /sbin/ldconfig -X || exit $?
fi

###
### file lists
###

%if %{with_headers}
%files headers
%defattr(-,root,root)
/usr/include/*
%endif

%if %{with_bootwrapper}
%files bootwrapper
%defattr(-,root,root)
/usr/sbin/*
%{_libdir}/kernel-wrapper
%endif

# only some architecture builds need kernel-doc
%if %{with_doc}
%files doc
%defattr(-,root,root)
%{_datadir}/doc/kernel-doc-%{rpmversion}/Documentation/*
%dir %{_datadir}/doc/kernel-doc-%{rpmversion}/Documentation
%dir %{_datadir}/doc/kernel-doc-%{rpmversion}
%{_datadir}/man/man9/*
%{_datadir}/doc/kernel-keys/%{rpmversion}-%{pkgrelease}/kernel-signing-ca.cer
%dir %{_datadir}/doc/kernel-keys/%{rpmversion}-%{pkgrelease}
%dir %{_datadir}/doc/kernel-keys
%endif

%if %{with_kernel_abi_whitelists}
%files -n kernel-abi-whitelists
%defattr(-,root,root,-)
/lib/modules/kabi-*
%endif

%if %{with_perf}
%files -n perf
%defattr(-,root,root)
%{_bindir}/perf
%{_libdir}/libperf-jvmti.so
%dir %{_libexecdir}/perf-core
%{_libexecdir}/perf-core/*
%{_libdir}/traceevent
%{_mandir}/man[1-8]/perf*
%{_sysconfdir}/bash_completion.d/perf
%{_datadir}/perf-core/strace/groups
%{_datadir}/doc/perf-tip/tips.txt

%files -n python-perf
%defattr(-,root,root)
%{python_sitearch}

%if %{with_debuginfo}
%files -f perf-debuginfo.list -n perf-debuginfo
%defattr(-,root,root)

%files -f python-perf-debuginfo.list -n python-perf-debuginfo
%defattr(-,root,root)
%endif
%endif

%if %{with_tools}
%files -n kernel-tools -f cpupower.lang
%defattr(-,root,root)
%ifarch %{cpupowerarchs}
%{_bindir}/cpupower
%ifarch x86_64
%{_bindir}/centrino-decode
%{_bindir}/powernow-k8-decode
%endif
%{_unitdir}/cpupower.service
%{_mandir}/man[1-8]/cpupower*
%config(noreplace) %{_sysconfdir}/sysconfig/cpupower
%ifarch %{ix86} x86_64
%{_bindir}/x86_energy_perf_policy
%{_mandir}/man8/x86_energy_perf_policy*
%{_bindir}/turbostat
%{_mandir}/man8/turbostat*
%endif
%endif
%{_bindir}/tmon
%if %{with_debuginfo}
%files -f kernel-tools-debuginfo.list -n kernel-tools-debuginfo
%defattr(-,root,root)
%endif

%ifarch %{cpupowerarchs}
%files -n kernel-tools-libs
%defattr(-,root,root)
%{_libdir}/libcpupower.so.0
%{_libdir}/libcpupower.so.0.0.0

%files -n kernel-tools-libs-devel
%defattr(-,root,root)
%{_libdir}/libcpupower.so
%{_includedir}/cpufreq.h
%endif

%endif # with_tools

%if %{with_gcov}
%ifarch x86_64 s390x ppc64 ppc64le
%files gcov
%defattr(-,root,root)
%{_builddir}
%endif
%endif

# This is %%{image_install_path} on an arch where that includes ELF files,
# or empty otherwise.
%define elf_image_install_path %{?kernel_image_elf:%{image_install_path}}

#
# This macro defines the %%files sections for a kernel package
# and its devel and debuginfo packages.
#	%%kernel_variant_files [-k vmlinux] <condition> <subpackage>
#
%define kernel_variant_files(k:) \
%if %{1}\
%{expand:%%files %{?2}}\
%defattr(-,root,root)\
/%{image_install_path}/%{?-k:%{-k*}}%{!?-k:vmlinuz}-%{KVRA}%{?2:.%{2}}\
/%{image_install_path}/.vmlinuz-%{KVRA}%{?2:.%{2}}.hmac \
%attr(600,root,root) /boot/System.map-%{KVRA}%{?2:.%{2}}\
/boot/symvers-%{KVRA}%{?2:.%{2}}.gz\
/boot/config-%{KVRA}%{?2:.%{2}}\
%dir /lib/modules/%{KVRA}%{?2:.%{2}}\
/lib/modules/%{KVRA}%{?2:.%{2}}/kernel\
/lib/modules/%{KVRA}%{?2:.%{2}}/build\
/lib/modules/%{KVRA}%{?2:.%{2}}/source\
/lib/modules/%{KVRA}%{?2:.%{2}}/extra\
/lib/modules/%{KVRA}%{?2:.%{2}}/updates\
/lib/modules/%{KVRA}%{?2:.%{2}}/weak-updates\
%ifarch %{vdso_arches}\
/lib/modules/%{KVRA}%{?2:.%{2}}/vdso\
/etc/ld.so.conf.d/kernel-%{KVRA}%{?2:.%{2}}.conf\
%endif\
/lib/modules/%{KVRA}%{?2:.%{2}}/modules.*\
%ghost /boot/initramfs-%{KVRA}%{?2:.%{2}}.img\
%{expand:%%files %{?2:%{2}-}devel}\
%defattr(-,root,root)\
/usr/src/kernels/%{KVRA}%{?2:.%{2}}\
%if %{with_debuginfo}\
%ifnarch noarch\
%{expand:%%files -f debuginfo%{?2}.list %{?2:%{2}-}debuginfo}\
%defattr(-,root,root)\
%endif\
%endif\
%endif\
%{nil}

%kernel_variant_files %{with_default}
%kernel_variant_files %{with_debug} debug
%kernel_variant_files %{with_kdump} kdump

%changelog
* Wed Jan 03 2018 CentOS Sources <bugs@centos.org> - 3.10.0-693.11.6.el7
- Apply debranding changes

* Thu Dec 28 2017 Denys Vlasenko <dvlasenk@redhat.com> [3.10.0-693.11.6.el7]
- [x86] spec_ctrl: Eliminate redundant FEATURE Not Present messages (Andrea Arcangeli) [1519795 1519798] {CVE-2017-5715}
- [x86] mm/kaiser: init_tss is supposed to go in the PAGE_ALIGNED per-cpu section (Andrea Arcangeli) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: svm: spec_ctrl at vmexit needs per-cpu areas functional (Andrea Arcangeli) [1519795 1519798] {CVE-2017-5715}
- [x86] kaiser/mm: skip IBRS/CR3 restore when paranoid exception returns to userland (Andrea Arcangeli) [1519795 1519798] {CVE-2017-5715}
- [x86] kaiser/mm: consider the init_mm.pgd a kaiser pgd (Andrea Arcangeli) [1519795 1519798] {CVE-2017-5715}

* Fri Dec 22 2017 Denys Vlasenko <dvlasenk@redhat.com> [3.10.0-693.11.5.el7]
- [x86] kaiser/mm: convert userland visible "kpti" name to "pti" (Andrea Arcangeli) [1519795 1519798]
- Revert "x86/entry: Use retpoline for syscall's indirect calls" (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: set IBRS during resume from RAM if ibrs_enabled is 2 (Andrea Arcangeli) [1519795 1519798]
- [x86] kaiser/mm: __load_cr3 in resume from RAM after kernel gs has been restored (Andrea Arcangeli) [1519795 1519798]

* Tue Dec 19 2017 Denys Vlasenko <dvlasenk@redhat.com> [3.10.0-693.11.4.el7]
- [x86] spec_ctrl: allow use_ibp_disable only if both SPEC_CTRL and IBPB_SUPPORT are missing (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: Documentation spec_ctrl.txt (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: remove irqs_disabled() check from intel_idle() (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: use enum when setting ibrs/ibpb_enabled (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: undo speculation barrier for ibrs_enabled and noibrs_cmdline (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: introduce ibpb_enabled = 2 for IBPB instead of IBRS (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: introduce SPEC_CTRL_PCP_ONLY_IBPB (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: cleanup s/flush/sync/ naming when sending IPIs (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: set IBRS during CPU init if in ibrs_enabled == 2 (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: use IBRS_ENABLED instead of 1 (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: allow the IBP disable feature to be toggled at runtime (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: always initialize save_reg in ENABLE_IBRS_SAVE_AND_CLOBBER (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: ibrs_enabled() is expected to return > 1 (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: issue a __spec_ctrl_ibpb if a credential check isn't possible (Andrea Arcangeli) [1519795 1519798]
- [x86] mm/kaiser: disable global pages by default with KAISER (Andrea Arcangeli) [1519795 1519798]
- Revert "x86/mm/kaiser: Disable global pages by default with KAISER" (Andrea Arcangeli) [1519795 1519798]
- ibpb: don't optimize spec_cntrl_ibpb on PREEMPT_RCU (Andrea Arcangeli) [1519795 1519798]
- [x86] spec_ctrl: clear registers after 32bit syscall stackframe is setup (Andrea Arcangeli) [1519800 1519801]
- [x86] spec_ctrl: reload spec_ctrl cpuid in all microcode load paths (Andrea Arcangeli) [1519800 1519801]
- [x86] kaiser/mm: fix pgd freeing in error path (Andrea Arcangeli) [1519800 1519801]

* Wed Dec 13 2017 Denys Vlasenko <dvlasenk@redhat.com> [3.10.0-693.11.3.el7]
- [x86] spec_ctrl: Prevent unwanted speculation without IBRS (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715 CVE-2017-5754}
- [x86] entry: Remove trampoline check from paranoid entry path (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715 CVE-2017-5754}
- [x86] entry: Fix paranoid_exit() trampoline clobber (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715 CVE-2017-5754}
- [x86] entry: Simplify trampoline stack restore code (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715 CVE-2017-5754}
- [x86] dumpstack: Remove raw stack dump (Josh Poimboeuf) [1519795 1519798]
- [x86] spec_ctrl: remove SPEC_CTRL_DEBUG code (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: add noibrs noibpb boot options (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] entry: Use retpoline for syscall's indirect calls (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] syscall: Clear unused extra registers on 32-bit compatible syscall entrance (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: cleanup unnecessary ptregscall_common function (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: CLEAR_EXTRA_REGS and extra regs save/restore (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] syscall: Clear unused extra registers on syscall entrance (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: rescan cpuid after a late microcode update (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: add debugfs ibrs_enabled ibpb_enabled (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: consolidate the spec control boot detection (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] KVM/spec_ctrl: allow IBRS to stay enabled in host userland (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: add debug aid to test the entry code without microcode (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: move stuff_RSB in spec_ctrl.h (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] entry: Stuff RSB for entry to kernel for non-SMEP platform (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] mm: Only set IBPB when the new thread cannot ptrace current thread (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] mm: Set IBPB upon context switch (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] idle: Disable IBRS when offlining cpu and re-enable on wakeup (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] idle: Disable IBRS entering idle and enable it on wakeup (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: implement spec ctrl C methods (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: save IBRS MSR value in save_paranoid for NMI (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] enter: Use IBRS on syscall and interrupts (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: swap rdx with rsi for nmi nesting detection (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: spec_ctrl_pcp and kaiser_enabled_pcp in same cachline (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] spec_ctrl: use per-cpu knob instead of ALTERNATIVES for ibpb and ibrs (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] enter: MACROS to set/clear IBRS and set IBPB (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [kvm] x86: add SPEC_CTRL to MSR and CPUID lists (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [kvm] svm: add MSR_IA32_SPEC_CTRL and MSR_IA32_PRED_CMD (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] svm: Set IBPB when running a different VCPU (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [kvm] vmx: add MSR_IA32_SPEC_CTRL and MSR_IA32_PRED_CMD (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [kvm] vmx: Set IBPB when running a different VCPU (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [kvm] x86: clear registers on VM exit (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] kvm: pad RSB on VM transition (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] cpu/AMD: Control indirect branch predictor when SPEC_CTRL not available (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] feature: Report presence of IBPB and IBRS control (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [x86] feature: Enable the x86 feature to control Speculation (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [tools] objtool: Don't print 'call dest' warnings for ignored functions (Josh Poimboeuf) [1519795 1519798] {CVE-2017-5715}
- [misc] locking/barriers: prevent speculative execution based on Coverity scan results (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [fs] udf: prevent speculative execution (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [fs] prevent speculative execution (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [kernel] userns: prevent speculative execution (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [scsi] qla2xxx: prevent speculative execution (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [netdrv] p54: prevent speculative execution (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [netdrv] carl9170: prevent speculative execution (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [media] uvcvideo: prevent speculative execution (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [x86] cpu/AMD: Remove now unused definition of MFENCE_RDTSC feature (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [x86] cpu/AMD: Make the LFENCE instruction serialized (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [misc] locking/barriers: introduce new memory barrier gmb() (Josh Poimboeuf) [1519788 1519786] {CVE-2017-5753}
- [x86] mm/kaiser: Replace kaiser with kpti to sync with upstream (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: add "kaiser" and "nokaiser" boot options (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: map the trace idt tables in userland shadow pgd (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: fix RESTORE_CR3 crash in kaiser_stop_machine (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: use stop_machine for enable/disable knob (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: use atomic ops to poison/unpoison user pagetables (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: use invpcid to flush the two kaiser PCID AISD (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: use two PCID ASIDs optimize the TLB during enter/exit kernel (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: stop patching flush_tlb_single (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: use PCID feature to make user and kernel switches faster (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm: If INVPCID is available, use it to flush global mappings (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/64: Fix reboot interaction with CR4.PCIDE (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/64: Initialize CR4.PCIDE early (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm: Add a 'noinvpcid' boot option to turn off INVPCID (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm: Add the 'nopcid' boot option to turn off PCID (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: validate trampoline stack (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] entry: Move SYSENTER_stack to the beginning of struct tss_struct (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: isolate the user mapped per cpu areas (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: enable kaiser in build (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: selective boot time defaults (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: handle call to xen_pv_domain() on PREEMPT_RT (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser/xen: Dynamically disable KAISER when running under Xen PV (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: add Kconfig (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: avoid false positives during non-kaiser pgd updates (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: Respect disabled CPU features (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: trampoline stack comments (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: stack trampoline (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: remove paravirt clock warning (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: re-enable vsyscalls (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: allow to build KAISER with KASRL (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: allow KAISER to be enabled/disabled at runtime (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: un-poison PGDs at runtime (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: add a function to check for KAISER being enabled (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: add debugfs file to turn KAISER on/off at runtime (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: disable native VSYSCALL (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: map virtually-addressed performance monitoring buffers (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: map debug IDT tables (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: add kprobes text section (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: map trace interrupt entry (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: map entry stack per-cpu areas (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: map dynamically-allocated LDTs (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: make sure static PGDs are 8k in size (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: allow NX poison to be set in p4d/pgd (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: unmap kernel from userspace page tables (core patch) (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: mark per-cpu data structures required for entry/exit (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: introduce user-mapped per-cpu areas (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: add cr3 switches to entry code (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: remove scratch registers (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: prepare assembly for entry/exit CR3 switching (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/kaiser: Disable global pages by default with KAISER (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm: Document X86_CR4_PGE toggling behavior (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm/tlb: Make CR4-based TLB flushes more robust (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] mm: Do not set _PAGE_USER for init_mm page tables (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [x86] increase robusteness of bad_iret fixup handler (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [perf] x86/intel/uncore: Fix memory leaks on allocation failures (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [mm] userfaultfd: hugetlbfs: prevent UFFDIO_COPY to fill beyond the end of i_size (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [fs] userfaultfd: non-cooperative: fix fork use after free (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [mm] userfaultfd: hugetlbfs: remove superfluous page unlock in VM_SHARED case (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}
- [mm] fix bad rss-counter if remap_file_pages raced migration (Josh Poimboeuf) [1519800 1519801] {CVE-2017-5754}

* Fri Oct 27 2017 Frantisek Hrbata <fhrbata@hrbata.com> [3.10.0-693.11.1.el7]
- [powerpc] perf: Fix book3s kernel to userspace backtraces (Gustavo Duarte) [1506143 1492669]

* Tue Oct 24 2017 Alexander Gordeev <agordeev@redhat.com> [3.10.0-693.10.1.el7]
- [mm] mm, hugetlb: use pte_present() instead of pmd_present() in follow_huge_pmd() (Rafael Aquini) [1505164 1472460]
- [mm] fix invalid node in alloc_migrate_target() (Rafael Aquini) [1505164 1472460]
- [mm] add !pte_present() check on existing hugetlb_entry callbacks (Rafael Aquini) [1505164 1472460]
- [fs] ceph: avoid accessing freeing inode in ceph_check_delayed_caps() (Ilya Dryomov) [1505163 1489426]
- [fs] nfsd: Fix general protection fault in release_lock_stateid() (J. Bruce Fields) [1505160 1500815]
- [fs] cifs: Reconnect expired SMB sessions (Leif Sahlberg) [1501526 1477052]
- [fs] cifs: Separate SMB2 header structure (Leif Sahlberg) [1501526 1429710]

* Fri Oct 20 2017 Alexander Gordeev <agordeev@redhat.com> [3.10.0-693.9.1.el7]
- [fs] ext4: fix off-by-one on max nr_pages in ext4_find_unwritten_pgoff() (Bill O'Donnell) [1504115 1458728]
- [fs] ext4: fix off-by-in loop termination in ext4_find_unwritten_pgoff() (Bill O'Donnell) [1501387 1469363]
- [fs] ext4: fix SEEK_HOLE (Bill O'Donnell) [1501387 1469363]
- [fs] xfs: Move handling of missing page into one place in xfs_find_get_desired_pgoff() (Bill O'Donnell) [1498736 1460446]
- [fs] xfs: Fix off-by-in in loop termination in xfs_find_get_desired_pgoff() (Bill O'Donnell) [1498736 1460446]
- [fs] xfs: Fix missed holes in SEEK_HOLE implementation (Bill O'Donnell) [1498736 1460446]
- [fs] xfs: fix off-by-one on max nr_pages in xfs_find_get_desired_pgoff() (Eryu Guan) [1502731 1458997]
- [nvme] Test unit Ready broken for nvme drvices (David Milburn) [1502733 1478457]
- [hv] vmbus: Increase the time between retries in vmbus_post_msg() (Mohammed Gamal) [1495763 1491843]
- [hv] vmbus: Fix error code returned by vmbus_post_msg() (Mohammed Gamal) [1495763 1467258]
- [netdrv] netvsc: propagate MAC address change to VF slave (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] netvsc: delay setup of VF device (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] netvsc: make sure and unregister datapath (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] netvsc: fix rtnl deadlock on unregister of vf (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] netvsc: transparent VF management (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] hv_netvsc: Fix the carrier state error when data path is off (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] hv_netvsc: Fix the queue index computation in forwarding case (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] netvsc: handle select_queue when device is being removed (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] netvsc: report per-channel stats in ethtool statistics (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] netvsc: account for packets/bytes transmitted after completion (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] netvsc: group all per-channel state together (Vitaly Kuznetsov) [1500321 1477784]
- [netdrv] netvsc: enhance transmit select_queue (Vitaly Kuznetsov) [1500321 1477784]

* Thu Oct 19 2017 Alexander Gordeev <agordeev@redhat.com> [3.10.0-693.8.1.el7]
- [x86] kvm: x86: Fix potential preemption when get the current kvmclock timestamp (Marcelo Tosatti) [1503459 1496522]
- [x86] kvm: x86: remove irq disablement around KVM_SET_CLOCK/KVM_GET_CLOCK (Marcelo Tosatti) [1503459 1496522]

* Fri Oct 13 2017 Alexander Gordeev <agordeev@redhat.com> [3.10.0-693.7.1.el7]
- [mm] page_cgroup: Fix Kernel bug during boot with memory cgroups enabled (Larry Woodman) [1491970 1483747]
- Revert: [mm] Fix Kernel bug during boot with memory cgroups enabled (Larry Woodman) [1491970 1483747]

* Fri Oct 06 2017 Denys Vlasenko <dvlasenk@redhat.com> [3.10.0-693.6.1.el7]
- [netdrv] mlx5: Avoid using pending command interface slots (Don Dutile) [1497604 1463367]
- [x86] amd: Limit cpu_core_id fixup to families older than F17h (Suravee Suthikulpanit) [1497603 1477397]
- [x86] cpu/amd: Fix Zen SMT topology (Suravee Suthikulpanit) [1497603 1477397]
- [x86] cpu/amd: Bring back Compute Unit ID (Suravee Suthikulpanit) [1497603 1477397]
- [x86] cpu/amd: Fix Bulldozer topology (Suravee Suthikulpanit) [1497603 1477397]
- [x86] cpu/amd: Clean up cpu_llc_id assignment per topology feature (Suravee Suthikulpanit) [1497603 1477397]
- [x86] cpu: Get rid of compute_unit_id (Suravee Suthikulpanit) [1497603 1477397]
- [x86] amd: Derive L3 shared_cpu_map from cpu_llc_shared_mask (Suravee Suthikulpanit) [1497238 1477399]
- [net] ipv6: only call ip6_route_dev_notify() once for NETDEV_UNREGISTER (Matteo Croce) [1497121 1468935]
- [fs] gfs2: Fix debugfs glocks dump (Andreas Grunbacher) [1497078 1493067]
- [fs] gfs2: Replace rhashtable_walk_init with rhashtable_walk_enter (Andreas Grunbacher) [1497078 1493067]
- [fs] gfs2: Deduplicate gfs2_{glocks,glstats}_open (Andreas Grunbacher) [1497078 1493067]
- [cpufreq] intel_pstate: Fix unsafe HWP MSR access (Steve Best) [1497058 1457552]
- [s390] af_iucv: correctly copy SKB data (add missing hunk from 04d0ec) (Hendrik Brueckner) [1494354 1459782]
- [sound] alsa: timer: Use common error handling code in alsa_timer_init() (Jaroslav Kysela) [1465998 1465999] {CVE-2017-1000380}
- [sound] alsa: timer: Adjust a condition check in snd_timer_resolution() (Jaroslav Kysela) [1465998 1465999] {CVE-2017-1000380}
- [sound] alsa: timer: Follow standard EXPORT_SYMBOL() declarations (Jaroslav Kysela) [1465998 1465999] {CVE-2017-1000380}
- [sound] alsa: timer: Wrap with spinlock for queue access (Jaroslav Kysela) [1465998 1465999] {CVE-2017-1000380}
- [sound] alsa: timer: Improve user queue reallocation (Jaroslav Kysela) [1465998 1465999] {CVE-2017-1000380}
- [sound] alsa: timer: Fix missing queue indices reset at SNDRV_TIMER_IOCTL_SELECT (Jaroslav Kysela) [1465998 1465999] {CVE-2017-1000380}
- [sound] alsa: timer: Fix race between read and ioctl (Jaroslav Kysela) [1465998 1465999] {CVE-2017-1000380}
- [sound] alsa: timer: Info leak in snd_timer_user_tinterrupt() (Jaroslav Kysela) [1465998 1465999] {CVE-2017-1000380}
- [sound] alsa: timer: remove some dead code (Jaroslav Kysela) [1465998 1465999] {CVE-2017-1000380}
- [sound] alsa: timer: Reject user params with too small ticks (Jaroslav Kysela) [1465998 1465999] {CVE-2017-1000380}

* Sat Sep 16 2017 Alexander Gordeev <agordeev@redhat.com> [3.10.0-693.5.1.el7]
- [netdrv] i40e: point wb_desc at the nvm_wb_desc during i40e_read_nvm_aq (Stefan Assmann) [1491972 1484232]
- [netdrv] i40e: avoid NVM acquire deadlock during NVM update (Stefan Assmann) [1491972 1484232]
- [mm] Fix Kernel bug during boot with memory cgroups enabled (Larry Woodman) [1491970 1483747]
- [fs] nfsv4: Ensure we don't re-test revoked and freed stateids (Dave Wysochanski) [1491969 1459733]
- [netdrv] bonding: commit link status change after propose (Jarod Wilson) [1491121 1469790]
- [mm] page_alloc: ratelimit PFNs busy info message (Jonathan Toppins) [1491120 1383179]
- [netdrv] cxgb4: avoid crash on PCI error recovery path (Gustavo Duarte) [1489872 1456990]
- [scsi] Add STARGET_CREATED_REMOVE state to scsi_target_state (Ewan Milne) [1489814 1468727]
- [net] tcp: initialize rcv_mss to TCP_MIN_MSS instead of 0 (Davide Caratti) [1488341 1487061] {CVE-2017-14106}
- [net] tcp: fix 0 divide in __tcp_select_window() (Davide Caratti) [1488341 1487061] {CVE-2017-14106}
- [net] sctp: Avoid out-of-bounds reads from address storage (Stefano Brivio) [1484356 1484355] {CVE-2017-7558}
- [net] udp: consistently apply ufo or fragmentation (Davide Caratti) [1481530 1481535] {CVE-2017-1000112}
- [net] udp: account for current skb length when deciding about UFO (Davide Caratti) [1481530 1481535] {CVE-2017-1000112}
- [net] ipv4: Should use consistent conditional judgement for ip fragment in __ip_append_data and ip_finish_output (Davide Caratti) [1481530 1481535] {CVE-2017-1000112}
- [net] udp: avoid ufo handling on IP payload compression packets (Stefano Brivio) [1490263 1464161]
- [pci] hv: Use vPCI protocol version 1.2 (Vitaly Kuznetsov) [1478256 1459202]
- [pci] hv: Add vPCI version protocol negotiation (Vitaly Kuznetsov) [1478256 1459202]
- [pci] hv: Use page allocation for hbus structure (Vitaly Kuznetsov) [1478256 1459202]
- [pci] hv: Fix comment formatting and use proper integer fields (Vitaly Kuznetsov) [1478256 1459202]
- [net] ipv6: accept 64k - 1 packet length in ip6_find_1stfragopt() (Stefano Brivio) [1477007 1477010] {CVE-2017-7542}
- [net] ipv6: avoid overflow of offset in ip6_find_1stfragopt (Sabrina Dubroca) [1477007 1477010] {CVE-2017-7542}
- [net] xfrm_user: validate XFRM_MSG_NEWAE incoming ESN size harder (Hannes Frederic Sowa) [1435672 1435670] {CVE-2017-7184}
- [net] xfrm_user: validate XFRM_MSG_NEWAE XFRMA_REPLAY_ESN_VAL replay_window (Hannes Frederic Sowa) [1435672 1435670] {CVE-2017-7184}
- [net] l2cap: prevent stack overflow on incoming bluetooth packet (Neil Horman) [1489788 1489789] {CVE-2017-1000251}

* Fri Sep 08 2017 Alexander Gordeev <agordeev@redhat.com> [3.10.0-693.4.1.el7]
- [fs] nfsv4: Add missing nfs_put_lock_context() (Benjamin Coddington) [1487271 1476826]
- [fs] nfs: discard nfs_lockowner structure (Benjamin Coddington) [1487271 1476826]
- [fs] nfsv4: enhance nfs4_copy_lock_stateid to use a flock stateid if there is one (Benjamin Coddington) [1487271 1476826]
- [fs] nfsv4: change nfs4_select_rw_stateid to take a lock_context inplace of lock_owner (Benjamin Coddington) [1487271 1476826]
- [fs] nfsv4: change nfs4_do_setattr to take an open_context instead of a nfs4_state (Benjamin Coddington) [1487271 1476826]
- [fs] nfsv4: add flock_owner to open context (Benjamin Coddington) [1487271 1476826]
- [fs] nfs: remove l_pid field from nfs_lockowner (Benjamin Coddington) [1487271 1476826]
- [x86] platform/uv/bau: Disable BAU on single hub configurations (Frank Ramsay) [1487159 1487160 1472455 1473353]
- [x86] platform/uv/bau: Fix congested_response_us not taking effect (Frank Ramsay) [1487159 1472455]
- [fs] cifs: Disable encryption capability for RHEL 7.4 kernel (Sachin Prabhu) [1485445 1485445]
- [fs] sunrpc: Handle EADDRNOTAVAIL on connection failures (Dave Wysochanski) [1484269 1479043]
- [fs] include/linux/printk.h: include pr_fmt in pr_debug_ratelimited (Sachin Prabhu) [1484267 1472823]
- [fs] printk: pr_debug_ratelimited: check state first to reduce "callbacks suppressed" messages (Sachin Prabhu) [1484267 1472823]
- [net] packet: fix tp_reserve race in packet_set_ring (Stefano Brivio) [1481938 1481940] {CVE-2017-1000111}
- [fs] proc: revert /proc/<pid>/maps [stack:TID] annotation (Waiman Long) [1481724 1448534]
- [net] ping: check minimum size on ICMP header length (Matteo Croce) [1481578 1481573] {CVE-2016-8399}
- [ipc] mqueue: fix a use-after-free in sys_mq_notify() (Davide Caratti) [1476128 1476126] {CVE-2017-11176}
- [netdrv] brcmfmac: fix possible buffer overflow in brcmf_cfg80211_mgmt_tx() (Stanislaw Gruszka) [1474778 1474784] {CVE-2017-7541}

* Mon Sep 04 2017 Alexander Gordeev <agordeev@redhat.com> [3.10.0-693.3.1.el7]
- [block] blk-mq-tag: fix wakeup hang after tag resize (Ming Lei) [1487281 1472434]

* Fri Aug 11 2017 Alexander Gordeev <agordeev@redhat.com> [3.10.0-693.2.1.el7]
- [nvme] nvmet-rdma: occasionally flush ongoing controller teardown (Slava Shwartsman) [1479850 1467998]
- [nvme] Free bio_aux struct when done with bio (David Milburn) [1474679 1455553]
- [mm] thp: respect MPOL_PREFERRED policy with non-local node (Larry Woodman) [1479763 1476709]
- [char] ipmi: use rcu lock around call to intf->handlers->sender() (Tony Camuso) [1479761 1419765]
- [x86] vmware: Use tsc_khz value for calibrate_cpu() (Prarit Bhargava) [1479246 1475716]
- [netdrv] cxgb4: reduce resource allocation in kdump kernel (Sai Vemuri) [1478255 1379762]
- [netdrv] cxgb4: fix a NULL dereference (Sai Vemuri) [1478255 1379762]
- [netdrv] cxgb4: fix BUG() on interrupt deallocating path of ULD (Mauricio Oliveira) [1475671 1465554]
- [netdrv] bonding: Fix transmit load balancing in balance-alb mode (Jarod Wilson) [1475670 1473481]
- [fs] xfs: use ->b_state to fix buffer I/O accounting release race (Brian Foster) [1478254 1452228]
- [net] dst: Fix an intermittent pr_emerg warning about lo becoming free (Xin Long) [1475675 1458111]
- [powerpc] eeh: Fix partial hotplug criterion (Gustavo Duarte) [1475672 1458508]
- [powerpc] eeh: Fix wrong argument passed to eeh_rmv_device() (Gustavo Duarte) [1475672 1458508]
- [crypto] api - Move alg ref count init to crypto_check_alg (Herbert Xu) [1475668 1473593]

* Thu Aug 03 2017 Alexander Gordeev <agordeev@redhat.com> [3.10.0-693.1.1.el7]
- [fs] dentry name snapshots (Miklos Szeredi) [1471131 1470403] {CVE-2017-7533}
- [fs] fix the regression from "direct-io: Fix negative return from dio read beyond eof" (Eric Sandeen) [1475669 1473549]
- [fs] direct-io: Fix negative return from dio read beyond eof (Eric Sandeen) [1475669 1473549]

* Thu Jul 06 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-693.el7]
- [x86] crypto: sha1-ssse3 - Disable avx2 (Benjamin Coddington) [1346106]
- [net] geneve: fix hlist corruption (Jiri Benc) [1464292]
- [net] vxlan: fix hlist corruption (Jiri Benc) [1464292]
- [net] vxlan: fix use-after-free on deletion (Jiri Benc) [1464292]

* Thu Jul 06 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-692.el7]
- [pci] Avoid FLR for Intel 82579 NICs (Jarod Wilson) [966840]
- [net] netfilter: nf_ct_dccp/sctp: fix memory leak after netns cleanup (Davide Caratti) [1458687]
- [net] netfilter: udplite: Remove duplicated udplite4/6 declaration (Davide Caratti) [1458687]
- [net] netfilter: nat: merge udp and udplite helpers (Davide Caratti) [1458687]
- [net] netfilter: merge udp and udplite conntrack helpers (Davide Caratti) [1458687]
- [netdrv] mlx5: Tolerate irq_set_affinity_hint() failures (Kamal Heib) [1465830]
- [netdrv] bonding: Restore old symlink names in sysfs to preserve ABI (Neil Horman) [1461892]

* Thu Jun 29 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-691.el7]
- [redhat] spec: Update dracut dependency to enable more algorithms as FIPS compliant (Rafael Aquini) [1466097]

* Wed Jun 28 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-690.el7]
- [mm] fix new crash in unmapped_area_topdown() (Larry Woodman) [1463241] {CVE-2017-1000364}
- [mm] larger stack guard gap, between vmas (Larry Woodman) [1463241] {CVE-2017-1000364}
- [mm] Revert "enlarge stack guard gap" (Larry Woodman) [1463241] {CVE-2017-1000364}
- [crypto] testmgr - Reenable sha1/aes in FIPS mode (Herbert Xu) [1465234]
- [crypto] testmgr - mark more algorithms as FIPS compliant (Herbert Xu) [1465234]
- [target] tcmu: break up free_device callback (Mike Christie) [1430225]
- [target] tcmu: perfom device add and del synchronously (Mike Christie) [1430225]
- [target] tcmu: use idr for se_device dev index (Mike Christie) [1430225]
- [target] tcmu: prep for sync add/rm device support (Mike Christie) [1430225]

* Tue Jun 27 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-689.el7]
- [net] bridge: allow IPv6 when multicast flood is disabled (Ivan Vecera) [1464167]

* Tue Jun 27 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-688.el7]
- [s390] move _text symbol to address higher than zero (Jiri Olsa) [1464800]
- [netdrv] cxgb4: notify uP to route ctrlq compl to rdma rspq (Sai Vemuri) [1463324]
- [powerpc] Add HAVE_PERF_USER_STACK_DUMP support (Jiri Olsa) [1449182]
- [tools] perf report: Ensure the perf DSO mapping matches what libdw sees (Jiri Olsa) [1449182]
- [tools] perf report: Include partial stacks unwound with libdw (Jiri Olsa) [1449182]
- [tools] perf: libdw support for powerpc (Jiri Olsa) [1449182]
- [firmware] efi/esrt: Cleanup bad memory map log messages (Prarit Bhargava) [1380812]
- [firmware] efi/esrt: Fix typo in pr_err() message (Prarit Bhargava) [1380812]
- [firmware] efi/esrt: Use memremap not ioremap to access ESRT table in memory (Prarit Bhargava) [1380812]
- [firmware] efi: Work around ia64 build problem with ESRT driver (Prarit Bhargava) [1380812]
- [firmware] efi/esrt: Don't preformat name (Prarit Bhargava) [1380812]
- [firmware] efi: Make efi/esrt.c driver explicitly non-modular (Prarit Bhargava) [1380812]
- [firmware] efi/esrt: Fix some compiler warnings (Prarit Bhargava) [1380812]
- [firmware] efi: Add esrt support (Prarit Bhargava) [1380812]
- [firmware] efi: Rename efi_guid_unparse to efi_guid_to_str (Prarit Bhargava) [1380812]

* Mon Jun 26 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-687.el7]
- [fs] mntns: Remove incorrect put_mnt_ns ("Eric W. Biederman") [1463072]
- [md] dm raid: fix oops on upgrading to extended superblock format (Mike Snitzer) [1464274]
- [md] dm io: fix duplicate bio completion due to missing ref count (Mike Snitzer) [1461519]
- [net] gro_cells: mark napi struct as not busy poll candidates (Eelco Chaudron) [1460078]
- [x86] boot/kaslr: Skip kernel text relocation if no kaslr action is done (Baoquan He) [1458738]
- [char] tpm/tpm_crb: enter the low power state upon device suspend (Jerry Snitselaar) [1463001]
- [input] wacom: fix Wacom Cintiq 27QHD max pressure (Aristeu Rozanski) [1461910]
- [kernel] nohz: Fix spurious warning when hrtimer and clockevent get out of sync (Frederic Weisbecker) [1366043]
- [kernel] nohz: Fix buggy tick delay on IRQ storms (Frederic Weisbecker) [1366043]
- [kernel] nohz: Reset next_tick cache even when the timer has no regs (Frederic Weisbecker) [1366043]
- [kernel] nohz: Fix collision between tick and other hrtimers, again (Frederic Weisbecker) [1366043]
- [kernel] nohz: Add hrtimer sanity check (Frederic Weisbecker) [1366043]
- [kernel] revert "nohz: Fix collision between tick and other hrtimers" (Frederic Weisbecker) [1366043]
- [powerpc] do not make the entire heap executable (Denys Vlasenko) [1330064]

* Wed Jun 21 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-686.el7]
- [fs] nfsv4.1: Keep a reference on lock states while checking (Scott Mayhew) [1458721]
- [fs] nfsv4.1: Handle NFS4ERR_OLD_STATEID in nfs4_reclaim_open_state (Scott Mayhew) [1458721]
- [fs] nfsv4: Don't call close if the open stateid has already been cleared (Scott Mayhew) [1458721]
- [fs] nfsv4: Fix CLOSE races with OPEN (Scott Mayhew) [1458721]
- [fs] nfsv4.1: Fix a regression in DELEGRETURN (Scott Mayhew) [1458721]
- [fs] nfs: nfs_rename() - revalidate directories on -ERESTARTSYS (Benjamin Coddington) [1459404]
- [fs] revert "nfs: nfs_rename() handle -ERESTARTSYS dentry left behind" (Benjamin Coddington) [1459404]
- [s390] pci: moving check and allocation of device_rh ahead (Wei Xu) [1455117]
- [netdrv] cxgb4: handle serial flash interrupt (Sai Vemuri) [1462266]
- [netdrv] cxgb4: fix to bring link down after adapter crash (Sai Vemuri) [1462266]
- [netdrv] cxgb4: handle interrupt raised when FW crashes (Sai Vemuri) [1462266]
- [security] keys: Change the name of the dead type to ".dead" to prevent user access (David Howells) [1439264] {CVE-2017-6951}
- [security] keys: Protect request_key() against a type with no match function (David Howells) [1433216] {CVE-2017-2647}
- [security] keys: Disallow keyrings beginning with '.' to be joined as session keyrings (David Howells) [1389309] {CVE-2016-9604}

* Mon Jun 19 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-685.el7]
- [mm] enlarge stack guard gap (Larry Woodman) [1452733] {CVE-2017-1000364}
- [mm] userfaultfd: shmem: handle coredumping in handle_userfault() (Andrea Arcangeli) [1462267]
- [fs] nfs: Don't send mode again in post-EXCLUSIVE4_1 SETATTR with umask (Benjamin Coddington) [1449466]
- [hid] hid_wacom: temporaly disable power_supply usage from driver (Aristeu Rozanski) [1458348]
- [drm] mgag200: Fix to always set HiPri for G200e4 V2 (Rob Clark) [1461985]
- [nvme] submit nvme_admin_activate_fw to admin queue (David Milburn) [1456978]
- [netdrv] i40e: set VFs to untrusted mode by default (Stefan Assmann) [1462105]
- [netdrv] tun: use symmetric hash (Jason Wang) [1458645]
- [crypto] qat: copy back iv on completion (Neil Horman) [1446394]
- [crypto] chcr - Fix txq ids (Sai Vemuri) [1457392]
- [crypto] chcr - fix itnull.cocci warnings (Sai Vemuri) [1426189]
- [crypto] chcr - Change flow IDs (Sai Vemuri) [1426189]
- [crypto] chcr - Check device is allocated before use (Sai Vemuri) [1426189]

* Mon Jun 19 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-684.el7]
- [crypto] cryptd - process CRYPTO_ALG_INTERNAL (Herbert Xu) [1459191]
- [crypto] testmgr - don't use interruptible wait in tests (Herbert Xu) [1459191]
- [crypto] testmgr - use CRYPTO_ALG_INTERNAL (Herbert Xu) [1459191]
- [crypto] testmgr - Disable fips-allowed for authenc() and des() ciphers (Herbert Xu) [1459191]
- [x86] crypto: twofish_avx - mark Twofish AVX helper ciphers (Herbert Xu) [1459191]
- [x86] crypto: serpent_sse2 - mark Serpent SSE2 helper ciphers (Herbert Xu) [1459191]
- [x86] crypto: serpent_avx - mark Serpent AVX helper ciphers (Herbert Xu) [1459191]
- [x86] crypto: serpent_avx2 - mark Serpent AVX2 helper ciphers (Herbert Xu) [1459191]
- [x86] crypto: cast6_avx - mark CAST6 helper ciphers (Herbert Xu) [1459191]
- [x86] crypto: camellia_aesni_avx - mark AVX Camellia helper ciphers (Herbert Xu) [1459191]
- [x86] crypto: cast5_avx - mark CAST5 helper ciphers (Herbert Xu) [1459191]
- [x86] crypto: camellia_aesni_avx2 - mark AES-NI Camellia helper ciphers (Herbert Xu) [1459191]
- [x86] crypto: clmulni - mark ghash clmulni helper ciphers (Herbert Xu) [1459191]
- [x86] crypto: aesni - mark AES-NI helper ciphers (Herbert Xu) [1459191]
- [crypto] testmgr - add aead cbc des, des3_ede tests (Herbert Xu) [1459191]
- [crypto] testmgr - add aead null encryption test vectors (Herbert Xu) [1459191]
- [crypto] algif_skcipher - initialize upon init request (Herbert Xu) [1459191]
- [crypto] af_alg - zeroize key data (Herbert Xu) [1459191]
- [crypto] fix broken crypto_register_instance() module handling (Herbert Xu) [1459191]
- [crypto] api - remove instance when test failed (Herbert Xu) [1459191]
- [crypto] api - Change crypto_unregister_instance argument type (Herbert Xu) [1459191]
- [crypto] api - Fix races in crypto_unregister_instance (Herbert Xu) [1459191]
- [crypto] rng - Zero seed in crypto_rng_reset (Herbert Xu) [1459191]
- [crypto] cmac - allow usage in FIPS mode (Herbert Xu) [1459191]
- [crypto] drbg - remove FIPS 140-2 continuous test (Herbert Xu) [1459191]
- [crypto] testmgr - mark authenticated ctr(aes) also as FIPS able (Herbert Xu) [1459191]
- [crypto] drbg - do not call drbg_instantiate in healt test (Herbert Xu) [1459191]
- [crypto] rsa - allow keys >= 2048 bits in FIPS mode (Herbert Xu) [1459191]
- [crypto] testmgr - mark ctr(des3_ede) as fips_allowed (Herbert Xu) [1459191]
- [crypto] testmgr - Allow ecb(cipher_null) in FIPS mode (Herbert Xu) [1459191]
- [crypto] ansi_cprng - ANSI X9.31 DRNG is not allowed in FIPS 140-2 (Herbert Xu) [1459191]

* Mon Jun 19 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-683.el7]
- [mm] hmm: RHEL specific, properly handle pte_file() case within HMM (Jerome Glisse) [1460044]
- [mm] hmm: remove extra sanity check to avoid crash (Jerome Glisse) [1459259]
- [md] revert "dm mirror: use all available legs on multiple failures" (Mike Snitzer) [1436374]
- [md] dm-raid: up target version to show MD deadlock fixes are present (Heinz Mauelshagen) [1443999]
- [md] fix suspend/write deadlock (Heinz Mauelshagen) [1443999]
- [md] fix single core deadlock (Heinz Mauelshagen) [1443999]
- [x86] complete introduction of feature word 16 (Paolo Bonzini) [1413348]
- [drm] amdgpu: Program ring for vce instance 1 at its register space (Rob Clark) [1458391]
- [drm] amdgpu: change wptr to 64 bits (Rob Clark) [1458391]
- [scsi] lpfc: Null pointer dereference when log_verbose is set to 0xffffffff (Maurizio Lombardi) [1459443]
- [kernel] sched/deadline: Use the revised wakeup rule for suspending constrained dl tasks (Xunlei Pang) [1433064]
- [kernel] sched/deadline: Fix dl_bw comment (Xunlei Pang) [1433064]
- [kernel] sched/deadline: Zero out positive runtime after throttling constrained tasks (Xunlei Pang) [1433064]
- [kernel] sched/deadline: Use deadline instead of period when calculating overflow (Xunlei Pang) [1433064]
- [kernel] sched/deadline: Throttle a constrained deadline task activated after the deadline (Xunlei Pang) [1433064]
- [kernel] sched/deadline: Make sure the replenishment timer fires in the next period (Xunlei Pang) [1433064]
- [kernel] sched/deadline: Add missing update_rq_clock() in dl_task_timer() (Xunlei Pang) [1433064]
- [target] tcmu: increase ring buffer size (Mike Christie) [1407015]
- [netdrv] bnx2x: Don't post statistics to malicious VFs (Michal Schmidt) [1449872]
- [netdrv] bnx2x: Allow vfs to disable txvlan offload (Michal Schmidt) [1449872]
- [infiniband] rdma/iw_cxgb4: fix the calculation of ipv6 header size (Sai Vemuri) [1458389]

* Thu Jun 15 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-682.el7]
- [char] random: Fix crashes with sparse node ids (Herbert Xu) [1457281 1270982]
- [char] random: use for_each_online_node() to iterate over NUMA nodes (Herbert Xu) [1457281 1270982]
- [char] random: strengthen input validation for RNDADDTOENTCNT (Herbert Xu) [1457281 1270982]
- [char] random: add backtracking protection to the CRNG (Herbert Xu) [1270982 1457281]
- [char] random: make /dev/urandom scalable for silly userspace programs (Herbert Xu) [1270982 1457281]
- [char] random: replace non-blocking pool with a Chacha20-based CRNG (Herbert Xu) [1270982 1457281]
- [char] random: properly align get_random_int_hash (Herbert Xu) [1270982 1457281]
- [char] random: print a warning for the first ten uninitialized random users (Herbert Xu) [1270982 1457281]
- [char] random: initialize the non-blocking pool via add_hwgenerator_randomness() (Herbert Xu) [1270982 1457281]
- [kernel] random: Add callback API for random pool readiness (Herbert Xu) [1270982 1457281]
- [char] random: Fix fast_mix() function (Herbert Xu) [1270982 1457281]
- [char] random: limit the contribution of the hw rng to at most half (Herbert Xu) [1270982 1457281]
- [char] random: check for increase of entropy_count because of signed conversion (Herbert Xu) [1270982 1457281]
- [char] random: use registers from interrupted code for CPU's w/o a cycle counter (Herbert Xu) [1270982 1457281]
- [char] random: use an improved fast_mix() function (Herbert Xu) [1270982 1457281]
- [char] random: clean up interrupt entropy accounting for archs w/o cycle counters (Herbert Xu) [1270982 1457281]
- [char] random: only update the last_pulled time if we actually transferred entropy (Herbert Xu) [1270982 1457281]
- [char] random: remove unneeded hash of a portion of the entropy pool (Herbert Xu) [1270982 1457281]
- [char] random: always update the entropy pool under the spinlock (Herbert Xu) [1270982 1457281]
- [char] random: fix nasty entropy accounting bug (Herbert Xu) [1270982 1457281]
- [char] random: fix BUG_ON caused by accounting simplification (Herbert Xu) [1270982 1457281]
- [kernel] random: Add arch_has_random[_seed]() (Herbert Xu) [1270982 1457281]
- [char] random: If we have arch_get_random_seed*(), try it before blocking (Herbert Xu) [1270982 1457281]
- [char] random: Use arch_get_random_seed*() at init time and once a second (Herbert Xu) [1270982 1457281]
- [kernel] x86, random: Enable the RDSEED instruction (Herbert Xu) [1270982 1457281]
- [char] random: use the architectural HWRNG for the SHA's IV in extract_buf() (Herbert Xu) [1270982 1457281]
- [char] random: clarify bits/bytes in wakeup thresholds (Herbert Xu) [1270982 1457281]
- [char] random: entropy_bytes is actually bits (Herbert Xu) [1270982 1457281]
- [char] random: simplify accounting code (Herbert Xu) [1270982 1457281]
- [char] random: tighten bound on random_read_wakeup_thresh (Herbert Xu) [1270982 1457281]
- [char] random: forget lock in lockless accounting (Herbert Xu) [1270982 1457281]
- [char] random: simplify accounting logic (Herbert Xu) [1270982 1457281]
- [char] random: fix comment on "account" (Herbert Xu) [1270982 1457281]
- [char] random: simplify loop in random_read (Herbert Xu) [1270982 1457281]
- [char] random: fix description of get_random_bytes (Herbert Xu) [1270982 1457281]
- [char] random: fix comment on proc_do_uuid (Herbert Xu) [1270982 1457281]
- [char] random: fix typos / spelling errors in comments (Herbert Xu) [1270982 1457281]
- [char] random: add debugging code to detect early use of get_random_bytes() (Herbert Xu) [1270982 1457281]
- [char] random: initialize the last_time field in struct timer_rand_state (Herbert Xu) [1270982 1457281]
- [char] random: don't zap entropy count in rand_initialize() (Herbert Xu) [1270982 1457281]
- [char] random: make add_timer_randomness() fill the nonblocking pool first (Herbert Xu) [1270982 1457281]
- [char] random: convert DEBUG_ENT to tracepoints (Herbert Xu) [1270982 1457281]
- [char] random: push extra entropy to the output pools (Herbert Xu) [1270982 1457281]
- [char] random: drop trickle mode (Herbert Xu) [1270982 1457281]
- [char] random: adjust the generator polynomials in the mixing function slightly (Herbert Xu) [1270982 1457281]
- [char] random: speed up the fast_mix function by a factor of four (Herbert Xu) [1270982 1457281]
- [char] random: cap the rate which the /dev/urandom pool gets reseeded (Herbert Xu) [1270982 1457281]
- [char] random: optimize the entropy_store structure (Herbert Xu) [1270982 1457281]
- [char] random: optimize spinlock use in add_device_randomness() (Herbert Xu) [1270982 1457281]
- [char] random: fix the tracepoint for get_random_bytes(_arch) (Herbert Xu) [1270982 1457281]
- [char] random: mix in architectural randomness earlier in extract_buf() (Herbert Xu) [1270982 1457281]

* Tue Jun 13 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-681.el7]
- [fs] mnt: Move unprivileged use of the mntns to tech preview ("Eric W. Biederman") [1350553]
- [fs] nfs: Don't print a pNFS error if we aren't using pNFS (Benjamin Coddington) [1459899]
- [fs] pnfs: add a new mechanism to select a layout driver according to an ordered list (Benjamin Coddington) [1459899]
- [fs] pnfs: track multiple layout types in fsinfo structure (Benjamin Coddington) [1459899]
- [fs] nfsd: Fix up the "supattr_exclcreat" attributes ("J. Bruce Fields") [1460376]
- [fs] nfsd: encoders mustn't use unitialized values in error cases ("J. Bruce Fields") [1460365]
- [fs] nfs: Fix initialization of nfs_page_array->npages (Benjamin Coddington) [1457284]
- [net] ipv6: Fix leak in ipv6_gso_segment() (Eric Garver) [1459950] {CVE-2017-9074}
- [net] ipv6: xfrm: Handle errors reported by xfrm6_find_1stfragopt() (Eric Garver) [1459950] {CVE-2017-9074}
- [net] ipv6: Check ip6_find_1stfragopt() return value properly (Eric Garver) [1459950] {CVE-2017-9074}
- [net] ipv6: Prevent overrun when parsing v6 header options (Eric Garver) [1459950] {CVE-2017-9074}
- [net] document that no more GSO bits can be added (Jiri Benc) [1439252]
- [net] fix GSO_PARTIAL support (Jiri Benc) [1439252]
- [net] udp: remove remote checksum offload (Jiri Benc) [1439252]
- [net] vxlan: remove remote checksum offload for egress (Jiri Benc) [1439252]
- [net] ip6_offload: check segs for NULL in ipv6_gso_segment (Jiri Benc) [1439252]
- [net] vxlan: eliminate cached dst leak (Lance Richardson) [1396552]
- [net] bridge: start hello timer only if device is up (Xin Long) [1452093]
- [net] bridge: fix hello and hold timers starting/stopping (Xin Long) [1452093]
- [net] bridge: start hello_timer when enabling KERNEL_STP in br_stp_start (Xin Long) [1452093]
- [net] vlan: Propagate MAC address to VLANs (Jarod Wilson) [1446356]
- [s390] crash: Fix KEXEC_NOTE_BYTES definition (Xunlei Pang) [1458988]
- [scsi] cxgb4i, libcxgbi: in error case RST tcp conn (Sai Vemuri) [1457996]
- [scsi] cxgb4i: update module description (Sai Vemuri) [1457995]
- [netdrv] cxgb4: Update IngPad and IngPack values (Sai Vemuri) [1439468]
- [netdrv] cxgb4: avoid enabling napi twice to the same queue (Sai Vemuri) [1457993]
- [netdrv] cxgb4: retrieve port information from firmware (Sai Vemuri) [1457987]
- [netdrv] cxgb4: save tid while creating server filter (Sai Vemuri) [1451448]
- [netdrv] qed: Don't log missing periodic stats by default (Harish Patil) [1456338]
- [netdrv] qed: Fix error in the dcbx app meta data initialization (Harish Patil) [1456338]
- [crypto] algif_skcipher - Add key check exception for cipher_null ("Bruno E. O. Meneguele") [1386234] {CVE-2015-8970}
- [crypto] algif_hash - Require setkey before accept(2) ("Bruno E. O. Meneguele") [1386234] {CVE-2015-8970}
- [crypto] hash - Add crypto_ahash_has_setkey ("Bruno E. O. Meneguele") [1386234] {CVE-2015-8970}
- [crypto] algif_skcipher - Add nokey compatibility path ("Bruno E. O. Meneguele") [1386234] {CVE-2015-8970}
- [crypto] af_alg - Add nokey compatibility path ("Bruno E. O. Meneguele") [1386234] {CVE-2015-8970}
- [crypto] af_alg - Fix socket double-free when accept fails ("Bruno E. O. Meneguele") [1386234] {CVE-2015-8970}
- [crypto] af_alg - Disallow bind/setkey/... after accept(2) ("Bruno E. O. Meneguele") [1386234] {CVE-2015-8970}
- [crypto] algif_skcipher - Require setkey before accept(2) ("Bruno E. O. Meneguele") [1386234] {CVE-2015-8970}
- [kernel] ptrace: fix fork event messages across pid namespaces ("Eric W. Biederman") [1458353]
- [infiniband] rdma/cxgb4: Increase epd buff size for debug interface (Sai Vemuri) [1457999]
- [infiniband] rdma/iser: Fix possible mr leak on device removal event (Sai Vemuri) [1457984]
- [infiniband] rdma/iw_cxgb4: calculate t4_eq_status_entries properly (Sai Vemuri) [1458002]
- [infiniband] iw_cxgb4: Guard against null cm_id in dump_ep/qp (Sai Vemuri) [1457403]

* Mon Jun 12 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-680.el7]
- [fs] buffer.c: call thaw_super during emergency thaw (Mateusz Guzik) [1375033]
- [fs] block_dev.c: return the right error in thaw_bdev() (Mateusz Guzik) [1375033]
- [fs] revert "xfs: fix bogus space reservation in xfs_iomap_write_allocate" (Bill O'Donnell) [1446484]
- [hv] vmbus: Raise retry/wait limits in vmbus_post_msg() (Vitaly Kuznetsov) [1452009]
- [md] raid1: ignore discard error (Nigel Croxon) [1435822]
- [usb] ohci-pci: add qemu quirk (Gerd Hoffmann) [1301872]
- [x86] boot/kaslr: Change the 'KASLR disabled' message from warning to debug printing (Baoquan He) [1458644]
- [drm] nouveau/tmr: fully separate alarm execution/pending lists (Ben Skeggs) [1450742]
- [drm] nouveau: enable autosuspend only when it'll actually be used (Ben Skeggs) [1450742]
- [drm] nouveau: replace multiple open-coded runpm support checks with function (Ben Skeggs) [1450742]
- [virt] kvm: fix spin_lock_init order on x86 (Luiz Capitulino) [1459739]
- [acpi] nfit: Fix memory corruption/Unregister mce decoder on failure (Prarit Bhargava) [1448312]
- [tools] perf trace: Add mmap alias for s390 (Jiri Olsa) [1436323 1347055]
- [tools] perf test: Disable breakpoint signal tests for powerpc (Jiri Olsa) [1436323 1347055]
- [netdrv] sfc-falcon: register proper netdevice_notifier (Jarod Wilson) [1389671]
- [netdrv] mlx5: E-Switch, Correctly deal with inline mode on ConnectX-5 (Kamal Heib) [1456551]
- [netdrv] vfio/pci: Add Intel XXV710 to hidden INTx devices (Stefan Assmann) [1458160]
- [netdrv] pci: Add Intel XXV710 to broken INTx masking quirk (Stefan Assmann) [1458160]
- [netdrv] cxgb4: Shutdown adapter if firmware times out or errors out (Sai Vemuri) [1385866]
- [netdrv] cxgb4: Increase max number of tc u32 links (Sai Vemuri) [1385866]
- [netdrv] cxgb4: Fix uld_send() for ctrl pkts (Sai Vemuri) [1385866]
- [netdrv] cxgb4: add support for drop and redirect actions (Sai Vemuri) [1385866]
- [netdrv] cxgb4: add support for offloading u32 filters (Sai Vemuri) [1385866]
- [security] selinux: allow security_sb_clone_mnt_opts to enable/disable native labeling behavior (Scott Mayhew) [1454617]
- [infiniband] target: Fix unknown fabric callback queue-full errors (Sai Vemuri) [1454788]
- [infiniband] iscsi-target: Propigate queue_data_in + queue_status errors (Sai Vemuri) [1454788]
- [infiniband] iser-target: Fix queue-full response handling (Sai Vemuri) [1454788]
- [infiniband] iser-target: avoid posting a recv buffer twice (Sai Vemuri) [1454788]
- [infiniband] ib/addr: Fix setting source address in addr6_resolve() (Paolo Abeni) [1414097]
- [infiniband] avoid dereferencing uninitialized dst on error path (Paolo Abeni) [1414097]
- [infiniband] call ipv6 route lookup via the stub interface (Paolo Abeni) [1414097]
- [infiniband] ib/rxe: Fix kernel panic in send (Kamal Heib) [1459549]

* Mon Jun 05 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-679.el7]
- [scsi] kabi workaround for scsi_internal_device_block (Tomas Henzl) [1450206]
- [scsi] mpt3sas: Avoid sleeping in interrupt context (Tomas Henzl) [1450206]
- [scsi] scsi-mq: Wait for .queue_rq() if necessary (Tomas Henzl) [1450206]
- [fs] nfsd: fix supported attributes for acl & labels (Scott Mayhew) [1449877]
- [fs] nfsd4: fix null dereference on replay ("J. Bruce Fields") [1452242]
- [fs] pnfs: Fix the check for requests in range of layout segment (Benjamin Coddington) [1452929]
- [fs] vfs: fix locks_lock_file_wait() on overlayfs (Miklos Szeredi) [1456242]
- [hv] hv_utils: fix TimeSync work on pre-TimeSync-v4 hosts (Vitaly Kuznetsov) [1447906]
- [hv] hv_utils: drop .getcrosststamp() support from PTP driver (Vitaly Kuznetsov) [1447906]
- [mm] mempolicy.c: fix error handling in set_mempolicy and mbind ("Bruno E. O. Meneguele") [1443541] {CVE-2017-7616}
- [mm] shmem: fix shm fallocate() list corruption (Waiman Long) [1438389]
- [md] raid1: prefer disk without bad blocks (Nigel Croxon) [1456741]
- [dma] dmaengine: ioatdma: add BDX-EP PCI dev IDs (Xiaolong Wang) [1369330]
- [drm] i915: Do not drop pagetables when empty (Lyude Paul) [1454339]
- [drm] i915/gvt: not to restore in-context mmio (Paul Lai) [1448762]
- [char] ipmi: create hardware-independent softdep for ipmi_devintf (Tony Camuso) [1456865]
- [nvme] Correct NVMF enum values to match NVMe-oF rev 1.0 (David Milburn) [1455784]
- [block] blk-mq: remove blk_mq_abort_requeue_list() (Ming Lei) [1445595]
- [nvme] avoid to use blk_mq_abort_requeue_list() (Ming Lei) [1445595]
- [nvme] use blk_mq_start_hw_queues() in nvme_kill_queues() (Ming Lei) [1445595]
- [block] block new I/O just after queue is set as dying (Ming Lei) [1445595]
- [block] rename blk_mq_freeze_queue_start() (Ming Lei) [1445595]
- [block] add a read barrier in blk_queue_enter() (Ming Lei) [1445595]
- [block] blk-mq: comment on races related with timeout handler (Ming Lei) [1445595]
- [netdrv] net, virtio_net: replace the magic value (Jason Wang) [1450300]
- [netdrv] ixgbe: fix incorrect status check (Ken Cox) [1452421]
- [netdrv] ixgbe: add missing configuration for rate select 1 (Ken Cox) [1452421]
- [netdrv] ixgbe: always call setup_mac_link for multispeed fiber (Ken Cox) [1452421]
- [netdrv] ixgbe: add write flush when configuring CS4223/7 (Ken Cox) [1452421]
- [netdrv] ixgbe: correct CS4223/7 PHY identification (Ken Cox) [1452421]
- [netdrv] ath9k_htc: fix NULL-deref at probe (Stanislaw Gruszka) [1449094]
- [netdrv] ath9k_htc: Add support of AirTies 1eda:2315 AR9271 device (Stanislaw Gruszka) [1449094]
- [netdrv] mwifiex: pcie: fix cmd_buf use-after-free in remove/reset (Stanislaw Gruszka) [1449094]
- [netdrv] rtlwifi: rtl8821ae: setup 8812ae RFE according to device type (Stanislaw Gruszka) [1449094]
- [netdrv] brcmfmac: Ensure pointer correctly set if skb data location changes (Stanislaw Gruszka) [1449094]
- [netdrv] brcmfmac: Make skb header writable before use (Stanislaw Gruszka) [1449094]
- [netdrv] be2net: Update the driver version to 11.4.0.0 (Ivan Vecera) [1455768]
- [netdrv] be2net: Fix UE detection logic for BE3 (Ivan Vecera) [1455768]
- [netdrv] e1000e: Don't return uninitialized stats (Jarod Wilson) [1455721]
- [infiniband] rdma/i40iw: Remove MSS change support (Stefan Assmann) [1448168]
- [infiniband] ib/hfi1: Prevent kernel QP post send hard lockups (Alex Estrin) [1451917]
- [infiniband] ib/hfi1: Protect the global dev_cntr_names and port_cntr_names (Alex Estrin) [1454919]

* Mon Jun 05 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-678.el7]
- [net] pending_confirm is not used anymore (Lance Richardson) [1450203]
- [net] use dst_confirm_neigh for UDP, RAW, ICMP, L2TP (Lance Richardson) [1450203]
- [net] add confirm_neigh method to dst_ops (Lance Richardson) [1450203]
- [net] tcp: replace dst_confirm with sk_dst_confirm (Lance Richardson) [1450203]
- [net] sctp: add dst_pending_confirm flag (Lance Richardson) [1450203]
- [net] add dst_pending_confirm flag to skbuff (Lance Richardson) [1450203]
- [net] sock: add sk_dst_pending_confirm flag (Lance Richardson) [1450203]
- [net] macvlan: Fix performance issues with vlan tagged packets (Vlad Yasevich) [1289475]
- [net] sctp: do not inherit ipv6_{mc|ac|fl}_list from parent (Florian Westphal) [1455609] {CVE-2017-8890 CVE-2017-9075 CVE-2017-9076 CVE-2017-9077}
- [net] ipv6/dccp: do not inherit ipv6_mc_list from parent (Florian Westphal) [1455609] {CVE-2017-8890 CVE-2017-9075 CVE-2017-9076 CVE-2017-9077}
- [net] dccp/tcp: do not inherit mc_list from parent (Florian Westphal) [1455609] {CVE-2017-8890 CVE-2017-9075 CVE-2017-9076 CVE-2017-9077}
- [net] tcp: do not inherit fastopen_req from parent (Florian Westphal) [1455609] {CVE-2017-8890 CVE-2017-9075 CVE-2017-9076 CVE-2017-9077}
- [netdrv] virtio_net: enable TSO/checksum offloads for Q-in-Q vlans (Eric Garver) [1423935]
- [netdrv] be2net: Fix offload features for Q-in-Q packets (Eric Garver) [1423935]
- [net] vlan: Fix tcp checksum offloads in Q-in-Q vlans (Eric Garver) [1423935]
- [net] sched: act_mirred: Use passed lastuse argument (Ivan Vecera) [1455296]
- [net] sched: act_mirred: allow statistic updates from offloaded actions (Ivan Vecera) [1455296]
- [net] sctp: set new_asoc temp when processing dupcookie (Xin Long) [1450786]
- [net] netfilter: conntrack: fix false CRC32c mismatch using paged skb (Davide Caratti) [1353218]
- [net] ipv6: fix out of bound writes in __ip6_append_data() (Hangbin Liu) [1453057]
- [net] skbuff: improve description of CHECKSUM_{COMPLETE, UNNECESSARY} (Davide Caratti) [1072503]
- [net] openvswitch: more accurate checksumming in queue_userspace_packet() (Davide Caratti) [1072503]
- [net] more accurate checksumming in validate_xmit_skb() (Davide Caratti) [1072503]
- [net] use skb->csum_not_inet to identify packets needing crc32c (Davide Caratti) [1072503]
- [net] introduce skb_crc32c_csum_help (Davide Caratti) [1072503]
- [net] Elaborate on checksum offload interface description (Davide Caratti) [1072503]
- [net] skbuff: add stub to help computing crc32c on SCTP packets (Davide Caratti) [1072503]
- [net] ipv6: reorder ip6_route_dev_notifier after ipv6_dev_notf (Xin Long) [1450281]
- [net] ipv6: initialize route null entry in addrconf_init() (Xin Long) [1450281]
- [net] l2tp: hold tunnel socket when handling control frames in l2tp_ip and l2tp_ip6 (Florian Westphal) [1441554] {CVE-2016-10200}
- [net] l2tp: fix address test in __l2tp_ip6_bind_lookup() (Florian Westphal) [1441554] {CVE-2016-10200}
- [net] l2tp: fix lookup for sockets not bound to a device in l2tp_ip (Florian Westphal) [1441554] {CVE-2016-10200}
- [net] l2tp: fix racy socket lookup in l2tp_ip and l2tp_ip6 bind() (Florian Westphal) [1441554] {CVE-2016-10200}
- [net] l2tp: hold socket before dropping lock in l2tp_ip{, 6}_recv() (Florian Westphal) [1441554] {CVE-2016-10200}
- [net] ipv6: lock socket in ip6_datagram_connect() (Florian Westphal) [1441554]
- [net] l2tp: fix racy SOCK_ZAPPED flag check in l2tp_ip{, 6}_bind() (Florian Westphal) [1441554] {CVE-2016-10200}
- [net] sched: cls: also reject deleting all filters when TCA_KIND present (Ivan Vecera) [1450137]
- [net] sched: cls: allow for deleting all filters for given parent (Ivan Vecera) [1450137]
- [net] sched: act_vlan: Add priority option (Ivan Vecera) [1450145]
- [net] sched: indentation and other OCD stylistic fixes (Ivan Vecera) [1450145]

* Fri Jun 02 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-677.el7]
- [powerpc] fadump: update about offset where fadump is reserved (Gustavo Duarte) [1384941]
- [powerpc] fadump: add a warning when 'fadump_reserve_mem=' is specified (Gustavo Duarte) [1384941]
- [powerpc] fadump: update documentation about crashkernel parameter reuse (Gustavo Duarte) [1384941]
- [powerpc] fadump: reuse crashkernel parameter for fadump memory reservation (Gustavo Duarte) [1384941]
- [powerpc] fadump: remove dependency with CONFIG_KEXEC (Gustavo Duarte) [1384941]
- [kernel] ia64: reuse append_elf_note() and final_note() functions (Gustavo Duarte) [1384941]
- [kernel] crash: move crashkernel parsing and vmcore related code under CONFIG_CRASH_CORE (Gustavo Duarte) [1384941]
- [kernel] sched/cputime: Fix NO_HZ_FULL getrusage() monotonicity regression (Aaron Tomlin) [1452621]
- [kernel] sched/cputime: Guarantee stime + utime == rtime (Aaron Tomlin) [1452621]
- [kernel] sched: Use swap() macro in scale_stime() (Aaron Tomlin) [1452621]
- [kernel] sched, time: Fix build error with 64 bit cputime_t on 32 bit systems (Aaron Tomlin) [1452621]
- [kernel] userns: Preserve bug compatibility on failure for chrome ("Eric W. Biederman") [1443482]
- [kernel] ptrace: fix PTRACE_LISTEN race corrupting task->state (Oleg Nesterov) [1450683]
- [x86] kvm: x86: Expose Intel VPOPCNTDQ feature to guest (Paul Lai) [1415961]
- [x86] cpufeature: Add AVX512_VPOPCNTDQ feature (Paul Lai) [1415961]
- [x86] kvm: x86: Expose Intel AVX512IFMA/AVX512VBMI/SHA features to guest (Paul Lai) [1415961]
- [x86] cpufeatures: Enable new AVX512 cpu features (Paul Lai) [1415961]
- [x86] kaslr: Use the right memcpy() implementation (Baoquan He) [1440928]
- [x86] documentation/kernel-parameters.txt: Update 'memmap=' boot option description (Baoquan He) [1440928]
- [x86] kaslr: Handle the memory limit specified by the 'memmap=' and 'mem=' boot options (Baoquan He) [1440928]
- [x86] kaslr: Parse all 'memmap=' boot option entries (Baoquan He) [1440928]
- [x86] boot/param: Move next_arg() function to lib/cmdline.c for later reuse (Baoquan He) [1440928]
- [x86] params: handle quotes properly for values not of form foo="bar" (Baoquan He) [1440928]
- [x86] efi: Correct ident mapping of efi old_map when kalsr enabled (Baoquan He) [1441185]
- [x86] kaslr: Fix kexec kernel boot crash when KASLR randomization fails (Baoquan He) [1449443]
- [x86] efi-bgrt: Fix kernel panic when mapping BGRT data (Gopal Tiwari) [1447685]
- [x86] mark AMD Naples SP3 processors supported (David Arcari) [1455601]
- [x86] set x86_model_id in early_identify_cpu for unsupported check (David Arcari) [1455601]
- [s390] cpum_cf: use perf software context for hardware counters (Hendrik Brueckner) [1454881]
- [perf] symbols: Accept symbols starting at address 0 (Jiri Olsa) [1140522]
- [perf] tools: Be consistent on the type of map->symbols[] interator (Jiri Olsa) [1140522]

* Fri Jun 02 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-676.el7]
- [mm] hmm: workaround kABI breakage because of new migrate mode enum (Jerome Glisse) [1444991]
- [mm] migrate: allow migrate_vma() to alloc new page on empty entry v2 (Jerome Glisse) [1444991]
- [mm] migrate: support un-addressable ZONE_DEVICE page in migration v2 (Jerome Glisse) [1444991]
- [mm] migrate: migrate_vma() unmap page from vma while collecting pages (Jerome Glisse) [1444991]
- [mm] migrate: new memory migration helper for use with device memory v4 (Jerome Glisse) [1444991]
- [mm] migrate: new migrate mode MIGRATE_SYNC_NO_COPY (Jerome Glisse) [1444991]
- [mm] hmm/devmem: support device memory in CPU snapshot helpers (Jerome Glisse) [1444991]
- [mm] hmm/devmem: dummy HMM device for ZONE_DEVICE memory v3 (Jerome Glisse) [1444991]
- [mm] hmm/devmem: device memory hotplug using ZONE_DEVICE v4 (Jerome Glisse) [1444991]
- [mm] private-memory: new type of ZONE_DEVICE for unaddressable memory v2 (Jerome Glisse) [1444991]
- [mm] put_page: move ZONE_DEVICE page reference decrement v2 (Jerome Glisse) [1444991]
- [mm] memory_hotplug: introduce add_pages (Jerome Glisse) [1444991]
- [mm] hmm/mirror: device page fault handler (Jerome Glisse) [1444991]
- [mm] hmm/mirror: helper to snapshot CPU page table v3 (Jerome Glisse) [1444991]
- [mm] hmm/mirror: mirror process address space on device with HMM helpers v3 (Jerome Glisse) [1444991]
- [mm] hmm: heterogeneous memory management (HMM for short) v3 (Jerome Glisse) [1444991]
- [mm] hmm: heterogeneous memory management documentation (Jerome Glisse) [1444991]
- [mm] hmm: remove old code to prepare for lastest patchset backport (Jerome Glisse) [1444991]

* Mon May 29 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-675.el7]
- [mm] hugetlbfs: fix offset overflow in hugetlbfs mmap (Andrea Arcangeli) [1455315]
- [mm] hugetlbfs: initialize shared policy as part of inode allocation (Andrea Arcangeli) [1455315]
- [mm] hugetlb: don't call region_abort if region_chg fails (Andrea Arcangeli) [1455315]
- [mm] ksm: optimize refile of stable_node_dup at the head of the chain (Andrea Arcangeli) [1447745]
- [mm] ksm: swap the two output parameters of chain/chain_prune (Andrea Arcangeli) [1447745]
- [mm] ksm: cleanup stable_node chain collapse case (Andrea Arcangeli) [1447745]
- [mm] ksm: fix use after free with merge_across_nodes = 0 (Andrea Arcangeli) [1447745]
- [mm] vmscan: Do not wait for page writeback for GFP_NOFS allocations (Rafael Aquini) [1433103]
- [mm] vmscan: disable memcg direct reclaim stalling if cgroup writeback support is in use (Rafael Aquini) [1433103]
- [mm] add private lock to serialize memory hotplug operations (Jeff Moyer) [1438579]
- [mm] validate device_hotplug is held for memory hotplug (Jeff Moyer) [1438579]
- [mm] devm_memremap_pages: hold device_hotplug lock over mem_hotplug_{begin, done} (Jeff Moyer) [1438579]
- [mm] fix devm_memremap_pages crash, use mem_hotplug_{begin, done} (Jeff Moyer) [1438579]
- [mm] hotplug: fix concurrent memory hot-add deadlock (Jeff Moyer) [1438579]
- [mm] mem-hotplug: implement get/put_online_mems (Jeff Moyer) [1438579]
- [mm] cpu/mem hotplug: add try_online_node() for cpu_up() (Jeff Moyer) [1438579]
- [mm] x86/mm/hotplug: Don't remove PGD entries in remove_pagetable() (Jeff Moyer) [1438579]
- [x86] mm: Tighten x86 /dev/mem with zeroing reads ("Bruno E. O. Meneguele") [1449677] {CVE-2017-7889}
- [x86] mce/amd: Give a name to MCA bank 3 when accessed with legacy MSRs (David Arcari) [1454807]
- [x86] boot/kaslr: Disable KASLR by default (Baoquan He) [1449762]
- [x86] microcode/intel: access the initrd at the relocated address (Pingfan Liu) [1448767]
- [x86] toshiba_acpi: Do not register vendor backlight when acpi_video bl is available (Jeremy McNicoll) [1305617]
- [drm] i915: don't rcu-sync from shrinker (Rob Clark) [1443028]
- [pci] msi: Stop disabling MSI/MSI-X in pci_device_shutdown() (Prarit Bhargava) [1207693]
- [kernel] workqueue: schedule WORK_CPU_UNBOUND work on wq_unbound_cpumask CPUs (Waiman Long) [1452675]
- [kernel] workqueue: handle NUMA_NO_NODE for unbound pool_workqueue (Waiman Long) [1452675]

* Mon May 29 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-674.el7]
- [target] Add target_core_user.h to included headers (Andy Grover) [1451522]
- [scsi] qedi: Fix endpoint NULL panic during recovery (Chad Dupuis) [1452748]
- [scsi] qedi: set max_fin_rt default value (Chad Dupuis) [1452748]
- [scsi] qedi: Set firmware tcp msl timer value (Chad Dupuis) [1452748]
- [scsi] qedi: Fix endpoint NULL panic in qedi_set_path (Chad Dupuis) [1452748]
- [scsi] qedi: Set dma_boundary to 0xfff (Chad Dupuis) [1452748]
- [scsi] qedi: Correctly set firmware max supported BDs (Chad Dupuis) [1452748]
- [scsi] qedi: Fix bad pte call trace when iscsiuio is stopped (Chad Dupuis) [1452748]
- [fs] nfs: Fix use after free in write error path (Steve Dickson) [1441883]
- [fs] fs: return -EOPNOTSUPP if clone is not supported ("J. Bruce Fields") [1449156]
- [fs] btrfs: use linux/sizes.h to represent constants (Bill O'Donnell) [1451546]
- [fs] cifs: Do not send echoes before Negotiate is complete (Sachin Prabhu) [1452060]
- [md] raid1: Use a new variable to count flighting sync requests (Xiao Ni) [1379764]
- [md] raid1: handle flush request correctly (Xiao Ni) [1379764]
- [md] raid1: fix a use-after-free bug (Xiao Ni) [1379764]
- [md] raid1: avoid unnecessary spin locks in I/O barrier code (Xiao Ni) [1379764]
- [md] raid1: a new I/O barrier implementation to remove resync window (Xiao Ni) [1379764]
- [md] raid1: Refactor raid1_make_request (Xiao Ni) [1379764]
- [md] handle read-only member devices better (Nigel Croxon) [1442776]
- [base] pm / sleep: prohibit devices probing during suspend/hibernation (Don Zickus) [1184229]
- [base] drivercore: Make probe deferral more quiet (Don Zickus) [1184229]
- [base] drivercore: deferral race condition fix (Don Zickus) [1184229]
- [nvme] nvme-rdma: Support ctrl_loss_tmo (David Milburn) [1452321 1442735]
- [nvme] nvme-fabrics: Allow ctrl loss timeout configuration (David Milburn) [1452321 1442735]
- [nvme] nvme-rdma: get rid of local reconnect_delay (David Milburn) [1452321 1442735]
- [nvme] nvmet-rdma: Fix a possible uninitialized variable dereference (David Milburn) [1437723]
- [block] fix bio_will_gap() for first bvec with offset (Ming Lei) [1443807]
- [tools] power turbostat: denverton: use HW CC1 counter, skip C3, C7 (Prarit Bhargava) [1447265]
- [tools] power turbostat: bug fixes to --add, --show/--hide features (Prarit Bhargava) [1447265]
- [tools] power turbostat: Add --show and --hide parameters (Prarit Bhargava) [1447265]
- [tools] power turbostat: fix bugs in --add option (Prarit Bhargava) [1447265]
- [netdrv] bonding: fix randomly populated arp target array (Jarod Wilson) [1450184]
- [netdrv] bonding: fix accounting of active ports in 3ad (Jarod Wilson) [1368265]
- [netdrv] vmxnet3: ensure that adapter is in proper state during force_close (Neil Horman) [1449021]
- [netdrv] tg3: don't clear stats while tg3_close (Jonathan Toppins) [1455222]
- [netdrv] tg3: Fix race condition in tg3_get_stats64() (Jonathan Toppins) [1455222]
- [infiniband] ib/ipoib: add get_link_ksettings in ethtool (Kamal Heib) [1450970]
- [infiniband] ib/device: Convert ib-comp-wq to be CPU-bound (Kamal Heib) [1437727]

* Fri May 26 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-673.el7]
- [drm] nouveau/kms/nv50: skip core channel cursor update on position-only chang (Ben Skeggs) [1451524]
- [drm] nouveau/kms/nv50: fix source-rect-only plane updates (Ben Skeggs) [1451524]
- [drm] nouveau/kms: Increase max retries in scanout position queries (Ben Skeggs) [1451524]
- [drm] nouveau/therm: remove ineffective workarounds for alarm bugs (Ben Skeggs) [1449338]
- [drm] nouveau/tmr: avoid processing completed alarms when adding a new one (Ben Skeggs) [1449338]
- [drm] nouveau/tmr: fix corruption of the pending list when rescheduling an ala (Ben Skeggs) [1449338]
- [drm] nouveau/tmr: handle races with hw when updating the next alarm time (Ben Skeggs) [1449338]
- [drm] nouveau/tmr: ack interrupt before processing alarms (Ben Skeggs) [1449338]
- [drm] nouveau/fb/ram/gf100-: remove 0x10f200 read (Ben Skeggs) [1371629]
- [drm] nouveau/fb/gf100-: Fix 32 bit wraparound in new ram detection (Ben Skeggs) [1371629]
- [drm] nouveau/fb/gf100-: rework ram detection (Ben Skeggs) [1371629]
- [drm] nouveau/fb/gm200: split ram implementation from gm107 (Ben Skeggs) [1371629]
- [drm] nouveau/fb/gf108: split implementation from gf100 (Ben Skeggs) [1371629]
- [drm] nouveau/fb/gf100-: modify constructors to allow more customisation (Ben Skeggs) [1371629]
- [media] usb: uvc: remove unnecessary & operation (Torez Smith) [1444758]
- [media] usb: uvc: make use of new usb_endpoint_maxp_mult() (Torez Smith) [1444758]
- [media] uvcvideo: Correct speed testing (Torez Smith) [1444758]
- [media] uvcvideo: Disable hardware timestamps by default (Torez Smith) [1444758]
- [media] uvcvideo: Fix incorrect bandwidth with Chicony device 04f2:b50b (Torez Smith) [1444758]
- [media] uvcvideo: Set buffer field to V4L2_FIELD_NONE (Torez Smith) [1444758]
- [media] v4l: uvcvideo: Fix buffer completion size check (Torez Smith) [1444758]
- [media] v4l2: uvcvideo: Allow using larger buffers (Torez Smith) [1444758]
- [media] uvc: fix sparse warning (Torez Smith) [1444758]
- [media] uvcvideo: Fix clock param realtime setting (Torez Smith) [1444758]
- [media] uvcvideo: Fix marking buffer erroneous in case of FID toggling (Torez Smith) [1444758]
- [media] uvcvideo: Do not use usb_set_interface on bulk EP (Torez Smith) [1444758]
- [media] uvcvideo: Update uvc_endpoint_max_bpi to handle USB_SPEED_WIRELESS devices (Torez Smith) [1444758]
- [media] uvc/lirc_serial: Fix some warnings on parisc arch (Torez Smith) [1444758]
- [sound] alsa: hda - Simplify bound-beep mute control for ALC268 (Jaroslav Kysela) [1422328]
- [sound] alsa: hda - No loopback on ALC299 codec (Jaroslav Kysela) [1422328]
- [sound] alsa: hda/realtek - Add Dual Codecs support for Lenovo P520/420 (Jaroslav Kysela) [1422328]
- [sound] alsa: hda - Use a helper function for renaming kctl names (Jaroslav Kysela) [1422328]
- [sound] alsa: hda - Support Gigabyte Gaming board with dual Realtek codecs (Jaroslav Kysela) [1422328]
- [sound] alsa: hda - Fix headset microphone detection for ASUS N551 and N751 (Jaroslav Kysela) [1422328]
- [sound] alsa: hda - fix a problem for lineout on a Dell AIO machine (Jaroslav Kysela) [1422328]
- [sound] alsa: hda - Adding a group of pin definition to fix headset problem (Jaroslav Kysela) [1422328]
- [sound] alsa: hda/realtek - Fix speaker support for Asus AiO ZN270IE (Jaroslav Kysela) [1422328]
- [sound] alsa: hda/realtek - Fix headset mic and speaker on Asus X441SA/X441UV (Jaroslav Kysela) [1422328]
- [sound] alsa: hda/realtek - Fix headset and mic on several Asus laptops with ALC256 (Jaroslav Kysela) [1422328]
- [sound] alsa: hda/realtek - Fix headset mic on several Asus laptops with ALC255 (Jaroslav Kysela) [1422328]
- [sound] alsa: hda/realtek - Add support for Acer Aspire E5-475 headset mic (Jaroslav Kysela) [1422328]
- [sound] alsa: hda - Add subwoofer support for Dell Inspiron 17 7000 Gaming (Jaroslav Kysela) [1422328]
- [sound] alsa: hda - Fix micmute hotkey problem for a lenovo AIO machine (Jaroslav Kysela) [1422328]
- [sound] alsa: hda - Allow to enable/disable vmaster build explicitly (Jaroslav Kysela) [1422328]
- [sound] alsa: hda - A new flag to enforce prefix to each pin (Jaroslav Kysela) [1422328]

* Fri May 26 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-672.el7]
- [netdrv] bnxt_en: Call bnxt_dcb_init() after getting firmware DCBX configuration (Jonathan Toppins) [1451915]
- [netdrv] bnxt_en: Check status of firmware DCBX agent before setting DCB_CAP_DCBX_HOST (Jonathan Toppins) [1451915]
- [netdrv] bnxt_en: allocate enough space for ->ntp_fltr_bmap (Jonathan Toppins) [1451915]
- [netdrv] bnxt_en: Check the FW_LLDP_AGENT flag before allowing DCBX host agent (Jonathan Toppins) [1451915]
- [netdrv] bnxt_en: Update firmware interface spec to 1.7.6.2 (Jonathan Toppins) [1451915]
- [netdrv] bnxt_en: Fix VF attributes reporting (Jonathan Toppins) [1451915]
- [netdrv] bnxt_en: Cap the msix vector with the max completion rings (Jonathan Toppins) [1451915]
- [netdrv] mlx5: E-Switch, Don't allow changing inline mode when flows are configured (Jonathan Toppins) [1446112]
- [netdrv] mlx5e: Change the TC offload rule add/del code path to be per NIC or E-Switch (Jonathan Toppins) [1446112]
- [netdrv] mlx5: Add missing entries for set/query rate limit commands (Jonathan Toppins) [1446112]
- [netdrv] mlx5: E-Switch, Enlarge the FDB size for the switchdev mode (Jonathan Toppins) [1446117]
- [netdrv] mlx5e: Avoid wrong identification of rules on deletion (Jonathan Toppins) [1446119]
- [netdrv] mlx5e: Support adding ingress tc rule when egress device flag is set (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Disable preemption when doing TC statistics upcall (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Support TC encapsulation offloads with upper devices (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Fix a -Wmaybe-uninitialized warning (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Properly handle FW errors while adding TC rules (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Fix kbuild warnings for uninitialized parameters (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Set inline mode requirements for matching on IP fragments (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Properly get address type of encapsulation IP headers (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: TC ipv4 tunnel encap offload error flow fixes (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Warn when rejecting offload attempts of IP tunnels (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Properly handle offloading of source udp port for IP tunnels (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Offload TC matching on packets being IP fragments (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Remove flow encap entry in the correct place (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Refactor tc del flow to accept mlx5e_tc_flow instance (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Remove redundant hashtable lookup in configure flower (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Correct cleanup order when deleting offloaded TC rules (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Enforce min inline mode when offloading flows (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Support HW (offloaded) and SW counters for SRIOV switchdev mode (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Add basic TC tunnel set action for SRIOV offloads (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Add TC tunnel release action for SRIOV offloads (Jonathan Toppins) [1383217]
- [netdrv] mlx5: Support encap id when setting new steering entry (Jonathan Toppins) [1383217]
- [netdrv] mlx5: Add creation flags when adding new flow table (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Handle matching on vlan priority for offloaded TC rules (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Add tc support for FWD rule with counter (Jonathan Toppins) [1383217]
- [netdrv] mlx5: Add multi dest support (Jonathan Toppins) [1383217]
- [netdrv] sched: tc_mirred: Rename public predicates 'is_tcf_mirred_redirect' and 'is_tcf_mirred_mirror' (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: shut up maybe-uninitialized warning (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Add TC vlan match parsing (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Add TC vlan action for SRIOV offloads (Jonathan Toppins) [1383217]
- [netdrv] mlx5: Put elements related to offloaded TC rule in one struct (Jonathan Toppins) [1383217]
- [netdrv] mlx5: E-Switch, Set the vport when registering the uplink rep (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Use correct flow dissector key on flower offloading (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Add TC offload support for the VF representors netdevice (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Add TC HW support for FDB (SRIOV e-switch) offloads (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Add TC drop and mirred/redirect action parsing for SRIOV offloads (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Adjustments in the TC offload code towards reuse for SRIOV (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Offload TC flow counters only when supported (Jonathan Toppins) [1383217]
- [netdrv] mlx5: Refactor mlx5_add_flow_rule (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Hardware offloaded flower filter statistics support (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Refactor mlx5e flow steering structs (Jonathan Toppins) [1383217]
- [netdrv] mlx5: Add user chosen levels when allocating flow tables (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Support offload cls_flower with skbedit mark action (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Support offload cls_flower with drop action (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Improve set features ndo resiliency (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: Introduce tc offload support (Jonathan Toppins) [1383217]
- [netdrv] mlx5e: revert commented out flow dissector changes (Jonathan Toppins) [1383217]
- [netdrv] mlx5: Add devlink interface (Jonathan Toppins) [1383217]
- [net] net_sched: act_vlan: add helper inlines to access tcf_vlan info (Jonathan Toppins) [1383217]

* Mon May 22 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-671.el7]
- [scsi] smartpqi: bump driver version for RHEL-7.4 (Don Brace) [1441396]
- [scsi] smartpqi: ensure controller is in SIS mode at init (Don Brace) [1441396]
- [scsi] smartpqi: enhance kdump (Don Brace) [1441396]
- [scsi] lpfc: Fix scsi task management error message (Maurizio Lombardi) [1451022]
- [scsi] lpfc: Fix Express lane queue creation (Maurizio Lombardi) [1451022]
- [scsi] lpfc: correct rdp diag portnames (Maurizio Lombardi) [1451022]
- [scsi] lpfc: Correct WQ creation for pagesize (Maurizio Lombardi) [1451022]
- [net] mac80211: reject ToDS broadcast data frames (Stanislaw Gruszka) [1449091]
- [net] mac80211: fix MU-MIMO follow-MAC mode (Stanislaw Gruszka) [1449091]
- [net] mac80211: unconditionally start new netdev queues with iTXQ support (Stanislaw Gruszka) [1449091]
- [net] cfg80211: check rdev resume callback only for registered wiphy (Stanislaw Gruszka) [1449091]
- [netdrv] iwlwifi: mvm: support ibss in dqa mode (Stanislaw Gruszka) [1449091]
- [netdrv] iwlwifi: mvm: writing zero bytes to debugfs causes a crash (Stanislaw Gruszka) [1449091]
- [netdrv] iwlwifi: mvm: fix accessing fw_id_to_mac_id (Stanislaw Gruszka) [1449091]
- [net] nl80211: fix dumpit error path RTNL deadlocks (Stanislaw Gruszka) [1449091]
- [netdrv] ath10k: fix incorrect wlan_mac_base in qca6174_regs (Stanislaw Gruszka) [1449091]
- [powerpc] kvm: ppc: book 3s: xics: Don't lock twice when checking for resend (David Gibson) [1430371]
- [powerpc] kvm: ppc: book 3s: xics: Implement ICS P/Q states (David Gibson) [1430371]
- [powerpc] kvm: ppc: book3s hv: Counters for passthrough IRQ stats (David Gibson) [1430371]
- [powerpc] kvm: ppc: book3s hv: Set server for passed-through interrupts (David Gibson) [1430371]
- [powerpc] opal: Add real mode call wrappers (David Gibson) [1430371]
- [powerpc] kvm: ppc: book3s hv: Update irq stats for IRQs handled in real mode (David Gibson) [1430371]
- [powerpc] kvm: ppc: book3s hv: Handle passthrough interrupts in guest (David Gibson) [1430371]
- [powerpc] kvm: ppc: book3s hv: Convert kvmppc_read_intr to a C function (David Gibson) [1430371]
- [powerpc] Add simple cache inhibited MMIO accessors (David Gibson) [1430371]
- [powerpc] kvm: ppc: book3s hv: Enable IRQ bypass (David Gibson) [1430371]
- [powerpc] kvm: ppc: select IRQ_BYPASS_MANAGER (David Gibson) [1430371]
- [powerpc] powernv: Provide facilities for EOI, usable from real mode (David Gibson) [1430371]
- [powerpc] kvm: ppc: book3s hv: Introduce kvmppc_passthru_irqmap (David Gibson) [1430371]
- [powerpc] kvm: ppc: book 3s: xics: Fix potential issue with duplicate IRQ resends (David Gibson) [1430371]
- [powerpc] kvm: ppc: book 3s: xics: correct the real mode ICP rejecting counter (David Gibson) [1430371]
- [powerpc] kvm: ppc: book 3s: xics cleanup: remove XICS_RM_REJECT (David Gibson) [1430371]
- [powerpc] 64: Fix race condition in setting lock bit in idle/wakeup code (David Gibson) [1430371]
- [powerpc] powernv: Rename idle_power7.S to idle_book3s.S (David Gibson) [1430371]

* Fri May 19 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-670.el7]
- [fs] NFS append COMMIT after synchronous COPY (Steve Dickson) [1445418]
- [fs] nfs: Fix O_DIRECT verifier problems (Steve Dickson) [1445418]
- [fs] nfsv4: Fix reboot recovery in copy offload (Steve Dickson) [1445418]
- [fs] nfsv4.2: Fix writeback races in nfs4_copy_file_range (Steve Dickson) [1445418]
- [fs] nfs: Ensure we reset the write verifier 'committed' value on resend (Steve Dickson) [1445418]
- [fs] nfs: Cache aggressively when file is open for writing (Scott Mayhew) [1415203]
- [fs] nfs: Don't flush caches for a getattr that races with writeback (Scott Mayhew) [1415203]
- [fs] super.c: fix race between freeze_super() and thaw_super() (Brian Foster) [1383739]
- [md] dm space map disk: fix some book keeping in the disk space map (Mike Snitzer) [1450419]
- [md] dm thin metadata: call precommit before saving the roots (Mike Snitzer) [1450419]
- [usb] revert "xhci: Workaround to get Intel xHCI reset working more reliably" (Torez Smith) [1376639]
- [pci] Add ACS quirk for Intel Union Point (Myron Stowe) [1449796]
- [drm] virtio: fix virtio_gpu_cursor_formats (Laurent Vivier) [1436557]
- [drm] virtio: fix virtio_gpu_mode_dumb_create (Laurent Vivier) [1436960]
- [drm] virtio: add virtio_gpu_translate_format (Laurent Vivier) [1436960]
- [x86] kvm: x86: lower default for halt_poll_ns (Paolo Bonzini) [1365428]
- [x86] kvm: nvmx: initialize PML fields in vmcs02 (Paolo Bonzini) [1440022]
- [x86] kvm: nvmx: do not leak PML full vmexit to L1 (Paolo Bonzini) [1440022]
- [scsi] virtio_scsi: Always try to read VPD pages (David Gibson) [1436675]
- [tools] perf annotate s390: Fix perf annotate error -95 (Jiri Olsa) [1443651]
- [vhost] tun: rx batching (Wei Xu) [1401433]
- [vhost] tun: tx batching (Wei Xu) [1401433]
- [vhost] better detection of available buffers (Wei Xu) [1401433]
- [vhost] tun: Use netif_receive_skb instead of netif_rx (Wei Xu) [1401433]
- [netdrv] mlx5e: Fix loopback selftest (Jonathan Toppins) [1448565]
- [netdrv] mlx5e: remove IEEE/CEE mode check when setting DCBX mode (Jonathan Toppins) [1448565]
- [netdrv] mlx5: Don't save PCI state when PCI error is detected (Jonathan Toppins) [1448565]
- [netdrv] mlx5: Fix create autogroup prev initializer (Jonathan Toppins) [1448565]
- [netdrv] mlx5e: Fix wrong CQE decompression (Jonathan Toppins) [1448565]
- [netdrv] mlx5e: Update MPWQE stride size when modifying CQE compress state (Jonathan Toppins) [1448565]
- [netdrv] mlx5e: Fix broken CQE compression initialization (Jonathan Toppins) [1448565]
- [netdrv] mlx5e: Do not reduce LRO WQE size when not using build_skb (Jonathan Toppins) [1448565]
- [netdrv] mlx5e: Register/unregister vport representors on interface attach/detach (Jonathan Toppins) [1448565]
- [netdrv] mlx5e: s390 system compilation fix (Jonathan Toppins) [1448565]
- [netdrv] bnx2x: Align RX buffers (Michal Schmidt) [1440648]
- [netdrv] mlx5: Avoid dereferencing uninitialized pointer (Kamal Heib) [1450735]
- [netdrv] i40e: reduce wait time for adminq command completion (Stefan Assmann) [1447212]
- [netdrv] xen-netfront: avoid crashing on resume after a failure in talk_to_netback() (Vitaly Kuznetsov) [1447293]
- [netdrv] cxgb4: avoid disabling FEC by default (Sai Vemuri) [1449482]
- [netdrv] hv_netvsc: change netvsc device default duplex to FULL (Vitaly Kuznetsov) [1450371]
- [powerpc] kprobe: Fix oops when kprobed on 'stdu' instruction (Pratyush Anand) [1448286]
- [powerpc] mm: Ensure IRQs are off in switch_mm() (David Gibson) [1437794]
- [infiniband] ib/srp: Fix race conditions related to task management (Don Dutile) [1444155]
- [infiniband] ib/srp: Avoid that duplicate responses trigger a kernel bug (Don Dutile) [1444155]
- [infiniband] ib/srp: Avoid using IB_MR_TYPE_SG_GAPS (Don Dutile) [1444155]
- [infiniband] ib/qib, ib/hfi1: Fix MR reference count leak on write with immediate (Don Dutile) [1366458]
- [infiniband] ib/hfi1: Defer setting VL15 credits to link-up interrupt (Alex Estrin) [1451290]

* Thu May 18 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-669.el7]
- [md] dm cache metadata: fail operations if fail_io mode has been established (Mike Snitzer) [1448904]
- [md] dm cache: handle kmalloc failure allocating background_tracker struct (Mike Snitzer) [1450483]
- [md] dm cache policy smq: don't do any writebacks unless IDLE (Mike Snitzer) [1450483]
- [md] dm cache: simplify the IDLE vs BUSY state calculation (Mike Snitzer) [1450483]
- [md] dm cache: track all IO to the cache rather than just the origin device's IO (Mike Snitzer) [1450483]
- [md] dm cache policy smq: stop preemptively demoting blocks (Mike Snitzer) [1450483]
- [md] dm cache policy smq: put newly promoted entries at the top of the multiqueue (Mike Snitzer) [1450483]
- [md] dm cache policy smq: be more aggressive about triggering a writeback (Mike Snitzer) [1450483]
- [md] dm cache policy smq: only demote entries in bottom half of the clean multiqueue (Mike Snitzer) [1450483]
- [md] dm cache: fix incorrect 'idle_time' reset in IO tracker (Mike Snitzer) [1450483]
- [acpi] button: Do not propagate wakeup-from-suspend events (Lenny Szubowicz) [1246944]
- [acpi] button: fix button driver compile error when CONFIG_PM_SLEEP is undefined (Lenny Szubowicz) [1246944]
- [s390] dasd: allow 0 for path_threshold attribute (Hendrik Brueckner) [1447738]
- [s390] dasd: suppress command reject error for query host access command (Hendrik Brueckner) [1440709]
- [s390] dasd: check if query host access feature is supported (Hendrik Brueckner) [1440709]
- [x86] mm: Fix boot crash caused by incorrect loop count calculation in sync_global_pgds() (Baoquan He) [1440196]
- [x86] efi: Consolidate region mapping logic (Bhupesh Sharma) [1446102]
- [x86] efi: Map RAM into the identity page table for mixed mode (Bhupesh Sharma) [1446102]
- [powerpc] mm: Add support for runtime configuration of ASLR limits (Bhupesh Sharma) [1412802]
- [mm] aslr: use get_random_long() (Bhupesh Sharma) [1412802]
- [kernel] char: random: add get_random_long() (Bhupesh Sharma) [1412802]
- [x86] mm: support ARCH_MMAP_RND_BITS (Bhupesh Sharma) [1412802]
- [mm] mmap: add new /proc tunable for mmap_base ASLR (Bhupesh Sharma) [1412802]
- [x86] use simpler API for random address requests (Bhupesh Sharma) [1412802]
- [kernel] random: simplify API for random address requests (Bhupesh Sharma) [1412802]
- [kernel] powerpc: Wire up sys_seccomp(), sys_getrandom() and sys_memfd_create() (Herbert Xu) [1432218]
- [kernel] s390: wire up seccomp and getrandom syscalls (Herbert Xu) [1432218]
- [netdrv] mlx4_en: Change the error print to debug print (Kamal Heib) [1334054]
- [netdrv] nfp: add missing .ndo_size to net_device_ops structure (John Linville) [1449381]
- [netdrv] enic: Add missing ndo_size param to net_device_ops struct (Stefan Assmann) [1449376]
- [netdrv] aquantia: Fix "ethtool -S" crash when adapter down (David Arcari) [1446250]
- [netdrv] cxgb4: Add missing ndo_size param to net_device_ops struct (Don Dutile) [1449379]
- [netdrv] fjes: Do not load fjes driver if extended socket device is not power on (Yasuaki Ishimatsu) [1436380]
- [netdrv] fjes: Do not load fjes driver if system does not have extended socket device (Yasuaki Ishimatsu) [1436380]

* Tue May 16 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-668.el7]
- [net] ethtool: remove unused __ethtool_get_settings (Ivan Vecera) [1449330]
- [net] core: use __ethtool_get_ksettings (Ivan Vecera) [1449330]
- [net] sysfs: Print link speed as signed integer (Ivan Vecera) [1449330]
- [net] 8021q: use __ethtool_get_ksettings (Ivan Vecera) [1449330]
- [scsi] fcoe: use __ethtool_get_ksettings (Ivan Vecera) [1449330]
- [net] team: use __ethtool_get_ksettings (Ivan Vecera) [1449330]
- [net] macvlan: use __ethtool_get_ksettings (Ivan Vecera) [1449330]
- [net] sched: actions: allocate act cookie early (Ivan Vecera) [1447674]
- [net] sched: actions: do not overwrite status of action creation (Ivan Vecera) [1447674]
- [net] sched: actions: Add support for user cookies (Ivan Vecera) [1447674]
- [net] netlink: Add nla_memdup() to wrap kmemdup() use on nlattr (Ivan Vecera) [1447674]
- [net] sched: act_tunnel_key: Fix setting UDP dst port in metadata under IPv6 (Ivan Vecera) [1445398]
- [net] sched: act_tunnel_key: Add UDP dst port option (Ivan Vecera) [1445398]
- [net] dst: Add dst port to dst_metadata utility functions (Ivan Vecera) [1445398]
- [net] sched: act_tunnel_key: add helper inlines to access tcf_tunnel_key (Ivan Vecera) [1445398]
- [net] sched: act_tunnel_key: Remove rcu_read_lock protection (Ivan Vecera) [1445398]
- [net] sched: Introduce act_tunnel_key (Ivan Vecera) [1445398]
- [net] vxlan: do not output confusing error message (Jiri Benc) [1445054]
- [net] vxlan: correctly handle ipv6.disable module parameter (Jiri Benc) [1445054]
- [net] sched: actions: aggregate dumping of actions timeinfo (Ivan Vecera) [1442088]
- [net] sched: actions: introduce timestamp for firsttime use (Ivan Vecera) [1442088]
- [net] sched: actions: use tcf_lastuse_update for consistency (Ivan Vecera) [1442088]
- [net] sched: actions: policer missing timestamp processing (Ivan Vecera) [1442088]
- [net] sched: align nlattr properly when needed (Ivan Vecera) [1442088]
- [net] ipvs: explicitly forbid ipv6 service/dest creation if ipv6 mod is disabled (Paolo Abeni) [1439235]
- [net] ipv6: implement ipv6_mod_enabled (Paolo Abeni) [1439235]

* Tue May 16 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-667.el7]
- [fs] sunrpc: fix refcounting problems with auth_gss messages (Steve Dickson) [1406925]
- [fs] sunrpc: allow for upcalls for same uid but different gss service (Steve Dickson) [1406925]
- [fs] nfs: move rw_mode to nfs_pageio_header (Benjamin Coddington) [1441370]
- [fs] nfs: move nfs_pgarray_set() to open code (Benjamin Coddington) [1441370]
- [fs] nfs: Use GFP_NOIO for two allocations in writeback (Benjamin Coddington) [1441370]
- [fs] nfsd: move blocked lock handling under a dedicated spinlock (Benjamin Coddington) [1377710]
- [fs] nfsd: set the MAY_NOTIFY_LOCK flag in OPEN replies (Benjamin Coddington) [1377710]
- [fs] nfsd: add a LRU list for blocked locks (Benjamin Coddington) [1377710]
- [fs] nfsd: have nfsd4_lock use blocking locks for v4.1+ locks (Benjamin Coddington) [1377710]
- [fs] nfsd: plumb in a CB_NOTIFY_LOCK operation (Benjamin Coddington) [1377710]
- [fs] nfsd: Get reference of lockowner when coping file_lock (Benjamin Coddington) [1377710]
- [fs] nfsd: New helper nfs4_get_stateowner() for atomic_inc sop reference (Benjamin Coddington) [1377710]
- [fs] locks: Copy fl_lmops information for conflock in locks_copy_conflock() (Benjamin Coddington) [1377710]
- [fs] locks: defer freeing locks in locks_delete_lock until after i_lock has been dropped (Benjamin Coddington) [1377710]
- [fs] locks: don't reuse file_lock in __posix_lock_file (Benjamin Coddington) [1377710]
- [fs] locks: New ops in lock_manager_operations for get/put owner (Benjamin Coddington) [1377710]
- [fs] locks: Rename __locks_copy_lock() to locks_copy_conflock() (Benjamin Coddington) [1377710]
- [fs] nfs: allow blocking locks to be awoken by lock callbacks (Benjamin Coddington) [1377710]
- [fs] nfs: move nfs4 lock retry attempt loop to a separate function (Benjamin Coddington) [1377710]
- [fs] nfs: move nfs4_set_lock_state call into caller (Benjamin Coddington) [1377710]
- [fs] nfs: add handling for CB_NOTIFY_LOCK in client (Benjamin Coddington) [1377710]
- [fs] nfs: track whether server sets MAY_NOTIFY_LOCK flag (Benjamin Coddington) [1377710]
- [fs] nfs: add a new NFS4_OPEN_RESULT_MAY_NOTIFY_LOCK constant (Benjamin Coddington) [1377710]
- [fs] nfs: use safe, interruptible sleeps when waiting to retry LOCK (Benjamin Coddington) [1377710]
- [fs] nfs: eliminate pointless and confusing do_vfs_lock wrappers (Benjamin Coddington) [1377710]
- [fs] nfs: the length argument to read_buf should be unsigned (Benjamin Coddington) [1377710]
- [fs] Move locks API users to locks_lock_inode_wait() (Benjamin Coddington) [1377710]
- [fs] locks: introduce locks_lock_inode_wait() (Benjamin Coddington) [1377710]
- [scsi] lpfc: Fix panic on BFS configuration (Maurizio Lombardi) [1443116]
- [scsi] lpfc: The lpfc driver does not issue RFF_ID and RFT_ID in the correct sequence (Ewan Milne) [1430272]

* Thu May 11 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-666.el7]
- [i2c] piix4: Request the SMBUS semaphore inside the mutex (David Arcari) [1446660]
- [i2c] piix4: Fix request_region size (David Arcari) [1446660]
- [i2c] piix4: Avoid race conditions with IMC (David Arcari) [1446660]
- [i2c] piix4: Pre-shift the port number (David Arcari) [1446660]
- [i2c] piix4: Always use the same type for port (David Arcari) [1446660]
- [i2c] piix4: Support alternative port selection register (David Arcari) [1446660]
- [i2c] piix4: don't regress on bus names (David Arcari) [1446660]
- [i2c] piix4: Fully initialize SB800 before it is registered (David Arcari) [1446660]
- [i2c] piix4: Fix SB800 locking (David Arcari) [1446660]
- [i2c] piix4: remove unneeded assignments (David Arcari) [1446660]
- [i2c] piix4: Add adapter port name support for SB800 chipset (David Arcari) [1446660]
- [i2c] piix4: Add support for multiplexed main adapter in SB800 (David Arcari) [1446660]
- [i2c] piix4: Convert piix4_main_adapter to array (David Arcari) [1446660]
- [i2c] i2c-piix4: Use Macro for AMD CZ SMBus device ID (David Arcari) [1446660]
- [i2c] delete non-required instances of include <linux/init.h> (David Arcari) [1446660]
- [i2c] piix4: Standardize log messages (David Arcari) [1446660]
- [i2c] piix4: Use different message for AMD Auxiliary SMBus Controller (David Arcari) [1446660]
- [i2c] piix4: Add support for AMD ML and CZ SMBus changes (David Arcari) [1446660]
- [i2c] piix4: Add support for secondary SMBus on AMD SB800 and AMD FCH chipsets (David Arcari) [1446660]
- [hwmon] (jc42) Add I2C_CLASS_HWMON to detection class (David Arcari) [1446660]
- [hwmon] (jc42) Add support for Microchip MCP9808 temperature sensor (David Arcari) [1446660]
- [hwmon] (jc42) Add support for additional IDT temperature sensors (David Arcari) [1446660]
- [hwmon] (jc42) Allow negative hysteresis temperatures (David Arcari) [1446660]
- [hwmon] (jc42) Fix integer overflow when writing hysteresis value (David Arcari) [1446660]
- [hwmon] (jc42) Fix integer overflow (David Arcari) [1446660]
- [hwmon] (jc42) Use sign_extend32 for sign extension (David Arcari) [1446660]
- [hwmon] (jc42) Add support for STTS2004 and AT30TSE004 (David Arcari) [1446660]
- [hwmon] (jc42) Convert function macros into functions (David Arcari) [1446660]
- [hwmon] (jc42) Rearrange code to avoid forward declarations (David Arcari) [1446660]
- [hwmon] (jc42) fix coccinelle warnings (David Arcari) [1446660]
- [hwmon] (jc42) Convert to use devm_hwmon_device_register_with_groups (David Arcari) [1446660]

* Wed May 10 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-665.el7]
- [scsi] qla2xxx: Allow vref count to timeout on vport delete (Himanshu Madhani) [1441897]
- [vfio] type1: Reduce repetitive calls in vfio_pin_pages_remote() (Alex Williamson) [1438403]
- [vfio] type1: Prune vfio_pin_page_external() (Alex Williamson) [1438403]
- [vfio] type1: Remove locked page accounting workqueue (Alex Williamson) [1438403]
- [acpi] acpica: tables: Update FADT handling (Lenny Szubowicz) [1411246]
- [acpi] acpica: acpi 6.0: Add changes for FADT table (Lenny Szubowicz) [1411246]
- [misc] vmci: Use 32bit atomics for queue headers on X86_32 (Cathy Avery) [1437109]
- [misc] vmci: Guard against overflow in queue pair allocation (Cathy Avery) [1437109]
- [misc] vmci: Check userland-provided datagram size (Cathy Avery) [1437109]
- [misc] vmci: Fix two UVA mapping bugs (Cathy Avery) [1437109]
- [misc] vmci: integer overflow in vmci_datagram_dispatch() (Cathy Avery) [1437109]
- [misc] vmci: fix error handling path when registering guest driver (Cathy Avery) [1437109]
- [misc] vmw_vmci: Convert driver to use get_user_pages_fast() (Cathy Avery) [1437109]
- [misc] vmci: Add support for virtual IOMMU (Cathy Avery) [1437109]
- [misc] vmci: Remove non-blocking/pinned queuepair support (Cathy Avery) [1437109]
- [net] vsock: Only check error on skb_recv_datagram when skb is NULL (Cathy Avery) [1437109]
- [x86] xen: don't crash under Xen hypervisors which present bogus topology (Vitaly Kuznetsov) [1443627]
- [fs] gfs2: Allow glocks to be unlocked after withdraw (Robert S Peterson) [1404005]
- [fs] svcrpc: fix memory leak in gssp_accept_sec_context_upcall ("J. Bruce Fields") [1447776]
- [fs] cifs_get_root shouldn't use path with tree name (Sachin Prabhu) [1373153]
- [fs] Fix match_prepath() (Sachin Prabhu) [1418107]
- [fs] locks: __break_lease cleanup in preparation of allowing direct removal of leases (Scott Mayhew) [1444338]
- [fs] xfs: bufferhead chains are invalid after end_page_writeback (Brian Foster) [1445158]
- [md] dm cache policy smq: cleanup free_target_met() and clean_target_met() (Mike Snitzer) [1448210]
- [md] dm cache policy smq: allow demotions to happen even during continuous IO (Mike Snitzer) [1448210]
- [md] dm cache policy smq: make the cleaner policy write-back more aggressively (Mike Snitzer) [1437251]
- [md] dm cache: set/clear the cache core's dirty_bitset when loading mappings (Mike Snitzer) [1437251]
- [md] dm crypt: rewrite (wipe) key in crypto layer using random data (Mike Snitzer) [1444337 1445816]
- [md] dm mpath: requeue after a small delay if blk_get_request() fails (Mike Snitzer) [1445816]
- [md] dm era: save spacemap metadata root after the pre-commit (Mike Snitzer) [1445816]
- [md] dm thin: fix a memory leak when passing discard bio down (Mike Snitzer) [1445816]
- [md] dm btree: fix for dm_btree_find_lowest_key() (Mike Snitzer) [1445816]
- [block] fix blk_integrity_register to use template's interval_exp if not 0 (Mike Snitzer) [1445816]
- [block] blk: Ensure users for current->bio_list can see the full list (Ming Lei) [1447313]
- [block] blk: improve order of bio handling in generic_make_request() (Ming Lei) [1447313]
- [netdrv] macvtap: read skb from skb array (Wei Xu) [1447143]
- [netdrv] Change TECH Preview message to match driver name (David Arcari) [1444721]
- [netdrv] aquantia: Fix driver name reported by ethtool (David Arcari) [1444721]
- [netdrv] ib/mlx5: Add port_xmit_wait to counter registers read (Kamal Heib) [1448020 1447995 1447788]
- [netdrv] ib/mlx5: Add missing hw counters (Kamal Heib) [1448020 1447995 1447788]
- [netdrv] mlx5e: Initialize ndo_size (Kamal Heib) [1448020 1447995 1447788]
- [powerpc] eeh: Refactor EEH PE reset functions (Gustavo Duarte) [1428706]

* Mon May 08 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-664.el7]
- [fs] nfsd: stricter decoding of write-like NFSv2/v3 ops ("J. Bruce Fields") [1443204] {CVE-2017-7895}
- [fs] nfsd4: minor NFSv2/v3 write decoding cleanup ("J. Bruce Fields") [1443204] {CVE-2017-7895}
- [fs] nfsd: check for oversized NFSv2/v3 arguments ("J. Bruce Fields") [1442407] {CVE-2017-7645}
- [net] macsec: dynamically allocate space for sglist (Sabrina Dubroca) [1445545] {CVE-2017-7477}
- [net] macsec: avoid heap overflow in skb_to_sgvec (Sabrina Dubroca) [1445545] {CVE-2017-7477}
- [net] bridge: move bridge multicast cleanup to ndo_uninit (Xin Long) [1434682]
- [net] bridge: netlink: register netdevice before executing changelink (Xin Long) [1434682]
- [net] bridge: implement missing ndo_uninit() (Xin Long) [1434682]
- [net] team: call netdev_change_features out of team lock (Xin Long) [1429679]
- [net] netfilter: nf_tables: add support for inverted logic in nft_lookup (Hangbin Liu) [1441103]
- [netdrv] bonding: avoid defaulting hard_header_len to ETH_HLEN on slave removal (Honggang Li) [1425030]
- [kernel] kallsyms: don't overload absolute symbol type for percpu symbols (Josh Poimboeuf) [1447175]
- [kernel] kallsyms: fix percpu vars on x86-64 with relocation (Josh Poimboeuf) [1447175]
- [kernel] kallsyms: generalize address range checking (Josh Poimboeuf) [1447175]
- [powerpc] Update TM user feature bits in scan_features() (David Gibson) [1445883]
- [powerpc] Update cpu_user_features2 in scan_features() (David Gibson) [1445883]
- [powerpc] tm: Abort syscalls in active transactions (David Gibson) [1445883]
- [powerpc] selftests/powerpc: Add transactional syscall test (David Gibson) [1445883]
- [powerpc] selftests/powerpc: Make git ignore all binaries in powerpc test suite (David Gibson) [1445883]
- [powerpc] Disable CPU_FTR_TM if TM is disabled by firmware (David Gibson) [1445883]

* Tue May 02 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-663.el7]
- [x86] kvm: x86: fix emulation of RSM and IRET instructions (Ladi Prosek) [1441510]
- [pci] hv: Allocate interrupt descriptors with GFP_ATOMIC (Vitaly Kuznetsov) [1442282]
- [pci] hv: Specify CPU_AFFINITY_ALL for MSI affinity when >= 32 CPUs (Vitaly Kuznetsov) [1442282]
- [pci] hv: Lock PCI bus on device eject (Vitaly Kuznetsov) [1442282]
- [pci] hv: Properly handle PCI bus remove (Vitaly Kuznetsov) [1442282]
- [edac] sb_edac: Add Knights Mill support (Aristeu Rozanski) [1432437]
- [edac] {sb, skx}_edac: Use Intel model macros instead of open-coding them (Aristeu Rozanski) [1432437]
- [edac] sb_edac: Fix Knights Landing (Aristeu Rozanski) [1432437]
- [edac] sb_edac: Readd accidentally dropped Broadwell-D support (Aristeu Rozanski) [1432437]
- [edac] sb_edac: Use cpu family/model in driver detection (Aristeu Rozanski) [1432437]
- [netdrv] bnx2x: add missing configuration of VF VLAN filters (Michal Schmidt) [1445770]
- [netdrv] bnx2x: fix incorrect filter count in an error message (Michal Schmidt) [1445770]
- [netdrv] bnx2x: do not rollback VF MAC/VLAN filters we did not configure (Michal Schmidt) [1445770]
- [netdrv] bnx2x: fix detection of VLAN filtering feature for VF (Michal Schmidt) [1445770]
- [netdrv] bnx2x: lower verbosity of VF stats debug messages (Michal Schmidt) [1445770]
- [powerpc] powernv: Expose OPAL firmware symbol map (Gustavo Duarte) [1444807]

* Tue May 02 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-662.el7]
- [drm] config: enable GVT (Rob Clark) [1380115]
- [drm] makefile: update DRM version (Rob Clark) [1422186]
- [drm] i915/gvt: set the correct default value of CTX STATUS PTR (Rob Clark) [1422186]
- [drm] fb-helper: Allow var->x/yres(_virtual) < fb->width/height again (Rob Clark) [1422186]
- [drm] nouveau: initial support (display-only) for GP107 (Rob Clark) [1422186]
- [drm] nouveau/kms/nv50: fix double dma_fence_put() when destroying plane state (Rob Clark) [1422186]
- [drm] nouveau/mmu/nv4a: use nv04 mmu rather than the nv44 one (Rob Clark) [1422186]
- [drm] nouveau/mpeg: mthd returns true on success now (Rob Clark) [1422186]
- [drm] i915: Do .init_clock_gating() earlier to avoid it clobbering watermarks (Rob Clark) [1422186]
- [drm] i915: Avoid rcu_barrier() from reclaim paths (shrinker) (Rob Clark) [1422186]
- [drm] i915: Stop using RP_DOWN_EI on Baytrail (Rob Clark) [1422186]
- [drm] i915: Drop support for I915_EXEC_CONSTANTS_* execbuf parameters (Rob Clark) [1422186]
- [drm] i915: Only enable hotplug interrupts if the display interrupts are enabled (Rob Clark) [1422186]
- [drm] i915: Reject HDMI 12bpc if the sink doesn't indicate support (Rob Clark) [1422186]
- [drm] i915: Avoid tweaking evaluation thresholds on Baytrail v3 (Rob Clark) [1422186]
- [drm] i915: Nuke debug messages from the pipe update critical section (Rob Clark) [1422186]
- [drm] i915: Store a permanent error in obj->mm.pages (Rob Clark) [1422186]
- [drm] i915/gen9: Increase PCODE request timeout to 50ms (Rob Clark) [1422186]
- [drm] i915: Squelch any ktime/jiffie rounding errors for wait-ioctl (Rob Clark) [1422186]
- [drm] i915/fbdev: Stop repeating tile configuration on stagnation (Rob Clark) [1422186]
- [drm] i915: Move updating color management to before vblank evasion (Rob Clark) [1422186]
- [drm] i915: Fix forcewake active domain tracking (Rob Clark) [1422186]
- [drm] i915: actually drive the BDW reserved IDs (Rob Clark) [1422186]
- [drm] i915: more .is_mobile cleanups for BDW (Rob Clark) [1422186]
- [drm] i915: fix INTEL_BDW_IDS definition (Rob Clark) [1422186]
- [drm] edid: constify edid quirk list (Rob Clark) [1422186]
- [drm] vmwgfx: fix integer overflow in vmw_surface_define_ioctl() (Rob Clark) [1422186]
- [drm] vmwgfx: Remove getparam error message (Rob Clark) [1422186]
- [drm] ttm, drm/vmwgfx: Relax permission checking when opening surfaces (Rob Clark) [1422186]
- [drm] vmwgfx: avoid calling vzalloc with a 0 size in vmw_get_cap_3d_ioctl() (Rob Clark) [1422186]
- [drm] vmwgfx: NULL pointer dereference in vmw_surface_define_ioctl() (Rob Clark) [1422186]
- [drm] vmwgfx: Type-check lookups of fence objects (Rob Clark) [1422186]
- [drm] i915: Split intel_engine allocation and initialisation (Rob Clark) [1380115]
- [drm] nouveau/kms/nv50: fix setting of HeadSetRasterVertBlankDmi method (Rob Clark) [1422186]
- [drm] vfio: Rework group release notifier warning (Rob Clark) [1380115]
- [drm] i915/gvt: Fix firmware loading interface for GVT-g golden HW state (Rob Clark) [1380115]
- [drm] i915/gvt: remove the redundant info NULL check (Rob Clark) [1380115]
- [drm] i915/gvt: adjust mem size for low resolution type (Rob Clark) [1380115]
- [drm] i915/gvt: exclude cfg space from failsafe mode (Rob Clark) [1380115]
- [drm] i915/gvt: Activate/de-activate vGPU in mdev ops (Rob Clark) [1380115]
- [drm] i915/gvt: Use force single submit flag to distinguish gvt request from i915 request (Rob Clark) [1380115]
- [drm] i915: make context status notifier head be per engine (Rob Clark) [1380115]
- [drm] i915/gvt: set shadow entry to scratch page while p2m failed (Rob Clark) [1380115]
- [drm] i915/gvt: Fix guest fail to read EDID leading to black guest console issue (Rob Clark) [1380115]
- [drm] i915/gvt: fix wrong offset when loading RCS mocs (Rob Clark) [1380115]
- [drm] i915/gvt: add write handler for mmio mbctl (Rob Clark) [1380115]
- [drm] i915/gvt: Fix gvt scheduler interval time (Rob Clark) [1380115]
- [drm] i915/gvt: scan shadow indirect context image when valid (Rob Clark) [1380115]
- [drm] i915/kvmgt: fix suspicious rcu dereference usage (Rob Clark) [1380115]
- [drm] i915/gvt: Remove bogus retry around i915_wait_request (Rob Clark) [1380115]
- [drm] i915/gvt: correct the ggtt valid bit check in pipe control command (Rob Clark) [1380115]
- [drm] i915/gvt: replace the gvt_err with gvt_vgpu_err (Rob Clark) [1380115]
- [drm] i915/gvt: handle force-nonpriv registers, cmd parser part (Rob Clark) [1380115]
- [drm] i915/gvt: set ring buffer size to default for guc submission (Rob Clark) [1380115]
- [drm] i915/gvt: change some gvt_err to gvt_dbg_cmd (Rob Clark) [1380115]
- [drm] i915/gvt: protect RO and Rsvd bits of virtual vgpu configuration space (Rob Clark) [1380115]
- [drm] i915/gvt: handle workload lifecycle properly (Rob Clark) [1380115]
- [drm] i915/gvt: fix an error for F_RO flag (Rob Clark) [1380115]
- [drm] i915/gvt: use pfn_valid for better checking (Rob Clark) [1380115]
- [drm] i915/gvt: set SFUSE_STRAP properly for vitual monitor detection (Rob Clark) [1380115]
- [drm] i915/gvt: fix an error for one register (Rob Clark) [1380115]
- [drm] i915/gvt: add more registers into handlers list (Rob Clark) [1380115]
- [drm] i915/gvt: have more registers with F_CMD_ACCESS flags set (Rob Clark) [1380115]
- [drm] i915/gvt: add some new MMIOs to cmd_access white list (Rob Clark) [1380115]
- [drm] i915/gvt: fix pcode mailbox write emulation of BDW (Rob Clark) [1380115]
- [drm] i915/gvt: add resolution definition for vGPU type (Rob Clark) [1380115]
- [drm] i915/gvt: Add more edid definition support (Rob Clark) [1380115]
- [drm] i915/gvt: adjust to fixed vGPU types (Rob Clark) [1380115]
- [drm] i915/gvt: remove unnecessary error msg from gtt write (Rob Clark) [1380115]
- [drm] i915/gvt: refine pcode write emulation (Rob Clark) [1380115]
- [drm] i915/gvt: clear the vGPU reset logic (Rob Clark) [1380115]
- [drm] i915/gvt: decrease priority of output msg for untracked mmio (Rob Clark) [1380115]
- [drm] i915/gvt: set default value to 0 for unhandled mmio regs (Rob Clark) [1380115]
- [drm] i915/gvt: add cmd_access to GEN7_HALF_SLICE_CHICKEN1 (Rob Clark) [1380115]
- [drm] i915/gvt: force-nopriv register handling (Rob Clark) [1380115]
- [drm] i915/gvt: add more registers to context save/restore list (Rob Clark) [1380115]
- [drm] i915/gvt: fix unhandled mmio warnings (Rob Clark) [1380115]
- [drm] i915/gvt: add a NULL pointer check to avoid kernel panic (Rob Clark) [1380115]
- [drm] i915/gvt: enter failsafe mode when guest requires more resources (Rob Clark) [1380115]
- [drm] i915/gvt: handle fence reg access during GPU reset (Rob Clark) [1380115]
- [drm] i915/gvt: introduced failsafe mode into vgpu (Rob Clark) [1380115]
- [drm] i915/gvt: Fix check error on opregion.c (Rob Clark) [1380115]
- [drm] i915/gvt: return error code if dma map iova failed (Rob Clark) [1380115]
- [drm] i915/gvt: optimize the inhibit context mmio load (Rob Clark) [1380115]
- [drm] i915/gvt: add sprite plane flip done support (Rob Clark) [1380115]
- [drm] i915/gvt: add missing display part reset for vGPU reset (Rob Clark) [1380115]
- [drm] i915/gvt: Fix shadow context descriptor (Rob Clark) [1380115]
- [drm] i915/gvt: fix crash at function release_shadow_wa_ctx (Rob Clark) [1380115]
- [drm] i915/gvt: enable IOMMU for gvt (Rob Clark) [1380115]
- [drm] i915/gvt: map pfn for PTE entry in kvm (Rob Clark) [1380115]
- [drm] i915/gvt: Map shadow page before using it in shadow page table (Rob Clark) [1380115]
- [drm] i915/gvt: reduce the line of interrupt logs and log friendly (Rob Clark) [1380115]
- [drm] i915/gvt: remove a redundant end of line in debug log (Rob Clark) [1380115]
- [drm] i915/gvt: remove a noisy unimportant log in sched_policy (Rob Clark) [1380115]
- [drm] i915/gvt/kvmgt: remove some dead code (Rob Clark) [1380115]
- [drm] i915/gvt: fix vgpu type size init (Rob Clark) [1380115]
- [drm] i915/gvt: use normal mmio read function for firmware exposure (Rob Clark) [1380115]
- [drm] i915/gvt: remove detect_host() MPT hook (Rob Clark) [1380115]
- [drm] i915/gvt: move intel iommu detection to intel_gvt_init() (Rob Clark) [1380115]
- [drm] i915: make intel_gvt_init() later instead of too early (Rob Clark) [1380115]
- [drm] i915/gvt: add more resolutions in virtual edid (Rob Clark) [1380115]
- [drm] i915: A hotfix for making aliasing PPGTT work for GVT-g (Rob Clark) [1380115 1422186]
- [drm] i915: Let execlist_update_context() cover !FULL_PPGTT mode (Rob Clark) [1380115 1422186]
- [drm] i915: Move the release of PT page to the upper caller (Rob Clark) [1380115 1422186]
- [drm] i915/kvmgt: Hold struct kvm reference (Rob Clark) [1422186]
- [drm] radeon: Override fpfn for all VRAM placements in radeon_evict_flags (Rob Clark) [1422186]
- [drm] reference count event->completion (Rob Clark) [1422186]
- [drm] amd/amdgpu: add POLARIS12 PCI ID (Rob Clark) [1422186]
- [drm] amdgpu: reinstate oland workaround for sclk (Rob Clark) [1422186]
- [drm] amdgpu/si: add dpm quirk for Oland (Rob Clark) [1422186]
- [drm] i915/lspcon: Fix resume time initialization due to unasserted HPD (Rob Clark) [1422186]
- [drm] i915/gen9+: Enable hotplug detection early (Rob Clark) [1422186]
- [drm] i915/lspcon: Enable AUX interrupts for resume time initialization (Rob Clark) [1422186]
- [drm] i915/gvt: Fix superfluous newline in GVT_DISPLAY_READY env var (Rob Clark) [1380115 1422186]
- [drm] i915: Fix not finding the VBT when it overlaps with OPREGION_ASLE_EXT (Rob Clark) [1422186]
- [drm] i915: Pass timeout==0 on to i915_gem_object_wait_fence() (Rob Clark) [1422186]
- [drm] i915: Check for timeout completion when waiting for the rq to submitted (Rob Clark) [1422186]
- [drm] i915: Avoid spurious WARNs about the wrong pipe in the PPS code (Rob Clark) [1422186]
- [drm] i915: Recreate internal objects with single page segments if dmar fails (Rob Clark) [1422186]
- [drm] Cancel drm_fb_helper_resume_work on unload (Rob Clark) [1422186]
- [drm] Cancel drm_fb_helper_dirty_work on unload (Rob Clark) [1422186]
- [drm] i915/gvt: Disable access to stolen memory as a guest (Rob Clark) [1422186]
- [drm] atomic: fix an error code in mode_fixup() (Rob Clark) [1422186]
- [drm] ttm: Make sure BOs being swapped out are cacheable (Rob Clark) [1422186]
- [drm] edid: Add EDID_QUIRK_FORCE_8BPC quirk for Rotel RSX-1058 (Rob Clark) [1422186]
- [drm] radeon: handle vfct with multiple vbios images (Rob Clark) [1422186]
- [drm] ast: Fix AST2400 POST failure without BMC FW or VBIOS (Rob Clark) [1422186]
- [drm] ast: Call open_key before enable_mmio in POST code (Rob Clark) [1422186]
- [drm] ast: Fix test for VGA enabled (Rob Clark) [1422186]
- [drm] revert "drm/amdgpu: update tile table for oland/hainan" (Rob Clark) [1422186]
- [drm] amdgpu/pm: check for headless before calling compute_clocks (Rob Clark) [1422186]
- [drm] amdgpu: add more cases to DCE11 possible crtc mask setup (Rob Clark) [1422186]

* Mon May 01 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-661.el7]
- [scsi] sd: Consider max_xfer_blocks if opt_xfer_blocks is unusable (Ewan Milne) [1436582]
- [scsi] revert "lpfc: Revert: Fix eh_deadline setting for sli3 adapters" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Correct WQ creation for pagesize" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: minor code cleanups" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: refactor debugfs queue prints" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: refactor debugfs queue dump routines" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: NVME Initiator: Base modifications" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: NVME Initiator: Merge into FC discovery" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: NVME Initiator: bind to nvme_fc api" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: NVME Initiator: Add debugfs support" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: NVME Target: Base modifications" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: NVME Target: Receive buffer updates" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: NVME Target: Merge into FC discovery" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: NVME Target: bind to nvmet_fc api" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: NVME Target: Add debugfs support" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Update copyrights" (Ewan Milne) [1444045]
- [scsi] revert "Update lpfc version to 11.2.0.8 with NVME support" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: remove redundant assignment of sgel" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: sanity check hrq is null before dereferencing it" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: don't dereference dma_buf-&gt; iocbq before null check" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: fix missing spin_unlock on sql_list_lock" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Fix crash during Hardware error recovery on SLI3 adapters" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Fix RCTL value on NVME LS request and response" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Fix NVME CMD IU byte swapped word 1 problem" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Fix IO submission if WQ is full" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Fix nvme allocation bug on failed nvme_fc_register_localport" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: add NVME exchange aborts" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Rename LPFC_MAX_EQ_DELAY to LPFC_MAX_EQ_DELAY_EQID_CNT" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: correct double print" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: remove dead sli3 nvme code" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: correct rdp diag portnames" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: code cleanups in NVME initiator discovery" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Fix eh_deadline setting for sli3 adapters" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: replace init_timer by setup_timer" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: add missing Kconfig NVME dependencies" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Rework lpfc Kconfig for NVME options" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Finalize Kconfig options for nvme" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: The lpfc driver does not issue RFF_ID and RFT_ID in the correct sequence" (Ewan Milne) [1444045]
- [scsi] revert "lpfc version bump for nvme to 11.2.0.11" (Ewan Milne) [1444045]
- [nvme] revert "nvmet_fc: cleanup of abort flag processing in fcp_op_done" (Ewan Milne) [1444045]
- [nvme] revert "nvme-fc: don't bother to validate ioccsz and iorcsz" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fc: Sync FC-NVME header with standard" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fc: Add check of status_code in ERSP_IU" (Ewan Milne) [1444045]
- [nvme] revert "nvmet_fc: Sync NVME LS reject reasons with spec" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fc: correct LS validation" (Ewan Milne) [1444045]
- [nvme] revert "nvmet_fc: Clear SG list to avoid double frees" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fc: Clean up host fcpio done status handling" (Ewan Milne) [1444045]
- [nvme] revert "nvmet_fc: add target feature flags for upcall isr contexts" (Ewan Milne) [1444045]
- [nvme] revert "nvmet_fc: add req_release to lldd api" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fcloop: split job struct from transport for req_release" (Ewan Milne) [1444045]
- [nvme] revert "nvmet_fc: Rework target side abort handling" (Ewan Milne) [1444045]
- [nvme] revert "nvmet_fc: add missing reference in add_port" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fc: Move LS's to rport" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fc: Add ls aborts on remote port teardown" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fc: fix command id check" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fc: add aen abort to teardown" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fc: add controller reset support" (Ewan Milne) [1444045]
- [nvme] revert "nvme-fc: add .map_queue entry to blk_mq_ops" (Ewan Milne) [1444045]
- [nvme] revert "nvme_fc: avoid double kfree(), don't call nvme_cleanup_cmd() in nvme_fc_unmap_data()" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: Mark NVMe and NVMe Target support as tech preview" (Ewan Milne) [1444045]
- [scsi] revert "lpfc: code cleanups in NVME initiator base" (Ewan Milne) [1444045]
- [scsi] qla2xxx: Update message for module parameter (Himanshu Madhani) [1445879]

* Sat Apr 29 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-660.el7]
- [kernel] tick/broadcast-hrtimer: Set name of the ce_broadcast_hrtimer (Prarit Bhargava) [1443846]
- [kernel] sched: Transform resched_task() into resched_curr() (Waiman Long) [1418778]
- [kernel] sched/core: Remove false-positive warning from wake_up_process() (Waiman Long) [1436128]
- [iommu] vt-d: Make sure IOMMUs are off when intel_iommu=off (Baoquan He) [1441413]
- [fs] xfs: drop iolock from reclaim context to appease lockdep (Brian Foster) [1441364]
- [fs] xfs: fix eofblocks race with file extending async dio writes (Brian Foster) [1441364]
- [fs] xfs: sync eofblocks scans under iolock are livelock prone (Brian Foster) [1441364]
- [fs] xfs: pull up iolock from xfs_free_eofblocks() (Brian Foster) [1441364]
- [mm] memblock: fix memblock_next_valid_pfn() (Frank Ramsay) [1438940]
- [mm] page_alloc: skip over regions of invalid pfns where possible (Frank Ramsay) [1438940]
- [x86] llvmlinux: Fix "incomplete type const struct x86cpu_device_id" (Ming Lei) [1367596 1437476]
- [x86] xen: do not re-use pirq number cached in pci device msi msg data (Vitaly Kuznetsov) [1433831]
- [x86] kvm: x86: Add MSR_AMD64_DC_CFG to the list of ignored MSRs (Ladi Prosek) [1440025]
- [x86] perf/intel/rapl: Fix module name collision with powercap intel-rapl (David Arcari) [1445833]
- [x86] Mark AMD Naples/Ryzen as unsupported (David Arcari) [1444841]
- [x86] mpx: saving FPU in do_bounds() (Rui Wang) [1443281]
- [x86] mm: fix gup_pte_range() vs DAX mappings (Jeff Moyer) [1443284]
- [x86] mm/gup: Simplify get_user_pages() PTE bit handling (Jeff Moyer) [1443284]
- [x86] revert "mm: Fix gup_huge_p?d() to handle large PAT bit" (Jeff Moyer) [1443284]
- [x86] revert "mm: Simplify get_user_pages() PTE bit handling" (Jeff Moyer) [1443284]
- [x86] revert "mm: fix gup_pte_range() vs DAX mappings" (Jeff Moyer) [1443284]
- [scsi] Avoid that SCSI queues get stuck (Ming Lei) [1441114]
- [scsi] blk-mq: Introduce blk_mq_delay_run_hw_queue() (Ming Lei) [1441114]
- [scsi] qedi: Add PCI device-ID for QL41xxx adapters (Chad Dupuis) [1432622]
- [netdrv] qed: Correct MSI-x for storage (Harish Patil) [1432196]
- [netdrv] qed*: Add support for QL41xxx adapters (Harish Patil) [1432196]
- [netdrv] qedf: fix wrong le16 conversion (Harish Patil) [1432196]
- [netdrv] qed*: Utilize Firmware 8.15.3.0 (Harish Patil) [1432196]
- [netdrv] qed: Don't free a QP more than once (Harish Patil) [1432196]
- [netdrv] be2net: VxLAN offload should be re-enabled when only 1 UDP port is left (Ivan Vecera) [1427258]

* Thu Apr 27 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-659.el7]
- [virtio] virtio_balloon: prevent uninitialized variable use (David Hildenbrand) [1439570]
- [virtio] virtio-balloon: use actual number of stats for stats queue buffers (David Hildenbrand) [1439570]
- [virtio] virtio_balloon: init 1st buffer in stats vq (David Hildenbrand) [1439570]
- [virtio] update balloon size in balloon "probe" (David Hildenbrand) [1439570]
- [virtio] virtio_balloon: Allow to resize and update the balloon stats in parallel (David Hildenbrand) [1439570]
- [virtio] virtio_balloon: Use a workqueue instead of "vballoon" kthread (David Hildenbrand) [1439570]
- [virtio] virtio-balloon: do not call blocking ops when !TASK_RUNNING (David Hildenbrand) [1439570]
- [netdrv] e1000e: fix timing for 82579 Gigabit Ethernet controller (Jarod Wilson) [1442918 1383529]
- [netdrv] revert "e1000e: driver trying to free already-free irq" (Jarod Wilson) [1442918 1383529]
- [netdrv] sfc: tx ring can only have 2048 entries for all EF10 NICs (Jarod Wilson) [1389480]
- [netdrv] sfc: limit the number of receive queues (Jarod Wilson) [1389480]
- [netdrv] sfc: don't insert mc_list on low-latency firmware if it's too long (Jarod Wilson) [1389480]
- [netdrv] sfc: cleanup a condition in efx_udp_tunnel_del() (Jarod Wilson) [1389480]
- [netdrv] sfc: fix IPID endianness in TSOv2 (Jarod Wilson) [1389480]
- [netdrv] sfc: avoid max() in array size (Jarod Wilson) [1389480]
- [netdrv] sfc: fix "an one" typo instances (Jarod Wilson) [1389480]
- [netdrv] bnx2x: prevent crash when accessing PTP with interface down (Michal Schmidt) [1344743]
- [netdrv] bnx2x: fix possible overrun of VFPF multicast addresses array (Michal Schmidt) [1445814]
- [netdrv] ib/mlx5: Verify that Q counters are supported (Kamal Heib) [1442597]
- [netdrv] mlx5e: Count LRO packets correctly (Kamal Heib) [1440660]
- [netdrv] mlx5e: Count GSO packets correctly (Kamal Heib) [1440660]
- [powerpc] Emulation support for load/store instructions on LE (Bhupesh Sharma) [1436294]
- [powerpc] sstep: Return directly after a failed address_ok() in emulate_step() (Bhupesh Sharma) [1436294]
- [powerpc] sstep: Fix emulation fall-through (Bhupesh Sharma) [1436294]
- [powerpc] sstep: Fix sstep.c compile on powerpcspe (Bhupesh Sharma) [1436294]
- [powerpc] Fix compilation of emulate_step() (Bhupesh Sharma) [1436294]
- [powerpc] Implement emulation of string loads and stores (Bhupesh Sharma) [1436294]
- [powerpc] Emulate icbi, mcrf and conditional-trap instructions (Bhupesh Sharma) [1436294]
- [powerpc] Split out instruction analysis part of emulate_step() (Bhupesh Sharma) [1436294]

* Wed Apr 26 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-658.el7]
- [netdrv] qed: Enable iSCSI Out-of-Order (Harish Patil) [1432632]
- [netdrv] qed: Correct out-of-bound access in OOO history (Harish Patil) [1432632]
- [netdrv] qed: Fix mapping leak on LL2 rx flow (Harish Patil) [1432632]
- [netdrv] qed: Align CIDs according to DORQ requirement (Harish Patil) [1432632]
- [vhost] introduce O(1) vq metadata cache (Wei Xu) [1425127 1283257]
- [vhost] add missing __user annotations (Wei Xu) [1283257 1425127]
- [vhost] make interval tree static inline (Wei Xu) [1283257 1425127]
- [vhost] detect 32 bit integer wrap around (Wei Xu) [1283257 1425127]
- [uapi] vhost: new device IOTLB API (Wei Xu) [1425127 1283257]
- [vhost] convert pre sorted vhost memory array to interval tree (Wei Xu) [1425127 1283257]
- [vhost] introduce vhost memory accessors (Wei Xu) [1425127 1283257]
- [vhost] remove unnecessary forward declarations in vhost.h (Wei Xu) [1283257 1425127]
- [vhost] replace  with & on data path (Wei Xu) [1283257 1425127]
- [uapi] virtio: new feature to detect IOMMU device quirk (Wei Xu) [1425127 1283257]
- [virtio] virtio_pci: Use the DMA API if enabled (Wei Xu) [1283257 1425127]
- [virtio] virtio_mmio: Use the DMA API if enabled (Wei Xu) [1283257 1425127]
- [virtio] Silence uninitialized variable warning (Wei Xu) [1283257 1425127]
- [kernel] virtio: Add improved queue allocation API (Wei Xu) [1283257 1425127]
- [tools] virtio_ring: Support DMA APIs (Wei Xu) [1283257 1425127]
- [virtio] vring: Introduce vring_use_dma_api() (Wei Xu) [1283257 1425127]
- [kernel] s390/dma: Allow per device dma ops (Wei Xu) [1425127 1283257]
- [lib] dma: Provide simple noop dma ops (Wei Xu) [1283257 1425127]
- [fs] ext4: fix an ext3 collapse range regression in xfstests (Lukas Czerner) [1435541]
- [fs] btrfs: Use __u64 in exported linux/btrfs.h (Bill O'Donnell) [1437489]
- [fs] nfs: Fix missing pg_cleanup after nfs_pageio_cond_complete() (Benjamin Coddington) [1358574]
- [fs] pnfs: return status from nfs4_pnfs_ds_connect (Benjamin Coddington) [1350261]
- [fs] lockd: Introduce nlmclnt_operations (Benjamin Coddington) [1240357]
- [fs] nfs: Add an iocounter wait function for async RPC tasks (Benjamin Coddington) [1240357]
- [fs] nfs: Use wait_on_atomic_t() for unlock after readahead (Benjamin Coddington) [1240357]
- [fs] locks: Set FL_CLOSE when removing flock locks on close() (Benjamin Coddington) [1240357]
- [fs] nfs: Move the flock open mode check into nfs_flock() (Benjamin Coddington) [1240357]
- [fs] nfs4: remove a redundant lock range check (Benjamin Coddington) [1240357]
- [fs] sunrpc: don't pass on-stack memory to sg_set_buf (Benjamin Coddington) [1346106]
- [fs] nfs: Fix old dentry rehash after move (Benjamin Coddington) [1349647]
- [fs] locks: allow __break_lease to sleep even when break_time is 0 ("J. Bruce Fields") [1088012]
- [fs] nfsd: opt in to labeled nfs per export ("J. Bruce Fields") [1406885]
- [fs] NFSv4.1 fix infinite loop on IO BAD_STATEID error (Steve Dickson) [1437584]
- [fs] NFS prevent double free in async nfs4_exchange_id (Steve Dickson) [1431756]
- [fs] NFSv4.1 respect server's max size in CREATE_SESSION (Steve Dickson) [1431757]
- [fs] nfs: Don't disconnect open-owner on NFS4ERR_BAD_SEQID (Steve Dickson) [1431755]
- [fs] nfs: fix the fault nrequests decreasing for nfs_inode COPY (Steve Dickson) [1436301]
- [fs] sunrpc, nfs: Add and use dprintk_cont macros (Steve Dickson) [1436301]
- [fs] vfs: guard end of device for mpage interface (Ming Lei) [1309318]
- [fs] vfs: make guard_bh_eod() more generic (Ming Lei) [1309318]
- [fs] autofs: dont hold spin lock over direct mount expire (Ian Kent) [1320588]
- [fs] autofs: constify misc struct path instances (Ian Kent) [1320588]
- [fs] autofs: use path_has_submounts() to fix unreliable have_submount() checks (Ian Kent) [1320588]
- [fs] autofs: use path_is_mountpoint() to fix unreliable d_mountpoint() checks (Ian Kent) [1320588]
- [fs] autofs: change autofs4_wait() to take struct path (Ian Kent) [1320588]
- [fs] autofs: change autofs4_expire_wait()/do_expire_wait() to take struct path (Ian Kent) [1320588]
- [fs] vfs: add path_has_submounts() (Ian Kent) [1320588]
- [fs] vfs: add path_is_mountpoint() helper (Ian Kent) [1320588]
- [fs] vfs: change d_manage() to take a struct path (Ian Kent) [1320588]
- [fs] xfs: handle array index overrun in xfs_dir2_leaf_readbuf() (Carlos Maiolino) [1440860]
- [fs] xfs: use dedicated log worker wq to avoid deadlock with cil wq (Brian Foster) [1422225]
- [fs] xfs: fix bogus space reservation in xfs_iomap_write_allocate (Brian Foster) [1435738]

* Mon Apr 24 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-657.el7]
- [md] dm raid: fix table line argument order in status (Mike Snitzer) [1435020]
- [fs] proc: fix GPF in /proc/$PID/map_files (Carlos Maiolino) [1438001]
- [fs] gfs2: Re-enable fallocate for the rindex (Andrew Price) [1399830]
- [fs] config: enable dlm for ppc64le (Andrew Price) [1429822]
- [fs] configs: enable gfs2 for ppc64le (Andrew Price) [1429830]
- [fs] nfs: Allow getattr to also report readdirplus cache hits (Dave Wysochanski) [1442068]
- [fs] nfs: Be more targeted about readdirplus use when doing lookup/revalidation (Dave Wysochanski) [1442068]
- [fs] nfs: Fix a performance regression in readdir (Dave Wysochanski) [1442068]
- [fs] nfs: tidy up nfs_show_mountd_netid (Steve Dickson) [1395068]
- [fs] pnfs: consolidate the different range intersection tests (Steve Dickson) [1436736]
- [fs] pnfs/flexfiles: Only send layoutstats updates for mirrors that were updated (Steve Dickson) [1436736]
- [fs] pnfs/flexfiles: Don't attempt to send layoutstats if there are no entries (Steve Dickson) [1436736]
- [x86] cpufeature: Enable RING3MWAIT for Knights Mill (Xiaolong Wang) [1387697]
- [x86] cpufeature: Enable RING3MWAIT for Knights Landing (Xiaolong Wang) [1387697]
- [x86] cpufeature: Add RING3MWAIT to CPU features (Xiaolong Wang) [1387697]
- [x86] elf: Add HWCAP2 to expose ring 3 MONITOR/MWAIT (Xiaolong Wang) [1387697]
- [x86] msr: Add MSR_MISC_FEATURE_ENABLES and RING3MWAIT bit (Xiaolong Wang) [1387697]
- [x86] Fix typo preventing msr_set/clear_bit from having an effect (Xiaolong Wang) [1387697]
- [x86] kvm: x86: bump KVM_(SOFT_)MAX_VCPUS to 384 (Radim Krcmar) [1433954]
- [x86] kvm: x86: fix out-of-bounds accesses of rtc_eoi map (Radim Krcmar) [1433954]
- [x86] kvm: x86: bump KVM_MAX_VCPU_ID to 1023 (Radim Krcmar) [1433954]
- [x86] kvm: introduce KVM_MAX_VCPU_ID (Radim Krcmar) [1433954]
- [x86] kvm: fix page struct leak in handle_vmon (Paolo Bonzini) [1417825] {CVE-2017-2596}
- [x86] intel_rdt: Fix the notifier priority crash (Jiri Olsa) [1442204]
- [xen] balloon: Set balloon's initial state to number of existing RAM pages (Vitaly Kuznetsov) [1437309]
- [pci] Avoid output of ioapic probe error (David Arcari) [1377960]
- [scsi] storvsc: remove bogus code to transfer struct scatterlist (Cathy Avery) [1429882]
- [scsi] storvsc: properly handle SRB_ERROR when sense message is present (Cathy Avery) [1429882]
- [scsi] storvsc: use tagged SRB requests if supported by the device (Cathy Avery) [1429882]
- [scsi] storvsc: Enable multi-queue support (Cathy Avery) [1429882]
- [scsi] storvsc: Remove the restriction on max segment size (Cathy Avery) [1429882]
- [gpio] acpi: Return -EPROBE_DEFER if the gpiochip was not found (Gopal Tiwari) [1415450]
- [block] blk-mq: don't complete un-started request in timeout handler (Ming Lei) [1429353]
- [kernel] compiler-gcc: integrate the various compiler-gcc[345].h files (Rafael Aquini) [1367596]
- [kernel] compiler-gcc.h: neatening (Rafael Aquini) [1367596]
- [kernel] lib: make memzero_explicit more robust against dead store elimination (Rafael Aquini) [1367596]
- [kernel] lib: memzero_explicit: use barrier instead of OPTIMIZER_HIDE_VAR (Rafael Aquini) [1367596]
- [kernel] compiler: introduce __alias(symbol) shortcut (Rafael Aquini) [1367596]
- [kernel] compiler-intel.h: Remove duplicate definition (Rafael Aquini) [1367596]
- [powerpc] mm: Add missing global TLB invalidate if cxl is active (Steve Best) [1440776]

* Thu Apr 20 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-656.el7]
- [documentation] ipvs: Document sysctl pmtu_disc (Hangbin Liu) [1415642]
- [documentation] ipvs: Document sysctl sync_ports (Hangbin Liu) [1415642]
- [documentation] ipvs: Document sysctl sync_qlen_max and sync_sock_size (Hangbin Liu) [1415642]
- [documentation] ipvs: fix sync_threshold description and add sync_refresh_period, sync_retries (Hangbin Liu) [1415642]
- [net] neigh: do not modify unlinked entries (Jakub Sitnicki) [1389292]
- [net] revert "tcp: fix the timid additive increase on stretch ACKs" (Hannes Frederic Sowa) [1418870]
- [net] revert "tcp: fix stretch ACK bugs in Reno" (Hannes Frederic Sowa) [1418870]
- [net] revert "tcp: fix tcp_cong_avoid_ai() credit accumulation bug with decreases in w" (Hannes Frederic Sowa) [1418870]
- [netdrv] macvtap: fix use after free for skb_array during release (Wei Xu) [1414006]
- [netdrv] macvtap: correctly free skb during socket destruction (Wei Xu) [1414006]
- [netdrv] macvtap: switch to use skb array (Wei Xu) [1414006]
- [netdrv] macvtap: Do not double-count received packets (Wei Xu) [1414006]
- [netdrv] macvlan: fix leak in macvlan_handle_frame (Wei Xu) [1414006]
- [net] tun: remove unnecessary sk_receive_queue (Wei Xu) [1352741]
- [net] tun: Don't assume type tun in tun_device_event (Wei Xu) [1352741]
- [net] tun: fix build warnings (Wei Xu) [1352741]
- [net] tun: switch to use skb array for tx (Wei Xu) [1352741]
- [net] introduce NETDEV_CHANGE_TX_QUEUE_LEN (Wei Xu) [1352741]
- [net] ptr_ring: fix race conditions when resizing (Wei Xu) [1352741]
- [net] skb_array: add wrappers for resizing (Wei Xu) [1352741]
- [net] ptr_ring: support resizing multiple queues (Wei Xu) [1352741]
- [net] skb_array: minor tweak (Wei Xu) [1352741]
- [net] ptr_ring: support zero length ring (Wei Xu) [1352741]
- [net] skb_array: resize support (Wei Xu) [1352741]
- [net] ptr_ring: resize support (Wei Xu) [1352741]
- [net] skb_array: array based FIFO for skbs (Wei Xu) [1352741]
- [net] ptr_ring: array based FIFO for pointers (Wei Xu) [1352741]
- [net] packet: fix overflow in check for tp_reserve (Hangbin Liu) [1441172] {CVE-2017-7308}
- [net] packet: fix overflow in check for tp_frame_nr (Hangbin Liu) [1441172] {CVE-2017-7308}
- [net] packet: fix overflow in check for priv area size (Hangbin Liu) [1441172] {CVE-2017-7308}
- [net] tcp: minimize false-positives on TCP/GRO check (Marcelo Leitner) [1438309]
- [net] audit: normalize NETFILTER_PKT (Richard Guy Briggs) [1382494]
- [net] netfilter: use consistent ipv4 network offset in xt_AUDIT (Richard Guy Briggs) [1382494]
- [net] netfilter: Convert uses of __constant_<foo> to <foo> (Richard Guy Briggs) [1382494]

* Tue Apr 18 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-655.el7]
- [scsi] sg: check length passed to SG_NEXT_CMD_LEN ("Ewan D. Milne") [1439047] {CVE-2017-7187}
- [scsi] ipr: do not set DID_PASSTHROUGH on CHECK CONDITION (Steve Best) [1441747]
- [scsi] storvsc: Support manual scan of FC hosts on Hyper-V (Cathy Avery) [1425469]
- [fs] proc/kcore: update physical address for kcore ram and text (Pratyush Anand) [1419888]
- [pci] pciehp: Leave power indicator on when enabling already-enabled slot (Myron Stowe) [1435818]
- [pci] pciehp: Prioritize data-link event over presence detect (Myron Stowe) [1435818]
- [pci] cpqphp: Add missing call to pci_disable_device() (Myron Stowe) [1435818]
- [pci] pciehp: Remove useless pciehp_get_latch_status() calls (Myron Stowe) [1435818]
- [pci] pciehp: Clean up dmesg "Slot(s)" messages (Myron Stowe) [1435818]
- [pci] pciehp: Remove unnecessary guard (Myron Stowe) [1435818]
- [pci] pciehp: Don't re-read Slot Status when handling surprise event (Myron Stowe) [1435818]
- [pci] pciehp: Don't re-read Slot Status when queuing hotplug event (Myron Stowe) [1435818]
- [pci] pciehp: Process all hotplug events before looking for new ones (Myron Stowe) [1435818]
- [pci] pciehp: Return IRQ_NONE when we can't read interrupt status (Myron Stowe) [1435818]
- [pci] pciehp: Rename pcie_isr() locals for clarity (Myron Stowe) [1435818]
- [pci] Fix all whitespace issues (Myron Stowe) [1435818]
- [pci] pciehp: Always protect pciehp_disable_slot() with hotplug mutex (Myron Stowe) [1435818]
- [netdrv] bonding: handle link transition from FAIL to UP correctly (Jarod Wilson) [1412921]
- [netdrv] bonding: attempt to better support longer hw addresses (Jarod Wilson) [1412921]
- [netdrv] bonding: fix active-backup transition (Jarod Wilson) [1412921]
- [netdrv] bonding: refine bond_fold_stats() wrap detection (Jarod Wilson) [1412921]
- [netdrv] bonding: avoid printing while holding a spinlock (Jarod Wilson) [1412921]
- [netdrv] bonding: correctly update link status during mii-commit phase (Jarod Wilson) [1412921]
- [netdrv] bonding: make speed, duplex setting consistent with link state (Jarod Wilson) [1412921]
- [netdrv] bonding: improve link-status update in mii-monitoring (Jarod Wilson) [1412921]
- [netdrv] bonding: split bond_set_slave_link_state into two parts (Jarod Wilson) [1412921]
- [netdrv] bonding: reduce scope of some global variables (Jarod Wilson) [1412921]
- [netdrv] bonding: remove "port-moved" state that was never implemented (Jarod Wilson) [1412921]
- [netdrv] bonding: remove hardcoded value (Jarod Wilson) [1412921]
- [netdrv] bonding: Remove unnecessary returned value check (Jarod Wilson) [1412921]
- [netdrv] bonding: quit messing with IOCTL (Jarod Wilson) [1412921]
- [netdrv] bonding: Fix bonding crash (Jarod Wilson) [1412921]
- [netdrv] bonding: fix the typo (Jarod Wilson) [1412921]
- [netdrv] bonding: Enforce active-backup policy for IPoIB bonds (Jarod Wilson) [1412921]
- [kernel] uapi: Fix exposed undefined u32 and u64 types to userland through /usr/include/linux/md_p.h (Rafael Aquini) [1443158]
- [powerpc] mm: Use appropriate ESID mask in copro_calculate_slb() (Gustavo Duarte) [1437942]

* Mon Apr 17 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-654.el7]
- [kernel] x86/e820: Don't merge consecutive E820_PRAM ranges (Jeff Moyer) [1351098]
- [kernel] x86/boot: Fix kdump, cleanup aborted E820_PRAM max_pfn manipulation (Jeff Moyer) [1351098]
- [kernel] scripts/sortextable: support objects with more than 64K sections (Joe Lawrence) [1440222]
- [kernel] sched/idle: Add missing checks to the exit condition of cpu_idle_poll() (Gustavo Duarte) [1437869]
- [md] raid5-ppl: runtime PPL enabling or disabling (Nigel Croxon) [1434872]
- [md] raid5-ppl: support disk hot add/remove with PPL (Nigel Croxon) [1434872]
- [md] raid5-ppl: load and recover the log (Nigel Croxon) [1434872]
- [md] add sysfs entries for PPL (Nigel Croxon) [1434872]
- [md] raid5-ppl: Partial Parity Log write logging implementation (Nigel Croxon) [1434872]
- [md] raid5: separate header for log functions (Nigel Croxon) [1434872]
- [md] superblock changes for PPL (Nigel Croxon) [1434872]
- [x86] mm: fix gup_pte_range() vs DAX mappings (Jeff Moyer) [1436283]
- [x86] mm: Simplify get_user_pages() PTE bit handling (Jeff Moyer) [1436283]
- [x86] mm: Fix gup_huge_p?d() to handle large PAT bit (Jeff Moyer) [1436283]
- [x86] Mark Intel Knights Mill processor as supported (Steve Best) [1381298]
- [x86] kvm: x86: Add AVX512_4VNNIW and AVX512_4FMAPS support (Paul Lai) [1382116]
- [x86] cpuid: Provide get_scattered_cpuid_leaf() (Paul Lai) [1382116]
- [x86] cpuid: Cleanup cpuid_regs definitions (Paul Lai) [1382116]
- [x86] cpufeature: Add AVX512_4VNNIW and AVX512_4FMAPS features (Paul Lai) [1382116 1380821]
- [x86] smpboot: Prevent false positive out of bounds cpumask access warning (Baoquan He) [1440629]
- [hid] hid-wacom: support 27QHDT using the new driver (Aristeu Rozanski) [1391668]
- [scsi] ses: don't get power status of SES device slot on probe (Gustavo Duarte) [1434768]
- [char] tpm_tis_spi: Add small delay after last transfer (Jerry Snitselaar) [1385571]
- [char] tpm_tis_spi: Remove limitation of transfers to MAX_SPI_FRAMESIZE bytes (Jerry Snitselaar) [1385571]
- [char] tpm_tis_spi: Check correct byte for wait state indicator (Jerry Snitselaar) [1385571]
- [char] tpm_tis_spi: Abort transfer when too many wait states are signaled (Jerry Snitselaar) [1385571]
- [char] tpm_tis_spi: Use single function to transfer data (Jerry Snitselaar) [1385571]
- [block] nvme: Complete all stuck requests (David Milburn) [1439623]
- [block] blk-mq: Provide freeze queue timeout (David Milburn) [1439623]
- [block] blk-mq: Export blk_mq_freeze_queue_wait (David Milburn) [1439623]
- [netdrv] mlx5: Increase number of max QPs in default profile (Kamal Heib) [1436238]
- [netdrv] i40e: only register client on iWarp-capable devices (Stefan Assmann) [1437246]
- [netdrv] i40e: close client on remove and shutdown (Stefan Assmann) [1429866]
- [netdrv] i40e: register existing client on probe (Stefan Assmann) [1429866]
- [netdrv] i40e: remove client instance on driver unload (Stefan Assmann) [1429866]
- [netdrv] i40e: fix RSS queues only operating on PF0 (Stefan Assmann) [1429866]
- [netdrv] i40e: initialize params before notifying of l2_param_changes (Stefan Assmann) [1429866]
- [netdrv] i40e: KISS the client interface (Stefan Assmann) [1429866]
- [netdrv] i40e: fix up recent proxy and wol bits for X722_SUPPORT (Stefan Assmann) [1429866]
- [netdrv] i40e: Acquire NVM lock before reads on all devices (Stefan Assmann) [1429866]
- [netdrv] i40e: Do not enable NAPI on q_vectors that have no rings (Stefan Assmann) [1429866]
- [infiniband] i40iw: Receive netdev events post INET_NOTIFIER state (Stefan Assmann) [1429866]
- [powerpc] prom: Increase minimum RMA size to 512MB (Gustavo Duarte) [1411321]

* Fri Apr 14 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-653.el7]
- [scsi] qla2xxx: Turn ql2xmqsupport off by default (Himanshu Madhani) [1441782]
- [scsi] lpfc: code cleanups in NVME initiator base (Ewan Milne) [1384922]
- [scsi] lpfc: Mark NVMe and NVMe Target support as tech preview (Ewan Milne) [1384922]
- [nvme] nvme_fc: avoid double kfree(), don't call nvme_cleanup_cmd() in nvme_fc_unmap_data() (Ewan Milne) [1384922]
- [nvme] nvme-fc: add .map_queue entry to blk_mq_ops (Ewan Milne) [1384922]
- [nvme] nvme_fc: add controller reset support (Ewan Milne) [1384922]
- [nvme] nvme_fc: add aen abort to teardown (Ewan Milne) [1384922]
- [nvme] nvme_fc: fix command id check (Ewan Milne) [1384922]
- [nvme] nvme_fc: Add ls aborts on remote port teardown (Ewan Milne) [1384922]
- [nvme] nvme_fc: Move LS's to rport (Ewan Milne) [1384922]
- [nvme] nvmet_fc: add missing reference in add_port (Ewan Milne) [1384922]
- [nvme] nvmet_fc: Rework target side abort handling (Ewan Milne) [1384922]
- [nvme] nvme_fcloop: split job struct from transport for req_release (Ewan Milne) [1384922]
- [nvme] nvmet_fc: add req_release to lldd api (Ewan Milne) [1384922]
- [nvme] nvmet_fc: add target feature flags for upcall isr contexts (Ewan Milne) [1384922]
- [nvme] nvme_fc: Clean up host fcpio done status handling (Ewan Milne) [1384922]
- [nvme] nvmet_fc: Clear SG list to avoid double frees (Ewan Milne) [1384922]
- [nvme] nvme_fc: correct LS validation (Ewan Milne) [1384922]
- [nvme] nvmet_fc: Sync NVME LS reject reasons with spec (Ewan Milne) [1384922]
- [nvme] nvme_fc: Add check of status_code in ERSP_IU (Ewan Milne) [1384922]
- [nvme] nvme_fc: Sync FC-NVME header with standard (Ewan Milne) [1384922]
- [nvme] nvme-fc: don't bother to validate ioccsz and iorcsz (Ewan Milne) [1384922]
- [nvme] nvmet_fc: cleanup of abort flag processing in fcp_op_done (Ewan Milne) [1384922]
- [scsi] lpfc version bump for nvme to 11.2.0.11 (Ewan Milne) [1384922]
- [scsi] lpfc: The lpfc driver does not issue RFF_ID and RFT_ID in the correct sequence (Ewan Milne) [1384922]
- [scsi] lpfc: Finalize Kconfig options for nvme (Ewan Milne) [1384922]
- [scsi] lpfc: Rework lpfc Kconfig for NVME options (Ewan Milne) [1384922]
- [scsi] lpfc: add missing Kconfig NVME dependencies (Ewan Milne) [1384922]
- [scsi] lpfc: replace init_timer by setup_timer (Ewan Milne) [1384922]
- [scsi] lpfc: Fix eh_deadline setting for sli3 adapters (Ewan Milne) [1384922]
- [scsi] lpfc: code cleanups in NVME initiator discovery (Ewan Milne) [1384922]
- [scsi] lpfc: correct rdp diag portnames (Ewan Milne) [1384922]
- [scsi] lpfc: remove dead sli3 nvme code (Ewan Milne) [1384922]
- [scsi] lpfc: correct double print (Ewan Milne) [1384922]
- [scsi] lpfc: Rename LPFC_MAX_EQ_DELAY to LPFC_MAX_EQ_DELAY_EQID_CNT (Ewan Milne) [1384922]
- [scsi] lpfc: add NVME exchange aborts (Ewan Milne) [1384922]
- [scsi] lpfc: Fix nvme allocation bug on failed nvme_fc_register_localport (Ewan Milne) [1384922]
- [scsi] lpfc: Fix IO submission if WQ is full (Ewan Milne) [1384922]
- [scsi] lpfc: Fix NVME CMD IU byte swapped word 1 problem (Ewan Milne) [1384922]
- [scsi] lpfc: Fix RCTL value on NVME LS request and response (Ewan Milne) [1384922]
- [scsi] lpfc: Fix crash during Hardware error recovery on SLI3 adapters (Ewan Milne) [1384922]
- [scsi] lpfc: fix missing spin_unlock on sql_list_lock (Ewan Milne) [1384922]
- [scsi] lpfc: don't dereference dma_buf-&gt; iocbq before null check (Ewan Milne) [1384922]
- [scsi] lpfc: sanity check hrq is null before dereferencing it (Ewan Milne) [1384922]
- [scsi] lpfc: remove redundant assignment of sgel (Ewan Milne) [1384922]
- [scsi] Update lpfc version to 11.2.0.8 with NVME support (Ewan Milne) [1384922]
- [scsi] lpfc: Update copyrights (Ewan Milne) [1384922]
- [scsi] lpfc: NVME Target: Add debugfs support (Ewan Milne) [1384922]
- [scsi] lpfc: NVME Target: bind to nvmet_fc api (Ewan Milne) [1384922]
- [scsi] lpfc: NVME Target: Merge into FC discovery (Ewan Milne) [1384922]
- [scsi] lpfc: NVME Target: Receive buffer updates (Ewan Milne) [1384922]
- [scsi] lpfc: NVME Target: Base modifications (Ewan Milne) [1384922]
- [scsi] lpfc: NVME Initiator: Add debugfs support (Ewan Milne) [1384922]
- [scsi] lpfc: NVME Initiator: bind to nvme_fc api (Ewan Milne) [1384922]
- [scsi] lpfc: NVME Initiator: Merge into FC discovery (Ewan Milne) [1384922]
- [scsi] lpfc: NVME Initiator: Base modifications (Ewan Milne) [1384922]
- [scsi] lpfc: refactor debugfs queue dump routines (Ewan Milne) [1384922]
- [scsi] lpfc: refactor debugfs queue prints (Ewan Milne) [1384922]
- [scsi] lpfc: minor code cleanups (Ewan Milne) [1384922]
- [scsi] lpfc: Correct WQ creation for pagesize (Ewan Milne) [1384922]
- [scsi] lpfc: Revert: Fix eh_deadline setting for sli3 adapters (Ewan Milne) [1384922]

* Thu Apr 13 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-652.el7]
- [gpu] drm/ast: Handle configuration without P2A bridge (Rob Clark) [1422342 1415055 1351050 1406119]
- [gpu] drm/vmwgfx: Work around drm removal of control nodes (Rob Clark) [1425111 1406119]
- [video] efifb: prevent null-deref when iterating dmi_list (Rob Clark) [1358107 1406119]
- [kernel] pm / sleep: add configurable delay for pm_test (Rob Clark) [1406119]
- [gpu] drm/mgag200: Added support for the new device G200eH3 (Rob Clark) [1385845 1385100 1406119]
- [documentation] rhel: remove drm from DocBook build (Rob Clark) [1406119]
- [drm] upstream sync to v4.10 (Rob Clark) [1390444 1390443 1330441 1330436 1310324 1406119 1386946 1385880 1385851 1385820 1385760 1385757 1384392 1380814 1377723 1373255 1339127 1305619 1211380]
- [acpi] acpi / video: Fix lockdep issue (Rob Clark) [1406119]
- [kernel] virtio: make find_vqs() checkpatch.pl-friendly (Rob Clark) [1406119]
- [kernel] sched: Export sched_setscheduler_nocheck (Rob Clark) [1406119]
- [kernel] relay: add global mode support for buffer-only channels (Rob Clark) [1406119]
- [kernel] kthread: export kthread functions (Rob Clark) [1406119]
- [x86] locking/atomic, arch/x86: Implement atomic{, 64}_fetch_{add, sub, and, or, xor}() (Rob Clark) [1406119]
- [sound] drm/i915/dp: DP audio API changes for MST (Rob Clark) [1406119]
- [x86] drm/i915: Remove .is_mobile field from platform struct (Rob Clark) [1406119]
- [x86] drm/i915: Account for TSEG size when determining 865G stolen base (Rob Clark) [1406119]
- [x86] Silence 32bit compiler warning in intel_graphics_stolen() (Rob Clark) [1406119]
- [x86] drm/i915: Function per early graphics quirk (Rob Clark) [1406119]
- [x86] drm/i915: Canonicalize stolen memory calculations (Rob Clark) [1406119]
- [x86] Provide atomic_{or,xor,and} (Rob Clark) [1406119]
- [x86] Force inlining of atomic ops (Rob Clark) [1406119]
- [x86] asm: Always inline atomics (Rob Clark) [1406119]
- [asm-generic] locking, arch: Use ACCESS_ONCE() instead of cast to volatile in atomic_read() (Rob Clark) [1406119]
- [x86] locking,x86: Kill atomic_or_long() (Rob Clark) [1406119]
- [kernel] kernel.h: add u64_to_user_ptr() (Rob Clark) [1406119]
- [kernel] io-mapping: Fixup for different names of writecombine (Rob Clark) [1406119]
- [kernel] io-mapping.h: s/PAGE_KERNEL_IO/PAGE_KERNEL/ (Rob Clark) [1406119]
- [kernel] io-mapping: Always create a struct to hold metadata about the io-mapping (Rob Clark) [1406119]
- [kernel] io-mapping: Specify mapping size for io_mapping_map_wc() (Rob Clark) [1406119]
- [kernel] rcu: Add rcu_pointer_handoff() (Rob Clark) [1406119]

* Thu Apr 13 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-651.el7]
- [netdrv] mlxsw: spectrum_flower: Remove bogus warns in mlxsw_sp_flower_destroy (Ivan Vecera) [1434591]
- [netdrv] mlxsw: acl: Use PBS type for forward action (Ivan Vecera) [1434591]
- [netdrv] spectrum: flower: Treat ETH_P_ALL as a special case and translate for HW (Ivan Vecera) [1434591]
- [netdrv] mlxsw: acl: Fix mlxsw_afa_block_commit error path (Ivan Vecera) [1434591]
- [netdrv] spectrum: acl_tcam: Fix catchall prio value (Ivan Vecera) [1434591]
- [netdrv] mlxsw: spectrum: Implement TC flower offload (Ivan Vecera) [1434591]
- [netdrv] mlxsw: spectrum: Introduce ACL core with simple TCAM implementation (Ivan Vecera) [1434591]
- [netdrv] mlxsw: resources: Add ACL related resources (Ivan Vecera) [1434591]
- [netdrv] mlxsw: spectrum: Introduce basic set of flexible key blocks (Ivan Vecera) [1434591]
- [netdrv] mlxsw: core: Introduce flexible actions support (Ivan Vecera) [1434591]
- [netdrv] mlxsw: core: Introduce flexible keys support (Ivan Vecera) [1434591]
- [kernel] include/linux/rwsem.h: add '<linux/err.h>' include (Ivan Vecera) [1434591]
- [netdrv] mlxsw: reg: Add Policy-Engine Extended Flexible Action Register (Ivan Vecera) [1434591]
- [netdrv] mlxsw: reg: Add Policy-Engine Policy Based Switching Register (Ivan Vecera) [1434591]
- [netdrv] mlxsw: reg: Add Policy-Engine Rules Copy Register (Ivan Vecera) [1434591]
- [netdrv] mlxsw: reg: Add Policy-Engine Port Binding Table (Ivan Vecera) [1434591]
- [netdrv] mlxsw: reg: Add Policy-Engine TCAM Entry Register Version 2 (Ivan Vecera) [1434591]
- [netdrv] mlxsw: reg: Add Policy-Engine TCAM Allocation Register (Ivan Vecera) [1434591]
- [netdrv] mlxsw: reg: Add Policy-Engine ACL Group Table register (Ivan Vecera) [1434591]
- [netdrv] mlxsw: reg: Add Policy-Engine ACL Register (Ivan Vecera) [1434591]
- [netdrv] mlxsw: item: Add helpers for getting pointer into payload for char buffer item (Ivan Vecera) [1434591]
- [netdrv] mlxsw: item: Add 8bit item helpers (Ivan Vecera) [1434591]
- [netdrv] mlxsw: spectrum_router: Add support for route replace (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Add support for route append (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Correctly handle identical routes (Ivan Vecera) [1434587]
- [net] ipv4: fib: Add events for FIB replace and append (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Don't reflect LINKDOWN nexthops (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Flush resources when RIF is deleted (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Reflect nexthop status changes (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Use trap action only for some route types (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Determine offload status using generic function (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: More accurately set offload flag (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Refactor nexthop init routine (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Remove FIB info from FIB entry struct (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Store routes in a more generic way (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Add gateway indication to nexthop group (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Use nexthop's scope to set action type (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Store nexthops in a hash table (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Store nexthop groups in a hash table (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Nullify nexthop's neigh pointer (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Fix typo in comment (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Don't read 'nud_state' without lock (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Remove redundant check (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Simplify neighbour reflection (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum_router: Use ordered workqueue for neigh updates (Ivan Vecera) [1434587]
- [netdrv] mlxsw: core: Queue work immediately instead of delaying it (Ivan Vecera) [1434587]
- [netdrv] mlxsw: pci: Fix EQE structure definition (Ivan Vecera) [1434587]
- [netdrv] mlxsw: switchx2: Fix memory leak at skb reallocation (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum: Fix memory leak at skb reallocation (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum: Change ENOTSUPP to EOPNOTSUPP (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum: Fix order of commands in port remove function (Ivan Vecera) [1434587]
- [netdrv] mlxsw: spectrum: Make the add_matchall_tc_entry symmetric (Ivan Vecera) [1434587]

* Wed Apr 12 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-650.el7]
- [net] sctp: get sock from transport in sctp_transport_update_pmtu (Xin Long) [1412865]
- [net] sctp: check for dst and pathmtu update in sctp_packet_config (Xin Long) [1412865]
- [net] sctp: remove return value from sctp_packet_init/config (Xin Long) [1412865]
- [net] revert "inet: frag: remove hash size assumptions from callers" (David Arcari) [1431878]
- [scsi] qla2xxx: Update driver version to 8.07.00.38.07.4-k1 (Himanshu Madhani) [1436940]
- [scsi] qla2xxx: Defer marking device lost when receiving an RSCN (Himanshu Madhani) [1436940]
- [scsi] qla2xxx: Fix typo in driver (Himanshu Madhani) [1436940]
- [scsi] qla2xxx: Fix crash in qla2xxx_eh_abort on bad ptr (Himanshu Madhani) [1436940]
- [scsi] qla2xxx: Avoid that issuing a LIP triggers a kernel crash (Himanshu Madhani) [1436940]
- [scsi] qla2xxx: Add fix to read correct register value for ISP82xx (Himanshu Madhani) [1436940]
- [scsi] qla2xxx: Disable the adapter and skip error recovery in case of register disconnect (Himanshu Madhani) [1436940]
- [scsi] ses: Fix SAS device detection in enclosure (Maurizio Lombardi) [1394089]
- [scsi] lpfc: Make default for lpfc_use_blk_mq to off (Ewan Milne) [1438933]
- [scsi] hpsa: cleanup PCI IDs in hpsa driver (Joseph Szczypek) [1433008]
- [scsi] storvsc: Workaround for virtual DVD SCSI version (Cathy Avery) [1437552]
- [scsi] drivers: add blist flags (Cathy Avery) [1437552]
- [iommu] vt-d: fix range computation when making room for large pages (Alex Williamson) [1435612]
- [target] replace ALUA transition wait/flush with mutex (Mike Christie) [1429008 1407016]
- [target] tcmu: Allow cmd_time_out to be set to zero (disabled) (Mike Christie) [1429008 1407016]
- [target] fix race during implicit transition work flushes (Mike Christie) [1429008 1407016]
- [target] allow userspace to set state to transitioning (Mike Christie) [1429008 1407016]
- [target] fix ALUA transition timeout handling (Mike Christie) [1429008 1407016]
- [target] export protocol identifier (Mike Christie) [1429008 1407016]
- [target] Use system workqueue for ALUA transitions (Mike Christie) [1429008 1407016]
- [target] fail ALUA transitions for pscsi (Mike Christie) [1429008 1407016]
- [target] allow ALUA setup for some passthrough backends (Mike Christie) [1429008 1407016]
- [target] Use a PASSTHROUGH flag instead of transport_types (Mike Christie) [1429008 1407016]
- [target] user: Fix use-after-free of tcmu_cmds if they are expired (Mike Christie) [1429008 1407016]
- [target] tcmu: Convert cmd_time_out into backend device attribute (Mike Christie) [1429008 1407016]
- [target] tcmu: make cmd timeout configurable (Mike Christie) [1429008 1407016]
- [target] tcmu: add helper to check if dev was configured (Mike Christie) [1429008 1407016]
- [target] tcmu: return on first Opt parse failure (Mike Christie) [1429008 1407016]
- [target] tcmu: allow hw_max_sectors greater than 128 (Mike Christie) [1429008 1407016]
- [infiniband] ib/mlx5: Support creation of a WQ with scatter FCS offload (Kamal Heib) [1409510]
- [infiniband] ib/mlx5: Enable QP creation with cvlan offload (Kamal Heib) [1409510]
- [infiniband] ib/mlx5: Enable WQ creation and modification with cvlan offload (Kamal Heib) [1409510]
- [infiniband] ib/mlx5: Expose vlan offloads capabilities (Kamal Heib) [1409510]
- [infiniband] ib/uverbs: Enable QP creation with cvlan offload (Kamal Heib) [1409510]
- [uapi] ib/uverbs: Enable WQ creation and modification with cvlan offload (Kamal Heib) [1409510]
- [uapi] ib/uverbs: Expose vlan offloads capabilities (Kamal Heib) [1409510]
- [rdma] ib/core: Add scatter FCS flag to use in WQ creation (Kamal Heib) [1409510]
- [rdma] ib/core: Enable QP creation with cvlan offload (Kamal Heib) [1409510]
- [rdma] ib/core: Enable WQ creation and modification with cvlan offload (Kamal Heib) [1409510]
- [rdma] ib/core: Expose vlan offloads capabilities (Kamal Heib) [1409510]
- [netdrv] mlx4: reduce OOM risk on arches with large pages (Kamal Heib) [1438409]
- [netdrv] ib/mlx4: Take source GID by index from HW GID table (Kamal Heib) [1438404]
- [netdrv] mlx4_en: fix overflow in mlx4_en_init_timestamp() (Kamal Heib) [1438400]
- [netdrv] mlx4_core: Fix VF overwrite of module param which disables DMFS on new probed PFs (Kamal Heib) [1438385]
- [netdrv] mlx4: && vs & typo (Kamal Heib) [1438373]
- [netdrv] mlx4: Spoofcheck and zero MAC can't coexist (Kamal Heib) [1438373]
- [netdrv] mlx4_core: Avoid delays during VF driver device shutdown (Kamal Heib) [1438365]
- [powerpc] Add ppc64 hard lockup detector support (Gustavo Duarte) [1226123]
- [powerpc] oprofile: Disable oprofile NMI timer on ppc64 (Gustavo Duarte) [1226123]
- [powerpc] boot: Fix zImage TOC alignment (Gustavo Duarte) [1395838]
- [powerpc] pseries: Don't give a warning when HPT resizing isn't available (David Gibson) [1431922]

* Wed Apr 12 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-649.el7]
- [netdrv] mlxsw: spectrum_router: Avoid potential packets loss (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Remove unused variable (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Correctly reallocate adjacency entries (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Correctly remove nexthop groups (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Mark split ports as such (Ivan Vecera) [1414400]
- [net] ipv4: fib: Replay events when registering FIB notifier (Ivan Vecera) [1414400]
- [netdrv] rocker: Register FIB notifier before creating ports (Ivan Vecera) [1414400]
- [netdrv] rocker: Implement FIB offload in deferred work (Ivan Vecera) [1414400]
- [netdrv] rocker: Create an ordered workqueue for FIB offload (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Implement FIB offload in deferred work (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Create an ordered workqueue for FIB offload (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Don't reflect dead neighs (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Change order of operations in removal path (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Add missing rollback in error path (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_buffers: Limit size of pools (Ivan Vecera) [1414400]
- [netdrv] mlxsw: resources: Add maximum buffer size (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchib: add MLXSW_PCI dependency (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add policers for trap groups (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add QoS Policer Configuration Register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: resources: Add max cpu policers resource (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Create a different trap group list for each device (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add BGP trap (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Change trap groups setting (Ivan Vecera) [1414400]
- [netdrv] mlxsw: resources: Add max trap groups resource (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Change emad trap group settings (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Add option to choose trap group (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Change trap set function (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchib: Use generic listener struct for events (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Use generic listener struct for events (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use generic listener struct for events (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Introduce generic macro for event (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Use generic listener struct for rx traps (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use generic listener struct for rx traps (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Expose generic macros for rx trap (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Create a generic function to register / unregister traps (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Remove unused traps (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Implement thermal zone (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Management Fan Speed Limit register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: minimal: Add I2C support for Mellanox ASICs (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Invoke driver's init/fini methods only if defined (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Introduce support for I2C bus (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Add bus capability flag (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Flush FIB tables during fini (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Add FIB abort warning (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Fix pwm_frequency field size in MFCR register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Correctly dump neighbour activity (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Fix refcount bug on span entries (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Ignore FIB notification events for non-init namespaces (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Fix handling of neighbour structure (Ivan Vecera) [1414400]
- [netdrv] mlxsw: pci: Fix the FW ready mask length (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Remove unused including <generated/utsrelease.h> (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Fix incorrect reuse of MID entries (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchib: Introduce SwitchIB and SwitchIB silicon driver (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Add IB port support (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Add eth prefix to port create and remove (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Add port type (Eth/IB) set API (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Add "eth" prefix to mlxsw_core_port_set (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Add Infiniband switch partition (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Make devlink port instances independent of spectrum/switchx2 port instances (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add local-port to Infiniband port mapping (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Infiniband support to PTYS (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add eth prefix to PTYS pack and unpack (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Fix port speed configuration (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Add support for physical port names (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Move port used check outside port remove function (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Move port used check outside port remove function (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Check if port is usable before calling port create (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Zero payload buffers for couple of registers (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Set physical device for port netdevice (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Set physical device for port netdevice (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Move PCI id table definitions into driver modules (Ivan Vecera) [1414400]
- [netdrv] mlxsw: pci: Rename header with HW definitions (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Remove extra whitespace (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Compare only trees which are in use during tree get (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Save requested prefix bitlist when creating tree (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Convert resources into array (Ivan Vecera) [1414400]
- [netdrv] mlxsw: cmd: Push resource query defines to cmd.h (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Generare register names automatically (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Use helper macro to define registers (Ivan Vecera) [1414400]
- [netdrv] mlxsw: item: Make char *buf arg constant for getters (Ivan Vecera) [1414400]
- [netdrv] mlxsw: item: Make struct mlxsw_item args const (Ivan Vecera) [1414400]
- [netdrv] mlxsw: pci: Fix reset wait for SwitchX2 (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Fix ethernet port initialization (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Make mlxsw_sp_router_fib4_del return void and remove warn (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Use correct tree index for binding (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Flip to the new dev walk API (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Fix misuse of hard_header_len (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Fix misuse of hard_header_len (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: avoid potential uninitialized data usage (Ivan Vecera) [1414400]
- [netdrv] doc: update switchdev L3 section (Ivan Vecera) [1414400]
- [net] switchdev: remove FIB offload infrastructure (Ivan Vecera) [1414400]
- [netdrv] rocker: use FIB notifications instead of switchdev calls (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Use FIB notifications instead of switchdev calls (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: remove redundant check if err is zero (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Implement max rif resource (Ivan Vecera) [1414400]
- [netdrv] mlxsw: pci: Add max router interface resource (Ivan Vecera) [1414400]
- [netdrv] mlxsw: pci: Add some miscellaneous resources (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Implement max virtual routers resource (Ivan Vecera) [1414400]
- [netdrv] mlxsw: pci: Add max virtual routers resource (Ivan Vecera) [1414400]
- [netdrv] mlxsw: profile: Add KVD resources to profile config (Ivan Vecera) [1414400]
- [netdrv] mlxsw: pci: Add KVD size relate resources (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: lag resources- use resources data instead of consts (Ivan Vecera) [1414400]
- [netdrv] mlxsw: pci: Add lag related resources to resources query (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Make offloads stats functions static (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Change the RX LAG hash function from XOR to CRC (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Fix sparse warnings (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Implement offload stats ndo and expose HW stats by default (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add support for new ethtool API (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Indicate support of multiple port types (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Report port type according to operational speed (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Report link partner's advertised speeds (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Correctly report autonegotiation (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Set port type before setting its address (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Fix error path in mlxsw_sp_router_init (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use existing flood setup when adding VLANs (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Don't take multiple references on a FID (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Fix netevent notifier registration (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Fix error path in mlxsw_sp_module_init (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Fix fib entry update path (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Fix failure caused by double fib removal from HW (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Mirror certain packets to CPU (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Allow different traps to have different actions (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Simplify traps definition (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Don't set learning when creating vPorts (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Remove unnecessary check in FDB processing (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Offload learning to the switch ASIC (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Configure learning for VLAN-aware bridge port (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Don't abort on first error when removing VLANs (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Make VLAN deletion function symmetric (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Limit number of FDB records per learning session (Ivan Vecera) [1414400]
- [netdrv] mlxsw: router: Enable neighbors to be created on stacked devices (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add missing flood to router port (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_buffers: Fix pool value handling in mlxsw_sp_sb_tc_pool_bind_set (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Allow packets to be trapped from any PG (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Unmap 802.1Q FID before destroying it (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add missing rollbacks in error path (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Fix missing op field fill-up (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Trap loop-backed packets (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add missing packet traps (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Mark port as active before registering it (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Create PVID vPort before registering netdevice (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Remove redundant errors from the code (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Don't return upon error in removal path (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Fix use after free (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add missing DCB rollback in error path (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Do not override PAUSE settings (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Do not assume PAUSE frames are disabled (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Fix compilation error when CLS_ACT isn't set (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add support in matchall mirror TC offloading (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add the Monitoring Port Analyzer register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Monitoring Port Analyzer Table register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Shared Buffer Internal Buffer register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: pci: Add max span resources to resources query (Ivan Vecera) [1414400]
- [netdrv] mlxsw: pci: Add resources query implementation (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Expose per-tc counters via ethtool (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Expose per-priority counters via ethtool (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Prevent invalid ingress buffer mapping (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Prevent overwrite of DCB capability fields (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Don't emit errors when PFC is disabled (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Indicate support for autonegotiation (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Force link training according to admin state (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Return -ENOENT in case of error (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Trace EMAD messages (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Add the unresolved next-hops probes (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Add the nexthop neigh activity update (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Implement next-hop routing (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Router Algorithmic LPM ECMP Update Register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Router Adjacency Table register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Introduce simplistic KVD linear area manager (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Define sizes of KVD areas (Ivan Vecera) [1414400]
- [netdrv] mlxsw: Add KVD sizes configuration into profile (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Offload neighbours based on NUD state change (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Periodically update the kernel's neigh table (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Router Algorithmic LPM Unicast Host Table Dump register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Router Algorithmic LPM Unicast Host Table register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Add private neigh table (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Enable L3 interfaces on top of bridge devices (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Configure FIDs based on bridge events (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Unsplit the vFID range (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Introduce support for router interfaces (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Edit RIF properties based on netdev events (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add couple of lower device helper functions (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Implement fib4 add/del switchdev obj ops (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Router Algorithmic LPM Unicast Entry Register definition (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Add virtual router management (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Implement LPM trees management (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Router Algorithmic LPM Tree Binding Register definition (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Router Algorithmic LPM Structure Tree Register definition (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Router Algorithmic LPM Tree Allocation Register definition (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Implement private fib (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add traps needed for router implementation (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use action 'discard' when removing traps (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Router Interface Table Register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add FDB action to forward to router (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add router interface struct (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum_router: Add basic ipv4 router initialization (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Initialize ports at the end of init sequence (Ivan Vecera) [1414400]
- [netdrv] mlxsw: reg: Add Router General Configuration Register (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Remove RIF from PVID vPort when joining / leaving LAG (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Sync PVID vPort LAG status (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Remove VLANs configuration via SELF flag (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Send untagged packets through a port netdev (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add debug prints (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Free resources upon vPort destruction (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Refactor FDB flushing logic (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Don't count on FID being present (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Add FID get / set functions (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Check if port is vPort using its VID (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use per-FID struct for the VLAN-aware bridge (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Remove unused function argument (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use join / leave functions for vFID operations (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Make vFID struct generic (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use FID instead of vFID to setup flooding (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Create a function to map vPort's FID (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use only one function to create vFIDs (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Remove redundant function argument (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use DECLARE_BITMAP() macro (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Centralize VLAN-aware bridge ref counting (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Remove unnecessary function argument (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Make unlinking functions return void (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use WARN_ON() return value (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Remove unnecessary checks from event processing (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Forbid LAG slave from having VLAN uppers (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Sanitize port netdev upper devices (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Use notifier_from_errno() in notifier block (Ivan Vecera) [1414400]
- [netdrv] mlxsw: switchx2: Don't count internal TX header bytes to stats (Ivan Vecera) [1414400]
- [netdrv] mlxsw: spectrum: Don't count internal TX header bytes to stats (Ivan Vecera) [1414400]
- [netdrv] mlxsw: core: Remove deprecated create_workqueue (Ivan Vecera) [1414400]

* Mon Apr 10 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-648.el7]
- [x86] intel_rdt: Put group node in rdtgroup_kn_unlock (Jiri Olsa) [1288964]
- [x86] intel_rdt: Remove duplicate inclusion of linux/cpu.h (Jiri Olsa) [1288964]
- [x86] intel_rdt: Implement show_options() for resctrlfs (Jiri Olsa) [1288964]
- [x86] intel_rdt: Call intel_rdt_sched_in() with preemption disabled (Jiri Olsa) [1288964]
- [x86] intel_rdt: Update task closid immediately on CPU in rmdir and unmount (Jiri Olsa) [1288964]
- [x86] intel_rdt: Fix setting of closid when adding CPUs to a group (Jiri Olsa) [1288964]
- [x86] intel_rdt: Update percpu closid immeditately on CPUs affected by changee (Jiri Olsa) [1288964]
- [x86] intel_rdt: Reset per cpu closids on unmount (Jiri Olsa) [1288964]
- [x86] intel_rdt: Prevent deadlock against hotplug lock (Jiri Olsa) [1288964]
- [x86] intel_rdt: Protect info directory from removal (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add info files to Documentation (Jiri Olsa) [1288964]
- [x86] intel_rdt: Export the minimum number of set mask bits in sysfs (Jiri Olsa) [1288964]
- [x86] intel_rdt: Propagate error in rdt_mount() properly (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add a missing #include (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add scheduler hook (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add schemata file (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add tasks files (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add cpus file (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add mkdir to resctrl file system (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add "info" files to resctrl file system (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add basic resctrl filesystem support (Jiri Olsa) [1288964]
- [x86] intel_rdt: Build structures for each resource based on cache topology (Jiri Olsa) [1288964]
- [x86] documentation, x86: Documentation for Intel resource allocation user interface (Jiri Olsa) [1288964]
- [x86] cqm: Share PQR_ASSOC related data between CQM and CAT (Jiri Olsa) [1288964]
- [x86] intel_rdt: Pick up L3/L2 RDT parameters from CPUID (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add Haswell feature discovery (Jiri Olsa) [1288964]
- [x86] intel_rdt: Add CONFIG, Makefile, and basic initialization (Jiri Olsa) [1288964]
- [x86] cpufeature: Add RDT CPUID feature bits (Jiri Olsa) [1288964]
- [x86] cpufeature: Move some of the scattered feature bits to x86_capability (Jiri Olsa) [1288964]
- [x86] intel: Add get_cpu_cache_id function (Jiri Olsa) [1288964]
- [x86] intel_cacheinfo: Enable cache id in cache info (Jiri Olsa) [1288964]
- [x86] cacheinfo: Introduce cache id (Jiri Olsa) [1288964]

* Mon Apr 10 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-647.el7]
- [tty] n_hdlc: get rid of racy n_hdlc.tbuf ("Herton R. Krzesinski") [1429920] {CVE-2017-2636}
- [fs] mnt: Prevent pivot_root from creating a loop in the mount tree (Aristeu Rozanski) [1151483] {CVE-2014-7970}
- [fs] ceph: remove bogus warnings from ceph_releasepage (Jeff Layton) [1428973]
- [fs] ceph: get caps when handling splice() (Jeff Layton) [1428973]
- [fs] jbd2: avoid infinite loop when destroying aborted journal (Lukas Czerner) [1433886]
- [fs] jbd2: fix checkpoint list cleanup (Lukas Czerner) [1433886]
- [fs] jbd2: simplify calling convention around __jbd2_journal_clean_checkpoint_list (Lukas Czerner) [1433886]
- [fs] sunrpc: Silence WARN_ON when NFSv4.1 over RDMA is in use (Sachin Prabhu) [1428039]
- [fs] sunrpc: Don't engage exponential backoff when connection attempt is rejected ("J. Bruce Fields") [1433390]
- [net] ping: implement proper locking (Jakub Sitnicki) [1438998] {CVE-2017-2671}
- [lib] Remove string from parman config selection (Ivan Vecera) [1382040]
- [net] sched: cls_matchall: Reflect HW offloading status (Ivan Vecera) [1382040]
- [net] sched: cls_matchall: Dump the classifier flags (Ivan Vecera) [1382040]
- [net] ipv4: fib: Send notification before deleting FIB alias (Ivan Vecera) [1382040]
- [net] ipv4: fib: Send deletion notification with actual FIB alias type (Ivan Vecera) [1382040]
- [net] ipv4: fib: Notify about nexthop status changes (Ivan Vecera) [1382040]
- [lib] Introduce priority array area manager (Ivan Vecera) [1382040]
- [kernel] list: introduce list_for_each_entry_from_reverse helper (Ivan Vecera) [1382040]
- [net] sched: tc_mirred: Rename public predicates 'is_tcf_mirred_redirect' and 'is_tcf_mirred_mirror' (Ivan Vecera) [1382040]
- [net] ipv4: fix value of ->nlmsg_flags reported in RTM_NEWROUTE events (Ivan Vecera) [1382040]
- [net] ipv4: include NLM_F_APPEND flag in append route notifications (Ivan Vecera) [1382040]
- [net] for rate-limited ICMP replies save one atomic operation (Sabrina Dubroca) [1428684]
- [net] reduce cycles spend on ICMP replies that gets rate limited (Sabrina Dubroca) [1428684]
- [net] icmp: add a global rate limitation (Sabrina Dubroca) [1428684]
- [net] diag: add missing declarations (Xin Long) [1430276]
- [net] sctp: use GFP_USER for user-controlled kmalloc (Xin Long) [1430276]
- [net] sctp: Add process name and pid to deprecation warnings (Xin Long) [1430276]
- [net] sctp: Reduce log spamming for sctp setsockopt (Xin Long) [1430276]
- [net] sctp: sctp_association_init: put refs in reverse order (Xin Long) [1430276]
- [net] sctp: process fwd tsn chunk only when prsctp is enabled (Xin Long) [1430276]
- [net] sctp: sctp gso should set feature with NETIF_F_SG when calling skb_segment (Xin Long) [1430276]
- [net] sctp: sctp_transport_lookup_process should rcu_read_unlock when transport is null (Xin Long) [1430276]
- [net] sctp: change sk state only when it has assocs in sctp_shutdown (Xin Long) [1430276]
- [net] sctp: assign assoc_id earlier in __sctp_connect (Xin Long) [1430276]
- [net] sctp: fix SSN comparision (Xin Long) [1430276]
- [net] sctp: forbid negative length (Xin Long) [1430276]
- [net] sctp: remove the old ttl expires policy (Xin Long) [1430276]
- [net] sctp: change to check peer prsctp_capable when using prsctp polices (Xin Long) [1430276]
- [net] sctp: remove prsctp_param from sctp_chunk (Xin Long) [1430276]
- [net] sctp: move sent_count to the memory hole in sctp_chunk (Xin Long) [1430276]
- [net] sctp: fix the handling of SACK Gap Ack blocks (Xin Long) [1430276]
- [net] sctp: fix overrun in sctp_diag_dump_one() (Xin Long) [1430276]
- [net] sctp: always initialise sctp_ht_iter::start_fail (Xin Long) [1430276]
- [net] sctp: terminate rhashtable walk correctly (Xin Long) [1430276]
- [net] sctp: fix error return code in sctp_init() (Xin Long) [1430276]
- [net] sctp: use in_compat_syscall for sctp_getsockopt_connectx3 (Xin Long) [1430276]
- [net] sctp: keep owned chunk in destructor_arg instead of skb->cb (Xin Long) [1430276]
- [x86] build: Build compressed x86 kernels as PIE when !CONFIG_RELOCATABLE as well (Scott Wood) [1438995]
- [x86] build: Build compressed x86 kernels as PIE (Scott Wood) [1438995]
- [block] blk-mq: Fix tagset reinit in the presence of cpu hot-unplug (David Milburn) [1437721]

* Fri Apr 07 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-646.el7]
- [fs] kernfs: Enable kernfs build by default in RHEL7 (Carlos Maiolino) [1396983]
- [fs] kernfs: Fix kernfs interface differences (Carlos Maiolino) [1396983]
- [fs] kernfs: move the last knowledge of sysfs out from kernfs (Carlos Maiolino) [1396983]
- [fs] sysfs: fix namespace refcnt leak (Carlos Maiolino) [1396983]
- [fs] kernfs, sysfs, cgroup: restrict extra perm check on open to sysfs (Carlos Maiolino) [1396983]
- [fs] kernfs: add back missing error check in kernfs_fop_mmap() (Carlos Maiolino) [1396983]
- [fs] kernfs: fix a subdir count leak (Carlos Maiolino) [1396983]
- [fs] kernfs: protect lazy kernfs_iattrs allocation with mutex (Carlos Maiolino) [1396983]
- [fs] kernfs: cache atomic_write_len in kernfs_open_file (Carlos Maiolino) [1396983]
- [fs] kernfs: fix off by one error. (Carlos Maiolino) [1396983]
- [fs] kernfs: fix kernfs_node_from_dentry() (Carlos Maiolino) [1396983]
- [fs] kernfs: fix hash calculation in kernfs_rename_ns() (Carlos Maiolino) [1396983]
- [fs] kernfs: add CONFIG_KERNFS (Carlos Maiolino) [1396983]
- [fs] kernfs: implement kernfs_get_parent(), kernfs_name/path() and friends (Carlos Maiolino) [1396983]
- [fs] kernfs: implement kernfs_node_from_dentry(), kernfs_root_from_sb() and kernfs_rename() (Carlos Maiolino) [1396983]
- [fs] kernfs: add kernfs_open_file->priv (Carlos Maiolino) [1396983]
- [fs] kernfs: implement kernfs_ops->atomic_write_len (Carlos Maiolino) [1396983]
- [fs] kernfs: allow nodes to be created in the deactivated state (Carlos Maiolino) [1396983]
- [fs] kernfs: add missing kernfs_active() checks in directory operations (Carlos Maiolino) [1396983]
- [fs] kernfs: implement kernfs_syscall_ops->remount_fs() and ->show_options() (Carlos Maiolino) [1396983]
- [fs] kernfs: rename kernfs_dir_ops to kernfs_syscall_ops (Carlos Maiolino) [1396983]
- [fs] kernfs: invoke dir_ops while holding active ref of the target node (Carlos Maiolino) [1396983]
- [fs] kernfs, sysfs, driver-core: implement kernfs_remove_self() and its wrappers (Carlos Maiolino) [1396983]
- [fs] kernfs: remove KERNFS_REMOVED (Carlos Maiolino) [1396983]
- [fs] kernfs: remove KERNFS_ACTIVE_REF and add kernfs_lockdep() (Carlos Maiolino) [1396983]
- [fs] kernfs: remove kernfs_addrm_cxt (Carlos Maiolino) [1396983]
- [fs] kernfs: invoke kernfs_unmap_bin_file() directly from kernfs_deactivate() (Carlos Maiolino) [1396983]
- [fs] kernfs: restructure removal path to fix possible premature return (Carlos Maiolino) [1396983]
- [fs] kernfs: replace kernfs_node->u.completion with kernfs_root->deactivate_waitq (Carlos Maiolino) [1396983]
- [fs] kernfs: make kernfs_deactivate() honor KERNFS_LOCKDEP flag (Carlos Maiolino) [1396983]
- [fs] kernfs: associate a new kernfs_node with its parent on creation (Carlos Maiolino) [1396983]
- [fs] kernfs: add struct dentry declaration in kernfs.h (Carlos Maiolino) [1396983]
- [fs] kernfs: fix get_active failure handling in kernfs_seq_*() (Carlos Maiolino) [1396983]
- [fs] kernfs: add kernfs_dir_ops (Carlos Maiolino) [1396983]
- [fs] kernfs: allow negative dentries (Carlos Maiolino) [1396983]
- [fs] kernfs: update kernfs_rename_ns() to consider KERNFS_STATIC_NAME (Carlos Maiolino) [1396983]
- [fs] kernfs: mark static names with KERNFS_STATIC_NAME (Carlos Maiolino) [1396983]
- [fs] kernfs: add REMOVED check to create and rename paths (Carlos Maiolino) [1396983]
- [fs] kernfs: add @mode to kernfs_create_dir[_ns]() (Carlos Maiolino) [1396983]
- [fs] kernfs: s/sysfs/kernfs/ in internal functions and whatever is left (Carlos Maiolino) [1396983]
- [fs] kernfs: s/sysfs/kernfs/ in global variables (Carlos Maiolino) [1396983]
- [fs] kernfs: s/sysfs/kernfs/ in constants (Carlos Maiolino) [1396983]
- [fs] kernfs: s/sysfs/kernfs/ in various data structures (Carlos Maiolino) [1396983]
- [fs] kernfs: drop s_ prefix from kernfs_node members (Carlos Maiolino) [1396983]
- [fs] kernfs: s/sysfs_dirent/kernfs_node/ and rename its friends accordingly (Carlos Maiolino) [1396983]
- [fs] sysfs: bail early from kernfs_file_mmap() to avoid spurious lockdep warning (Carlos Maiolino) [1396983]
- [fs] kernfs: implement "trusted.*" xattr support (Carlos Maiolino) [1396983]
- [fs] kernfs: update sysfs_init_inode_attrs() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: remove cross inclusions of internal headers (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: implement kernfs_ns_enabled() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: make sysfs_dirent definition public (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: move mount core code to fs/kernfs/mount.c (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: prepare mount path for kernfs (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: make inode number ida per kernfs_root (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: implement kernfs_create/destroy_root() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: move symlink core code to fs/kernfs/symlink.c (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: move file core code to fs/kernfs/file.c (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: move dir core code to fs/kernfs/dir.c (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: move inode code to fs/kernfs/inode.c (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: move internal decls to fs/kernfs/kernfs-internal.h (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: introduce kernfs[_find_and]_get() and kernfs_put() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: revamp sysfs_dirent active_ref lockdep annotation (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: introduce kernfs_notify() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: add kernfs_ops->seq_{start|next|stop}() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: introduce kernfs_create_file[_ns]() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: introduce kernfs_ops (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: move sysfs_open_file to include/linux/kernfs.h (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: introduce kernfs_create_dir[_ns]() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: introduce kernfs_setattr() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: introduce kernfs_rename[_ns]() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: introduce kernfs_create_link() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: introduce kernfs_remove[_by_name[_ns]]() (Carlos Maiolino) [1396983]
- [fs] sysfs, kernfs: add skeletons for kernfs (Carlos Maiolino) [1396983]

* Thu Apr 06 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-645.el7]
- [ntb] ntb_netdev not covering all receive errors (Suravee Suthikulpanit) [1303727]
- [ntb] use ethtool_cmd_speed_set helper to set ethtool speed value (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_netdev: Fix list_for_each_entry exit issue (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_netdev: Fix skb free issue in open (Suravee Suthikulpanit) [1303727]
- [ntb] correct ntb_peer_spad_read for case when callback is not supplied (Suravee Suthikulpanit) [1303727]
- [ntb] correct ntb_spad_count comment typo (Suravee Suthikulpanit) [1303727]
- [ntb] Make _addr functions optional in the API (Suravee Suthikulpanit) [1303727]
- [ntb] Fix documentation for ntb_peer_db_clear (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_transport: Remove unnecessary call to ntb_peer_spad_read (Suravee Suthikulpanit) [1303727]
- [ntb] Fix 'request_irq()' and 'free_irq()' inconsistancy (Suravee Suthikulpanit) [1303727]
- [ntb] fix SKX NTB config space size register offsets (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_transport: Limit memory windows based on available, scratchpads (Suravee Suthikulpanit) [1303727]
- [ntb] Register and offset values fix for memory window (Suravee Suthikulpanit) [1303727]
- [ntb] add support for hotplug feature (Suravee Suthikulpanit) [1303727]
- [ntb] Adding Skylake Xeon NTB support (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_perf: potential info leak in debugfs (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_hw_intel: init peer_addr in struct intel_ntb_dev (Suravee Suthikulpanit) [1303727]
- [ntb] make DMA_OUT_RESOURCE_TO HZ independent (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_transport: make DMA_OUT_RESOURCE_TO HZ independent (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_hw_intel: Fix typo in module parameter descriptions (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_pingpong: Fix db_init parameter description (Suravee Suthikulpanit) [1303727]
- [ntb] add DMA error handling for RX DMA (Suravee Suthikulpanit) [1303727]
- [ntb] add DMA error handling for TX DMA (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_hw_intel: use local variable pdev (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_hw_intel: show BAR size in debugfs info (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_perf: clear link_is_up flag when the link goes down (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_pingpong: Add a debugfs file to get the ping count (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_tool: Add link status and files to debugfs (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_tool: Postpone memory window initialization for the user (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_perf: Wait for link before running test (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_perf: Return results by reading the run file (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_perf: Improve thread handling to increase robustness (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_perf: Schedule based on time not on performance (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_transport: Check the number of spads the hardware supports (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_tool: Add memory window debug support (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_perf: Allow limiting the size of the memory windows (Suravee Suthikulpanit) [1303727]
- [ntb] allocate number transport entries depending on size of ring size (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_tool: bug: Ensure the buffer size is large enough to return all spads (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_tool: Fix infinite loop bug when writing spad/peer_spad file (Suravee Suthikulpanit) [1303727]
- [ntb] Remove _addr functions from ntb_hw_amd (Suravee Suthikulpanit) [1303727]
- [ntb] Fix incorrect clean up routine in ntb_perf (Suravee Suthikulpanit) [1303727]
- [ntb] Fix incorrect return check in ntb_perf (Suravee Suthikulpanit) [1303727]
- [ntb] fix possible NULL dereference (Suravee Suthikulpanit) [1303727]
- [ntb] add missing setup of translation window (Suravee Suthikulpanit) [1303727]
- [ntb] stop link work when we do not have memory (Suravee Suthikulpanit) [1303727]
- [ntb] stop tasklet from spinning forever during shutdown (Suravee Suthikulpanit) [1303727]
- [ntb] perf test: fix address space confusion (Suravee Suthikulpanit) [1303727]
- [ntb] Fix macro parameter conflict with field name (Suravee Suthikulpanit) [1303727]
- [ntb] Add support for AMD PCI-Express Non-Transparent Bridge (Suravee Suthikulpanit) [1303727]
- [ntb] ntb perf tool (Suravee Suthikulpanit) [1303727]
- [ntb] Address out of DMA descriptor issue with NTB (Suravee Suthikulpanit) [1303727]
- [ntb] Clear property bits in BAR value (Suravee Suthikulpanit) [1303727]
- [ntb] ntb_process_tx error path bug (Suravee Suthikulpanit) [1303727]
- [ntb] fix 32-bit compiler warning (Suravee Suthikulpanit) [1303727]
- [ntb] unify translation addresses (Suravee Suthikulpanit) [1303727]
- [ntb] invalid buf pointer in multi-MW setups (Suravee Suthikulpanit) [1303727]
- [ntb] remove unused variable (Suravee Suthikulpanit) [1303727]
- [ntb] fix access of free-ed pointer (Suravee Suthikulpanit) [1303727]
- [ntb] Fix issue where we may be accessing NULL ptr (Suravee Suthikulpanit) [1303727]
- [ntb] Fix range check on memory window index (Suravee Suthikulpanit) [1303727]
- [ntb] Improve index handling in B2B MW workaround (Suravee Suthikulpanit) [1303727]
- [ntb] Use unique DMA channels for TX and RX (Suravee Suthikulpanit) [1303727]
- [ntb] Remove dma_sync_wait from ntb_async_rx (Suravee Suthikulpanit) [1303727]
- [ntb] Clean up QP stats info (Suravee Suthikulpanit) [1303727]
- [ntb] Make the transport list in order of discovery (Suravee Suthikulpanit) [1303727]
- [ntb] Add PCI Device IDs for Broadwell Xeon (Suravee Suthikulpanit) [1303727]
- [ntb] Add flow control to the ntb_netdev (Suravee Suthikulpanit) [1303727]
- [ntb] avoid format string in dev_set_name (Suravee Suthikulpanit) [1303727]
- [ntb] Fix dereference before check (Suravee Suthikulpanit) [1303727]
- [ntb] Fix zero size or integer overflow in ntb_set_mw (Suravee Suthikulpanit) [1303727]
- [ntb] Schedule to receive on QP link up (Suravee Suthikulpanit) [1303727]
- [ntb] Fix oops in debugfs when transport is half-up (Suravee Suthikulpanit) [1303727]
- [ntb] Fix transport stats for multiple devices (Suravee Suthikulpanit) [1303727]
- [ntb] Fix ntb_transport out-of-order RX update (Suravee Suthikulpanit) [1303727]
- [ntb] Add split BAR output for debugfs stats (Suravee Suthikulpanit) [1303727]
- [ntb] Change WARN_ON_ONCE to pr_warn_once on unsafe (Suravee Suthikulpanit) [1303727]
- [ntb] Print driver name and version in module init (Suravee Suthikulpanit) [1303727]
- [ntb] Increase transport MTU to 64k from 16k (Suravee Suthikulpanit) [1303727]
- [ntb] Rename Intel code names to platform names (Suravee Suthikulpanit) [1303727]
- [ntb] Default to CPU memcpy for performance (Suravee Suthikulpanit) [1303727]
- [ntb] Improve performance with write combining (Suravee Suthikulpanit) [1303727]
- [ntb] Use NUMA memory in Intel driver (Suravee Suthikulpanit) [1303727]
- [ntb] Use NUMA memory and DMA chan in transport (Suravee Suthikulpanit) [1303727]
- [ntb] Rate limit ntb_qp_link_work (Suravee Suthikulpanit) [1303727]
- [ntb] Add tool test client (Suravee Suthikulpanit) [1303727]
- [ntb] Add ping pong test client (Suravee Suthikulpanit) [1303727]
- [ntb] Add parameters for Intel SNB B2B addresses (Suravee Suthikulpanit) [1303727]
- [ntb] Reset transport QP link stats on down (Suravee Suthikulpanit) [1303727]
- [ntb] Do not advance transport RX on link down (Suravee Suthikulpanit) [1303727]
- [ntb] Differentiate transport link down messages (Suravee Suthikulpanit) [1303727]
- [ntb] Check the device ID to set errata flags (Suravee Suthikulpanit) [1303727]
- [ntb] Enable link for Intel root port mode in probe (Suravee Suthikulpanit) [1303727]
- [ntb] Read peer info from local SPAD in transport (Suravee Suthikulpanit) [1303727]
- [ntb] Split ntb_hw_intel and ntb_transport drivers (Suravee Suthikulpanit) [1303727]
- [ntb] Add NTB hardware abstraction layer (Suravee Suthikulpanit) [1303727]
- [ntb] Move files in preparation for NTB abstraction (Suravee Suthikulpanit) [1303727]
- [ntb] initialize max_mw for Atom before using it (Suravee Suthikulpanit) [1303727]
- [ntb] iounmap MW reg and vbase in error path (Suravee Suthikulpanit) [1303727]
- [ntb] Adding split BAR support for Haswell platforms (Suravee Suthikulpanit) [1303727]
- [ntb] use errata flag set via DID to implement workaround (Suravee Suthikulpanit) [1303727]
- [ntb] conslidate reading of PPD to move platform detection earlier (Suravee Suthikulpanit) [1303727]
- [ntb] move platform detection to separate function (Suravee Suthikulpanit) [1303727]
- [ntb] debugfs device entry (Suravee Suthikulpanit) [1303727]
- [ntb] Add alignment check to meet hardware requirement (Suravee Suthikulpanit) [1303727]
- [ntb] correct the spread of queues over mw's (Suravee Suthikulpanit) [1303727]
- [ntb] Use pci_enable_msix_range() instead of pci_enable_msix() (Suravee Suthikulpanit) [1303727]
- [ntb] Split ntb_setup_msix() into separate BWD/SNB routines (Suravee Suthikulpanit) [1303727]
- [ntb] Use pci_msix_vec_count() to obtain number of MSI-Xs (Suravee Suthikulpanit) [1303727]
- [ntb] Code Style Clean-up (Suravee Suthikulpanit) [1303727]
- [ntb] client event cleanup (Suravee Suthikulpanit) [1303727]
- [ntb] Fix leakage of ntb_device::msix_entries[] array (Suravee Suthikulpanit) [1303727]
- [ntb] Fix typo in setting one translation register (Suravee Suthikulpanit) [1303727]
- [ntb] Disable interrupts and poll under high load (Suravee Suthikulpanit) [1303727]
- [ntb] Enable Snoop on Primary Side (Suravee Suthikulpanit) [1303727]
- [ntb] Document HW errata (Suravee Suthikulpanit) [1303727]
- [ntb] remove duplicate defines (Suravee Suthikulpanit) [1303727]
- [ntb] correct dmaengine_get/put usage (Suravee Suthikulpanit) [1303727]
- [ntb] Fix ntb_transport link down race (Suravee Suthikulpanit) [1303727]
- [ntb] Fix missed call to pci_enable_msix() (Suravee Suthikulpanit) [1303727]
- [ntb] Fix NTB-RP Link Up (Suravee Suthikulpanit) [1303727]
- [ntb] Xeon Doorbell errata workaround (Suravee Suthikulpanit) [1303727]
- [ntb] convert to dmaengine_unmap_data (Suravee Suthikulpanit) [1303727]
- [ntb] clean up unnecessary MSI/MSI-X capability find (Suravee Suthikulpanit) [1303727]
- [ntb] Update Version (Suravee Suthikulpanit) [1303727]
- [ntb] Comment Fix (Suravee Suthikulpanit) [1303727]
- [ntb] Remove unused variable (Suravee Suthikulpanit) [1303727]
- [ntb] Remove References of non-B2B BWD HW (Suravee Suthikulpanit) [1303727]
- [ntb] NTB-RP support (Suravee Suthikulpanit) [1303727]
- [ntb] Rename Variables for NTB-RP (Suravee Suthikulpanit) [1303727]
- [ntb] Use DMA Engine to Transmit and Receive (Suravee Suthikulpanit) [1303727]
- [ntb] Enable 32bit Support (Suravee Suthikulpanit) [1303727]
- [ntb] Update Device IDs (Suravee Suthikulpanit) [1303727]
- [ntb] BWD Link Recovery (Suravee Suthikulpanit) [1303727]
- [ntb] Xeon Errata Workaround (Suravee Suthikulpanit) [1303727]
- [dma] async_memcpy: convert to dmaengine_unmap_data (Suravee Suthikulpanit) [1303727]
- [dma] dmaengine: reference counted unmap data (Suravee Suthikulpanit) [1303727]
- [dma] dmaengine: add support to provide error result from a DMA transation (Suravee Suthikulpanit) [1303727]
- [dma] dmaengine: Add helper function to prep for error reporting (Suravee Suthikulpanit) [1303727]
- [dma] dmaengine: prepare for generic 'unmap' data (Suravee Suthikulpanit) [1303727]

* Thu Apr 06 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-644.el7]
- [kernel] userns: Avoid panics by reserving space in user_table for future ucounts ("Eric W. Biederman") [1340238]
- [mm] slab.h: fix argument order in cache_from_obj's error message (Aristeu Rozanski) [1437645]
- [x86] platform/uv: Fix calculation of Global Physical Address (Frank Ramsay) [1434837]
- [pci] Support INTx masking on ConnectX-4 with firmware x.14.1100+ (Myron Stowe) [1437132]
- [pci] Convert Mellanox broken INTx quirks to be for listed devices only (Myron Stowe) [1437132]
- [pci] Convert broken INTx masking quirks from HEADER to FINAL (Myron Stowe) [1437132]
- [acpi] apei: Fix leaked resources (Jerome Marchand) [1173433]
- [acpi] apei: erst: Fixed leaked resources in erst_init (Jerome Marchand) [1173433]
- [scsi] ipr: Driver version 2.6.4 (Gustavo Duarte) [1406512]
- [scsi] ipr: Fix SATA EH hang (Gustavo Duarte) [1406512]
- [scsi] ipr: Error path locking fixes (Gustavo Duarte) [1406512]
- [scsi] ipr: Fix abort path race condition (Gustavo Duarte) [1406512]
- [scsi] ipr: Remove redundant initialization (Gustavo Duarte) [1406512]
- [scsi] ipr: Fix missed EH wakeup (Gustavo Duarte) [1406512]
- [netdrv] be2net: Fix endian issue in logical link config command (David Arcari) [1384389]
- [netdrv] fjes: Fix wrong netdevice feature flags (Yasuaki Ishimatsu) [1435603]
- [netdrv] bnxt_en: Correct the order of arguments to netdev_err() in bnxt_set_tpa() (Jonathan Toppins) [1433476]
- [netdrv] bnxt_en: Fix NULL pointer dereference in reopen failure path (Jonathan Toppins) [1433476]
- [netdrv] bnxt_en: Ignore 0 value in autoneg supported speed from firmware (Jonathan Toppins) [1433476]
- [netdrv] bnxt_en: Check if firmware LLDP agent is running (Jonathan Toppins) [1433476]
- [netdrv] bnxt_en: Call bnxt_ulp_stop() during tx timeout (Jonathan Toppins) [1433476]
- [netdrv] bnxt_en: Perform function reset earlier during probe (Jonathan Toppins) [1433476]
- [netdrv] bnxt_en: use eth_hw_addr_random() (Jonathan Toppins) [1433476]
- [netdrv] bnxt_en: fix pci cleanup in bnxt_init_one() failure path (Jonathan Toppins) [1433476]
- [netdrv] bnxt_en: Fix NULL pointer dereference in a failure path during open (Jonathan Toppins) [1433476]
- [netdrv] bnxt_en: Reject driver probe against all bridge devices (Jonathan Toppins) [1433476]
- [netdrv] mlx5e: Reorder update stats (Kamal Heib) [1409101]
- [netdrv] mlx5: Move cached hca caps to designated caps struct (Kamal Heib) [1409101]
- [netdrv] mlx5e: Expose PCIe statistics to ethtool (Kamal Heib) [1409101]
- [netdrv] mlx5: Add MPCNT register infrastructure (Kamal Heib) [1409101]
- [netdrv] mlx5e: Expose physical layer statistical counters to ethtool (Kamal Heib) [1409101]
- [netdrv] mlx5: Add PPCNT physical layer statistical group infrastructure (Kamal Heib) [1409101]
- [netdrv] mlx5: Query and cache PCAM, MCAM registers on initialization (Kamal Heib) [1409101]
- [netdrv] mlx5: Implement PCAM, MCAM access register commands (Kamal Heib) [1409101]
- [netdrv] mlx5: Expose PCAM, MCAM registers infrastructure (Kamal Heib) [1409101]
- [netdrv] mlx5e: Implement 1PPS support (Kamal Heib) [1386723]
- [netdrv] mlx5: Add MTPPS and MTPPSE registers infrastructure (Kamal Heib) [1386723]
- [infiniband] ib/mlx5: Replace ENOTSUPP usage with EOPNOTSUPP (Kamal Heib) [1386747]
- [infiniband] ib/mlx5: Add flow tag support (Kamal Heib) [1386747]
- [infiniband] ib/uverbs: Add support for flow tag (Kamal Heib) [1386747]
- [rdma] ib/core: Introduce flow tag specification (Kamal Heib) [1386747]
- [netdrv] mlx5: Consolidate flow rules regardless their flow tag (Kamal Heib) [1386747]

* Tue Apr 04 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-643.el7]
- [net] flow_dissector: check if arp_eth is null rather than arp (Jonathan Toppins) [1393375]
- [net] sched: cls_rsvp: complete rcu conversion (Jonathan Toppins) [1393375]
- [net] sched: cls_tcindex: fix another crash in cls_tcindex (Jonathan Toppins) [1393375]
- [net] sched: act_mirred: fix a typo in get_dev (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: mark tech preview (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Reflect HW offload status (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Properly handle classifier flags dumping (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: expose priority to offloading netdevice (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Correct matching on ICMPv6 code (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: reduce fl_change stack size (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Disallow duplicate internal elements (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Support matching on ARP (Jonathan Toppins) [1393375]
- [net] flow_disector: ARP support (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Fix missing addr_type in classify (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Mandate mask when matching on flags (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Use masked key when calling HW offloads (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Use mask for addr_type (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Support matching on ICMP type and code (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Add support for matching on flags (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Set the filter Hardware device for all use-cases (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Add offload support using egress Hardware device (Jonathan Toppins) [1393375]
- [net] sched: move tc offload macros to pkt_cls.h (Jonathan Toppins) [1393375]
- [net] sched: avoid unused variable warning (Jonathan Toppins) [1393375]
- [net] sched: act_mirred: Add new tc_action_ops get_dev() (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Provide a filter to replace/destroy hardware filter functions (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Try to offload only if skip_hw flag isn't set (Jonathan Toppins) [1393375]
- [net] sched: Add separate check for skip_hw flag (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: remove from hashtable only in case skip sw flag is not set (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: respect rcu grace period on cls destruction (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Add UDP port to tunnel parameters (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Allow setting encapsulation fields as used key (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Support matching on SCTP ports (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: merge filter delete/destroy common code (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: add missing unbind call when destroying flows (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Use a proper mask value for enc key id parameter (Jonathan Toppins) [1393375]
- [net] sched: stylistic cleanups (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Specify vlan attributes format in the UAPI header (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Remove an unused field from the filter key structure (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Support masking for matching on tcp/udp ports (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Classify packet in ip tunnels (Jonathan Toppins) [1393375]
- [net] dst: Utility functions to build dst_metadata without supplying an skb (Jonathan Toppins) [1393375]
- [net] ip_tunnels: Introduce tunnel_id_to_key32() and key32_to_tunnel_id() (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: fix use of uninitialized ethertype variable in cls_flower (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Add vlan support (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Avoid dissection of unmasked keys (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Return error when hw can't offload and skip_sw is set (Jonathan Toppins) [1393375]
- [net] sched: fix tc_should_offload for specific clsact classes (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Introduce support in SKIP SW flag (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Hardware offloaded filters statistics support (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Fix pointer cast (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Introduce hardware offload support (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: set key address type when present (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: fix panic on filter replace (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: flower fix typo (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Add full IPv6 addresses to flow_keys (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Get skb hash over flow_keys structure (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: Fix compile error (Jonathan Toppins) [1393375]
- [net] sched: cls_flower: introduce Flower classifier (Jonathan Toppins) [1393375]

* Tue Apr 04 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-642.el7]
- [pci] Enable access to non-standard VPD for Chelsio devices (Sai Vemuri) [1241921]
- [x86] efi: Do not handle BGRT image in kdump kernel (Bhupesh Sharma) [1268946]
- [net] qed: Add support for hardware offloaded FCoE (Chad Dupuis) [1384085]
- [scsi] qedf: Add QLogic FastLinQ offload FCoE driver framework (Chad Dupuis) [1384085]
- [scsi] qedi: Fix memory leak in tmf response processing (Chad Dupuis) [1384083]
- [scsi] qedi: Fix possible memory leak in qedi_iscsi_update_conn() (Chad Dupuis) [1384083]
- [scsi] qedi: fix build, depends on UIO (Chad Dupuis) [1384083]
- [scsi] qedi: Add QLogic FastLinQ offload iSCSI driver framework (Chad Dupuis) [1384083]
- [misc] mei: don't wait for os version message reply (Jerry Snitselaar) [1435102]
- [misc] mei: me: add lewisburg device ids (Jerry Snitselaar) [1435102]
- [char] tpm_crb: request and relinquish locality 0 (Jerry Snitselaar) [1402149]
- [char] tpm: make check_locality return bool (Jerry Snitselaar) [1402149]
- [char] tpm_crb: check for bad response size (Jerry Snitselaar) [1402149]
- [char] tpm_crb: encapsulate crb_wait_for_reg_32 (Jerry Snitselaar) [1402149]
- [char] tpm_crb: map locality registers (Jerry Snitselaar) [1402149]
- [char] tpm crb: Work around BIOS's that report the wrong ACPI region size (Jerry Snitselaar) [1402149]
- [tools] perf bench numa: Add more comment for -c option (Jiri Olsa) [1018964]
- [crypto] ccp - Assign DMA commands to the channel's CCP (Suravee Suthikulpanit) [1420977]
- [netdrv] iwlwifi: mvm: cleanup pending frames in DQA mode (Stanislaw Gruszka) [1431840]
- [netdrv] mlx4_en: Adding support of turning off link autonegotiation via ethtool (Kamal Heib) [1409502]
- [cpufreq] intel_pstate: Disable energy efficiency optimization (Prarit Bhargava) [1408828]
- [powerpc] powernv: Handle OPAL_WRONG_STATE in opal_get_sensor_data() (Steve Best) [1412551]
- [powerpc] powerpc/64: Fix checksum folding in csum_add() (Gustavo Duarte) [1430834]
- [powerpc] powerpc/64: Use optimized checksum routines on little-endian (Gustavo Duarte) [1430834]
- [powerpc] powerpc/64: Fix checksum folding in csum_tcpudp_nofold and ip_fast_csum_nofold (Gustavo Duarte) [1430834]
- [powerpc] Update parameters for csum_tcpudp_magic & csum_tcpudp_nofold (Gustavo Duarte) [1430834]
- [powerpc] powerpc/32: Fix again csum_partial_copy_generic() (Gustavo Duarte) [1430834]
- [powerpc] powerpc/32: Fix csum_partial_copy_generic() (Gustavo Duarte) [1430834]
- [powerpc] lib: Clarify that adde is an instruction and we mean plural (Gustavo Duarte) [1430834]
- [powerpc] simplify csum_add(a, b) in case a or b is constant 0 (Gustavo Duarte) [1430834]
- [powerpc] powerpc/32: optimise csum_partial() loop (Gustavo Duarte) [1430834]
- [powerpc] powerpc/32: optimise a few instructions in csum_partial() (Gustavo Duarte) [1430834]
- [powerpc] powerpc/32: rewrite csum_partial_copy_generic() based on copy_tofrom_user() (Gustavo Duarte) [1430834]
- [powerpc] inline ip_fast_csum() (Gustavo Duarte) [1430834]
- [powerpc] powerpc/32: checksum_wrappers_64 becomes checksum_wrappers (Gustavo Duarte) [1430834]
- [powerpc] mark xer clobbered in csum_add() (Gustavo Duarte) [1430834]
- [powerpc] add support for csum_add() (Gustavo Duarte) [1430834]
- [powerpc] put csum_tcpudp_magic inline (Gustavo Duarte) [1430834]
- [firmware] efi: Expose underlying UEFI firmware platform size to userland (Lenny Szubowicz) [1434959]

* Mon Apr 03 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-641.el7]
- [x86] mm/kaslr: EFI region is mistakenly included into KASLR VA space for randomization (Baoquan He) [1424943]
- [x86] kconfig: Remove misleading note regarding hibernation and KASLR (Baoquan He) [1424943]
- [kernel] uaccess.h: Include linux/sched.h (Baoquan He) [1424943]
- [x86] microcode/amd: Fix load of builtin microcode with randomized memory (Baoquan He) [1424943]
- [x86] microcode/amd: Make amd_ucode_patch[] static (Baoquan He) [1424943]
- [x86] microcode/amd: Fix initrd loading with CONFIG_RANDOMIZE_MEMORY=y (Baoquan He) [1424943]
- [x86] asm, x86/microcode: Add __PAGE_OFFSET_BASE define on 32-bit (Baoquan He) [1424943]
- [x86] microcode/intel: Fix initrd loading with CONFIG_RANDOMIZE_MEMORY=y (Baoquan He) [1424943]
- [x86] microcode: Fix loading precedence (Baoquan He) [1424943]
- [kernel] kexec: export the value of phys_base instead of symbol address (Baoquan He) [1424943]
- [kernel] kexec: export KERNEL_IMAGE_SIZE to vmcoreinfo (Baoquan He) [1424943]
- [x86] revert "kdump, vmcoreinfo: report memory sections virtual addresses" (Baoquan He) [1424943]
- [kernel] kdump, vmcoreinfo: report memory sections virtual addresses (Baoquan He) [1424943]
- [x86] mm/64: Enable KASLR for vmemmap memory region (Baoquan He) [1424943]
- [x86] ptdump: Add section for EFI runtime services (Baoquan He) [1424943]
- [x86] mm/kaslr: Increase BRK pages for KASLR memory randomization (Baoquan He) [1424943]
- [x86] mm/kaslr: Fix physical memory calculation on KASLR memory randomization (Baoquan He) [1424943]
- [x86] mm: Do not reference phys addr beyond kernel (Baoquan He) [1424943]
- [x86] mm: Add memory hotplug support for KASLR memory randomization (Baoquan He) [1424943]
- [x86] mm: Enable KASLR for vmalloc memory regions (Baoquan He) [1424943]
- [x86] mm: Enable KASLR for physical mapping memory regions (Baoquan He) [1424943]
- [x86] asm: Remove unused L3_PAGE_OFFSET (Baoquan He) [1424943]
- [x86] mm: Implement ASLR for kernel memory regions (Baoquan He) [1424943]
- [x86] mm: Separate variable for trampoline PGD (Baoquan He) [1424943]
- [x86] mm: Add PUD VA support for physical mapping (Baoquan He) [1424943]
- [x86] mm: Use pte_none() to test for empty PTE (Baoquan He) [1424943]
- [x86] mm: Update physical mapping variable names (Baoquan He) [1424943]
- [x86] revert "Use pte_none() to test for empty PTE" (Baoquan He) [1424943]
- [kernel] sched: Remove lockdep check in sched_move_task() (Oleg Nesterov) [1388158]
- [kernel] sched/autogroup: Do not use autogroup->tg in zombie threads (Oleg Nesterov) [1388158]
- [kernel] sched/autogroup: Fix autogroup_move_group() to never skip sched_move_task() (Oleg Nesterov) [1388158]
- [kernel] sched: Change autogroup_move_group() to use for_each_thread() (Oleg Nesterov) [1388158]
- [kernel] audit: log module name on delete_module (Richard Guy Briggs) [1426659]
- [kernel] audit: add feature audit_lost reset (Richard Guy Briggs) [1249813]
- [kernel] audit: Audit proc/<pid>/cmdline aka proctitle (Richard Guy Briggs) [1299527]
- [kernel] mm: Create utility function for accessing a tasks commandline value (Richard Guy Briggs) [1299527]
- [kernel] perf/core: Introduce PMU_EV_CAP_READ_ACTIVE_PKG (Jiri Olsa) [1434753] {CVE-2017-6001}
- [kernel] perf/core: Generalize event->group_flags (Jiri Olsa) [1434753] {CVE-2017-6001}
- [kernel] perf/core: Fix concurrent sys_perf_event_open() vs. 'move_group' race (Jiri Olsa) [1434753] {CVE-2017-6001}
- [kernel] powerpc: Fix copy_file_range syscall (Prarit Bhargava) [1436879]
- [kernel] s390: set NR_syscalls to 376 (Prarit Bhargava) [1436879]
- [kernel] userns: Remove user namespaces from tech preview status ("Eric W. Biederman") [1340238]
- [kernel] userns: By default allow 0 user namespaces in RHEL7 ("Eric W. Biederman") [1340238]
- [kernel] ucount: Remove the atomicity from ucount->count ("Eric W. Biederman") [1340238]
- [kernel] userns: Make ucounts lock irq-safe ("Eric W. Biederman") [1340238]
- [kernel] userns: When the per user per user namespace limit is reached return ENOSPC ("Eric W. Biederman") [1340238]
- [kenrel] userns: Document per user per user namespace limits ("Eric W. Biederman") [1340238]
- [kernel] mntns: Add a limit on the number of mount namespaces ("Eric W. Biederman") [1340238 1322495] {CVE-2016-6213}
- [kernel] netns: Add a limit on the number of net namespaces ("Eric W. Biederman") [1340238]
- [kernel] ipcns: Add a limit on the number of ipc namespaces ("Eric W. Biederman") [1340238]
- [kernel] ipc: Initialize ipc_namespace->user_ns early ("Eric W. Biederman") [1340238]
- [kernel] utsns: Add a limit on the number of uts namespaces ("Eric W. Biederman") [1340238]
- [kernel] pidns: Add a limit on the number of pid namespaces ("Eric W. Biederman") [1340238]
- [kernel] userns: Generalize the user namespace count into ucount ("Eric W. Biederman") [1340238]
- [kernel] userns: Make the count of user namespaces per user ("Eric W. Biederman") [1340238]
- [kernel] userns: Add a limit on the number of user namespaces ("Eric W. Biederman") [1340238]
- [kernel] userns: Add per user namespace sysctls ("Eric W. Biederman") [1340238]
- [kernel] userns: Free user namespaces in process context ("Eric W. Biederman") [1340238]
- [kernel] sysctl: Stop implicitly passing current into sysctl_table_root.lookup ("Eric W. Biederman") [1340238]

* Fri Mar 31 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-640.el7]
- [md] dm error: add DAX support (Jeff Moyer) [1384648 1384644]
- [dax] rhel: device-dax: only support page-sized faults (Jeff Moyer) [1383489]
- [md] dm: allow bio-based table to be upgraded to bio-based with DAX support (Jeff Moyer) [1384648 1384644]
- [md] dm snap: add fake origin_direct_access (Jeff Moyer) [1384648 1384644]
- [md] dm stripe: add DAX support (Jeff Moyer) [1384644]
- [md] dm linear: add DAX support (Jeff Moyer) [1384648]
- [uapi] dm: add infrastructure for DAX support (Jeff Moyer) [1384648 1384644]
- [kernel] dax: enable dax in the presence of known media errors (badblocks) (Jeff Moyer) [1383825]
- [dax] device-dax: fix pmd/pte fault fallback handling (Jeff Moyer) [1383489]
- [dax] fix debug output typo (Jeff Moyer) [1383489]
- [nvdimm] libnvdimm, pfn: fix memmap reservation size versus 4K alignment (Jeff Moyer) [1383825]
- [acpi] nfit: fix acpi_nfit_flush_probe() crash (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm, namespace: do not delete namespace-id 0 (Jeff Moyer) [1383827]
- [nvdimm] constify device_type structures (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm, namespace: fix pmem namespace leak, delete when size set to zero (Jeff Moyer) [1383827]
- [nvdimm] pmem: return EIO on read_pmem() failure (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm: fix mishandled nvdimm_clear_poison() return value (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm: replace mutex_is_locked() warnings with lockdep_assert_held (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm, pfn: fix align attribute (Jeff Moyer) [1383825]
- [tools] testing/nvdimm: unit test acpi_nfit_ctl() (Jeff Moyer) [1383825]
- [acpi] nfit: fix bus vs dimm confusion in xlat_status (Jeff Moyer) [1383825]
- [acpi] nfit: validate ars_status output buffer size (Jeff Moyer) [1383825]
- [kernel] acpi, nfit, libnvdimm: fix / harden ars_status output length handling (Jeff Moyer) [1383825]
- [acpi] nfit: fix extended status translations for ACPI DSMs (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm, e820: use module_platform_driver (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm, namespace: use octal for permissions (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, namespace: avoid multiple sector calculations (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm: remove else after return in nsio_rw_bytes() (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, namespace: fix the type of name variable (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm: use consistent naming for request_mem_region() (Jeff Moyer) [1383825]
- [dax] add region 'id', 'size', and 'align' attributes (Jeff Moyer) [1383489]
- [dax] device-dax: fix private mapping restriction, permit read-only (Jeff Moyer) [1383489]
- [dax] device-dax: fail all private mapping attempts (Jeff Moyer) [1383489]
- [dax] device-dax: check devm_nsio_enable() return value (Jeff Moyer) [1383489]
- [dax] device-dax: fix percpu_ref_exit ordering (Jeff Moyer) [1383489]
- [dax] use correct dev_t value (Jeff Moyer) [1383489]
- [dax] convert devm_create_dax_dev to PTR_ERR (Jeff Moyer) [1383489]
- [dax] fix mapping size check (Jeff Moyer) [1383489]
- [dax] fix device-dax region base (Jeff Moyer) [1383489]
- [dax] check resource alignment at dax region/device create (Jeff Moyer) [1383489]
- [dax] unmap/truncate on device shutdown (Jeff Moyer) [1383489]
- [uapi] dax: define a unified inode/address_space for device-dax mappings (Jeff Moyer) [1383489]
- [dax] convert to the cdev api (Jeff Moyer) [1383489]
- [dax] embed a struct device in dax_dev (Jeff Moyer) [1383489]
- [dax] rename fops from dax_dev_ to dax_ (Jeff Moyer) [1383489]
- [dax] reorder dax_fops function definitions (Jeff Moyer) [1383489]
- [dax] cleanup needlessly global symbol warnings (Jeff Moyer) [1383489]
- [dax] use devm_add_action_or_reset() (Jeff Moyer) [1383489]
- [nvdimm] use the right length of "pmem" (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm: check and clear poison before writing to pmem (Jeff Moyer) [1383825]
- [nvdimm] make CONFIG_NVDIMM_DAX 'bool' (Jeff Moyer) [1383489]
- [nvdimm] pmem: report error on clear poison failure (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm, namespace: potential NULL deref on allocation error (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm: allow a platform to force enable label support (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm: use generic iostat interfaces (Jeff Moyer) [1383825]
- [kernel] blk: introduce generic io stat accounting help function (Jeff Moyer) [1383825]
- [nvdimm] /dev/dax: fix Kconfig dependency build breakage (Jeff Moyer) [1383489]
- [nvdimm] libnvdimm, namespace: allow creation of multiple pmem-namespaces per region (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, namespace: lift single pmem limit in scan_labels() (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, namespace: filter out of range labels in scan_labels() (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, namespace: enable allocation of multiple pmem namespaces (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, namespace: update label implementation for multi-pmem (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, namespace: expand pmem device naming scheme for multi-pmem (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, region: update nd_region_available_dpa() for multi-pmem support (Jeff Moyer) [1383827]
- [kernel] libnvdimm, namespace: sort namespaces by dpa at init (Jeff Moyer) [1383827]
- [kernel] libnvdimm, namespace: allow multiple pmem-namespaces per region at scan time (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, namespace: unify blk and pmem label scanning (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, namespace: refactor uuid_show() into a namespace_to_uuid() helper (Jeff Moyer) [1383827]
- [nvdimm] libnvdimm, label: convert label tracking to a linked list (Jeff Moyer) [1383827]
- [kernel] libnvdimm, region: move region-mapping input-paramters to nd_mapping_desc (Jeff Moyer) [1383825]
- [nvdimm] reduce duplicated wpq flushes (Jeff Moyer) [1383825]
- [kernel] libnvdimm: clear the internal poison_list when clearing badblocks (Jeff Moyer) [1383825]
- [nvdimm] pmem: reduce kmap_atomic sections to the memcpys only (Jeff Moyer) [1383825]
- [kernel] x86, pmem: use memcpy_mcsafe() for memcpy_from_pmem() (Jeff Moyer) [1383825]
- [acpi] nfit: don't start a full scrub by default for an MCE (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm, region: fix flush hint table thinko (Jeff Moyer) [1383825]
- [nvdimm] remove duplicate nd_mapping declaration (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm, namespace: debug invalid interleave-set-cookie values (Jeff Moyer) [1383825]
- [acpi] nfit: fail DSMs that return non-zero status by default (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm: fix devm_nvdimm_memremap() error path (Jeff Moyer) [1383825]
- [nvdimm] fix PHYS_PFN/PFN_PHYS mixup (Jeff Moyer) [1428115]
- [nvdimm] libnvdimm: allow legacy (e820) pmem region to clear bad blocks (Jeff Moyer) [1383825]
- [acpi] nfit, mce: Fix SPA matching logic in MCE handler (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm: Fix nvdimm_probe error on NVDIMM-N (Jeff Moyer) [1385037]
- [nvdimm] Spelling s/unacknoweldged/unacknowledged/ (Jeff Moyer) [1383825]
- [tools] testing/nvdimm: unit test for acpi_nvdimm_notify() (Jeff Moyer) [1383825]
- [kernel] acpi, nfit: add dimm device notification support (Jeff Moyer) [1383825]
- [tools] testing/nvdimm: unit test for acpi_nfit_notify() (Jeff Moyer) [1383825]
- [tools] testing/nvdimm: fix SIGTERM vs hotplug crash (Jeff Moyer) [1383825]
- [acpi] nfit: check for the correct event code in notifications (Jeff Moyer) [1369563]
- [nvdimm] btt: add a size attribute for BTTs (Jeff Moyer) [1379275]
- [acpi] libnvdimm, nd_blk: mask off reserved status bits (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm-btt: Delete an unnecessary check before the function call "__nd_device_register" (Jeff Moyer) [1379275]
- [tools] nfit: do an ARS scrub on hitting a latent media error (Jeff Moyer) [1383825]
- [acpi] nfit: move to nfit/ sub-directory (Jeff Moyer) [1383825]
- [mm] /dev/dax, core: file operations and dax-mmap (Jeff Moyer) [1383489]
- [tools] /dev/dax, pmem: direct access to persistent memory (Jeff Moyer) [1383489]
- [kernel] nfit, libnvdimm: allow an ARS scrub to be triggered on demand (Jeff Moyer) [1383825]
- [nvdimm] libnvdimm: register nvdimm_bus devices with an nd_bus driver (Jeff Moyer) [1383825]
- [nvdimm] pmem: clarify a debug print in pmem_clear_poison (Jeff Moyer) [1383825]
- [tools] nfit, tools/testing/nvdimm/: unify shutdown paths (Jeff Moyer) [1383825]
- [tools] libnvdimm: move ->module to struct nvdimm_bus_descriptor (Jeff Moyer) [1383825]
- [tools] nfit: cleanup acpi_nfit_init calling convention (Jeff Moyer) [1383825]
- [acpi] nfit: fix _FIT evaluation memory leak + use after free (Jeff Moyer) [1383825]
- [acpi] nfit: treat virtual ramdisk SPA as pmem region (Jeff Moyer) [1383825]
- [kernel] block: add QUEUE_FLAG_DAX for devices to advertise their DAX support (Jeff Moyer) [1384648 1384644]
- [nvdimm] libnvdimm: IS_ERR() usage cleanup (Jeff Moyer) [1383825]

* Fri Mar 31 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-639.el7]
- [netdrv] mark the aquantia ethernet driver as tech-preview (David Arcari) [1406021]
- [netdrv] aquantia: Reset is_gso flag when EOP reached (David Arcari) [1406021]
- [netdrv] aquantia: Fix for LSO with IPv6 (David Arcari) [1406021]
- [netdrv] aquantia: Missing spinlock initialization (David Arcari) [1406021]
- [netdrv] aquantia: Fix packet type detection (TCP/UDP) for IPv6 (David Arcari) [1406021]
- [netdrv] aquantia: Remove adapter re-opening when MTU changed (David Arcari) [1406021]
- [netdrv] aquantia: Fix for RX checksum offload (David Arcari) [1406021]
- [netdrv] aquantia: Copying tx buffers is not needed (David Arcari) [1406021]
- [netdrv] aquantia: Fixed memory allocation if AQ_CFG_RX_FRAME_MAX > 1 page (David Arcari) [1406021]
- [netdrv] aquantia: Fixed incorrect buff->len calculation (David Arcari) [1406021]
- [netdrv] aquantia: Call netdev_register after all initialized (David Arcari) [1406021]
- [netdrv] aquantia: Null pointer check for aq_nic_ndev_alloc (David Arcari) [1406021]
- [netdrv] aquantia: Using NETDEV_TX_OK instead 0 (David Arcari) [1406021]
- [netdrv] aquantia: Fixed missing rtnl_unlock (David Arcari) [1406021]
- [netdrv] aquantia: Superfluous initialization of "err" (David Arcari) [1406021]
- [netdrv] aquantia: Using module_pci_driver (David Arcari) [1406021]
- [netdrv] aquantia: Removed busy_count field (David Arcari) [1406021]
- [netdrv] aquantia: Removed extra assignment for skb->dev (David Arcari) [1406021]
- [netdrv] aquantia: remove function aq_ring_tx_deinit (David Arcari) [1406021]
- [netdrv] aquantia: Add 2500/5000 mbit link modes support (David Arcari) [1406021]
- [netdrv] aquantia: fix dma_mapping_error test (David Arcari) [1406021]
- [netdrv] aquantia: atlantic: use new api ethtool_{get|set}_link_ksettings (David Arcari) [1406021]
- [netdrv] generalize napi_complete_done() (David Arcari) [1406021]
- [netdrv] aquantia: return -ETIME in macro AQ_HW_WAIT_FOR (David Arcari) [1406021]
- [netdrv] aquantia: remove another redundant err check (David Arcari) [1406021]
- [netdrv] aquantia: remove redundant err check (David Arcari) [1406021]
- [netdrv] aquantia: Integrate AQtion 2.5/5 GB NIC driver (David Arcari) [1406021]
- [netdrv] aquantia: Receive side scaling (David Arcari) [1406021]
- [netdrv] aquantia: Ethtool support (David Arcari) [1406021]
- [netdrv] aquantia: Hardware interface and utility functions (David Arcari) [1406021]
- [netdrv] aquantia: Atlantic hardware abstraction layer (David Arcari) [1406021]
- [netdrv] aquantia: PCI operations (David Arcari) [1406021]
- [netdrv] aquantia: Vector operations (David Arcari) [1406021]
- [netdrv] aquantia: Atlantic A0 and B0 specific functions (David Arcari) [1406021]
- [netdrv] aquantia: Support for NIC-specific code (David Arcari) [1406021]
- [netdrv] aquantia: Low-level hardware interfaces (David Arcari) [1406021]
- [netdrv] aquantia: Add ring support code (David Arcari) [1406021]
- [netdrv] aquantia: Common functions and definitions (David Arcari) [1406021]
- [netdrv] aquantia: Make and configuration files (David Arcari) [1406021]
- [uapi] ethtool: add support for 2500BaseT and 5000BaseT link modes (David Arcari) [1406021]
- [uapi] ethtool: add support for 1000BaseX and missing 10G link modes (David Arcari) [1406021]

* Fri Mar 31 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-638.el7]
- [netdrv] ieee802154: atusb: fix driver to work with older firmware versions (David Arcari) [1415327]
- [netdrv] at86rf230: Allow slow GPIO pins for "rstn" (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: do not use the stack for address fetching to make it DMA able (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: make sure we set a randaom extended address if fetching fails (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: do not use the stack for buffers to make them DMA able (David Arcari) [1415327]
- [bluetooth] btmrvl: drop duplicate header slab.h (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: implement .set_frame_retries ops callback (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: try to read permanent extended address from device (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: store firmware version after retrieval for later use (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: sync header file from firmware for new features (David Arcari) [1415327]
- [netdrv] ieee802154: fakelb: print number of created fake devices during probe (David Arcari) [1415327]
- [netdrv] at86rf230: fix cca ed values for rf233 (David Arcari) [1415327]
- [net] ieee802154: check device type (David Arcari) [1415327]
- [bluetooth] hci_qca: Use setup_timer Kernel API instead of init_timer (David Arcari) [1415327]
- [bluetooth] hci_h5: Use setup_timer Kernel API instead of init_timer (David Arcari) [1415327]
- [bluetooth] hci_bcsp: Use setup_timer Kernel API instead of init_timer (David Arcari) [1415327]
- [net] bluetooth: __ variants of u8 and friends are not neccessary inside kernel (David Arcari) [1415327]
- [netdrv] ieee802154: drop duplicate header delay.h (David Arcari) [1415327]
- [net] bluetooth: Fix using the correct source address type (David Arcari) [1415327]
- [netdrv] ieee802154: constify ieee802154_ops structures (David Arcari) [1415327]
- [bluetooth] btwilink: Fix probe return value (David Arcari) [1415327]
- [net] bluetooth: Fix append max 11 bytes of name to scan rsp data (David Arcari) [1415327]
- [bluetooth] hci_bcm: Fix autosuspend PM for Lenovo ThinkPad 8 (David Arcari) [1415327]
- [bluetooth] btusb: Fix atheros firmware download error (David Arcari) [1415327]
- [net] bluetooth: Refactor append name and appearance (David Arcari) [1415327]
- [net] bluetooth: Add appearance to default scan rsp data (David Arcari) [1415327]
- [net] bluetooth: Fix local name in scan rsp (David Arcari) [1415327]
- [bluetooth] btusb: add entry for Marvell 8997 chipset (David Arcari) [1415327]
- [bluetooth] Use single return in hci_uart_tty_ioctl() call (David Arcari) [1415327]
- [bluetooth] BCSP fails to ACK re-transmitted frames from the peer (David Arcari) [1415327]
- [bluetooth] Tidy-up coding style in hci_bcsp.c (David Arcari) [1415327]
- [bluetooth] btwilink: Save the packet type before sending (David Arcari) [1415327]
- [net] bluetooth: Fix not updating scan rsp when adv off (David Arcari) [1415327]
- [bluetooth] Add a new 04ca:3011 QCA_ROME device (David Arcari) [1415327]
- [net] bluetooth: Fix NULL pointer dereference in mgmt context (David Arcari) [1415327]
- [net] bluetooth: Set appearance only for LE capable controllers (David Arcari) [1415327]
- [net] bluetooth: Fix missing ext info event when setting appearance (David Arcari) [1415327]
- [net] bluetooth: Add supported data types to ext info changed event (David Arcari) [1415327]
- [net] bluetooth: Add appearance to Read Ext Controller Info command (David Arcari) [1415327]
- [net] bluetooth: Factor appending EIR to separate helper (David Arcari) [1415327]
- [net] bluetooth: Refactor read_ext_controller_info handler (David Arcari) [1415327]
- [bluetooth] hci_uart: Add Marvell support (David Arcari) [1415327]
- [bluetooth] hci_uart: Add Nokia Protocol identifier (David Arcari) [1415327]
- [bluetooth] hci_bcm: Change protocol name (David Arcari) [1415327]
- [net] bluetooth: Increment management interface revision (David Arcari) [1415327]
- [net] bluetooth: Fix advertising instance validity check for flags (David Arcari) [1415327]
- [net] bluetooth: Unify advertising instance flags check (David Arcari) [1415327]
- [net] bluetooth: Remove unused parameter from tlv_data_is_valid function (David Arcari) [1415327]
- [net] bluetooth: Add support for appearance in scan rsp (David Arcari) [1415327]
- [net] bluetooth: Add support for local name in scan rsp (David Arcari) [1415327]
- [bluetooth] btrtl: Add RTL8822BE Bluetooth device (David Arcari) [1415327]
- [net] bluetooth: Fix not registering BR/EDR SMP channel with force_bredr flag (David Arcari) [1415327]
- [net] bluetooth: Use kzalloc instead of kmalloc/memset (David Arcari) [1415327]
- [net] bluetooth: Increase the subsystem minor version number (David Arcari) [1415327]
- [net] bluetooth: Fix reason code used for rejecting SCO connections (David Arcari) [1415327]
- [bluetooth] btqca: remove null checks on edl->data as it is an array (David Arcari) [1415327]
- [net] bluetooth: Fix wrong New Settings event when closing HCI User Channel (David Arcari) [1415327]
- [net] bluetooth: Send control open and close messages for HCI user channels (David Arcari) [1415327]
- [netdrv] fakelb: fix schedule while atomic (David Arcari) [1415327]
- [net] bluetooth: Append local name and CoD to Extended Controller Info (David Arcari) [1415327]
- [net] bluetooth: Add framework for Extended Controller Information (David Arcari) [1415327]
- [bluetooth] btusb: Mark CW6622 devices to have broken link key commands (David Arcari) [1415327]
- [bluetooth] Remove deprecated create_singlethread_workqueue (David Arcari) [1415327]
- [net] bluetooth: Handle HCI raw socket transition from unbound to bound (David Arcari) [1415327]
- [net] bluetooth: Send control open and close messages for HCI raw sockets (David Arcari) [1415327]
- [net] bluetooth: Add extra channel checks for control open/close messages (David Arcari) [1415327]
- [net] bluetooth: Assign the channel early when binding HCI sockets (David Arcari) [1415327]
- [net] bluetooth: Send control open and close only when cookie is present (David Arcari) [1415327]
- [net] bluetooth: Use numbers for subsystem version string (David Arcari) [1415327]
- [net] bluetooth: Introduce helper functions for socket cookie handling (David Arcari) [1415327]
- [bluetooth] add WCNSS dependency for HCI driver (David Arcari) [1415327]
- [net] bluetooth: Use command status event for Set IO Capability errors (David Arcari) [1415327]
- [net] bluetooth: Fix wrong Get Clock Information return parameters (David Arcari) [1415327]
- [net] bluetooth: Use individual flags for certain management events (David Arcari) [1415327]
- [net] bluetooth: mgmt: Fix sending redundant event for Advertising Instance (David Arcari) [1415327]
- [net] bluetooth: Add support for sending MGMT commands and events to monitor (David Arcari) [1415327]
- [net] bluetooth: Add support for sending MGMT open and close to monitor (David Arcari) [1415327]
- [net] bluetooth: Introduce helper to pack mgmt version information (David Arcari) [1415327]
- [net] bluetooth: Store control socket cookie and comm information (David Arcari) [1415327]
- [net] bluetooth: Check SOL_HCI for raw socket options (David Arcari) [1415327]
- [bluetooth] bcm203x: don't print error when allocating urb fails (David Arcari) [1415327]
- [bluetooth] btusb: Add support for 0cf3:e009 (David Arcari) [1415327]
- [net] bluetooth: add printf format attribute to hci_set_[fh]w_info() (David Arcari) [1415327]
- [bluetooth] btusb, hci_intel: Fix wait_on_bit_timeout() return value checks (David Arcari) [1415327]
- [bluetooth] Introduce Qualcomm WCNSS SMD based HCI driver (David Arcari) [1415327]
- [net] bluetooth: Add HCI device identifier for Qualcomm SMD (David Arcari) [1415327]
- [net] 6lowpan: ndisc: no overreact if no short address is available (David Arcari) [1415327]
- [net] bluetooth: Add combined LED trigger for controller power (David Arcari) [1415327]
- [net] bluetooth: Put led_trigger field behind CONFIG_BT_LEDS (David Arcari) [1415327]
- [char] miscdevice: Use module_misc_device() macro (David Arcari) [1415327]
- [kernel] miscdevice: Add helper macro for misc device boilerplate (David Arcari) [1415327]
- [net] bluetooth: Fix hci_sock_recvmsg when MSG_TRUNC is not set (David Arcari) [1415327]
- [net] bluetooth: Fix bt_sock_recvmsg when MSG_TRUNC is not set (David Arcari) [1415327]
- [net] bluetooth: split sk_filter in l2cap_sock_recv_cb (David Arcari) [1415327]
- [net] bluetooth: Fix memory leak at end of hci requests (David Arcari) [1415327]
- [net] mac802154: use rate limited warnings for malformed frames (David Arcari) [1415327]
- [net] mac802154: don't warn on unsupported frames (David Arcari) [1415327]
- [net] mac802154: set phy net namespace for new ifaces (David Arcari) [1415327]
- [bluetooth] btmrvl: reset is_suspending flag in failure path (David Arcari) [1415327]
- [bluetooth] bpa10x: Add support for hci_set_fw_info (David Arcari) [1415327]
- [net] bluetooth: Add debugfs fields for hardware and firmware info (David Arcari) [1415327]
- [lib] kasprintf.c: introduce kvasprintf_const (David Arcari) [1415327]
- [net] bluetooth: Move hci_recv_frame and hci_recv_diag prototypes (David Arcari) [1415327]
- [net] bluetooth: Fix l2cap_sock_setsockopt() with optname BT_RCVMTU (David Arcari) [1415327]
- [kernel] misc: ti-st: Use int instead of fuzzy char for callback status (David Arcari) [1415327]
- [net] bluetooth: Increment management interface revision (David Arcari) [1415327]
- [net] bluetooth: Add Authentication Failed reason to Disconnected Mgmt event (David Arcari) [1415327]
- [netdrv] mrf24j40: avoid uninitialized byte in SPI transfer to radio (David Arcari) [1415327]
- [bluetooth] Add support of 13d3:3490 AR3012 device (David Arcari) [1415327]
- [bluetooth] hci_intel: Remove LPM enabling from setup procedure (David Arcari) [1415327]
- [net] bluetooth: Rename HCI_BREDR into HCI_PRIMARY (David Arcari) [1415327]
- [netdrv] fakelb: allow to run as monitor (David Arcari) [1415327]
- [net] ieee802154: cleanup WARN_ON for fc fetch (David Arcari) [1415327]
- [netdrv] atusb: don't change csma settings while set channel (David Arcari) [1415327]
- [net] 6lowpan: ndisc: set invalid unicast short addr to unspec (David Arcari) [1415327]
- [net] ieee802154: fix skb get fc on big endian (David Arcari) [1415327]
- [net] ieee802154: 6lowpan: fix intra pan id check (David Arcari) [1415327]
- [net] ieee802154: add ieee802154_skb_src_pan helper (David Arcari) [1415327]
- [net] ieee802154: add ieee802154_skb_dst_pan helper (David Arcari) [1415327]
- [bluetooth] btusb: add support for device 0489:e092 (David Arcari) [1415327]
- [bluetooth] btmrvl: fix slab-out-of-bounds access in btmrvl_sdio (David Arcari) [1415327]
- [net] bluetooth: Fix hci_sock_recvmsg return value (David Arcari) [1415327]
- [net] bluetooth: Fix bt_sock_recvmsg return value (David Arcari) [1415327]
- [net] ieee802154: allow netns create of lowpan interface (David Arcari) [1415327]
- [net] ieee802154: add netns support (David Arcari) [1415327]
- [net] nl802154: move PAD to right position (David Arcari) [1415327]
- [net] 6lowpan: ndisc: add missing 802.15.4 only check (David Arcari) [1415327]
- [net] 6lowpan: ndisc: fix double read unlock (David Arcari) [1415327]
- [net] 6lowpan: add support for 802.15.4 short addr handling (David Arcari) [1415327]
- [net] 6lowpan: add support for getting short address (David Arcari) [1415327]
- [net] 6lowpan: introduce 6lowpan-nd (David Arcari) [1415327]
- [net] ipv6: introduce neighbour discovery ops (David Arcari) [1415327]
- [net] ipv6: export several functions (David Arcari) [1415327]
- [net] ndisc: add __ndisc_fill_addr_option function (David Arcari) [1415327]
- [net] ndisc: add __ndisc_opt_addr_data function (David Arcari) [1415327]
- [net] ndisc: add __ndisc_opt_addr_space function (David Arcari) [1415327]
- [net] addrconf: put prefix address add in an own function (David Arcari) [1415327]
- [net] 6lowpan: remove ipv6 module request (David Arcari) [1415327]
- [net] 6lowpan: add 802.15.4 short addr slaac (David Arcari) [1415327]
- [net] 6lowpan: add private neighbour data (David Arcari) [1415327]
- [net] ieee802154: fix logic error in ieee802154_llsec_parse_dev_addr (David Arcari) [1415327]
- [netdrv] ieee802154/adf7242: syntax error ifdef DEBUG (David Arcari) [1415327]
- [bluetooth] Add USB ID 13D3:3487 to ath3k (David Arcari) [1415327]
- [net] bluetooth: fix power_on vs close race (David Arcari) [1415327]
- [bluetooth] hci_intel: Fix null gpio desc pointer dereference (David Arcari) [1415327]
- [bluetooth] btmrvl: add platform specific wakeup interrupt support (David Arcari) [1415327]
- [net] bluetooth: Add defines for SPI and I2C (David Arcari) [1415327]
- [bluetooth] ath3k: Silence uninitialized variable warning (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: update my copyright years for this driver (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: implement .set_cca_mode ops callback (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: implement .set_cca_ed_level ops callback (David Arcari) [1415327]
- [netdrv] ieee802154: atusb: implement .set_csma_params ops callback (David Arcari) [1415327]
- [netdrv] at86rf230: increase sleep to off timings (David Arcari) [1415327]
- [net] 6lowpan: move mac802154 header (David Arcari) [1415327]
- [net] 6lowpan: add lowpan_is_ll function (David Arcari) [1415327]
- [net] 6lowpan: move eui64 uncompress function (David Arcari) [1415327]
- [net] 6lowpan: iphc: remove unnecessary zero data (David Arcari) [1415327]
- [net] 6lowpan: iphc: rename add lowpan prefix (David Arcari) [1415327]
- [net] 6lowpan: move lowpan_802154_dev to 6lowpan (David Arcari) [1415327]
- [net] 6lowpan: change naming for lowpan private data (David Arcari) [1415327]
- [net] ieee802154: 6lowpan: fix short addr hash (David Arcari) [1415327]
- [net] nl802154: avoid address change while running lowpan (David Arcari) [1415327]
- [net] ieee802154: add short address helpers (David Arcari) [1415327]
- [kernel] ieee802154: cleanups for ieee802154.h (David Arcari) [1415327]
- [netdrv] mrf24j40: apply the security-enabled bit on secured outbound frames (David Arcari) [1415327]
- [netdrv] mrf24j40: fix security-enabled processing on inbound frames (David Arcari) [1415327]
- [kernel] ieee802154: add security bit check function (David Arcari) [1415327]
- [bluetooth] hci_bcsp: fix code style (David Arcari) [1415327]
- [netdrv] ieee802154/adf7242: fix memory leak of firmware (David Arcari) [1415327]
- [net] 6lowpan: iphc: fix handling of link-local compression (David Arcari) [1415327]
- [net] bluetooth: Allow setting BT_SECURITY_FIPS with setsockopt (David Arcari) [1415327]
- [bluetooth] hci_ldisc: Fix null pointer derefence in case of early data (David Arcari) [1415327]
- [bluetooth] hci_bcm: Add BCM2E71 ACPI ID (David Arcari) [1415327]
- [net] bluetooth: Ignore unknown advertising packet types (David Arcari) [1415327]
- [net] bluetooth: Fix setting NO_BREDR advertising flag (David Arcari) [1415327]
- [net] ipv6: Add checks for 6LOWPAN ARP type (David Arcari) [1415327]
- [net] tcp: avoid infinite loop in tcp_splice_read() (Davide Caratti) [1430580] {CVE-2017-6214}
- [net] ipv4: keep skb->dst around in presence of IP options (Sabrina Dubroca) [1433201] {CVE-2017-5970}
- [net] neigh: only allow init_net to change the default neigh_parms (Hangbin Liu) [1434277]
- [net] neigh: no need to call lookup_neigh_parms in neigh_parms_alloc (Hangbin Liu) [1434277]
- [net] ipv6: Paritially checksum full MTU frames (Vlad Yasevich) [1420109]
- [net] ipv6: Should use consistent conditional judgement for ip6 fragment between __ip6_append_data and ip6_finish_output (Vlad Yasevich) [1420109]
- [net] udp: disallow UFO for sockets with SO_NO_CHECK option (Vlad Yasevich) [1420109]
- [net] udp: only allow UFO for packets from SOCK_DGRAM sockets (Vlad Yasevich) [1420109]
- [net] ipv6: make ECMP route replacement less greedy (Xin Long) [1430267]
- [net] ipv6: fix multipath route replace error recovery (Xin Long) [1430267]
- [net] ipv6: fix ECMP route replacement (Xin Long) [1430267]
- [net] ipv6: do not delete previously existing ECMP routes if add fails (Xin Long) [1430267]

* Thu Mar 30 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-637.el7]
- [net] flow_dissector: skb_flow_get_be16() can be static (Jonathan Toppins) [1428557]
- [net] flow_dissector: Update pptp handling to avoid null pointer deref. (Jonathan Toppins) [1428557]
- [net] flow dissector: ICMP support (Jonathan Toppins) [1428557]
- [net] flow_dissector: __skb_flow_dissect() must cap its return value (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add enums for encapsulation keys (Jonathan Toppins) [1428557]
- [net] flow_dissector: __skb_get_hash_symmetric arg can be const (Jonathan Toppins) [1428557]
- [net] flow_dissector: fix vlan tag handling (Jonathan Toppins) [1428557]
- [net] flow_dissector: Check skb for VLAN only if skb specified. (Jonathan Toppins) [1428557]
- [net] flow_dissector: rps: Fix uninitialized flow_keys used in __skb_get_hash possibly (Jonathan Toppins) [1428557]
- [net] flow_dissector: rps: Add the const for the parameter of flow_keys_have_l4 (Jonathan Toppins) [1428557]
- [net] flow_dissector: Get vlan priority in addition to vlan id (Jonathan Toppins) [1428557]
- [net] flow_dissector: For stripped vlan, get vlan info from skb->vlan_tci (Jonathan Toppins) [1428557]
- [net] rps: Inspect PPTP encapsulated by GRE to get flow hash (Jonathan Toppins) [1428557]
- [net] pptp: fix byte order warnings (Jonathan Toppins) [1428557]
- [net] packet: Use symmetric hash for PACKET_FANOUT_HASH. (Jonathan Toppins) [1428557]
- [net] flow_dissector: Make dissector_uses_key() and skb_flow_dissector_target() public (Jonathan Toppins) [1428557]
- [net] eth: Pull header from first fragment via eth_get_headlen (Jonathan Toppins) [1428557]
- [net] flow_dissector: Use same pointer for IPv4 and IPv6 addresses (Jonathan Toppins) [1428557]
- [net] flow_dissector: Correctly handle parsing FCoE (Jonathan Toppins) [1428557]
- [net] flow_dissector: Fix fragment handling for header length computation (Jonathan Toppins) [1428557]
- [net] flow_dissector: Check for IP fragmentation even if not using IPv4 address (Jonathan Toppins) [1428557]
- [net] flow_dissector: Copy inner L3 and L4 headers as unaligned on GRE TEB (Jonathan Toppins) [1428557]
- [net] flow_dissector: Fix unaligned access in __skb_flow_dissector when used by eth_get_headlen (Jonathan Toppins) [1428557]
- [net] flow_dissector: Use 'const' where possible. (Jonathan Toppins) [1428557]
- [net] flow_dissector: Fix function argument ordering dependency (Jonathan Toppins) [1428557]
- [net] flow_dissector: Move __get_hash_from_flowi{4, 6} into flow_dissector.c (Jonathan Toppins) [1428557]
- [net] flow_dissector: Don't use bit fields. (Jonathan Toppins) [1428557]
- [net] flow_dissector: Ignore flow dissector return value from ___skb_get_hash (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add control/reporting of encapsulation (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add flag to stop parsing when an IPv6 flow label is seen (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add flag to stop parsing at L3 (Jonathan Toppins) [1428557]
- [net] flow_dissector: Support IPv6 fragment header (Jonathan Toppins) [1428557]
- [net] ipv6: introduce ipv6_authlen and IP6_OFFSET (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add control/reporting of fragmentation (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add flags argument to skb_flow_dissector functions (Jonathan Toppins) [1428557]
- [net] flow_dissector: Jump to exit code in __skb_flow_dissect (Jonathan Toppins) [1428557]
- [net] flowi: Abstract out functions to get flow hash based on flowi (Jonathan Toppins) [1428557]
- [net] Make __skb_set_sw_hash a general function (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add functions to get skb->hash based on flow structures (Jonathan Toppins) [1428557]
- [net] Set sk_txhash from a random number (Jonathan Toppins) [1428557]
- [net] break flow vs skbuff header dependency (Jonathan Toppins) [1428557]
- [net] flow_dissector: Move skb related functions to skbuff.h (Jonathan Toppins) [1428557]
- [net] flow_dissector: Pre-initialize ip_proto in __skb_flow_dissect() (Jonathan Toppins) [1428557]
- [net] flow_dissector: fix ipv6 dst, hop-by-hop and routing ext hdrs (Jonathan Toppins) [1428557]
- [net] flow_dissector: add support for dst, hop-by-hop and routing ext hdrs (Jonathan Toppins) [1428557]
- [net] flow_dissector: Fix MPLS entropy label handling in flow dissector (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add MPLS entropy label in flow_keys (Jonathan Toppins) [1428557]
- [net] mpls: Change reserved label names to be consistent with netbsd (Jonathan Toppins) [1428557]
- [net] mpls: Move reserved label definitions (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add GRE keyid in flow_keys (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add IPv6 flow label to flow_keys (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add VLAN ID to flow_keys (Jonathan Toppins) [1428557]
- [net] flow_dissector: Get rid of IPv6 hash addresses flow keys (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add keys for TIPC address (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add full IPv6 addresses to flow_keys (Jonathan Toppins) [1428557]
- [net] flow_dissector: Get skb hash over flow_keys structure (Jonathan Toppins) [1428557]
- [net] flow_dissector: Remove superfluous setting of key_basic (Jonathan Toppins) [1428557]
- [net] mpls: Add definition for IPPROTO_MPLS (Jonathan Toppins) [1428557]
- [net] flow_dissector: Simplify GRE case in flow_dissector (Jonathan Toppins) [1428557]
- [net] flow_dissector: do not break if ports are not needed in flowlabel (Jonathan Toppins) [1428557]
- [net] flow_dissector: remove bogus return in tipc section (Jonathan Toppins) [1428557]
- [net] flow_dissector: call init_default_flow_dissectors() earlier (Jonathan Toppins) [1428557]
- [net] flow_dissector: change port array into src, dst tuple (Jonathan Toppins) [1428557]
- [net] flow_dissector: introduce support for Ethernet addresses (Jonathan Toppins) [1428557]
- [net] flow_dissector: introduce support for ipv6 addressses (Jonathan Toppins) [1428557]
- [net] flow_dissector: add missing header includes (Jonathan Toppins) [1428557]
- [net] flow_dissector: use programable dissector in skb_flow_dissect and friends (Jonathan Toppins) [1428557]
- [net] flow_dissector: introduce programable flow_dissector (Jonathan Toppins) [1428557]
- [net] flow_dissector: fix doc for skb_get_poff (Jonathan Toppins) [1428557]
- [net] move __skb_tx_hash to dev.c (Jonathan Toppins) [1428557]
- [net] move __skb_get_hash function declaration to flow_dissector.h (Jonathan Toppins) [1428557]
- [net] flow_dissector: fix doc for __skb_get_hash and remove couple of empty lines (Jonathan Toppins) [1428557]
- [net] move *skb_get_poff declarations into correct header (Jonathan Toppins) [1428557]
- [net] flow_dissector: remove unused function flow_get_hlen declaration (Jonathan Toppins) [1428557]
- [net] change name of flow_dissector header to match the .c file name (Jonathan Toppins) [1428557]
- [net] sched: sch_choke: Use flow_keys_digest (Jonathan Toppins) [1428557]
- [net] flow_dissector: Add flow_keys digest (Jonathan Toppins) [1428557]
- [net] sched: Call skb_get_hash_perturb in sch_sfq (Jonathan Toppins) [1428557]
- [net] sched: Call skb_get_hash_perturb in sch_sfb (Jonathan Toppins) [1428557]
- [net] sched: Call skb_get_hash_perturb in sch_fq_codel (Jonathan Toppins) [1428557]
- [net] flow_dissector: add tipc support (Jonathan Toppins) [1428557]
- [net] sched: fix skb->protocol use in case of accelerated vlan path (Jonathan Toppins) [1428557]
- [net] flow_dissector: Fix alignment issue in __skb_flow_get_ports (Jonathan Toppins) [1428557]
- [net] fix comments for __skb_flow_get_ports() (Jonathan Toppins) [1428557]
- [net] flow_dissector: Use IPv6 flow label in flow_dissector (Jonathan Toppins) [1428557]
- [net] Convert uses of __constant_<foo> to <foo> (Jonathan Toppins) [1428557]
- [net] flow_dissector: small optimizations in IPv4 dissect (Jonathan Toppins) [1428557]
- [net] flow_dissector: add 802.1ad support (Jonathan Toppins) [1428557]
- [net] flow_dissector: add support for IPPROTO_IPV6 (Jonathan Toppins) [1428557]
- [net] flow_dissector: clean up IPIP case (Jonathan Toppins) [1428557]

* Thu Mar 30 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-636.el7]
- [scsi] megaraid_sas: Driver version upgrade (Tomas Henzl) [1433861]
- [scsi] megaraid_sas: raid6 also require cpuSel check same as raid5 (Tomas Henzl) [1433861]
- [scsi] megaraid_sas: add correct return type check for ldio hint logic for raid1 (Tomas Henzl) [1433861]
- [scsi] hpsa: fix volume offline state (Joseph Szczypek) [1384611]
- [scsi] hpsa: update version to 3.4.18-0-RH1 (Joseph Szczypek) [1384611]
- [scsi] hpsa: do not timeout reset operations (Joseph Szczypek) [1384611]
- [scsi] hpsa: limit outstanding rescans (Joseph Szczypek) [1384611]
- [scsi] hpsa: update check for logical volume status (Joseph Szczypek) [1384611]
- [scsi] hpsa: remove coalescing settings for ioaccel2 (Joseph Szczypek) [1384611]
- [scsi] hpsa: remove memory allocate failure message (Joseph Szczypek) [1384611]
- [scsi] hpsa: fallback to use legacy REPORT PHYS command (Joseph Szczypek) [1384611]
- [scsi] hpsa: use phN for short hex dumps (Joseph Szczypek) [1384611]
- [scsi] hpsa: add 'ctlr_num' sysfs attribute (Joseph Szczypek) [1384611]
- [scsi] hpsa: use correct DID_NO_CONNECT hostbyte (Joseph Szczypek) [1384611]
- [scsi] hpsa: use bus '3' for legacy HBA devices (Joseph Szczypek) [1384611]
- [scsi] hpsa: correct logical resets (Joseph Szczypek) [1384611]
- [scsi] hpsa: Remove unneeded void pointer cast (Joseph Szczypek) [1384611]
- [scsi] hpsa: correct call to hpsa_do_reset (Joseph Szczypek) [1384611]
- [scsi] hpsa: correct scsi 6byte lba calculation (Joseph Szczypek) [1384611]
- [scsi] hpsa: Check for null devices in ioaccel submission patch (Joseph Szczypek) [1384611]
- [scsi] hpsa: Prevent sending bmic commands to externals (Joseph Szczypek) [1384611]
- [scsi] hpsa: Check for vpd support before sending (Joseph Szczypek) [1384611]
- [scsi] hpsa: Check for null device pointers (Joseph Szczypek) [1384611]
- [scsi] hpsa: Determine device external status earlier (Joseph Szczypek) [1384611]
- [scsi] hpsa: change hpsa_passthru_ioctl timeout (Joseph Szczypek) [1384611]
- [scsi] hpsa: update driver to 3.4.16-0-RH1 (Joseph Szczypek) [1384611]
- [scsi] hpsa: correct handling of HBA device removal (Joseph Szczypek) [1384611]
- [scsi] hpsa: correct ioaccel2 error procecssing (Joseph Szczypek) [1384611]
- [scsi] hpsa: correct ioaccel state change operation (Joseph Szczypek) [1384611]
- [scsi] hpsa: add timeouts for driver initiated commands (Joseph Szczypek) [1384611]
- [scsi] hpsa: add sas_address to sysfs device attibute (Joseph Szczypek) [1384611]
- [scsi] hpsa: correct initialization order issue (Joseph Szczypek) [1384611]
- [scsi] hpsa: set the enclosure identifier to zero (Joseph Szczypek) [1384611]
- [scsi] hpsa: remove function definition for sanitize_inquiry_string (Joseph Szczypek) [1384611]

* Wed Mar 29 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-635.el7]
- [infiniband] ib/hfi1: Process qp wait list in IRQ thread periodically (Don Dutile) [1382806 1417286]
- [infiniband] ib/ipoib: Add destination address when re-queue packet (Don Dutile) [1417286]
- [netdrv] mlx4_core: Use cq quota in SRIOV when creating completion EQs (Don Dutile) [1429188 1417286]
- [uapi] rdma: Don't reference kernel private header from UAPI header (Don Dutile) [1385326 1417286]
- [infiniband] ib/rxe: Fix mem_check_range integer overflow (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Fix resid update (Don Dutile) [1384574 1417286]
- [netdrv] mlx4: Invoke softirqs after napi_reschedule (Don Dutile) [1417286]
- [netdrv] mlx4: Fix memory leak after mlx4_en_update_priv() (Don Dutile) [1385329 1417286]
- [netdrv] mlx4_core: Avoid command timeouts during VF driver device shutdown (Don Dutile) [1385329 1417286 1429188]
- [netdrv] mlx5e: Check ets capability before ets query FW command (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Fix update of hash function/key via ethtool (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Modify TIRs hash only when it's needed (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: E-Switch, Re-enable RoCE on mode change only after FDB destroy (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: E-Switch, Err when retrieving steering name-space fails (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Return EOPNOTSUPP when failing to get steering name-space (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Change ENOTSUPP to EOPNOTSUPP (Don Dutile) [1385330 1417286]
- [infiniband] rdma/cma: Fix unknown symbol when CONFIG_IPV6 is not enabled (Don Dutile) [1417286]
- [infiniband] ib/rxe: Prevent from completer to operate on non valid QP (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Fix rxe dev insertion to rxe_dev_list (Don Dutile) [1384574 1417286]
- [infiniband] ib/umem: Release pid in error and ODP flow (Don Dutile) [1417286]
- [infiniband] rdma/qedr: Dispatch port active event from qedr_add (Don Dutile) [1275823 1417286]
- [infiniband] rdma/qedr: Fix and simplify memory leak in PD alloc (Don Dutile) [1275823 1417286]
- [infiniband] rdma/qedr: Fix RDMA CM loopback (Don Dutile) [1275823 1417286]
- [infiniband] rdma/qedr: Fix formatting (Don Dutile) [1275823 1417286]
- [infiniband] rdma/qedr: Mark three functions as static (Don Dutile) [1275823 1417286]
- [infiniband] rdma/qedr: Don't reset QP when queues aren't flushed (Don Dutile) [1275823 1417286]
- [infiniband] rdma/qedr: Don't spam dmesg if QP is in error state (Don Dutile) [1275823 1417286]
- [infiniband] rdma/qedr: Remove CQ spinlock from CM completion handlers (Don Dutile) [1275823 1417286]
- [infiniband] rdma/qedr: Return max inline data in QP query result (Don Dutile) [1275823 1417286]
- [uapi] rdma/qedr: Add uapi header qedr-abi.h (Don Dutile) [1275823 1417286]
- [infiniband] rdma/qedr: Fix MTU returned from QP query (Don Dutile) [1275823 1417286]
- [rdma] core: Add the function ib_mtu_int_to_enum (Don Dutile) [1417286]
- [uapi] ib/cxgb3: fix misspelling in header guard (Don Dutile) [1417286]
- [infiniband] ib/iser: remove unused variable from iser_conn struct (Don Dutile) [1417286]
- [infiniband] ib/iser: Fix sg_tablesize calculation (Don Dutile) [1417286]
- [infiniband] ib/srp: fix invalid indirect_sg_entries parameter value (Don Dutile) [1417286]
- [infiniband] ib/srp: fix mr allocation when the device supports sg gaps (Don Dutile) [1417286]
- [netdrv] mlx5e: Do not recycle pages from emergency reserve (Don Dutile) [1385330 1417286]
- [netdrv] qed: avoid possible stack overflow in qed_ll2_acquire_connection (Don Dutile) [1275823 1417286]
- [netdrv] mlx5e: Remove unused variable (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Remove unnecessary checks when setting num channels (Don Dutile) [1385330 1417286]
- [netdrv] mlx4_en: Remove unnecessary checks when setting num channels (Don Dutile) [1385329 1417286]
- [netdrv] mlx4_core: Eliminate warning messages for SRQ_LIMIT under SRIOV (Don Dutile) [1385329 1417286]
- [netdrv] mlx4_core: Fix when to save some qp context flags for dynamic VST to VGT transitions (Don Dutile) [1385329 1417286 1429188]
- [netdrv] mlx4_core: Fix racy CQ (Completion Queue) free (Don Dutile) [1385329 1417286 1429188]
- [netdrv] mlx4: do not call napi_schedule() without care (Don Dutile) [1385329 1417286]
- [net] svcrdma: avoid duplicate dma unmapping during error recovery (Don Dutile) [1417286]
- [netdrv] mlx5: Only cancel recovery work when cleaning up device (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Remove WARN_ONCE from adaptive moderation code (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Un-register uplink representor on nic_disable (Don Dutile) [1385330 1417286]
- [infiniband] iw_cxgb4: do not send RX_DATA_ACK CPLs after close/abort (Don Dutile) [1385866 1417286]
- [infiniband] iw_cxgb4: free EQ queue memory on last deref (Don Dutile) [1417517 1385866 1417286]
- [infiniband] iw_cxgb4: refactor sq/rq drain logic (Don Dutile) [1416914 1385866 1417286]
- [kernel] mlx4_core: Fix raw qp flow steering rules under SRIOV (Don Dutile) [1385329 1417286]
- [netdrv] mlx4_en: Fix type mismatch for 32-bit systems (Don Dutile) [1385329 1417286]
- [netdrv] mlx4: Remove BUG_ON from ICM allocation routine (Don Dutile) [1385329 1417286]
- [netdrv] mlx4_en: Fix bad WQE issue (Don Dutile) [1385329 1417286 1429188]
- [netdrv] mlx4_core: Use-after-free causes a resource leak in flow-steering detach (Don Dutile) [1385329 1417286]
- [netdrv] mlx5e: Disable netdev after close (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Don't sync netdev state when not registered (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Check ets capability before initializing ets settings (Don Dutile) [1386547 1385330 1417286]
- [kernel] revert "net/mlx5: Add MPCNT register infrastructure" (Don Dutile) [1385330 1417286]
- [netdrv] revert "net/mlx5e: Expose PCIe statistics to ethtool" (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Prevent setting multicast macs for VFs (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Release FTE lock in error flow (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Mask destination mac value in ethtool steering rules (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Avoid shadowing numa_node (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Cancel recovery work in remove flow (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Check FW limitations on log_max_qp before setting it (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Disable RoCE on the e-switch management port under switchdev mode (Don Dutile) [1385330 1417286]
- [netdrv] mlx4_en: Fix user prio field in XDP forward (Don Dutile) [1385329 1417286]
- [infiniband] ib/rxe: Don't check for null ptr in send() (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Drop future atomic/read packets rather than retrying (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Use BTH_PSN_MASK when ACKing duplicate sends (Don Dutile) [1384574 1417286]
- [infiniband] qedr: Always notify the verb consumer of flushed CQEs (Don Dutile) [1275823 1417286]
- [infiniband] qedr: clear the vendor error field in the work completion (Don Dutile) [1275823 1417286]
- [infiniband] qedr: post_send/recv according to QP state (Don Dutile) [1275823 1417286]
- [infiniband] qedr: ignore inline flag in read verbs (Don Dutile) [1275823 1417286]
- [infiniband] qedr: modify QP state to error when destroying it (Don Dutile) [1275823 1417286]
- [infiniband] qedr: return correct value on modify qp (Don Dutile) [1275823 1417286]
- [infiniband] qedr: return error if destroy CQ failed (Don Dutile) [1275823 1417286]
- [infiniband] qedr: configure the number of CQEs on CQ creation (Don Dutile) [1275823 1417286]
- [rdma] ib/cma: Fix a race condition in iboe_addr_get_sgid() (Don Dutile) [1417286]
- [net] rds: use rb_entry() (Don Dutile) [1417286]
- [netdrv] mlx5: use rb_entry() (Don Dutile) [1385330 1417286]
- [infiniband] ib/rxe: Fix a memory leak in rxe_qp_cleanup() (Don Dutile) [1384574 1417286]
- [netdrv] chelsio: cxgb3: use new api ethtool_{get|set}_link_ksettings (Don Dutile) [1417286]
- [infiniband] ib/mlx4: fix improper return value (Don Dutile) [1385329 1417286]
- [infiniband] ib/ocrdma: fix bad initialization (Don Dutile) [1385876 1417286]
- [infiniband] nes: return value of skb_linearize should be handled (Don Dutile) [1417286]
- [infiniband] ib/core: fix unmap_sg argument (Don Dutile) [1417286]
- [infiniband] ib/mthca: Replace pci_pool_alloc by pci_pool_zalloc (Don Dutile) [1417286]
- [infiniband] mlx5, calc_sq_size(): Make a debug message more informative (Don Dutile) [1385330 1417286]
- [infiniband] mlx5: Remove a set-but-not-used variable (Don Dutile) [1385330 1417286]
- [infiniband] mlx5: Use { } instead of { 0 } to init struct (Don Dutile) [1385330 1417286]
- [infiniband] ib/srp: Make writing the add_target sysfs attr interruptible (Don Dutile) [1417286]
- [infiniband] ib/srp: Make mapping failures easier to debug (Don Dutile) [1417286]
- [infiniband] ib/srp: Make login failures easier to debug (Don Dutile) [1417286]
- [infiniband] ib/srp: Introduce a local variable in srp_add_one() (Don Dutile) [1417286]
- [infiniband] ib/multicast: Check ib_find_pkey() return value (Don Dutile) [1417286]
- [infiniband] ipoib: Avoid reading an uninitialized member variable (Don Dutile) [1417286]
- [infiniband] ib/mad: Fix an array index check (Don Dutile) [1417286]
- [infiniband] ib/mlx4: Rework special QP creation error path (Don Dutile) [1385329 1417286]
- [infiniband] ib/usnic: simplify IS_ERR_OR_NULL to IS_ERR (Don Dutile) [1417286]
- [infiniband] ib/core: Issue DREQ when receiving REQ/REP for stale QP (Don Dutile) [1417286]
- [infiniband] ib/nes: use new api ethtool_{get|set}_link_ksettings (Don Dutile) [1417286]
- [infiniband] ib/isert: do not ignore errors in dma_map_single() (Don Dutile) [1417286]
- [infiniband] rdma: fix buggy code that the compiler warns about (Don Dutile) [1385848 1417286]
- [infiniband] ib/rdmavt: Avoid queuing work into a destroyed cq kthread worker (Don Dutile) [1385848 1417286]
- [infiniband] ib/mlx5: avoid bogus -Wmaybe-uninitialized warning (Don Dutile) [1385330 1417286]
- [uapi] rdma uapi: Use __kernel_sockaddr_storage (Don Dutile) [1417286]
- [infiniband] ib_isert: log the connection reject message (Don Dutile) [1417286]
- [net] rds_rdma: log the connection reject message (Don Dutile) [1417286]
- [infiniband] ib_iser: log the connection reject message (Don Dutile) [1417286]
- [rdma] rdma_cm: add rdma_consumer_reject_data helper function (Don Dutile) [1417286]
- [rdma] rdma_cm: add rdma_is_consumer_reject() helper function (Don Dutile) [1417286]
- [rdma] rdma_cm: add rdma_reject_msg() helper function (Don Dutile) [1417286]
- [infiniband] qedr: remove pointless NULL check in qedr_post_send() (Don Dutile) [1275823 1417286]
- [infiniband] qedr: Use list_move_tail instead of list_del/list_add_tail (Don Dutile) [1275823 1417286]
- [infiniband] qedr: Fix possible memory leak in qedr_create_qp() (Don Dutile) [1275823 1417286]
- [infiniband] qedr: return -EINVAL if pd is null and avoid null ptr dereference (Don Dutile) [1275823 1417286]
- [rdma] ib/mad: Eliminate redundant SM class version defines for OPA (Don Dutile) [1417286]
- [infiniband] ib/mlx5: Properly adjust rate limit on QP state transitions (Don Dutile) [1385326 1385330 1417286]
- [uapi] ib/uverbs: Extend modify_qp and support packet pacing (Don Dutile) [1385326 1417286]
- [rdma] ib/core: Support rate limit for packet pacing (Don Dutile) [1385326 1417286]
- [uapi] ib/mlx5: Report mlx5 packet pacing capabilities when querying device (Don Dutile) [1385326 1385330 1417286]
- [infiniband] ib/mlx5: Support RAW Ethernet when RoCE is disabled (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Rename RoCE related helpers to reflect being Eth ones (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Refactor registration to netdev notifier (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Use u64 for UMR length (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Avoid system crash when enabling many VFs (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Assign SRQ type earlier (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx4: Fix out-of-range array index in destroy qp flow (Don Dutile) [1385329 1417286]
- [infiniband] ib/mlx5: Make create/destroy_ah available to userspace (Don Dutile) [1385330 1417286]
- [uapi] ib/mlx5: Use kernel driver to help userspace create ah (Don Dutile) [1385330 1417286]
- [rdma] ib/core: Let create_ah return extended response to user (Don Dutile) [1417286]
- [uapi] ib/mlx5: Report that device has udata response in create_ah (Don Dutile) [1385330 1417286]
- [rdma] ib/core: Change ib_resolve_eth_dmac to use it in create AH (Don Dutile) [1417286]
- [infiniband] ib/mlx5: Add support to match inner packet fields (Don Dutile) [1386703 1385330 1417286]
- [rdma] ib/core: Introduce inner flow steering (Don Dutile) [1386703 1417286]
- [infiniband] ib/mlx5: Support Vxlan tunneling specification (Don Dutile) [1385330 1417286]
- [uapi] ib/uverbs: Add support for Vxlan protocol (Don Dutile) [1386703 1417286]
- [rdma] ib/core: Align structure ib_flow_spec_type (Don Dutile) [1386703 1417286]
- [rdma] ib/core: Add flow spec tunneling support (Don Dutile) [1386703 1417286]
- [uapi] ib/mlx5: Add support for CQE compressing (Don Dutile) [1385330 1417286]
- [uapi] ib/mlx5: Report mlx5 CQE compression caps during query (Don Dutile) [1385330 1417286]
- [uapi] ib/mlx5: Report mlx5 multi packet WQE caps during query (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Report multi packet WQE capabilities (Don Dutile) [1385330 1417286]
- [infiniband] ib/rxe: Increase max number of completions to 32k (Don Dutile) [1384574 1417286]
- [infiniband] ib/mlx4: Check if GRH is available before using it (Don Dutile) [1385329 1417286]
- [infiniband] ib/mlx4: When no DMFS for IPoIB, don't allow NET_IF QPs (Don Dutile) [1385329 1417286]
- [infiniband] ib/rxe: Hold refs when running tasklets (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Wait for tasklets to finish before tearing down QP (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Fix ref leak in duplicate_request() (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Fix ref leak in rxe_create_qp() (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Add support for IB_CQ_REPORT_MISSED_EVENTS (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Add support for zero-byte operations (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Unblock loopback by moving skb_out increment (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Don't update the response PSN unless it's going forwards (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Advance the consumer pointer before posting the CQE (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Remove buffer used for printing IP address (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Remove unneeded cast in rxe_srq_from_attr() (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Use DEFINE_SPINLOCK() for spinlock (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: avoid putting a large struct rxe_qp on stack (Don Dutile) [1384574 1417286]
- [infiniband] ib/hfi1: Define platform_config_table_limits once (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: constify mmu_notifier_ops structure (Don Dutile) [1382806 1417286]
- [rdma] ib/rdmavt, ib/hfi1, ib/qib: Add inlines for mtu division (Don Dutile) [1382806 1381986 1417286]
- [infiniband] ib/hfi1, ib/qib: use rvt swqe mr deref helper (Don Dutile) [1382806 1381986 1417286]
- [rdma] ib/rdmavt: Add swqe mr deref helper (Don Dutile) [1385848 1417286]
- [infiniband] ib/hfi1: Avoid credit return allocation for cpu-less NUMA nodes (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1, ib/qib: Use new send completion helper (Don Dutile) [1382806 1381986 1417286]
- [rdma] ib/rdmavt: Add a send completion helper (Don Dutile) [1385848 1417286]
- [infiniband] ib/qib: Use standard refcount wrapper for QPs (Don Dutile) [1381986 1417286]
- [infiniband] ib/hfi1: Use reference count wrapper for MRs (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Replace qp->refcount release code with standard driver wrapper (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Preserve external device completed bit (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Remove critical section gap in sc_buffer_alloc() (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Remove usage of qp->s_cur_sge (Don Dutile) [1382806 1417286]
- [infiniband] ib/rdmavt: Add trace of MR segs (Don Dutile) [1385848 1417286]
- [infiniband] ib/hfi1: Add special setting for low power AOC (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Remove definition of unused hfi1_affinity struct (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Remove dependence on qp->s_cur_size (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Show statistics counters under IB stats interface (Don Dutile) [1382806 1417286]
- [infiniband] ib/rdmavt: Fix trace hierarchy (Don Dutile) [1385848 1417286]
- [uapi] ib/hfi1: Disable header suppression for short packets (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Export 8051 memory and LCB registers via debugfs (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Use non-atomic __test_and_clear_bit in hot path (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Fix dc8051 multiple qword memory reads (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Read new EPROM format (Don Dutile) [1382806 1417286]
- [netdrv] mlx5e: use pad format string for dma_addr_t (Don Dutile) [1385330 1417286]
- [netdrv] cxgb4/cxgb4vf: Remove deprecated module parameters (Don Dutile) [1385866 1417286]
- [infiniband] iw_cxgb4: Fix error return code in c4iw_rdev_open() (Don Dutile) [1385866 1417286]
- [crypto] chcr - checking for IS_ERR() instead of NULL (Don Dutile) [1417286]
- [netdrv] mlx4: use reset to set mac header (Don Dutile) [1385329 1417286]
- [infiniband] remove WARN that is not kernel bug (Don Dutile) [1417286]
- [infiniband] ib/ipoib: Remove and fix debug prints after allocation failure (Don Dutile) [1417286]
- [infiniband] ib/isert: Remove and fix debug prints after allocation failure (Don Dutile) [1417286]
- [infiniband] ib/rxe: Remove and fix debug prints after allocation failure (Don Dutile) [1384574 1417286]
- [infiniband] ib/ocrdma: Remove and fix debug prints after allocation failure (Don Dutile) [1385876 1417286]
- [infiniband] ib/usninc: Remove and fix debug prints after allocation failure (Don Dutile) [1417286]
- [infiniband] ib/mthca: Remove debug prints after allocation failure (Don Dutile) [1417286]
- [infiniband] ib/nes: Remove debug prints after allocation failure (Don Dutile) [1417286]
- [infiniband] ib/qib: Remove debug prints after allocation failure (Don Dutile) [1381986 1417286]
- [infiniband] ib/cxgb4: Remove debug prints after allocation failure (Don Dutile) [1385866 1417286]
- [infiniband] ib/cxgb3: Remove debug prints after allocation failure (Don Dutile) [1417286]
- [infiniband] ib/hfi1: Remove debug prints after allocation failure (Don Dutile) [1382806 1417286]
- [infiniband] ib/mlx5: Remove debug prints after allocation failure (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx4: Remove debug prints after allocation failure (Don Dutile) [1385329 1417286]
- [infiniband] ib/core: Release allocated memory in cache setup failure (Don Dutile) [1417286]
- [infiniband] ib/core: Remove debug prints after allocation failure (Don Dutile) [1417286]
- [infiniband] ib/mad: Remove debug prints after allocation failure (Don Dutile) [1417286]
- [netdrv] mlx4: fix use-after-free in mlx4_en_fold_software_stats() (Don Dutile) [1385329 1417286]
- [netdrv] mlx5e: Save the represntor netdevice as part of the representor (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: skip loopback selftest with !CONFIG_INET (Don Dutile) [1386660 1385330 1417286]
- [netdrv] mlx5e: Create UMR MKey per RQ (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Move function mlx5e_create_umr_mkey (Don Dutile) [1385330 1417286]
- [kernel] mlx5e: Implement Fragmented Work Queue (WQ) (Don Dutile) [1368400 1428349 1417286 1385330]
- [net] svcrdma: Further clean-up of svc_rdma_get_inv_rkey() (Don Dutile) [1417286]
- [net] svcrdma: Break up dprintk format in svc_rdma_accept() (Don Dutile) [1417286]
- [net] svcrdma: Remove unused variable in rdma_copy_tail() (Don Dutile) [1417286]
- [net] svcrdma: Remove unused variables in xprt_rdma_bc_allocate() (Don Dutile) [1417286]
- [net] svcrdma: Remove svc_rdma_op_ctxt::wc_status (Don Dutile) [1417286]
- [net] svcrdma: Remove DMA map accounting (Don Dutile) [1417286]
- [net] svcrdma: Remove BH-disabled spin locking in svc_rdma_send() (Don Dutile) [1417286]
- [net] svcrdma: Renovate sendto chunk list parsing (Don Dutile) [1417286]
- [net] svcrdma: Clear xpt_bc_xps in xprt_setup_rdma_bc() error exit arm (Don Dutile) [1417286]
- [netdrv] ethernet :mellanox :mlx5: Replace pci_pool_alloc by pci_pool_zalloc (Don Dutile) [1385330 1417286]
- [netdrv] ethernet :mellanox :mlx4: Replace pci_pool_alloc by pci_pool_zalloc (Don Dutile) [1385329 1417286]
- [kernel] pci: mm: add pci_pool_zalloc() call (Don Dutile) [1417286]
- [crypto] chcr - Move tfm ctx variable to request context (Don Dutile) [1417286]
- [crypto] chcr - Use SHASH_DESC_ON_STACK (Don Dutile) [1417286]
- [crypto] chcr - Adjust Dest. buffer size (Don Dutile) [1417286]
- [crypto] chcr - Calculate Reverse round key in setkey callback (Don Dutile) [1417286]
- [crypto] chcr - Remove dynamic allocation (Don Dutile) [1417286]
- [crypto] chcr - Fixes Unchecked dereference inside function (Don Dutile) [1417286]
- [crypto] chcr - Added new structure chcr_wr (Don Dutile) [1417286]
- [crypto] chcr - Cosmetic change (Don Dutile) [1417286]
- [net] xprtrdma: Relocate connection helper functions (Don Dutile) [1417286]
- [net] xprtrdma: Update dprintk in rpcrdma_count_chunks (Don Dutile) [1417286]
- [net] xprtrdma: Shorten QP access error message (Don Dutile) [1417286]
- [net] xprtrdma: Squelch "max send, max recv" messages at connect time (Don Dutile) [1417286]
- [net] xprtrdma: Update documenting comment (Don Dutile) [1417286]
- [net] xprtrdma: Refactor FRMR invalidation (Don Dutile) [1417286]
- [net] xprtrdma: Avoid calls to ro_unmap_safe() (Don Dutile) [1417286]
- [net] xprtrdma: Address coverity complaint about wait_for_completion() (Don Dutile) [1417286]
- [net] xprtrdma: Support for SG_GAP devices (Don Dutile) [1417286]
- [net] xprtrdma: Make FRWR send queue entry accounting more accurate (Don Dutile) [1417286]
- [net] xprtrdma: Cap size of callback buffer resources (Don Dutile) [1417286]
- [netdrv] mlx4: give precise rx/tx bytes/packets counters (Don Dutile) [1385329 1417286]
- [scsi] srp_transport: Move queuecommand() wait code to SCSI core (Don Dutile) [1417286]
- [netdrv] mlx5e: Add CQE compression user control (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Moves pflags to priv->params (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Add support for loopback selftest (Don Dutile) [1386660 1385330 1417286]
- [netdrv] mlx5e: Add support for ethtool self diagnostics test (Don Dutile) [1386660 1385330 1417286]
- [netdrv] mlx5e: Add DCBX control interface (Don Dutile) [1386547 1385330 1417286]
- [netdrv] mlx5e: ConnectX-4 firmware support for DCBX (Don Dutile) [1386547 1385330 1417286]
- [kernel] mlx5: Add DCBX firmware commands support (Don Dutile) [1386547 1385330 1417286]
- [netdrv] mlx5e: Read ETS settings directly from firmware (Don Dutile) [1386547 1385330 1417286]
- [kernel] mlx5e: Support DCBX CEE API (Don Dutile) [1386547 1385330 1417286]
- [netdrv] mlx5e: Add qos capability check (Don Dutile) [1385330 1417286]
- [netdrv] mlx4: do not use priv->stats_lock in mlx4_en_auto_moderation() (Don Dutile) [1385329 1417286]
- [netdrv] mlx5: remove a duplicate condition (Don Dutile) [1385330 1417286]
- [netdrv] cxgb4: fix memory leak on txq_info (Don Dutile) [1385330 1385866 1417286]
- [netdrv] mlx4: reorganize struct mlx4_en_tx_ring (Don Dutile) [1385330 1385329 1417286]
- [netdrv] mlx5: E-Switch, Add control for inline mode (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Enable to query min inline for a specific vport (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Support VF vport link state control for SRIOV switchdev mode (Don Dutile) [1385330 1417286]
- [netdrv] mlx4: avoid unnecessary dirtying of critical fields (Don Dutile) [1385329 1417286]
- [target] cxgb4: Allocate Tx queues dynamically (Don Dutile) [1385866 1417286]
- [netdrv] mlx5e: Expose PCIe statistics to ethtool (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Add MPCNT register infrastructure (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Set driver version into firmware (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Set driver version infrastructure (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Add port module event counters to ethtool stats (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Add handling for port module event (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Port module event hardware structures (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Make the command interface cache more flexible (Don Dutile) [1385330 1417286]
- [netdrv] mlx4_core: Use device ID defines (Don Dutile) [1385329 1417286]
- [kernel] pci: Add Mellanox device IDs (Don Dutile) [1387321 1417286]
- [net] rds: tcp: Force every connection to be initiated by numerically smaller IP address (Don Dutile) [1417286]
- [net] rds: tcp: Track peer's connection generation number (Don Dutile) [1417286]
- [net] rds: tcp: set RDS_FLAG_RETRANSMITTED in cp_retrans list (Don Dutile) [1417286]
- [netdrv] mlx5e: remove napi_hash_del() calls (Don Dutile) [1385330 1417286]
- [netdrv] mlx4_en: remove napi_hash_del() call (Don Dutile) [1385329 1417286]
- [infiniband] ib/mlx4: Fix port query for 56Gb Ethernet links (Don Dutile) [1385329 1417286]
- [infiniband] ib/mlx4: Put non zero value in max_ah device attribute (Don Dutile) [1385329 1417286]
- [infiniband] ib/mlx4: Handle well-known-gid in mad_demux processing (Don Dutile) [1385329 1417286]
- [rdma] ib/mlx4: Handle IPv4 header when demultiplexing MAD (Don Dutile) [1385329 1417286]
- [infiniband] ib/mlx4: Set traffic class in AH (Don Dutile) [1385329 1417286]
- [infiniband] ib/ipoib: Remove can't use GFP_NOIO warning (Don Dutile) [1362586 1417286]
- [infiniband] ib/mlx5: Limit mkey page size to 2GB (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Fix reported max SGE calculation (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Wait for all async command completions to complete (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Put non zero value in max_ah (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Fix atomic cap in indirect UMR (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Replace numerical constant with predefined MACRO (Don Dutile) [1385330 1417286]
- [infiniband] ib/core: Save QP in ib_flow structure (Don Dutile) [1417286]
- [infiniband] ib/hfi1: Optimize pio_buf and send_context structs (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Get rid of divide in pio buffer allocator (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Add active channel and backplane support for integrated devices (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Optimize devdata cachelines (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Unify access to GUID entries (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Optimize pio cachelines (Don Dutile) [1382806 1417286]
- [rdma] ib/rdmvat: Organize hot path calldowns into a single cacheline (Don Dutile) [1382806 1417286]
- [rdma] ib/hfi1: Optimize lkey validation structures (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Inline sdma_txclean() for verbs pio (Don Dutile) [1382806 1417286]
- [infiniband] ib/hfi1: Add unique txwait_lock for txreq events (Don Dutile) [1382806 1417286]
- [netdrv] mlx5e: Add basic TC tunnel set action for SRIOV offloads (Don Dutile) [1385330 1417286]
- [netdrv] mlx5e: Add ndo_udp_tunnel_add to VF representors (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Support encap id when setting new steering entry (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Add creation flags when adding new flow table (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Check max encap header size capability (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Move alloc/dealloc encap commands declarations to common header file (Don Dutile) [1385330 1417286]
- [net] rds: tcp: start multipath acceptor loop at 0 (Don Dutile) [1417286]
- [net] rds: tcp: report addr/port info based on TCP socket in rds-info (Don Dutile) [1417286]
- [scsi] replace custom approach to hexdump small buffers (Don Dutile) [1417286]
- [netdrv] mlx4_en: Refactor the XDP forwarding rings scheme (Don Dutile) [1385329 1417286]
- [netdrv] mlx4_en: add xdp forwarding and data write support (Don Dutile) [1385329 1417286]
- [netdrv] mlx4_en: Add TX_XDP for CQ types (Don Dutile) [1385329 1417286]
- [netdrv] mlx5e: Add tc support for FWD rule with counter (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Add option to add fwd rule with counter (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Add multi dest support (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Group similer rules under the same fte (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Refactor find_flow_rule (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Use fte status to decide on firmware command (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Don't unlock fte while still using it (Don Dutile) [1385330 1417286]
- [netdrv] mlx5: Add SRIOV VF max rate configuration support (Don Dutile) [1386713 1385330 1417286]
- [netdrv] mlx5: Introduce E-switch QoS management (Don Dutile) [1386713 1385330 1417286]
- [kernel] mlx5: Introduce TSAR manipulation firmware commands (Don Dutile) [1386713 1385330 1417286]
- [netdrv] mlx5: Add ConnectX-5 PCIe 4.0 VF device ID (Don Dutile) [1385330 1387321 1417286]
- [netdrv] mlx5: Fix length of async_event_mask (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Ensure SRQ physical address structure endianness (Don Dutile) [1385330 1417286]
- [kernel] mlx5: Update struct mlx5_ifc_xrqc_bits (Don Dutile) [1385330 1417286]
- [infiniband] ib/mlx5: Skip handling unknown events (Don Dutile) [1385330 1417286]
- [infiniband] ib/ipoib: Flip to new dev walk API (Don Dutile) [1417286]
- [infiniband] ib/core: Flip to the new dev walk API (Don Dutile) [1417286]
- [net] rds: Remove duplicate prefix from rds_conn_path_error use (Don Dutile) [1417286]
- [net] rds: Remove unused rds_conn_error (Don Dutile) [1417286]
- [infiniband] ib/rxe: Fix sending out loopback packet on netdev interface (Don Dutile) [1384574 1417286]
- [infiniband] ib/rxe: Avoid scheduling tasklet for userspace QP (Don Dutile) [1384574 1417286]

* Tue Mar 28 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-634.el7]
- [net] pktgen: add needed include file (Ivan Vecera) [1382040]
- [net] Add net-device param to the get offloaded stats ndo (Ivan Vecera) [1382040]
- [net] core: Correctly iterate over lower adjacency list (Ivan Vecera) [1382040]
- [net] switchdev: Execute bridge ndos only for bridge ports (Ivan Vecera) [1382040]
- [net] Fix compilation error when CLS_ACT isn't set (Ivan Vecera) [1382040]
- [net] Add couple of lower device helper functions (Ivan Vecera) [1382040]
- [net] pktgen: fix UDP checksum computation (Ivan Vecera) [1382040]
- [net] pktgen: Add UDPCSUM flag to support UDP checksums (Ivan Vecera) [1382040]
- [net] devlink: Add E-Switch inline mode control (Ivan Vecera) [1382040]
- [net] neigh: Fix netevent NETEVENT_DELAY_PROBE_TIME_UPDATE notification (Ivan Vecera) [1382040]
- [net] sched: cls_matchall: Fix error path (Ivan Vecera) [1382040]
- [net] sched: matchall: Fix configuration race (Ivan Vecera) [1382040]
- [net] ipv4: fib: Allow for consistent FIB dumping (Ivan Vecera) [1382040]
- [net] ipv4: fib: Convert FIB notification chain to be atomic (Ivan Vecera) [1382040]
- [net] ipv4: fib: Add fib_info_hold() helper (Ivan Vecera) [1382040]
- [net] ipv4: fib: Export free_fib_info() (Ivan Vecera) [1382040]
- [net] neigh: Send netevent after marking neigh as dead (Ivan Vecera) [1382040]
- [net] sched: respect rcu grace period on cls destruction (Ivan Vecera) [1382040]
- [net] fib: introduce FIB info offload flag helpers (Ivan Vecera) [1382040]
- [net] fib: introduce FIB notification infrastructure (Ivan Vecera) [1382040]
- [net] core: Add offload stats to if_stats_msg (Ivan Vecera) [1382040]
- [net] netdevice: Add offload statistics ndo (Ivan Vecera) [1382040]
- [net] sched: act_mirred: Add helper inlines to access tcf_mirred info. (Ivan Vecera) [1382040]
- [net] sched: act_mirred: add helper inlines to access tcf_mirred info (Ivan Vecera) [1382040]
- [net] sched: Add match-all classifier hw offloading. (Ivan Vecera) [1382040]
- [net] sched: introduce Match-all classifier (Ivan Vecera) [1382040]
- [kernel] devlink: fix trace format string (Ivan Vecera) [1382040]
- [kernel] tracing: change owner name to driver name for devlink hwmsg tracepoint (Ivan Vecera) [1382040]
- [net] devlink: add hardware messages tracing facility (Ivan Vecera) [1382040]
- [net] neigh: Send a notification when DELAY_PROBE_TIME changes (Ivan Vecera) [1382040]
- [kernel] list_nulls: fix missing header (Ivan Vecera) [1382040]
- [net] gro: use min_t() in skb_gro_reset_offset() (Slava Shwartsman) [1371812]
- [net] gro: Disable frag0 optimization on IPv6 ext headers (Slava Shwartsman) [1371812]
- [net] gro: Enter slow-path if there is no tailroom (Slava Shwartsman) [1371812]
- [scsi] be2iscsi: do not lock the session->lock spinlock twice (Maurizio Lombardi) [1436346]
- [scsi] be2iscsi: Fix closing of connection (Maurizio Lombardi) [1394016]
- [scsi] be2iscsi: Check tag in beiscsi_mccq_compl_wait (Maurizio Lombardi) [1394016]

* Tue Mar 28 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-633.el7]
- [tools] perf diff: Fix -o/--order option behavior (again) (Jiri Olsa) [1425612]
- [tools] perf diff: Fix segfault on 'perf diff -o N' option (Jiri Olsa) [1425612]
- [tools] perf ftrace: Add ftrace.tracer config option (Jiri Olsa) [1425612]
- [tools] perf tools: Create for_each_event macro for tracepoints iteration (Jiri Olsa) [1425612]
- [tools] tools lib api fs: Add bpf_fs filesystem detector (Jiri Olsa) [1425612]
- [tools] tools perf util: Make rm_rf(path) argument const (Jiri Olsa) [1425612]
- [tools] perf callchain: Reference count maps (Jiri Olsa) [1425612]
- [tools] perf tools: Propagate perf_config() errors (Jiri Olsa) [1425612]
- [tools] perf config: Do not consider an error not to have any perfconfig file (Jiri Olsa) [1425612]
- [tools] perf ftrace: Remove needless code setting default tracer (Jiri Olsa) [1425612]
- [tools] perf ftrace: Make 'function_graph' be the default tracer (Jiri Olsa) [1425612]
- [tools] perf ftrace: Introduce new 'ftrace' tool (Jiri Olsa) [1425612]
- [tools] perf util: Add more debug message on failure path (Jiri Olsa) [1425612]
- [tools] perf util: Save pid-cmdline mapping into tracing header (Jiri Olsa) [1425612]
- [tools] perf scripting perl: Do not die() when not founding event for a type (Jiri Olsa) [1425612]
- [tools] perf probe: Delete an unnecessary assignment in try_to_find_absolute_address() (Jiri Olsa) [1425612]
- [tools] perf probe: Delete an unnecessary check in try_to_find_absolute_address() (Jiri Olsa) [1425612]
- [tools] perf probe: Fix wrong register name for arm64 (Jiri Olsa) [1425612]
- [tools] perf c2c report: Coalesce by default only by pid, iaddr (Jiri Olsa) [1425612]
- [tools] perf c2c report: Display Total records column in offset view (Jiri Olsa) [1425612]
- [tools] perf hists browser: Add e/c hotkeys to expand/collapse callchain for current entry (Jiri Olsa) [1425612]
- [tools] perf hists browser: Put hist_entry folding logic into single function (Jiri Olsa) [1425612]
- [tools] perf unwind: Fix looking up dwarf unwind stack info (Jiri Olsa) [1425612]
- [tools] perf evlist: Fix typo in deliver_sample() (Jiri Olsa) [1425612]
- [tools] perf tools: Move two variables usied in libperf from perf.c (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Show total wait times for summary (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Add --state option (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Account thread wait time separately (Jiri Olsa) [1425612]
- [tools] perf script: Also allow forcing reading of non-root owned files by root (Jiri Olsa) [1425612]
- [tools] perf script: Fix man page about --dump-raw-trace option (Jiri Olsa) [1425612]
- [tools] tools lib subcmd: Fix missing member name (Jiri Olsa) [1425612]
- [tools] perf tools: Remove unneccessary feature-dwarf warning (Jiri Olsa) [1425612]
- [tools] perf pmu: Factor out scale conversion code (Jiri Olsa) [1425612]
- [tools] perf record: Add switch-output time option argument (Jiri Olsa) [1425612]
- [tools] perf record: Add switch-output size warning (Jiri Olsa) [1425612]
- [tools] perf record: Add switch-output size option argument (Jiri Olsa) [1425612]
- [tools] perf record: Change switch-output option to take optional argument (Jiri Olsa) [1425612]
- [tools] perf record: Add struct switch_output (Jiri Olsa) [1425612]
- [tools] perf tools: Add unit_number__scnprintf function (Jiri Olsa) [1425612]
- [tools] perf evlist: Fix typo in perf_evlist__start_workload() (Jiri Olsa) [1425612]
- [tools] perf trace: Allow specifying list of syscalls and events in -e/--expr/--event (Jiri Olsa) [1425612]
- [tools] perf kallsyms: Introduce tool to look for extended symbol information on the running kernel (Jiri Olsa) [1425612]
- [tools] perf machine: Add a kallsyms loading constructor (Jiri Olsa) [1425612]
- [tools] tools lib subcmd: Add missing linux/kernel.h include to subcmd.h (Jiri Olsa) [1425612]
- [tools] perf jvmti: Create libdir directory before installing libperf-jvmti.so (Jiri Olsa) [1425612]
- [tools] perf probe: Fix to probe on gcc generated functions in modules (Jiri Olsa) [1425612]
- [tools] perf probe: Add error checks to offline probe post-processing (Jiri Olsa) [1425612]
- [tools] perf probe: Fix to show correct locations for events on modules (Jiri Olsa) [1425612]
- [tools] perf probe: Fix to probe on gcc generated symbols for offline kernel (Jiri Olsa) [1425612]
- [tools] perf probe: Fix --funcs to show correct symbols for offline module (Jiri Olsa) [1425612]
- [tools] perf symbols: Robustify reading of build-id from sysfs (Jiri Olsa) [1425612]
- [tools] perf tools: Install tools/lib/traceevent plugins with install-bin (Jiri Olsa) [1425612]
- [tools] tools lib traceevent: Fix prev/next_prio for deadline tasks (Jiri Olsa) [1425612]
- [tools] perf record: Fix --switch-output documentation and comment (Jiri Olsa) [1425612]
- [tools] perf record: Make __record_options static (Jiri Olsa) [1425612]
- [tools] tools lib subcmd: Add OPT_STRING_OPTARG_SET option (Jiri Olsa) [1425612]
- [tools] perf probe: Fix to get correct modname from elf header (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Show total scheduling time (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Fix invalid period calculation (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Remove hardcoded 'comm_width' check at print_summary (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Enlarge default 'comm_width' (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Honour 'comm_width' when aligning the headers (Jiri Olsa) [1425612]
- [tools] perf diff: Do not overwrite valid build id (Jiri Olsa) [1425612]
- [tools] perf annotate: Don't throw error for zero length symbols (Jiri Olsa) [1425612]
- [tools] perf bench futex: Fix lock-pi help string (Jiri Olsa) [1425612]
- [tools] perf annotate: Fix jump target outside of function address range (Jiri Olsa) [1425612]
- [tools] perf annotate: Support jump instruction with target as second operand (Jiri Olsa) [1425612]
- [tools] perf record: Force ignore_missing_thread for uid option (Jiri Olsa) [1425612]
- [tools] perf evsel: Allow to ignore missing pid (Jiri Olsa) [1425612]
- [tools] perf thread_map: Add thread_map__remove function (Jiri Olsa) [1425612]
- [tools] perf evsel: Use variable instead of repeating lengthy FD macro (Jiri Olsa) [1425612]
- [tools] perf mem: Fix --all-user/--all-kernel options (Jiri Olsa) [1425612]
- [tools] perf tools: Remove some needless __maybe_unused (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Show callchains for idle stat (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Add -I/--idle-hist option (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Skip non-idle events when necessary (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Save callchain when entering idle (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Introduce struct idle_time_data (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Split is_idle_sample() (Jiri Olsa) [1425612]
- [tools] perf tools: Move headers check into bash script (Jiri Olsa) [1425612]
- [tools] make use of make variable CURDIR instead of calling pwd (Jiri Olsa) [1425612]
- [tools] add more bitmap functions (Jiri Olsa) [1425612]
- [tools] perf tools: Explicitly document that --children is enabled by default (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Cleanup idle_max_cpu handling (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Handle zero sample->tid properly (Jiri Olsa) [1425612]
- [tools] perf callchain: Introduce callchain_cursor__copy() (Jiri Olsa) [1425612]
- [tools] perf sched: Cleanup option processing (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Improve error message when analyzing wrong file (Jiri Olsa) [1425612]
- [tools] perf tools: Move perf build related variables under non fixdep leg (Jiri Olsa) [1425612]
- [tools] perf tools: Force fixdep compilation at the start of the build (Jiri Olsa) [1425612]
- [tools] perf tools: Move PERF-VERSION-FILE target into rules area (Jiri Olsa) [1425612]
- [tools] perf build: Check LLVM version in feature check (Jiri Olsa) [1425612]
- [tools] perf annotate: Show raw form for jump instruction with indirect target (Jiri Olsa) [1425612]
- [tools] perf tools: Add non config targets (Jiri Olsa) [1425612]
- [tools] perf tools: Cleanup build directory before each test (Jiri Olsa) [1425612]
- [tools] perf tools: Move python/perf.so target into rules area (Jiri Olsa) [1425612]
- [tools] perf tools: Move install-gtk target into rules area (Jiri Olsa) [1425612]
- [tools] tools build: Move tabs to spaces where suitable (Jiri Olsa) [1425612]
- [tools] tools build: Make the .cmd file more readable (Jiri Olsa) [1425612]
- [tools] perf build: Add clang and llvm compile and linking support (Jiri Olsa) [1425612]
- [tools] tools build: Add feature detection for clang (Jiri Olsa) [1425612]
- [tools] tools build: Add feature detection for LLVM (Jiri Olsa) [1425612]
- [tools] perf tools: Pass context to perf hook functions (Jiri Olsa) [1425612]
- [tools] tools build: Fix objtool build with clang (Jiri Olsa) [1425612]
- [tools] tools build: Make fixdep parsing wait for last target (Jiri Olsa) [1425612]
- [tools] perf annotate: AArch64 support (Jiri Olsa) [1425612]
- [tools] perf annotate: Use arch->objdump.comment_char in dec__parse() (Jiri Olsa) [1425612]
- [tools] perf report: Add option to specify time window of interest (Jiri Olsa) [1425612]
- [tools] perf kmem: Add option to specify time window of interest (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Add option to specify time window of interest (Jiri Olsa) [1425612]
- [tools] perf script: Add option to specify time window of interest (Jiri Olsa) [1425612]
- [tools] perf tools: Move parse_nsec_time to time-utils.c (Jiri Olsa) [1425612]
- [tools] perf tools: Add time-based utility functions (Jiri Olsa) [1425612]
- [tools] perf script: Add option to stop printing callchain (Jiri Olsa) [1425612]
- [tools] perf kmem stat: Track memory freed (Jiri Olsa) [1425612]
- [tools] perf test: Remove "test" and similar strings from test descriptions (Jiri Olsa) [1425612]
- [tools] perf tools: Introduce perf hooks (Jiri Olsa) [1425612]
- [tools] perf trace: Update tid/pid filtering option to leverage symbol_conf (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Handle cpu migration events (Jiri Olsa) [1425612]
- [tools] perf annotate: Show invalid jump offset in error message (Jiri Olsa) [1425612]
- [tools] perf ui helpline: Provide a printf variant (Jiri Olsa) [1425612]
- [tools] perf tools: Add missing struct definition in probe_event.h (Jiri Olsa) [1425612]
- [tools] perf record: Fix segfault when running with suid and kptr_restrict is 1 (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Enlarge max stack depth by 2 (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Mark schedule function in callchains (Jiri Olsa) [1425612]
- [tools] perf callchain: Add option to skip ignore symbol when printing callchains (Jiri Olsa) [1425612]
- [tools] perf annotate: Initial PowerPC support (Jiri Olsa) [1425612]
- [tools] perf annotate: Improve support for ARM (Jiri Olsa) [1425612]
- [tools] perf annotate: Allow arches to have a init routine and a priv area (Jiri Olsa) [1425612]
- [tools] perf annotate: Introduce alternative method of keeping instructions table (Jiri Olsa) [1425612]
- [tools] perf annotate: Remove duplicate 'name' field from disasm_line (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Add -V/--cpu-visual option (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Add call graph options (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Add -w/--wakeups option (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Add summary options (Jiri Olsa) [1425612]
- [tools] perf sched timehist: Introduce timehist command (Jiri Olsa) [1425612]
- [tools] perf evsel: Support printing callchains with arrows (Jiri Olsa) [1425612]
- [tools] perf symbols: Print symbol offsets conditionally (Jiri Olsa) [1425612]
- [tools] perf c2c: Support cascading options (Jiri Olsa) [1425612]
- [tools] perf c2c report: Display total HITMs on default (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add struct c2c_stats::tot_hitm field (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add -f/--force option (Jiri Olsa) [1425612]
- [tools] perf c2c report: Setup browser after opening perf.data (Jiri Olsa) [1425612]
- [tools] perf tools: Show event fd in debug output (Jiri Olsa) [1425612]
- [tools] tools lib traceevent: Add retrieval of preempt count and latency flags (Jiri Olsa) [1425612]
- [tools] tools lib traceevent: Use USECS_PER_SEC instead of hardcoded number (Jiri Olsa) [1425612]
- [tools] perf annotate: Add per arch instructions annotate handlers (Jiri Olsa) [1425612]
- [tools] perf annotate: Allow arches to specify functions to skip (Jiri Olsa) [1425612]
- [tools] perf annotate: Start supporting cross arch annotation (Jiri Olsa) [1425612]
- [tools] perf report: Show branch info in callchain entry for browser mode (Jiri Olsa) [1425612]
- [tools] perf report: Show branch info in callchain entry for stdio mode (Jiri Olsa) [1425612]
- [tools] perf report: Calculate and return the branch flag counting (Jiri Olsa) [1425612]
- [tools] perf report: Create a symbol_conf flag for showing branch flag counting (Jiri Olsa) [1425612]
- [tools] perf report: Add branch flag to callchain cursor node (Jiri Olsa) [1425612]
- [tools] perf config: Mark where are config items from (user or system) (Jiri Olsa) [1425612]
- [tools] perf config: Add support setting variables in a config file (Jiri Olsa) [1425612]
- [tools] perf config: Validate config variable arguments before trying use them (Jiri Olsa) [1425612]
- [tools] perf config: Add support for getting config key-value pairs (Jiri Olsa) [1425612]
- [tools] perf kvmti: Remove unused Makefile file (Jiri Olsa) [1425612]
- [tools] perf jvmti: Plug compilation into perf build (Jiri Olsa) [1425612]
- [tools] tools build: Add jvmti feature detection support (Jiri Olsa) [1425612]
- [tools] tools build: Add CFLAGS_REMOVE_* support (Jiri Olsa) [1425612]
- [tools] perf intel-pt: Update documentation about context switch events (Jiri Olsa) [1425612]
- [tools] perf callchain: Fixup help/config for no-unwinding (Jiri Olsa) [1425612]
- [tools] perf tools: Add missing object file to the python binding linkage list (Jiri Olsa) [1425612]
- [tools] perf scripting: Don't die if scripting can't be setup, disable it (Jiri Olsa) [1425612]
- [tools] perf scripting: Avoid leaking the scripting_context variable (Jiri Olsa) [1425612]
- [tools] Update asm-generic/mman-common.h copy from the kernel (Jiri Olsa) [1425612]
- [tools] perf list: Support matching by topic (Jiri Olsa) [1425612]
- [tools] perf tools: Introduce timestamp__scnprintf_usec() (Jiri Olsa) [1425612]
- [tools] perf sched map: Always show task comm with -v (Jiri Olsa) [1425612]
- [tools] perf sched map: Apply cpu color when there's an activity (Jiri Olsa) [1425612]
- [tools] perf sched: Make common options cascading (Jiri Olsa) [1425612]
- [tools] tools lib subcmd: Suppport cascading options (Jiri Olsa) [1425612]
- [tools] perf bench futex: Sanitize numeric parameters (Jiri Olsa) [1425612]
- [tools] perf bench futex: Avoid worker cacheline bouncing (Jiri Olsa) [1425612]
- [tools] perf list: Make vendor event matching case insensitive (Jiri Olsa) [1425612]
- [tools] perf trace: Use the syscall raw_syscalls:sys_enter timestamp (Jiri Olsa) [1425612]
- [tools] perf trace: Remove thread_trace->exit_time (Jiri Olsa) [1425612]
- [tools] perf bench futex: Cache align the worker struct (Jiri Olsa) [1425612]
- [tools] perf tools: Use normal error reporting when processing PERF_RECORD_READ events (Jiri Olsa) [1425612]
- [tools] perf tools: Normalize sq_quote_argv() error reporting (Jiri Olsa) [1425612]
- [tools] perf bench mem: Move boilerplate memory allocation to the infrastructure (Jiri Olsa) [1425612]
- [tools] perf trace: Implement --delay (Jiri Olsa) [1425612]
- [tools] perf hists browser: Dynamically change verbosity level (Jiri Olsa) [1425612]
- [tools] perf pmu: Only print Using CPUID message once (Jiri Olsa) [1425612]
- [tools] perf jit: Add jitdump format specification document (Jiri Olsa) [1425612]
- [tools] perf jit: Check JITHEADER_VERSION (Jiri Olsa) [1425612]
- [tools] perf jit: Generate .eh_frame/.eh_frame_hdr in DSO (Jiri Olsa) [1425612]
- [tools] perf jit: Add unwinding support (Jiri Olsa) [1425612]
- [tools] perf jit: Do not assume pgoff is zero (Jiri Olsa) [1425612]
- [tools] perf jit: Make perf skip unknown records (Jiri Olsa) [1425612]
- [tools] perf jit: Remove unecessary padding in jitdump file (Jiri Olsa) [1425612]
- [tools] perf jit: Enable jitdump support without dwarf (Jiri Olsa) [1425612]
- [tools] perf jit: Improve error messages from JVMTI (Jiri Olsa) [1425612]
- [tools] perf jit: Add NT_GNU_BUILD_ID definition for older distros (Jiri Olsa) [1425612]
- [tools] perf jit: Avoid returning garbage for a ret variable (Jiri Olsa) [1425612]
- [tools] perf tools: Implement branch_type event parameter (Jiri Olsa) [1425612]
- [tools] perf record: Improve documentation of event parameters (Jiri Olsa) [1425612]
- [tools] perf header: Display feature name on write failure (Jiri Olsa) [1425612]
- [tools] perf header: Display missing features (Jiri Olsa) [1425612]
- [tools] perf report: Move captured info to generic header info (Jiri Olsa) [1425612]
- [tools] tools lib: Add for_each_clear_bit macro (Jiri Olsa) [1425612]
- [tools] tools lib traceevent: Add version for traceevent shared object (Jiri Olsa) [1425612]
- [tools] tools lib traceevent: Rename LIB_FILE to LIB_TARGET (Jiri Olsa) [1425612]
- [tools] tools lib traceevent: Add do_install_mkdir Makefile function (Jiri Olsa) [1425612]
- [tools] tools lib traceevent: Add install_headers target (Jiri Olsa) [1425612]
- [tools] perf script: Support insn and insnlen (Jiri Olsa) [1425612]
- [tools] perf intel-pt/bts: Report instruction bytes and length in sample (Jiri Olsa) [1425612]
- [tools] perf intel-pt/bts: Tidy instruction buffer size usage (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add --show-all option (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add --no-source option (Jiri Olsa) [1425612]
- [tools] perf c2c: Add man page and credits (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add help windows (Jiri Olsa) [1425612]
- [tools] perf c2c report: Iterate node display in browser (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add support to manage symbol name length (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add cacheline index entry (Jiri Olsa) [1425612]
- [tools] perf c2c report: Recalc width of global sort entries (Jiri Olsa) [1425612]
- [tools] perf c2c report: Allow to set cacheline sort fields (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add support to choose local HITMs (Jiri Olsa) [1425612]
- [tools] perf c2c report: Limit the cachelines table entries (Jiri Olsa) [1425612]
- [tools] perf c2c report: Allow to report callchains (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add c2c related stats stdio output (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add shared cachelines stats stdio output (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add global stats stdio output (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add TUI cacheline browser (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add main TUI browser (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add stdio output support (Jiri Olsa) [1425612]
- [tools] perf c2c report: Set final resort fields (Jiri Olsa) [1425612]
- [tools] perf c2c report: Setup number of header lines for hists (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add src line sort key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add 'cpucnt' sort key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add stats related sort keys (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add 'node' sort key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add 'symbol' and 'dso' sort keys (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add 'tid' sort key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add 'pid' sort key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add dram related sort keys (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add hitm/store percent related sort keys (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add hitm percent sort key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add total loads sort key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add total record sort key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add llc load miss dimension key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add llc and remote loads related dimension keys (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add loads related dimension keys (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add stores related dimension keys (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add hitm related dimension keys (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add 'iaddr' dimension key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add 'offset' dimension key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add 'dcacheline' dimension key (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add header macros (Jiri Olsa) [1425612]
- [tools] perf c2c report: Decode c2c_stats for hist entries (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add cacheline hists processing (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add sample processing (Jiri Olsa) [1425612]
- [tools] perf c2c report: Fallback to standard dimensions (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add sort_entry dimension support (Jiri Olsa) [1425612]
- [tools] perf c2c report: Add dimension support (Jiri Olsa) [1425612]
- [tools] perf c2c: Add report subcommand (Jiri Olsa) [1425612]
- [tools] perf c2c: Add record subcommand (Jiri Olsa) [1425612]
- [tools] perf c2c: Add c2c command (Jiri Olsa) [1425612]
- [tools] perf c2c: Introduce c2c_add_stats function (Jiri Olsa) [1425612]
- [tools] perf c2c: Introduce c2c_decode_stats function (Jiri Olsa) [1425612]
- [tools] perf vendor events: Support couple more POWER8 PVRs in mapfile (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add power8 PMU events (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add WestmereEX V2 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add WestmereEP-SP V2 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add WestmereEP-DP V2 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add SandyBridge V15 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add Silvermont V13 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add Skylake V24 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add NehalemEX V2 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add NehalemEP V2 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add KnightsLanding V9 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add Jaketown V20 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add IvyTown V19 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add IvyBridge V18 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add HaswellX V17 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add Haswell V24 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add Goldmont V8 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add Bonnell V4 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add BroadwellX V10 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add Broadwell V17 event file (Jiri Olsa) [1425612]
- [tools] perf vendor events: Add BroadwellDE V5 event file (Jiri Olsa) [1425612]
- [x86] perf/x86/intel/pt: Add format strings for PTWRITE and power event tracing (Jiri Olsa) [1425612]
- [kernel] perf/core: Try parent PMU first when initializing a child event (Jiri Olsa) [1425612]
- [kernel] perf/core: Optimize event rescheduling on active contexts (Jiri Olsa) [1425612]
- [kernel] perf/core: Don't re-schedule CPU flexible events needlessly (Jiri Olsa) [1425612]
- [kernel] perf/core: Fix PERF_RECORD_MMAP2 prot/flags for anonymous memory (Jiri Olsa) [1425612]
- [kernel] perf/core: Fix use-after-free bug (Jiri Olsa) [1425612]
- [x86] perf/x86/intel: Handle exclusive threadid correctly on CPU hotplug (Jiri Olsa) [1425612]
- [x86] perf/x86: Reject non sampling events with precise_ip (Jiri Olsa) [1425612]
- [kernel] perf/x86/intel: Account interrupts for PEBS errors (Jiri Olsa) [1425612]
- [kernel] perf/core: Fix sys_perf_event_open() vs. hotplug (Jiri Olsa) [1425612]
- [x86] perf/x86/intel: Use ULL constant to prevent undefined shift behaviour (Jiri Olsa) [1425612]
- [x86] perf/x86: Fix overlap counter scheduling bug (Jiri Olsa) [1425612]
- [x86] perf/x86/pebs: Fix handling of PEBS buffer overflows (Jiri Olsa) [1425612]
- [tools] hw_breakpoint: Allow watchpoint of length 3, 5, 6 and 7 (Jiri Olsa) [1425612]
- [x86] perf/x86: Fix exclusion of BTS and LBR for Goldmont (Jiri Olsa) [1425612]

* Mon Mar 27 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-632.el7]
- [crypto] tcrypt - Add new mode for sha512_mb (Herbert Xu) [1379518]
- [crypto] sha512-mb - Crypto computation (x4 AVX2) (Herbert Xu) [1379518]
- [crypto] sha512-mb - Algorithm data structures (Herbert Xu) [1379518]
- [crypto] sha512-mb - submit/flush routines for AVX2 (Herbert Xu) [1379518]
- [crypto] sha512-mb - Enable SHA512 multibuffer support (Herbert Xu) [1379518]
- [crypto] sha512-mb - SHA512 multibuffer job manager and glue code (Herbert Xu) [1379518]
- [crypto] tcrypt - Add speed tests for SHA multibuffer algorithms (Herbert Xu) [1379518]
- [crypto] sha256-mb - Crypto computation (x8 AVX2) (Herbert Xu) [1379518]
- [crypto] sha256-mb - Algorithm data structures (Herbert Xu) [1379518]
- [crypto] sha256-mb - submit/flush routines for AVX2 (Herbert Xu) [1379518]
- [crypto] sha256-mb - Enable multibuffer support (Herbert Xu) [1379518]
- [crypto] sha256-mb - SHA256 multibuffer job manager and glue code (Herbert Xu) [1379518]
- [crypto] sha1-mb - async implementation for sha1-mb (Herbert Xu) [1379518]
- [crypto] sha1-mb - stylistic cleanup (Herbert Xu) [1379518]
- [crypto] sha-mb - Fix load failure (Herbert Xu) [1379518]
- [crypto] mcryptd - Fix load failure (Herbert Xu) [1379518]
- [crypto] sha-mb - mark Multi buffer SHA1 helper cipher (Herbert Xu) [1379518]
- [crypto] tcrypt - print cra driver name in tcrypt tests output (Herbert Xu) [1379518]
- [crypto] tcrypt - Added speed tests for AEAD crypto alogrithms in tcrypt test suite (Herbert Xu) [1379518]
- [crypto] jitterentropy - drop duplicate header module.h (Herbert Xu) [1270982]
- [crypto] jitterentropy - use ktime_get_ns as fallback (Herbert Xu) [1270982]
- [crypto] jitterentropy - remove unnecessary information from a comment (Herbert Xu) [1270982]
- [crypto] jitterentropy - use safe format string parameters (Herbert Xu) [1270982]
- [crypto] jitterentropy - Delete unnecessary checks before the function call "kzfree" (Herbert Xu) [1270982]
- [crypto] jitterentropy - avoid compiler warnings (Herbert Xu) [1270982]
- [crypto] drbg - use pragmas for disabling optimization (Herbert Xu) [1270982]
- [crypto] jitterentropy - remove timekeeping_valid_for_hres (Herbert Xu) [1270982]
- [crypto] jitterentropy - add jitterentropy RNG (Herbert Xu) [1270982]
- [crypto] algif_rng - zeroize buffer with random data (Herbert Xu) [1270982]
- [crypto] algif_rng - fix sparse non static symbol warning (Herbert Xu) [1270982]
- [crypto] algif_rng - enable RNG interface compilation (Herbert Xu) [1270982]
- [crypto] algif_rng - add random number generator support (Herbert Xu) [1270982]
- [crypto] fips - allow tests to be disabled in FIPS mode (Herbert Xu) [1314179]
- [crypto] xts - fix compile errors (Herbert Xu) [1314179]
- [crypto] xts - consolidate sanity check for keys (Herbert Xu) [1314179]
- [crypto] memneq - fix for archs without efficient unaligned access (Herbert Xu) [1314179]
- [crypto] more robust crypto_memneq (Herbert Xu) [1314179]
- [crypto] crypto_memneq - add equality testing of memory regions w/o timing leaks (Herbert Xu) [1314179]
- [crypto] testmgr - Fix GCM test vector IV overrun (Herbert Xu) [1386657]
- [crypto] qat - Fix DMA on stack memory (Herbert Xu) [1364724]
- [crypto] algif_hash - Only export and import on sockets with data (Herbert Xu) [1387632] {CVE-2016-8646}

* Mon Mar 27 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-631.el7]
- [fs] userfaultfd: remove wrong comment from userfaultfd_ctx_get() (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: shmem: use __SetPageSwapBacked in shmem_mcopy_atomic_pte() (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: non-cooperative: userfaultfd_remove revalidate vma in MADV_DONTNEED (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: non-cooperative: fix fork fctx->new memleak (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: shmem: __do_fault requires VM_FAULT_NOPAGE (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: non-cooperative: release all ctx in dup_userfaultfd_complete (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: non-cooperative: robustness check (Andrea Arcangeli) [1373606]
- [kernel] userfaultfd: non-cooperative: rollback userfaultfd_exit (Andrea Arcangeli) [1373606]
- [documentation] userfaultfd: documentation update (Andrea Arcangeli) [1373606]
- [fs] scripts/spelling.txt: add "an user" pattern and fix typo instances (Andrea Arcangeli) [1373606]
- [fs] userfaultfd_copy: return -ENOSPC in case mm has gone (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: mcopy_atomic: return -ENOENT when no compatible VMA found (Andrea Arcangeli) [1373606]
- [kernel] userfaultfd: non-cooperative: add event for exit() notification (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: non-cooperative: add event for memory unmap to mm/fremap.c (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: non-cooperative: add event for memory unmaps (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: non-cooperative: rename *EVENT_MADVDONTNEED to *EVENT_REMOVE (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: non-cooperative: add madvise() event for MADV_REMOVE request (Andrea Arcangeli) [1373606]
- [mm] mprotect: use pmd_trans_unstable instead of taking the pmd_lock (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: hugetlbfs: backport build fixes (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: hugetlbfs: add UFFDIO_COPY support for shared mappings (Andrea Arcangeli) [1373606]
- [uapi] userfaultfd: hugetlbfs: UFFD_FEATURE_MISSING_SHMEM (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: shmem: backport build fixes (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: shmem: avoid a lockup resulting from corrupted page->flags (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: shmem: avoid leaking blocks and used blocks in UFFDIO_COPY (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: shmem: lock the page before adding it to pagecache (Andrea Arcangeli) [1373606]
- [uapi] userfaultfd: shmem: allow registration of shared memory ranges (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: shmem: add userfaultfd hook for shared memory faults (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: shmem: use shmem_mcopy_atomic_pte for shared memory (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: shmem: introduce vma_is_shmem (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: shmem: add shmem_mcopy_atomic_pte for userfaultfd support (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: introduce vma_can_userfault (Andrea Arcangeli) [1373606]
- [uapi] userfaultfd: hugetlbfs: UFFD_FEATURE_MISSING_HUGETLBFS (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: hugetlbfs: reserve count on error in __mcopy_atomic_hugetlb (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: hugetlbfs: gup: support VM_FAULT_RETRY (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: hugetlbfs: userfaultfd_huge_must_wait for hugepmd ranges (Andrea Arcangeli) [1373606]
- [uapi] userfaultfd: hugetlbfs: allow registration of ranges containing huge pages (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: hugetlbfs: add userfaultfd hugetlb hook (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: hugetlbfs: fix __mcopy_atomic_hugetlb retry/error processing (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: hugetlbfs: add __mcopy_atomic_hugetlb for huge page UFFDIO_COPY (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: hugetlbfs: add hugetlb_mcopy_atomic_pte for userfaultfd support (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: hugetlbfs: add copy_huge_page_from_user for hugetlb userfaultfd support (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: non-cooperative: wake userfaults after UFFDIO_UNREGISTER (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: non-cooperative: avoid MADV_DONTNEED race condition (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: non-cooperative: add madvise() event for MADV_DONTNEED request (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: non-cooperative: optimize mremap_userfaultfd_complete() (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: non-cooperative: add mremap() event (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: non-cooperative: dup_userfaultfd: use mm_count instead of mm_users (Andrea Arcangeli) [1373606]
- [kernel] userfaultfd: non-cooperative: Add fork() event (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: non-cooperative: report all available features to userland (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: non-cooperative: add ability to report non-PF events from uffd descriptor (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: non-cooperative: Split the find_userfault() routine (Andrea Arcangeli) [1373606]
- [mm] userfaultfd: use vma_is_anonymous (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: convert BUG() to WARN_ON_ONCE() (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: correct comment about UFFD_FEATURE_PAGEFAULT_FLAG_WP (Andrea Arcangeli) [1373606]
- [uapi] userfaultfd: document _IOR/_IOW (Andrea Arcangeli) [1373606]
- [mm] introduce vma_is_anonymous(vma) helper (Andrea Arcangeli) [1373606]
- [fs] userfaultfd: fix SIGBUS resulting from false rwsem wakeups (Andrea Arcangeli) [1373606]

* Mon Mar 27 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-630.el7]
- [mm] hugetlb.c: fix reservation race when freeing surplus pages (Andrea Arcangeli) [1430172]
- [mm] hugetlb.c: use huge_pte_lock instead of opencoding the lock (Andrea Arcangeli) [1430172]
- [mm] hugetlb.c: use the right pte val for compare in hugetlb_cow (Andrea Arcangeli) [1430172]
- [mm] hugetlb: fix huge page reservation leak in private mapping error paths (Andrea Arcangeli) [1430172]
- [mm] remove unnecessary condition in remove_inode_hugepages (Andrea Arcangeli) [1430172]
- [mm] hugetlb: improve locking in dissolve_free_huge_pages() (Andrea Arcangeli) [1430172]
- [mm] hugetlb: check for reserved hugepages during memory offline (Andrea Arcangeli) [1430172]
- [mm] hugetlb: fix memory offline with hugepage size > memory block size (Andrea Arcangeli) [1430172]
- [mm] hugetlb: fix incorrect hugepages count during mem hotplug (Andrea Arcangeli) [1430172]
- [mm] hugetlb: fix huge_pte_alloc BUG_ON (Andrea Arcangeli) [1430172]
- [mm] hugetlb: avoid soft lockup in set_max_huge_pages() (Andrea Arcangeli) [1430172]
- [mm] hwpoison: remove incorrect comments (Andrea Arcangeli) [1430172]
- [mm] hugetlb: simplify hugetlb unmap (Andrea Arcangeli) [1430172]
- [mm] hugetlb: fix huge page reserve accounting for private mappings (Andrea Arcangeli) [1430172]
- [mm] hugetlb: add same zone check in pfn_range_valid_gigantic() (Andrea Arcangeli) [1430172]
- [mm] hugetlb.c: use first_memory_node (Andrea Arcangeli) [1430172]
- [mm] hugetlb: introduce hugetlb_bad_size() (Andrea Arcangeli) [1430172]
- [mm] hugetlb: optimize minimum size (min_size) accounting (Andrea Arcangeli) [1430172]
- [mm] hugetlb: hugetlb_no_page: rate-limit warning message (Andrea Arcangeli) [1430172]
- [mm] hugetlb.c: fix incorrect proc nr_hugepages value (Andrea Arcangeli) [1430172]
- [fs] hugetlbfs: unmap pages if page fault raced with hole punch update locking (Andrea Arcangeli) [1430172]
- [fs] mm/hugetlbfs: unmap pages if page fault raced with hole punch (Andrea Arcangeli) [1430172]
- [fs] hugetlbfs/inode.c: fix bugs in hugetlb_vmtruncate_list() (Andrea Arcangeli) [1430172]
- [mm] fix locking order in mm_take_all_locks() (Andrea Arcangeli) [1430172]
- [mm] hugetlb.c: fix resv map memory leak for placeholder entries (Andrea Arcangeli) [1430172]
- [mm] hugetlb: fix hugepage memory leak caused by wrong reserve count (Andrea Arcangeli) [1430172]
- [fs] mm/hugetlbfs: fix bugs in fallocate hole punch of areas with holes (Andrea Arcangeli) [1430172]
- [mm] hugetlb: trivial comment fix (Andrea Arcangeli) [1430172]
- [mm] hugetlbfs: optimize when NUMA=n (Andrea Arcangeli) [1430172]
- [mm] hugetlb: use memory policy when available (Andrea Arcangeli) [1430172]
- [mm] hugetlb: make node_hstates array static (Andrea Arcangeli) [1430172]
- [fs] hugetlbfs: add hugetlbfs_fallocate() update locking (Andrea Arcangeli) [1430172]
- [mm] hugetlbfs: add hugetlbfs_fallocate() (Andrea Arcangeli) [1430172]
- [mm] hugetlbfs: New huge_add_to_page_cache helper routine (Andrea Arcangeli) [1430172]
- [mm] hugetlb: alloc_huge_page handle areas hole punched by fallocate (Andrea Arcangeli) [1430172]
- [mm] hugetlb: vma_has_reserves() needs to handle fallocate hole punch (Andrea Arcangeli) [1430172]
- [mm] hugetlbfs: truncate_hugepages() takes a range of pages (Andrea Arcangeli) [1430172]
- [fs] hugetlbfs: hugetlb_vmtruncate_list() needs to take a range to delete (Andrea Arcangeli) [1430172]
- [mm] hugetlb: expose hugetlb fault mutex for use by fallocate (Andrea Arcangeli) [1430172]
- [mm] hugetlb: add region_del() to delete a specific range of entries (Andrea Arcangeli) [1430172]
- [mm] hugetlb: add cache of descriptors to resv_map for region_add (Andrea Arcangeli) [1430172]
- [mm] hugetlb: compute/return the number of regions added by region_add() (Andrea Arcangeli) [1430172]
- [mm] hugetlb.c: make vma_has_reserves() return bool (Andrea Arcangeli) [1430172]
- [mm] hugetlb.c: make vma_shareable() return bool (Andrea Arcangeli) [1430172]
- [mm] hugetlb: handle races in alloc_huge_page and hugetlb_reserve_pages (Andrea Arcangeli) [1430172]
- [mm] hugetlb: document the reserve map/region tracking routines (Andrea Arcangeli) [1430172]
- [mm] hugetlb: introduce minimum hugepage order (Andrea Arcangeli) [1430172]
- [mm] hugetlbfs: accept subpool min_size mount option and setup accordingly (Andrea Arcangeli) [1430172]
- [mm] hugetlbfs: add minimum size accounting to subpools (Andrea Arcangeli) [1430172]
- [mm] hugetlbfs: add minimum size tracking fields to subpool structure (Andrea Arcangeli) [1430172]
- [mm] hugetlb: abort __get_user_pages if current has been oom killed (Andrea Arcangeli) [1430172]
- [mm] hugetlb: close race when setting PageTail for gigantic pages (Andrea Arcangeli) [1430172]
- [mm] hugetlb: fix type of hugetlb_treat_as_movable variable (Andrea Arcangeli) [1430172]
- [mm] hugetlb: move the error handle logic out of normal code path (Andrea Arcangeli) [1430172]
- [mm] hugetlb: use vma_resv_map() map types (Andrea Arcangeli) [1430172]
- [mm] hugetlb: remove resv_map_put (Andrea Arcangeli) [1430172]
- [mm] hugetlb: use already existing interface huge_page_shift (Andrea Arcangeli) [1430172]

* Mon Mar 27 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-629.el7]
- [lib] locking/rwsem: Fix rwsem kABI issues (Waiman Long) [1416924]
- [lib] locking/rwsem: Scan the wait_list for readers only once (Waiman Long) [1416924]
- [lib] locking/rwsem: Return void in __rwsem_mark_wake() (Waiman Long) [1416924]
- [lib] locking/rwsem: Streamline the rwsem_optimistic_spin() code (Waiman Long) [1416924]
- [lib] locking/rwsem: Improve reader wakeup code (Waiman Long) [1416924]
- [kernel] locking/rwsem: Protect all writes to owner by WRITE_ONCE() (Waiman Long) [1416924]
- [lib] locking/rwsem: Add reader-owned state to the owner field (Waiman Long) [1416924]
- [asm-generic] locking/rwsem: Remove rwsem_atomic_add() and rwsem_atomic_update() (Waiman Long) [1416924]
- [lib] locking/rwsem: Convert sem->count to 'atomic_long_t' (Waiman Long) [1416924]
- [lib] locking/rwsem: Optimize write lock by reducing operations in slowpath (Waiman Long) [1416924]
- [lib] locking/rwsem: Rework zeroing reader waiter->task (Waiman Long) [1416924]
- [lib] locking/rwsem: Enable lockless waiter wakeup(s) (Waiman Long) [1416924]
- [lib] locking/rwsem: Reduce spinlock contention in wakeup after up_read()/up_write() (Waiman Long) [1416924]
- [lib] locking/rwsem: Fix lock optimistic spinning when owner is not running (Waiman Long) [1416924]
- [lib] locking: Remove ACCESS_ONCE() usage (Waiman Long) [1416924]
- [lib] locking/rwsem: Check for active lock before bailing on spinning (Waiman Long) [1416924]
- [lib] locking/rwsem: Avoid deceiving lock spinners (Waiman Long) [1416924]
- [lib] locking/rwsem: Set lock ownership ASAP (Waiman Long) [1416924]
- [lib] locking/rwsem: Document barrier need when waking tasks (Waiman Long) [1416924]
- [lib] locking/rwsem: Use task->state helpers (Waiman Long) [1416924]
- [kernel] locking/mcs: Better differentiate between MCS variants (Waiman Long) [1416924]
- [lib] locking/rwsem: Avoid double checking before try acquiring write lock (Waiman Long) [1416924]
- [lib] locking/rwsem: Move EXPORT_SYMBOL() lines to follow function definition (Waiman Long) [1416924]
- [lib] locking/rwsem: Add CONFIG_RWSEM_SPIN_ON_OWNER (Waiman Long) [1416924]
- [kernel] locking/rwsem: Reduce the size of struct rw_semaphore (Waiman Long) [1416924]
- [kernel] locking/spinlocks/mcs: Micro-optimize osq_unlock() (Waiman Long) [1416924]
- [lib] locking/spinlocks/mcs: Introduce and use init macro and function for osq locks (Waiman Long) [1416924]
- [lib] locking/spinlocks/mcs: Convert osq lock to atomic_t to reduce overhead (Waiman Long) [1416924]
- [kernel] locking/spinlocks/mcs: Rename optimistic_spin_queue() to optimistic_spin_node() (Waiman Long) [1416924]
- [lib] locking/rwsem: Allow conservative optimistic spinning when readers have lock (Waiman Long) [1416924]
- [lib] locking/rwsem: Fix checkpatch.pl warnings (Waiman Long) [1416924]
- [kernel] locking/rwsem: Fix warnings for CONFIG_RWSEM_GENERIC_SPINLOCK (Waiman Long) [1416924]
- [lib] locking/rwsem: Support optimistic spinning (Waiman Long) [1416924]
- [lib] rwsem: Add comments to explain the meaning of the rwsem's count field (Waiman Long) [1416924]
- [lib] asmlinkage: Mark rwsem functions that can be called from assembler asmlinkage (Waiman Long) [1416924]

* Fri Mar 24 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-628.el7]
- [md] dm cache metadata: fix metadata2 format's blocks_are_clean_separate_dirty (Mike Snitzer) [1434155]
- [pci] hv: Use device serial number as PCI domain (Vitaly Kuznetsov) [1429743]
- [pci] hv: Fix wslot_to_devfn() to fix warnings on device removal (Vitaly Kuznetsov) [1429743]
- [net] bridge: netlink: call br_changelink() during br_dev_newlink() (Ivan Vecera) [1433293]
- [net] Reduce queue allocation to one in kdump kernel (Sai Vemuri) [1379762]
- [net] sched: Reflect HW offload status (Ivan Vecera) [1390693]
- [net] sched: cls_u32: be more strict about skip-sw flag (Ivan Vecera) [1390693]
- [net] sched: fix a typo in tc_for_each_action() (Ivan Vecera) [1390693]
- [net] sched: act_gact: Update statistics when offloaded to hardware (Ivan Vecera) [1390693]
- [net] sched: Enable netdev drivers to update statistics of offloaded actions (Ivan Vecera) [1390693]
- [net] sched: cls_u32: Add support for skip-sw flag to tc u32 classifier. (Ivan Vecera) [1390693]
- [net] sched: Move TCA_CLS_FLAGS_SKIP_HW to uapi header file. (Ivan Vecera) [1390693]
- [net] sched: act_skbedit: Utility functions for mark action (Ivan Vecera) [1390693]
- [net] sched: Macro instead of CONFIG_NET_CLS_ACT ifdef (Ivan Vecera) [1390693]
- [net] sched: cls_u32 add bit to specify software only rules (Ivan Vecera) [1390693]
- [net] sched: cls_u32: move TC offload feature bit into cls_u32 offload logic (Ivan Vecera) [1390693]
- [net] sched: consolidate offload decision in cls_u32 (Ivan Vecera) [1390693]
- [net] sched: tc: helper functions to query action types (Ivan Vecera) [1390693]
- [net] sched: add cls_u32 offload hooks for netdevs (Ivan Vecera) [1390693]
- [net] sched: avoid calling tcf_unbind_filter() in call_rcu callback (Ivan Vecera) [1390693]
- [net] sched: cls_u32 changes to knode must appear atomic to readers (Ivan Vecera) [1390693]
- [net] sched: cls_u32: fix missed pcpu_success free_percpu (Ivan Vecera) [1390693]
- [net] sched: cls_u32: add missing rcu_assign_pointer and annotation (Ivan Vecera) [1390693]
- [x86] platform/uv/bau: Fix HUB errors by remove initial write to sw-ack register (Frank Ramsay) [1422564]
- [x86] platform/uv/bau: Implement uv4_wait_completion with read_status (Frank Ramsay) [1422564]
- [x86] platform/uv/bau: Add wait_completion to bau_operations (Frank Ramsay) [1422564]
- [x86] platform/uv/bau: Add status mmr location fields to bau_control (Frank Ramsay) [1422564]
- [x86] platform/uv/bau: Cleanup bau_operations declaration and instances (Frank Ramsay) [1422564]
- [x86] platform/uv/bau: Add payload descriptor qualifier (Frank Ramsay) [1422564]
- [x86] platform/uv/bau: Add uv_bau_version enumerated constants (Frank Ramsay) [1422564]
- [x86] platform: Remove warning message for duplicate NMI handlers (Frank Ramsay) [1433021]
- [s390] vmlogrdr: fix IUCV buffer allocation (Hendrik Brueckner) [1431699]
- [s390] dcssblk: fix device size calculation in dcssblk_direct_access() (Hendrik Brueckner) [1431700]
- [tools] power turbostat: Support Knights Mill (KNM) (Steve Best) [1381293]
- [vhost] lockless enqueuing (Wei Xu) [1401436]
- [vhost] simplify work flushing (Wei Xu) [1401436]
- [netdrv] i40e: don't add more vectors to num_lan_msix than number of CPUs (Stefan Assmann) [1396127]
- [netdrv] bonding: add 802.3ad support for 25G speeds (Jarod Wilson) [1431202]
- [powercap] rapl: Add Knights Mill CPUID (Steve Best) [1381291]
- [wireless] Update rt2x00 driver to work with cfg80211 from linux-4.11-rc1 (Stanislaw Gruszka) [1421597]
- [wireless] Update mwifiex driver to compile with cfg80211 from linux-4.11-rc1 (Stanislaw Gruszka) [1421597]
- [wireless] Update brcmfmac driver to compile with cfg80211 from linux-4.11-rc1 (Stanislaw Gruszka) [1421597]
- [wireless] Update iwlegacy driver to compile with cfg80211 from linux-4.11-rc1 (Stanislaw Gruszka) [1421597]
- [wireless] Backport iwlwifi driver from linux-4.11-rc1 (Stanislaw Gruszka) [1387986 1385917 1385746 1351045 1421597]
- [wireless] Backport wil6210 driver from linux-4.11-rc1 (Stanislaw Gruszka) [1421597]
- [wireless] Backport ath10k driver from linux-4.11-rc1 (Stanislaw Gruszka) [1385738 1351053 1351049 1421597]
- [wireless] Backport ath9k driver from linux-4.11-rc1 (Stanislaw Gruszka) [1421597]
- [wireless] Backport net/mac80211 from linux-4.11-rc1 (Stanislaw Gruszka) [1421597]
- [wireless] Backport net/wireless from linux-4.11-rc1 (Stanislaw Gruszka) [1421597]

* Fri Mar 24 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-627.el7]
- [staging] usbip: remove staged driver (Torez Smith) [1383823]
- [netdrv] sierra_net: Skip validating irrelevant fields for IDLE LSIs (Torez Smith) [1383823]
- [netdrv] sierra_net: Add support for IPv6 and Dual-Stack Link Sense Indications (Torez Smith) [1383823]
- [netdrv] catc: Use heap buffer for memory size test (Torez Smith) [1383823]
- [netdrv] catc: Combine failure cleanup code in catc_probe() (Torez Smith) [1383823]
- [netdrv] rtl8150: Use heap buffers for all register access (Torez Smith) [1383823]
- [netdrv] pegasus: Use heap buffers for all register access (Torez Smith) [1383823]
- [usb] serial: pl2303: add ATEN device ID (Torez Smith) [1383823]
- [netdrv] r8152: check rx after napi is enabled (Torez Smith) [1383823]
- [netdrv] r8152: re-schedule napi for tx (Torez Smith) [1383823]
- [netdrv] r8152: avoid start_xmit to schedule napi when napi is disabled (Torez Smith) [1383823]
- [netdrv] r8152: avoid start_xmit to call napi_schedule during autosuspend (Torez Smith) [1383823]
- [usb] Add quirk for WORLDE easykey.25 MIDI keyboard (Torez Smith) [1383823]
- [netdrv] qmi_wwan/cdc_ether: add device ID for HP lt2523 (Novatel E371) WWAN card (Torez Smith) [1383823]
- [netdrv] r8152: don't execute runtime suspend if the tx is not empty (Torez Smith) [1383823]
- [usb] serial: option: add device ID for HP lt2523 (Novatel E371) (Torez Smith) [1383823]
- [netdrv] r8152: fix rtl8152_post_reset function (Torez Smith) [1383823]
- [usb] serial: qcserial: add Dell DW5570 QDL (Torez Smith) [1383823]
- [netdrv] r8152: fix the sw rx checksum is unavailable (Torez Smith) [1383823]
- [usb] xhci: fix deadlock at host remove by running watchdog correctly (Torez Smith) [1383823]
- [usb] serial: ch341: fix control-message error handling (Torez Smith) [1383823]
- [netdrv] r8152: fix rx issue for runtime suspend (Torez Smith) [1383823]
- [netdrv] r8152: split rtl8152_suspend function (Torez Smith) [1383823]
- [usb] wusbcore: Fix one more crypto-on-the-stack bug (Torez Smith) [1383823]
- [usb] serial: kl5kusb105: fix line-state error handling (Torez Smith) [1383823]
- [usb] serial: ch341: fix baud rate and line-control handling (Torez Smith) [1383823]
- [usb] serial: ch341: fix line settings after reset-resume (Torez Smith) [1383823]
- [usb] serial: ch341: fix open error handling (Torez Smith) [1383823]
- [usb] serial: ch341: fix modem-control and B0 handling (Torez Smith) [1383823]
- [usb] serial: ch341: fix open and resume after B0 (Torez Smith) [1383823]
- [usb] serial: ch341: fix initial modem-control state (Torez Smith) [1383823]
- [usb] fix problems with duplicate endpoint addresses (Torez Smith) [1383823]
- [usb] storage: unusual_uas: Add JMicron JMS56x to unusual device (Torez Smith) [1383823]
- [usb] hub: Move hub_port_disable() to fix warning if PM is disabled (Torez Smith) [1383823]
- [netdrv] usb: asix_devices: add .reset_resume for USB PM (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: fix NULL-deref at open (Torez Smith) [1383823]
- [usb] serial: spcp8x5: fix NULL-deref at open (Torez Smith) [1383823]
- [usb] serial: quatech2: fix sleep-while-atomic in close (Torez Smith) [1383823]
- [usb] serial: pl2303: fix NULL-deref at open (Torez Smith) [1383823]
- [usb] serial: oti6858: fix NULL-deref at open (Torez Smith) [1383823]
- [usb] serial: omninet: fix NULL-derefs at open and disconnect (Torez Smith) [1383823]
- [usb] serial: mos7840: fix misleading interrupt-URB comment (Torez Smith) [1383823]
- [usb] serial: mos7840: remove unused write URB (Torez Smith) [1383823]
- [usb] serial: mos7840: fix NULL-deref at open (Torez Smith) [1383823]
- [usb] serial: mos7720: remove obsolete port initialisation (Torez Smith) [1383823]
- [usb] serial: mos7720: fix parallel probe (Torez Smith) [1383823]
- [usb] serial: mos7720: fix parport use-after-free on probe errors (Torez Smith) [1383823]
- [usb] serial: mos7720: fix use-after-free on probe errors (Torez Smith) [1383823]
- [usb] serial: mos7720: fix NULL-deref at open (Torez Smith) [1383823]
- [usb] serial: kobil_sct: fix NULL-deref in write (Torez Smith) [1383823]
- [usb] serial: keyspan_pda: verify endpoints at probe (Torez Smith) [1383823]
- [usb] serial: iuu_phoenix: fix NULL-deref at open (Torez Smith) [1383823]
- [usb] serial: io_ti: bind to interface after fw download (Torez Smith) [1383823]
- [usb] serial: io_ti: fix I/O after disconnect (Torez Smith) [1383823]
- [usb] serial: io_ti: fix another NULL-deref at open (Torez Smith) [1383823]
- [usb] serial: io_ti: fix NULL-deref at open (Torez Smith) [1383823]
- [usb] serial: io_edgeport: fix NULL-deref at open (Torez Smith) [1383823]
- [usb] serial: garmin_gps: fix memory leak on failed URB submit (Torez Smith) [1383823]
- [usb] serial: cyberjack: fix NULL-deref at open (Torez Smith) [1383823]
- [usb] host: xhci: handle COMP_STOP from SETUP phase too (Torez Smith) [1383823]
- [usb] xhci: apply XHCI_PME_STUCK_QUIRK to Intel Apollo Lake (Torez Smith) [1383823]
- [usb] xhci: hold lock over xhci_abort_cmd_ring() (Torez Smith) [1383823]
- [usb] xhci: Handle command completion and timeout race (Torez Smith) [1383823]
- [usb] host: xhci: Fix possible wild pointer when handling abort command (Torez Smith) [1383823]
- [usb] xhci: fix possible wild pointer (Torez Smith) [1383823]
- [usb] return error code when platform_get_irq fails (Torez Smith) [1383823]
- [usb] xhci: fix return value of xhci_setup_device() (Torez Smith) [1383823]
- [usb] xhci: free xhci virtual devices with leaf nodes first (Torez Smith) [1383823]
- [usb] serial: option: add dlink dwm-158 (Torez Smith) [1383823]
- [usb] serial: option: add support for Telit LE922A PIDs 0x1040, 0x1041 (Torez Smith) [1383823]
- [netdrv] lan78xx: add LAN7801 MAC only support (Torez Smith) [1383823]
- [kernel] usb: cdc_mbim: add quirk for supporting Telit LE922A (Torez Smith) [1383823]
- [usb] misc: rio500: fix result type for error message (Torez Smith) [1383823]
- [usb] core: usbport: Use proper LED API to fix potential crash (Torez Smith) [1383823]
- [netdrv] usb: set error code when usb_alloc_urb fails (Torez Smith) [1383823]
- [kernel] usb: hcd.h: construct hub class request constants from simpler constants (Torez Smith) [1383823]
- [usb] cdc-acm: add device id for GW Instek AFG-125 (Torez Smith) [1383823]
- [kernel] fsl/usb: Workarourd for USB erratum-A005697 (Torez Smith) [1383823]
- [usb] hub: Wait for connection to be reestablished after port reset (Torez Smith) [1383823]
- [netdrv] usb: qmi_wwan: add support for Telit LE922A PID 0x1040 (Torez Smith) [1383823]
- [netdrv] cdc_ether: Fix handling connection notification (Torez Smith) [1383823]
- [netdrv] asix: Fix AX88772_suspend() USB vendor commands failure issues (Torez Smith) [1383823]
- [usb] serial: kl5kusb105: abort on open exception path (Torez Smith) [1383823]
- [usb] serial: kl5kusb105: fix open error path (Torez Smith) [1383823]
- [usb] fix improper return value when kzalloc fails (Torez Smith) [1383823]
- [usb] return correct errno on failures (Torez Smith) [1383823]
- [usb] return correct errno code when krealloc fails (Torez Smith) [1383823]
- [usb] ohci: use dma_pool_zalloc (Torez Smith) [1383823]
- [usb] serial: cp210x: use tcflag_t to fix incompatible pointer type (Torez Smith) [1383823]
- [usb] cdc-acm: handle read pipe errors (Torez Smith) [1383823]
- [usb] cdc-acm: remove is_int_ep from acm structure (Torez Smith) [1383823]
- [usb] cdc-acm: store in and out pipes in acm structure (Torez Smith) [1383823]
- [usb] cdc-acm: refactor killing urbs (Torez Smith) [1383823]
- [usb] cdc-acm: avoid interface_to_usbdev call (Torez Smith) [1383823]
- [usb] cdc-acm: reindent log messages (Torez Smith) [1383823]
- [usb] core: urb make use of usb_endpoint_maxp_mult (Torez Smith) [1383823]
- [usb] hub: Fix auto-remount of safely removed or ejected USB-3 devices (Torez Smith) [1383823]
- [usb] serial: cp210x: add ID for the Zone DPMX (Torez Smith) [1383823]
- [netdrv] usb: lan78xx: Utilize phy_ethtool_nway_reset (Torez Smith) [1383823]
- [usb] Fix USB CB/CBI storage devices with CONFIG_VMAP_STACK=y (Torez Smith) [1383823]
- [usb] xhci-mem: use passed in GFP flags instead of GFP_KERNEL (Torez Smith) [1383823]
- [usb] xhci: move slot_id from xhci_hcd to xhci_command structure (Torez Smith) [1383823]
- [usb] xhci: remove the use of xhci->addr_dev (Torez Smith) [1383823]
- [usb] xhci: cleanup cmd_completion in xhci_virt_device (Torez Smith) [1383823]
- [usb] xhci: add helper to get the endpoint state of a endpoint context (Torez Smith) [1383823]
- [usb] xhci: clean up error_bitmask usage (Torez Smith) [1383823]
- [usb] xhci: Remove duplicate xhci urb giveback functions (Torez Smith) [1383823]
- [usb] xhci: Giveback urb in finish_td directly (Torez Smith) [1383823]
- [usb] xhci: refactor handle_tx_event() urb giveback (Torez Smith) [1383823]
- [usb] xhci: fix non static symbol warning (Torez Smith) [1383823]
- [usb] xhci: cleanup and refactor td_to_noop() (Torez Smith) [1383823]
- [usb] xhci: refactor and cleanup process_isoc_td() (Torez Smith) [1383823]
- [usb] xhci: rename endpoint related trb variables (Torez Smith) [1383823]
- [usb] xhci: cleanup and refactor process_bulk_intr_td() (Torez Smith) [1383823]
- [usb] xhci: cleanup and refactor process_ctrl_td() (Torez Smith) [1383823]
- [usb] xhci: remove extra URB_SHORT_NOT_OK checks in xhci, core handles most cases (Torez Smith) [1383823]
- [usb] xhci: add trb_is_noop() helper function (Torez Smith) [1383823]
- [usb] xhci: use trb helper functions when possible (Torez Smith) [1383823]
- [usb] xhci: don't try to reset the host if it is unaccessible (Torez Smith) [1383823]
- [usb] xhci: cleanup error message if halting the host failed (Torez Smith) [1383823]
- [usb] xhci: remove unnecessary xhci_quiesce call before xhci_halt (Torez Smith) [1383823]
- [netdrv] r8152: Fix error path in open function (Torez Smith) [1383823]
- [usb] uhci: report non-PME wakeup signalling for Intel hardware (Torez Smith) [1383823]
- [usb] serial: fix invalid user-pointer checks (Torez Smith) [1383823]
- [usb] cdc-acm: use get_icount tty operation (Torez Smith) [1383823]
- [usb] cdc-acm: fix invalid user-pointer check (Torez Smith) [1383823]
- [usb] cdc-acm: fix TIOCMIWAIT (Torez Smith) [1383823]
- [netdrv] net driver: Add Cypress GX3 VID=04b4 PID=3610 (Torez Smith) [1383823]
- [usb] serial: ftdi_sio: add support for TI CC3200 LaunchPad (Torez Smith) [1383823]
- [usb] storage: drop freezer.h usage (Torez Smith) [1383823]
- [usb] wusbcore: wusbhc: use permission-specific DEVICE_ATTR variants (Torez Smith) [1383823]
- [usb] wusbcore: dev-sysfs: use permission-specific DEVICE_ATTR variants (Torez Smith) [1383823]
- [usb] cdc-acm: fix uninitialized variable (Torez Smith) [1383823]
- [usb] misc: usbtest: remove unnecessary & operation (Torez Smith) [1383823]
- [usb] host: ehci: remove unnecessary max_packet() macro (Torez Smith) [1383823]
- [usb] core: endpoint: remove unnecessary & operation (Torez Smith) [1383823]
- [usb] core: devices: remove unnecessary & operation (Torez Smith) [1383823]
- [usb] host: xhci: purge GET_MAX_PACKET() (Torez Smith) [1383823]
- [uapi] usb: ch9: make usb_endpoint_maxp() return only packet size (Torez Smith) [1383823]
- [usb] misc: usbtest: make use of new usb_endpoint_maxp_mult() (Torez Smith) [1383823]
- [usb] host: xhci: make use of new usb_endpoint_maxp_mult() (Torez Smith) [1383823]
- [usb] host: ehci: make use of new usb_endpoint_maxp_mult() (Torez Smith) [1383823]
- [usb] core: devices: make use of new usb_endpoint_maxp_mult() (Torez Smith) [1383823]
- [netdrv] lan78xx: Use irq_domain for phy interrupt from USB Int. EP (Torez Smith) [1383823]
- [uapi] usb: add helper to extract bits 12:11 of wMaxPacketSize (Torez Smith) [1383823]
- [netdrv] r8152: Fix broken RX checksums (Torez Smith) [1383823]
- [usb] core: add missing license information to some files (Torez Smith) [1383823]
- [netdrv] kalmia: avoid potential uninitialized variable use (Torez Smith) [1383823]
- [usb] xhci-mtk: make IPPC register optional (Torez Smith) [1383823]
- [usb] ohci: make ohci-da8xx a separate driver (Torez Smith) [1383823]
- [usb] core: Added devspec sysfs entry for devices behind the usb hub (Torez Smith) [1383823]
- [kernel] tty: vgacon+sisusb, move scrolldelta to a common helper (Torez Smith) [1383823]
- [usb] serial: ch341: add debug output for chip version (Torez Smith) [1383823]
- [usb] serial: ch341: add support for parity, frame length, stop bits (Torez Smith) [1383823]
- [usb] serial: ch341: reinitialize chip on reconfiguration (Torez Smith) [1383823]
- [usb] serial: ch341: add register and USB request definitions (Torez Smith) [1383823]
- [usb] ohci-da8xx: Remove code that references mach (Torez Smith) [1383823]
- [usb] hwrng: chaoskey - drop workaround for old hwrng core limitation (Torez Smith) [1383823]
- [usb] ehci: merge all cases that disable the IO watchdog (Torez Smith) [1383823]
- [usb] ehci: elide I/O watchdog on AMD parts (Torez Smith) [1383823]
- [usb] usbtmc: Add, clarify and fix comments (Torez Smith) [1383823]
- [kernel] usb: fix a typo in usb_class_driver documentation (Torez Smith) [1383823]
- [usb] increase ohci watchdog delay to 275 msec (Torez Smith) [1383823]
- [usb] serial: cp210x: return -EIO on short control transfers (Torez Smith) [1383823]
- [usb] serial: cp210x: clean up CSIZE handling (Torez Smith) [1383823]
- [usb] serial: fix potential NULL-dereference at probe (Torez Smith) [1383823]
- [usb] xhci: use default USB_RESUME_TIMEOUT when resuming ports (Torez Smith) [1383823]
- [usb] xhci: workaround for hosts missing CAS bit (Torez Smith) [1383823]
- [usb] xhci: add restart quirk for Intel Wildcatpoint PCH (Torez Smith) [1383823]
- [usb] serial: cp210x: fix tiocmget error handling (Torez Smith) [1383823]
- [usb] wusb: fix error return code in wusb_prf() (Torez Smith) [1383823]
- [netdrv] r8152: add new products of Lenovo (Torez Smith) [1383823]
- [usb] serial: ftdi_sio: add support for Infineon TriBoard TC2X7 (Torez Smith) [1383823]
- [usb] wusb: Stop using the stack for sg crypto scratch space (Torez Smith) [1383823]
- [netdrv] asix: Avoid looping when the device does not respond (Torez Smith) [1383823]
- [netdrv] qmi_wwan: add support for Quectel EC21 and EC25 (Torez Smith) [1383823]
- [netdrv] usb: lan78xx: use new api ethtool_{get|set}_link_ksettings (Torez Smith) [1383823]
- [usb] host: ehci-sead3: Remove SEAD-3 EHCI code (Torez Smith) [1383823]
- [usb] revert "usbtmc: convert to devm_kzalloc" (Torez Smith) [1383823]
- [usb] serial: cp210x: Add ID for a Juniper console (Torez Smith) [1383823]
- [usb] kconfig: using select for USB_COMMON dependency (Torez Smith) [1383823]
- [usb] hub: change CLEAR_FEATURE to SET_FEATURE (Torez Smith) [1383823]
- [usb] core: Introduce a USB port LED trigger (Torez Smith) [1383823]
- [usb] core: hcd: add missing header dependencies (Torez Smith) [1383823]
- [usb] misc: legousbtower: Fix NULL pointer deference (Torez Smith) [1383823]
- [usb] cdc-acm: hardening against malicious devices (Torez Smith) [1383823]
- [netdrv] r8152: disable ALDPS and EEE before setting PHY (Torez Smith) [1383823]
- [netdrv] r8152: remove r8153_enable_eee (Torez Smith) [1383823]
- [netdrv] r8152: move PHY settings to hw_phy_cfg (Torez Smith) [1383823]
- [netdrv] r8152: move enabling PHY (Torez Smith) [1383823]
- [netdrv] r8152: move some functions (Torez Smith) [1383823]
- [usb] change bInterval default to 10 ms (Torez Smith) [1383823]
- [usb] ohci: Allow ohci on omap5 also (Torez Smith) [1383823]
- [usb] host: xhci-tegra: Fix error return code in tegra_xusb_probe() (Torez Smith) [1383823]
- [usb] ezusb: constify local structures (Torez Smith) [1383823]
- [usb] wusbcore: add in missing white space in error message text (Torez Smith) [1383823]
- [usb] cdc-acm: cleaning up debug in data submission path (Torez Smith) [1383823]
- [usb] cdc-acm: cleanup debugging in submission path (Torez Smith) [1383823]
- [kernel] scsi: introduce a quirk for false cache reporting (Torez Smith) [1383823]
- [usb] kconfig: let USB_ULPI_BUS depends on USB_COMMON (Torez Smith) [1383823]
- [usb] serial: simple: add support for another Infineon flashloader (Torez Smith) [1383823]
- [usb] cdc-acm: delete obsolete debug messages (Torez Smith) [1383823]
- [usb] cdc-wdm: add terminating newline (Torez Smith) [1383823]
- [usb] kconfig: move ulpi bus support out of host (Torez Smith) [1383823]
- [usb] xhci: fix null pointer dereference in stop command timeout function (Torez Smith) [1383823]
- [netdrv] kaweth: remove obsolete debugging statements (Torez Smith) [1383823]
- [netdrv] lan78xx: mark symbols static where possible (Torez Smith) [1383823]
- [netdrv] hso: Convert printk to pr_<level> (Torez Smith) [1383823]
- [netdrv] hso: Use a more common logging style (Torez Smith) [1383823]
- [netdrv] smsc95xx: Add mdix control via ethtool (Torez Smith) [1383823]
- [netdrv] smsc95xx: Add register define (Torez Smith) [1383823]
- [kernel] usb: ulpi: make ops struct constant (Torez Smith) [1383823]
- [kernel] usb: ulpi: remove "dev" field from struct ulpi_ops (Torez Smith) [1383823]
- [kernel] usb: ulpi: rename operations {read|write}_dev to simply {read|write} (Torez Smith) [1383823]
- [kernel] usb: ulpi: remove calls to old api callbacks (Torez Smith) [1383823]
- [kernel] usb: ulpi: add new api functions, {read|write}_dev() (Torez Smith) [1383823]
- [usb] ulpi: move setting of ulpi->dev parent up in ulpi_register() (Torez Smith) [1383823]
- [usb] core: use IS_ENABLED() instead of checking for built-in or module (Torez Smith) [1383823]
- [netdrv] pegasus: Remove deprecated create_singlethread_workqueue (Torez Smith) [1383823]
- [netdrv] r8152: fix the coding style with checkpatch.pl (Torez Smith) [1383823]
- [netdrv] asix: autoneg will set WRITE_MEDIUM reg (Torez Smith) [1383823]
- [netdrv] asix: see 802.3 spec for phy reset (Torez Smith) [1383823]
- [netdrv] asix: Fix AX88772x resume failures (Torez Smith) [1383823]
- [netdrv] asix: Avoid looping when the device is disconnected (Torez Smith) [1383823]
- [netdrv] asix: Add in_pm parameter (Torez Smith) [1383823]
- [netdrv] r8152: constify ethtool_ops structures (Torez Smith) [1383823]
- [usb] wusbcore: wa-nep: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] wusbcore: security: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] wusbcore: crypto: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] usb-skeleton: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] storage: sddr09: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] storage: alauda: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: yurex: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: uss720: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: usbsevseg: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: usblcd: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: trancevibrator: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: lvstest: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: legousbtower: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: ldusb: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: iowarrior: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: idmouse: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: ftdi-elan: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: cytherm: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: cypress_cy7c63: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: appledisplay: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] misc: adutux: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] host: xhci: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] host: xhci-tegra: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] host: uhci-hcd: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] core: urb: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] core: message: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] core: hub: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] core: hcd: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] class: usbtmc: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] atm: usbatm: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] atm: ueagle-atm: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] atm: speedtch: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] atm: cxacru: don't print on ENOMEM (Torez Smith) [1383823]
- [usb] serial: option: add WeTelecom 0x6802 and 0x6803 products (Torez Smith) [1383823]
- [usb] avoid left shift by -1 (Torez Smith) [1383823]
- [usb] fix typo in wMaxPacketSize validation (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: remove unused variables (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: use C_X macros (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: remove useless NULL-testing (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: remove useless dev_dbg messages (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: do not use __uX types (Torez Smith) [1383823]
- [usb] serial: use IS_ENABLED() instead of checking for built-in or module (Torez Smith) [1383823]
- [usb] serial: option: add WeTelecom WM-D200 (Torez Smith) [1383823]
- [netdrv] kaweth: fix oops upon failed memory allocation (Torez Smith) [1383823]
- [netdrv] kaweth: fix firmware download (Torez Smith) [1383823]
- [usb] xhci: don't dereference a xhci member after removing xhci (Torez Smith) [1383823]
- [usb] xhci: Fix panic if disconnect (Torez Smith) [1383823]
- [usb] xhci: really enqueue zero length TRBs (Torez Smith) [1383823]
- [usb] xhci: always handle "Command Ring Stopped" events (Torez Smith) [1383823]
- [usb] cdc-acm: fix wrong pipe type on rx interrupt xfers (Torez Smith) [1383823]
- [kernel] usb: bcma: support old USB 2.0 controller on Northstar devices (Torez Smith) [1383823]
- [usb] whci: Remove deprecated create_singlethread_workqueue (Torez Smith) [1383823]
- [usb] cdc-wdm: cleanup debug messages (Torez Smith) [1383823]
- [usb] wusbcore: wa-xfer: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] wusbcore: wa-nep: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] usb-skeleton: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] storage: usb: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: yurex: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: uss720: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: sisusbvga: sisusb: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: lvstest: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: legousbtower: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: ldusb: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: iowarrior: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: ftdi-elan: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: appledisplay: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: adutux: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] class: usbtmc: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] atm: usbatm: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] atm: ueagle-atm: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] atm: cxacru: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] serial: mos7840: fix non-atomic allocation in write path (Torez Smith) [1383823]
- [usb] serial: mos7720: fix non-atomic allocation in write path (Torez Smith) [1383823]
- [netdrv] usb: usbnet: don't print error when allocating urb fails (Torez Smith) [1383823]
- [netdrv] usb: lan78xx: don't print error when allocating urb fails (Torez Smith) [1383823]
- [netdrv] usb: hso: don't print error when allocating urb fails (Torez Smith) [1383823]
- [usb] misc: usbtest: add fix for driver hang (Torez Smith) [1383823]
- [usb] cdc-wdm: Clear read pipeline in case of error (Torez Smith) [1383823]
- [usb] core: of.c: fix defined but not declare warning (Torez Smith) [1383823]
- [usb] remove redundant dependency on USB_SUPPORT (Torez Smith) [1383823]
- [usb] remove race condition in usbfs/libusb when using reap-after-disconnect (Torez Smith) [1383823]
- [usb] devio, do not warn when allocation fails (Torez Smith) [1383823]
- [usb] ehci: change order of register cleanup during shutdown (Torez Smith) [1383823]
- [usb] validate wMaxPacketValue entries in endpoint descriptors (Torez Smith) [1383823]
- [kernel] usb: ulpi: Automatically set driver::owner with ulpi_driver_register() (Torez Smith) [1383823]
- [usb] storage: fix runtime pm issue in usb_stor_probe2 (Torez Smith) [1383823]
- [usb] cdc-wdm: fix "out-of-sync" due to missing notifications (Torez Smith) [1383823]
- [usb] ftdi-elan: Remove deprecated create_singlethread_workqueue (Torez Smith) [1383823]
- [usb] appledisplay: Remove deprecated create_singlethread_workqueue (Torez Smith) [1383823]
- [usb] lvstest: Remove deprecated create_singlethread_workqueue (Torez Smith) [1383823]
- [usb] misc: Add driver for usb4604 (Torez Smith) [1383823]
- [usb] misc: ftdi-elan: Fix off-by-one memory corruptions (Torez Smith) [1383823]
- [usb] misc: usbtest: usbtest_do_ioctl may return positive integer (Torez Smith) [1383823]
- [usb] hub: change the locking in hub_activate (Torez Smith) [1383823]
- [usb] hub: fix up early-exit pathway in hub_activate (Torez Smith) [1383823]
- [usb] hub: Fix unbalanced reference count/memory leak/deadlocks (Torez Smith) [1383823]
- [usb] serial: fix memleak in driver-registration error path (Torez Smith) [1383823]
- [usb] serial: option: add support for Telit LE920A4 (Torez Smith) [1383823]
- [usb] serial: ftdi_sio: add device ID for WICED USB UART dev board (Torez Smith) [1383823]
- [usb] serial: ftdi_sio: add PIDs for Ivium Technologies devices (Torez Smith) [1383823]
- [usb] serial: option: add D-Link DWM-156/A3 (Torez Smith) [1383823]
- [netdrv] cdc_ether: Improve ZTE MF823/831/910 handling (Torez Smith) [1383823]
- [usb] cdc-acm: beautify probe() (Torez Smith) [1383823]
- [usb] cdc-wdm: use the common CDC parser (Torez Smith) [1383823]
- [usb] cdc-acm: cleanup error handling (Torez Smith) [1383823]
- [usb] cdc-acm: use the common parser (Torez Smith) [1383823]
- [usb] usbnet: move the CDC parser into USB core (Torez Smith) [1383823]
- [netdrv] rndis_host: Set valid random MAC on buggy devices (Torez Smith) [1383823]
- [usb] serial: use variable for status (Torez Smith) [1383823]
- [usb] serial: option: add support for Telit LE910 PID 0x1206 (Torez Smith) [1383823]
- [netdrv] r8152: add MODULE_VERSION (Torez Smith) [1383823]
- [usb] serial: cp210x: use kmemdup (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: use functions rather than macros (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: remove ti_usb_3410_5052.h (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: use __packed (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: remove useless comments (Torez Smith) [1383823]
- [usb] quirks: Add no-lpm quirk for Elan (Torez Smith) [1383823]
- [netdrv] r8152: Add support for setting pass through MAC address on RTL8153-AD (Torez Smith) [1383823]
- [netdrv] r8152: remove cancel_delayed_work_sync in rtl8152_set_speed (Torez Smith) [1383823]
- [netdrv] r8152: remove a netif_carrier_off in rtl8152_open function (Torez Smith) [1383823]
- [netdrv] r8152: remove rtl_phy_reset function (Torez Smith) [1383823]
- [netdrv] r8152: remove the setting of LAN_WAKE_EN (Torez Smith) [1383823]
- [netdrv] r8152: fix runtime function for RTL8152 (Torez Smith) [1383823]
- [netdrv] cdc_ncm: workaround for EM7455 "silent" data interface (Torez Smith) [1383823]
- [usb] xhci: free the correct ring (Torez Smith) [1383823]
- [netdrv] r8152: clear LINK_OFF_WAKE_EN after autoresume (Torez Smith) [1383823]
- [netdrv] usbnet: Stop RX Q on MTU change (Torez Smith) [1383823]
- [usb] don't free bandwidth_mutex too early (Torez Smith) [1383823]
- [kernel] xhci: get rid of platform data (Torez Smith) [1383823]
- [usb] xhci: rename and simplify last_trb_on_last_seg() helper (Torez Smith) [1383823]
- [usb] xhci: remove enqueue_is_link() helper (Torez Smith) [1383823]
- [usb] xhci: rework inc_deq() and fix off by one error (Torez Smith) [1383823]
- [usb] xhci: use and add separate function for checking for link trbs (Torez Smith) [1383823]
- [usb] xhci: clean up event ring checks from inc_enq() (Torez Smith) [1383823]
- [usb] xhci: TD-fragment, align the unsplittable case with a bounce buffer (Torez Smith) [1383823]
- [usb] xhci: align the last trb before link if it is easily splittable (Torez Smith) [1383823]
- [usb] xhci: don't rely on precalculated value of needed trbs in the enqueue loop (Torez Smith) [1383823]
- [usb] xhci: use boolean to indicate last trb in td remainder calculation (Torez Smith) [1383823]
- [usb] xhci: properly prepare zero packet TD after normal bulk TD (Torez Smith) [1383823]
- [usb] xhci: rename ep_ring variable in queue_bulk_tx(), no functional change (Torez Smith) [1383823]
- [kernel] tty: vt, convert more macros to functions (Torez Smith) [1383823]
- [kernel] tty: vt, remove consw->con_bmove (Torez Smith) [1383823]
- [kernel] tty: vt, consw->con_set_palette cleanup (Torez Smith) [1383823]
- [kernel] tty: vt, consw->con_scrolldelta cleanup (Torez Smith) [1383823]
- [usb] sisusb: remove dummy variables (Torez Smith) [1383823]
- [kernel] usb: ehci: declare hostpc register as zero-length array (Torez Smith) [1383823]
- [usb] gadget: move gadget API functions to udc-core (Torez Smith) [1383823]
- [usb] misc: remove outdated USB LED driver (Torez Smith) [1383823]
- [netdrv] r8152: modify the check of the flag of PHY_RESET in set_speed function (Torez Smith) [1383823]
- [netdrv] r8152: correct the rx early size (Torez Smith) [1383823]
- [netdrv] r8152: disable MAC clock speed down (Torez Smith) [1383823]
- [netdrv] r8152: save the speed (Torez Smith) [1383823]
- [netdrv] r8152: move the setting for the default speed (Torez Smith) [1383823]
- [netdrv] r8152: move the settings of PHY to a work queue (Torez Smith) [1383823]
- [usb] common: otg-fsm: add license to usb-otg-fsm (Torez Smith) [1383823]
- [netdrv] r8152: replace netdev_alloc_skb_ip_align with napi_alloc_skb (Torez Smith) [1383823]
- [usb] misc: usb3503: Clean up on driver unbind (Torez Smith) [1383823]
- [usb] misc: usb3503: Set platform data (Torez Smith) [1383823]
- [usb] microtek: Use "foo *bar" instead of "foo * bar" (Torez Smith) [1383823]
- [usb] cdc-acm: Space prohibited before close parenthesis ')' (Torez Smith) [1383823]
- [usb] echi-hcd: Add ehci_setup check before echi_shutdown (Torez Smith) [1383823]
- [usb] ohci: Don't mark EDs as ED_OPER if scheduling fails (Torez Smith) [1383823]
- [usb] hwrng: chaoskey - Fix URB warning due to timeout on Alea (Torez Smith) [1383823]
- [usb] hwrng: chaoskey - Add support for Araneus Alea I USB RNG (Torez Smith) [1383823]
- [usb] ehci: avoid undefined pointer arithmetic and placate UBSAN (Torez Smith) [1383823]
- [usb] quirks: Add no-lpm quirk for Acer C120 LED Projector (Torez Smith) [1383823]
- [usb] quirks: Fix sorting (Torez Smith) [1383823]
- [usb] xhci: fix platform quirks overwrite regression in 4.7-rc1 (Torez Smith) [1383823]
- [netdrv] usbnet: smsc95xx: fix link detection for disabled autonegotiation (Torez Smith) [1383823]
- [netdrv] pegasus: simplify logical constraint (Torez Smith) [1383823]
- [netdrv] usb: ch9200: use kmemdup (Torez Smith) [1383823]
- [netdrv] cdc_ncm: update datagram size after changing mtu (Torez Smith) [1383823]
- [netdrv] revert "net: pegasus: remove dead coding" (Torez Smith) [1383823]
- [netdrv] pegasus: remove dead coding (Torez Smith) [1383823]
- [netdrv] asix: Fix offset calculation in asix_rx_fixup() causing slow transmissions (Torez Smith) [1383823]
- [usb] ohci-jz4740: Remove obsolete driver (Torez Smith) [1383823]
- [usb] serial: ti_usb_3410_5052: add MOXA UPORT 11x0 support (Torez Smith) [1383823]
- [usb] serial: fix minor-number allocation (Torez Smith) [1383823]
- [usb] serial: quatech2: fix use-after-free in probe error path (Torez Smith) [1383823]
- [usb] serial: keyspan: fix debug and error messages (Torez Smith) [1383823]
- [usb] serial: keyspan: fix URB unlink (Torez Smith) [1383823]
- [usb] serial: keyspan: fix use-after-free in probe error path (Torez Smith) [1383823]
- [usb] serial: io_edgeport: fix memory leaks in probe error path (Torez Smith) [1383823]
- [usb] serial: io_edgeport: fix memory leaks in attach error path (Torez Smith) [1383823]
- [usb] host: xhci-rcar: Avoid long wait in xhci_reset() (Torez Smith) [1383823]
- [usb] wusbcore: Do not initialise statics to 0 (Torez Smith) [1383823]
- [usb] wusbcore: Remove space before ', ' and '(' (Torez Smith) [1383823]
- [usb] serial: cp210x: clean up CRTSCTS flag code (Torez Smith) [1383823]
- [usb] serial: cp210x: get rid of magic numbers in CRTSCTS flag code (Torez Smith) [1383823]
- [usb] serial: cp210x: fix hardware flow-control disable (Torez Smith) [1383823]
- [netdrv] usbnet: smsc95xx: silence an uninitialized variable warning (Torez Smith) [1383823]
- [netdrv] usbnet/smsc75xx: silence uninitialized variable warning (Torez Smith) [1383823]
- [usb] serial: option: add even more ZTE device ids (Torez Smith) [1383823]
- [usb] serial: option: add more ZTE device ids (Torez Smith) [1383823]
- [usb] sisusbvga: correct speed testing (Torez Smith) [1383823]
- [usb] misc: usbtest: fix pattern tests for scatterlists (Torez Smith) [1383823]
- [kernel] usb: leave LPM alone if possible when binding/unbinding interface drivers (Torez Smith) [1383823]
- [netdrv] rtl8152: correct speed testing (Torez Smith) [1383823]
- [netdrv] usbnet: correct speed testing (Torez Smith) [1383823]
- [usb] serial: option: add support for Cinterion PH8 and AHxx (Torez Smith) [1383823]
- [kernel] tty: vt, make color_table const (Torez Smith) [1383823]
- [net] tty: Replace TTY_THROTTLED bit tests with tty_throttled() (Torez Smith) [1383823]
- [usb] ehci: make all debugging depend on CONFIG_DYNAMIC_DEBUG (Torez Smith) [1383823]
- [usb] Add driver for UCSI (Torez Smith) [1383823]
- [usb] xhci: tegra: Add Tegra210 support (Torez Smith) [1383823]
- [usb] xhci: Add NVIDIA Tegra XUSB controller driver (Torez Smith) [1383823]
- [usb] core: move root hub's device node assignment after it is added to bus (Torez Smith) [1383823]
- [usb] Use "foo *bar" instead of "foo * bar" (Torez Smith) [1383823]
- [usb] Remove unnecessary space before function pointer arguments (Torez Smith) [1383823]
- [kernel] usb: core: hub: hub_port_init lock controller instead of bus (Torez Smith) [1383823]
- [usb] devio: declare usbdev_vm_ops as static (Torez Smith) [1383823]
- [usb] misc: usbtest: fix error of urb allocation (Torez Smith) [1383823]
- [usb] core: buffer: avoid NULL pointer dereferrence (Torez Smith) [1383823]
- [usb] hcd: do not call whc_clean_up on wch_init call failure (Torez Smith) [1383823]
- [usb] xhci: remove duplicate code of interval checking (Torez Smith) [1383823]
- [usb] xhci: remove duplicate function xhci_urb_to_transfer_ring (Torez Smith) [1383823]
- [usb] xhci: merge xhci_queue_bulk_tx and queue_bulk_sg_tx functions (Torez Smith) [1383823]
- [usb] usb: core: Minimize irq disabling in usb_sg_cancel() (Torez Smith) [1383823]
- [usb] usb: core: Don't disable irqs in usb_sg_wait() during URB submit (Torez Smith) [1383823]
- [usb] storage: fix multi-line comment style (Torez Smith) [1383823]
- [usb] storage: scsiglue: limit USB3 devices to 2048 sectors (Torez Smith) [1383823]
- [usb] storage: scsiglue: further describe our 240 sector limit (Torez Smith) [1383823]
- [usb] hub: admit devices are SS+ (Torez Smith) [1383823]
- [kernel] usb: correct intervals for SS+ (Torez Smith) [1383823]
- [kernel] usb: LTM also for USB 3.1 (Torez Smith) [1383823]
- [usb] serial: use IS_ENABLED() instead of checking for FOO || FOO_MODULE (Torez Smith) [1383823]
- [usb] serial: ftdi_sio: constify ftdi_sio_quirk structures (Torez Smith) [1383823]
- [usb] wusbcore: remove unreachable code (Torez Smith) [1383823]
- [usb] whci-hcd: add more checks for dma mapping error (Torez Smith) [1383823]
- [usb] xhci: fix typo in babble endpoint handling comment (Torez Smith) [1383823]
- [uapi] usb: pd: additional feature selectors (Torez Smith) [1383823]
- [uapi] usb: pd: define specific requests (Torez Smith) [1383823]
- [uapi] usb: add descriptors from USB Power Delivery spec (Torez Smith) [1383823]
- [usb] common: rework CONFIG_USB_COMMON logic (Torez Smith) [1383823]
- [kernel] usb: otg-fsm: support multiple instances (Torez Smith) [1383823]
- [kernel] usb: otg-fsm: Add documentation for struct otg_fsm (Torez Smith) [1383823]
- [acpi] acpica: linux: Allow ACPICA inclusion for CONFIG_ACPI=n builds (Prarit Bhargava) [1432953 1383823]
- [acpi] acpica: linux: Add support to exclude <asm/acenv.h> inclusion (Prarit Bhargava) [1432953 1383823]
- [acpi] acpica: linux headers: Add <asm/acenv.h> to remove mis-ordered inclusion of <asm/acpi.h> (Prarit Bhargava) [1432953 1383823]
- [acpi] acpica: linux headers: Add <acpi/platform/aclinuxex.h> (Prarit Bhargava) [1432953 1383823]
- [acpi] acpica: linux header: Add support for stubbed externals (Prarit Bhargava) [1432953 1383823]
- [acpi] acpica: osl: Add configurability for generic external functions (Prarit Bhargava) [1383823 1432953]
- [acpi] acpica: Add support to allow host OS to redefine individual OSL prototypes (Prarit Bhargava) [1432953 1383823]

* Thu Mar 23 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-626.el7]
- [netdrv] nfp: consolidate two PCI device tables/structures into one (John Linville) [1406197]
- [netdrv] nfp: don't tell FW about the reserved buffer space (John Linville) [1406197]
- [netdrv] nfp: allow application firmware to limit number of SR-IOV VFs (John Linville) [1406197]
- [netdrv] nfp: return nfp_rtsym_read_le() errors correctly (John Linville) [1406197]
- [netdrv] nfp: add very basic access to NSP logs (John Linville) [1406197]
- [netdrv] nfp: report NSP ABI version in ethtool FW version (John Linville) [1406197]
- [netdrv] nfp: store NSP ABI version in state structure (John Linville) [1406197]
- [netdrv] nfp: report manufacturing info on load (John Linville) [1406197]
- [netdrv] nfp: refactor NSP initialization and add error message (John Linville) [1406197]
- [netdrv] nfp: add the PF driver (John Linville) [1406197]
- [netdrv] nfp: allocate irqs in lower driver (John Linville) [1406197]
- [netdrv] nfp: add port layer to debugfs directories (John Linville) [1406197]
- [netdrv] nfp: add support for service processor access (John Linville) [1406197]
- [netdrv] nfp: add rtsym support (John Linville) [1406197]
- [netdrv] nfp: add MIP reading support (John Linville) [1406197]
- [netdrv] nfp: add support for reading nffw info (John Linville) [1406197]
- [netdrv] nfp: add hwinfo support (John Linville) [1406197]
- [netdrv] nfp: add support for resources (John Linville) [1406197]
- [netdrv] nfp: add CPP access core (John Linville) [1406197]
- [netdrv] nfp: rename the driver and add new main file (John Linville) [1406197]
- [kernel] bitfield.h: add FIELD_FIT() helper (John Linville) [1406197]
- [kernel] add basic register-field manipulation macros (John Linville) [1406197]
- [netdrv] netronome: don't access real_num_rx_queues directly (John Linville) [1406197]
- [netdrv] nfp: reorganize nfp_net_rx() to get packet offsets early (John Linville) [1406197]
- [netdrv] nfp: add support for ethtool .set_channels (John Linville) [1406197]
- [netdrv] nfp: move RSS indirection table init into a separate function (John Linville) [1406197]
- [netdrv] nfp: add helper to reassign rings to IRQ vectors (John Linville) [1406197]
- [netdrv] nfp: loosen relation between rings and IRQs vectors (John Linville) [1406197]
- [netdrv] nfp: reuse ring helpers on .ndo_open() path (John Linville) [1406197]
- [netdrv] nfp: rename ring allocation helpers (John Linville) [1406197]
- [netdrv] nfp: centralize runtime reconfiguration logic (John Linville) [1406197]
- [netdrv] nfp: add support for ethtool .get_channels (John Linville) [1406197]
- [netdrv] nfp: bring back support for different ring counts (John Linville) [1406197]
- [netdrv] nfp: replace num_irqs with max_r_vecs (John Linville) [1406197]
- [netdrv] nfp: remove nfp_net_irqs_wanted() (John Linville) [1406197]
- [netdrv] nfp: use unsigned int for vector/ring counts (John Linville) [1406197]
- [netdrv] nfp: create separate define for max number of vectors (John Linville) [1406197]
- [netdrv] nfp: use AND instead of modulo to get ring indexes (John Linville) [1406197]
- [netdrv] nfp: add separate buffer allocation function for napi (John Linville) [1406197]
- [netdrv] nfp: use alloc_frag() and build_skb() (John Linville) [1406197]
- [netdrv] nfp: add buffer drop/recycle helper for RX (John Linville) [1406197]
- [netdrv] nfp: centralize the buffer size calculation (John Linville) [1406197]
- [netdrv] nfp: remove inline attributes and dead code (John Linville) [1406197]
- [netdrv] nfp: remove unnecessary call to ether_setup() (John Linville) [1406197]
- [netdrv] nfp: remove support for nfp3200 (John Linville) [1406197]
- [netdrv] nfp: backport definitions of nn_{read,write}* (John Linville) [1406197]
- [netdrv] nfp: simplify nfp_net_poll() (John Linville) [1406197]
- [netdrv] xen-netfront: Delete rx_refill_timer in xennet_disconnect_backend() (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: Improve error handling during initialization (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: Rework the fix for Rx stall during OOM and network stress (Vitaly Kuznetsov) [1102638]
- [netdrv] xen/netfront: set default upper limit of tx/rx queues to 8 (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: Fix Rx stall during network stress and OOM (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: cast grant table reference first to type int (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: do not cast grant table reference to signed short (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: only napi_synchronize() if running (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: Use setup_timer (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: request Tx response events more often (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: update num_queues to real created (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: always set num queues if possible (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: respect user provided max_queues (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: Remove the meaningless code (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: only clean up queues if present (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: properly destroy queues when removing device (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: refactor making Tx requests (Vitaly Kuznetsov) [1102638]
- [xen] add page_to_mfn() (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: refactor skb slot counting (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: use different locks for Rx and Tx stats (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: remove residual dead code (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: always keep the Rx ring full of requests (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: print correct number of queues (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: release per-queue Tx and Rx resource when disconnecting (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: fix locking in connect error path (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: call netif_carrier_off() only once when disconnecting (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: don't nest queue locks in xennet_connect() (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: recreate queues correctly when reconnecting (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: fix oops when disconnected from backend (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: initialise queue name in xennet_init_queue (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: Add support for multiple queues (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: Factor queue-specific data into queue struct (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: fix array initialization bug (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: Call dev_kfree_skb_any instead of dev_kfree_skb (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: handle backend CLOSED without CLOSING (Vitaly Kuznetsov) [1102638]
- [netdrv] xen-netfront: fix missing rx_refill_timer when allocate memory failed (Vitaly Kuznetsov) [1102638]

* Thu Mar 23 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-625.el7]
- [net] sched: cls_u32: complete the check for non-forced case in u32_destroy() (Ivan Vecera) [1428588]
- [net] sched: fix a use-after-free in tc_ctl_tfilter() (Ivan Vecera) [1428588]
- [net] sched: destroy proto tp when all filters are gone (Ivan Vecera) [1428588]
- [net] sched: fq_codel: return non zero qlen in class dumps (Ivan Vecera) [1428588]
- [net] sched: close another race condition in tcf_mirred_release() (Ivan Vecera) [1428588]
- [net] sched: Add description for cpu_bstats argument (Ivan Vecera) [1428588]
- [net] sched: fix missing free per cpu on qstats (Ivan Vecera) [1428588]
- [net] sched: act_pedit: check binding before calling tcf_hash_release() (Ivan Vecera) [1428588]
- [net] sched: fix refcount imbalance in actions (Ivan Vecera) [1428588]
- [net] sched: act_mirred: remove spinlock in fast path (Ivan Vecera) [1428588]
- [net] sched: act_gact: remove spinlock in fast path (Ivan Vecera) [1428588]
- [net] sched: act_gact: read tcfg_ptype once (Ivan Vecera) [1428588]
- [net] sched: act_gact: use a separate packet counters for gact_determ() (Ivan Vecera) [1428588]
- [net] sched: act_gact: make tcfg_pval non zero (Ivan Vecera) [1428588]
- [net] sched: add percpu stats to actions (Ivan Vecera) [1428588]
- [net] sched: extend percpu stats helpers (Ivan Vecera) [1428588]
- [net] sched: invoke ->attach() after setting dev->qdisc (Ivan Vecera) [1428588]
- [net] set qdisc pkt len before tc_classify (Ivan Vecera) [1428588]
- [net] kill useless net_*_ingress_queue() definitions when NET_CLS_ACT is unset (Ivan Vecera) [1428588]
- [net] sched: use counter to break reclassify loops (Ivan Vecera) [1428588]
- [net] sched: fix typo in net_device ifdef (Ivan Vecera) [1428588]
- [net] sched: further simplify handle_ing (Ivan Vecera) [1428588]
- [net] sched: consolidate handle_ing and ing_filter (Ivan Vecera) [1428588]
- [net] tc: remove unused redirect ttl (Ivan Vecera) [1428588]
- [net] sched: run ingress qdisc without locks (Ivan Vecera) [1428588]
- [net] sched: remove TC_MUNGED bits (Ivan Vecera) [1428588]
- [net] use jump label patching for ingress qdisc in __netif_receive_skb_core (Ivan Vecera) [1428588]
- [net] sched: fix panic in rate estimators (Ivan Vecera) [1428588]
- [net] sched: cls: use nla_nest_cancel instead of nlmsg_trim (Ivan Vecera) [1428588]
- [net] sched: cls_basic: fix error path in basic_change() (Ivan Vecera) [1428588]
- [net] sched: cls: remove unused op put from tcf_proto_ops (Ivan Vecera) [1428588]
- [net] sched: cls_cgroup: remove unnecessary if (Ivan Vecera) [1428588]
- [net] sched: cls_flow: remove duplicate assignments (Ivan Vecera) [1428588]
- [net] sched: cls_flow: remove faulty use of list_for_each_entry_rcu (Ivan Vecera) [1428588]
- [net] sched: cls_bpf: remove faulty use of list_for_each_entry_rcu (Ivan Vecera) [1428588]
- [net] sched: cls_bpf: remove unnecessary iteration and use passed arg (Ivan Vecera) [1428588]
- [net] sched: cls_basic: remove unnecessary iteration and use passed arg (Ivan Vecera) [1428588]
- [net] sched: tc_vlan: fix type of tcfv_push_vid (Ivan Vecera) [1428588]
- [net] sched: introduce vlan action (Ivan Vecera) [1428588]
- [net] sched: initialize bstats syncp (Ivan Vecera) [1428588]
- [net] sched: fix unused variables in __gnet_stats_copy_basic_cpu() (Ivan Vecera) [1428588]
- [net] sched: do not use tcf_proto 'tp' argument from call_rcu (Ivan Vecera) [1428588]
- [net] sched: remove tcf_proto from ematch calls (Ivan Vecera) [1428588]
- [net] sched: enable per cpu qstats (Ivan Vecera) [1428588]
- [net] sched: restrict use of qstats qlen (Ivan Vecera) [1428588]
- [net] sched: make bstats per cpu and estimator RCU safe (Ivan Vecera) [1428588]
- [net] sched: fix errno in tcindex_set_parms() (Ivan Vecera) [1428588]
- [net] sched: remove the first parameter from tcf_exts_destroy() (Ivan Vecera) [1428588]
- [net] sched: hold tcf_lock in netdevice notifier (Ivan Vecera) [1428588]
- [net] sched: add cond_resched() to class and qdisc dump (Ivan Vecera) [1428588]
- [net] sched: do not use rcu in tc_dump_qdisc() (Ivan Vecera) [1428588]
- [net] sched: move the sanity test in qdisc_list_add() (Ivan Vecera) [1428588]
- [net] sched: htb: do not acquire qdisc lock in dump operations (Ivan Vecera) [1428588]
- [net] sched: act: clean up tca_action_flush() (Ivan Vecera) [1428588]
- [net] sched: act: refuse to remove bound action outside (Ivan Vecera) [1428588]
- [net] sched: act: move tcf_hashinfo_init() into tcf_register_action() (Ivan Vecera) [1428588]
- [net] sched: act: remove capab from struct tc_action_ops (Ivan Vecera) [1428588]
- [net] sched: act: refactor cleanup ops (Ivan Vecera) [1428588]
- [net] sched: act: hide struct tcf_common from API (Ivan Vecera) [1428588]
- [net] sched: act: export tcf_hash_search() instead of tcf_hash_lookup() (Ivan Vecera) [1428588]
- [net] sched: act: fetch hinfo from a->ops->hinfo (Ivan Vecera) [1428588]
- [net] sched: replace macros net_random and net_srandom with direct calls to prandom (Ivan Vecera) [1428588]
- [net] sched: act: use tcf_hash_release() in net/sched/act_police.c (Ivan Vecera) [1428588]
- [net] sched: act: remove struct tcf_act_hdr (Ivan Vecera) [1428588]
- [net] sched: act: clean up notification functions (Ivan Vecera) [1428588]
- [net] sched: act: move idx_gen into struct tcf_hashinfo (Ivan Vecera) [1428588]
- [net] sched: action: make local function static (Ivan Vecera) [1428588]
- [net] sched: act: action flushing missaccounting (Ivan Vecera) [1428588]
- [net] sched: Remove unnecessary checks for act->ops (Ivan Vecera) [1428588]
- [net] sched: act: Dont increment refcnt on replace (Ivan Vecera) [1428588]
- [net] sched: set root qdisc before change() in attach_default_qdiscs() (Ivan Vecera) [1428588]
- [net] sched: remove unnecessary parentheses while return (Ivan Vecera) [1428588]
- [net] sched: give visibility to mq slave qdiscs (Ivan Vecera) [1428588]
- [net] netem: missing break in ge loss generator (Ivan Vecera) [1428588]
- [net] netem: fix gemodel loss generator (Ivan Vecera) [1428588]
- [net] gen_stats: Remove extern from function prototypes (Ivan Vecera) [1428588]

* Thu Mar 23 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-624.el7]
- [nvme] redhat: mark NVMe over FC as tech preview (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: Fix missing dma sync to nvme data structures (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: Call fatal_error from keep-alive timout expiration (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: cancel fatal error and flush async work before free controller (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: delete controllers deletion upon subsystem release (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet_fc: correct logic in disconnect queue LS handling (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: fix nvme_rdma_queue_is_ready (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet/fcloop: remove some logically dead code performing redundant ret checks (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: fix KATO offset in Set Features (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] fc: simplify error handling of nvme_fc_create_hw_io_queues (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] fc: correct some printk information (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] scsi: Remove START STOP emulation (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] pci: Delete misleading queue-wrap comment (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] simplify stripe quirk (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme : Use correct scnprintf in cmb show (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] pci: Log PCI_STATUS when the controller dies (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: Add FC LLDD loopback driver to test FC-NVME (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: Add target support for FC transport (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: Add host support for FC transport (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] admin-cmd: Added smart-log command support (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: Add host_traddr options field to host infrastructure (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] untangle 0 and BLK_MQ_RQ_QUEUE_OK (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] don't pass the full CQE to nvme_complete_async_event (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme: introduce struct nvme_request (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme-fabrics: Add FC transport LLDD api definitions (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme-fabrics: Add FC transport FC-NVME definitions (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme-fabrics: Add FC transport error codes to nvme.h (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [uapi] Add type 0x28 NVME type code to scsi fc headers (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: patch target code in prep for FC transport support (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: set sqe.command_id in core not transports (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [lib] parser: add u64 number parser (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: align to generic ib_event logging helper (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: align to generic ib_event logging helper (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: remove redundant define (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: Adjust source code indentation (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] scsi: Remove set-but-not-used variables (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: Fix possible infinite loop triggered on hot namespace removal (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: Fix a memory leak in an nvmf_create_ctrl() error path (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: Fix memory leaks in nvmf_parse_options() (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: force queue size to respect controller capability (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: Fix REJ status code (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme: move NVMe class code to pci_ids.h (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [block] blk-mq: blk_account_io_start() takes a bool (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] don't schedule multiple resets (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] pci: Don't free queues on error (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: drain the queue-pair just before freeing it (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: stop and free io queues on connect failure (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: don't forget to delete a queue from the list of connection failed (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: Don't queue fatal error work if csts.cfs is set (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: reject non-connect commands before the queue is live (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: Fix possible NULL deref when handling rdma cm events (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: use symbolic constants for CNS values (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] use symbolic constants for CNS values (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme.h: add an enum for cns values (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme.h: resync with nvme-cli (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme: Add tertiary number to NVME_VS (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme : Add sysfs entry for NVMe CMBs when appropriate (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] Delete created IO queues on reset (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] Stop probing a removed device (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] Pass pointers, not dma addresses, to nvme_get/set_features() (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] scsi: Remove power management support (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: Make dsm number of ranges zero based (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: Use direct IO for writes (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: revise host transport option descriptions (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: rework nvmf_get_address() for variable options (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [block] blk-mq: account higher order dispatch (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] blk-mq: allow the driver to pass in a queue mapping (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] blk-mq: only allocate a single mq_map per tag_set (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [block] blk-mq: don't redistribute hardware queues on a CPU hotplug event (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [block] blk-mq: skip unmapped queues in blk_mq_alloc_request_hctx (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: only clear queue flags after successful connect (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: fix null pointer dereference on req->mr (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: use ib_client API to detect device removal (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: add DELETING queue flag (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: destroy nvme queue rdma resources on connect failure (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme_rdma: keep a ref on the ctrl during delete/flush (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: Get rid of redundant defines (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: Get rid of duplicate variable (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: get a reference when reusing a nvme_host structure (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme-fabrics: change NQN UUID to big-endian format (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-loop: set sqsize to 0-based value, per spec (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: fix sqsize/hsqsize per spec (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] fabrics: define admin sqsize min default, per spec (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: +1 to *queue_size from hsqsize/hrqsize (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: Fix use after free (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: initialize ret to zero to avoid returning garbage (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: start async event handler after reconnecting to a controller (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: Fix controller serial number inconsistency (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: Don't use the inline buffer in order to avoid allocation for small reads (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: Correctly handle RDMA device hot removal (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: Make sure to shutdown the controller if we can (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-loop: Remove duplicate call to nvme_remove_namespaces (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: Free the I/O tags when we delete the controller (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: Remove duplicate call to nvme_remove_namespaces (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: Fix device removal handling (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: Queue ns scanning after a sucessful reconnection (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: Don't leak uninitialized memory in connect request private data (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] make NVME_RDMA depend on BLOCK (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] fabrics drivers don't need the nvme-pci driver (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] quirk: Add a delay before checking device ready for memblaze device (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] Fix nvme_get/set_features() with a NULL result pointer (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [block] Fix race triggered by blk_set_queue_dying() (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] Prevent controller state invalid transition (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [block] blk-mq: fix deadlock in blk_mq_register_disk() error path (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] pci: Provide SR-IOV support (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] don't allocate unused nvme_major (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] Limit command retries (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-loop: fix nvme-loop Kconfig dependencies (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: fix return value check in nvmet_subsys_alloc() (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: add-remove ctrl repeat fix (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: Remove tl_retry_count (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: Don't use tl_retry_count (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: fix the return value of nvme_rdma_reinit_request() (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: use IB_PD_UNSAFE_GLOBAL_RKEY (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] ib/core: add support to create a unsafe global rkey to ib_create_pd (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-rdma: add a NVMe over Fabrics RDMA host driver (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet-rdma: add a NVMe over Fabrics RDMA target driver (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme-rdma.h: Add includes for nvme rdma_cm negotiation (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] add new reconnecting controller state (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] blk-mq: Introduce blk_mq_reinit_tagset (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvmet: fix an error code (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-loop: add configfs dependency (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-loop: add a NVMe loopback host driver (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [lib] scatterlist: move SG pool code from SCSI driver to lib/sg_pool.c (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [scsi] rename SG related struct and functions (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [scsi] replace "mq" with "first_chunk" in SG functions (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [scsi] replace "scsi_data_buffer" with "sg_table" in SG functions (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvmet: add a generic NVMe target (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] configfs: switch ->default groups to a linked list (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] add keep-alive support (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme.h: Add keep-alive opcode and identify controller attribute (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] nvme-fabrics: add a generic NVMe over Fabrics library (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme.h: add NVMe over Fabrics definitions (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] add fabrics sysfs attributes (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] Modify and export sync command submission for fabrics (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] allow transitioning from NEW to LIVE state (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] blk-mq: add blk_mq_alloc_request_hctx (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] move the workaround for I/O queue-less controllers from PCIe to core (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme: factor out a add nvme_is_write helper (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] blk-mq: add a flags parameter to blk_mq_alloc_request (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] allow for size limitations from transport drivers (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme.h: add AER constants (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme.h: add constants for PSDT and FUSE values (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme.h: add NVM command set SQE/CQE size defines (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme.h: Add get_log_page command strucure (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] nvme.h: add RTD3R, RTD3E and OAES fields (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [block] blk-mq: actually hook up defer list when running requests (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] Fix removal in case of active namespace list scanning method (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] move nvme_cancel_request() to common code (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [nvme] update and rename nvme_cancel_io to nvme_cancel_request (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [kernel] block: add REQ_OP definitions and helpers (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [lib] drivers/scsi/scsi_debug.c: resolve sg buffer const-ness issue (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [lib] scatterlist: mark input buffer parameters as 'const' (David Milburn) [1384526 1389755 1366753 1374291 1383834]
- [lib] scatterlist.c: fix kerneldoc for sg_pcopy_{to, from}_buffer() (David Milburn) [1384526 1389755 1366753 1374291 1383834]

* Tue Mar 21 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-623.el7]
- [scsi] aacraid: Fix potential null access (Scott Benesh) [1384213]
- [scsi] aacraid: Fix typo in blink status (Scott Benesh) [1384213]
- [scsi] aacraid: remove redundant zero check on ret (Scott Benesh) [1384213]
- [scsi] aacraid: Fixed expander hotplug for SMART family (Scott Benesh) [1384213]
- [scsi] aacraid: Update driver version (Scott Benesh) [1384213]
- [scsi] aacraid: Fix a potential spinlock double unlock bug (Scott Benesh) [1384213]
- [scsi] aacraid: Save adapter fib log before an IOP reset (Scott Benesh) [1384213]
- [scsi] aacraid: Reorder Adapter status check (Scott Benesh) [1384213]
- [scsi] aacraid: Skip IOP reset on controller panic (SMART Family) (Scott Benesh) [1384213]
- [scsi] aacraid: Decrease adapter health check interval (Scott Benesh) [1384213]
- [scsi] aacraid: Reload offlined drives after controller reset (Scott Benesh) [1384213]
- [scsi] aacraid: Skip wellness sync on controller failure (Scott Benesh) [1384213]
- [scsi] aacraid: Fix sync fibs time out on controller reset (Scott Benesh) [1384213]
- [scsi] aacraid: Added sysfs for driver version (Scott Benesh) [1384213]
- [scsi] aacraid: Fix memory leak in fib init path (Scott Benesh) [1384213]
- [scsi] aacraid: Prevent E3 lockup when deleting units (Scott Benesh) [1384213]
- [scsi] aacraid: Fix for excessive prints on EEH (Scott Benesh) [1384213]
- [scsi] aacraid: Use correct channel number for raw srb (Scott Benesh) [1384213]
- [scsi] aacraid: Fix camel case (Scott Benesh) [1384213]
- [scsi] aacraid: avoid open-coded upper_32_bits (Scott Benesh) [1384213]
- [scsi] aacraid: rcode is unsigned and should be signed int (Scott Benesh) [1384213]
- [scsi] aacraid: update version (Scott Benesh) [1384213]
- [scsi] aacraid: Change Driver Version Prefix (Scott Benesh) [1384213]
- [scsi] aacraid: Update copyrights (Scott Benesh) [1384213]
- [scsi] aacraid: Retrieve HBA host information ioctl (Scott Benesh) [1384213]
- [scsi] aacraid: Added ioctl to trigger IOP/IWBR reset (Scott Benesh) [1384213]
- [scsi] aacraid: Added new IWBR reset (Scott Benesh) [1384213]
- [scsi] aacraid: VPD 83 type3 support (Scott Benesh) [1384213]
- [scsi] aacraid: Added support to abort cmd and reset lun (Scott Benesh) [1384213]
- [scsi] aacraid: Add task management functionality (Scott Benesh) [1384213]
- [scsi] aacraid: Include HBA direct interface (Scott Benesh) [1384213]
- [scsi] aacraid: Added support for hotplug (Scott Benesh) [1384213]
- [scsi] aacraid: Added support to set QD of attached drives (Scott Benesh) [1384213]
- [scsi] aacraid: Retrieve Queue Depth from Adapter FW (Scott Benesh) [1384213]
- [scsi] aacraid: Added support for periodic wellness sync (Scott Benesh) [1384213]
- [scsi] aacraid: Reworked aac_command_thread (Scott Benesh) [1384213]
- [scsi] aacraid: Added support for read medium error (Scott Benesh) [1384213]
- [scsi] aacraid: Added support for response path (Scott Benesh) [1384213]
- [scsi] aacraid: Process Error for response I/O (Scott Benesh) [1384213]
- [scsi] aacraid: Reworked scsi command submission path (Scott Benesh) [1384213]
- [scsi] aacraid: Retrieve and update the device types (Scott Benesh) [1384213]
- [scsi] aacraid: Added sa firmware support (Scott Benesh) [1384213]
- [scsi] aacraid: added support for init_struct_8 (Scott Benesh) [1384213]
- [scsi] aacraid: Added aacraid.h include guard (Scott Benesh) [1384213]
- [scsi] aacraid: Remove duplicate irq management code (Scott Benesh) [1384213]
- [scsi] aacraid: Replace <asm/uaccess.h> with <linux/uaccess.h> globally (Scott Benesh) [1384213]
- [scsi] aacraid: Fix INTx/MSI-x issue with older controllers (Scott Benesh) [1384213]
- [scsi] aacraid: mark aac_src_select_comm() static (Scott Benesh) [1384213]
- [scsi] aacraid: use kmemdup (Scott Benesh) [1384213]
- [scsi] qla2xxx: Fix apparent cut-n-paste error (Chad Dupuis) [1414957]
- [scsi] qla2xxx: Fix Target mode handling with Multiqueue changes (Chad Dupuis) [1414957]
- [scsi] qla2xxx: Add Block Multi Queue functionality (Chad Dupuis) [1414957]
- [scsi] qla2xxx: Add multiple queue pair functionality (Chad Dupuis) [1414957]
- [scsi] qla2xxx: Fix NULL pointer deref in QLA interrupt (Chad Dupuis) [1414957]
- [scsi] qla2xxx: Add irq affinity notification (Chad Dupuis) [1414957]

* Tue Mar 21 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-622.el7]
- [fs] vfs: In d_path don't call d_dname on a mount point (Aristeu Rozanski) [1418962]
- [hv] util: don't forget to init host_ts.lock (Vitaly Kuznetsov) [1388419]
- [hv] hv_utils: implement Hyper-V PTP source (Vitaly Kuznetsov) [1388419]
- [hv] export current Hyper-V clocksource (Vitaly Kuznetsov) [1388419]
- [hv] utils: Fix the mapping between host version and protocol to use (Vitaly Kuznetsov) [1388419]
- [hv] hv_util: Avoid dynamic allocation in time synch (Vitaly Kuznetsov) [1388419]
- [hv] utils: Support TimeSync version 4.0 protocol samples (Vitaly Kuznetsov) [1388419]
- [hv] utils: Use TimeSync samples to adjust the clock after boot (Vitaly Kuznetsov) [1388419]
- [mm] memory_hotplug: set magic number to page->freelist instead of page->lru.next (Yasuaki Ishimatsu) [1417692]
- [mm] sparse: use page_private() to get page->private value (Yasuaki Ishimatsu) [1417692]
- [mm] sparsemem: fix a bug in free_map_bootmem when CONFIG_SPARSEMEM_VMEMMAP (Yasuaki Ishimatsu) [1417696]
- [mm] sparsemem: use PAGES_PER_SECTION to remove redundant nr_pages parameter (Yasuaki Ishimatsu) [1417696]
- [x86] numa: Online memory-less nodes at boot time (Rui Wang) [1405893]
- [x86] mm/numa: Drop dead code and rename setup_node_data() to setup_alloc_data() (Rui Wang) [1405893]
- [x86] revert "mce: Do not panic when single core has reached a timeout" (Xunlei Pang) [1256375]
- [x86] mce: Handle broadcasted MCE gracefully with kexec (Xunlei Pang) [1256375]
- [net] dccp/tcp: fix routing redirect race (Eric Garver) [1387485]
- [net] ipv6: don't increase size when refragmenting forwarded ipv6 skbs (Florian Westphal) [1430571]
- [net] bridge: drop netfilter fake rtable unconditionally (Florian Westphal) [1430571]
- [net] ipv6: avoid write to a possibly cloned skb (Florian Westphal) [1430571]
- [net] netfilter: bridge: honor frag_max_size when refragmenting (Florian Westphal) [1430571]
- [net] l2tp: Avoid schedule while atomic in exit_net (Lance Richardson) [1429687]
- [net] l2tp: protect tunnel->del_work by ref_count (Lance Richardson) [1429687]
- [net] sctp: deny peeloff operation on asocs with threads sleeping on it (Hangbin Liu) [1429497] {CVE-2017-5986 CVE-2017-6353}
- [net] sctp: avoid BUG_ON on sctp_wait_for_sndbuf (Hangbin Liu) [1429497] {CVE-2017-5986 CVE-2017-6353}
- [net] sctp: set sin_port for addr param when checking duplicate address (Xin Long) [1308362]
- [net] sctp: sctp_transport_dst_check should check if transport pmtu is dst mtu (Xin Long) [1412865]
- [net] sctp: call rcu_read_lock before checking for duplicate transport nodes (Xin Long) [1383938]
- [net] sctp: check duplicate node before inserting a new transport (Xin Long) [1383938]
- [net] sctp: sctp_epaddr_lookup_transport should be protected by rcu_read_lock (Xin Long) [1383938]
- [net] sctp: use new rhlist interface on sctp transport rhashtable (Xin Long) [1383938]
- [net] Add netdev all_adj_list refcnt propagation to fix panic (Adrian Reber) [1425010]
- [hid] usbhid: change return error of usbhid_output_report (Benjamin Tissoires) [1401381]
- [scsi] storvsc: properly set residual data length on errors (Cathy Avery) [1364282]
- [sound] alsa: hda - add support for docking station for HP 840 G3 (Jaroslav Kysela) [1312217]
- [sound] alsa: hda - add support for docking station for HP 820 G2 (Jaroslav Kysela) [1312217]
- [kernel] rcu: Reverse rcu_dereference_check() conditions (Waiman Long) [1432967]
- [kernel] signals: avoid unnecessary taking of sighand->siglock (Waiman Long) [1412194]

* Tue Mar 21 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-621.el7]
- [fs] autofs: take more care to not update last_used on path walk (Ian Kent) [1413523]
- [fs] autofs: remove duplicated AUTOFS_DEV_IOCTL_SIZE definition (Ian Kent) [1413523]
- [fs] autofs: add command enum/macros for root-dir ioctls (Ian Kent) [1413523]
- [fs] autofs: update ioctl documentation regarding struct autofs_dev_ioctl (Ian Kent) [1413523]
- [fs] autofs: fix wrong ioctl documentation regarding devid (Ian Kent) [1413523]
- [fs] autofs: fix typo in Documentation (Ian Kent) [1413523]
- [fs] autofs: remove wrong comment (Ian Kent) [1413523]
- [fs] autofs: constify find_autofs_mount() callback (Ian Kent) [1413523]
- [fs] autofs: refactor ioctl fn vector in iookup_dev_ioctl() (Ian Kent) [1413523]
- [fs] autofs: remove possibly misleading /* #define DEBUG */ (Ian Kent) [1413523]
- [fs] autofs4: move linux/auto_dev-ioctl.h to uapi/linux (Ian Kent) [1413523]
- [fs] autofs: move inclusion of linux/limits.h to uapi (Ian Kent) [1413523]
- [fs] autofs: fix print format for ioctl warning message (Ian Kent) [1413523]
- [fs] autofs: add autofs_dev_ioctl_version() for AUTOFS_DEV_IOCTL_VERSION_CMD (Ian Kent) [1413523]
- [fs] autofs: fix dev ioctl number range check (Ian Kent) [1413523]
- [fs] autofs: fix pr_debug() message (Ian Kent) [1413523]
- [fs] autofs: update struct autofs_dev_ioctl in Documentation (Ian Kent) [1413523]
- [fs] autofs: fix Documentation regarding devid on ioctl (Ian Kent) [1413523]
- [fs] autofs: remove AUTOFS_DEVID_LEN (Ian Kent) [1413523]
- [fs] autofs: don't fail to free_dev_ioctl(param) (Ian Kent) [1413523]
- [fs] autofs: remove obsolete sb fields (Ian Kent) [1413523]
- [fs] autofs: use autofs4_free_ino() to kfree dentry data (Ian Kent) [1413523]
- [fs] autofs: remove ino free in autofs4_dir_symlink() (Ian Kent) [1413523]
- [fs] autofs: add WARN_ON(1) for non dir/link inode case (Ian Kent) [1413523]
- [fs] autofs: fix autofs4_fill_super() error exit handling (Ian Kent) [1413523]
- [fs] autofs: test autofs versions first on sb initialization (Ian Kent) [1413523]
- [fs] autofs: drop unnecessary extern in autofs_i.h (Ian Kent) [1413523]
- [fs] autofs: fix typos in Documentation/filesystems/autofs4.txt (Ian Kent) [1413523]
- [fs] autofs: use dentry flags to block walks during expire (Ian Kent) [1413523]
- [fs] qstr: constify instances in autofs4 (Ian Kent) [1413523]
- [fs] autofs: don't get stuck in a loop if vfs_write() returns an error (Ian Kent) [1413523]
- [fs] autofs races (Ian Kent) [1413523]
- [fs] autofs4: fix string.h include in auto_dev-ioctl.h (Ian Kent) [1413523]
- [fs] autofs4: use pr_xxx() macros directly for logging (Ian Kent) [1413523]
- [fs] autofs4: change log print macros to not insert newline (Ian Kent) [1413523]
- [fs] autofs4: make autofs log prints consistent (Ian Kent) [1413523]
- [fs] autofs4: fix some white space errors (Ian Kent) [1413523]
- [fs] autofs4: fix invalid ioctl return in autofs4_root_ioctl_unlocked() (Ian Kent) [1413523]
- [fs] autofs4: fix coding style line length in autofs4_wait() (Ian Kent) [1413523]
- [fs] autofs4: fix coding style problem in autofs4_get_set_timeout() (Ian Kent) [1413523]
- [fs] autofs4: coding style fixes (Ian Kent) [1413523]
- [fs] autofs: show pipe inode in mount options (Ian Kent) [1413523]
- [fs] autofs4: don't bother with d_instantiate(dentry, NULL) in ->lookup() (Ian Kent) [1413523]
- [fs] vfs: normal filesystems (and lustre): d_inode() annotations (Ian Kent) [1413523]
- [fs] vfs: Convert S_ISLNK/DIR/REG(dentry->d_inode) to d_is_*(dentry) (Ian Kent) [1413523]
- [fs] autofs4 copy_dev_ioctl(): keep the value of ->size we'd used for allocation (Ian Kent) [1413523]
- [fs] autofs4: Wrong format for printing dentry (Ian Kent) [1413523]
- [fs] assorted conversions to p[dD] (Ian Kent) [1413523]
- [fs] autofs: the documentation I wanted to read (Ian Kent) [1413523]
- [fs] autofs4: d_manage() should return -EISDIR when appropriate in rcu-walk mode (Ian Kent) [1413523]
- [fs] autofs4: avoid taking fs_lock during rcu-walk (Ian Kent) [1413523]
- [fs] autofs4: make "autofs4_can_expire" idempotent (Ian Kent) [1413523]
- [fs] autofs4: factor should_expire() out of autofs4_expire_indirect (Ian Kent) [1413523]
- [fs] autofs4: allow RCU-walk to walk through autofs4 (Ian Kent) [1413523]
- [fs] autofs4: comment typo: remove a a doubled word (Ian Kent) [1413523]
- [fs] autofs4: remove some unused inline functions (Ian Kent) [1413523]
- [fs] autofs4: don't take spinlock when not needed in autofs4_lookup_expiring (Ian Kent) [1413523]
- [fs] autofs4: remove a redundant assignment (Ian Kent) [1413523]
- [fs] autofs4: remove unused autofs4_ispending() (Ian Kent) [1413523]
- [fs] vfs: allow ->d_manage() to declare -EISDIR in rcu_walk mode (Ian Kent) [1413523]
- [fs] autofs4: fix false positive compile error (Ian Kent) [1413523]
- [fs] autofs4/dev-ioctl.c: add __init to autofs_dev_ioctl_init (Ian Kent) [1413523]
- [fs] autofs4: check dev ioctl size before allocating (Ian Kent) [1413523]
- [fs] autofs: use IS_ROOT to replace root dentry checks (Ian Kent) [1413523]
- [fs] autofs4: close the races around autofs4_notify_daemon() (Ian Kent) [1413523]

* Tue Mar 21 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-620.el7]
- [fs] fix unpaired rcu lock in prepend_path() ("Eric W. Biederman") [1247935]
- [fs] Add may_detach_mounts sysctl to hide new behavior ("Eric W. Biederman") [1247935]
- [fs] proc: Update proc_flush_task_mnt to use d_invalidate ("Eric W. Biederman") [1247935]
- [fs] mnt: Protect the mountpoint hashtable with mount_lock ("Eric W. Biederman") [1247935]
- [fs] mnt: Clear mnt_expire during pivot_root ("Eric W. Biederman") [1247935]
- [fs] clone_private_mount() doesn't need to touch namespace_sem ("Eric W. Biederman") [1247935]
- [fs] remove a bogus claim about namespace_sem being held by callers of mnt_alloc_id() ("Eric W. Biederman") [1247935]
- [fs] namespace: update event counter when umounting a deleted dentry ("Eric W. Biederman") [1247935]
- [fs] mnt: In detach_mounts detach the appropriate unmounted mount ("Eric W. Biederman") [1247935]
- [fs] mnt: Clarify and correct the disconnect logic in umount_tree ("Eric W. Biederman") [1247935]
- [fs] mnt: Update detach_mounts to leave mounts connected ("Eric W. Biederman") [1247935]
- [fs] mnt: Fix the error check in __detach_mounts ("Eric W. Biederman") [1247935]
- [fs] mnt: Honor MNT_LOCKED when detaching mounts ("Eric W. Biederman") [1247935]
- [fs] fs_pin: Allow for the possibility that m_list or s_list go unused ("Eric W. Biederman") [1247935]
- [fs] mnt: Factor umount_mnt from umount_tree ("Eric W. Biederman") [1247935]
- [fs] mnt: Factor out unhash_mnt from detach_mnt and umount_tree ("Eric W. Biederman") [1247935]
- [fs] mnt: Fail collect_mounts when applied to unmounted mounts ("Eric W. Biederman") [1247935]
- [fs] mnt: Don't propagate unmounts to locked mounts ("Eric W. Biederman") [1247935]
- [fs] mnt: On an unmount propagate clearing of MNT_LOCKED ("Eric W. Biederman") [1247935]
- [fs] mnt: Delay removal from the mount hash ("Eric W. Biederman") [1247935]
- [fs] mnt: Add MNT_UMOUNT flag ("Eric W. Biederman") [1247935]
- [fs] mnt: In umount_tree reuse mnt_list instead of mnt_hash ("Eric W. Biederman") [1247935]
- [fs] mnt: Don't propagate umounts in __detach_mounts ("Eric W. Biederman") [1247935]
- [fs] mnt: Improve the umount_tree flags ("Eric W. Biederman") [1247935]
- [fs] mnt: Use hlist_move_list in namespace_unlock ("Eric W. Biederman") [1247935]
- [fs] switch the IO-triggering parts of umount to fs_pin ("Eric W. Biederman") [1247935]
- [fs] new fs_pin killing logics ("Eric W. Biederman") [1247935]
- [fs] allow attaching fs_pin to a group not associated with some superblock ("Eric W. Biederman") [1247935]
- [fs] get rid of the second argument of acct_kill() ("Eric W. Biederman") [1247935]
- [fs] take count and rcu_head out of fs_pin ("Eric W. Biederman") [1247935]
- [fs] pull bumping refcount into ->kill() ("Eric W. Biederman") [1247935]
- [fs] kill pin_put() ("Eric W. Biederman") [1247935]
- [fs] btrfs: don't invalidate root dentry when subvolume deletion fails ("Eric W. Biederman") [1247935]
- [fs] mnt: Fix a memory stomp in umount ("Eric W. Biederman") [1247935]
- [fs] vfs: Remove d_drop calls from d_revalidate implementations ("Eric W. Biederman") [1247935]
- [fs] vfs: Make d_invalidate return void ("Eric W. Biederman") [1247935]
- [fs] vfs: Merge check_submounts_and_drop and d_invalidate ("Eric W. Biederman") [1247935]
- [fs] vfs: Remove unnecessary calls of check_submounts_and_drop ("Eric W. Biederman") [1247935]
- [fs] vfs: Lazily remove mounts on unlinked files and directories ("Eric W. Biederman") [1247935]
- [fs] vfs: More precise tests in d_invalidate ("Eric W. Biederman") [1247935]
- [fs] vfs: Document the effect of d_revalidate on d_find_alias ("Eric W. Biederman") [1247935]
- [fs] autofs - remove obsolete d_invalidate() from expire ("Eric W. Biederman") [1247935]
- [fs] vfs: Add a function to lazily unmount all mounts from any dentry ("Eric W. Biederman") [1247935]
- [fs] vfs: factor out lookup_mountpoint from new_mountpoint ("Eric W. Biederman") [1247935]
- [fs] vfs: Keep a list of mounts on a mount point ("Eric W. Biederman") [1247935]
- [fs] vfs: Don't allow overwriting mounts in the current mount namespace ("Eric W. Biederman") [1247935]
- [fs] delayed mntput ("Eric W. Biederman") [1247935]
- [fs] Add a missing permission check to do_umount ("Eric W. Biederman") [1247935]
- [fs] fix EBUSY on umount() from MNT_SHRINKABLE ("Eric W. Biederman") [1247935]
- [fs] get rid of propagate_umount() mistakenly treating slaves as busy ("Eric W. Biederman") [1247935]
- [fs] fix copy_tree() regression ("Eric W. Biederman") [1247935]
- [fs] death to mnt_pinned ("Eric W. Biederman") [1247935]
- [fs] make fs/{namespace, super}.c forget about acct.h ("Eric W. Biederman") [1247935]
- [fs] take fs_pin stuff to fs/* ("Eric W. Biederman") [1247935]
- [fs] start carving bsd_acct_struct up ("Eric W. Biederman") [1247935]
- [fs] acct: move mnt_pin() upwards ("Eric W. Biederman") [1247935]
- [fs] make acct_kill() wait for file closing ("Eric W. Biederman") [1247935]
- [fs] drop ->s_umount around acct_auto_close() ("Eric W. Biederman") [1247935]
- [fs] acct: get rid of acct_lock for acct->count ("Eric W. Biederman") [1247935]
- [fs] acct: get rid of acct_list ("Eric W. Biederman") [1247935]
- [fs] acct: simplify check_free_space() ("Eric W. Biederman") [1247935]
- [fs] acct: new lifetime rules ("Eric W. Biederman") [1247935]
- [fs] acct: serialize acct_on() ("Eric W. Biederman") [1247935]
- [fs] acct() should honour the limits from the very beginning ("Eric W. Biederman") [1247935]
- [fs] split the slow path in acct_process() off ("Eric W. Biederman") [1247935]
- [fs] separate namespace-independent parts of filling acct_t ("Eric W. Biederman") [1247935]
- [fs] acct: switch to __kernel_write() ("Eric W. Biederman") [1247935]
- [fs] acct: encode_comp_t(0) is 0, fortunately.. ("Eric W. Biederman") [1247935]
- [fs] vfs: Make delayed_free() call free_vfsmnt() ("Eric W. Biederman") [1247935]
- [fs] switch mnt_hash to hlist ("Eric W. Biederman") [1247935]
- [fs] keep shadowed vfsmounts together ("Eric W. Biederman") [1247935]
- [fs] resizable namespace.c hashes ("Eric W. Biederman") [1247935]
- [fs] vfs: Is mounted should be testing mnt_ns for NULL or error ("Eric W. Biederman") [1247935]
- [fs] fix bogus read_seqretry() checks introduced in b37199e ("Eric W. Biederman") [1247935]
- [fs] rcuwalk: recheck mount_lock after mountpoint crossing attempts ("Eric W. Biederman") [1247935]
- [fs] fix bogus path_put() of nd->root after some unlazy_walk() failures ("Eric W. Biederman") [1247935]
- [fs] get rid of {lock, unlock}_rcu_walk() ("Eric W. Biederman") [1247935]
- [fs] Use RH_KABI_EXTEND to wrap nameidata.m_seq ("Eric W. Biederman") [1247935]
- [fs] RCU'd vfsmounts ("Eric W. Biederman") [1247935]
- [fs] pid_namespace: make freeing struct pid_namespace rcu-delayed ("Eric W. Biederman") [1247935]
- [fs] fuse: rcu-delay freeing fuse_conn ("Eric W. Biederman") [1247935]
- [fs] ncpfs: rcu-delay unload_nls() and freeing ncp_server ("Eric W. Biederman") [1247935]
- [fs] fat: rcu-delay unloading nls and freeing sbi ("Eric W. Biederman") [1247935]
- [fs] adfs: delayed freeing of sbi ("Eric W. Biederman") [1247935]
- [fs] hpfs: make freeing sbi and codetables rcu-delayed ("Eric W. Biederman") [1247935]
- [fs] make freeing super_block rcu-delayed ("Eric W. Biederman") [1247935]
- [fs] move taking vfsmount_lock down into prepend_path() ("Eric W. Biederman") [1247935]
- [fs] vfs: make d_path() get the root path under RCU ("Eric W. Biederman") [1247935]
- [fs] vfs: don't copy things to user space holding the rcu readlock ("Eric W. Biederman") [1247935]
- [fs] vfs: make getcwd() get the root and pwd path under rcu ("Eric W. Biederman") [1247935]
- [fs] vfs: move get_fs_root_and_pwd() to single caller ("Eric W. Biederman") [1247935]
- [fs] split __lookup_mnt() in two functions ("Eric W. Biederman") [1247935]
- [fs] Readd include of linux/lglock.h in fs/internal.h to preserve the kabi ("Eric W. Biederman") [1247935]
- [fs] new helpers: lock_mount_hash/unlock_mount_hash ("Eric W. Biederman") [1247935]
- [fs] don't bother with vfsmount_lock in mounts_poll() ("Eric W. Biederman") [1247935]
- [fs] namespace.c: get rid of mnt_ghosts ("Eric W. Biederman") [1247935]
- [fs] fold dup_mnt_ns() into its only surviving caller ("Eric W. Biederman") [1247935]
- [fs] mnt_set_expiry() doesn't need vfsmount_lock ("Eric W. Biederman") [1247935]
- [fs] finish_automount() doesn't need vfsmount_lock for removal from expiry list ("Eric W. Biederman") [1247935]
- [fs] namespace.c: bury long-dead define ("Eric W. Biederman") [1247935]
- [fs] fold mntfree() into mntput_no_expire() ("Eric W. Biederman") [1247935]
- [fs] do_remount(): pull touch_mnt_namespace() up ("Eric W. Biederman") [1247935]
- [fs] dup_mnt_ns(): get rid of pointless grabbing of vfsmount_lock ("Eric W. Biederman") [1247935]
- [fs] initialize namespace_sem statically ("Eric W. Biederman") [1247935]
- [fs] put_mnt_ns(): use drop_collected_mounts() ("Eric W. Biederman") [1247935]

* Mon Mar 20 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-619.el7]
- [fs] ext4: unmap metadata when zeroing blocks (Eric Sandeen) [1430424]
- [fs] ext4: handle transient ENOSPC properly for DAX (Eric Sandeen) [1347247 1430424]
- [mm] dax: fix deadlock with DAX 4k holes (Eric Sandeen) [1430424]
- [fs] ext4: avoid split extents for DAX writes (Eric Sandeen) [1430424]
- [fs] ext4: only set S_DAX if DAX is really supported (Eric Sandeen) [1430424]
- [fs] dax: move put_(un)locked_mapping_entry() in dax.c (Eric Sandeen) [1430424]
- [fs] dax: move RADIX_DAX_* defines to dax.h (Eric Sandeen) [1430424]
- [fs] dax: remove dax_pmd_fault() (Eric Sandeen) [1430424]
- [mm] dax: coordinate locking for offsets in PMD range (Eric Sandeen) [1430424]
- [fs] dax: consistent variable naming for DAX entries (Eric Sandeen) [1430424]
- [fs] dax: remove the last BUG_ON() from fs/dax.c (Eric Sandeen) [1430424]
- [fs] dax: make 'wait_table' global variable static (Eric Sandeen) [1430424]
- [fs] dax: remove buffer_size_valid() (Eric Sandeen) [1430424]
- [fs] ext4: tell DAX the size of allocation holes (Eric Sandeen) [1430424]
- [fs] ext4: more efficient SEEK_DATA implementation (Eric Sandeen) [1430424]
- [fs] ext4: return hole from ext4_map_blocks() (Eric Sandeen) [1430424]
- [fs] ext4: factor out determining of hole size (Eric Sandeen) [1430424]
- [fs] ext4: allow DAX writeback for hole punch (Eric Sandeen) [1430424]
- [fs] xfs: fix locking for DAX writes (Eric Sandeen) [1430424]
- [fs] dax: don't pass buffer_head to copy_user_dax (Eric Sandeen) [1430424]
- [fs] dax: don't pass buffer_head to dax_insert_mapping (Eric Sandeen) [1430424]
- [mm] silently skip readahead for DAX inodes (Eric Sandeen) [1366943 1430424]
- [fs] xfs: don't invalidate whole file on DAX read/write (Eric Sandeen) [1430424]
- [fs] dax: remote unused fault wrappers (Eric Sandeen) [1430424]
- [fs] dax: Remove i_mmap_lock protection (Eric Sandeen) [1430424]
- [mm] dax: Use radix tree entry lock to protect cow faults (Eric Sandeen) [1430424]
- [mm] dax: New fault locking (Eric Sandeen) [1430424]
- [mm] dax: Allow DAX code to replace exceptional entries (Eric Sandeen) [1430424]
- [fs] dax: Define DAX lock bit for radix tree exceptional entry (Eric Sandeen) [1430424]
- [fs] dax: Make huge page handling depend of CONFIG_BROKEN (Eric Sandeen) [1430424]
- [fs] dax: Fix condition for filling of PMD holes (Eric Sandeen) [1430424]
- [fs] dax: fix a comment in dax_zero_page_range and dax_truncate_page (Eric Sandeen) [1430424]
- [fs] dax: for truncate/hole-punch, do zeroing through the driver if possible (Eric Sandeen) [1430424]
- [fs] dax: export a low-level __dax_zero_page_range helper (Eric Sandeen) [1430424]
- [fs] dax: use sb_issue_zerout instead of calling dax_clear_sectors (Eric Sandeen) [1430424]
- [fs] dax: fallback from pmd to pte on error (Eric Sandeen) [1430424]
- [fs] dax: Remove redundant inode size checks (Eric Sandeen) [1430424]
- [fs] dax: Remove pointless writeback from dax_do_io() (Eric Sandeen) [1430424]
- [fs] dax: Remove zeroing from dax_io() (Eric Sandeen) [1430424]
- [fs] dax: Remove dead zeroing code from fault handlers (Eric Sandeen) [1430424]
- [fs] dax: Remove complete_unwritten argument (Eric Sandeen) [1430424]
- [fs] dax: move RADIX_DAX_ definitions to dax.c (Eric Sandeen) [1430424]
- [fs] dax: call get_blocks() with create == 1 for write faults to unwritten extents (Eric Sandeen) [1430424]
- [fs] ext4: cleanup handling of bh->b_state in DAX mmap (Eric Sandeen) [1430424]
- [fs] ext4: fix bh->b_state corruption (Eric Sandeen) [1430424]
- [fs] xfs: split direct I/O and DAX path (Eric Sandeen) [1430424]
- [fs] xfs: direct calls in the direct I/O path (Eric Sandeen) [1430424]
- [fs] xfs: fold xfs_vm_do_dio into xfs_vm_direct_IO (Eric Sandeen) [1430424]
- [fs] xfs: using generic_file_direct_write() is unnecessary (Eric Sandeen) [1430424]
- [fs] xfs: stop using generic_file_read_iter for direct I/O (Eric Sandeen) [1430424]
- [fs] xfs: split xfs_file_read_iter into buffered and direct I/O helpers (Eric Sandeen) [1430424]
- [fs] xfs: remove s_maxbytes enforcement in xfs_file_read_iter (Eric Sandeen) [1430424]
- [fs] xfs: kill ioflags (Eric Sandeen) [1430424]
- [fs] xfs: don't pass ioflags around in the ioctl path (Eric Sandeen) [1430424]

* Mon Mar 20 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-618.el7]
- [fs] vfs: pull btrfs clone API to vfs layer (Bill O'Donnell) [1399590]
- [fs] btrfs: add .copy_file_range file operation (Bill O'Donnell) [1399590]
- [fs] btrfs: fix btrfs_compat_ioctl failures on non-compat ioctls (Bill O'Donnell) [1399590]
- [fs] btrfs: fix truncate down when no_holes feature is enabled (Bill O'Donnell) [1399590]
- [fs] btrfs: Fix deadlock between direct IO and fast fsync (Bill O'Donnell) [1399590]
- [fs] btrfs: fix false enospc error when truncating heavily reflinked file (Bill O'Donnell) [1399590]
- [fs] btrfs: adjust outstanding_extents counter properly when dio write is split (Bill O'Donnell) [1399590]
- [fs] btrfs: fix lockdep warning about log_mutex (Bill O'Donnell) [1399590]
- [fs] btrfs: use down_read_nested to make lockdep silent (Bill O'Donnell) [1399590]
- [fs] btrfs: fix locking when we put back a delayed ref that's too new (Bill O'Donnell) [1399590]
- [fs] btrfs: fix error handling when run_delayed_extent_op fails (Bill O'Donnell) [1399590]
- [fs] btrfs: return the actual error value from from btrfs_uuid_tree_iterate (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race in btrfs_free_dummy_fs_info() (Bill O'Donnell) [1399590]
- [fs] btrfs: limit async_work allocation and worker func duration (Bill O'Donnell) [1399590]
- [fs] btrfs: fix tree search logic when replaying directory entry deletes (Bill O'Donnell) [1399590]
- [fs] btrfs: fix deadlock caused by fsync when logging directory entries (Bill O'Donnell) [1399590]
- [fs] btrfs: fix enospc in hole punching (Bill O'Donnell) [1399590]
- [fs] btrfs: improve delayed refs iterations (Bill O'Donnell) [1399590]
- [fs] btrfs: qgroup: Add comments explaining how btrfs qgroup works (Bill O'Donnell) [1399590]
- [fs] btrfs: Ensure proper sector alignment for btrfs_free_reserved_data_space (Bill O'Donnell) [1399590]
- [fs] btrfs: abort transaction if fill_holes() fails (Bill O'Donnell) [1399590]
- [fs] btrfs: fix file extent corruption (Bill O'Donnell) [1399590]
- [fs] btrfs: cleanup: use already calculated value in btrfs_should_throttle_delayed_refs() (Bill O'Donnell) [1399590]
- [fs] btrfs: fix qgroup rescan worker initialization (Bill O'Donnell) [1399590]
- [fs] btrfs: fix emptiness check for dirtied extent buffers at check_leaf() (Bill O'Donnell) [1399590]
- [fs] btrfs: fix BUG_ON in btrfs_mark_buffer_dirty (Bill O'Donnell) [1399590]
- [fs] btrfs: fix relocation incorrectly dropping data references (Bill O'Donnell) [1399590]
- [fs] btrfs: fix races on root_log_ctx lists (Bill O'Donnell) [1399590]
- [fs] btrfs: fix WARNING in btrfs_select_ref_head() (Bill O'Donnell) [1399590]
- [fs] btrfs: remove some no-op casts (Bill O'Donnell) [1399590]
- [fs] btrfs: pass correct args to btrfs_async_run_delayed_refs() (Bill O'Donnell) [1399590]
- [fs] btrfs: make file clone aware of fatal signals (Bill O'Donnell) [1399590]
- [fs] btrfs: qgroup: Prevent qgroup->reserved from going subzero (Bill O'Donnell) [1399590]
- [fs] btrfs: kill BUG_ON in do_relocation (Bill O'Donnell) [1399590]
- [fs] btrfs: fix incremental send failure caused by balance (Bill O'Donnell) [1399590]
- [fs] revert "btrfs: let btrfs_delete_unused_bgs() to clean relocated bgs" (Bill O'Donnell) [1399590]
- [fs] btrfs: tests: uninline member definitions in free_space_extent (Bill O'Donnell) [1399590]
- [fs] btrfs: tests: constify free space extent specs (Bill O'Donnell) [1399590]
- [fs] btrfs: expand free space tree sanity tests to catch endianness bug (Bill O'Donnell) [1399590]
- [fs] btrfs: fix extent buffer bitmap tests on big-endian systems (Bill O'Donnell) [1399590]
- [fs] btrfs: catch invalid free space trees (Bill O'Donnell) [1399590]
- [fs] btrfs: fix mount -o clear_cache, space_cache=v2 (Bill O'Donnell) [1399590]
- [fs] btrfs: fix free space tree bitmaps on big-endian systems (Bill O'Donnell) [1399590]
- [fs] btrfs: remove unnecessary btrfs_mark_buffer_dirty in split_leaf (Bill O'Donnell) [1399590]
- [fs] btrfs: don't BUG() during drop snapshot (Bill O'Donnell) [1399590]
- [fs] btrfs: fix btrfs_no_printk stub helper (Bill O'Donnell) [1399590]
- [fs] btrfs: memset to avoid stale content in btree leaf (Bill O'Donnell) [1399590]
- [fs] btrfs: parent_start initialization cleanup (Bill O'Donnell) [1399590]
- [fs] btrfs: Remove already completed TODO comment (Bill O'Donnell) [1399590]
- [fs] btrfs: Do not reassign count in btrfs_run_delayed_refs (Bill O'Donnell) [1399590]
- [fs] btrfs: fix a possible umount deadlock (Bill O'Donnell) [1399590]
- [fs] btrfs: fix memory leak in do_walk_down (Bill O'Donnell) [1399590]
- [fs] btrfs: unsplit printed strings (Bill O'Donnell) [1399590]
- [fs] btrfs: clean the old superblocks before freeing the device (Bill O'Donnell) [1399590]
- [fs] btrfs: kill BUG_ON in run_delayed_tree_ref (Bill O'Donnell) [1399590]
- [fs] btrfs: don't leak reloc root nodes on error (Bill O'Donnell) [1399590]
- [fs] btrfs: squash lines for simple wrapper functions (Bill O'Donnell) [1399590]
- [fs] btrfs: improve check_node to avoid reading corrupted nodes (Bill O'Donnell) [1399590]
- [fs] btrfs: add error handling for extent buffer in print tree (Bill O'Donnell) [1399590]
- [fs] btrfs: remove BUG_ON in start_transaction (Bill O'Donnell) [1399590]
- [fs] btrfs: memset to avoid stale content in btree node block (Bill O'Donnell) [1399590]
- [fs] btrfs: return gracefully from balance if fs tree is corrupted (Bill O'Donnell) [1399590]
- [fs] btrfs: kill BUG_ON()'s in btrfs_mark_extent_written (Bill O'Donnell) [1399590]
- [fs] btrfs: kill the start argument to read_extent_buffer_pages (Bill O'Donnell) [1399590]
- [fs] btrfs: add a flags field to btrfs_fs_info (Bill O'Donnell) [1399590]
- [fs] btrfs: extend btrfs_set_extent_delalloc and its friends to support in-band dedupe and subpage size patchset (Bill O'Donnell) [1399590]
- [fs] btrfs: add dynamic debug support (Bill O'Donnell) [1399590]
- [fs] btrfs: Fix warning "variable 'gen' set but not used" (Bill O'Donnell) [1399590]
- [fs] btrfs: Fix warning "variable 'blocksize' set but not used" (Bill O'Donnell) [1399590]
- [fs] btrfs: let btrfs_delete_unused_bgs() to clean relocated bgs (Bill O'Donnell) [1399590]
- [fs] btrfs: bail out if block group has different mixed flag (Bill O'Donnell) [1399590]
- [fs] btrfs: fix memory leak in reading btree blocks (Bill O'Donnell) [1399590]
- [fs] btrfs: fix check_shared for fiemap ioctl (Bill O'Donnell) [1399590]
- [fs] btrfs: create example debugfs file only in debugging build (Bill O'Donnell) [1399590]
- [fs] btrfs: fix perms on demonstration debugfs interface (Bill O'Donnell) [1399590]
- [fs] btrfs: fix memory leak of block group cache (Bill O'Donnell) [1399590]
- [fs] btrfs: ensure that file descriptor used with subvol ioctls is a dir (Bill O'Donnell) [1399590]
- [fs] btrfs: handle quota reserve failure properly (Bill O'Donnell) [1399590]
- [fs] btrfs: use filemap_check_errors() (Bill O'Donnell) [1399590]
- [mm] export filemap_check_errors() to modules (Bill O'Donnell) [1399590]
- [fs] btrfs: introduce tickets_id to determine whether asynchronous metadata reclaim work makes progress (Bill O'Donnell) [1399590]
- [fs] btrfs: remove root_log_ctx from ctx list before btrfs_sync_log returns (Bill O'Donnell) [1399590]
- [fs] btrfs: do not decrease bytes_may_use when replaying extents (Bill O'Donnell) [1399590]
- [fs] btrfs: fix one bug that process may endlessly wait for ticket in wait_reserve_ticket() (Bill O'Donnell) [1399590]
- [fs] btrfs: fix endless loop in balancing block groups (Bill O'Donnell) [1399590]
- [fs] btrfs: kill invalid ASSERT() in process_all_refs() (Bill O'Donnell) [1399590]
- [fs] btrfs: fix lockdep warning on deadlock against an inode's log mutex (Bill O'Donnell) [1399590]
- [fs] btrfs: detect corruption when non-root leaf has zero item (Bill O'Donnell) [1399590]
- [fs] btrfs: check btree node's nritems (Bill O'Donnell) [1399590]
- [fs] btrfs: don't create or leak aliased root while cleaning up orphans (Bill O'Donnell) [1399590]
- [fs] btrfs: fix em leak in find_first_block_group (Bill O'Donnell) [1399590]
- [fs] btrfs: do not background blkdev_put() (Bill O'Donnell) [1399590]
- [fs] btrfs: clarify do_chunk_alloc()'s return value (Bill O'Donnell) [1399590]
- [fs] btrfs: fix fsfreeze hang caused by delayed iputs deal (Bill O'Donnell) [1399590]
- [fs] btrfs: update btrfs_space_info's bytes_may_use timely (Bill O'Donnell) [1399590]
- [fs] btrfs: divide btrfs_update_reserved_bytes() into two functions (Bill O'Donnell) [1399590]
- [fs] btrfs: use correct offset for reloc_inode in prealloc_file_extent_cluster() (Bill O'Donnell) [1399590]
- [fs] btrfs: qgroup: Fix qgroup incorrectness caused by log replay (Bill O'Donnell) [1399590]
- [fs] btrfs: relocation: Fix leaking qgroups numbers on data extents (Bill O'Donnell) [1399590]
- [fs] btrfs: qgroup: Refactor btrfs_qgroup_insert_dirty_extent() (Bill O'Donnell) [1399590]
- [fs] btrfs: waiting on qgroup rescan should not always be interruptible (Bill O'Donnell) [1399590]
- [fs] btrfs: properly track when rescan worker is running (Bill O'Donnell) [1399590]
- [fs] btrfs: flush_space: treat return value of do_chunk_alloc properly (Bill O'Donnell) [1399590]
- [fs] btrfs: add ASSERT for block group's memory leak (Bill O'Donnell) [1399590]
- [fs] btrfs: backref: Fix soft lockup in __merge_refs function (Bill O'Donnell) [1399590]
- [fs] btrfs: fix memory leak of reloc_root (Bill O'Donnell) [1399590]
- [fs] btrfs: fix __MAX_CSUM_ITEMS (Bill O'Donnell) [1399590]
- [fs] btrfs: remove unused function btrfs_add_delayed_qgroup_reserve() (Bill O'Donnell) [1399590]
- [fs] btrfs: improve performance on fsync against new inode after rename/unlink (Bill O'Donnell) [1399590]
- [fs] btrfs: be more precise on errors when getting an inode from disk (Bill O'Donnell) [1399590]
- [fs] btrfs: send, don't bug on inconsistent snapshots (Bill O'Donnell) [1399590]
- [fs] btrfs: send, avoid incorrect leaf accesses when sending utimes operations (Bill O'Donnell) [1399590]
- [fs] btrfs: send, add missing error check for calls to path_loop() (Bill O'Donnell) [1399590]
- [fs] btrfs: send, fix failure to move directories with the same name around (Bill O'Donnell) [1399590]
- [fs] btrfs: add missing check for writeback errors on fsync (Bill O'Donnell) [1399590]
- [fs] btrfs: btrfs_relocate_chunk pass extent_root to btrfs_end_transaction (Bill O'Donnell) [1399590]
- [fs] btrfs: convert nodesize macros to static inlines (Bill O'Donnell) [1399590]
- [fs] btrfs: introduce BTRFS_MAX_ITEM_SIZE (Bill O'Donnell) [1399590]
- [fs] btrfs: cleanup, remove prototype for btrfs_find_root_ref (Bill O'Donnell) [1399590]
- [fs] btrfs: copy_to_sk drop unused root parameter (Bill O'Donnell) [1399590]
- [fs] btrfs: simpilify btrfs_subvol_inherit_props (Bill O'Donnell) [1399590]
- [fs] btrfs: tests, use BTRFS_FS_STATE_DUMMY_FS_INFO instead of dummy root (Bill O'Donnell) [1399590]
- [fs] btrfs: tests, require fs_info for root (Bill O'Donnell) [1399590]
- [fs] btrfs: tests, move initialization into tests/ (Bill O'Donnell) [1399590]
- [fs] btrfs: btrfs_test_opt and friends should take a btrfs_fs_info (Bill O'Donnell) [1399590]
- [fs] btrfs: plumb fs_info into btrfs_work (Bill O'Donnell) [1399590]
- [fs] btrfs: remove obsolete part of comment in statfs (Bill O'Donnell) [1399590]
- [fs] btrfs: hide test-only member under ifdef (Bill O'Donnell) [1399590]
- [fs] btrfs: Add ratelimit to btrfs printing (Bill O'Donnell) [1399590]
- [kernel] ratelimit: add initialization macro (Bill O'Donnell) [1399590]
- [fs] btrfs: fix unexpected balance crash due to BUG_ON (Bill O'Donnell) [1399590]
- [fs] btrfs: fix panic in balance due to EIO (Bill O'Donnell) [1399590]
- [fs] btrfs: fix eb memory leak due to readpage failure (Bill O'Donnell) [1399590]
- [fs] btrfs: change BUG_ON()'s to ASSERT()'s in backref_cache_cleanup() (Bill O'Donnell) [1399590]
- [fs] btrfs: fix free space calculation in dump_space_info() (Bill O'Donnell) [1399590]
- [fs] btrfs: subpage-blocksize: Rate limit scrub error message (Bill O'Donnell) [1399590]
- [fs] btrfs: expand cow_file_range() to support in-band dedup and subpage-blocksize (Bill O'Donnell) [1399590]
- [fs] btrfs: make sure device is synced before return (Bill O'Donnell) [1399590]
- [fs] btrfs: reorg btrfs_close_one_device() (Bill O'Donnell) [1399590]
- [fs] btrfs: Cleanup compress_file_range() (Bill O'Donnell) [1399590]
- [fs] btrfs: cleanup BUG_ON in merge_bio (Bill O'Donnell) [1399590]
- [fs] btrfs: Fix slab accounting flags (Bill O'Donnell) [1399590]
- [fs] btrfs: Replace -ENOENT by -ERANGE in btrfs_get_acl() (Bill O'Donnell) [1399590]
- [fs] btrfs: Handle uninitialised inode eviction (Bill O'Donnell) [1399590]
- [fs] btrfs: fix read_node_slot to return errors (Bill O'Donnell) [1399590]
- [fs] btrfs: fix double free of fs root (Bill O'Donnell) [1399590]
- [fs] btrfs: error out if generic_bin_search get invalid arguments (Bill O'Donnell) [1399590]
- [fs] btrfs: check inconsistence between chunk and block group (Bill O'Donnell) [1399590]
- [fs] btrfs: add missing bytes_readonly attribute file in sysfs (Bill O'Donnell) [1399590]
- [fs] btrfs: fix delalloc accounting after copy_from_user faults (Bill O'Donnell) [1399590]
- [fs] btrfs: avoid deadlocks during reservations in btrfs_truncate_block (Bill O'Donnell) [1399590]
- [fs] btrfs: use FLUSH_LIMIT for relocation in reserve_metadata_bytes (Bill O'Donnell) [1399590]
- [fs] btrfs: fill relocation block rsv after allocation (Bill O'Donnell) [1399590]
- [fs] btrfs: always use trans->block_rsv for orphans (Bill O'Donnell) [1399590]
- [fs] btrfs: change how we calculate the global block rsv (Bill O'Donnell) [1399590]
- [fs] btrfs: use root when checking need_async_flush (Bill O'Donnell) [1399590]
- [fs] btrfs: don't bother kicking async if there's nothing to reclaim (Bill O'Donnell) [1399590]
- [fs] btrfs: fix release reserved extents trace points (Bill O'Donnell) [1399590]
- [fs] btrfs: add tracepoints for flush events (Bill O'Donnell) [1399590]
- [fs] btrfs: fix delalloc reservation amount tracepoint (Bill O'Donnell) [1399590]
- [fs] btrfs: trace pinned extents (Bill O'Donnell) [1399590]
- [fs] btrfs: introduce ticketed enospc infrastructure (Bill O'Donnell) [1399590]
- [fs] btrfs: add tracepoint for adding block groups (Bill O'Donnell) [1399590]
- [fs] btrfs: warn_on for unaccounted spaces (Bill O'Donnell) [1399590]
- [fs] btrfs: change delayed reservation fallback behavior (Bill O'Donnell) [1399590]
- [fs] btrfs: always reserve metadata for delalloc extents (Bill O'Donnell) [1399590]
- [fs] btrfs: fix callers of btrfs_block_rsv_migrate (Bill O'Donnell) [1399590]
- [fs] btrfs: add bytes_readonly to the spaceinfo at once (Bill O'Donnell) [1399590]
- [fs] btrfs: Force stripesize to the value of sectorsize (Bill O'Donnell) [1399590]
- [fs] btrfs: fix disk_i_size update bug when fallocate() fails (Bill O'Donnell) [1399590]
- [fs] btrfs: fix error handling in map_private_extent_buffer (Bill O'Donnell) [1399590]
- [fs] btrfs: fix error return code in btrfs_init_test_fs() (Bill O'Donnell) [1399590]
- [fs] btrfs: don't do nocow check unless we have to (Bill O'Donnell) [1399590]
- [fs] btrfs: fix deadlock in delayed_ref_async_start (Bill O'Donnell) [1399590]
- [fs] btrfs: track transid for delayed ref flushing (Bill O'Donnell) [1399590]
- [fs] btrfs: btrfs_check_super_valid: Allow 4096 as stripesize (Bill O'Donnell) [1399590]
- [fs] btrfs: remove build fixup for qgroup_account_snapshot (Bill O'Donnell) [1399590]
- [fs] btrfs: use new error message helper in qgroup_account_snapshot (Bill O'Donnell) [1399590]
- [fs] btrfs: avoid blocking open_ctree from cleaner_kthread (Bill O'Donnell) [1399590]
- [fs] btrfs: don't BUG_ON() in btrfs_orphan_add (Bill O'Donnell) [1399590]
- [fs] btrfs: account for non-CoW'd blocks in btrfs_abort_transaction (Bill O'Donnell) [1399590]
- [fs] btrfs: check if extent buffer is aligned to sectorsize (Bill O'Donnell) [1399590]
- [fs] btrfs: Use correct format specifier (Bill O'Donnell) [1399590]
- [fs] btrfs: self-tests: Fix extent buffer bitmap test fail on BE system (Bill O'Donnell) [1399590]
- [fs] btrfs: self-tests: Fix test_bitmaps fail on 64k sectorsize (Bill O'Donnell) [1399590]
- [fs] btrfs: self-tests: Use macros instead of constants and add missing newline (Bill O'Donnell) [1399590]
- [fs] btrfs: self-tests: Support testing all possible sectorsizes and nodesizes (Bill O'Donnell) [1399590]
- [fs] btrfs: self-tests: Execute page straddling test only when nodesize < PAGE_SIZE (Bill O'Donnell) [1399590]
- [fs] btrfs: advertise which crc32c implementation is being used at module load (Bill O'Donnell) [1399590]
- [fs] btrfs: add validadtion checks for chunk loading (Bill O'Donnell) [1399590]
- [fs] btrfs: add more validation checks for superblock (Bill O'Donnell) [1399590]
- [fs] btrfs: clear uptodate flags of pages in sys_array eb (Bill O'Donnell) [1399590]
- [fs] btrfs: deal with duplciates during extent_map insertion in btrfs_get_extent (Bill O'Donnell) [1399590]
- [fs] btrfs: self-tests: Support non-4k page size (Bill O'Donnell) [1399590]
- [fs] btrfs: Fix integer overflow when calculating bytes_per_bitmap (Bill O'Donnell) [1399590]
- [fs] btrfs: test_check_exists: Fix infinite loop when searching for free space entries (Bill O'Donnell) [1399590]
- [fs] btrfs: end transaction if we abort when creating uuid root (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race between device replace and read repair (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race between device replace and discard (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race between device replace and chunk allocation (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race setting block group back to RW mode during device replace (Bill O'Donnell) [1399590]
- [fs] btrfs: fix unprotected assignment of the left cursor for device replace (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race setting block group readonly during device replace (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race between device replace and block group removal (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race between readahead and device replace/removal (Bill O'Donnell) [1399590]
- [fs] btrfs: fix handling of faults from btrfs_copy_from_user (Bill O'Donnell) [1399590]
- [fs] btrfs: scrub: Set bbio to NULL before calling btrfs_map_block (Bill O'Donnell) [1399590]
- [fs] btrfs: fix unexpected return value of fiemap (Bill O'Donnell) [1399590]
- [fs] btrfs: free sys_array eb as soon as possible (Bill O'Donnell) [1399590]
- [fs] btrfs: fix memory leak during RAID 5/6 device replacement (Bill O'Donnell) [1399590]
- [fs] btrfs: add semaphore to synchronize direct IO writes with fsync (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race between block group relocation and nocow writes (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race between fsync and direct IO writes for prealloc extents (Bill O'Donnell) [1399590]
- [fs] btrfs: pin log earlier when renaming (Bill O'Donnell) [1399590]
- [fs] btrfs: unpin log if rename operation fails (Bill O'Donnell) [1399590]
- [fs] btrfs: don't do unnecessary delalloc flushes when relocating (Bill O'Donnell) [1399590]
- [fs] btrfs: don't wait for unrelated IO to finish before relocation (Bill O'Donnell) [1399590]
- [fs] btrfs: fix empty symlink after creating symlink and fsync parent dir (Bill O'Donnell) [1399590]
- [fs] btrfs: fix for incorrect directory entries after fsync log replay (Bill O'Donnell) [1399590]
- [fs] btrfs: build fixup for qgroup_account_snapshot (Bill O'Donnell) [1399590]
- [fs] btrfs: qgroup: Fix qgroup accounting when creating snapshot (Bill O'Donnell) [1399590]
- [fs] btrfs: fix fspath error deallocation (Bill O'Donnell) [1399590]
- [fs] btrfs: make find_workspace warn if there are no workspaces (Bill O'Donnell) [1399590]
- [fs] btrfs: make find_workspace always succeed (Bill O'Donnell) [1399590]
- [fs] btrfs: preallocate compression workspaces (Bill O'Donnell) [1399590]
- [fs] btrfs: rename and document compression workspace members (Bill O'Donnell) [1399590]
- [fs] btrfs: GFP_NOFS does not GFP_HIGHMEM (Bill O'Donnell) [1399590]
- [fs] btrfs: switch to common message helpers in open_ctree, adjust messages (Bill O'Donnell) [1399590]
- [fs] btrfs: fix int32 overflow in shrink_delalloc() (Bill O'Donnell) [1399590]
- [fs] btrfs: don't force mounts to wait for cleaner_kthread to delete one or more subvolumes (Bill O'Donnell) [1399590]
- [fs] btrfs: add write protection to SET_FEATURES ioctl (Bill O'Donnell) [1399590]
- [fs] btrfs: fix lock dep warning move scratch super outside of chunk_mutex (Bill O'Donnell) [1399590]
- [fs] btrfs: Fix BUG_ON condition in scrub_setup_recheck_block() (Bill O'Donnell) [1399590]
- [fs] btrfs: remove BUG_ON()'s in btrfs_map_block (Bill O'Donnell) [1399590]
- [fs] btrfs: fix divide error upon chunk's stripe_len (Bill O'Donnell) [1399590]
- [fs] btrfs: sysfs: protect reading label by lock (Bill O'Donnell) [1399590]
- [fs] btrfs: add check to sysfs handler of label (Bill O'Donnell) [1399590]
- [fs] btrfs: add read-only check to sysfs handler of features (Bill O'Donnell) [1399590]
- [fs] btrfs: reuse existing variable in scrub_stripe, reduce stack usage (Bill O'Donnell) [1399590]
- [fs] btrfs: use dynamic allocation for root item in create_subvol (Bill O'Donnell) [1399590]
- [fs] btrfs: clone: use vmalloc only as fallback for nodesize bufer (Bill O'Donnell) [1399590]
- [fs] btrfs: send: use vmalloc only as fallback for clone_sources_tmp (Bill O'Donnell) [1399590]
- [fs] btrfs: send: use vmalloc only as fallback for clone_roots (Bill O'Donnell) [1399590]
- [fs] btrfs: send: use temporary variable to store allocation size (Bill O'Donnell) [1399590]
- [fs] btrfs: send: use vmalloc only as fallback for read_buf (Bill O'Donnell) [1399590]
- [fs] btrfs: send: use vmalloc only as fallback for send_buf (Bill O'Donnell) [1399590]
- [fs] btrfs: fix lock dep warning, move scratch dev out of device_list_mutex and uuid_mutex (Bill O'Donnell) [1399590]
- [fs] btrfs: send: silence an integer overflow warning (Bill O'Donnell) [1399590]
- [fs] btrfs: avoid overflowing f_bfree (Bill O'Donnell) [1399590]
- [fs] btrfs: fix mixed block count of available space (Bill O'Donnell) [1399590]
- [fs] btrfs: allow balancing to dup with multi-device (Bill O'Donnell) [1399590]
- [fs] btrfs: ioctl: reorder exclusive op check in RM_DEV (Bill O'Donnell) [1399590]
- [fs] btrfs: cleanup assigning next active device with a check (Bill O'Donnell) [1399590]
- [fs] btrfs: s_bdev is not null after missing replace (Bill O'Donnell) [1399590]
- [fs] btrfs: pass the right error code to the btrfs_std_error (Bill O'Donnell) [1399590]
- [fs] btrfs: sink gfp parameter to convert_extent_bit (Bill O'Donnell) [1399590]
- [fs] btrfs: make state preallocation more speculative in __set_extent_bit (Bill O'Donnell) [1399590]
- [fs] btrfs: untangle gotos a bit in convert_extent_bit (Bill O'Donnell) [1399590]
- [fs] btrfs: untangle gotos a bit in __clear_extent_bit (Bill O'Donnell) [1399590]
- [fs] btrfs: sink gfp parameter to set_record_extent_bits (Bill O'Donnell) [1399590]
- [fs] btrfs: sink gfp parameter to set_extent_new (Bill O'Donnell) [1399590]
- [fs] btrfs: sink gfp parameter to set_extent_defrag (Bill O'Donnell) [1399590]
- [fs] btrfs: sink gfp parameter to set_extent_delalloc (Bill O'Donnell) [1399590]
- [fs] btrfs: sink gfp parameter to clear_extent_dirty (Bill O'Donnell) [1399590]
- [fs] btrfs: sink gfp parameter to clear_record_extent_bits (Bill O'Donnell) [1399590]
- [fs] btrfs: sink gfp parameter to clear_extent_bits (Bill O'Donnell) [1399590]
- [fs] btrfs: sink gfp parameter to set_extent_bits (Bill O'Donnell) [1399590]
- [fs] btrfs: uapi/linux/btrfs_tree.h migration, item types and defines (Bill O'Donnell) [1399590]
- [fs] btrfs: uapi/linux/btrfs.h migration, move struct btrfs_ioctl_defrag_range_args (Bill O'Donnell) [1399590]
- [fs] btrfs: uapi/linux/btrfs.h migration, move balance flags (Bill O'Donnell) [1399590]
- [fs] btrfs: uapi/linux/btrfs.h migration, move feature flags (Bill O'Donnell) [1399590]
- [fs] btrfs: uapi/linux/btrfs.h migration, qgroup limit flags (Bill O'Donnell) [1399590]
- [fs] btrfs: uapi/linux/btrfs.h migration, move BTRFS_LABEL_SIZE (Bill O'Donnell) [1399590]
- [fs] btrfs: refactor btrfs_dev_replace_start for reuse (Bill O'Donnell) [1399590]
- [fs] btrfs: use fs_info directly (Bill O'Donnell) [1399590]
- [fs] btrfs: rename flags for vol args v2 (Bill O'Donnell) [1399590]
- [fs] btrfs: rename btrfs_find_device_by_user_input (Bill O'Donnell) [1399590]
- [fs] btrfs: use existing device constraints table btrfs_raid_array (Bill O'Donnell) [1399590]
- [fs] btrfs: introduce raid-type to error-code table, for minimum device constraint (Bill O'Donnell) [1399590]
- [fs] btrfs: pass number of devices to btrfs_check_raid_min_devices (Bill O'Donnell) [1399590]
- [fs] btrfs: rename __check_raid_min_devices (Bill O'Donnell) [1399590]
- [fs] btrfs: optimize check for stale device (Bill O'Donnell) [1399590]
- [fs] btrfs: introduce device delete by devid (Bill O'Donnell) [1399590]
- [fs] btrfs: make use of btrfs_scratch_superblocks() in btrfs_rm_device() (Bill O'Donnell) [1399590]
- [fs] btrfs: enhance btrfs_find_device_by_user_input() to check device path (Bill O'Donnell) [1399590]
- [fs] btrfs: make use of btrfs_find_device_by_user_input() (Bill O'Donnell) [1399590]
- [fs] btrfs: create helper btrfs_find_device_by_user_input() (Bill O'Donnell) [1399590]
- [fs] btrfs: clean up and optimize __check_raid_min_device() (Bill O'Donnell) [1399590]
- [fs] btrfs: create helper function __check_raid_min_devices() (Bill O'Donnell) [1399590]
- [fs] btrfs: create a helper function to read the disk super (Bill O'Donnell) [1399590]
- [fs] btrfs: do not create empty block group if we have allocated data (Bill O'Donnell) [1399590]
- [fs] btrfs: __btrfs_buffered_write: Pass valid file offset when releasing delalloc space (Bill O'Donnell) [1399590]
- [fs] btrfs: cleanup error handling in extent_write_cached_pages (Bill O'Donnell) [1399590]
- [fs] btrfs: make mapping->writeback_index point to the last written page (Bill O'Donnell) [1399590]
- [fs] btrfs: bugfix: handle FS_IOC32_{GETFLAGS, SETFLAGS, GETVERSION} in btrfs_ioctl (Bill O'Donnell) [1399590]
- [fs] btrfs: fix typos in comments (Bill O'Donnell) [1399590]
- [fs] btrfs: Refactor btrfs_lock_cluster() to kill compiler warning (Bill O'Donnell) [1399590]
- [fs] btrfs: remove save_error_info() (Bill O'Donnell) [1399590]
- [fs] btrfs: Simplify conditions about compress while mapping btrfs flags to inode flags (Bill O'Donnell) [1399590]
- [fs] btrfs: move error handling code together in ctree.h (Bill O'Donnell) [1399590]
- [fs] btrfs: remove unused function btrfs_assert() (Bill O'Donnell) [1399590]
- [fs] btrfs: rename btrfs_std_error to btrfs_handle_fs_error (Bill O'Donnell) [1399590]
- [fs] btrfs: fix file/data loss caused by fsync after rename and new inode (Bill O'Donnell) [1399590]
- [fs] btrfs: Reset IO error counters before start of device replacing (Bill O'Donnell) [1399590]
- [fs] btrfs: Add qgroup tracing (Bill O'Donnell) [1399590]
- [fs] btrfs: don't use src fd for printk (Bill O'Donnell) [1399590]
- [fs] btrfs: fallback to vmalloc in btrfs_compare_tree (Bill O'Donnell) [1399590]
- [fs] btrfs: handle non-fatal errors in btrfs_qgroup_inherit() (Bill O'Donnell) [1399590]
- [fs] btrfs: Output more info for enospc_debug mount option (Bill O'Donnell) [1399590]
- [fs] btrfs: fix invalid reference in replace_path (Bill O'Donnell) [1399590]
- [fs] btrfs: Improve FL_KEEP_SIZE handling in fallocate (Bill O'Donnell) [1399590]
- [fs] btrfs: transaction_kthread() is not freezable (Bill O'Donnell) [1399590]
- [fs] btrfs: cleaner_kthread() doesn't need explicit freeze (Bill O'Donnell) [1399590]
- [fs] btrfs: do not write corrupted metadata blocks to disk (Bill O'Donnell) [1399590]
- [fs] btrfs: csum_tree_block: return proper errno value (Bill O'Donnell) [1399590]
- [fs] btrfs: use radix_tree_iter_retry() (Bill O'Donnell) [1399590]
- [fs] btrfs: Fix misspellings in comments (Bill O'Donnell) [1399590]
- [fs] btrfs: Print Warning only if ENOSPC_DEBUG is enabled (Bill O'Donnell) [1399590]
- [fs] btrfs: scrub: silence an uninitialized variable warning (Bill O'Donnell) [1399590]
- [fs] btrfs: move btrfs_compression_type to compression.h (Bill O'Donnell) [1399590]
- [fs] btrfs: rename btrfs_print_info to btrfs_print_mod_info (Bill O'Donnell) [1399590]
- [fs] btrfs: Show a warning message if one of objectid reaches its highest value (Bill O'Donnell) [1399590]
- [fs] btrfs: use kbasename in btrfsic_mount (Bill O'Donnell) [1399590]
- [fs] btrfs: do not collect ordered extents when logging that inode exists (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race when checking if we can skip fsync'ing an inode (Bill O'Donnell) [1399590]
- [fs] btrfs: fix listxattrs not listing all xattrs packed in the same item (Bill O'Donnell) [1399590]
- [fs] btrfs: fix deadlock between direct IO reads and buffered writes (Bill O'Donnell) [1399590]
- [fs] btrfs: fix extent_same allowing destination offset beyond i_size (Bill O'Donnell) [1399590]
- [fs] btrfs: fix file loss on log replay after renaming a file and fsync (Bill O'Donnell) [1399590]
- [fs] btrfs: fix unreplayable log after snapshot delete + parent dir fsync (Bill O'Donnell) [1399590]
- [fs] btrfs: fix lockdep deadlock warning due to dev_replace (Bill O'Donnell) [1399590]
- [fs] btrfs: drop unused argument in btrfs_ioctl_get_supported_features (Bill O'Donnell) [1399590]
- [fs] btrfs: add GET_SUPPORTED_FEATURES to the control device ioctls (Bill O'Donnell) [1399590]
- [fs] btrfs: change max_inline default to 2048 (Bill O'Donnell) [1399590]
- [fs] btrfs: remove error message from search ioctl for nonexistent tree (Bill O'Donnell) [1399590]
- [fs] btrfs: avoid uninitialized variable warning (Bill O'Donnell) [1399590]
- [fs] btrfs: fix memory leak of fs_info in block group cache (Bill O'Donnell) [1399590]
- [fs] btrfs: Continue write in case of can_not_nocow (Bill O'Donnell) [1399590]
- [fs] btrfs: drop null testing before destroy functions (Bill O'Donnell) [1399590]
- [fs] btrfs: fix build warning (Bill O'Donnell) [1399590]
- [fs] btrfs: use proper type for failrec in extent_state (Bill O'Donnell) [1399590]
- [fs] btrfs: Replace CURRENT_TIME by current_fs_time() (Bill O'Donnell) [1399590]
- [fs] btrfs: remove open-coded swap() in backref.c:__merge_refs (Bill O'Donnell) [1399590]
- [fs] btrfs: remove redundant error check (Bill O'Donnell) [1399590]
- [fs] btrfs: simplify expression in btrfs_calc_trans_metadata_size() (Bill O'Donnell) [1399590]
- [fs] btrfs: check reserved when deciding to background flush (Bill O'Donnell) [1399590]
- [fs] btrfs: add transaction space reservation tracepoints (Bill O'Donnell) [1399590]
- [fs] btrfs: fix truncate_space_check (Bill O'Donnell) [1399590]
- [fs] btrfs: change how we update the global block rsv (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: ignore creating reada_extent for a non-existent device (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: avoid undone reada extents in btrfs_reada_wait (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: limit max works count (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: simplify dev->reada_in_flight processing (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: Fix a debug code typo (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: Jump into cleanup in direct way for __readahead_hook() (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: Use fs_info instead of root in __readahead_hook's argument (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: Pass reada_extent into __readahead_hook directly (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: move reada_extent_put to place after __readahead_hook() (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: Remove level argument in severial functions (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: bypass adding extent when all zone failed (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: add all reachable mirrors into reada device list (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: Move is_need_to_readahead contition earlier (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: Avoid many times of empty loop (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: Add missed segment checking in reada_find_zone (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: reduce additional fs_info->reada_lock in reada_find_zone (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: Fix in-segment calculation for reada (Bill O'Donnell) [1399590]
- [fs] btrfs: Introduce new mount option alias for nologreplay (Bill O'Donnell) [1399590]
- [fs] btrfs: Introduce new mount option to disable tree log replay (Bill O'Donnell) [1399590]
- [fs] btrfs: Introduce new mount option usebackuproot to replace recovery (Bill O'Donnell) [1399590]
- [fs] btrfs: teach print_leaf about temporary item subtypes (Bill O'Donnell) [1399590]
- [fs] btrfs: teach print_leaf about permanent item subtypes (Bill O'Donnell) [1399590]
- [fs] btrfs: switch dev stats item to the permanent item key (Bill O'Donnell) [1399590]
- [fs] btrfs: introduce key type for persistent permanent items (Bill O'Donnell) [1399590]
- [fs] btrfs: switch balance item to the temporary item key (Bill O'Donnell) [1399590]
- [fs] btrfs: introduce key type for persistent temporary items (Bill O'Donnell) [1399590]
- [fs] btrfs: switch to kcalloc in btrfs_cmp_data_prepare (Bill O'Donnell) [1399590]
- [fs] btrfs: extent same: use GFP_KERNEL for page array allocations (Bill O'Donnell) [1399590]
- [fs] btrfs: device add and remove: use GFP_KERNEL (Bill O'Donnell) [1399590]
- [fs] btrfs: readdir: use GFP_KERNEL (Bill O'Donnell) [1399590]
- [fs] btrfs: fallocate: use GFP_KERNEL (Bill O'Donnell) [1399590]
- [fs] btrfs: let callers of btrfs_alloc_root pass gfp flags (Bill O'Donnell) [1399590]
- [fs] btrfs: scrub: use GFP_KERNEL on the submission path (Bill O'Donnell) [1399590]
- [fs] btrfs: reada: use GFP_KERNEL everywhere (Bill O'Donnell) [1399590]
- [fs] btrfs: send: use GFP_KERNEL everywhere (Bill O'Donnell) [1399590]
- [fs] btrfs: remove no longer used function extent_read_full_page_nolock() (Bill O'Donnell) [1399590]
- [fs] btrfs: btrfs_ioctl_clone: Truncate complete page after performing clone operation (Bill O'Donnell) [1399590]
- [fs] btrfs: Fix block size returned to user space (Bill O'Donnell) [1399590]
- [fs] btrfs: Limit inline extents to root->sectorsize (Bill O'Donnell) [1399590]
- [fs] btrfs: btrfs_submit_direct_hook: Handle map_length < bio vector length (Bill O'Donnell) [1399590]
- [fs] btrfs: Use eb->start, seq as search key for tree modification log (Bill O'Donnell) [1399590]
- [fs] btrfs: Search for all ordered extents that could span across a page (Bill O'Donnell) [1399590]
- [fs] btrfs: btrfs_page_mkwrite: Reserve space in sectorsized units (Bill O'Donnell) [1399590]
- [fs] btrfs: fallocate: Work with sectorsized blocks (Bill O'Donnell) [1399590]
- [fs] btrfs: direct i/o read: Work on sectorsized blocks (Bill O'Donnell) [1399590]
- [fs] btrfs: __btrfs_buffered_write: Reserve/release extents aligned to block size (Bill O'Donnell) [1399590]
- [fs] btrfs: revert: btrfs: synchronize incompat feature bits with sysfs files (Bill O'Donnell) [1399590]
- [fs] btrfs: don't use GFP_HIGHMEM for free-space-tree bitmap kzalloc (Bill O'Donnell) [1399590]
- [fs] btrfs: sysfs: check initialization state before updating features (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race between fsync and lockless direct IO writes (Bill O'Donnell) [1399590]
- [fs] btrfs: add free space tree to the cow-only list (Bill O'Donnell) [1399590]
- [fs] btrfs: add free space tree to lockdep classes (Bill O'Donnell) [1399590]
- [fs] btrfs: tweak free space tree bitmap allocation (Bill O'Donnell) [1399590]
- [fs] btrfs: tests: switch to GFP_KERNEL (Bill O'Donnell) [1399590]
- [fs] btrfs: synchronize incompat feature bits with sysfs files (Bill O'Donnell) [1399590]
- [fs] btrfs: sysfs: introduce helper for syncing bits with sysfs files (Bill O'Donnell) [1399590]
- [fs] btrfs: sysfs: add free-space-tree bit attribute (Bill O'Donnell) [1399590]
- [fs] btrfs: sysfs: fix typo in compat_ro attribute definition (Bill O'Donnell) [1399590]
- [fs] btrfs: raid56: Use raid_write_end_io for scrub (Bill O'Donnell) [1399590]
- [fs] btrfs: Remove unnecessary ClearPageUptodate for raid56 (Bill O'Donnell) [1399590]
- [fs] btrfs: use rbio->nr_pages to reduce calculation (Bill O'Donnell) [1399590]
- [fs] btrfs: Use unified stripe_page's index calculation (Bill O'Donnell) [1399590]
- [fs] btrfs: Fix calculation of rbio->dbitmap's size calculation (Bill O'Donnell) [1399590]
- [fs] btrfs: merge functions for wait snapshot creation (Bill O'Donnell) [1399590]
- [fs] btrfs: delete unused argument in btrfs_copy_from_user (Bill O'Donnell) [1399590]
- [fs] btrfs: Use direct way to determine raid56 write/recover mode (Bill O'Donnell) [1399590]
- [fs] btrfs: Small cleanup for get index_srcdev loop (Bill O'Donnell) [1399590]
- [fs] btrfs: Enhance chunk validation check (Bill O'Donnell) [1399590]
- [fs] btrfs: Enhance super validation check (Bill O'Donnell) [1399590]
- [fs] btrfs: fix typo in log message when starting a balance (Bill O'Donnell) [1399590]
- [fs] btrfs: remove duplicate const specifier (Bill O'Donnell) [1399590]
- [fs] btrfs: clean up an error code in btrfs_init_space_info() (Bill O'Donnell) [1399590]
- [fs] btrfs: fix iterator with update error in backref.c (Bill O'Donnell) [1399590]
- [fs] btrfs: fix output of compression message in btrfs_parse_options() (Bill O'Donnell) [1399590]
- [fs] btrfs: cleanup, stop casting for extent_map->lookup everywhere (Bill O'Donnell) [1399590]
- [fs] btrfs: Check metadata redundancy on balance (Bill O'Donnell) [1399590]
- [fs] btrfs: preallocate path for snapshot creation at ioctl time (Bill O'Donnell) [1399590]
- [fs] btrfs: allocate root item at snapshot ioctl time (Bill O'Donnell) [1399590]
- [fs] btrfs: do an allocation earlier during snapshot creation (Bill O'Donnell) [1399590]
- [fs] btrfs: use smaller type for btrfs_path locks (Bill O'Donnell) [1399590]
- [fs] btrfs: use smaller type for btrfs_path lowest_level (Bill O'Donnell) [1399590]
- [fs] btrfs: use smaller type for btrfs_path reada (Bill O'Donnell) [1399590]
- [fs] btrfs: cleanup, use enum values for btrfs_path reada (Bill O'Donnell) [1399590]
- [fs] btrfs: constify static arrays (Bill O'Donnell) [1399590]
- [fs] btrfs: constify remaining structs with function pointers (Bill O'Donnell) [1399590]
- [fs] btrfs tests: replace whole ops structure for free space tests (Bill O'Donnell) [1399590]
- [fs] btrfs: use list_for_each_entry* in backref.c (Bill O'Donnell) [1399590]
- [fs] btrfs: use list_for_each_entry_safe in free-space-cache.c (Bill O'Donnell) [1399590]
- [fs] btrfs: use list_for_each_entry* in check-integrity.c (Bill O'Donnell) [1399590]
- [fs] btrfs: use linux/sizes.h to represent constants (Bill O'Donnell) [1399590]
- [fs] btrfs: cleanup, remove stray return statements (Bill O'Donnell) [1399590]
- [fs] btrfs: zero out delayed node upon allocation (Bill O'Donnell) [1399590]
- [fs] btrfs: pass proper enum type to start_transaction() (Bill O'Donnell) [1399590]
- [fs] btrfs: switch __btrfs_fs_incompat return type from int to bool (Bill O'Donnell) [1399590]
- [fs] btrfs: remove unused inode argument from uncompress_inline() (Bill O'Donnell) [1399590]
- [fs] btrfs: don't use slab cache for struct btrfs_delalloc_work (Bill O'Donnell) [1399590]
- [fs] btrfs: drop duplicate prefix from scrub workqueues (Bill O'Donnell) [1399590]
- [fs] btrfs: verbose error when we find an unexpected item in sys_array (Bill O'Donnell) [1399590]
- [fs] btrfs: better packing of btrfs_delayed_extent_op (Bill O'Donnell) [1399590]
- [fs] btrfs: Support convert to -d dup for btrfs-convert (Bill O'Donnell) [1399590]
- [fs] btrfs: don't leave dangling dentry if symlink creation failed (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race between free space endio workers and space cache writeout (Bill O'Donnell) [1399590]
- [fs] btrfs: don't run delayed references while we are creating the free space tree (Bill O'Donnell) [1399590]
- [fs] btrfs: fix compiling with CONFIG_BTRFS_DEBUG enabled (Bill O'Donnell) [1399590]
- [fs] btrfs: fix unprotected list operations at btrfs_write_dirty_block_groups (Bill O'Donnell) [1399590]
- [fs] btrfs: fix locking bugs when defragging leaves (Bill O'Donnell) [1399590]
- [fs] btrfs: add free space tree mount option (Bill O'Donnell) [1399590]
- [fs] btrfs: wire up the free space tree to the extent tree (Bill O'Donnell) [1399590]
- [fs] btrfs: add free space tree sanity tests (Bill O'Donnell) [1399590]
- [fs] btrfs: implement the free space B-tree (Bill O'Donnell) [1399590]
- [fs] btrfs: introduce the free space B-tree on-disk format (Bill O'Donnell) [1399590]
- [fs] btrfs: refactor caching_thread() (Bill O'Donnell) [1399590]
- [fs] btrfs: add helpers for read-only compat bits (Bill O'Donnell) [1399590]
- [fs] btrfs: add extent buffer bitmap sanity tests (Bill O'Donnell) [1399590]
- [fs] btrfs: add extent buffer bitmap operations (Bill O'Donnell) [1399590]
- [fs] btrfs: fix deadlock between direct IO write and defrag/readpages (Bill O'Donnell) [1399590]
- [fs] btrfs: fix memory leaks after transaction is aborted (Bill O'Donnell) [1399590]
- [fs] btrfs: fix race when finishing dev replace leading to transaction abort (Bill O'Donnell) [1399590]
- [fs] btrfs: make set_range_writeback return void (Bill O'Donnell) [1399590]
- [fs] btrfs: make extent_range_redirty_for_io return void (Bill O'Donnell) [1399590]
- [fs] btrfs: make extent_range_clear_dirty_for_io return void (Bill O'Donnell) [1399590]
- [fs] btrfs: make end_extent_writepage return void (Bill O'Donnell) [1399590]
- [fs] btrfs: make extent_clear_unlock_delalloc return void (Bill O'Donnell) [1399590]
- [fs] btrfs: make clear_extent_buffer_uptodate return void (Bill O'Donnell) [1399590]
- [fs] btrfs: make set_extent_buffer_uptodate return void (Bill O'Donnell) [1399590]
- [fs] btrfs: remove a trivial helper btrfs_set_buffer_uptodate (Bill O'Donnell) [1399590]
- [fs] btrfs: use GFP_KERNEL for xattr and acl allocations (Bill O'Donnell) [1399590]
- [fs] btrfs: use GFP_KERNEL for allocations of workqueues (Bill O'Donnell) [1399590]
- [fs] btrfs: use GFP_KERNEL for allocations in ioctl handlers (Bill O'Donnell) [1399590]
- [fs] btrfs: remove wait from struct btrfs_delalloc_work (Bill O'Donnell) [1399590]
- [fs] btrfs: sink parameter wait to btrfs_alloc_delalloc_work (Bill O'Donnell) [1399590]
- [fs] btrfs: make btrfs_close_one_device static (Bill O'Donnell) [1399590]
- [fs] btrfs: make lock_extent static inline (Bill O'Donnell) [1399590]
- [fs] btrfs: drop unused parameter from lock_extent_bits (Bill O'Donnell) [1399590]
- [fs] btrfs: make clear_extent_bit helpers static inline (Bill O'Donnell) [1399590]
- [fs] btrfs: make set_extent_bit helpers static inline (Bill O'Donnell) [1399590]

* Fri Mar 17 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-617.el7]
- [mmc] core: fix multi-bit bus width without high-speed mode (Don Zickus) [1430497]
- [mmc] sdhci: Ignore unexpected CARD_INT interrupts (Don Zickus) [1430497]
- [mmc] core: Restore parts of the polling policy when switch to HS/HS DDR (Don Zickus) [1430497]
- [mmc] sdhci-acpi: Only powered up enabled acpi child devices (Don Zickus) [1430497]
- [mmc] sd: Meet alignment requirements for raw_ssr DMA (Don Zickus) [1430497]
- [mmc] core: Further fix thread wake-up (Don Zickus) [1430497]
- [mmc] sdhci: Fix to handle MMC_POWER_UNDEFINED (Don Zickus) [1430497]
- [mmc] sdhci-cadence: add Socionext UniPhier specific compatible string (Don Zickus) [1430497]
- [mmc] block: Move files to core (Don Zickus) [1430497]
- [mmc] sdhci-cadence: add Cadence SD4HC support (Don Zickus) [1430497]
- [mmc] sdhci: export sdhci_execute_tuning() (Don Zickus) [1430497]
- [mmc] sdhci: Tidy tuning loop (Don Zickus) [1430497]
- [mmc] sdhci: Simplify tuning block size logic (Don Zickus) [1430497]
- [mmc] sdhci: Factor out tuning helper functions (Don Zickus) [1430497]
- [mmc] sdhci: Use mmc_abort_tuning() (Don Zickus) [1430497]
- [mmc] mmc: Introduce mmc_abort_tuning() (Don Zickus) [1430497]
- [mmc] sdhci: Always allow tuning to fall back to fixed sampling (Don Zickus) [1430497]
- [mmc] sdhci: Fix tuning reset after exhausting the maximum number of loops (Don Zickus) [1430497]
- [mmc] sdhci: Fix recovery from tuning timeout (Don Zickus) [1430497]
- [mmc] revert "mmc: sdhci: Reset cmd and data circuits after tuning failure" (Don Zickus) [1430497]
- [mmc] mmc: Relax checking for switch errors after HS200 switch (Don Zickus) [1430497]
- [mmc] sdhci-acpi: support 80860F14 UID 2 SDIO bus (Don Zickus) [1430497]
- [mmc] sdhci-pci: Use ACPI to get max frequency for Intel NI byt sdio (Don Zickus) [1430497]
- [mmc] sdhci-pci: Add PCI ID for Intel NI byt sdio (Don Zickus) [1430497]
- [mmc] mmc_test: remove BUG_ONs and deploy error handling (Don Zickus) [1430497]
- [mmc] queue: remove BUG_ON for bounce_sg (Don Zickus) [1430497]
- [mmc] sdio_uart: remove meaningless BUG_ON (Don Zickus) [1430497]
- [mmc] core: remove BUG_ONs from core.c (Don Zickus) [1430497]
- [mmc] core: remove BUG_ONs from sd (Don Zickus) [1430497]
- [mmc] core: remove BUG_ONs from mmc (Don Zickus) [1430497]
- [mmc] debugfs: remove BUG_ON from mmc_ext_csd_open (Don Zickus) [1430497]
- [mmc] core: remove BUG_ONs from sdio (Don Zickus) [1430497]
- [mmc] mmc: Add Command Queue definitions (Don Zickus) [1430497]
- [mmc] queue: Introduce queue depth and use it to allocate and free (Don Zickus) [1430497]
- [mmc] queue: Factor out mmc_queue_reqs_free_bufs() (Don Zickus) [1430497]
- [mmc] queue: Factor out mmc_queue_alloc_sgs() (Don Zickus) [1430497]
- [mmc] queue: Factor out mmc_queue_alloc_bounce_sgs() (Don Zickus) [1430497]
- [mmc] queue: Factor out mmc_queue_alloc_bounce_bufs() (Don Zickus) [1430497]
- [mmc] queue: Fix queue thread wake-up (Don Zickus) [1430497]
- [mmc] block: Fix 4K native sector check (Don Zickus) [1430497]
- [mmc] block: Restore line inadvertently removed with packed commands (Don Zickus) [1430497]
- [mmc] sdhci-of-esdhc: fix host version for T4240-R1.0-R2.0 (Don Zickus) [1430497]
- [mmc] block: delete packed command support (Don Zickus) [1430497]
- [mmc] delete is_first_req parameter from pre-request callback (Don Zickus) [1430497]
- [mmc] core: Update CMD13 polling policy when switch to HS DDR mode (Don Zickus) [1430497]
- [mmc] core: Allow CMD13 polling when switching to HS mode for mmc (Don Zickus) [1430497]
- [mmc] core: Enable __mmc_switch() to change bus speed timing for the host (Don Zickus) [1430497]
- [mmc] core: Check SWITCH_ERROR bit from each CMD13 response when polling (Don Zickus) [1430497]
- [mmc] core: Rename ignore_crc to retry_crc_err to reflect its purpose (Don Zickus) [1430497]
- [mmc] core: Remove redundant __mmc_send_status() (Don Zickus) [1430497]
- [mmc] core: Retry instead of ignore at CRC errors when polling for busy (Don Zickus) [1430497]
- [mmc] sdhci-pci: Allow deferred probe for sd card detect gpio (Don Zickus) [1430497]
- [mmc] sdhci-pci: Add support for Intel GLK (Don Zickus) [1430497]
- [mmc] sdhci: Factor out sdhci_enable_clk (Don Zickus) [1430497]
- [mmc] dw_mmc: use the cookie's enum values for post/pre_req() (Don Zickus) [1430497]
- [mmc] block: move packed command struct init (Don Zickus) [1430497]
- [mmc] block: rename data to blkdata (Don Zickus) [1430497]
- [mmc] mmc_test: Uninitialized return value (Don Zickus) [1430497]
- [mmc] sdhci: remove unneeded (void *) casts in sdhci_(pltfm_)priv() (Don Zickus) [1430497]
- [mmc] core: Add helper to see if a host can be retuned (Don Zickus) [1430497]
- [mmc] core: use enum mmc_blk_status properly (Don Zickus) [1430497]
- [mmc] block: convert ecc_err to a bool (Don Zickus) [1430497]
- [mmc] block: make gen_err a bool variable (Don Zickus) [1430497]
- [mmc] sdhci: Use sdhci-caps-mask and sdhci-caps to change the caps read during __sdhci_read_caps (Don Zickus) [1430497]
- [mmc] core: Don't power off the card when starting the host (Don Zickus) [1430497]
- [mmc] core: expose the capability of gpio card detect (Don Zickus) [1430497]
- [mmc] core: Don't use ->card_busy() and CMD13 in combination when polling (Don Zickus) [1430497]
- [mmc] core: Factor out code related to polling in __mmc_switch() (Don Zickus) [1430497]
- [mmc] core: Clarify code which deals with polling in __mmc_switch() (Don Zickus) [1430497]
- [mmc] core: Make mmc_switch_status() available for mmc core (Don Zickus) [1430497]
- [mmc] rtsx_usb_sdmmc: Enable runtime PM autosuspend (Don Zickus) [1430497]
- [mmc] sdhci: put together into one condition checking (Don Zickus) [1430497]
- [mmc] sdhci-of-esdhc: fixup PRESENT_STATE read (Don Zickus) [1430497]
- [mmc] mmc: Use 500ms as the default generic CMD6 timeout (Don Zickus) [1430497]
- [mmc] mmc_test: Fix "Commands during non-blocking write" tests (Don Zickus) [1430497]
- [mmc] sdhci: Fix missing enhanced strobe setting during runtime resume (Don Zickus) [1430497]
- [mmc] sdhci: Reset cmd and data circuits after tuning failure (Don Zickus) [1430497]
- [mmc] sdhci: Fix unexpected data interrupt handling (Don Zickus) [1430497]
- [mmc] sdhci: Fix CMD line reset interfering with ongoing data transfer (Don Zickus) [1430497]
- [mmc] rtsx_usb_sdmmc: Handle runtime PM while changing the led (Don Zickus) [1430497]
- [mmc] rtsx_usb_sdmmc: Avoid keeping the device runtime resumed when unused (Don Zickus) [1430497]
- [mmc] sdhci: cast unsigned int to unsigned long long to avoid unexpeted error (Don Zickus) [1430497]
- [mmc] sdhci-pci: Fix bus power failing to enable for some Intel controllers (Don Zickus) [1430497]
- [mmc] sdhci-pci: Let devices define their own sdhci_ops (Don Zickus) [1430497]
- [mmc] sdhci: Rename sdhci_set_power() to sdhci_set_power_noreg() (Don Zickus) [1430497]
- [mmc] sdhci: Fix SDHCI_QUIRK2_STOP_WITH_TC (Don Zickus) [1430497]
- [mmc] core: Annotate cmd_hdr as __le32 (Don Zickus) [1430497]
- [mmc] core: changes frequency to hs_max_dtr when selecting hs400es (Don Zickus) [1430497]
- [mmc] core: switch to 1V8 or 1V2 for hs400es mode (Don Zickus) [1430497]
- [mmc] block: add missing header dependencies (Don Zickus) [1430497]
- [mmc] mfd: rtsx_usb: Avoid setting ucr->current_sg.status (Don Zickus) [1430497]
- [mmc] core: don't try to switch block size for dual rate mode (Don Zickus) [1430497]
- [mmc] sdhci-of-arasan: Set controller to test mode when no CD bit (Don Zickus) [1430497]
- [mmc] rtsx_usb: use new macro for R1 without CRC (Don Zickus) [1430497]
- [mmc] rtsx_pci: use new macro for R1 without CRC (Don Zickus) [1430497]
- [mmc] add define for R1 response without CRC (Don Zickus) [1430497]
- [mmc] card: do away with indirection pointer (Don Zickus) [1430497]
- [mmc] sdhci-acpi: Set MMC_CAP_CMD_DURING_TFR for Intel eMMC controllers (Don Zickus) [1430497]
- [mmc] sdhci-pci: Set MMC_CAP_CMD_DURING_TFR for Intel eMMC controllers (Don Zickus) [1430497]
- [mmc] sdhci: Support cap_cmd_during_tfr requests (Don Zickus) [1430497]
- [mmc] mmc_test: Add tests for sending commands during transfer (Don Zickus) [1430497]
- [mmc] core: Add support for sending commands during data transfer (Don Zickus) [1430497]
- [mmc] sdhci-brcmstb: Fix incorrect capability (Don Zickus) [1430497]
- [mmc] core: Optimize the mmc erase size alignment (Don Zickus) [1430497]
- [mmc] core: Factor out the alignment of erase size (Don Zickus) [1430497]
- [mmc] core: Use a default maximum erase timeout (Don Zickus) [1430497]
- [mmc] sdhci-pci: enable SD card interface on Merrifield (Don Zickus) [1430497]
- [mmc] sdhci-pci: enable SDIO interface on Intel Merrifield (Don Zickus) [1430497]
- [mmc] sdhci-pci: refactor intel_mrfld_mmc_probe_slot() (Don Zickus) [1430497]
- [mmc] dw_mmc: add reset support to dwmmc host controller (Don Zickus) [1430497]
- [mmc] block: don't use CMD23 with very old MMC cards (Don Zickus) [1430497]
- [mmc] sdhci: Remove ->platform_init() callback as it's no longer used (Don Zickus) [1430497]
- [mmc] sdhci-pci: Convert to use managed functions (part2) (Don Zickus) [1430497]
- [mmc] sdio: deploy error handling instead of triggering BUG_ON (Don Zickus) [1430497]
- [mmc] block: remove the check of packed for packed request routine (Don Zickus) [1430497]
- [mmc] core: Add error message when switching fails in mmc_select_hs() (Don Zickus) [1430497]
- [mmc] sdhci: Do not allow tuning procedure to be interrupted (Don Zickus) [1430497]
- [mmc] sdhci-brcmstb: Delete owner assignment (Don Zickus) [1430497]
- [mmc] sd: Export SD Status via "ssr" device attribute (Don Zickus) [1430497]
- [mmc] vub300: don't print error when allocating urb fails (Don Zickus) [1430497]
- [mmc] rtsx_pci: Remove deprecated create_singlethread_workqueue (Don Zickus) [1430497]
- [mmc] rtsx_pci: Enable MMC_CAP_ERASE to allow erase/discard/trim requests (Don Zickus) [1430497]
- [mmc] rtsx_pci: Use the provided busy timeout from the mmc core (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: Drop define for SDHCI_PLTFM_PMOPS (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: Convert to use the SET_SYSTEM_SLEEP_PM_OPS (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: Make sdhci_pltfm_suspend|resume() static (Don Zickus) [1430497]
- [mmc] sdhci-acpi: Simplify code by using SET_SYSTEM_SLEEP_PM_OPS (Don Zickus) [1430497]
- [mmc] sdhci-pci-core: Simplify code by using SET_SYSTEM_SLEEP_PM_OPS (Don Zickus) [1430497]
- [mmc] Change the max discard sectors and erase response when HW busy detect (Don Zickus) [1430497]
- [mmc] sdhci: Request regulators before reading capabilities (Don Zickus) [1430497]
- [mmc] sdhci-pci: Use MRFLD as abbreviation of Merrifield (Don Zickus) [1430497]
- [mmc] sdhci: add standard hw auto retuning support (Don Zickus) [1430497]
- [mmc] sdhci: using common mmc_regulator_set_vqmmc() (Don Zickus) [1430497]
- [mmc] sdhci-pci: Convert to use managed functions pcim_* and devm_* (Don Zickus) [1430497]
- [mmc] core: Extend sysfs with DSR register (Don Zickus) [1430497]
- [mmc] core: expose MMC_CAP2_NO_* to dt (Don Zickus) [1430497]
- [mmc] core: Extend sysfs with OCR register (Don Zickus) [1430497]
- [mmc] sdhci: add define for suspend/resume capability (Don Zickus) [1430497]
- [mmc] core: Allow hosts to specify non-support for MMC commands (Don Zickus) [1430497]
- [mmc] sdhci: sdhci_execute_tuning() must delete timer (Don Zickus) [1430497]
- [mmc] sdhci: Avoid STOP cmd triggering warning in sdhci_send_command() (Don Zickus) [1430497]
- [mmc] sdhci: Do not reset cmd or data circuits that are in use (Don Zickus) [1430497]
- [mmc] sdhci: Factor out sdhci_auto_cmd12() (Don Zickus) [1430497]
- [mmc] sdhci: Allow for finishing multiple requests (Don Zickus) [1430497]
- [mmc] sdhci: Separate timer timeout for command and data requests (Don Zickus) [1430497]
- [mmc] sdhci: Factor out sdhci_data_line_cmd() (Don Zickus) [1430497]
- [mmc] sdhci: Ensure all requests get errored out (Don Zickus) [1430497]
- [mmc] sdhci: Clear pointers when a request finishes (Don Zickus) [1430497]
- [mmc] sdhci: Track whether a reset is pending (Don Zickus) [1430497]
- [mmc] sdhci: Factor out sdhci_needs_reset() (Don Zickus) [1430497]
- [mmc] sdhci: Factor out sdhci_finish_mrq() (Don Zickus) [1430497]
- [mmc] sdhci: Move host->data warning (Don Zickus) [1430497]
- [mmc] sdhci: Reduce the use of host->mrq (Don Zickus) [1430497]
- [mmc] sdhci: Get rid of host->busy_handle (Don Zickus) [1430497]
- [mmc] sdhci: Record what command is using the data lines (Don Zickus) [1430497]
- [mmc] sdhci: Simplify sdhci_finish_command() by clearing host->cmd at the start (Don Zickus) [1430497]
- [mmc] sdhci: Get rid of redundant BUG_ONs (Don Zickus) [1430497]
- [mmc] sdhci: Move busy signal handling into sdhci_finish_cmd() (Don Zickus) [1430497]
- [mmc] sdhci-pci: Do not runtime suspend at the end of sdhci_pci_probe() (Don Zickus) [1430497]
- [mmc] sdhci: Add sdhci_read_caps() (Don Zickus) [1430497]
- [mmc] sdhci: Tidy caps variables in sdhci_setup_host() (Don Zickus) [1430497]
- [mmc] sdhci: Make signal voltage support explicit (Don Zickus) [1430497]
- [mmc] sdhci: Split sdhci_add_host() (Don Zickus) [1430497]
- [mmc] sdhci: Do not call implementations of mmc host ops directly (Don Zickus) [1430497]
- [mmc] dw_mmc: remove the quirks flags (Don Zickus) [1430497]
- [mmc] core: Allow hosts to specify non-support for SD commands (Don Zickus) [1430497]
- [mmc] sdhci: use pr_err for sdhci_dumpregs (Don Zickus) [1430497]
- [mmc] host: use the defined function to check whether card is removable (Don Zickus) [1430497]
- [mmc] sdhci-of-arasan: Add ability to export card clock (Don Zickus) [1430497]
- [mmc] sdhci-brcmstb: Add driver for Broadcom BRCMSTB SoCs (Don Zickus) [1430497]
- [mmc] block: Fix tag condition with packed writes (Don Zickus) [1430497]
- [mmc] core: Disable HPI for certain Hynix eMMC cards (Don Zickus) [1430497]
- [mmc] core: Only change mode if mmc_select_bus_width() is successful (Don Zickus) [1430497]
- [mmc] Set pref erase size based on size (Don Zickus) [1430497]
- [mmc] mmc: Fix HS switch failure in mmc_select_hs400() (Don Zickus) [1430497]
- [mmc] mmc: fix switch timeout issue caused by jiffies precision (Don Zickus) [1430497]
- [mmc] mmc: do not use CMD13 to get status after speed mode switch (Don Zickus) [1430497]
- [mmc] mmc: Use ->card_busy() to detect busy cards in __mmc_switch() (Don Zickus) [1430497]
- [mmc] sdhci: Fix sdhci_card_busy() (Don Zickus) [1430497]
- [mmc] debugfs: add HS400 enhanced strobe description (Don Zickus) [1430497]
- [mmc] core: implement enhanced strobe support (Don Zickus) [1430497]
- [mmc] core: add mmc-hs400-enhanced-strobe support (Don Zickus) [1430497]
- [mmc] sdhci: fix wakeup configuration (Don Zickus) [1430497]
- [mmc] block: correct 4KB alignment check (Don Zickus) [1430497]
- [mmc] sdhci: remove comment regarding timeout during tuning (Don Zickus) [1430497]
- [mmc] block: fix packed command header endianness (Don Zickus) [1430497]
- [mmc] block: fix free of uninitialized 'idata->buf' (Don Zickus) [1430497]
- [mmc] x86, mmc: Use Intel family name macros for mmc driver (Don Zickus) [1430497]
- [mmc] fix mmc mode selection for HS-DDR and higher (Don Zickus) [1430497]
- [mmc] remove lots of IS_ERR_VALUE abuses (Don Zickus) [1430497]
- [mmc] sdhci-acpi: Remove MMC_CAP_BUS_WIDTH_TEST for Intel controllers (Don Zickus) [1430497]
- [mmc] sdhci-pci: Remove MMC_CAP_BUS_WIDTH_TEST for Intel controllers (Don Zickus) [1430497]
- [mmc] longer timeout for long read time quirk (Don Zickus) [1430497]
- [mmc] block: Pause re-tuning while switched to the RPMB partition (Don Zickus) [1430497]
- [mmc] block: Always switch back to main area after RPMB access (Don Zickus) [1430497]
- [mmc] core: Add a facility to "pause" re-tuning (Don Zickus) [1430497]
- [mmc] mmc: Fix partition switch timeout for some eMMCs (Don Zickus) [1430497]
- [mmc] sdio: fall back to SDIO 1.0 for broken 1.1 cards (Don Zickus) [1430497]
- [mmc] block: improve logging of handling emmc timeouts (Don Zickus) [1430497]
- [mmc] sdhci: removed unneeded function wrappers (Don Zickus) [1430497]
- [mmc] core: remove the invalid message in mmc_select_timing (Don Zickus) [1430497]
- [mmc] core: fix using wrong io voltage if mmc_select_hs200 fails (Don Zickus) [1430497]
- [mmc] mmc: Attempt to flush cache before reset (Don Zickus) [1430497]
- [mmc] sh_mmcif: remove obsolete support for sh7372 (Don Zickus) [1430497]
- [mmc] block: Convert to IDA for partition device indexes (Don Zickus) [1430497]
- [mmc] block: Release index in partition allocation error path (Don Zickus) [1430497]
- [mmc] core: Convert from IDR to IDA for host indexes (Don Zickus) [1430497]
- [mmc] sdhci: use IS_ENABLE(CONFIG_LEDS_CLASS) to enable LED struct members (Don Zickus) [1430497]
- [mmc] sdhci: use IS_REACHABLE(CONFIG_LEDS_CLASS) to enable LED code (Don Zickus) [1430497]
- [mmc] sdhci: Remove SDHCI_SDR104_NEEDS_TUNING (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: call platform_get_irq() before sdhci_alloc_host() (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: move devm_ioremap_resource() up (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: use devm_ioremap_resource() (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: use devm_ioremap() (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: use devm_request_mem_region() (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: check return value of platform_get_irq() (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: drop error message for too small MMIO resource size (Don Zickus) [1430497]
- [mmc] core: drop unnecessary bit checking (Don Zickus) [1430497]
- [mmc] sdhci: Tidy together LED code (Don Zickus) [1430497]
- [mmc] sdhci: Fix error paths in sdhci_add_host() (Don Zickus) [1430497]
- [mmc] sdhci: Remove redundant condition (Don Zickus) [1430497]
- [mmc] sdhci-acpi: Set MMC_CAP_AGGRESSIVE_PM for Broxton controllers (Don Zickus) [1430497]
- [mmc] sdhci-pci: Set MMC_CAP_AGGRESSIVE_PM for Broxton controllers (Don Zickus) [1430497]
- [mmc] sdhci: Remove SDHCI_QUIRK2_NEED_DELAY_AFTER_INT_CLK_RST (Don Zickus) [1430497]
- [mmc] sdhci: Introduce sdhci_calc_clk() (Don Zickus) [1430497]
- [mmc] sdhci: Move sdhci_runtime_pm_bus_off|on() to avoid pre-definition (Don Zickus) [1430497]
- [mmc] sdhci-pic32: remove owner assignment (Don Zickus) [1430497]
- [mmc] sdhci: Remove redundant runtime PM calls (Don Zickus) [1430497]
- [mmc] core: Do regular power cycle when lacking eMMC HW reset support (Don Zickus) [1430497]
- [mmc] sdhci-pci: Remove redundant runtime PM calls (Don Zickus) [1430497]
- [mmc] sdhci-acpi: Remove redundant runtime PM calls (Don Zickus) [1430497]
- [mmc] dw_mmc: remove unused EVENT_XFER_ERROR (Don Zickus) [1430497]
- [mmc] dw_mmc: fix warning reported by kernel-doc (Don Zickus) [1430497]
- [mmc] host: add note that set_ios needs to handle 0Hz properly (Don Zickus) [1430497]
- [mmc] core: Provide tracepoints for request processing (Don Zickus) [1430497]
- [mmc] sdhci-acpi: Reduce Baytrail eMMC/SD/SDIO hangs (Don Zickus) [1430497]
- [mmc] block: Use the mmc host device index as the mmcblk device index (Don Zickus) [1430497]
- [mmc] sdhci-pci: Add support and PCI IDs for more Broxton host controllers (Don Zickus) [1430497]
- [mmc] sdhci: Fix regression setting power on Trats2 board (Don Zickus) [1430497]
- [mmc] sdhci-pci: Do not set DMA mask in enable_dma() (Don Zickus) [1430497]
- [mmc] sdhci-acpi: Remove enable_dma() hook (Don Zickus) [1430497]
- [mmc] sdhci: Set DMA mask when adding host (Don Zickus) [1430497]
- [mmc] block: fix ABI regression of mmc_blk_ioctl (Don Zickus) [1430497]
- [mmc] core: remove redundant memset of sdio_read_cccr (Don Zickus) [1430497]
- [mmc] core: remove redundant memset of mmc_decode_cid (Don Zickus) [1430497]
- [mmc] sdhci: Fix override of timeout clk wrt max_busy_timeout (Don Zickus) [1430497]
- [mmc] sdhci-acpi: add QCOM controllers (Don Zickus) [1430497]
- [mmc] sdhci-pltfm: remove priv variable from sdhci_pltfm_host (Don Zickus) [1430497]
- [mmc] sdhci: further code simplication (Don Zickus) [1430497]
- [mmc] sdhci: consolidate the DMA/ADMA size/address quicks (Don Zickus) [1430497]
- [mmc] sdhci: prepare DMA address/size quirk handling consolidation (Don Zickus) [1430497]
- [mmc] sdhci: cleanup DMA un-mapping (Don Zickus) [1430497]
- [mmc] sdhci: clean up host cookie handling (Don Zickus) [1430497]
- [mmc] sdhci: always unmap a mapped data transfer in sdhci_post_req() (Don Zickus) [1430497]
- [mmc] sdhci: pass the cookie into sdhci_pre_dma_transfer() (Don Zickus) [1430497]
- [mmc] sdhci: factor out sdhci_pre_dma_transfer() from sdhci_adma_table_pre() (Don Zickus) [1430497]
- [mmc] sdhci: move sdhci_pre_dma_transfer() (Don Zickus) [1430497]
- [mmc] sdhci: factor out common DMA cleanup in sdhci_finish_data() (Don Zickus) [1430497]
- [mmc] sdhci: avoid walking SG list for writes (Don Zickus) [1430497]
- [mmc] sdhci: clean up coding style in sdhci_adma_table_pre() (Don Zickus) [1430497]
- [mmc] sdhci: allocate alignment and DMA descriptor buffer together (Don Zickus) [1430497]
- [mmc] sdhci: fix data timeout (part 2) (Don Zickus) [1430497]
- [mmc] sdhci: fix data timeout (part 1) (Don Zickus) [1430497]
- [mmc] sdhci: further fix for DMA unmapping in sdhci_post_req() (Don Zickus) [1430497]
- [mmc] sdhci: plug DMA mapping leak on error (Don Zickus) [1430497]
- [mmc] sdhci: avoid unnecessary mapping/unmapping of align buffer (Don Zickus) [1430497]
- [mmc] sdhci: fix command response CRC error handling (Don Zickus) [1430497]
- [mmc] sdhci: clean up command error handling (Don Zickus) [1430497]
- [mmc] sdhci: move initialisation of command error member (Don Zickus) [1430497]
- [mmc] sdhci: Allow CAPS check for SDHCI_CAN_64BIT to use overridden caps (Don Zickus) [1430497]
- [mmc] sdhci-pic32: Add PIC32 SDHCI host controller driver (Don Zickus) [1430497]
- [mmc] dw_mmc: remove DW_MCI_QUIRK_BROKEN_CARD_DETECTION quirk (Don Zickus) [1430497]
- [mmc] dw_mmc: remove struct block_settings (Don Zickus) [1430497]
- [mmc] core: report tuning command execution failure reason (Don Zickus) [1430497]
- [mmc] block: shut up "retrying because a re-tune was needed" message (Don Zickus) [1430497]
- [mmc] core: improve mmc_of_parse_voltage() to return better status (Don Zickus) [1430497]
- [mmc] core: shut up "voltage-ranges unspecified" pr_info() (Don Zickus) [1430497]
- [mmc] block: don't use the OR operation for flag of data (Don Zickus) [1430497]
- [mmc] core: remove the MMC_DATA_STREAM flag (Don Zickus) [1430497]
- [mmc] sanitize 'bus width' in debug output (Don Zickus) [1430497]
- [mmc] core: use the defined function to check whether card is removable (Don Zickus) [1430497]
- [mmc] mmc_test: mention that '0' runs all tests (Don Zickus) [1430497]
- [mmc] mmcif: don't depend on MMC_BLOCK (Don Zickus) [1430497]
- [mmc] make MAN_BKOPS_EN message a debug (Don Zickus) [1430497]
- [mmc] sdhci-acpi: enable sdhci-acpi device to suspend/resume asynchronously (Don Zickus) [1430497]
- [mmc] core: enable mmc host device to suspend/resume asynchronously (Don Zickus) [1430497]
- [mmc] debugfs: Add a restriction to mmc debugfs clock setting (Don Zickus) [1430497]
- [mmc] remove unnecessary assignment statements before return (Don Zickus) [1430497]

* Fri Mar 17 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-616.el7]
- [fs] cifs: initialize file_info_lock (Sachin Prabhu) [1416808]
- [fs] cifs: Fix a possible double locking of mutex during reconnect (Sachin Prabhu) [1416808]
- [fs] cifs: Fix a possible memory corruption during reconnect (Sachin Prabhu) [1416808]
- [fs] cifs: Fix a possible memory corruption in push locks (Sachin Prabhu) [1416808]
- [fs] cifs: Fix missing nls unload in smb2_reconnect() (Sachin Prabhu) [1416808]
- [fs] cifs: Decrease verbosity of ioctl call (Sachin Prabhu) [1416808]
- [fs] smb3: parsing for new snapshot timestamp mount parm (Sachin Prabhu) [1416808]
- [fs] Call echo service immediately after socket reconnect (Sachin Prabhu) [1416808]
- [fs] cifs: Retrieve uid and gid from special sid if enabled (Sachin Prabhu) [1416808]
- [fs] cifs: Add new mount option to set owner uid and gid from special sids in acl (Sachin Prabhu) [1416808]
- [fs] cifs: Reset read oplock to NONE if we have mandatory locks after reopen (Sachin Prabhu) [1416808]
- [fs] cifs: Fix persistent handles re-opening on reconnect (Sachin Prabhu) [1416808]
- [fs] smb2: Separate RawNTLMSSP authentication from SMB2_sess_setup (Sachin Prabhu) [1416808]
- [fs] smb2: Separate Kerberos authentication from SMB2_sess_setup (Sachin Prabhu) [1416808]
- [fs] Expose cifs module parameters in sysfs (Sachin Prabhu) [1416808]
- [fs] Cleanup missing frees on some ioctls (Sachin Prabhu) [1416808]
- [fs] Enable previous version support (Sachin Prabhu) [1416808]
- [fs] Do not send SMB3 SET_INFO request if nothing is changing (Sachin Prabhu) [1416808]
- [fs] smb3: Add mount parameter to allow user to override max credits (Sachin Prabhu) [1416808]
- [fs] cifs: reopen persistent handles on reconnect (Sachin Prabhu) [1416808]
- [fs] Clarify locking of cifs file and tcon structures and make more granular (Sachin Prabhu) [1416808]
- [fs] cifs: keep guid when assigning fid to fileinfo (Sachin Prabhu) [1416808]
- [fs] smb3: GUIDs should be constructed as random but valid uuids (Sachin Prabhu) [1416808]
- [fs] Set previous session id correctly on SMB3 reconnect (Sachin Prabhu) [1416808]
- [fs] cifs: Limit the overall credit acquired (Sachin Prabhu) [1416808]
- [fs] Display number of credits available (Sachin Prabhu) [1416808]
- [fs] cifs: get rid of unused arguments of CIFSSMBWrite() (Sachin Prabhu) [1416808]
- [fs] cifs: don't use ->d_time (Sachin Prabhu) [1416808]
- [fs] cifs: Fix a possible invalid memory access in smb2_query_symlink() (Sachin Prabhu) [1416808]
- [fs] cifs: fix crash due to race in hmac(md5) handling (Sachin Prabhu) [1416808]
- [fs] cifs: unbreak TCP session reuse (Sachin Prabhu) [1416808]
- [fs] File names with trailing period or space need special case conversion (Sachin Prabhu) [1416808]
- [fs] Fix reconnect to not defer smb3 session reconnect long after socket reconnect (Sachin Prabhu) [1416808]
- [fs] cifs: check hash calculating succeeded (Sachin Prabhu) [1416808]
- [fs] cifs: stuff the fl_owner into "pid" field in the lock request (Sachin Prabhu) [1416808]
- [fs] cifs: Remove some obsolete comments (Sachin Prabhu) [1416808]
- [fs] remove directory incorrectly tries to set delete on close on non-empty directories (Sachin Prabhu) [1416808]
- [fs] Update cifs.ko version to 2.09 (Sachin Prabhu) [1416808]
- [fs] cifs: Fix removexattr for os2.* xattrs (Sachin Prabhu) [1416808]
- [fs] cifs: Check for equality with ACL_TYPE_ACCESS and ACL_TYPE_DEFAULT (Sachin Prabhu) [1416808]
- [fs] cifs: Fix xattr name checks (Sachin Prabhu) [1416808]
- [fs] cifs: kill more bogus checks in ->...xattr() methods (Sachin Prabhu) [1416808]
- [fs] don't bother with ->d_inode->i_sb - it's always equal to ->d_sb (Sachin Prabhu) [1416808]
- [fs] mm, fs: remove remaining PAGE_CACHE_* and page_cache_{get, release} usage(cifs only) (Sachin Prabhu) [1416808]
- [fs] mm, fs: get rid of PAGE_CACHE_* and page_cache_{get, release} macros(cifs only) (Sachin Prabhu) [1416808]
- [fs] lib: update single-char callers of strtobool()(cifs only) (Sachin Prabhu) [1416808]
- [fs] Add helper kstrtobool_from_user (Sachin Prabhu) [1416808]
- [fs] cifs_get_root(): use lookup_one_len_unlocked() (Sachin Prabhu) [1416808]
- [fs] Fix cifs_uniqueid_to_ino_t() function for s390x (Sachin Prabhu) [1416808]
- [fs] wrappers for ->i_mutex access (Sachin Prabhu) [1416808]
- [fs] cifs: remove redundant check for null string pointer (Sachin Prabhu) [1416808]
- [fs] cifs: Add decryption and encryption key generation (Sachin Prabhu) [1416808]
- [fs] cifs: Allow using O_DIRECT with cache=loose (Sachin Prabhu) [1416808]
- [fs] posix acls: Remove duplicate xattr name definitions (cifs only) (Sachin Prabhu) [1416808]
- [fs] libceph: don't set weight to IN when OSD is destroyed (Ilya Dryomov) [1427556]
- [fs] xfs: allocate log vector buffers outside CIL context lock (Brian Foster) [1410906]
- [fs] procfs: expose umask in /proc/<PID>/status (Miklos Szeredi) [1391413]
- [fs] gfs2: Prevent BUG from occurring when normal Withdraws occur (Robert S Peterson) [1404005]
- [fs] ext4: fix mmp use after free during unmount (Lukas Czerner) [1386651]
- [fs] jbd2: fix incorrect unlock on j_list_lock (Lukas Czerner) [1403346]
- [fs] nfs: nfs_rename() handle -ERESTARTSYS dentry left behind (Benjamin Coddington) [1349647]
- [fs] nfsv4.0: always send mode in SETATTR after EXCLUSIVE4 (Benjamin Coddington) [1415780]
- [fs] xfs: split indlen reservations fairly when under reserved (Brian Foster) [1423393]
- [fs] xfs: handle indlen shortage on delalloc extent merge (Brian Foster) [1423393]
- [netdrv] bna: use new api ethtool_{get|set}_link_ksettings (Jonathan Toppins) [1386007]
- [netdrv] bna: use correct type specifier (2) (Jonathan Toppins) [1386007]
- [netdrv] bna: use correct type specifications (Jonathan Toppins) [1386007]
- [scsi] bfa: Increase requested firmware version to 3.2.5.1 (Jonathan Toppins) [1386007]
- [netdrv] bna: Update the Driver and Firmware Version (Jonathan Toppins) [1386007]
- [kernel] watchdog: prevent false hardlockup on overloaded system (Don Zickus) [1399881]
- [security] keys: request_key() should reget expired keys rather than give EKEYEXPIRED (David Howells) [1408330]
- [security] keys: Simplify KEYRING_SEARCH_{NO, DO}_STATE_CHECK flags (David Howells) [1408330]

* Fri Mar 17 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-615.el7]
- [net] sched: sch_sfb: keep backlog updated with qlen (Ivan Vecera) [1382040]
- [net] sched: sch_qfq: keep backlog updated with qlen (Ivan Vecera) [1382040]
- [net] switchdev: Fix return value of switchdev_port_fdb_dump() (Ivan Vecera) [1382040]
- [net] sched: netem: fix a use after free (Ivan Vecera) [1382040]
- [net] sched: fix pfifo_head_drop behavior vs backlog (Ivan Vecera) [1382040]
- [net] sched: fq_codel: fix NET_XMIT_CN behavior (Ivan Vecera) [1382040]
- [net] sched: keep backlog updated with qlen (Ivan Vecera) [1382040]
- [net] sched: sch_tbf: update backlog as well (Ivan Vecera) [1382040]
- [net] sched: sch_red: update backlog as well (Ivan Vecera) [1382040]
- [net] sched: sch_drr: update backlog as well (Ivan Vecera) [1382040]
- [net] sched: sch_prio: update backlog as well (Ivan Vecera) [1382040]
- [net] sched: sch_hfsc: always keep backlog updated (Ivan Vecera) [1382040]
- [net] sched: fq_codel: fix memory limitation drift (Ivan Vecera) [1382040]
- [net] sched: fq_codel: add memory limitation per queue (Ivan Vecera) [1382040]
- [net] sched: fq_codel: add batch ability to fq_codel_drop() (Ivan Vecera) [1382040]
- [net] sched: fq_codel: explicitly reset flows in ->reset() (Ivan Vecera) [1382040]
- [net] sched: fq_codel: fix return value of fq_codel_drop() (Ivan Vecera) [1382040]
- [net] sched: fq_codel: fix a use-after-free (Ivan Vecera) [1382040]
- [net] rtnetlink: fix FDB size computation (Ivan Vecera) [1382040]
- [net] dev: Fix non-RCU based lower dev walker (Ivan Vecera) [1382040]
- [net] Introduce new api for walking upper and lower devices (Ivan Vecera) [1382040]
- [net] rtnetlink: fdb dump: optimize by saving last interface markers (Ivan Vecera) [1382040]
- [net] rtnetlink: wrap .ndo_fdb_dump calls (Ivan Vecera) [1382040]
- [net] rtnetlink: Pass VLAN ID to rtnl_fdb_notify (Ivan Vecera) [1382040]
- [net] rtnetlink: fix fdb notification flags (Ivan Vecera) [1382040]
- [net] fq: Port memory limit mechanism from fq_codel (Ivan Vecera) [1382040]
- [net] fq: split out backlog update logic (Ivan Vecera) [1382040]
- [net] fq: add fair queuing framework (Ivan Vecera) [1382040]
- [net] codel: split into multiple files (Ivan Vecera) [1382040]
- [net] codel: generalize the implementation (Ivan Vecera) [1382040]
- [net] Add skb_get_hash_perturb (Ivan Vecera) [1382040]
- [net] Only do flow_dissector hash computation once per packet (Ivan Vecera) [1382040]
- [net] sch_dsmark: update backlog as well (Ivan Vecera) [1382040]
- [net] sch_htb: update backlog as well (Ivan Vecera) [1382040]
- [net] sched: update hierarchical backlog too (Ivan Vecera) [1382040]
- [net] sched: introduce qdisc_replace() helper (Ivan Vecera) [1382040]
- [net] codel: add ce_threshold attribute (Ivan Vecera) [1382040]
- [net] codel: fix maxpacket/mtu confusion (Ivan Vecera) [1382040]
- [net] use ktime_get_ns() and ktime_get_real_ns() helpers (Ivan Vecera) [1382040]
- [net] codel: Avoid undefined behavior from signed overflow (Ivan Vecera) [1382040]
- [net] sock: backport __sock_queue_rcv_skb() (Ivan Vecera) [1382040]
- [net] sock: convert sk_peek_offset functions to WRITE_ONCE (Ivan Vecera) [1382040]
- [net] Add and use skb_copy_datagram_msg() helper (Ivan Vecera) [1382040]
- [net] ipv6: Export fib6_get_table and nd_tbl (Ivan Vecera) [1382040]

* Fri Mar 17 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-614.el7]
- [fs] nfsv4: Label stateids with the type (Steve Dickson) [1349668]
- [fs] pnfs: Files and flexfiles always need to commit before layoutcommit (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Clean up calls to pnfs_set_layoutcommit() (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Fix layoutcommit after a commit to DS (Steve Dickson) [1349668]
- [fs] pnfs/files: Fix layoutcommit after a commit to DS (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Fix a deadlock on LAYOUTGET (Steve Dickson) [1349668]
- [fs] nfs: Fix used uninitialized warn in nfs4_slot_seqid_in_use() (Steve Dickson) [1349668]
- [fs] nfs4: fix missing-braces warning (Steve Dickson) [1349668]
- [fs] nfsv4.2: Fix a reference leak in nfs42_proc_layoutstats_generic (Steve Dickson) [1349668]
- [fs] pnfs: Fix atime updates on pNFS clients (Steve Dickson) [1349668]
- [fs] nfsv4: Fix a race when updating an open_stateid (Steve Dickson) [1349668]
- [fs] nfsv4: Fix a race in nfs_inode_reclaim_delegation() (Steve Dickson) [1349668]
- [fs] nfsv4: Pass the stateid to the exception handler in nfs4_read/write_done_cb (Steve Dickson) [1349668]
- [fs] nfsv4.1: nfs4_layoutget_handle_exception handle revoked state (Steve Dickson) [1349668]
- [fs] nfsv4: nfs4_handle_setlk_error() handle expiration as revoke case (Steve Dickson) [1349668]
- [fs] nfsv4: nfs4_handle_delegation_recall_error() handle expiration as revoke case (Steve Dickson) [1349668]
- [fs] nfsv4: nfs4_do_handle_exception() handle revoke/expiry of a single stateid (Steve Dickson) [1349668]
- [fs] nfsv4: nfs_inode_find_state_and_recover() should check all stateids (Steve Dickson) [1349668]
- [fs] nfsv4.1: Ensure we call FREE_STATEID if needed on close/delegreturn/locku (Steve Dickson) [1349668]
- [fs] nfsv4.1: FREE_STATEID can be asynchronous (Steve Dickson) [1349668]
- [fs] nfsv4.1: Ensure we always run TEST/FREE_STATEID on locks (Steve Dickson) [1349668]
- [fs] nfsv4.1: Allow revoked stateids to skip the call to TEST_STATEID (Steve Dickson) [1349668]
- [fs] nfsv4.1: Don't deadlock the state manager on the SEQUENCE status flags (Steve Dickson) [1349668]
- [fs] nfsv4.1: Remove obsolete and incorrrect assignment in nfs4_callback_sequence (Steve Dickson) [1349668]
- [fs] nfsv4.1: Close callback races for OPEN, LAYOUTGET and LAYOUTRETURN (Steve Dickson) [1349668]
- [fs] nfsv4.1: Defer bumping the slot sequence number until we free the slot (Steve Dickson) [1349668]
- [fs] nfsv4.1: Delay callback processing when there are referring triples (Steve Dickson) [1349668]
- [fs] nfsv4.1: Fix Oopsable condition in server callback races (Steve Dickson) [1349668]
- [fs] nfsv4.1: Fix the CREATE_SESSION slot number accounting (Steve Dickson) [1349668]
- [fs] pnfs: Don't forget the layout stateid if there are outstanding LAYOUTGETs (Steve Dickson) [1349668]
- [fs] pnfs: Clear out all layout segments if the server unsets lrp->res.lrs_present (Steve Dickson) [1349668]
- [fs] pnfs: Fix pnfs_set_layout_stateid() to clear NFS_LAYOUT_INVALID_STID (Steve Dickson) [1349668]
- [fs] nfsv4.1: Don't recheck delegations that have already been checked (Steve Dickson) [1349668]
- [fs] nfsv4.1: Deal with server reboots during delegation expiration recovery (Steve Dickson) [1349668]
- [fs] nfsv4.1: Test delegation stateids when server declares "some state revoked" (Steve Dickson) [1349668]
- [fs] nfsv4.x: Allow callers of nfs_remove_bad_delegation() to specify a stateid (Steve Dickson) [1349668]
- [fs] nfsv4.1: Add a helper function to deal with expired stateids (Steve Dickson) [1349668]
- [fs] nfsv4.1: Allow test_stateid to handle session errors without waiting (Steve Dickson) [1349668]
- [fs] nfsv4.1: Don't check delegations that are already marked as revoked (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Fix an Oopsable condition when connection to the DS fails (Steve Dickson) [1349668]
- [fs] pnfs: The client must not do I/O to the DS if it's lease has expired (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Set reasonable default retrans values for the data channel (Steve Dickson) [1349668]
- [fs] nfs: Allow the mount option retrans=0 (Steve Dickson) [1349668]
- [fs] pnfs: Handle NFS4ERR_OLD_STATEID correctly in LAYOUTSTAT calls (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Fix layoutstat periodic reporting (Steve Dickson) [1349668]
- [fs] Remove "tech preview" label for flexfile driver (Steve Dickson) [1349668]
- [fs] nfsv4: Cap the transport reconnection timer at 1/2 lease period (Steve Dickson) [1349668]
- [fs] sunrpc: Limit the reconnect backoff timer to the max RPC message timeout (Steve Dickson) [1349668]
- [fs] sunrpc: Fix reconnection timeouts (Steve Dickson) [1349668]
- [fs] sunrpc: Reduce latency when send queue is congested (Steve Dickson) [1349668]
- [fs] sunrpc: RPC transport queue must be low latency (Steve Dickson) [1349668]
- [fs] sunrpc: Consolidate xs_tcp_data_ready and xs_data_ready (Steve Dickson) [1349668]
- [fs] sunrpc: Small optimisation of client receive (Steve Dickson) [1349668]
- [fs] nfsv4: Clean up lookup of SECINFO_NO_NAME (Steve Dickson) [1349668]
- [fs] pnfs: Remove redundant smp_mb() from pnfs_init_lseg() (Steve Dickson) [1349668]
- [fs] pnfs: Cleanup - do layout segment initialisation in one place (Steve Dickson) [1349668]
- [fs] pnfs: Remove redundant stateid invalidation (Steve Dickson) [1349668]
- [fs] pnfs: Remove redundant pnfs_mark_layout_returned_if_empty() (Steve Dickson) [1349668]
- [fs] pnfs: Clear the layout metadata if the server changed the layout stateid (Steve Dickson) [1349668]
- [fs] pnfs: Cleanup - don't open code pnfs_mark_layout_stateid_invalid() (Steve Dickson) [1349668]
- [fs] nfs: pnfs_mark_matching_lsegs_return() should match the layout sequence id (Steve Dickson) [1349668]
- [fs] pnfs: Do not set plh_return_seq for non-callback related layoutreturns (Steve Dickson) [1349668]
- [fs] pnfs: Ensure layoutreturn acts as a completion for layout callbacks (Steve Dickson) [1349668]
- [fs] pnfs: Fix CB_LAYOUTRECALL stateid verification (Steve Dickson) [1349668]
- [fs] pnfs: Always update the layout barrier seqid on LAYOUTGET (Steve Dickson) [1349668]
- [fs] pnfs: Always update the layout stateid if NFS_LAYOUT_INVALID_STID is set (Steve Dickson) [1349668]
- [fs] pnfs: Clear the layout return tracking on layout reinitialisation (Steve Dickson) [1349668]
- [fs] pnfs: LAYOUTRETURN should only update the stateid if the layout is valid (Steve Dickson) [1349668]
- [fs] pnfs/files: filelayout_write_done_cb must call nfs_writeback_update_inode() (Steve Dickson) [1349668]
- [fs] mount: use sec= that was specified on the command line (Steve Dickson) [1349668]
- [fs] fixing infinite OPEN loop in 4.0 stateid recovery (Steve Dickson) [1349668]
- [fs] nfs/pnfs: Do not clobber existing pgio_done_cb in nfs4_proc_read_setup (Steve Dickson) [1349668]
- [fs] sunrpc: Detect immediate closure of accepted sockets (Steve Dickson) [1349668]
- [fs] sunrpc: accept() may return sockets that are still in SYN_RECV (Steve Dickson) [1349668]
- [fs] pnfs: Fix post-layoutget error handling in pnfs_update_layout() (Steve Dickson) [1349668]
- [fs] pnfs: Fix LAYOUTGET handling of NFS4ERR_BAD_STATEID and NFS4ERR_EXPIRED (Steve Dickson) [1349668]
- [fs] pnfs: Handle NFS4ERR_RECALLCONFLICT correctly in LAYOUTGET (Steve Dickson) [1349668]
- [fs] pnfs: Separate handling of NFS4ERR_LAYOUTTRYLATER and RECALLCONFLICT (Steve Dickson) [1349668]
- [fs] nfs: Fix another OPEN_DOWNGRADE bug (Steve Dickson) [1349668]
- [fs] nfs: Fix potential race in nfs_fhget() (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Mark the layout stateid invalid when all segments are removed (Steve Dickson) [1349668]
- [fs] nfs: Fix a double page unlock (Steve Dickson) [1349668]
- [fs] pnfs_nfs: fix _cancel_empty_pagelist (Steve Dickson) [1349668]
- [fs] nfs/pnfs: handle bad delegation stateids in nfs4_layoutget_handle_exception (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Add sparse lock annotations for pnfs_find_alloc_layout (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Layout stateids start out as being invalid (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Ensure we handle delegation errors in nfs4_proc_layoutget() (Steve Dickson) [1349668]
- [fs] nfs: fix anonymous member initializer build failure with older compilers (Steve Dickson) [1349668]
- [fs] pnfs: pnfs_update_layout needs to consider if strict iomode checking is on (Steve Dickson) [1349668]
- [fs] nfs/flexfiles: Use the layout segment for reading unless it a IOMODE_RW and reading is disabled (Steve Dickson) [1349668]
- [fs] nfs/flexfiles: Helper function to detect FF_FLAGS_NO_READ_IO (Steve Dickson) [1349668]
- [fs] nfs: avoid race that crashes nfs_init_commit (Steve Dickson) [1349668]
- [fs] pnfs: make pnfs_layout_process more robust (Steve Dickson) [1349668]
- [fs] pnfs: rework LAYOUTGET retry handling (Steve Dickson) [1349668]
- [fs] pnfs: lift retry logic from send_layoutget to pnfs_update_layout (Steve Dickson) [1349668]
- [fs] pnfs: fix bad error handling in send_layoutget (Steve Dickson) [1349668]
- [fs] flexfiles: add kerneldoc header to nfs4_ff_layout_prepare_ds (Steve Dickson) [1349668]
- [fs] flexfiles: remove pointless setting of NFS_LAYOUT_RETURN_REQUESTED (Steve Dickson) [1349668]
- [fs] pnfs: only tear down lsegs that precede seqid in LAYOUTRETURN args (Steve Dickson) [1349668]
- [fs] pnfs: keep track of the return sequence number in pnfs_layout_hdr (Steve Dickson) [1349668]
- [fs] pnfs: record sequence in pnfs_layout_segment when it's created (Steve Dickson) [1349668]
- [fs] pnfs: don't merge new ff lsegs with ones that have LAYOUTRETURN bit set (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: When initing reads or writes, we might have to retry connecting to DSes (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: When checking for available DSes, conditionally check for MDS io (Steve Dickson) [1349668]
- [fs] pnfs/flexfile: Fix erroneous fall back to read/write through the MDS (Steve Dickson) [1349668]
- [fs] nfs: Reclaim writes via writepage are opportunistic (Steve Dickson) [1349668]
- [fs] pnfs: Fix a leaked layoutstats flag (Steve Dickson) [1349668]
- [fs] nfs4: client: do not send empty SETATTR after OPEN_CREATE (Steve Dickson) [1349668]
- [fs] Fixing oops in callback path (Steve Dickson) [1349668]
- [fs] nfs: don't share mounts between network namespaces (Steve Dickson) [1349668]
- [fs] nfs: Save struct inode * inside nfs_commit_info to clarify usage of i_lock (Steve Dickson) [1349668]
- [fs] pnfs: set NFS_IOHDR_REDO in pnfs_read_resend_pnfs (Steve Dickson) [1349668]
- [fs] nfs: missing wakeup in nfs_unblock_sillyrename() (Steve Dickson) [1349668]
- [fs] nfsv4.x/pnfs: Fix a race between layoutget and bulk recalls (Steve Dickson) [1349668]
- [fs] nfsv4.x/pnfs: Fix a race between layoutget and pnfs_destroy_layout (Steve Dickson) [1349668]
- [fs] nfs4: fix stateid handling for the NFS v4.2 operations (Steve Dickson) [1349668]
- [fs] pnfs: Always set NFS_LAYOUT_RETURN_REQUESTED with lo->plh_return_iomode (Steve Dickson) [1349668]
- [fs] pnfs: Fix pnfs_mark_matching_lsegs_return() (Steve Dickson) [1349668]
- [fs] nfsv4.x: Fix NFS4ERR_RETRY_UNCACHED_REP in nfs4_callback_sequence (Steve Dickson) [1349668]
- [fs] nfs: Cleanup - rename NFS_LAYOUT_RETURN_BEFORE_CLOSE (Steve Dickson) [1349668]
- [fs] pnfs: Fix missing layoutreturn calls (Steve Dickson) [1349668]
- [fs] nfsv4.x: Allow multiple callbacks in flight (Steve Dickson) [1349668]
- [fs] nfsv4.x: Fix wraparound issues when validing the callback sequence id (Steve Dickson) [1349668]
- [fs] nfsv4.x: Enforce the ca_maxresponsesize_cached on the back channel (Steve Dickson) [1349668]
- [fs] nfsv4.x: CB_SEQUENCE should return NFS4ERR_DELAY if still executing (Steve Dickson) [1349668]
- [fs] nfsv4.x: Remove hard coded slotids in callback channel (Steve Dickson) [1349668]
- [fs] nfs: Simplify nfs_request_add_commit_list() arguments (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Improve merging of errors in LAYOUTRETURN (Steve Dickson) [1349668]
- [fs] nfs: Fix a compile warning about unused variable in nfs_generic_pg_pgios() (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Cleanup constify struct pnfs_layout_range arguments (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Cleanup copying of pnfs_layout_range structures (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Cleanup pnfs_mark_matching_lsegs_invalid() (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Fix a race in initiate_file_draining() (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: pnfs_error_mark_layout_for_return() must always return layout (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: pnfs_mark_matching_lsegs_return() should set the iomode (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Use nfs4_stateid_copy for copying stateids (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Don't pass stateids by value to pnfs_send_layoutreturn() (Steve Dickson) [1349668]
- [fs] nfs: Relax requirements in nfs_flush_incompatible (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Don't queue up a new commit if the layout segment is invalid (Steve Dickson) [1349668]
- [fs] nfs: Allow multiple commit requests in flight per file (Steve Dickson) [1349668]
- [fs] nfs/pnfs: Fix up pNFS write reschedule layering violations and bugs (Steve Dickson) [1349668]
- [fs] nfs: Ensure we revalidate attributes before using execute_ok() (Steve Dickson) [1349668]
- [fs] nfsv4: List stateid information in the callback tracepoints (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Don't return NFS4ERR_DELAY unnecessarily in CB_LAYOUTRECALL (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Ensure we enforce RFC5661 Section 12.5.5.2.1 (Steve Dickson) [1349668]
- [fs] pnfs: If we have to delay the layout callback, mark the layout for return (Steve Dickson) [1349668]
- [fs] nfsv4.1/pnfs: Add a helper to mark the layout as returned (Steve Dickson) [1349668]
- [fs] pnfs: Ensure nfs4_layoutget_prepare returns the correct error (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Ensure we record layoutstats even if RPC is terminated early (Steve Dickson) [1349668]
- [fs] pnfs: Add flag to track if we've called nfs4_ff_layout_stat_io_start_read/write (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Fix a statistics gathering imbalance (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Don't mark the entire layout as failed, when returning it (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: count io stat in rpc_count_stats callback (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: do not mark delay-like status as DS failure (Steve Dickson) [1349668]
- [fs] pnfs/flexfiles: Support server-supplied layoutstats sampling period (Steve Dickson) [1349668]
- [fs] nfs: Flush reclaim writes using FLUSH_COND_STABLE (Steve Dickson) [1349668]
- [fs] nfs: Background flush should not be low priority (Steve Dickson) [1349668]
- [fs] nfs: do not initialise statics to 0 (Steve Dickson) [1349668]
- [fs] nfsv4: Fix unused variable warnings in nfs4_init_*_client_string() (Steve Dickson) [1349668]
- [fs] Adding tracepoint to cached open (Steve Dickson) [1349668]
- [fs] nfs: fix missing assignment in nfs4_sequence_done tracepoint (Steve Dickson) [1349668]
- [fs] nfs42: handle layoutstats stateid error (Steve Dickson) [1349668]
- [fs] sunrpc: set SOCK_FASYNC (Steve Dickson) [1349668]
- [fs] sunrpc: init xdr_stream for zero iov_len, page_len (Steve Dickson) [1349668]
- [fs] sunrpc/cache: fix off-by-one in qword_get() (Steve Dickson) [1349668]
- [fs] sunrpc: Fix a missing break in rpc_anyaddr() (Steve Dickson) [1349668]
- [fs] sunrpc: drop unused xs_reclassify_socketX() helpers (Steve Dickson) [1349668]

* Thu Mar 16 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-613.el7]
- [net] sctp: also copy sk_tsflags when copying the socket (Hangbin Liu) [1389283]
- [net] timestamp: allow reading recv cmsg on errqueue with origin tstamp (Hangbin Liu) [1389283]
- [net] timestamp: only report sw timestamp if reporting bit is set (Hangbin Liu) [1389283]
- [net] timestamp: move timestamp flags out of sk_flags (Hangbin Liu) [1389283]
- [net] timestamp: extend SCM_TIMESTAMPING ancillary data struct (Hangbin Liu) [1389283]
- [net] Improve SO_TIMESTAMPING documentation and fix a minor code bug (Hangbin Liu) [1389283]
- [net] ipv6: make IPV6_RECVPKTINFO work for ipv4 datagrams (Hangbin Liu) [1389283]
- [net] ipv6: transp_v6.h: style neatening (Hangbin Liu) [1389283]
- [net] ipv6: Clean up indentation in net/ipv6/transp_v6.h (Hangbin Liu) [1389283]
- [net] tunnel: set inner protocol in network gro hooks (Paolo Abeni) [1427781]
- [net] gro_cells: remove spinlock protecting receive queues (Jiri Benc) [1429597]
- [netdrv] virtio-net: Update the mtu code to match virtio spec (Aaron Conole) [1412234]
- [netdrv] virtio_net: Update the feature bit to comply with spec (Aaron Conole) [1412234]
- [netdrv] virtio-net: Add initial MTU advice feature (Aaron Conole) [1412234]
- [net] ipv6: Set skb->protocol properly for local output (Jakub Sitnicki) [1336001]
- [net] ipv4: Set skb->protocol properly for local output (Jakub Sitnicki) [1336001]
- [net] sit: fix a double free on error path (Jakub Sitnicki) [1336001]
- [net] ipv6: pointer math error in ip6_tnl_parse_tlv_enc_lim() (Jakub Sitnicki) [1336001]
- [net] ipv6: fix ip6_tnl_parse_tlv_enc_lim() (Jakub Sitnicki) [1336001]
- [net] ip6_tunnel: must reload ipv6h in ip6ip6_tnl_xmit() (Jakub Sitnicki) [1336001]
- [net] ip6_tunnel: Clear IP6CB in ip6tunnel_xmit() (Jakub Sitnicki) [1336001]
- [net] ip6_tunnel: fix ip6_tnl_lookup (Jakub Sitnicki) [1336001]
- [net] sit: correct IP protocol used in ipip6_err (Jakub Sitnicki) [1336001]
- [net] tunnel: Clear IPCB(skb)->opt before dst_link_failure called (Jakub Sitnicki) [1336001]
- [net] ip_tunnel: fix ipv4 pmtu check to honor inner ip header df (Jakub Sitnicki) [1336001]
- [net] ipip: fix one sparse error (Jakub Sitnicki) [1336001]
- [net] sit: fix some __be16/u16 mismatches (Jakub Sitnicki) [1336001]
- [net] fou: Fix typo in returning flags in netlink (Jakub Sitnicki) [1336001]
- [net] ipip, sit: fix ipv4_{update_pmtu,redirect} calls (Jakub Sitnicki) [1336001]
- [net] openvswitch: add NETIF_F_HW_VLAN_STAG_TX to internal dev (Eric Garver) [1155732]
- [net] openvswitch: fix vlan subtraction from packet length (Eric Garver) [1155732]
- [net] openvswitch: vlan: remove wrong likely statement (Eric Garver) [1155732]
- [net] openvswitch: 802.1AD Flow handling, actions, vlan parsing, netlink attributes (Eric Garver) [1155732]
- [net] vlan: Check for vlan ethernet types for 8021.q or 802.1ad (Eric Garver) [1155732]
- [net] fib_trie: Correct /proc/net/route off by one error (Hannes Frederic Sowa) [1426372]
- [net] ipv4: panic in leaf_walk_rcu due to stale node pointer (Hannes Frederic Sowa) [1426372]
- [net] documentation: ipv6: add documentation for stable_secret, idgen_delay and idgen_retries knobs (Hannes Frederic Sowa) [1418812]
- [net] ipv6: addrconf: always initialize sysctl table data (Hannes Frederic Sowa) [1418812]
- [net] ipv6: addrconf: use stable address generator for ARPHRD_NONE (Hannes Frederic Sowa) [1418812]
- [net] ipv6: automatically enable stable privacy mode if stable_secret set (Hannes Frederic Sowa) [1418812]
- [net] ipv6: fix sparse warnings in privacy stable addresses generation (Hannes Frederic Sowa) [1418812]
- [net] ipv6: introduce idgen_delay and idgen_retries knobs (Hannes Frederic Sowa) [1418812]
- [net] ipv6: do retries on stable privacy addresses (Hannes Frederic Sowa) [1418812]
- [net] ipv6: collapse state_lock and lock (Hannes Frederic Sowa) [1418812]
- [net] ipv6: introduce IFA_F_STABLE_PRIVACY flag (Hannes Frederic Sowa) [1418812]
- [net] ipv6: generation of stable privacy addresses for link-local and autoconf (Hannes Frederic Sowa) [1418812]
- [net] ipv6: introduce secret_stable to ipv6_devconf (Hannes Frederic Sowa) [1418812]
- [net] ipv6: remove unused function ipv6_inherit_linklocal() (Hannes Frederic Sowa) [1418812]
- [net] tcp/dccp: avoid starving bh on connect (Paolo Abeni) [1401419]

* Thu Mar 16 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-612.el7]
- [hid] hid-wacom: rename driver and dont use it on already supported devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [lib] kobject: grab an extra reference on kobject->sd to allow duplicate deletes (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Update last_slot_field during pre_report phase (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - add touch_arbitration parameter to wacom module (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Augment oVid and oPid with heuristics for HID_GENERIC (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add WACOM_DEVICETYPE_DIRECT for Cintiqs and similar (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: power_supply: provide the actual model_name (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: power_supply: remove ac information (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: power_supply: mark the type as USB (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: ekr: attach the power_supply on first connection (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: ekr: have one power_supply per remote (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: ekr: allocate one input node per remote (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: ekr: have one array of struct remotes instead of many arrays (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: ekr: use devres groups to manage resources (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: ekr: have proper allocator and destructor (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: rework fail path in probe() and parse_and_register() (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: ekr: have the wacom resources dynamically allocated (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: ekr: add a worker to add/remove resources on addition/removal (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: leds: dynamically allocate LED groups (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: devres manage the shared data too (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: use devres to allocate driver data (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: use devm_kasprintf for allocating the name of the remote (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: convert LEDs to devres (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: put the managed resources in a group (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: switch inputs to devres (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: switch battery to devres (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: use one work queue per task (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: untie leds from inputs (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: remove cleanup of wacom->remote_dir from wacom_clean_inputs() (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: store the type in wacom->shared for INTUOSHT and INTUOSHT2 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: actually report the battery level for wireless connected (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: add missed stylus_in_proximity line back (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add fuzz factor to distance and tilt axes (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add support for DTK-1651 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Support switching from vendor-defined device mode on G9 and G11 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Initialize hid_data.inputmode to -1 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: fix Bamboo ONE oops (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: close the wireless receiver on remove() (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: cleanup input devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: reuse wacom_parse_and_register() in wireless_work (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: move down wireless_work() (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: break out parsing of device and registering of input (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: break out wacom_intuos_get_tool_type (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - Add quirks for INTUOSHT2 in range events (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - Cleanup touch arbitration logic (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - make sure wacom_intuos_inout only process in/out events (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - request tool info only when we get general events (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Use correct report to query pen ID from INTUOSHT2 devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] use kobj_to_dev() (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] use to_hid_device() (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Fix pad button range for CINTIQ_COMPANION_2 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Fix touchring value reporting (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Report strip2 values in ABS_RY (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Limit touchstrip data to 13 bits (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: bitwise vs logical ORs (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Apply lowres quirk to BAMBOO_TOUCH devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Rename wacom ID report ID macros (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Clean up value reading (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Further clean up wacom_intuos_general packet decoder (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Replace magic masks and comparisons with switch cases (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Centralize Intuos pen packet decoding (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Slim down wacom_intuos_pad processing (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Move Intuos pad handling code into dedicated function (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Delete an unnecessary check before kobject_put() (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: fixup quirks setup for WACOM_DEVICETYPE_PAD (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add outbounding area for DTU1141 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Call wacom_query_tablet_data only after hid_hw_start (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Fix ABS_MISC reporting for Cintiq Companion 2 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Remove useless conditions from wacom_query_tablet_data (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: fix Intuos wireless report id issue (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Expect touch_max touches if HID_DG_CONTACTCOUNT not present (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Tie cached HID_DG_CONTACTCOUNT indices to report ID (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Report full pressure range for Intuos, Cintiq 13HD Touch (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add support for Cintiq Companion 2 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add four new Intuos devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Cleanup unsupported device_type for BAMBOO_PT (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: wacom_setup_numbered_buttons is local to wacom_wac (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add support for Express Key Remote (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Set button bits based on a new numbered_buttons (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Use tablet-provided touch height/width values for INTUOSHT (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Simplify wacom_pl_irq (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Report correct device resolution when using the wireless adapater (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Do not repeatedly attempt to set device mode on error (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Remove WACOM_QUIRK_NO_INPUT (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Replace WACOM_QUIRK_MONITOR with WACOM_DEVICETYPE_WL_MONITOR (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Use calculated pkglen for wireless touch interface (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Report touch width/height/orientation for GENERIC devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Ignore contacts in excess of declared contact count (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Perform all event processing as part of report processing (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Set default device name to value from wacom->features (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Properly free inputs if wacom_allocate_inputs fails (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: remove the extra Pen interface for Wacom Bamboo PAD (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Delete unnecessary checks before the function call "input_free_device" (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Enable pad device for older Bamboo Touch tablets (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: NULL dereferences on error in probe() (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Introduce new touch_input device (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Split apart wacom_setup_pentouch_input_capabilites (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Introduce a new WACOM_DEVICETYPE_PAD device_type (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Treat features->device_type values as flags (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Simplify wacom_update_name (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Handle failing HID_DG_CONTACTMAX requests (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Have wacom_{get, set}_report retry on -EAGAIN, not -EPIPE (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: fix an Oops caused by wacom_wac_finger_count_touches (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Fail probe if HID_GENERIC device has unknown device_type (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Discover device_type from HID descriptor for all devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Do not add suffix to name of devices with an unknown type (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: retrieve name from HID descriptor for generic devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add support for DTU-1141 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Simplify check for presence of single-finger touch (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: remove unused packet lengths (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: move unit and unitExpo initialization to wacom_calculate_res (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: move all quirks to wacom_setup_device_quirks (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add support for Cintiq 13HD Touch (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: set stylus_in_proximity before checking touch_down (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: use wacom_wac_finger_count_touches to set touch_down (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: remove hardcoded WACOM_QUIRK_MULTI_INPUT (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: check for wacom->shared before following the pointer (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: ask for a in-prox report when it was missed (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add battery presence indicator to wireless tablets (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: drop WACOM_PKGLEN_STATUS (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Status packet provides charging, not powered bit (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Report battery status for Intuos Pro and Intuos5 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Provide battery charge state to system over USB if available (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Allow dynamic battery creation/destruction (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Centralize updating of wacom_wac battery status (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Move handling of Intuos status packets to seperate function (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: rely on actual touch down count to decide touch_down (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: do not send pen events before touch is up/forced out (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: add full support of the Wacom Bamboo PAD (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: store the hid_device pointers of the sibling devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add support for I2C connected devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: do not directly use input_mt_report_pointer_emulation (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add missing ABS_MISC event and feature declaration for 27QHD (Aristeu Rozanski) [1346348 1388646 1385026]
- [uapi] hid: wacom: add support for Cintiq 27QHD and 27QHD touch (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: consolidate input capability settings for pen and touch (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: make sure touch arbitration is applied consistently (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Report ABS_MISC event for Cintiq Companion Hybrid (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: peport In Range event according to the spec (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: process invalid Cintiq and Intuos data in wacom_intuos_inout() (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: add support of the Pen of the Bamboo Pad (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: use WACOM_*_FIELD macros in wacom_usage_mapping() (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Report input events for each finger on generic devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Initialize MT slots for generic devices at post_parse_hid (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Update maximum X/Y accounding to outbound offset (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add support for DTU-1031X (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: add defines for new Cintiq and DTU outbound tracking (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Consult the application usage when determining field type (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: PAD is independent with pen/touch (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add angular resolution data to some ABS axes (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Report ABS_TILT_{X, Y} as signed values (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - Bamboo pen-only tablet does not support PAD (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - Cleanup input_capabilities for Graphire 4 and Bamboo Fun (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - return ENODEV for failed wacom_setup_pad_input_capabilities (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add support for Intuos Pen Medium (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - make sure touch_input is valid before using it (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] make hid_report_len as a static inline function in hid.h (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: fix freeze on open when autosuspend is on (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: re-add accidentally dropped Lenovo PID (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: implement the finger part of the HID generic handling (Aristeu Rozanski) [1346348 1388646 1385026]
- [kernel] hid: wacom: implement generic HID handling for pen generic devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: move allocation of inputs earlier (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: split out input allocation and registration (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: rename failN with some meaningful information (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: fix timeout on probe for some wacoms (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: make the WL connection friendly for the desktop (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - enable LED support for Wireless Intuos5/Pro (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - remove report_id from wacom_get_report interface (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - Clean up of sysfs (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom - Add default permission defines for sysfs attributes (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] wacom: Add support for the Cintiq Companion (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - cleanup multitouch code when touch_max is 2 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - fix compiler warning if !CONFIG_PM (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - only register once the MODULE_* macros (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - add copyright note and bump version to 2.0 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - remove passing id for wacom_set_report (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - check for bluetooth protocol while setting OLEDs (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: HID - remove hid-wacom Bluetooth driver (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - handle Intuos 4 BT in wacom.ko (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - handle Graphire BT tablets in wacom.ko (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - prepare the driver to include BT devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - add support for 0x12C ISDv4 sensor (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - register an ac power supply for wireless devices (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - use a uniq name for the battery device (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - enhance Wireless Receiver battery reporting (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - put a flag when the led are initialized (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - support up to 2048 pressure levels with ISDv4 (Aristeu Rozanski) [1346348 1388646 1385026]
- [hid] input: wacom - move the USB (now hid) Wacom driver in drivers/hid (Aristeu Rozanski) [1346348 1388646 1385026]
- [uapi] input: add SW_MUTE_DEVICE switch definition (Aristeu Rozanski) [1346348 1388646 1385026]
- [kernel] input: wacom - switch from an USB driver to a HID driver (Aristeu Rozanski) [1346348 1388646 1385026]
- [kernel] power_supply core: support use of devres to register/unregister a power supply (Aristeu Rozanski) [1346348 1388646 1385026]
- [kernel] power_supply: allow power supply devices registered w/o wakeup source (Aristeu Rozanski) [1346348 1388646 1385026]
- [kernel] power_supply: Prevent suspend until power supply events are processed (Aristeu Rozanski) [1346348 1388646 1385026]

* Wed Mar 15 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-611.el7]
- [fs] ext4: fix NULL pointer dereference in ext4_mark_inode_dirty() (Lukas Czerner) [1429223]
- [fs] ext4: reject inodes with negative size (Lukas Czerner) [1429223]
- [fs] ext4: return EROFS if device is r/o and journal replay is needed (Lukas Czerner) [1429223]
- [fs] ext4: preserve the needs_recovery flag when the journal is aborted (Lukas Czerner) [1429223]
- [fs] jbd2: don't leak modified metadata buffers on an aborted journal (Lukas Czerner) [1429223]
- [fs] ext4: trim allocation requests to group size (Lukas Czerner) [1429223]
- [fs] ext4: return -ENOMEM instead of success (Lukas Czerner) [1429223]
- [fs] ext4: add sanity checking to count_overhead() (Lukas Czerner) [1429223]
- [fs] ext4: use more strict checks for inodes_per_block on mount (Lukas Czerner) [1429223]
- [fs] ext4: fix in-superblock mount options processing (Lukas Czerner) [1429223]
- [fs] ext4: fix stack memory corruption with 64k block size (Lukas Czerner) [1429223]
- [fs] ext4: fix mballoc breakage with 64k block size (Lukas Czerner) [1429223]
- [fs] ext4: release bh in make_indexed_dir (Lukas Czerner) [1429223]
- [fs] ext4: bugfix for mmaped pages in mpage_release_unused_pages() (Lukas Czerner) [1429223]
- [fs] ext4: reinforce check of i_dtime when clearing high fields of uid and gid (Lukas Czerner) [1429223]
- [fs] ext4: avoid deadlock when expanding inode size (Lukas Czerner) [1429223]
- [fs] ext4: properly align shifted xattrs when expanding inodes (Lukas Czerner) [1429223]
- [fs] ext4: fix xattr shifting when expanding inodes part 2 (Lukas Czerner) [1429223]
- [fs] ext4: fix xattr shifting when expanding inodes (Lukas Czerner) [1429223]
- [fs] ext4: validate that metadata blocks do not overlap superblock (Lukas Czerner) [1429223]
- [fs] ext4: short-cut orphan cleanup on error (Lukas Czerner) [1429223]
- [fs] ext4: fix reference counting bug on block allocation error (Lukas Czerner) [1429223]
- [fs] ext4: validate s_reserved_gdt_blocks on mount (Lukas Czerner) [1429223]
- [fs] ext4: don't call ext4_should_journal_data() on the journal inode (Lukas Czerner) [1429223]
- [fs] ext4: check for extents that wrap around (Lukas Czerner) [1429223]
- [fs] ext4: silence UBSAN in ext4_mb_init() (Lukas Czerner) [1429223]
- [fs] ext4: address UBSAN warning in mb_find_order_for_block() (Lukas Czerner) [1429223]
- [fs] ext4: fix oops on corrupted filesystem (Lukas Czerner) [1429223]
- [fs] ext4: fix hang when processing corrupted orphaned inode list (Lukas Czerner) [1429223]
- [fs] ext4: add lockdep annotations for i_data_sem (Lukas Czerner) [1429223]
- [fs] jbd2: fix FS corruption possibility in jbd2_journal_destroy() on umount path (Lukas Czerner) [1429223]
- [fs] ext4: iterate over buffer heads correctly in move_extent_per_page() (Lukas Czerner) [1429223]
- [fs] ext4: don't read blocks from disk after extents being swapped (Lukas Czerner) [1429223]
- [fs] jbd2: Fix unreclaimed pages after truncate in data=journal mode (Lukas Czerner) [1429223]
- [fs] ext4, jbd2: ensure entering into panic after recording an error in superblock (Lukas Czerner) [1429223]
- [fs] fix calculation of meta_bg descriptor backups (Lukas Czerner) [1429223]
- [fs] ext4: replace open coded nofail allocation in ext4_free_blocks() (Lukas Czerner) [1429223]
- [fs] ext4: don't retry file block mapping on bigalloc fs with non-extent file (Lukas Czerner) [1429223]
- [fs] jbd2: fix ocfs2 corrupt when updating journal superblock fails (Lukas Czerner) [1429223]
- [fs] jbd2: use GFP_NOFS in jbd2_cleanup_journal_tail() (Lukas Czerner) [1429223]
- [fs] jbd2: fix r_count overflows leading to buffer overflow in journal recovery (Lukas Czerner) [1429223]
- [fs] ext4: move check under lock scope to close a race (Lukas Czerner) [1429223]
- [fs] ext4: Define EFSCORRUPTED error value (Lukas Czerner) [1429223]
- [fs] ext4: fix deadlock during page writeback (Lukas Czerner) [1321523]
- [fs] ext4: fix data exposure after a crash (Lukas Czerner) [1321523]
- [fs] ext4: fix fencepost in s_first_meta_bg validation (Lukas Czerner) [1332503] {CVE-2016-10208}
- [fs] ext4: sanity check the block and cluster size at mount time (Lukas Czerner) [1332503] {CVE-2016-10208}
- [fs] ext4: validate s_first_meta_bg at mount time (Lukas Czerner) [1332503] {CVE-2016-10208}

* Wed Mar 15 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-610.el7]
- [kernel] audit: Fix sleep in atomic (Paul Moore) [1410862]
- [uio] uio-hv-generic: mark as Tech Preview (Vitaly Kuznetsov) [1396534]
- [uio] uio-hv-generic: store physical addresses instead of virtual (Vitaly Kuznetsov) [1396534]
- [documentation] doc: add documentation for uio-hv-generic (Vitaly Kuznetsov) [1396534]
- [uio] uio-hv-generic: new userspace i/o driver for VMBus (Vitaly Kuznetsov) [1396534]
- [kernel] vmbus: add support for dynamic device id's (Vitaly Kuznetsov) [1396534]
- [kernel] hv: vmbus: add a hvsock flag in struct hv_driver (Vitaly Kuznetsov) [1396534]
- [scsi] cxlflash: Cancel scheduled workers before stopping AFU (Gustavo Duarte) [1427396]
- [vfio] Replace module request with softdep (Alex Williamson) [1420572]
- [vfio] mdev: Use a module softdep for vfio_mdev (Alex Williamson) [1420572]
- [x86] kvm: x86: bump KVM_SOFT_MAX_VCPUS to 288 (Radim Krcmar) [1388961]
- [x86] kvm: x86: allow hotplug of VCPU with APIC ID over 0xff (Radim Krcmar) [1388961]
- [x86] kvm: x86: make interrupt delivery fast and slow path behave the same (Radim Krcmar) [1388961]
- [x86] kvm: x86: replace kvm_apic_id with kvm_{x, x2}apic_id (Radim Krcmar) [1388961]
- [x86] pci: vmd: Synchronize with RCU freeing MSI IRQ descs (Myron Stowe) [1388664]
- [x86] pci: vmd: Fix infinite loop executing irq's (Myron Stowe) [1388664]
- [x86] pci: vmd: Initialize list item in IRQ disable (Myron Stowe) [1388688]
- [pci] Allow additional bus numbers for hotplug bridges (Myron Stowe) [1388688]
- [x86] pci/vmd: Use untracked irq handler (Myron Stowe) [1388688]
- [kernel] genirq: Add untracked irq handler (Myron Stowe) [1388688]
- [x86] pci: Retrofit Intel Volume Management Device (VMD) driver (Myron Stowe) [1388688]
- [x86] pci: Allow DMA ops specific to a PCI domain (Myron Stowe) [1388688]
- [x86] kvm/page_track: export symbols for external usage (Paul Lai) [1380113]
- [x86] kvm/page_track: call notifiers with kvm_page_track_notifier_node (Paul Lai) [1380113]
- [x86] kvm: x86: add track_flush_slot page track notifier (Paul Lai) [1380113]
- [x86] kvm: mtrr: fix kvm_mtrr_check_gfn_range_consistency page fault (Paul Lai) [1380113]
- [x86] kvm: mtrr: remove MSR 0x2f8 (Paul Lai) [1380113] {CVE-2016-3713}
- [x86] kvm: page_track: fix access to NULL slot (Paul Lai) [1380113]
- [x86] kvm: mmu: apply page track notifier (Paul Lai) [1380113]
- [x86] kvm: mmu: simplify mmu_need_write_protect (Paul Lai) [1380113]
- [x86] kvm: mmu: use page track for non-leaf shadow pages (Paul Lai) [1380113]
- [x86] kvm: page track: add notifier support (Paul Lai) [1380113]
- [x86] kvm: mmu: clear write-flooding on the fast path of tracked page (Paul Lai) [1380113]
- [x86] kvm: mmu: let page fault handler be aware tracked page (Paul Lai) [1380113]
- [x86] kvm: page track: introduce kvm_slot_page_track_{add, remove}_page (Paul Lai) [1380113]
- [x86] kvm: page track: add the framework of guest page tracking (Paul Lai) [1380113]
- [x86] kvm: mmu: introduce kvm_mmu_slot_gfn_write_protect (Paul Lai) [1380113]
- [x86] kvm: mmu: introduce kvm_mmu_gfn_{allow, disallow}_lpage (Paul Lai) [1380113]
- [x86] kvm: mmu: rename has_wrprotected_page to mmu_gfn_lpage_is_disallowed (Paul Lai) [1380113]
- [x86] kvm: x86: mmu: Move handle_mmio_page_fault() call to kvm_mmu_page_fault() (Paul Lai) [1380113]
- [x86] kvm: x86: mmu: Consolidate quickly_check_mmio_pf() and is_mmio_page_fault() (Paul Lai) [1380113]
- [x86] kvm: mtrr: treat memory as writeback if MTRR is disabled in guest CPUID (Paul Lai) [1380113]
- [x86] kvm: mtrr: observe maxphyaddr from guest CPUID, not host (Paul Lai) [1380113]
- [x86] kvm: mtrr: fix fixed MTRR segment look up (Paul Lai) [1380113]
- [x86] kvm: x86: mmu: Encapsulate the type of rmap-chain head in a new struct (Paul Lai) [1380113]
- [x86] kvm: x86: mmu: Eliminate an extra memory slot search in mapping_level() (Paul Lai) [1380113]
- [x86] kvm: x86: mmu: Remove mapping_level_dirty_bitmap() (Paul Lai) [1380113]
- [x86] kvm: x86: mmu: Move mapping_level_dirty_bitmap() call in mapping_level() (Paul Lai) [1380113]
- [x86] kvm: x86: mmu: Simplify force_pt_level calculation code in FNAME(page_fault)() (Paul Lai) [1380113]
- [x86] kvm: x86: mmu: Make force_pt_level bool (Paul Lai) [1380113]
- [x86] kvm: mtrr: Use default type for non-MTRR-covered gfn before WARN_ON (Paul Lai) [1380113]
- [x86] kvm: mtrr: simplify kvm_mtrr_get_guest_memory_type (Paul Lai) [1380113]
- [x86] kvm: mtrr: fix memory type handling if MTRR is completely disabled (Paul Lai) [1380113]
- [x86] kvm: mtrr: do not map huge page for non-consistent range (Paul Lai) [1380113]
- [x86] kvm: mtrr: simplify kvm_mtrr_get_guest_memory_type (Paul Lai) [1380113]
- [x86] kvm: mtrr: introduce mtrr_for_each_mem_type (Paul Lai) [1380113]
- [x86] kvm: mtrr: introduce fixed_mtrr_addr_* functions (Paul Lai) [1380113]
- [x86] kvm: mtrr: sort variable MTRRs (Paul Lai) [1380113]
- [x86] kvm: mtrr: introduce var_mtrr_range (Paul Lai) [1380113]
- [x86] kvm: mtrr: introduce fixed_mtrr_segment table (Paul Lai) [1380113]
- [x86] kvm: mtrr: improve kvm_mtrr_get_guest_memory_type (Paul Lai) [1380113]
- [x86] kvm: mtrr: do not split 64 bits MSR content (Paul Lai) [1380113]
- [x86] kvm: mtrr: clean up mtrr default type (Paul Lai) [1380113]
- [x86] kvm: mtrr: remove mtrr_state.have_fixed (Paul Lai) [1380113]
- [x86] kvm: mtrr: handle MSR_MTRRcap in kvm_mtrr_get_msr (Paul Lai) [1380113]
- [x86] kvm: x86: move MTRR related code to a separate file (Paul Lai) [1380113]

* Wed Mar 15 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-609.el7]
- [md] dm cache: significant rework to leverage dm-bio-prison-v2 (Mike Snitzer) [1430028]
- [md] dm bio prison v2: new interface for the bio prison (Mike Snitzer) [1430028]
- [md] dm: flush queued bios when process blocks to avoid deadlock (Mike Snitzer) [1430028]
- [md] dm stats: fix a leaked s->histogram_boundaries array (Mike Snitzer) [1430028]
- [md] dm space map metadata: constify dm_space_map structures (Mike Snitzer) [1430028]
- [md] dm cache metadata: use cursor api in blocks_are_clean_separate_dirty() (Mike Snitzer) [1430028]
- [md] dm persistent data: add cursor skip functions to the cursor APIs (Mike Snitzer) [1430028]
- [md] dm cache metadata: use dm_bitset_new() to create the dirty bitset in format 2 (Mike Snitzer) [1430028]
- [md] dm bitset: add dm_bitset_new() (Mike Snitzer) [1430028]
- [md] dm cache metadata: name the cache block that couldn't be loaded (Mike Snitzer) [1430028]
- [md] dm cache metadata: add "metadata2" feature (Mike Snitzer) [1430028]
- [md] dm cache metadata: use bitset cursor api to load discard bitset (Mike Snitzer) [1430028]
- [md] dm bitset: introduce cursor api (Mike Snitzer) [1430028]
- [md] dm btree: use GFP_NOFS in dm_btree_del() (Mike Snitzer) [1430028]
- [md] dm space map common: memcpy the disk root to ensure it's arch aligned (Mike Snitzer) [1430028]
- [md] dm block manager: add unlikely() annotations on dm_bufio error paths (Mike Snitzer) [1430028]
- [md] dm cache: fix corruption seen when using cache > 2TB (Mike Snitzer) [1430028]
- [md] dm raid: bump the target version (Mike Snitzer) [1430028]
- [md] dm raid: fix data corruption on reshape request (Mike Snitzer) [1430028]
- [md] dm raid: fix raid "check" regression due to improper cleanup in raid_message() (Mike Snitzer) [1430028]
- [md] dm raid: cleanup awkward branching in raid_message() option processing (Mike Snitzer) [1430028]
- [md] dm raid: use mddev rather than rdev->mddev (Mike Snitzer) [1430028]
- [md] dm raid: use read_disk_sb() throughout (Mike Snitzer) [1430028]
- [md] dm raid: add raid4/5/6 journaling support (Mike Snitzer) [1430028]
- [md] dm raid: be prepared to accept arbitrary '- -' tuples (Mike Snitzer) [1430028]
- [md] dm raid: fix transient device failure processing (Mike Snitzer) [1430028]
- [md] dm mpath: cleanup -Wbool-operation warning in choose_pgpath() (Mike Snitzer) [1430028]
- [powerpc] pseries: Advertise HPT resizing support via CAS (David Gibson) [1305399]
- [kernel] rh_kabi: Provide better error messages for size and align checks (Prarit Bhargava) [1425864]
- [kernel] sched: Move p->nr_cpus_allowed check to select_task_rq() (Lauro Ramos Venancio) [1428028]
- [char] random: printk notifications for urandom pool initialization (Herbert Xu) [1298643]
- [acpi] acpica: utilities: Fix local printf issue (Prarit Bhargava) [1430397]
- [block] relax check on sg gap (Cathy Avery) [1413656]
- [block] check virt boundary in bio_will_gap() (Cathy Avery) [1413656]
- [block] Check for gaps on front and back merges (Cathy Avery) [1413656]
- [block] blk-mq: Avoid memory reclaim when remapping queues (Gustavo Duarte) [1356663]
- [block] block: kmemleak: Track the page allocations for struct request (Gustavo Duarte) [1356663]
- [block] blk-mq: Fix failed allocation path when mapping queues (Gustavo Duarte) [1356663]
- [block] blk-mq: Always schedule hctx->next_cpu (Gustavo Duarte) [1356663]
- [block] fix use-after-free in seq file (Denys Vlasenko) [1418551] {CVE-2016-7910}
- [netdrv] ixgbe: Update driver version for RHEL 7.4 (Ken Cox) [1383524]
- [netdrv] libcxgb: fix error check for ip6_route_output() (Sai Vemuri) [1385866]
- [netdrv] libcxgb: remove unused including <linux/version.h> (Sai Vemuri) [1385866]
- [target] libcxgb: export ppm release and tagmask set api (Sai Vemuri) [1385866]
- [scsi] libcxgbi: return error if interface is not up (Sai Vemuri) [1385866]
- [scsi] cxgb4i: libcxgbi: add missing module_put() (Sai Vemuri) [1385866]
- [scsi] cxgb4i: Add a missing call to neigh_release (Sai Vemuri) [1385866]
- [scsi] libcxgbi: fix incorrect DDP resource cleanup (Sai Vemuri) [1385866]
- [scsi] cxgb4i: Set completion bit in work request (Sai Vemuri) [1385866]
- [scsi] cxgb3i, cxgb4i: fix symbol not declared sparse warning (Sai Vemuri) [1385866]
- [scsi] cxgb3i: add iSCSI DDP support (Sai Vemuri) [1385866]
- [scsi] cxgb4i,libcxgbi: add iSCSI DDP support (Sai Vemuri) [1385866]
- [scsi] cxgb3i, cxgb4i, libcxgbi: remove iSCSI DDP support (Sai Vemuri) [1385866]
- [iscsi] iscsi-target: fix iscsi cmd leak (Sai Vemuri) [1429179]
- [iscsi] target/iscsi: Fix unsolicited data seq_end_offset calculation (Sai Vemuri) [1429179]
- [iscsi] target/cxgbit: add T6 iSCSI DDP completion feature (Sai Vemuri) [1429179]
- [iscsi] target/cxgbit: Enable DDP for T6 only if data sequence and pdu are in order (Sai Vemuri) [1429179]
- [iscsi] target/cxgbit: Use T6 specific macros to get ETH/IP hdr len (Sai Vemuri) [1429179]
- [iscsi] target/cxgbit: use cxgb4_tp_smt_idx() to get smt idx (Sai Vemuri) [1429179]
- [iscsi] target/iscsi: split iscsit_check_dataout_hdr() (Sai Vemuri) [1429179]
- [iscsi] target/cxgbit: Use T6 specific macro to set the force bit (Sai Vemuri) [1429179]
- [iscsi] target/cxgbit: Fix endianness annotations (Sai Vemuri) [1429179]
- [netdrv] cxgb4: Implement ndo_get_phys_port_id for mgmt dev (Sai Vemuri) [1138664]
- [netdrv] cxgb4: Initialize mbox lock and list for mgmt dev (Sai Vemuri) [1138664]
- [netdrv] cxgb4: Synchronize access to mailbox (Sai Vemuri) [1138664]
- [netdrv] cxgb4: Add port description for new cards (Sai Vemuri) [1416916]
- [netdrv] cxgb4/cxgb4vf: Display 25G and 100G link speed (Sai Vemuri) [1416916]
- [infiniband] iw_cxgb4: set correct FetchBurstMax for QPs (Sai Vemuri) [1416910]

* Wed Mar 15 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-608.el7]
- [char] tpm: Only call pm_runtime_get_sync if device has a parent (Jerry Snitselaar) [1402539]
- [char] tmp/tpm_crb: implement runtime pm for tpm_crb (Jerry Snitselaar) [1402539]
- [char] tpm/tpm_crb: open code the crb_init into acpi_add (Jerry Snitselaar) [1402539]
- [char] tmp/tpm_crb: fix Intel PTT hw bug during idle state (Jerry Snitselaar) [1402539]
- [char] tpm/tpm_crb: implement tpm crb idle state (Jerry Snitselaar) [1402539]
- [char] tpm_tis: fix the error handling of init_tis() (Jerry Snitselaar) [1383554]
- [char] tpm: remove invalid min length check from tpm_do_selftest() (Jerry Snitselaar) [1383554]
- [char] tpm: add check for minimum buffer size in tpm_transmit() (Jerry Snitselaar) [1383554]
- [char] tpm: constify TPM 1.x header structures (Jerry Snitselaar) [1383554]
- [char] tpm/tpm_crb: fix the over 80 characters checkpatch warring (Jerry Snitselaar) [1383554]
- [char] tpm/tpm_crb: drop useless cpu_to_le32 when writing to registers (Jerry Snitselaar) [1383554]
- [char] tpm/tpm_crb: cache cmd_size register value (Jerry Snitselaar) [1383554]
- [char] tmp/tpm_crb: drop include to platform_device (Jerry Snitselaar) [1383554]
- [char] tpm/tpm_tis: remove unused itpm variable (Jerry Snitselaar) [1383554]
- [char] tpm_crb: fix incorrect values of cmdReady and goIdle bits (Jerry Snitselaar) [1383554]
- [char] tpm_crb: refine the naming of constants (Jerry Snitselaar) [1383554]
- [char] tpm_crb: remove wmb()'s (Jerry Snitselaar) [1383554]
- [char] tpm_crb: fix crb_req_canceled behavior (Jerry Snitselaar) [1383554]
- [char] tpm: use tpm_pcr_read_dev() in tpm_do_selftest() (Jerry Snitselaar) [1383554]
- [char] tpm: use tpm_transmit_cmd() in tpm2_probe() (Jerry Snitselaar) [1383554]
- [char] tpm: replace tpm_gen_interrupt() with tpm_tis_gen_interrupt() (Jerry Snitselaar) [1383554]
- [char] tpm: remove unnecessary externs from tpm.h (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24: Remove useless tpm_gen_interrupt (Jerry Snitselaar) [1383554]
- [char] tpm: fix a race condition in tpm2_unseal_trusted() (Jerry Snitselaar) [1383554]
- [char] tpm: invalid self test error message (Jerry Snitselaar) [1383554]
- [char] tpm: Add TPM 2.0 support to the Nuvoton i2c driver (NPCT6xx family) (Jerry Snitselaar) [1383554]
- [char] tpm: Factor out common startup code (Jerry Snitselaar) [1383554]
- [char] tpm: use devm_add_action_or_reset (Jerry Snitselaar) [1383554]
- [char] tpm2_i2c_nuvoton: add irq validity check (Jerry Snitselaar) [1383554]
- [char] tpm: read burstcount from TPM_STS in one 32-bit transaction (Jerry Snitselaar) [1383554]
- [char] tpm: fix byte-order for the value read by tpm2_get_tpm_pt (Jerry Snitselaar) [1383554]
- [char] tpm_tis_core: convert max timeouts from msec to jiffies (Jerry Snitselaar) [1383554]
- [char] tpm_crb: fix address space of the return pointer in crb_map_res() (Jerry Snitselaar) [1383554]
- [char] tpm_vtpm_proxy: fix address space of a user pointer in vtpmx_fops_ioctl() (Jerry Snitselaar) [1383554]
- [char] tpm/tpm_tis_spi: Add support for spi phy (Jerry Snitselaar) [1383554]
- [char] tpm/tpm_tis: Split tpm_tis driver into a core and TCG TIS compliant phy (Jerry Snitselaar) [1383554]
- [char] tpm_tis: Introduce intermediate layer for TPM access (Jerry Snitselaar) [1383554]
- [char] tpm: tpm_tis: Share common data between phys (Jerry Snitselaar) [1383554]
- [char] tpm: Add include guards in tpm.h (Jerry Snitselaar) [1383554]
- [char] tpm: Fix suspend regression (Jerry Snitselaar) [1383554]
- [char] tpm: fix for typo in tpm/tpm_ibmvtpm.c (Jerry Snitselaar) [1383554]
- [char] tpm: select ANON_INODES for proxy driver (Jerry Snitselaar) [1383554]
- [char] tpm: Fix IRQ unwind ordering in TIS (Jerry Snitselaar) [1383554]
- [char] tpm: Proxy driver for supporting multiple emulated TPMs (Jerry Snitselaar) [1383554]
- [char] tpm: Introduce TPM_CHIP_FLAG_VIRTUAL (Jerry Snitselaar) [1383554]
- [char] tpm: Remove all uses of drvdata from the TPM Core (Jerry Snitselaar) [1383554]
- [char] tpm: Remove useless priv field in struct tpm_vendor_specific (Jerry Snitselaar) [1383554]
- [char] tpm: Move tpm_vendor_specific data related with PTP specification to tpm_chip (Jerry Snitselaar) [1383554]
- [char] tpm: drop 'locality' from struct tpm_vendor_specific (Jerry Snitselaar) [1383554]
- [char] tpm: drop 'read_queue' from struct tpm_vendor_specific (Jerry Snitselaar) [1383554]
- [char] tpm: drop 'irq' from struct tpm_vendor_specific (Jerry Snitselaar) [1383554]
- [char] tpm: drop 'iobase' from struct tpm_vendor_specific (Jerry Snitselaar) [1383554]
- [char] tpm: drop list from struct tpm_vendor_specific (Jerry Snitselaar) [1383554]
- [char] tpm: drop the field 'time_expired' from struct tpm_chip (Jerry Snitselaar) [1383554]
- [char] tpm: drop 'base' from struct tpm_vendor_specific (Jerry Snitselaar) [1383554]
- [char] tpm: drop manufacturer_id from struct tpm_vendor_specific (Jerry Snitselaar) [1383554]
- [char] tpm: drop tpm_atmel specific fields from tpm_vendor_specific (Jerry Snitselaar) [1383554]
- [char] tpm: drop int_queue from tpm_vendor_specific (Jerry Snitselaar) [1383554]
- [char] tpm: check for TPM_CHIP_FLAG_TPM2 before calling tpm2_shutdown() (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24: Remove unneeded tpm_reg in get_burstcount (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/spi: Drop two useless checks in ACPI probe path (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/i2c: Drop two useless checks in ACPI probe path (Jerry Snitselaar) [1383554]
- [char] tpm: fix crash in tpm_tis deinitialization (Jerry Snitselaar) [1383554]
- [char] tpm: cleanup tpm_tis_remove() (Jerry Snitselaar) [1383554]
- [char] tpm: fix tpm_bios_log_setup stub prototype (Jerry Snitselaar) [1383554]
- [char] tpm: Replace device number bitmap with IDR (Jerry Snitselaar) [1383554]
- [char] tpm: Split out the devm stuff from tpmm_chip_alloc (Jerry Snitselaar) [1383554]
- [char] tpm: Get rid of module locking (Jerry Snitselaar) [1383554]
- [char] tpm: Provide strong locking for device removal (Jerry Snitselaar) [1383554]
- [char] tpm: Get rid of devname (Jerry Snitselaar) [1383554]
- [char] tpm: Get rid of chip->pdev (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/spi: Change xxx_request_resources header (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/i2c: Change xxx_request_resources header (Jerry Snitselaar) [1383554]
- [char] tpm: st33zp24: Add support for acpi probing for spi device (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24: Add support for acpi probing for i2c device (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24: Extend Copyright headers (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/spi: Improve st33zp24_spi_evaluate_latency (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24: Auto-select core module (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24: Remove unneeded CONFIG_OF switches (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/spi: Remove field spi_xfer from st33zp24_spi_phy structure (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/spi: Remove useless use of memcpy (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/spi: Use functions name with st33zp24_spi_ prefix (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/spi: Remove nbr_dummy_bytes variable usage (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/spi: Add missing device table for spi phy (Jerry Snitselaar) [1383554]
- [char] tpm/st33zp24/spi: Add st33zp24 spi phy (Jerry Snitselaar) [1383554]

* Wed Mar 15 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-607.el7]
- [net] sched: respect rcu grace period on cls destruction (Ivan Vecera) [1420506]
- [net] sched: cls_cgroup tear down exts and ematch from rcu callback (Ivan Vecera) [1420506]
- [net] sched: act_mirred: fix a race condition on mirred_list (Ivan Vecera) [1420506]
- [net] sched: cls_flow: fix panic on filter replace (Ivan Vecera) [1420506]
- [net] sched: cls_bpf: fix panic on filter replace (Ivan Vecera) [1420506]
- [net] sched: fix call_rcu() race on classifier module unloads (Ivan Vecera) [1420506]
- [net] sched: fix struct tc_u_hnode layout in u32 (Ivan Vecera) [1420506]
- [net] sched: fix suspicious rcu_dereference_check in net/sched/sch_fq_codel.c (Ivan Vecera) [1420506]
- [net] sched: fix another regression in cls_tcindex (Ivan Vecera) [1420506]
- [net] sched: cls_cgroup need tcf_exts_init in all cases (Ivan Vecera) [1420506]
- [net] sched: cls_u32: fix unsued cpu variable (Ivan Vecera) [1420506]
- [net] sched: cls_fw: add missing tcf_exts_init call in fw_change() (Ivan Vecera) [1420506]
- [net] sched: fix a null pointer dereference in tcindex_set_parms() (Ivan Vecera) [1420506]
- [net] sched: fix memory leak in cls_tcindex (Ivan Vecera) [1420506]
- [net] sched: use tcindex_filter_result_init() (Ivan Vecera) [1420506]
- [net] sched: fix suspicious RCU usage in tcindex_classify() (Ivan Vecera) [1420506]
- [net] sched: fix an allocation bug in tcindex_set_parms() (Ivan Vecera) [1420506]
- [net] sched: fix suspicious RCU usage in cls_bpf_classify() (Ivan Vecera) [1420506]
- [net] sched: suspicious RCU usage in qdisc_watchdog (Ivan Vecera) [1420506]
- [net] sched: cls_cgroup fix possible memory leak of 'new' (Ivan Vecera) [1420506]
- [net] sched: fix error return code in fw_change_attrs() (Ivan Vecera) [1420506]
- [net] sched: rcu'ify cls_bpf (Ivan Vecera) [1420506]
- [net] sched: rcu'ify cls_rsvp (Ivan Vecera) [1420506]
- [net] sched: make cls_u32 lockless (Ivan Vecera) [1420506]
- [net] sched: avoid generating same handle for u32 filters (Ivan Vecera) [1420506]
- [net] sched: change "foo* bar" to "foo *bar" (Ivan Vecera) [1420506]
- [net] sched: make cls_u32 per cpu (Ivan Vecera) [1420506]
- [net] sched: RCU cls_tcindex (Ivan Vecera) [1420506]
- [net] sched: RCU cls_route (Ivan Vecera) [1420506]
- [net] sched: fw use RCU (Ivan Vecera) [1420506]
- [net] sched: cls_flow use RCU (Ivan Vecera) [1420506]
- [net] sched: cls_cgroup use RCU (Ivan Vecera) [1420506]
- [net] sched: cls_basic use RCU (Ivan Vecera) [1420506]
- [net] sched: rcu-ify tcf_proto (Ivan Vecera) [1420506]
- [net] sched: qdisc: use rcu prefix and silence sparse warnings (Ivan Vecera) [1420506]
- [net] sched: use no more than one page in struct fw_head (Ivan Vecera) [1420506]
- [net] sched: optimize tcf_match_indev() (Ivan Vecera) [1420506]
- [net] sched: add struct net pointer to tcf_proto_ops->dump (Ivan Vecera) [1420506]
- [net] sched: Fix dumping of non-existing actions' stats (Ivan Vecera) [1420506]
- [net] sched: copy exts->type in tcf_exts_change() (Ivan Vecera) [1420506]
- [net] sched: fix an oops in tcindex filter (Ivan Vecera) [1420506]
- [net] sched: act: allow to clear all actions as well (Ivan Vecera) [1420506]
- [net] sched: cls: check if we could overwrite actions when changing a filter (Ivan Vecera) [1420506]
- [net] sched: sch_htb: let skb->priority refer to non-leaf class (Ivan Vecera) [1420506]
- [net] sched: avoid casting void pointer (Ivan Vecera) [1420506]
- [net] sched: fix regression in tc_action_ops (Ivan Vecera) [1420506]
- [net] sched: fix a regression in tcf_proto_lookup_ops() (Ivan Vecera) [1420506]
- [net] sched: fix a regression in tc actions (Ivan Vecera) [1420506]
- [net] sched: convert tcf_proto_ops to use struct list_head (Ivan Vecera) [1420506]
- [net] sched: convert tc_action_ops to use struct list_head (Ivan Vecera) [1420506]
- [net] sched: convert tcf_hashinfo to hlist and use spinlock (Ivan Vecera) [1420506]
- [net] sched: init struct tcf_hashinfo at register time (Ivan Vecera) [1420506]
- [net] sched: cls: refactor out struct tcf_ext_map (Ivan Vecera) [1420506]
- [net] sched: act: use standard struct list_head (Ivan Vecera) [1420506]
- [net] sched: remove get_stats from tc_action_ops (Ivan Vecera) [1420506]
- [net] sched: Use default action walker methods (Ivan Vecera) [1420506]
- [net] sched: Provide default walker function for actions (Ivan Vecera) [1420506]
- [net] sched: Use default action lookup functions (Ivan Vecera) [1420506]
- [net] sched: Default action lookup method for actions (Ivan Vecera) [1420506]
- [net] sched: Fail if missing mandatory action operation methods (Ivan Vecera) [1420506]

* Tue Mar 14 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-606.el7]
- [misc] mei: bus: enable OS version only for SPT and newer (Jerry Snitselaar) [1404064]
- [misc] mei: send OS type to the FW (Jerry Snitselaar) [1404064]
- [misc] mei: enable to set the internal flag for client write (Jerry Snitselaar) [1404064]
- [watchdog] mei_wdt: use module_mei_cl_driver macro (Jerry Snitselaar) [1404064]
- [kernel] mei: bus: add module_mei_cl_driver helper macro (Jerry Snitselaar) [1404064]
- [nfc] mei: bus: fix received data size check in NFC fixup (Jerry Snitselaar) [1404064]
- [misc] mei: bus: demote error to debug level upon disconnect (Jerry Snitselaar) [1404064]
- [misc] mei: show the HBM protocol versions in the device attributes (Jerry Snitselaar) [1404064]
- [documentation] mei: add ABI documentation for fw_status exported through sysfs (Jerry Snitselaar) [1404064]
- [documentation] mei: sysfs: add Documentation mei class attributes (Jerry Snitselaar) [1404064]
- [misc] mei: txe: don't clean an unprocessed interrupt cause (Jerry Snitselaar) [1404064]
- [misc] mei: stop the stall timer worker if not needed (Jerry Snitselaar) [1404064]
- [misc] mei: me: add kaby point device ids (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: fix deadlock in initialization during a reset (Jerry Snitselaar) [1404064]
- [misc] mei: drop unused file transaction states (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: drop mei_amthif_read (Jerry Snitselaar) [1404064]
- [misc] mei: enqueue consecutive reads (Jerry Snitselaar) [1404064]
- [misc] mei: add wrapper for queuing control commands (Jerry Snitselaar) [1404064]
- [misc] mei: use consistent naming for TX control flow credits (Jerry Snitselaar) [1404064]
- [misc] mei: rx flow control counter (Jerry Snitselaar) [1404064]
- [misc] mei: prepare read cb for fixed address clients on the receive path only (Jerry Snitselaar) [1404064]
- [misc] mei: drop redundant krealloc and checks in irq read (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: drop mei_clear_lists function (Jerry Snitselaar) [1404064]
- [misc] mei: add read callback on demand for fixed_address clients (Jerry Snitselaar) [1404064]
- [misc] mei: add file pointer to the host client structure (Jerry Snitselaar) [1404064]
- [misc] mei: move read cb to complete queue if not connected (Jerry Snitselaar) [1404064]
- [misc] mei: fix return value on disconnection (Jerry Snitselaar) [1404064]
- [misc] mei: drop read complete queue emptiness check (Jerry Snitselaar) [1404064]
- [misc] mei: hbm: add missing argument in the kdoc (Jerry Snitselaar) [1404064]
- [misc] mei: recover after errors in runtime pm flow (Jerry Snitselaar) [1404064]
- [misc] mei: drop mei_io_cb_alloc_buf (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: use mei_cl_alloc_cb for allocating cbs (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: drop mei_amthif_send_cmd (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: enable poll for async events (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: drop iamthif_current_cb (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: fix request cancel (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: drop READ_COMPLETE state (Jerry Snitselaar) [1404064]
- [misc] mei: don't use wake_up_interruptible for wr_ctrl (Jerry Snitselaar) [1404064]
- [misc] mei: drop wr_msg from the mei_dev structure (Jerry Snitselaar) [1404064]
- [misc] mei: bus: call mei_cl_read_start under device lock (Jerry Snitselaar) [1404064]
- [misc] mei: fix waiting for wr_ctrl for corner cases (Jerry Snitselaar) [1404064]
- [misc] mei: don't clean control queues on notify request timeout (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: discard not read messages (Jerry Snitselaar) [1404064]
- [misc] mei: fix NULL dereferencing during FW initiated disconnection (Jerry Snitselaar) [1404064]
- [misc] mei: drop global me_client_index (Jerry Snitselaar) [1404064]
- [misc] mei: do not pin module if cldrv->probe() failed (Jerry Snitselaar) [1404064]
- [misc] mei: bus: use scnprintf in *_show (Jerry Snitselaar) [1404064]
- [misc] mei: me: add broxton pci device ids (Jerry Snitselaar) [1404064]
- [misc] mei: fix format string in debug prints (Jerry Snitselaar) [1404064]
- [misc] mei: fix double freeing of a cb during link reset (Jerry Snitselaar) [1404064]
- [misc] mei: split amthif client init from end of clients enumeration (Jerry Snitselaar) [1404064]
- [misc] mei: hbm: send immediate reply flag in enum request (Jerry Snitselaar) [1404064]
- [misc] mei: bus: run rescan on me_clients list change (Jerry Snitselaar) [1404064]
- [misc] mei: drop reserved host client ids (Jerry Snitselaar) [1404064]
- [misc] mei: hbm: warn about fw-initiated disconnect (Jerry Snitselaar) [1404064]
- [misc] mei: fixed address clients for the new platforms (Jerry Snitselaar) [1404064]
- [misc] mei: fill file pointer in read cb for fixed address client (Jerry Snitselaar) [1404064]
- [misc] mei: discard replies from unconnected fixed address clients (Jerry Snitselaar) [1404064]
- [misc] mei: clean write queues and wake waiters on disconnect (Jerry Snitselaar) [1404064]
- [misc] mei: wake blocked write on link reset (Jerry Snitselaar) [1404064]
- [misc] mei: drop superfluous closing bracket from write traces (Jerry Snitselaar) [1404064]
- [misc] mei: bus: check if the device is enabled before data transfer (Jerry Snitselaar) [1404064]
- [misc] mei: bus: fix notification event delivery (Jerry Snitselaar) [1404064]
- [misc] mei: bus: fix RX event scheduling (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: interrupt reader on link reset (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: use rx_wait queue also for amthif client (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: drop parameter validation from mei_amthif_write (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: replace amthif_rd_complete_list with rd_completed (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: allow only one request at a time (Jerry Snitselaar) [1404064]
- [misc] mei: rename variable names 'file_object' to fp (Jerry Snitselaar) [1404064]
- [misc] mei: constify struct file pointer (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: don't drop read packets on timeout (Jerry Snitselaar) [1404064]
- [misc] mei: amthif: don't copy from an empty buffer (Jerry Snitselaar) [1404064]
- [misc] mei: call stop on failed char device register (Jerry Snitselaar) [1404064]
- [misc] mei: fix possible integer overflow issue (Jerry Snitselaar) [1404064]
- [misc] mei: debugfs: allow hbm features list dump in earlier stages (Jerry Snitselaar) [1404064]
- [misc] mei: debugfs: adjust active clients print buffer (Jerry Snitselaar) [1404064]
- [misc] mei: trace pci configuration space io (Jerry Snitselaar) [1404064]
- [misc] mei: bus: whitelist the watchdog client (Jerry Snitselaar) [1404064]
- [watchdog] mei_wdt: re-register device on event (Jerry Snitselaar) [1404064]
- [watchdog] mei_wdt: add activation debugfs entry (Jerry Snitselaar) [1404064]
- [watchdog] mei_wdt: register wd device only if required (Jerry Snitselaar) [1404064]
- [watchdog] mei_wdt: add status debugfs entry (Jerry Snitselaar) [1404064]
- [watchdog] mei_wdt: implement MEI iAMT watchdog driver (Jerry Snitselaar) [1404064]
- [kernel] mei: bus: complete variable rename of type struct mei_cl_device (Jerry Snitselaar) [1404064]
- [kernel] mei: fixup function prototypes in mei_cl_bus.h (Jerry Snitselaar) [1404064]
- [misc] mei: wd: drop the watchdog code from the core mei driver (Jerry Snitselaar) [1404064]
- [misc] mei: drop nfc leftovers from the mei driver (Jerry Snitselaar) [1404064]
- [misc] mei: always copy the read buffer if data is ready (Jerry Snitselaar) [1404064]
- [misc] mei: prevent queuing new flow control credit (Jerry Snitselaar) [1404064]
- [misc] mei: bus: remove redundant uuid string in debug messages (Jerry Snitselaar) [1404064]
- [kernel] debugfs: Export bool read/write functions (Jerry Snitselaar) [1404064]

* Tue Mar 14 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-605.el7]
- [infiniband] ib: Query ports via the core instead of direct into the driver (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Set maj_err and min_err in i40iw_sc_cqp_create (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: fix some indenting in i40iw_sc_vsi_init() (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] rdma/i40iw: use designated initializers (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Set 128B as the only supported RQ WQE size (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Reorganize structures to align with HW capabilities (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Fix incorrect check for error (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Assign MSS only when it is a new MTU (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Fix race condition in terminate timer's handler (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Fix memory leak in CQP destroy when in reset (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Fix QP flush to not hang on empty queues or failure (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Fix double free of QP (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Use correct src address in memcpy to rdma stats counters (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Remove macros I40IW_STAG_KEY_FROM_STAG and I40IW_STAG_INDEX_FROM_STAG (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Add request for reset on CQP timeout (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Code cleanup, remove check of PBLE pages (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Correctly fail loopback connection if no listener (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Fill in IRD value when on connect request (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Set TOS field in IP header (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Add NULL check for ibqp event handler (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Replace list_for_each_entry macro with safe version (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Add IP addr handling on netdev events (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Add missing cleanup on device close (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Add 2MB page support (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Utilize physically mapped memory regions (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Fix incorrect assignment of SQ head (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Remove variable flush_code and check to set qp->sq_flush (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Remove check on return from device_init_pestat() (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Use runtime check for IS_ENABLED(CONFIG_IPV6) (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Use actual page size (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Remove NULL check for cm_node->iwdev (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Remove checks for more than 48 bytes inline data (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Query device accounts for internal rsrc (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Optimize inline data copy (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Fix for LAN handler removal (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Correct values for max_recv_sge, max_send_sge (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Use vector when creating CQs (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Convert page_size to encoded value (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Set MAX IRD, MAX ORD size to max supported value (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Remove workaround for pre-production errata (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Enable message packing (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw: Add Quality of Service support (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] ib/i40iw: Remove debug prints after allocation failure (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw_cm: Remove deprecated create_singlethread_workqueue (Stefan Assmann) [1381753 1381749 1381740]
- [infiniband] i40iw_main: Remove deprecated create_singlethread_workqueue (Stefan Assmann) [1381753 1381749 1381740]
- [netdrv] enic: add vxlan offload on tx path (Stefan Assmann) [1388239]
- [netdrv] enic: add udp_tunnel ndo for vxlan offload (Stefan Assmann) [1388239]
- [netdrv] enic: add devcmds for vxlan offload (Stefan Assmann) [1388239]
- [netdrv] enic: Remove local ndo_busy_poll() implementation (Stefan Assmann) [1388239]
- [netdrv] generalize napi_complete_done() (Stefan Assmann) [1388239]
- [netdrv] enic: set skb->hash type properly (Stefan Assmann) [1388239]
- [netdrv] enic: fix rq disable (Stefan Assmann) [1388239]
- [netdrv] enic: use correct type specifier (Stefan Assmann) [1388239]
- [netdrv] enic: move to new ethtool api {get|set}_link_ksettings (Stefan Assmann) [1388239]
- [netdrv] enic: add support for set/get rss hash key (Stefan Assmann) [1388239]
- [netdrv] enic: use netdev_rss_key_fill() helper (Stefan Assmann) [1388239]
- [netdrv] enic: remove #ifdef CONFIG_RFS_ACCEL around filter structures (Stefan Assmann) [1388239]
- [netdrv] enic: Add Accelerated RFS support (Stefan Assmann) [1388239]
- [netdrv] enic: Add tunable_ops support for rx_copybreak (Stefan Assmann) [1388239]
- [netdrv] enic: use pci_zalloc_consistent (Stefan Assmann) [1388239]
- [netdrv] enic: use spin_lock(wq_lock) instead of spin_lock_irqsave(wq_lock) (Stefan Assmann) [1388239]
- [netdrv] enic: support skb->xmit_more (Stefan Assmann) [1388239]
- [netdrv] enic: use napi_schedule_irqoff() (Stefan Assmann) [1388239]

* Tue Mar 14 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-604.el7]
- [netdrv] i40e: mark the value passed to csum_replace_by_diff as __wsum (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Fix TSO checksum pseudo-header adjustment (Stefan Assmann) [1383523]
- [netdrv] i40e: refactor AQ CMD buffer debug printing (Stefan Assmann) [1383523]
- [netdrv] i40e: Fix Adaptive ITR enabling (Stefan Assmann) [1383523]
- [netdrv] i40evf: add comment (Stefan Assmann) [1383523]
- [netdrv] i40evf: free rings in remove function (Stefan Assmann) [1383523]
- [netdrv] i40e: Save link FEC info from link up event (Stefan Assmann) [1383523]
- [netdrv] i40e: Add bus number info to i40e_bus_info struct (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf : Changed version from 1.6.25 to 1.6.27 (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: eliminate i40e_pull_tail() (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Moves skb from i40e_rx_buffer to i40e_ring (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Limit DMA sync of RX buffers to actual packet size (Stefan Assmann) [1383523]
- [netdrv] i40evf: track outstanding client request (Stefan Assmann) [1383523]
- [netdrv] i40e: Remove FPK HyperV VF device ID (Stefan Assmann) [1383523]
- [netdrv] i40e: Quick refactor to start moving data off stack and into Tx buffer info (Stefan Assmann) [1383523]
- [netdrv] i40evf: remove unused device ID (Stefan Assmann) [1383523]
- [netdrv] i40e: Deprecating unused macro (Stefan Assmann) [1383523]
- [netdrv] i40e: Add functions which apply correct PHY access method for read and write operation (Stefan Assmann) [1383523]
- [netdrv] i40e: Add FEC for 25g (Stefan Assmann) [1383523]
- [netdrv] i40e: Add support for 25G devices (Stefan Assmann) [1383523]
- [netdrv] Changed version from 1.6.21 to 1.6.25 (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: napi_poll must return the work done (Stefan Assmann) [1383523]
- [netdrv] i40e: simplify txd use count calculation (Stefan Assmann) [1383523]
- [netdrv] i40evf: protect against NULL msix_entries and q_vectors pointers (Stefan Assmann) [1383523]
- [netdrv] i40evf: check for msix_entries null dereference (Stefan Assmann) [1383523]
- [netdrv] i40evf: Move some i40evf_reset_task code to separate function (Stefan Assmann) [1383523]
- [netdrv] i40e: Add protocols over MCTP to i40e_aq_discover_capabilities (Stefan Assmann) [1383523]
- [netdrv] i40evf: Be much more verbose about what we can and cannot offload (Stefan Assmann) [1383523]
- [netdrv] i40e: Implementation of ERROR state for NVM update state machine (Stefan Assmann) [1383523]
- [netdrv] i40e: Reorder logic for coalescing RS bits (Stefan Assmann) [1383523]
- [netdrv] i40evf: avoid an extra msleep while (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Changed version from 1.6.19 to 1.6.21 (Stefan Assmann) [1383523]
- [netdrv] i40e: Drop redundant Rx descriptor processing code (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Changed version from 1.6.16 to 1.6.19 (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: fix interrupt affinity bug (Stefan Assmann) [1383523]
- [netdrv] i40e: group base mode VF offload flags (Stefan Assmann) [1383523]
- [netdrv] i40evf: support queue-specific settings for interrupt moderation (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Add txring_txq function to match fm10k and ixgbe (Stefan Assmann) [1383523]
- [netdrv] i40e: Fix Flow Director raw_buf cleanup (Stefan Assmann) [1383523]
- [netdrv] i40evf: enable adaptive interrupt throttling (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Changed version to 1.6.16 (Stefan Assmann) [1383523]
- [netdrv] i40e: add encap csum VF offload flag (Stefan Assmann) [1383523]
- [netdrv] i40evf: remove unnecessary error checking against i40e_shutdown_adminq (Stefan Assmann) [1383523]
- [netdrv] i40e: Limit TX descriptor count in cases where frag size is greater than 16K (Stefan Assmann) [1383523]
- [netdrv] i40evf: remove unnecessary error checking against i40evf_up_complete (Stefan Assmann) [1383523]
- [netdrv] i40evf: Fix link state event handling (Stefan Assmann) [1383523]
- [netdrv] i40e: avoid potential null pointer dereference when assigning len (Stefan Assmann) [1383523]
- [netdrv] i40evf: Open RDMA Client after reset (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Fix indentation (Stefan Assmann) [1383523]
- [netdrv] i40e: Add support for HMC resource and profile for X722 (Stefan Assmann) [1383523]
- [netdrv] i40e: Fix byte ordering in ARP NS code for X722 (Stefan Assmann) [1383523]
- [netdrv] i40e: refactor tail_bump check (Stefan Assmann) [1383523]
- [netdrv] i40evf: report link speed (Stefan Assmann) [1383523]
- [netdrv] i40e: use alloc_workqueue instead of create_singlethread_workqueue (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf-Bump version from 1.6.11 to 1.6.12 (Stefan Assmann) [1383523]
- [netdrv] i40evf: add missing rtnl_lock() around i40evf_set_interrupt_capability (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf-bump version to 1.6.11 (Stefan Assmann) [1383523]
- [netdrv] i40evf: add hyperv dev ids (Stefan Assmann) [1383523]
- [netdrv] i40e: Remove device ID 0x37D4 (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: remove useless initializer (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Fix i40e_rx_checksum (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Bump version from 1.5.16 to 1.6.4 (Stefan Assmann) [1383523]
- [netdrv] i40evf: always activate correct MAC address filter (Stefan Assmann) [1383523]
- [netdrv] i40evf: don't overflow buffer (Stefan Assmann) [1383523]
- [netdrv] i40e: Add allmulti support for the VF (Stefan Assmann) [1383523]
- [netdrv] i40evf: Allocate Rx buffers properly (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Remove unused hardware receive descriptor code (Stefan Assmann) [1383523]
- [netdrv] i40evf: refactor receive routine (Stefan Assmann) [1383523]
- [netdrv] i40evf: Drop packet split receive routine (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Remove reference to ring->dtype (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Refactor tunnel interpretation (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: Add support for GSO partial with UDP_TUNNEL_CSUM and GRE_CSUM (Stefan Assmann) [1383523]
- [netdrv] i40evf: make use of BIT() macro to avoid signed left shift (Stefan Assmann) [1383523]
- [netdrv] i40e/i40evf: fix I40E_MASK signed shift overflow warnings (Stefan Assmann) [1383523]

* Mon Mar 13 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-603.el7]
- [infiniband] rdma/qedr: Return success when not changing QP state (Don Dutile) [1414913 1417285]
- [net] xprtrdma: Shrink send SGEs array (Don Dutile) [1416849 1417285]
- [net] xprtrdma: Reduce required number of send SGEs (Don Dutile) [1416849 1417285]
- [net] xprtrdma: Disable pad optimization by default (Don Dutile) [1416849 1417285]
- [net] xprtrdma: Per-connection pad optimization (Don Dutile) [1416849 1417285]
- [net] xprtrdma: Fix Read chunk padding (Don Dutile) [1416849 1417285]
- [netdrv] mlx5: Fix Kconfig help text (Don Dutile) [1385330 1417285]
- [netdrv] cxgb4/cxgb4vf: Assign netdev->dev_port with port ID (Don Dutile) [1385866 1417285]
- [netdrv] mlx5e: Change the SQ/RQ operational state to positive logic (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Don't flush SQ on error (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Don't notify HW when filling the edge of ICO SQ (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Fix query ISSI flow (Don Dutile) [1238192 1385330 1417285]
- [netdrv] mlx5: Remove duplicate pci dev name print (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Verify module parameters (Don Dutile) [1385330 1417285]
- [net] rds: tcp: unregister_netdevice_notifier() in error path of rds_tcp_init_net (Don Dutile) [1417285]
- [netdrv] cxgb4: Add PCI device ID for new adapter (Don Dutile) [1385866 1417285]
- [netdrv] mlx4: Fix uninitialized fields in rule when adding promiscuous mode to device managed flow steering (Don Dutile) [1385329 1417285]
- [kernel] revert "net/mlx4_en: Avoid unregister_netdev at shutdown flow" (Don Dutile) [1385329 1417285]
- [netdrv] mlx5: drop duplicate header delay.h (Don Dutile) [1385330 1417285]
- [netdrv] mlx4_en: Free netdev resources under state lock (Don Dutile) [1385329 1417285]
- [infiniband] iw_cxgb4: invalidate the mr when posting a read_w_inv wr (Don Dutile) [1385866 1417285]
- [infiniband] ib/rxe: Update qp state for user query (Don Dutile) [1384574 1417285]
- [infiniband] ib/rxe: Clear queue buffer when modifying QP to reset (Don Dutile) [1384574 1417285]
- [infiniband] ib/rxe: Fix handling of erroneous WR (Don Dutile) [1384574 1417285]
- [infiniband] ib/rxe: Fix kernel panic in UDP tunnel with GRO and RX checksum (Don Dutile) [1384574 1417285]
- [infiniband] ib/mlx4: Fix create CQ error flow (Don Dutile) [1385329 1417285]
- [infiniband] ib/mlx4: Check gid_index return value (Don Dutile) [1385329 1417285]
- [infiniband] ib/mlx5: Fix NULL pointer dereference on debug print (Don Dutile) [1385330 1417285]
- [infiniband] ib/mlx5: Fix fatal error dispatching (Don Dutile) [1385330 1417285]
- [infiniband] ib/mlx5: Resolve soft lock on massive reg MRs (Don Dutile) [1385330 1417285]
- [infiniband] ib/mlx5: Use cache line size to select CQE stride (Don Dutile) [1385330 1417285]
- [infiniband] ib/mlx5: Validate requested RQT size (Don Dutile) [1385330 1417285]
- [infiniband] ib/mlx5: Fix memory leak in query device (Don Dutile) [1385330 1417285]
- [infiniband] ib/core: Avoid unsigned int overflow in sg_alloc_table (Don Dutile) [1417285]
- [infiniband] ib/core: Add missing check for addr_resolve callback return value (Don Dutile) [1417285]
- [infiniband] ib/core: Set routable RoCE gid type for ipv4/ipv6 networks (Don Dutile) [1417285]
- [infiniband] ib/cm: Mark stale CM id's whenever the mad agent was unregistered (Don Dutile) [1417285]
- [infiniband] ib/uverbs: Fix leak of XRC target QPs (Don Dutile) [1417285]
- [netdrv] cxgb4: do not call napi_hash_del() (Don Dutile) [1385866 1417285]
- [infiniband] ib/hfi1: Remove incorrect IS_ERR check (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Prevent hardware counter names from being cut off (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Fix ECN processing in prescan_rxq (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Fix status error code for unsupported packets (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Relocate rcvhdrcnt module parameter check (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Fix rnr_timer addition (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Delete unused lock (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Clean up unused argument (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Remove leftover snoop references (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Fix a potential memory leak in hfi1_create_ctxts() (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Return ENODEV for unsupported PCI device ids (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Fix an Oops on pci device force remove (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Fix integrity check flags default values (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Remove redundant sysfs irq affinity entry (Don Dutile) [1382806 1417285]
- [infiniband] ib/rdmavt: rdmavt can handle non aligned page maps (Don Dutile) [1385848 1417285]
- [infiniband] shut up a maybe-uninitialized warning (Don Dutile) [1417285]
- [net] xprtrdma: Fix DMAR failure in frwr_op_map() after reconnect (Don Dutile) [1417285]
- [netdrv] mlx5: Fix invalid pointer reference when prof_sel parameter is invalid (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: E-Switch, Set the actions for offloaded rules properly (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Disallow changing name-space for VF representors (Don Dutile) [1385330 1417285]
- [netdrv] cxgb4: correct device ID of T6 adapter (Don Dutile) [1385866 1417285]
- [net] svcrdma: backchannel cannot share a page for send and rcv buffers (Don Dutile) [1417285]
- [netdrv] mlx5: Simplify a test (Don Dutile) [1385330 1417285]
- [netdrv] mlx4_en: Save slave ethtool stats command (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_en: Fix potential deadlock in port statistics flow (Don Dutile) [1385329 1417285]
- [kernel] mlx4: Fix firmware command timeout during interrupt test (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_core: Do not access comm channel if it has not yet been initialized (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_en: Process all completions in RX rings after port goes up (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_en: Resolve dividing by zero in 32-bit system (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_core: Change the default value of enable_qos (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_core: Avoid setting ports to auto when only one port type is supported (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_core: Fix the resource-type enum in res tracker to conform to FW spec (Don Dutile) [1385329 1417285]
- [net] rds: debug messages are enabled by default (Don Dutile) [1417285]
- [netdrv] cxgb4: Fix error handling in alloc_uld_rxqs() (Don Dutile) [1385866 1417285]
- [netdrv] ib/mlx4: avoid a -Wmaybe-uninitialize warning (Don Dutile) [1385329 1417285]
- [netdrv] mlx5: Avoid passing dma address 0 to firmware (Don Dutile) [1385330 1417285]
- [kernel] mlx5: PCI error recovery health care simulation (Don Dutile) [1385330 1417285]
- [kernel] mlx5: Fix race between PCI error handlers and health work (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Clear health sick bit when starting health poll (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Change the acl enable prototype to return status (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Unregister netdev before detaching it (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Choose best nearest LRO timeout (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Correctly initialize last use of flow counters (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Fix autogroups groups num not decreasing (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Keep autogroups list ordered (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Always Query HCA caps after setting them (Don Dutile) [1385330 1417285]
- [kernel] {net, ib}/mlx5: Make cache line size determination at runtime (Don Dutile) [1385330 1417285]
- [net] sunrpc: fix some missing rq_rbuffer assignments (Don Dutile) [1275823 1417285]
- [netdrv] cxgb4: Fix number of queue sets corssing the limit (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: fix memory leak of qe on error exit path (Don Dutile) [1385866 1417285]
- [infiniband] qedr: Add events support and register IB device (Don Dutile) [1275823 1417285]
- [infiniband] qedr: Add GSI support (Don Dutile) [1275823 1417285]
- [infiniband] qedr: Add LL2 RoCE interface (Don Dutile) [1275823 1417285]
- [infiniband] qedr: Add support for data path (Don Dutile) [1275823 1417285]
- [infiniband] qedr: Add support for memory registeration verbs (Don Dutile) [1275823 1417285]
- [uapi] qedr: Add support for QP verbs (Don Dutile) [1275823 1417285]
- [uapi] qedr: Add support for PD,PKEY and CQ verbs (Don Dutile) [1275823 1417285]
- [uapi] qedr: Add support for user context verbs (Don Dutile) [1275823 1417285]
- [infiniband] qedr: Add support for RoCE HW init (Don Dutile) [1275823 1417285]
- [uapi] qedr: Add RoCE driver framework (Don Dutile) [1275823 1417285]
- [kernel] mlx5: Add MLX5_ARRAY_SET64 to fix BUILD_BUG_ON (Don Dutile) [1385330 1417285]
- [netdrv] iw_cxgb4: add fast-path for small REG_MR operations (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: advertise support for FR_NSMR_TPTE_WR (Don Dutile) [1385866 1417285]
- [infiniband] ib/core: correctly handle rdma_rw_init_mrs() failure (Don Dutile) [1417285]
- [infiniband] ib/srp: Fix infinite loop when FMR sg[0].offset != 0 (Don Dutile) [1417285]
- [infiniband] ib/srp: Remove an unused argument (Don Dutile) [1417285]
- [infiniband] ib/core: Improve ib_map_mr_sg() documentation (Don Dutile) [1417285]
- [kernel] ib/mlx4: Fix possible vl/sl field mismatch in LRH header in QP1 packets (Don Dutile) [1385329 1417285]
- [uapi] ib/mthca: Move user vendor structures (Don Dutile) [1417285]
- [uapi] ib/nes: Move user vendor structures (Don Dutile) [1417285]
- [uapi] ib/ocrdma: Move user vendor structures (Don Dutile) [1385876 1417285]
- [uapi] ib/mlx4: Move user vendor structures (Don Dutile) [1385329 1417285]
- [uapi] ib/cxgb4: Move user vendor structures (Don Dutile) [1385866 1417285]
- [uapi] ib/cxgb3: Move user vendor structures (Don Dutile) [1417285]
- [uapi] ib/mlx5: Move and decouple user vendor structures (Don Dutile) [1385330 1417285]
- [rdma] ib/{core,hw}: Add constant for node_desc (Don Dutile) [1417285]
- [infiniband] ipoib: Make ipoib_warn ratelimited (Don Dutile) [1417285]
- [infiniband] ib/mlx4/alias_guid: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/ipoib_verbs: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/ipoib: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/nes: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/mlx4/mcg: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/mlx4/mad: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/mlx4: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/mlx5/odp: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/mlx5: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/mthca: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] iw_cxgb4: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/qib: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] iw_cxgb3: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/iwcm: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/addr: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/cma: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/ucma: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/multicast: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/mad: Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/sa : Remove deprecated create_singlethread_workqueue (Don Dutile) [1417285]
- [infiniband] ib/mlx5: LAG QP load balancing (Don Dutile) [1385219 1385330 1417285]
- [infiniband] ib/mlx5: Set unique device name on LAG (Don Dutile) [1385219 1385330 1417285]
- [infiniband] ib/mlx5: Port status track LAG master, when LAG is active (Don Dutile) [1385219 1385330 1417285]
- [infiniband] ib/mlx5: Merge vports flow steering during LAG (Don Dutile) [1385219 1385330 1417285]
- [infiniband] ib/mlx5: Port events in RoCE now rely on netdev events (Don Dutile) [1385330 1417285]
- [infiniband] ib/mlx5: Track asynchronous events on a receive work queue (Don Dutile) [1385330 1417285]
- [infiniband] ib/mlx5: Add support of more IPv6 fields to flow steering (Don Dutile) [1385308 1385330 1417285]
- [infiniband] ib/mlx5: Add support in TOS and protocol to flow steering (Don Dutile) [1385308 1385330 1417285]
- [uapi] ib/core: Add more fields to IPv6 flow specification (Don Dutile) [1385308 1385330 1417285]
- [uapi] ib/uverbs: Add more fields to IPv4 flow specification (Don Dutile) [1385308 1385330 1417285]
- [rdma] ib/uverbs: Add support to extend flow steering specifications (Don Dutile) [1385308 1385330 1417285]
- [infiniband] ib/mlx5: Add validation to flow specifications parsing (Don Dutile) [1385308 1385330 1417285]
- [infiniband] ib/mlx4: Add validation to flow specifications parsing (Don Dutile) [1385308 1385330 1417285]
- [infiniband] ib/mlx5: Add sniffer support to steering (Don Dutile) [1385256 1385330 1417285]
- [infiniband] ib/mlx5: Increase flow table reference count in create rule (Don Dutile) [1385256 1385330 1417285]
- [infiniband] ib/mlx5: Fix coverity warning (Don Dutile) [1385256 1385330 1417285]
- [infiniband] ib/mlx5: Save flow table priority handler instead of index (Don Dutile) [1385256 1385330 1417285]
- [infiniband] ib/mlx5: Fix steering resource leak (Don Dutile) [1385256 1385330 1417285]
- [infiniband] ib/mlx5: Add port counter support for raw packet QP (Don Dutile) [1385307 1385330 1417285]
- [infiniband] ib/mlx5: Refactor raw packet QP modify function (Don Dutile) [1385307 1385330 1417285]
- [infiniband] ib/mlx5: Expose RSS related capabilities (Don Dutile) [1385330 1417285]
- [uapi] ib/uverbs: Expose RSS related capabilities (Don Dutile) [1417285]
- [rdma] ib/core: Expose RSS related capabilities (Don Dutile) [1417285]
- [infiniband] ib/rxe: improved debug prints & code cleanup (Don Dutile) [1384574 1417285]
- [infiniband] rdma_rxe: Ensure rdma_rxe init occurs at correct time (Don Dutile) [1384574 1417285]
- [infiniband] ib/rxe: Properly honor max IRD value for rd/atomic (Don Dutile) [1384574 1417285]
- [rdma] ib/{rxe, core, rdmavt}: Fix kernel crash for reg MR (Don Dutile) [1385848 1384574 1417285]
- [infiniband] ib/rdmavt: Trivial function comment corrected (Don Dutile) [1385848 1417285]
- [netdrv] cxgb4: unexport cxgb4_dcb_enabled (Don Dutile) [1385866 1417285]
- [infiniband] ib/hfi1: Fix trace of atomic ack (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Update SMA ingress checks for response packets (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Use EPROM platform configuration read (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Add ability to read platform config from the EPROM (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Restore EPROM read ability (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Add new debugfs sdma_cpu_list file (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Add irq affinity notification handler (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Add a new VL sysfs attribute for sdma engines (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Add sysfs interface for affinity setup (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Fix resource release in context allocation (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Remove unused variable from devdata (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Cleanup tasklet refs in comments (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Adjust hardware buffering parameter (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Act on external device timeout (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Fix defered ack race with qp destroy (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Combine shift copy and byte copy for SGE reads (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Do not read more than a SGE length (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Extend i2c timeout (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Increase default settings of max_cqes and max_qps (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Remove filtering of Set(PkeyTable) in HFI SMA (Don Dutile) [1382806 1417285]
- [infiniband] ib/qib: Remove qpt_mask global (Don Dutile) [1381986 1417285]
- [infiniband] ib/hfi1: Consolidate pio control masks into single definition (Don Dutile) [1382806 1417285]
- [infiniband] ib/rdmavt, ib/hfi1: Add lockdep asserts for lock debug (Don Dutile) [1385848 1417285]
- [infiniband] ib/rdmavt: Add qp init function (Don Dutile) [1385848 1417285]
- [infiniband] ib/rdmavt: Move reset calldown to reset path (Don Dutile) [1385848 1417285]
- [infiniband] ib/hfi1: Move iowait_init() to priv allocate (Don Dutile) [1382806 1417285]
- [infiniband] ib/rdmavt: Correct sparse annotation (Don Dutile) [1385848 1417285]
- [infiniband] ib/hfi1: Fix locking scheme for affinity settings (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Fix user-space buffers mapping with IOMMU enabled (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Fix the count of user packets submitted to an SDMA engine (Don Dutile) [1382806 1417285]
- [infiniband] ib/hfi1: Move serdes tune inside link start function (Don Dutile) [1382806 1417285]
- [infiniband] ib/qib,ib/hfi: Use core common header file (Don Dutile) [1382806 1417285]
- [rdma] ib/core: Add ib headers for general use (Don Dutile) [1417285]
- [netdrv] mlx5: Add ndo_poll_controller() implementation (Don Dutile) [1385330 1417285]
- [netdrv] mlx4: remove unused fields (Don Dutile) [1385329 1417285]
- [netdrv] cxgb4: mark symbols static where possible (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: fix -ve error check on a signed iq (Don Dutile) [1385866 1417285]
- [kernel] mlx4: Add VF vlan protocol 802.1ad support (Don Dutile) [1386553 1385329 1417285]
- [netdrv] mlx4_en: Disable vlan HW acceleration when in VF vlan protocol 802.1ad mode (Don Dutile) [1386553 1385329 1417285]
- [kernel] mlx4_core: Preparation for VF vlan protocol 802.1ad (Don Dutile) [1386553 1385329 1417285]
- [netdrv] mlx4_core: Fix QUERY FUNC CAP flags (Don Dutile) [1386553 1385329 1417285]
- [rdma] ib/core: remove ib_get_dma_mr (Don Dutile) [1417285]
- [infiniband] ib/srp: use IB_PD_UNSAFE_GLOBAL_RKEY (Don Dutile) [1417285]
- [infiniband] ib/iser: use IB_PD_UNSAFE_GLOBAL_RKEY (Don Dutile) [1417285]
- [net] ib/core: add support to create a unsafe global rkey to ib_create_pd (Don Dutile) [1417285]
- [rdma] ib/core: rename pd->local_mr to pd->__internal_mr (Don Dutile) [1417285]
- [net] svcrdma: support Remote Invalidation (Don Dutile) [1417285]
- [net] svcrdma: Server-side support for rpcrdma_connect_private (Don Dutile) [1417285]
- [net] svcrdma: Skip put_page() when send_reply() fails (Don Dutile) [1417285]
- [net] svcrdma: Tail iovec leaves an orphaned DMA mapping (Don Dutile) [1417285]
- [net] xprtrdma: use complete() instead complete_all() (Don Dutile) [1417285]
- [netdrv] cxgb4: fix signed wrap around when decrementing index idx (Don Dutile) [1385866 1417285]
- [netdrv] mlx5: E-Switch, Support VLAN actions in the offloads mode (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Refactor retrival of skb from rx completion element (cqe) (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Put elements related to offloaded TC rule in one struct (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: E-Switch, Allow fine tuning of eswitch vport push/pop vlan (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: E-Switch, Set vport representor fields explicitly on registration (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: E-Switch, Set the vport when registering the uplink rep (Don Dutile) [1385330 1417285]
- [netdrv] cxgb4: Convert to use simple_open() (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Have a clear separation between different SQ types (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Dynamic RQ type infrastructure (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Slightly reduce hardware LRO size (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Union RQ RX info per RQ type (Don Dutile) [1385330 1417285]
- [netdrv] mlx5e: Build RX SKB on demand (Don Dutile) [1385330 1417285]
- [kernel] ptp_clock: future-proofing drivers against PTP subsystem becoming optional (Don Dutile) [1417285]
- [netdrv] cxgb4: add parser to translate u32 filters to internal spec (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: add common api support for configuring filters (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: move common filter code to separate file (Don Dutile) [1385866 1417285]
- [netdrv] mlx4_core: Fix deadlock when switching between polling and event fw commands (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_core: Use RCU to perform radix tree lookup for SRQ (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_en: Fix wrong indentation (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_en: Add branch prediction hints in RX data-path (Don Dutile) [1385329 1417285]
- [netdrv] mlx4_en: add page recycle to prepare rx ring for tx support (Don Dutile) [1385329 1417285]
- [netdrv] mlx5: clean function declarations in eswitch.c up (Don Dutile) [1385330 1417285]
- [net] xprtrdma: Eliminate rpcrdma_receive_worker() (Don Dutile) [1417285]
- [net] xprtrdma: Rename rpcrdma_receive_wc() (Don Dutile) [1417285]
- [net] xprtrmda: Report address of frmr, not mw (Don Dutile) [1417285]
- [net] xprtrdma: Support larger inline thresholds (Don Dutile) [1417285]
- [net] xprtrdma: Use gathered Send for large inline messages (Don Dutile) [1417285]
- [net] xprtrdma: Basic support for Remote Invalidation (Don Dutile) [1417285]
- [net] xprtrdma: Client-side support for rpcrdma_connect_private (Don Dutile) [1417285]
- [kernel] rpcrdma: RDMA/CM private message data structure (Don Dutile) [1417285]
- [net] xprtrdma: Move recv_wr to struct rpcrdma_rep (Don Dutile) [1417285]
- [net] xprtrdma: Move send_wr to struct rpcrdma_req (Don Dutile) [1417285]
- [net] xprtrdma: Simplify rpcrdma_ep_post_recv() (Don Dutile) [1417285]
- [net] xprtrdma: Eliminate "ia" argument in rpcrdma_{alloc, free}_regbuf (Don Dutile) [1417285]
- [net] xprtrdma: Delay DMA mapping Send and Receive buffers (Don Dutile) [1417285]
- [net] xprtrdma: Replace DMA_BIDIRECTIONAL (Don Dutile) [1417285]
- [net] xprtrdma: Use smaller buffers for RPC-over-RDMA headers (Don Dutile) [1417285]
- [net] xprtrdma: Initialize separate RPC call and reply buffers (Don Dutile) [1417285]
- [net] sunrpc: Add a transport-specific private field in rpc_rqst (Don Dutile) [1417285]
- [net] sunrpc: Separate buffer pointers for RPC Call and Reply messages (Don Dutile) [1417285]
- [net] sunrpc: Generalize the RPC buffer release API (Don Dutile) [1417285]
- [net] sunrpc: Generalize the RPC buffer allocation API (Don Dutile) [1417285]
- [net] sunrpc: Refactor rpc_xdr_buf_init() (Don Dutile) [1417285]
- [net] xprtrdma: Eliminate INLINE_THRESHOLD macros (Don Dutile) [1417285]
- [netdrv] cxgb4: Fix return value check in cfg_queues_uld() (Don Dutile) [1385866 1417285]
- [crypto] chcr - Fix memory corruption (Don Dutile) [1385866 1417285]
- [target] chcr/cxgb4i/cxgbit/rdma/cxgb4: Allocate resources dynamically for all cxgb4 ULD's (Don Dutile) [1385866 1417285]
- [crypto] chcr: Fix non static symbol warning (Don Dutile) [1385866 1417285]
- [crypto] Added Chelsio Menu to the Kconfig file (Don Dutile) [1385866 1417285]
- [crypto] chcr: Support for Chelsio's Crypto Hardware (Don Dutile) [1385866 1417285]
- [netdrv] mlx5e: Implement RX mapped page cache for page recycle (Don Dutile) [1385310 1385330 1417285]
- [netdrv] mlx5e: Introduce API for RX mapped pages (Don Dutile) [1385310 1385330 1417285]
- [netdrv] mlx5e: Single flow order-0 pages for Striding RQ (Don Dutile) [1385310 1385330 1417285]
- [infiniband] ib/rdmavt, ib/qib, ib/hfi1: Use new QP put get routines (Don Dutile) [1381986 1382806 1385848 1417285]
- [rdma] ib/rdmavt: Add functions to get and release QP references (Don Dutile) [1385848 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_mk_rx_data_ack() (Don Dutile) [1385866 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_mk_abort_rpl() (Don Dutile) [1385866 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_mk_abort_req() (Don Dutile) [1385866 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_mk_close_con_req() (Don Dutile) [1385866 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_mk_tid_release() (Don Dutile) [1385866 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_compute_wscale() (Don Dutile) [1385866 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_best_mtu() (Don Dutile) [1385866 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_is_neg_adv() (Don Dutile) [1385866 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_find_route6() (Don Dutile) [1385866 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_find_route() (Don Dutile) [1385866 1417285]
- [target] libcxgb, iw_cxgb4, cxgbit: add cxgb_get_4tuple() (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4vf: don't offload Rx checksums for IPv6 fragments (Don Dutile) [1385866 1417285]
- [netdrv] mlx5: Organize device list API in one place (Don Dutile) [1385214 1385330 1417285]
- [netdrv] mlx5e: Restore vlan filter after seamless reset (Don Dutile) [1385214 1385330 1417285]
- [netdrv] mlx5e: Implement mlx5e interface attach/detach callbacks (Don Dutile) [1385214 1385330 1417285]
- [netdrv] mlx5: Implement vports admin state backup/restore (Don Dutile) [1385214 1385330 1417285]
- [netdrv] mlx5: Align sriov/eswitch modules with the new load/unload flow (Don Dutile) [1385214 1385330 1417285]
- [netdrv] mlx5: Implement eswitch attach/detach flows (Don Dutile) [1385214 1385330 1417285]
- [netdrv] mlx5: Implement SRIOV attach/detach flows (Don Dutile) [1385214 1385330 1417285]
- [netdrv] mlx5: Split the load/unload flow into hardware and software flows (Don Dutile) [1385214 1385330 1417285]
- [kernel] mlx5: Introduce attach/detach to interface API (Don Dutile) [1385214 1385330 1417285]
- [kernel] mlx5: SRIOV core code refactoring (Don Dutile) [1385214 1385330 1417285]
- [netdrv] mlx5: Skip waiting for vf pages in internal error (Don Dutile) [1385214 1385330 1417285]
- [netdrv] cxgb4: Add support for ndo_get_vf_config (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4/cxgb4vf: fix spelling mistake "provissioned" -> "provisioned" (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: Remove unused including <linux/version.h> (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: add support for tx max rate limiting (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: add support for per queue tx scheduling (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: add support for tx traffic scheduling classes (Don Dutile) [1385866 1417285]
- [netdrv] mlx5/core: Use memdup_user() rather than duplicating its implementation (Don Dutile) [1385330 1417285]
- [netdrv] cxgb4: Simplify the return expression (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: Register changes and fw defines for crypto (Don Dutile) [1385866 1417285]
- [netdrv] cxgb4: Add support for dynamic allocation of resources for ULD (Don Dutile) [1385866 1417285]
- [kernel] mlx5: Add sniffer namespaces (Don Dutile) [1385256 1385330 1417285]
- [kernel] mlx5: Introduce sniffer steering hardware capabilities (Don Dutile) [1385256 1385330 1417285]
- [netdrv] mlx5: Configure IB devices according to LAG state (Don Dutile) [1385219 1385330 1417285]
- [kernel] mlx5: Vport LAG creation support (Don Dutile) [1385219 1385330 1417285]
- [kernel] mlx5: Add LAG flow steering namespace (Don Dutile) [1385219 1385330 1417285]
- [kernel] mlx5: LAG demux flow table support (Don Dutile) [1385219 1385330 1417285]
- [netdrv] mlx5: LAG and SRIOV cannot be used together (Don Dutile) [1385219 1385330 1417285]
- [netdrv] mlx5e: Avoid port remapping of mlx5e netdev TISes (Don Dutile) [1385219 1385330 1417285]
- [kernel] mlx5: Get RoCE netdev (Don Dutile) [1385219 1385330 1417285]
- [kernel] mlx5: Implement RoCE LAG feature (Don Dutile) [1385219 1385330 1417285]
- [kernel] mlx5: Add HW interfaces used by LAG (Don Dutile) [1385219 1385330 1417285]
- [kernel] mlx5: Separate query_port_proto_oper for IB and EN (Don Dutile) [1385330 1417285]
- [kernel] mlx5: Expose mlx5e_link_mode (Don Dutile) [1385330 1417285]
- [kernel] mlx5: Update struct mlx5_ifc_xrqc_bits (Don Dutile) [1385330 1417285]
- [kernel] mlx5: Modify RQ bitmask from mlx5 ifc (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Introduce alloc_encap and dealloc_encap commands (Don Dutile) [1385330 1417285]
- [kernel] mlx5: Update mlx5_ifc.h for vxlan encap/decap (Don Dutile) [1385330 1417285]
- [kernel] mlx5: Enable setting minimum inline header mode for VFs (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Improve driver log messages (Don Dutile) [1385330 1417285]
- [kernel] mlx5: Unify and improve command interface (Don Dutile) [1385330 1417285]
- [kernel] {net, ib}/mlx5: Modify QP commands via mlx5 ifc (Don Dutile) [1385330 1417285]
- [kernel] {net, ib}/mlx5: QP/XRCD commands via mlx5 ifc (Don Dutile) [1385330 1417285]
- [kernel] {net, ib}/mlx5: MKey/PSV commands via mlx5 ifc (Don Dutile) [1385330 1417285]
- [kernel] {net,ib}/mlx5: CQ commands via mlx5 ifc (Don Dutile) [1385330 1417285]
- [kernel] mlx5: EQ commands via mlx5 ifc (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: Pages management commands via mlx5 ifc (Don Dutile) [1385330 1417285]
- [kernel] mlx5: MCG commands via mlx5 ifc (Don Dutile) [1385330 1417285]
- [netdrv] mlx5: PD and UAR commands via mlx5 ifc (Don Dutile) [1385330 1417285]
- [kernel] mlx5: Access register and MAD IFC commands via mlx5 ifc (Don Dutile) [1385330 1417285]
- [kernel] mlx5: Init/Teardown hca commands via mlx5 ifc (Don Dutile) [1385330 1417285]
- [net] rds: add __printf format attribute to error reporting functions (Don Dutile) [1417285]

* Mon Mar 13 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-602.el7]
- [netdrv] qed: Conserve RDMA resources when !QEDR (Harish Patil) [1391272]
- [netdrv] qed: Support Multicast on Tx-switching (Harish Patil) [1391272]
- [netdrv] qed*: RSS indirection based on queue-handles (Harish Patil) [1391272]
- [netdrv] qede: Remove unnecessary datapath dereference (Harish Patil) [1391272]
- [netdrv] qede - mark SKB as encapsulated (Harish Patil) [1391272]
- [netdrv] qede: Postpone reallocation until NAPI end (Harish Patil) [1391272]
- [netdrv] qed*: Change maximal number of queues (Harish Patil) [1391272]
- [netdrv] qede: Split filtering logic to its own file (Harish Patil) [1391272]
- [netdrv] qede: Break datapath logic into its own file (Harish Patil) [1391272]
- [netdrv] qed*: Update to dual-license (Harish Patil) [1391272]
- [netdrv] qed*: Advance driver versions to 8.10.10.20 (Harish Patil) [1391272]
- [netdrv] qed: fix old-style function definition (Harish Patil) [1391272]
- [netdrv] qede: fix general protection fault may occur on probe (Harish Patil) [1391272]
- [netdrv] qede: use reset to set network header (Harish Patil) [1391272]
- [netdrv] qed: Add iSCSI out of order packet handling (Harish Patil) [1391272]
- [netdrv] qed: Add support for hardware offloaded iSCSI (Harish Patil) [1391272]
- [netdrv] qede: Better utilize the qede_[rt]x_queue (Harish Patil) [1391272]
- [netdrv] qede: Don't check netdevice for rx-hash (Harish Patil) [1391272]
- [netdrv] qed*: Handle-based L2-queues (Harish Patil) [1391272]
- [netdrv] qede: Revise state locking scheme (Harish Patil) [1391272]
- [netdrv] qede: Refactor data-path Rx flow (Harish Patil) [1391272]
- [netdrv] qede: Refactor statistics gathering (Harish Patil) [1391272]
- [netdrv] qede: Remove 'num_tc' (Harish Patil) [1391272]
- [netdrv] qed: Optimize qed_chain datapath usage (Harish Patil) [1391272]
- [netdrv] qede: Optimize aggregation information size (Harish Patil) [1391272]
- [netdrv] qed: Correct rdma params configuration (Harish Patil) [1391272]
- [netdrv] qed: configure ll2 RoCE v1/v2 flavor correctly (Harish Patil) [1391272]
- [netdrv] qed: Prevent stack corruption on MFW interaction (Harish Patil) [1391272]
- [netdrv] qede: Correctly map aggregation replacement pages (Harish Patil) [1391272]
- [netdrv] qed: Correct VF mac number (Harish Patil) [1391272]
- [netdrv] qede: Don't override priv_flags (Harish Patil) [1391272]
- [netdrv] qed: Learn resources from management firmware (Harish Patil) [1391272]
- [netdrv] qed: Use VF-queue feature (Harish Patil) [1391272]
- [netdrv] qed: Learn of RDMA capabilities per-device (Harish Patil) [1391272]
- [netdrv] qede: Decouple ethtool caps from qed (Harish Patil) [1391272]
- [netdrv] qed*: Add support for WoL (Harish Patil) [1391272]
- [netdrv] qed: Add nvram selftest (Harish Patil) [1391272]
- [netdrv] qed*: Management firmware - notifications and defaults (Harish Patil) [1391272]
- [netdrv] qede: Fix statistics' strings for Tx/Rx queues (Harish Patil) [1391272]
- [netdrv] qede: Fix out-of-bound fastpath memory access (Harish Patil) [1391272]
- [netdrv] qede: Fix incorrrect usage of APIs for un-mapping DMA memory (Harish Patil) [1391272]
- [netdrv] qed: Zero-out the buffer paased to dcbx_query() API (Harish Patil) [1391272]
- [netdrv] qede: Reconfigure rss indirection direction table when rss count is updated (Harish Patil) [1391272]
- [netdrv] qed*: Reduce the memory footprint for Rx path (Harish Patil) [1391272]
- [netdrv] qede: Loopback implementation should ignore the normal traffic (Harish Patil) [1391272]
- [netdrv] qede: get_channels() need to populate max tx/rx coalesce values (Harish Patil) [1391272]
- [netdrv] qed: Use list_move_tail instead of list_del/list_add_tail (Harish Patil) [1391272]
- [netdrv] qed: Remove useless set memory to zero use memset() (Harish Patil) [1391272]
- [netdrv] qed: Fix possible race when reading firmware return code (Harish Patil) [1391272]
- [netdrv] qed: Handle malicious VFs events (Harish Patil) [1391272]
- [netdrv] qed: Allow chance for fast ramrod completions (Harish Patil) [1391272]
- [netdrv] qed*: Allow unicast filtering (Harish Patil) [1391272]
- [netdrv] qede: Prevent GSO on long Geneve headers (Harish Patil) [1391272]
- [netdrv] qede: GSO support for tunnels with outer csum (Harish Patil) [1391272]
- [netdrv] qed: Pass MAC hints to VFs (Harish Patil) [1391272]
- [netdrv] qed: Additional work toward cleaning C=1 (Harish Patil) [1391272]
- [netdrv] qede: Do not allow RSS config for 100G devices (Harish Patil) [1391272]
- [netdrv] qed*: Fix Kconfig dependencies with INFINIBAND_QEDR (Harish Patil) [1391272]
- [netdrv] qed: Fix static checker warning (Harish Patil) [1391272]
- [netdrv] qed: fix old-style function definition (Harish Patil) [1391272]
- [netdrv] qed: Fix to use list_for_each_entry_safe() when delete items (Harish Patil) [1391272]
- [netdrv] qed: Add RoCE ll2 & GSI support (Harish Patil) [1391272]
- [netdrv] qed: Add support for memory registeration verbs (Harish Patil) [1391272]
- [netdrv] qed: Add support for QP verbs (Harish Patil) [1391272]
- [netdrv] qed: PD,PKEY and CQ verb support (Harish Patil) [1391272]
- [netdrv] qed: Add support for RoCE hw init (Harish Patil) [1391272]
- [netdrv] qede: Add qedr framework (Harish Patil) [1391272]
- [netdrv] qed: Add Light L2 support (Harish Patil) [1391272]
- [netdrv] qed: Fix stack corruption on probe (Harish Patil) [1391272]
- [netdrv] qed: mark symbols static where possible (Harish Patil) [1391272]
- [netdrv] qede: mark qede_set_features() static (Harish Patil) [1391272]
- [netdrv] qed*: Add support for the ethtool get_regs operation (Harish Patil) [1391272]
- [netdrv] qed: Add support for debug data collection (Harish Patil) [1391272]
- [netdrv] qed: add missing header dependencies (Harish Patil) [1391272]
- [netdrv] qed: Add infrastructure for debug data collection (Harish Patil) [1391272]
- [netdrv] qed: Remove OOM messages (Harish Patil) [1391272]
- [netdrv] qed: fix kzalloc-simple.cocci warnings (Harish Patil) [1391272]
- [netdrv] qed: Clear dcbx memory buffers before the usage (Harish Patil) [1391272]
- [netdrv] qed: Set selection-field while configuring the app entry in ieee mode (Harish Patil) [1391272]
- [netdrv] qed*: Disallow dcbx configuration for VF interfaces (Harish Patil) [1391272]
- [netdrv] qede: hide 32-bit compile warning (Harish Patil) [1391272]
- [netdrv] qede: Add support for Tx/Rx-only queues (Harish Patil) [1391272]
- [netdrv] qed: Fix address macros (Harish Patil) [1391272]
- [netdrv] qed: Change locking scheme for VF channel (Harish Patil) [1391272]
- [netdrv] qed*: Add support for VFs over legacy PFs (Harish Patil) [1391272]
- [netdrv] qed: Prevent VFs from pause flooding (Harish Patil) [1391272]
- [netdrv] qed: Add support for legacy VFs (Harish Patil) [1391272]
- [netdrv] qed: FLR of active VFs might lead to FW assert (Harish Patil) [1391272]
- [netdrv] qed: utilize FW 8.10.10.0 (Harish Patil) [1391272]
- [netdrv] qede: Fix forcing high speeds (Harish Patil) [1391272]
- [netdrv] qed*: Fix pause setting (Harish Patil) [1391272]
- [netdrv] qede: Fix Tx timeout due to xmit_more (Harish Patil) [1391272]
- [netdrv] qed: Add support for NCSI statistics (Harish Patil) [1391272]
- [netdrv] qede: Add support for per-queue stats (Harish Patil) [1391272]
- [netdrv] qede: Add support for capturing additional stats in ethtool-stats display (Harish Patil) [1391272]
- [netdrv] qed*: Add and modify some prints (Harish Patil) [1391272]
- [netdrv] qed*: Trivial modifications (Harish Patil) [1391272]
- [netdrv] qed*: Semantic changes (Harish Patil) [1391272]
- [netdrv] qed: Fix possible memory leak in qed_dcbnl_get_ieee_pfc() (Harish Patil) [1391272]
- [netdrv] qed*: Add support for ethtool link_ksettings callbacks (Harish Patil) [1391272]
- [netdrv] qed: Update app count when adding a new dcbx app entry to the table (Harish Patil) [1391272]
- [netdrv] qed: Add dcbx app support for IEEE Selection Field (Harish Patil) [1391272]
- [netdrv] qed: Use ieee mfw-mask to get ethtype in ieee-dcbx mode (Harish Patil) [1391272]
- [netdrv] qed: Remove the endian-ness conversion for pri_to_tc value (Harish Patil) [1391272]
- [netdrv] qed: Use DEFINE_SPINLOCK() for spinlock (Harish Patil) [1391272]
- [netdrv] qed: Fail driver load in 100g MSI mode (Harish Patil) [1391272]
- [netdrv] qed: Fix error return code in qed_resc_alloc() (Harish Patil) [1391272]
- [netdrv] qed: do not use unitialized variable (Harish Patil) [1391272]
- [netdrv] qed: Prevent over-usage of vlan credits by PF (Harish Patil) [1391272]
- [netdrv] qed: Correct min bandwidth for 100g (Harish Patil) [1391272]
- [netdrv] qede: Reset statistics on explicit down (Harish Patil) [1391272]
- [netdrv] qed: Don't over-do producer cleanup for Rx (Harish Patil) [1391272]
- [netdrv] qed: Fix removal of spoof checking for VFs (Harish Patil) [1391272]
- [netdrv] qede: Don't try removing unconfigured vlans (Harish Patil) [1391272]
- [netdrv] qed: Fix setting/clearing bit in completion bitmap (Harish Patil) [1391272]
- [netdrv] qede: Bump up driver version to 8.10.1.20 (Harish Patil) [1391272]
- [netdrv] qede: Add get/set rx copy break tunable support (Harish Patil) [1391272]
- [netdrv] qede: Utilize xmit_more (Harish Patil) [1391272]
- [netdrv] qede: qede_poll refactoring (Harish Patil) [1391272]
- [netdrv] qede: Add support for handling IP fragmented packets (Harish Patil) [1391272]
- [netdrv] qed: Protect the doorbell BAR with the write barriers (Harish Patil) [1391272]
- [netdrv] qede: Fix the static checker warnings (Harish Patil) [1391272]
- [netdrv] qed: Fix static checker warnings (Harish Patil) [1391272]
- [netdrv] qede: Add support for coalescing config read/update (Harish Patil) [1391272]
- [netdrv] qed: Add support for coalescing config read/update (Harish Patil) [1391272]
- [netdrv] qed: Add missing port-mode (Harish Patil) [1391272]
- [netdrv] qed: Fix returning unlimited SPQ entries (Harish Patil) [1391272]
- [netdrv] qed*: Don't reset statistics on inner reload (Harish Patil) [1391272]
- [netdrv] qed: Prevent VF from Tx-switching 'promisc' (Harish Patil) [1391272]
- [netdrv] qed: Correct default vlan behavior (Harish Patil) [1391272]
- [netdrv] qede: Add dcbnl support (Harish Patil) [1391272]
- [netdrv] qed: Add dcbnl support (Harish Patil) [1391272]
- [netdrv] qed: Add support for query/config dcbx (Harish Patil) [1391272]
- [netdrv] qed: potential overflow in qed_cxt_src_t2_alloc() (Harish Patil) [1391272]
- [netdrv] qed: PF to reply to unknown messages (Harish Patil) [1391272]
- [netdrv] qed: PF enforce MAC limitation of VFs (Harish Patil) [1391272]
- [netdrv] qed: Move doorbell calculation from VF to PF (Harish Patil) [1391272]
- [netdrv] qed: Make PF more robust against malicious VF (Harish Patil) [1391272]
- [netdrv] qed: PF-VF resource negotiation (Harish Patil) [1391272]
- [netdrv] qed: Relax VF firmware requirements (Harish Patil) [1391272]
- [netdrv] qed: Fix next-ptr chains for BE / 32-bit (Harish Patil) [1391272]
- [netdrv] qed: Initialize hardware for new protocols (Harish Patil) [1391272]
- [netdrv] qed: Add iscsi/rdma personalities (Harish Patil) [1391272]
- [netdrv] qed: Add common HSI for new protocols (Harish Patil) [1391272]
- [netdrv] qed: Revisit chain implementation (Harish Patil) [1391272]
- [netdrv] qed: fix qed_fill_link() error handling (Harish Patil) [1391272]
- [netdrv] qed: Don't config min BW on 100g on link flap (Harish Patil) [1391272]
- [netdrv] qed: Prevent 100g from working in MSI (Harish Patil) [1391272]
- [netdrv] qed: Add missing 100g init mode (Harish Patil) [1391272]
- [netdrv] qed: Save min/max accross dcbx-change (Harish Patil) [1391272]
- [netdrv] qed: Fix allocation in interrupt context (Harish Patil) [1391272]
- [netdrv] qede: Don't expose self-test for VFs (Harish Patil) [1391272]
- [netdrv] qede: Reload on GRO changes (Harish Patil) [1391272]
- [netdrv] qede: Fix VF minimum BW setting (Harish Patil) [1391272]
- [netdrv] qed/qede: update driver version to 8.7.1.43 (Harish Patil) [1372930]

* Mon Mar 13 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-601.el7]
- [scsi] qla2xxx: Update driver version to 8.07.00.38.07.4-k (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Fix scsi scan hang triggered if adapter fails during init (Chad Dupuis) [1384091]
- [scsi] qla2xxx: fix spelling mistake "retyring" -> "retrying" (Chad Dupuis) [1384091]
- [scsi] qla2xxx: small cleanup in qla2x00_wait_for_hba_ready() (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Fix BBCR offset (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Fix duplicate message id (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Separate ISP type bits out from device type (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Correction to function qla26xx_dport_diagnostics() (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Add support to handle Loop Init error Asynchronus event (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Let DPORT be enabled purely by nvram (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Add bsg interface to support statistics counter reset (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Add bsg interface to support D_Port Diagnostics (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Check for device state before unloading the driver (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Properly reset firmware statistics (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Make debug buffer log easier to view (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Add module parameter alternate/short names (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Set FLOGI retry in additional firmware options for P2P (N2N) mode (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Shutdown board on thermal shutdown aen (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Add ram area DDR for fwdump template entry T262 (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Remove sysfs node fw_dump_template (Chad Dupuis) [1384091]
- [scsi] qla2xxx: setup data needed in ISR before setting up the ISR (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Remove erroneous unused macro qla82xx_get_temp_val1() (Chad Dupuis) [1384091]
- [scsi] qla2xxx: Indicate out-of-memory with -ENOMEM (Chad Dupuis) [1384091]
- [scsi] be2iscsi: Reinit SGL handle, CID tables after TPE (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Use GFP_ATOMIC under spin lock (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Update driver version (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Add checks to validate CID alloc/free (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Remove wq_name from beiscsi_hba (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Remove unused struct members (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Remove redundant receive buffers posting (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix iSCSI cmd cleanup IOCTL (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Set WRB invalid bit for SkyHawk (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Take iscsi_task ref in abort handler (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix for crash in beiscsi_eh_device_reset (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix use of invalidate command table req (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: set errno on error path (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: set errno on error path (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: allocate enough memory in beiscsi_boot_get_sinfo() (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: mark symbols static where possible (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Replace _bh with _irqsave/irqrestore (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: _bh for io_sgl_lock and mgmt_sgl_lock (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Add missing unlock for mbox_lock (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Remove redundant iscsi_wrb desc memset (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix error return code (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Update the driver version (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Update copyright information (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix queue and connection parameters (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix async PDU handling path (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Add FUNCTION_RESET during driver unload (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fail the sessions immediately after TPE (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Add TPE recovery feature (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Add V1 of EPFW cleanup IOCTL (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix POST check and reset sequence (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Move functions to right files (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Add IOCTL to check UER supported (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix to add timer for UE detection (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix to make boot discovery non-blocking (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix checks for HBA in error state (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Remove isr_lock and dead code (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Remove alloc_mcc_tag & beiscsi_pci_soft_reset (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Check all zeroes IP before issuing IOCTL (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Handle only NET_PARAM in iface_get_param (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Rename iface get/set/create/destroy APIs (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Update iface handle before any set param (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Move VLAN code to common iface_set_param (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix release of DHCP IP in static mode (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix gateway APIs to support IPv4 & IPv6 (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Set and return right iface v4/v6 states (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Reduce driver load/unload time (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Replace _bh version for mcc_lock spinlock (Maurizio Lombardi) [1382263]
- [scsi] be2iscsi: Fix to use correct configuration values (Maurizio Lombardi) [1382263]
- [scsi] megaraid_sas: handle dma_addr_t right on 32-bit (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: array overflow in megasas_dump_frame() (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: driver version upgrade (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Change RAID_1_10_RMW_CMDS to RAID_1_PEER_CMDS and set value to 2 (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Indentation and smatch warning fixes (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Cleanup VD_EXT_DEBUG and SPAN_DEBUG related debug prints (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Increase internal command pool (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Use synchronize_irq to wait for IRQs to complete (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Bail out the driver load if ld_list_query fails (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Change build_mpt_mfi_pass_thru to return void (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: During OCR, if get_ctrl_info fails do not continue with OCR (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Do not set fp_possible if TM capable for non-RW syspdIO, change fp_possible to bool (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Remove unused pd_index from megasas_build_ld_nonrw_fusion (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: megasas_return_cmd does not memset IO frame to zero (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: max_fw_cmds are decremented twice, remove duplicate (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: update can_queue only if the new value is less (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Change max_cmd from u32 to u16 in all functions (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: set pd_after_lb from MR_BuildRaidContext and initialize pDevHandle to MR_DEVHANDLE_INVALID (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: latest controller OCR capability from FW before sending shutdown DCMD (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: avoid unaligned access in ioctl path (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: big endian support changes (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Big endian RDPQ mode fix (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: MR_TargetIdToLdGet u8 to u16 and avoid invalid raid-map access (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: In validate raid map, raid capability is not converted to cpu format for all lds (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: reduce size of fusion_context and use vmalloc if kmalloc fails (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: add print in device removal path (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: enhance debug logs in OCR context (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: set residual bytes count during IO completion (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: raid 1 write performance for large io (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: NVME fast path io support (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: NVME interface target prop added (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: NVME Interface detection and prop settings (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: change issue_dcmd to return void from int (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: megasas_get_request_descriptor always return valid desc (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Use DID_REQUEUE (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: RAID map is accessed for SYS PDs when use_seqnum_jbod_fp is not set (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: Refactor MEGASAS_IS_LOGICAL macro using sdev (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: 32 bit descriptor fire cmd optimization (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: raid 1 fast path code optimize (Tomas Henzl) [1417038]
- [scsi] megaraid_sas: cpu select rework (Tomas Henzl) [1417038]
- [scsi] megaraid: Revert "scsi: megaraid_sas: Enable or Disable Fast path based on the PCI Threshold Bandwidth" (Tomas Henzl) [1417038]
- [maintainers] Updating maintainers list for Cisco FNI and SNIC drivers (Maurizio Lombardi) [1388217]
- [scsi] fnic: Avoid sending reset to firmware when another reset is in progress (Maurizio Lombardi) [1388217]
- [scsi] fnic: Correcting rport check location in fnic_queuecommand_lck (Maurizio Lombardi) [1388217]
- [scsi] fnic: use kernel's 'pM' format option to print MAC (Maurizio Lombardi) [1388217]
- [scsi] fnic: pci_dma_mapping_error() doesn't return an error code (Maurizio Lombardi) [1388217]

* Fri Mar 10 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-600.el7]
- [powerpc] pseries: Automatically resize HPT for memory hot add/remove (David Gibson) [1305399]
- [mm] memblock: don't mark memblock_phys_mem_size() as __init (David Gibson) [1305399]
- [powerpc] mm: Split hash page table sizing heuristic into a helper (David Gibson) [1305399]
- [powerpc] pseries: Add support for hash table resizing (David Gibson) [1305399]
- [powerpc] pseries: Add hypercall wrappers for hash page table resizing (David Gibson) [1305399]
- [powerpc] Remove the celleb support (David Gibson) [1305399]
- [tty] hvc: remove celleb-only beat driver (David Gibson) [1305399]
- [powerpc] ptrace: Fix cppcheck issue in gpr32_set_common/gpr32_get_common() (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Fix coredump since ptrace TM changes (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable support for Performance Monitor registers (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable support for EBB registers (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable support for NT_PPPC_TAR, NT_PPC_PPR, NT_PPC_DSCR (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable NT_PPC_TM_CTAR, NT_PPC_TM_CPPR, NT_PPC_TM_CDSCR (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable support for TM SPR state (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable support for NT_PPC_CVSX (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable support for NT_PPC_CVMX (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable support for NT_PPC_CFPR (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable support for NT_PPC_CGPR (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Adapt gpr32_get, gpr32_set functions for transaction (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable in transaction NT_PPC_VSX ptrace requests (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable in transaction NT_PPC_VMX ptrace requests (Gustavo Duarte) [1187582]
- [powerpc] ptrace: Enable in transaction NT_PRFPREG ptrace requests (Gustavo Duarte) [1187582]
- [powerpc] process: Add the function flush_tmregs_to_thread (Gustavo Duarte) [1187582]
- [powerpc] elf: Add powerpc specific core note sections (Gustavo Duarte) [1187582]
- [powerpc] tm: Drop tm_orig_msr from thread_struct (Gustavo Duarte) [1187582]
- [powerpc] pseries: Advertise Hot Plug Event support to firmware (Thomas Huth) [1305399 1323417]
- [powerpc] prom: Switch to using structs for ibm_architecture_vec (Thomas Huth) [1305399 1323417]
- [powerpc] prom: Define structs for client architecture vectors (Thomas Huth) [1305399 1323417]
- [powerpc] prom: Fix sub-processor option passed to ibm, client-architecture-support (Thomas Huth) [1305399 1323417]
- [powerpc] Add macros for the ibm_architecture_vec[] lengths (Thomas Huth) [1305399 1323417]
- [powerpc] pseries: Implement indexed-count hotplug memory remove (Thomas Huth) [1323417]
- [powerpc] pseries: Implement indexed-count hotplug memory add (Thomas Huth) [1323417]
- [powerpc] pseries: Fix build break when MEMORY_HOTREMOVE=n (Thomas Huth) [1323417]
- [powerpc] pseries: Introduce memory hotplug READD operation (Thomas Huth) [1323417]
- [powerpc] pseries: Revert 'Auto-online hotplugged memory' (Thomas Huth) [1323417]
- [powerpc] pseries: Make the acquire/release of the drc for memory a seperate step (Thomas Huth) [1323417]
- [powerpc] pseries: Remove call to memblock_add() (Thomas Huth) [1323417]
- [powerpc] pseries: Auto-online hotplugged memory (Thomas Huth) [1323417]
- [powerpc] pseries: Use lmb_is_removable() to check removability (Thomas Huth) [1323417]
- [powerpc] Fix unused function warning 'lmb_to_memblock' (Thomas Huth) [1323417]
- [powerpc] of: Introduce device tree node flag helpers (Thomas Huth) [1323417]
- [powerpc] pseries: Correct possible read beyond dlpar sysfs buffer (Thomas Huth) [1323417]
- [powerpc] pseries: fix memory leak in queue_hotplug_event() error path (Thomas Huth) [1323417]
- [powerpc] pseries: Use kernel hotplug queue for PowerVM hotplug events (Thomas Huth) [1323417]
- [powerpc] pseries: Add support for hotplug interrupt source (Thomas Huth) [1323417]
- [powerpc] pseries: Add pseries hotplug workqueue (Thomas Huth) [1323417]
- [powerpc] pseries: Dynamic add entires to associativity lookup array (Thomas Huth) [1323417]
- [powerpc] pseries: Move property cloning into its own routine (Thomas Huth) [1323417]
- [powerpc] pseries: Update LMB associativity index during DLPAR add/remove (Thomas Huth) [1323417]
- [powerpc] pseries: Refactor dlpar_add_lmb() code (Thomas Huth) [1323417]
- [powerpc] pseries: Consolidate CPU hotplug code to hotplug-cpu.c (Thomas Huth) [1323417]
- [powerpc] Ensure global functions include their prototype (Thomas Huth) [1323417]
- [powerpc] arch/powerpc: replace obsolete strict_strto* calls (Thomas Huth) [1323417]
- [powerpc] pseries: Verify CPU doesn't exist before adding (Thomas Huth) [1323417]
- [powerpc] pseries: Release DRC when configure_connector fails (Thomas Huth) [1323417]
- [powerpc] pseries: use kmemdup rather than duplicating its implementation (Thomas Huth) [1323417]
- [powerpc] pseries: Fix possible leaked device node reference (Thomas Huth) [1323417]
- [powerpc] pseries: Fix compile of memory hotplug without CONFIG_MEMORY_HOTREMOVE (Thomas Huth) [1323417]
- [powerpc] pseries: Correct memory hotplug locking (Thomas Huth) [1323417]
- [powerpc] pseries: Implement memory hotplug remove in the kernel (Thomas Huth) [1323417]
- [powerpc] pseries: Implement memory hotplug add in the kernel (Thomas Huth) [1323417]
- [powerpc] pseries: Create new device hotplug entry point (Thomas Huth) [1323417]
- [powerpc] pseries: Declare the acquire/release drc index routines (Thomas Huth) [1323417]
- [powerpc] Remove ppc_md.remove_memory (Thomas Huth) [1323417]
- [powerpc] Fix comment typos in hotplug-memory.c (Thomas Huth) [1323417]
- [powerpc] pseries: Define rtas hotplug event sections (Thomas Huth) [1323417]

* Fri Mar 10 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-599.el7]
- [kernel] tracing: Do not have 'comm' filter override event 'comm' field (Pratyush Anand) [1399999]
- [kernel] tracing: Allow triggers to filter for CPU ids and process names (Pratyush Anand) [1399999]
- [x86] apic: Order irq_enter/exit() calls correctly vs. ack_APIC_irq() (George Beshers) [1404816]
- [x86] apic: Fix suspicious RCU usage in smp_trace_call_function_interrupt() (George Beshers) [1404816]
- [x86] Consolidate irq entering inlines (George Beshers) [1404816]
- [net] ip_tunnel: Create percpu gro_cell (Jiri Benc) [1424076]
- [net] udp: fix errorneous sk_filter removal (Paolo Abeni) [1388467]
- [net] l2tp: do not use udp_ioctl() (Paolo Abeni) [1388467]
- [net] udp: properly cope with csum errors (Paolo Abeni) [1388467]
- [net] udp: be less conservative with sock rmem accounting (Paolo Abeni) [1388467]
- [net] udplite: fix NULL pointer dereference (Paolo Abeni) [1388467]
- [net] udp: do fwd memory scheduling on dequeue (Paolo Abeni) [1388467]
- [net] sock: add an explicit sk argument for ip_cmsg_recv_offset() (Paolo Abeni) [1388467]
- [net] udp: use it's own memory accounting schema (Paolo Abeni) [1388467]
- [net] udp: implement memory accounting helpers (Paolo Abeni) [1388467]
- [net] sock: factor out helpers for memory and queue manipulation (Paolo Abeni) [1388467]
- [net] Fix inverted test in __skb_recv_datagram (Paolo Abeni) [1388467]
- [net] enable more fine-grained datagram reception control (Paolo Abeni) [1388467]
- [net] add common accessor for setting dropcount on packets (Paolo Abeni) [1388467]
- [net] ipvs: SH fallback and L4 hashing (Jakub Sitnicki) [1365002]
- [net] ipvs: provide iph to schedulers (Jakub Sitnicki) [1365002]
- [acpi] acpi / sysfs: Fix an issue for LoadTable opcode (Prarit Bhargava) [1425195]
- [acpi] acpica: tables: Add new table events indicating table installation/uninstallation (Prarit Bhargava) [1425195]
- [acpi] acpica: tables: Remove wrong table event macros (Prarit Bhargava) [1425195]
- [misc] cxl: fix nested locking hang during EEH hotplug (Steve Best) [1429625]
- [misc] cxl: Prevent read/write to AFU config space while AFU not configured (Steve Best) [1429625]
- [edac] enable skx_edac (Aristeu Rozanski) [1273747]
- [edac] skx_edac: Add EDAC driver for Skylake (Aristeu Rozanski) [1273747]
- [netdrv] broadcom: bnx2x: use new api ethtool_{get|set}_link_ksettings (Michal Schmidt) [1391238]
- [netdrv] bnx2x: avoid two atomic ops per page on x86 (Michal Schmidt) [1391238]
- [netdrv] bnx2x: Fix printk() message errors (Michal Schmidt) [1391238]
- [netdrv] bnx2x: Prevent tunnel config for 577xx (Michal Schmidt) [1391238]
- [netdrv] bnx2x: Correct ringparam estimate when DOWN (Michal Schmidt) [1391238]
- [netdrv] bnx2x: fix improper return value (Michal Schmidt) [1391238]
- [netdrv] bnx2x: use reset to set network header (Michal Schmidt) [1391238]
- [netdrv] bnx2x: switch to napi_complete_done() (Michal Schmidt) [1391238]
- [netdrv] bnx2x: cleanup ETH_* defines (Michal Schmidt) [1391238]
- [netdrv] bnx2x: free the mac filter group list before freeing the cmd (Michal Schmidt) [1391238]
- [netdrv] bnx2x: allocate mac filtering pending list in PAGE_SIZE increments (Michal Schmidt) [1391238]
- [netdrv] bnx2x: allocate mac filtering 'mcast_list' in PAGE_SIZE increments (Michal Schmidt) [1391238]
- [netdrv] bnx2x: don't reset chip on cleanup if PCI function is offline (Michal Schmidt) [1391238]
- [netdrv] bnx2x: Add support for segmentation of tunnels with outer checksums (Michal Schmidt) [1391238]
- [netdrv] bnx2x: Don't flush multicast MACs (Michal Schmidt) [1391238]
- [netdrv] bnx2x: Move all UDP port notifiers to single function (Michal Schmidt) [1391238]
- [netdrv] cxgb4vf: Fix queue allocation for 40G adapter (Sai Vemuri) [1250931]
- [netdrv] cxgb4: Fix issue while re-registering VF mgmt netdev (Sai Vemuri) [1250931]
- [netdrv] cxgb4/cxgb4vf: Add set VF mac address support (Sai Vemuri) [1250931]
- [netdrv] cxgb4: Add control net_device for configuring PCIe VF (Sai Vemuri) [1250931]
- [infiniband] iw_cxgb4: set *bad_wr for post_send/post_recv errors (Sai Vemuri) [1416917]

* Thu Mar 09 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-598.el7]
- [netdrv] e1000e: driver trying to free already-free irq (Jarod Wilson) [1383529]
- [netdrv] e1000e/ptp_clock: future-proofing drivers against PTP subsystem becoming optional (Jarod Wilson) [1383529]
- [netdrv] e1000e: Use pci_(request|release)_mem_regions (Jarod Wilson) [1383529]
- [netdrv] e1000e: don't modify SYSTIM registers during SIOCSHWTSTAMP ioctl (Jarod Wilson) [1383529]
- [netdrv] e1000e: mark shifted values as unsigned (Jarod Wilson) [1383529]
- [netdrv] e1000e: use BIT() macro for bit defines (Jarod Wilson) [1383529]
- [netdrv] e1000e: e1000e_cyclecounter_read(): do overflow check only if needed (Jarod Wilson) [1383529]
- [netdrv] e1000e: e1000e_cyclecounter_read(): fix er32(SYSTIML) overflow check (Jarod Wilson) [1383529]
- [netdrv] e1000e: Cleanup consistency in ret_val variable usage (Jarod Wilson) [1383529]
- [netdrv] e1000e: fix ethtool autoneg off for non-copper (Jarod Wilson) [1383529]
- [netdrv] e1000e: call ndo_stop() instead of dev_close() when running offline selftest (Jarod Wilson) [1383529]
- [netdrv] sfc: do not device_attach if a reset is pending (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: forget filters from sw table if hw replies ENOENT on removing them (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: fix filter_id misinterpretation in edge case (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: only fall back to a lower interrupt mode if it is supported (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: MSI-X is the only interrupt mode for EF10 VFs (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: fix swapped arguments to efx_ef10_handle_rx_event_errors (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: configure UDP tunnel offload ports (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: update mcdi_pcol definitions for MC_CMD_SET_TUNNEL_ENCAP_UDP_PORTS (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: call mcdi_reboot_detected() when MC reboots during an MCDI command (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: harden driver against MC resets during initial probe (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: set csum_level for encapsulated packets (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: process RX event inner checksum flags (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: report 4-tuple UDP hashing to ethtool, if it's enabled (Jarod Wilson) [1389480 1386061 1385378 1385133]
- [netdrv] sfc: enable 4-tuple RSS hashing for UDP (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [net] Delete trailing semi-colon from definition of netdev_WARN() (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: fix an off by one bug (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc-falcon: get rid of custom busy polling code (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: get rid of custom busy polling code (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: fix an off-by-one compare on an array size (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: generalize napi_complete_done() (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: insert catch-all filters for encapsulated traffic (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: refactor debug-or-warnings printks (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [net] implement netif_cond_dbg macro (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: fixes to filter restore handling (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: reduce severity of PIO buffer alloc failures (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: read back RX hash config from the NIC when querying it with ethtool -x (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: support setting RSS hash key through ethtool API (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: get PIO buffer size from the NIC (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: allow PIO more often (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: Replace memset with eth_zero_addr (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: efx_get_phys_port_id() can be static (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: stop setting dev_port (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: implement ndo_get_phys_port_name (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: support ndo_get_phys_port_id even when !CONFIG_SFC_SRIOV (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: don't report RX hash keys to ethtool when RSS wasn't enabled (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc-falcon: declare module version (same as ethtool drvinfo version) (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: declare module version (same as ethtool drvinfo version) (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: remove EFX_BUG_ON_PARANOID, use EFX_WARN_ON_[ONCE_]PARANOID instead (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: remove RESET_TYPE_RX_RECOVERY (Jarod Wilson) [1385133 1385378 1386061 1389480 1389671]
- [netdrv] ethernet: sfc: Add Kconfig entry for vendor Solarflare (Jarod Wilson) [1385133 1385378 1386061 1389480 1389671]
- [netdrv] sfc: don't select SFC_FALCON (Jarod Wilson) [1385133 1385378 1386061 1389480 1389671]
- [netdrv] sfc: fix debug message format string in efx_farch_handle_rx_not_ok (Jarod Wilson) [1385133 1385378 1386061 1389480 1389671]
- [netdrv] sfc: separate out SFC4000 ("Falcon") support into new sfc-falcon driver (Jarod Wilson) [1385133 1385378 1386061 1389480 1389671]
- [netdrv] sfc: remove unneeded variable (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: remove Software TSO (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: handle failure to allocate TSOv2 contexts (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: Firmware-Assisted TSO version 2 (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: Update EF10 register definitions (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: Update MCDI protocol definitions (Jarod Wilson) [1385133 1385378 1386061 1389480]
- [netdrv] sfc: remove napi_hash_del() call (Jarod Wilson) [1385133 1385378 1386061 1389480]

* Thu Mar 09 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-597.el7]
- [netdrv] igb/igbvf: Don't use lco_csum to compute IPv4 checksum (Corinna Vinschen) [1383528]
- [netdrv] igbvf: bump version to igbvf-2.4.0 (Corinna Vinschen) [1383528]
- [netdrv] igb/igbvf: Add support for GSO partial (Corinna Vinschen) [1383528]
- [netdrv] igb: Fix hw_dbg logging in igb_update_flash_i210 (Corinna Vinschen) [1383527]
- [netdrv] igb: add i211 to i210 PHY workaround (Corinna Vinschen) [1383527]
- [netdrv] igb: close/suspend race in netif_device_detach (Corinna Vinschen) [1383527]
- [netdrv] igb: reset the PHY before reading the PHY ID (Corinna Vinschen) [1383527]
- [netdrv] igb: use igb_adapter->io_addr instead of e1000_hw->hw_addr (Corinna Vinschen) [1383527]
- [netdrv] igb: Workaround for igb i210 firmware issue (Corinna Vinschen) [1383527]
- [netdrv] igb: correct register comments (Corinna Vinschen) [1383527]
- [netdrv] igb: Realign bad indentation (Corinna Vinschen) [1383527]
- [netdrv] igb/igbvf: Don't use lco_csum to compute IPv4 checksum (Corinna Vinschen) [1383527]
- [netdrv] igb: restore PPS signal on igb_ptp_reset (Corinna Vinschen) [1383527]
- [netdrv] igb: bump version to igb-5.4.0 (Corinna Vinschen) [1383527]
- [netdrv] igb: fix non static symbol warning (Corinna Vinschen) [1383527]
- [netdrv] ptp_clock: future-proofing drivers against PTP subsystem becoming optional (Corinna Vinschen) [1383527]
- [netdrv] igb: fix error code in igb_add_ethtool_nfc_entry() (Corinna Vinschen) [1383527]
- [netdrv] igb: support RX flow classification by VLAN (Corinna Vinschen) [1383527]
- [netdrv] igb: support RX flow classification by ethertype (Corinna Vinschen) [1383527]
- [netdrv] igb: add support of RX network flow classification (Corinna Vinschen) [1383527]
- [netdrv] igb: fix adjusting PTP timestamps for Tx/Rx latency (Corinna Vinschen) [1383527]
- [netdrv] igb: Only DMA sync frame length (Corinna Vinschen) [1383527]
- [netdrv] igb: call igb_ptp_suspend during suspend/resume cycle (Corinna Vinschen) [1383527]
- [netdrv] igb: implement igb_ptp_suspend (Corinna Vinschen) [1383527]
- [netdrv] igb: re-use igb_ptp_reset in igb_ptp_init (Corinna Vinschen) [1383527]
- [netdrv] igb: introduce IGB_PTP_OVERFLOW_CHECK flag (Corinna Vinschen) [1383527]
- [netdrv] igb: introduce ptp_flags variable and use it to replace IGB_FLAG_PTP (Corinna Vinschen) [1383527]
- [netdrv] ethernet/intel: Use pci_(request|release)_mem_regions (Corinna Vinschen) [1383527]
- [netdrv] igb/igbvf: Add support for GSO partial (Corinna Vinschen) [1383527]
- [netdrv] igb: adjust PTP timestamps for Tx/Rx latency (Corinna Vinschen) [1383527]
- [netdrv] igb: make igb_update_pf_vlvf static (Corinna Vinschen) [1383527]
- [netdrv] igb: use BIT() macro or unsigned prefix (Corinna Vinschen) [1383527]
- [netdrv] generalize napi_complete_done() (Ivan Vecera) [1382354]
- [netdrv] be2net: get rid of custom busy poll code (Ivan Vecera) [1382354]
- [netdrv] be2net: fix initial MAC setting (Ivan Vecera) [1382354]
- [netdrv] be2net: fix MAC addr setting on privileged BE3 VFs (Ivan Vecera) [1382354]
- [netdrv] be2net: don't delete MAC on close on unprivileged BE3 VFs (Ivan Vecera) [1382354]
- [netdrv] be2net: fix status check in be_cmd_pmac_add() (Ivan Vecera) [1382354]
- [netdrv] be2net: fix unicast list filling (Ivan Vecera) [1382354]
- [netdrv] be2net: fix accesses to unicast list (Ivan Vecera) [1382354]
- [netdrv] benet: stricter vxlan offloading check in be_features_check (Ivan Vecera) [1382354]
- [netdrv] emulex: benet: use new api ethtool_{get|set}_link_ksettings (Ivan Vecera) [1382354]
- [netdrv] be2net: Add DEVSEC privilege to SET_HSW_CONFIG command (Ivan Vecera) [1382354]
- [netdrv] be2net: do not call napi_hash_del() (Ivan Vecera) [1382354]
- [netdrv] be2net: Enable VF link state setting for BE3 (Ivan Vecera) [1382354]
- [netdrv] be2net: Fix TX stats for TSO packets (Ivan Vecera) [1382354]
- [netdrv] be2net: Update Copyright string in be_hw.h (Ivan Vecera) [1382354]
- [netdrv] be2net: NCSI FW section should be properly updated with ethtool for BE3 (Ivan Vecera) [1382354]
- [netdrv] be2net: Provide an alternate way to read pf_num for BEx chips (Ivan Vecera) [1382354]
- [netdrv] be2net: fix non static symbol warnings (Ivan Vecera) [1382354]
- [netdrv] be2net: mark symbols static where possible (Ivan Vecera) [1382354]
- [netdrv] be2net: Update the driver version to 11.1.0.0 (Ivan Vecera) [1382354]
- [netdrv] be2net: Fix mac address collision in some configurations (Ivan Vecera) [1382354]
- [netdrv] be2net: Avoid redundant addition of mac address in HW (Ivan Vecera) [1382354]
- [netdrv] be2net: Add privilege level check for OPCODE_COMMON_GET_EXT_FAT_CAPABILITIES SLI cmd (Ivan Vecera) [1382354]
- [netdrv] be2net: Issue COMMON_RESET_FUNCTION cmd during driver unload (Ivan Vecera) [1382354]
- [netdrv] be2net: Support UE recovery in BEx/Skyhawk adapters (Ivan Vecera) [1382354]
- [netdrv] be2net: replace polling with sleeping in the FW completion path (Ivan Vecera) [1382354]
- [netdrv] be2net: Avoid unnecessary firmware updates of multicast list (Ivan Vecera) [1382354]
- [netdrv] be2net: do not remove vids from driver table if be_vid_config() fails (Ivan Vecera) [1382354]
- [netdrv] be2net: clear vlan-promisc setting before programming the vlan list (Ivan Vecera) [1382354]

* Thu Mar 09 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-596.el7]
- [netdrv] amd-xgbe: Check xgbe_init() return code (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add a hardware quirk for register definitions (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix IRQ processing when running in single IRQ mode (David Arcari) [1339783]
- [netdrv] Rename CONFIG_PM to CONFIG_PM_SLEEP in XGBE driver (David Arcari) [1339783]
- [netdrv] amd-xgbe: Update connection validation for backplane mode (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix maximum GPIO value check (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix possible uninitialized variable (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix up some coccinelle identified warnings (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix mask appliciation for Clause 37 register (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add support for a KR redriver (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add support for MDIO attached PHYs (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add support for SFP+ modules (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add I2C support for sideband communication (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add ECC status support for the device memory (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add support for new DMA interrupt mode (David Arcari) [1339783]
- [netdrv] amd-xgbe: Allow for a greater number of Rx queues (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add PCI device support (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add a workaround for Tx timestamp issue (David Arcari) [1339783]
- [netdrv] amd-xgbe: Guard against incorrectly generated interrupts (David Arcari) [1339783]
- [netdrv] xgbe: use new api ethtool_{get|set}_link_ksettings (David Arcari) [1339783]
- [netdrv] amd-xgbe: Prepare for supporting PCI devices (David Arcari) [1339783]
- [netdrv] amd-xgbe: Update how to determine DMA channel status (David Arcari) [1339783]
- [netdrv] amd-xgbe: Support for 64-bit management counter registers (David Arcari) [1339783]
- [netdrv] amd-xgbe: Prepare for a new PCS register access method (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add support for clause 37 auto-negotiation (David Arcari) [1339783]
- [netdrv] amd-xgbe: Prepare for introduction of clause 37 autoneg (David Arcari) [1339783]
- [netdrv] amd-xgbe: Prepare for working with more than one type of phy (David Arcari) [1339783]
- [netdrv] amd-xgbe: Perform priority-based hardware FIFO allocation (David Arcari) [1339783]
- [netdrv] amd-xgbe: Prepare for priority-based FIFO allocation (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix formatting of PCS register dump (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix error return code in xgbe_probe() (David Arcari) [1339783]
- [netdrv] xgbe: constify get_netdev_ops and get_ethtool_ops (David Arcari) [1339783]
- [netdrv] amd-xgbe: Reset running devices after resume from hibernate (David Arcari) [1339783]
- [netdrv] amd-xgbe: use correct format specifier (David Arcari) [1339783]
- [netdrv] relax setup_tc ndo op handle restriction (David Arcari) [1339783]
- [netdrv] amd-xgbe: Mask auto-negotiation interrupts in ISR (David Arcari) [1339783]
- [netdrv] amd-xgbe: Check Rx queue fifos before stopping Rx DMA (David Arcari) [1339783]
- [netdrv] amd-xgbe: Do traffic class setup when called through dcbnl (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix the mapping of priorities to traffic classes (David Arcari) [1339783]
- [netdrv] amd-xgbe: Enable/disable PFC per traffic class (David Arcari) [1339783]
- [netdrv] amd-xgbe: Verify forced speed matches the active speedset (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use __napi_schedule_irqoff (David Arcari) [1339783]
- [netdrv] amd-xgbe: Change from napi_complete to napi_complete_done (David Arcari) [1339783]
- [netdrv] amd-xgbe: Disable VLAN filtering when in promiscuous mode (David Arcari) [1339783]
- [netdrv] rework setup_tc ndo op to consume general tc operand (David Arcari) [1339783]
- [netdrv] rework ndo tc op to consume additional qdisc handle parameter (David Arcari) [1339783]
- [netdrv] amd-xgbe: fix a couple timeout loops (David Arcari) [1339783]
- [netdrv] move skb_mark_napi_id() into core networking stack (David Arcari) [1339783]
- [netdrv] device property: acpi: Make use of the new DMA Attribute APIs (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix race between access of desc and desc index (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use wmb before updating current descriptor count (David Arcari) [1339783]
- [netdrv]  get rid of unnecessary initializations in .get_drvinfo() (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use system workqueue for device restart (David Arcari) [1339783]
- [netdrv] amd-xgbe: Check for successful buffer allocation before use (David Arcari) [1339783]
- [netdrv] amd-xgbe: Remove the XGBE_LINK state bit (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use device workqueue instead of system workqueue (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add receive buffer unavailable statistic (David Arcari) [1339783]
- [netdrv] amd-xgbe: Simplify calculation and setting of queue fifos (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add ethtool error and debug messages (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add ethtool support for setting the msglevel (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use proper DT / ACPI precedence checking (David Arcari) [1339783]
- [netdrv] amd-xgbe: Remove an unneeded semicolon on a switch statement (David Arcari) [1339783]
- [netdrv] amd-xgbe: fix potential memory leak in xgbe-debugfs (David Arcari) [1339783]
- [netdrv] treewide: fix typos in comment blocks (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix DMA API debug warning (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add the __GFP_NOWARN flag to Rx buffer allocation (David Arcari) [1339783]
- [netdrv] amd-xgbe: Unify coherency checking logic with device_dma_is_coherent() (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use disable_irq_nosync from within timer function (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add more netif_dbg output to the driver (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix initial mode when auto-negotiation is disabled (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add setting of a missing hardware feature (David Arcari) [1339783]
- [netdrv] amd-xgbe: Remove manual check and set of dma_mask pointer (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix flow control setting logic (David Arcari) [1339783]
- [netdrv] amd-xgbe: Support defining PHY resources in ETH device node (David Arcari) [1339783]
- [netdrv] amd-xgbe: Move the PHY support into amd-xgbe (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Fix initial mode when autoneg is disabled (David Arcari) [1339783]
- [netdrv] amd-xgbe: Rework the Rx path SKB allocation (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add netif_* message support to the driver (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add additional stats to be reported via ethtool (David Arcari) [1339783]
- [netdrv] batch of last_rx update avoidance in ethernet drivers (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add hardware dependency (David Arcari) [1339783]
- [netdrv] ethernet: amd: AMD_XGBE should depend on HAS_DMA (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add support for the netdev Tx watchdog (David Arcari) [1339783]
- [netdrv] amd-xgbe: Move Rx mode configuration into init (David Arcari) [1339783]
- [netdrv] amd-xgbe: Allow rx-frames coalescing to be changed anytime (David Arcari) [1339783]
- [netdrv] ptp: xgbe: convert to the 64 bit get/set time methods (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use napi_alloc_skb when allocating skb in softirq (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix Rx coalescing reporting (David Arcari) [1339783]
- [netdrv] amd-xgbe: Remove Tx coalescing (David Arcari) [1339783]
- [netdrv] amd-xgbe: Set DMA mask based on hardware register value (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use the new DMA memory barriers where appropriate (David Arcari) [1339783]
- [netdrv] amd-xgbe: Clarify output message about queues (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Provide support for auto-negotiation timeout (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Use the phy_driver flags field (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Use phydev advertising field vs supported (David Arcari) [1339783]
- [netdrv] ethernet: codespell comment spelling fixes (David Arcari) [1339783]
- [netdrv] amd-xgbe: Request IRQs only after driver is fully setup (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: PHY KX/KR mode differences (David Arcari) [1339783]
- [netdrv] amd-xgbe: Check per channel DMA interrupt use in main ISR (David Arcari) [1339783]
- [netdrv] amd-xgbe: Set RSS enablement based on hardware features (David Arcari) [1339783]
- [netdrv] amd-xgbe: Adjust for zero-based traffic class count (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use proper Rx flow control register (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Allow certain PHY settings to be set by UEFI (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add ACPI support (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Use the proper auto-negotiation XNP registers (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Properly support the FEC auto-negotiation (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Change auto-negotiation logic (David Arcari) [1339783]
- [netdrv] amd-xgbe: Remove need for Tx path spinlock (David Arcari) [1339783]
- [netdrv] amd-xgbe: Simplify the Rx desciptor ring tracking (David Arcari) [1339783]
- [netdrv] amd-xgbe: Clear all state during a device restart (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: On suspend, save CTRL1 reg for use on resume (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add check to be sure amd-xgbe-phy driver is used (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Checkpatch fixes (David Arcari) [1339783]
- [netdrv] amd-xgbe: Checkpatch fixes (David Arcari) [1339783]
- [netdrv] rename vlan_tx_* helpers since "tx" is misleading there (David Arcari) [1339783]
- [netdrv] xgbe: convert to timecounter adjtime (David Arcari) [1339783]
- [netdrv] time: move the timecounter/cyclecounter code into its own file (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Let AMD_XGBE_PHY depend on HAS_IOMEM (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use disable_irq_nosync when in IRQ context (David Arcari) [1339783]
- [netdrv] amd-xgbe: Prevent Tx cleanup stall (David Arcari) [1339783]
- [netdrv] amd-xgbe: Associate Tx SKB with proper ring descriptor (David Arcari) [1339783]
- [netdrv] amd-xgbe: Do not clear interrupt indicator (David Arcari) [1339783]
- [netdrv] amd-xgbe: IRQ names require allocated memory (David Arcari) [1339783]
- [netdrv] ethtool: Support for configurable RSS hash function (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add support for the skb->xmit_more flag (David Arcari) [1339783]
- [netdrv] amd-xgbe: Perform Tx coalescing on a packet basis (David Arcari) [1339783]
- [netdrv] amd-xgbe: Remove unused variable (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add BQL support (David Arcari) [1339783]
- [netdrv] amd-xgbe: Separate Tx/Rx ring data fields into new structs (David Arcari) [1339783]
- [netdrv] amd-xgbe: Incorporate Smatch coding suggestion (David Arcari) [1339783]
- [netdrv] amd-xgbe: Tx engine must not be active before stopping it (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add a read memory barrier to Tx/Rx path (David Arcari) [1339783]
- [netdrv] amd-xgbe: use netdev_rss_key_fill() helper (David Arcari) [1339783]
- [netdrv] amd-xgbe: fix ->rss_hash_type (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix sparse endian warnings (David Arcari) [1339783]
- [netdrv] amd-xgbe: Check for complete packet on skb allocation error (David Arcari) [1339783]
- [netdrv] amd-xgbe: Free channel/ring structures later (David Arcari) [1339783]
- [netdrv] amd-xgbe: Let AMD_XGBE depend on HAS_IOMEM (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Sync PCS and PHY modes after reset (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix a spelling error (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add receive side scaling ethtool support (David Arcari) [1339783]
- [netdrv] amd-xgbe: Provide support for receive side scaling (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add support for per DMA channel interrupts (David Arcari) [1339783]
- [netdrv] amd-xgbe: Implement split header receive support (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use page allocations for Rx buffers (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use the u32 data type for descriptors (David Arcari) [1339783]
- [netdrv] amd-xgbe: Rename pre_xmit function to dev_xmit (David Arcari) [1339783]
- [netdrv] amd-xgbe: Move ring allocation to device open (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix napi Rx budget accounting (David Arcari) [1339783]
- [netdrv] amd-xgbe: Properly handle feature changes via ethtool (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Fix build break for missing declaration (David Arcari) [1339783]
- [netdrv] amd-xgbe: Enable interrupts for all management counters (David Arcari) [1339783]
- [netdrv] amd-xgbe: Treat certain counter registers as 64 bit (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Checkpatch driver fixes (David Arcari) [1339783]
- [netdrv] amd-xgbe: Checkpatch driver fixes (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Enhance parallel detection to support KR speed (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Check device for current speed mode (KR/KX) (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix initialization of the wrong spin lock (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use the Tx queue count for Tx flow control support (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix the xpcs mmd debugfs support (David Arcari) [1339783]
- [netdrv] amd-xgbe: Reported fifo size from hardware is not correct (David Arcari) [1339783]
- [netdrv] amd-xgbe: Check for Tx hardware queue flushing support (David Arcari) [1339783]
- [netdrv] amd: xgbe: fix duplicate #include of linux/phy.h (David Arcari) [1339783]
- [netdrv] amd-xgbe: Perform phy connect/disconnect at dev open/stop (David Arcari) [1339783]
- [netdrv] amd-xgbe: Use dma_set_mask_and_coherent to set DMA mask (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Allow more time for Rx/Tx to become ready (David Arcari) [1339783]
- [netdrv] amd-xgbe: Remove unnecessary spinlocks (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add traffic class support (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Print out the auto-negotiation method used (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Updates to KR training initiation (David Arcari) [1339783]
- [netdrv] amd-xgbe-phy: Updates to rate change complete check (David Arcari) [1339783]
- [netdrv] amd-xgbe: Base queue fifo size and enablement on ring count (David Arcari) [1339783]
- [netdrv] amd-xgbe: Update/fix 2.5GbE support (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add hardware timestamp support (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add dma-coherent to device bindings documentation (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix error return code in xgbe_probe() (David Arcari) [1339783]
- [netdrv] amd-xgbe: Remove the adjustments needed for fixed speed (David Arcari) [1339783]
- [netdrv] amd-xgbe: Base AXI DMA cache settings on device tree (David Arcari) [1339783]
- [netdrv] amd-xgbe: Performance enhancements (David Arcari) [1339783]
- [netdrv] amd-xgbe: Call netif_napi_del on ndo_stop operation (David Arcari) [1339783]
- [netdrv] amd-xgbe: Clear the proper MTL interrupt register (David Arcari) [1339783]
- [netdrv] amd-xgbe: Fix debugfs compatibility change with kstrtouint (David Arcari) [1339783]
- [netdrv] amd-xgbe: Resolve checkpatch warning about sscanf usage (David Arcari) [1339783]
- [netdrv] amd-xgbe: Change destination address filtering support (David Arcari) [1339783]
- [netdrv] amd-xgbe: Add support for VLAN filtering (David Arcari) [1339783]
- [netdrv] amd-xgbe: VLAN Rx tag stripping fix (David Arcari) [1339783]
- [netdrv] amd-xgbe: VLAN Tx tag insertion fix (David Arcari) [1339783]
- [netdrv] amd-xgbe: Make defines in xgbe.h unique (David Arcari) [1339783]
- [netdrv] amd-xgbe: unwind on error in xgbe_mdio_register() (David Arcari) [1339783]
- [netdrv] amd-xgbe: Rename MAX_DMA_CHANNELS to avoid powerpc conflict (David Arcari) [1339783]
- [netdrv] amd-xgbe: fix unused variable compilation warning in phylib driver (David Arcari) [1339783]
- [netdrv] amd-xgbe: Remove unnecessary include (David Arcari) [1339783]
- [netdrv] amd-xgbe: Maintainer information (David Arcari) [1339783]
- [netdrv] amd-xgbe: Configuration and build support (David Arcari) [1339783]
- [netdrv] amd-xgbe: Initial AMD 10GbE phylib driver (David Arcari) [1339783]
- [netdrv] amd-xgbe: Initial AMD 10GbE platform driver (David Arcari) [1339783]
- [netdrv] amd-xgbe: AMD 10GbE device bindings documentation (David Arcari) [1339783]

* Thu Mar 09 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-595.el7]
- [netdrv] ixgbevf: Add support for VF promiscuous mode (Ken Cox) [1383525]
- [netdrv] ixgbevf: restore hw_addr on resume or error (Ken Cox) [1383525]
- [netdrv] ixgbevf: fix AER error handling (Ken Cox) [1383525]
- [netdrv] ixgbevf: handle race between close and suspend on shutdown (Ken Cox) [1383525]
- [netdrv] ixgbevf: Handle previously-freed msix_entries (Ken Cox) [1383525]
- [netdrv] ixgbevf: add spinlocks for MTU change calls (Ken Cox) [1383525]
- [netdrv] ixgbevf: fix incorrect MAC address on load (Ken Cox) [1383525]
- [netdrv] ixgbevf: only check Tx queue enablement when debugging (Ken Cox) [1383525]
- [netdrv] ixgbevf: change hw_dbg to use netdev_dbg (Ken Cox) [1383525]
- [netdrv] ixgbevf: Commonize mailbox write/read (Ken Cox) [1383525]
- [netdrv] ixgbevf: Add range checking for setting MTU (Ken Cox) [1383525]
- [netdrv] ixgbevf: Protect ixgbevf_reset_subtask from remove event (Ken Cox) [1383525]
- [netdrv] ixgbevf: Add lock around ixgbevf_reinit_locked call (Ken Cox) [1383525]
- [netdrv] ixgbevf: add VF support for new hardware (Ken Cox) [1383525]
- [netdrv] ixgbevf: bump version number (Ken Cox) [1383525]
- [netdrv] ixgbevf: fix NACK check in ixgbevf_set_uc_addr_vf() (Ken Cox) [1383525]
- [netdrv] ixgbevf: ixgbevf_write/read_posted_mbx should use IXGBE_ERR_MBX to initialize ret_val (Ken Cox) [1383525]
- [netdrv] ixgbe: Add PF support for VF promiscuous mode (Ken Cox) [1383524]
- [netdrv] ixgbe: Implement support for firmware-controlled PHYs (Ken Cox) [1333482 1383524]
- [netdrv] ixgbe: Implement firmware interface to access some PHYs (Ken Cox) [1383524]
- [netdrv] ixgbe: Remove unused firmware version functions and method (Ken Cox) [1383524]
- [netdrv] ixgbe: Fix issues with EEPROM access (Ken Cox) [1383524]
- [netdrv] ixgbe: Configure advertised speeds correctly for KR/KX backplane (Ken Cox) [1383524]
- [netdrv] ixgbe: Fix incorrect bitwise operations of PTP Rx timestamp flags (Ken Cox) [1383524]
- [netdrv] ixgbe: fix AER error handling (Ken Cox) [1383524]
- [netdrv] ixgbe: handle close/suspend race with netif_device_detach/present (Ken Cox) [1383524]
- [netdrv] ixgbe: Fix reporting of 100Mb capability (Ken Cox) [1383524]
- [netdrv] ixgbe: Reduce I2C retry count on X550 devices (Ken Cox) [1383524]
- [netdrv] ixgbe: Add bounds check for x540 LED functions (Ken Cox) [1383524]
- [netdrv] ixgbe: add mask for 64 RSS queues (Ken Cox) [1383524]
- [netdrv] ixgbe: Fix check for ixgbe_phy_x550em_ext_t reset (Ken Cox) [1383524]
- [netdrv] ixgbe: Report driver version to firmware for x550 devices (Ken Cox) [1383524]
- [netdrv] ixgbe: do not disable FEC from the driver (Ken Cox) [1383524]
- [netdrv] ixgbe/ixgbevf: Don't use lco_csum to compute IPv4 checksum (Ken Cox) [1383524]
- [netdrv] ixgbe: ixgbe_atr() compute l4_proto only if non-paged data has network/transport headers (Ken Cox) [1383524]
- [netdrv] ixgbe: ixgbe_atr() should access udp_hdr(skb) only for UDP packets (Ken Cox) [1383524]
- [netdrv] ixgbe: Correct X550 phy ID (Ken Cox) [1383524]
- [netdrv] ixgbe: Add X553 FW ALEF support (Ken Cox) [1371722 1383524]
- [netdrv] ixgbe: set device if before calling get_invariants (Ken Cox) [1383524]
- [netdrv] ixgbe: use link instead of I2C combined abstraction (Ken Cox) [1383524]
- [netdrv] ixgbe: remove SFP ixfi support (Ken Cox) [1383524]
- [netdrv] ixgbe: Handle previously-freed msix_entries (Ken Cox) [1383524]
- [netdrv] ixgbe: Add X553 PHY FC autoneg support (Ken Cox) [1371722 1383524]
- [netdrv] ixgbe: fix link status check for copper X550em (Ken Cox) [1383524]
- [netdrv] ixgbe: do not use ixgbe specific mdio defines (Ken Cox) [1383524]
- [netdrv] ixgbe: Update setup PHY link to unset all speeds (Ken Cox) [1371722 1383524]
- [netdrv] ixgbe: Add support to retrieve and store LED link active (Ken Cox) [1371722 1383524]
- [netdrv] ixgbe: Add X552 iXFI configuration helper function (Ken Cox) [1371722 1383524]
- [netdrv] ixgbe: fix panic when using macvlan with l2-fwd-offload enabled (Ken Cox) [1383524]
- [netdrv] ixgbe: enable tx queues after link up (Ken Cox) [1383524]
- [netdrv] ixgbe: reset before SRIOV init to avoid mailbox issues (Ken Cox) [1383524]
- [netdrv] ixgbe: Support 4 queue RSS on VFs with 1 or 2 queue RSS on PF (Ken Cox) [1383524]
- [netdrv] ixgbe: Limit reporting of redirection table if SR-IOV is enabled (Ken Cox) [1383524]
- [netdrv] ixgbe: Allow setting multiple queues when SR-IOV is enabled (Ken Cox) [1383524]
- [netdrv] ixgbe: Use MDIO_PRTAD_NONE consistently (Ken Cox) [1383524]
- [netdrv] ixgbe: Indicate support for pause frames in all cases (Ken Cox) [1383524]
- [netdrv] ixgbe: Resolve NULL reference by setting {read, write}_reg_mdi (Ken Cox) [1383524]
- [netdrv] ixgbe: make ixgbe_led_on/off_t_x550em static (Ken Cox) [1383524]
- [netdrv] ixgbe: simplify the logic for setting VLAN filtering (Ken Cox) [1383524]
- [netdrv] ptp_clock: future-proofing drivers against PTP subsystem becoming optional (Ken Cox) [1383524]
- [netdrv] ixgbe: use IS_ENABLED() instead of checking for built-in or module (Ken Cox) [1383524]
- [netdrv] ixgbe: Add support for new X557 device (Ken Cox) [1383524]
- [netdrv] ixgbe: add device to MDIO speed setting (Ken Cox) [1383524]
- [netdrv] ixgbe: Fix led interface for X557 devices (Ken Cox) [1383524]
- [netdrv] ixgbe: add support for geneve Rx offload (Ken Cox) [1383524]
- [netdrv] ixgbe: fully disable hardware RSC logic when disabling RSC (Ken Cox) [1383524]
- [netdrv] ixgbe: report correct media type for KR, KX and KX4 interfaces (Ken Cox) [1383524]
- [netdrv] ixgbe: Do not clear RAR entry when clearing VMDq for SAN MAC (Ken Cox) [1383524]
- [netdrv] ixgbe: use atomic bitwise operations when handling reset requests (Ken Cox) [1383524]
- [netdrv] ixgbe: only check Tx queue enablement when debugging (Ken Cox) [1383524]
- [netdrv] ixgbe: Re-enable ability to toggle VLAN filtering (Ken Cox) [1383524]
- [netdrv] ixgbe: Force VLNCTRL.VFE to be set in all VMDq paths (Ken Cox) [1383524]
- [netdrv] ixgbe: cleanup crosstalk fix (Ken Cox) [1383524]
- [netdrv] ixgbe: remove redundant check on ret_val (Ken Cox) [1383524]
- [netdrv] ixgbe: Add missing destroy_workqueue() on error in ixgbe_init_module() (Ken Cox) [1383524]
- [netdrv] ixgbe: Fix minor typo while freeing irq (Ken Cox) [1383524]
- [netdrv] ixgbe: Change register variable to unsigned (Ken Cox) [1383524]
- [netdrv] ixgbevf: Correct parameter sent to LED function (Ken Cox) [1383524]
- [netdrv] ixgbe: napi_poll must return the work done (Ken Cox) [1383524]
- [netdrv] ixgbe: fixup comments after "Future-proof tunnel offload handlers" (Ken Cox) [1383524]
- [netdrv] ixgbe: Correct reporting of timestamping for x550 (Ken Cox) [1383524]
- [netdrv] ethernet/intel: Use pci_(request|release)_mem_regions (Ken Cox) [1383524]
- [netdrv] ixgbe: Replace ndo_add/del_vxlan_port with ndo_add/del_udp_enc_port (Ken Cox) [1383524]
- [netdrv] ixgbe: Fix VLAN features error (Ken Cox) [1383524]
- [netdrv] ixgbe/ixgbevf: Add support for GSO partial (Ken Cox) [1383524]
- [netdrv] ixgbe/ixgbevf: Add support for bulk free in Tx cleanup & cleanup boolean logic (Ken Cox) [1383524]
- [netdrv] ixgbe: add a callback to set the maximum transmit bitrate (Ken Cox) [1383524]
- [netdrv] ixgbe: use eth_platform_get_mac_address() (Ken Cox) [1383524]
- [netdrv] ixgbe: bulk free SKBs during TX completion cleanup cycle (Ken Cox) [1383524]

* Wed Mar 08 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-594.el7]
- [net] bridge: set error code on failure (Ivan Vecera) [1352289]
- [net] bridge: multicast: restore perm router ports on multicast enable (Ivan Vecera) [1352289]
- [net] bridge: add the multicast_flood flag attribute to brport_attrs (Ivan Vecera) [1352289]
- [net] bridge: add address and vlan to fdb warning messages (Ivan Vecera) [1352289]
- [net] netfilter: bridge: clarify bridge/netfilter message (Ivan Vecera) [1352289]
- [net] bridge: add helper to call /sbin/bridge-stp (Ivan Vecera) [1352289]
- [net] bridge: add per-port multicast flood flag (Ivan Vecera) [1352289]
- [net] bridge: change unicast boolean to exact pkt_type (Ivan Vecera) [1352289]
- [net] bridge: don't increment tx_dropped in br_do_proxy_arp (Ivan Vecera) [1352289]
- [net] bridge: re-introduce 'fix parsing of MLDv2 reports' (Ivan Vecera) [1352289]
- [net] bridge: switchdev: Add forward mark support for stacked devices (Ivan Vecera) [1352289]
- [net] switchdev: Support parent ID comparison for stacked devices (Ivan Vecera) [1352289]
- [net] team: loadbalance: push lacpdus to exact delivery (Ivan Vecera) [1352289]
- [net] bridge: export also pvid flag in the xstats flags (Ivan Vecera) [1352289]
- [net] bridge: export vlan flags with the stats (Ivan Vecera) [1352289]
- [net] bridge: consolidate bridge and port linkxstats calls (Ivan Vecera) [1352289]
- [net] switchdev: Put export declaration in the right place (Ivan Vecera) [1352289]
- [net] bridge: Fix problems around fdb entries pointing to the bridge device (Ivan Vecera) [1352289]
- [net] bridge: Fix incorrect re-injection of LLDP packets (Ivan Vecera) [1352289]
- [net] bridge: br_set_ageing_time takes a clock_t (Ivan Vecera) [1352289]
- [net] bridge: fix br_stp_enable_bridge comment (Ivan Vecera) [1352289]
- [net] switchdev: change ageing_time type to clock_t (Ivan Vecera) [1352289]
- [net] bridge: remove _deliver functions and consolidate forward code (Ivan Vecera) [1352289]
- [net] bridge: drop skb2/skb0 variables and use a local_rcv boolean (Ivan Vecera) [1352289]
- [net] bridge: rearrange flood vs unicast receive paths (Ivan Vecera) [1352289]
- [net] bridge: minor style adjustments in br_handle_frame_finish (Ivan Vecera) [1352289]
- [net] bridge: extend MLD/IGMP query stats (Ivan Vecera) [1352289]
- [net] net_sched: fix mirrored packets checksum (Ivan Vecera) [1352289]
- [net] ipv4: Fix ip_skb_dst_mtu to use the sk passed by ip_finish_output (Ivan Vecera) [1352289]
- [net] bridge: add support for IGMP/MLD stats and export them via netlink (Ivan Vecera) [1352289]
- [net] rtnetlink: add support for the IFLA_STATS_LINK_XSTATS_SLAVE attribute (Ivan Vecera) [1352289]
- [net] bridge: fix vlan stats continue counter (Ivan Vecera) [1352289]
- [net] bridge: Fix ipv6 mc snooping if bridge has no ipv6 address (Ivan Vecera) [1352289]
- [net] bridge: Fix incorrect re-injection of STP packets (Ivan Vecera) [1352289]
- [net] bridge: fix igmp / mld query parsing (Ivan Vecera) [1352289]
- [net] bridge: fix old ioctl unlocked net device walk (Ivan Vecera) [1352289]
- [net] bridge: netlink: export per-vlan stats (Ivan Vecera) [1352289]
- [net] bridge: vlan: learn to count (Ivan Vecera) [1352289]
- [net] rtnetlink: add linkxstats callbacks and attribute (Ivan Vecera) [1352289]
- [net] rtnetlink: allow rtnl_fill_statsinfo to save private state counter (Ivan Vecera) [1352289]
- [net] bridge: fix potential use-after-free when hook returns QUEUE or STOLEN verdict (Ivan Vecera) [1352289]
- [net] bridge: mcast: add support for more router port information dumping (Ivan Vecera) [1352289]
- [net] bridge: mcast: add support for temporary port router (Ivan Vecera) [1352289]
- [net] bridge: mcast: do nothing if port's multicast_router is set to the same val (Ivan Vecera) [1352289]
- [net] bridge: mcast: use names for the different multicast_router types (Ivan Vecera) [1352289]
- [net] fix bridge multicast packet checksum validation (Ivan Vecera) [1352289]
- [net] bridge: use kobj_to_dev instead of to_dev (Ivan Vecera) [1352289]
- [net] netlink: Rightsize IFLA_AF_SPEC size calculation (Ivan Vecera) [1352289]
- [net] inet: ip_skb_dst_mtu() should use sk_fullsock() (Ivan Vecera) [1352289]
- [net] bridge: Add br_netif_receive_skb remove netif_receive_skb_sk (Ivan Vecera) [1352289]
- [net] bridge: Introduce br_send_bpdu_finish (Ivan Vecera) [1352289]
- [net] bridge: fix igmpv3 / mldv2 report parsing (Ivan Vecera) [1352289]
- [net] netfilter: bridge: fix IPv6 packets not being bridged with CONFIG_IPV6=n (Ivan Vecera) [1352289]
- [net] fix wrong skb_get() usage / crash in IGMP/MLD parsing code (Ivan Vecera) [1352289]
- [net] bridge: netlink: account for the IFLA_BRPORT_PROXYARP_WIFI attribute size and policy (Ivan Vecera) [1352289]
- [net] bridge: netlink: account for the IFLA_BRPORT_PROXYARP attribute size and policy (Ivan Vecera) [1352289]
- [net] bridge: Don't segment multiple tagged packets on bridge device (Ivan Vecera) [1352289]
- [net] bridge: stp: when using userspace stp stop kernel hello and hold timers (Ivan Vecera) [1352289]
- [net] bridge: mdb: notify on router port add and del (Ivan Vecera) [1352289]
- [net] bridge: Fix setting a flag in br_fill_ifvlaninfo_range(). (Ivan Vecera) [1352289]
- [net] bridge: mcast: fix br_multicast_dev_del warn when igmp snooping is not defined (Ivan Vecera) [1352289]
- [net] bridge: multicast: treat igmpv3 report with INCLUDE and no sources as a leave (Ivan Vecera) [1352289]
- [net] bridge: multicast: add a comment to br_port_state_selection about blocking state (Ivan Vecera) [1352289]
- [net] bridge: multicast: restore router configuration on port link down/up (Ivan Vecera) [1352289]
- [net] bridge: fix multicast router rlist endless loop (Ivan Vecera) [1352289]
- [net] bridge: fix br_multicast_query_expired() bug (Ivan Vecera) [1352289]
- [net] bridge: skip fdb add if the port shouldn't learn (Ivan Vecera) [1352289]
- [net] bridge: allow setting hash_max + multicast_router if interface is down (Ivan Vecera) [1352289]
- [net] bridge: change BR_GROUPFWD_RESTRICTED to allow forwarding of LLDP frames (Ivan Vecera) [1352289]
- [net] fix two sparse warnings introduced by IGMP/MLD parsing exports (Ivan Vecera) [1352289]
- [net] Export IGMP/MLD message validation code (Ivan Vecera) [1352289]
- [net] bridge: multicast: call skb_checksum_{simple_, }validate (Ivan Vecera) [1352289]
- [net] bridge/mdb: remove wrong use of NLM_F_MULTI (Ivan Vecera) [1352289]
- [net] act_mirred: Fix bogus header when redirecting from VLAN (Ivan Vecera) [1352289]
- [net] bridge: Extend Proxy ARP design to allow optional rules for Wi-Fi (Ivan Vecera) [1352289]
- [net] bridge: add compile-time assert for cb struct size (Ivan Vecera) [1352289]
- [net] mark some potential candidates __read_mostly (Ivan Vecera) [1352289]
- [net] bridge: reject DSA-enabled master netdevices as bridge members (Ivan Vecera) [1352289]
- [net] bridge: use MDBA_SET_ENTRY_MAX for maxtype in nlmsg_parse() (Ivan Vecera) [1352289]
- [net] bridge: only provide proxy ARP when CONFIG_INET is enabled (Ivan Vecera) [1352289]
- [net] bridge: Add ability to enable TSO (Ivan Vecera) [1352289]
- [net] bridge: Add missing policy entry for IFLA_BRPORT_FAST_LEAVE (Ivan Vecera) [1352289]
- [net] bridge: Add support for IEEE 802.11 Proxy ARP (Ivan Vecera) [1352289]
- [net] udp_tunnel: Only build ip6_udp_tunnel.c when IPV6 is selected (Ivan Vecera) [1352289]
- [net] dsa: reduce number of protocol hooks (Ivan Vecera) [1352289]
- [net] br_multicast: Replace rcu_assign_pointer() with RCU_INIT_POINTER() (Ivan Vecera) [1352289]
- [net] bridge: export knowledge about the presence of IGMP/MLD queriers (Ivan Vecera) [1352289]
- [net] bridge: adding stubs for multicast exports (Ivan Vecera) [1352289]
- [net] bridge: fix smatch warning / potential null pointer dereference (Ivan Vecera) [1352289]
- [net] bridge: fix compile error when compiling without IPv6 support (Ivan Vecera) [1352289]
- [net] bridge: memorize and export selected IGMP/MLD querier port (Ivan Vecera) [1352289]
- [net] bridge: un-comment br_multicast_list_adjacent() (Ivan Vecera) [1352289]
- [net] bridge: adhere to querier election mechanism specified by RFCs (Ivan Vecera) [1352289]
- [net] vlan: rename __vlan_find_dev_deep() to __vlan_find_dev_deep_rcu() (Ivan Vecera) [1352289]
- [net] netpoll: Remove gfp parameter from __netpoll_setup (Ivan Vecera) [1352289]
- [net] bridge: Use ether_addr_copy and ETH_ALEN (Ivan Vecera) [1352289]
- [net] bridge: fix netconsole setup over bridge (Ivan Vecera) [1352289]
- [net] bridge: use spin_lock_bh() in br_multicast_set_hash_max (Ivan Vecera) [1352289]
- [net] netlink: cleanup rntl_af_register (Ivan Vecera) [1352289]
- [net] bridge: change "foo* bar" to "foo *bar" (Ivan Vecera) [1352289]
- [net] bridge: add space before '(/{', after ', ', etc. (Ivan Vecera) [1352289]
- [net] bridge: remove unnecessary condition judgment (Ivan Vecera) [1352289]
- [net] more spelling fixes (Ivan Vecera) [1352289]
- [net] revert "bridge: only expire the mdb entry when query is received" (Ivan Vecera) [1352289]
- [net] bridge: update mdb expiration timer upon reports. (Ivan Vecera) [1352289]
- [net] Miscellaneous conversions to ETH_ALEN (Ivan Vecera) [1352289]
- [net] bridge: correct the comment for file br_sysfs_br.c (Ivan Vecera) [1352289]
- [net] bridge: fix rcu check warning in multicast port group (Ivan Vecera) [1352289]
- [net] bridge: cleanup netpoll code (Ivan Vecera) [1352289]
- [net] bridge: do not call setup_timer() multiple times (Ivan Vecera) [1352289]
- [net] bridge: fix some kernel warning in multicast timer (Ivan Vecera) [1352289]
- [net] bridge: fix a typo in comments (Ivan Vecera) [1352289]
- [net] bridge: only expire the mdb entry when query is received (Ivan Vecera) [1352289]
- [netdrv] phy: Don't increment MDIO bus refcount unless it's a different owner (Ivan Vecera) [1382040]
- [netdrv] phy: fixed_phy: fix of_node leak in fixed_phy_unregister (Ivan Vecera) [1382040]
- [netdrv] revert "phy: IRQ cannot be shared" (Ivan Vecera) [1382040]
- [netdrv] phy: Manage fixed PHY address space using IDA (Ivan Vecera) [1382040]
- [netdrv] phy: fixed: Fix removal of phys (Ivan Vecera) [1382040]
- [netdrv] phy: Avoid polling PHY with PHY_IGNORE_INTERRUPTS (Ivan Vecera) [1382040]
- [netdrv] phy: fix PHY_RUNNING in phy_state_machine (Ivan Vecera) [1382040]
- [netdrv] phy: Fix phy_mac_interrupt() (Ivan Vecera) [1382040]
- [netdrv] phy: fixed_phy: pass 'irq' to fixed_phy_add() (Ivan Vecera) [1382040]
- [netdrv] phy: fixed_phy: Add gpio to determine link up/down. (Ivan Vecera) [1382040]
- [netdrv] phy: fixed_phy: handle link-down case (Ivan Vecera) [1382040]
- [netdrv] phy: adjust fixed_phy_register() return value (Ivan Vecera) [1382040]
- [netdrv] revert "net: phy: Set the driver when registering an MDIO bus device" (Ivan Vecera) [1382040]
- [netdrv] phy: resume phydev when going to RESUMING (Ivan Vecera) [1382040]
- [netdrv] phy: Check for aneg completion before setting state to PHY_RUNNING (Ivan Vecera) [1382040]
- [netdrv] phylib: Remove unnecessary condition check in phy (Ivan Vecera) [1382040]
- [netdrv] phy: re-apply PHY fixups during phy_register_device (Ivan Vecera) [1382040]
- [netdrv] phy: expose phy_aneg_done API for use by drivers (Ivan Vecera) [1382040]
- [net] ethtool: export conversion function between u32 and link mode (Ivan Vecera) [1382040]
- [netdrv] mdio: Move mdiobus_read/write operatings into mdio.h (Ivan Vecera) [1382040]
- [netdrv] phy: Add nested variants of mdiobus read/write (Ivan Vecera) [1382040]
- [netdrv] phy: add phy_device_remove() (Ivan Vecera) [1382040]
- [netdrv] phy: fixed-phy: properly validate phy in fixed_phy_update_state() (Ivan Vecera) [1382040]
- [netdrv] of_mdio: fix MDIO phy device refcounting (Ivan Vecera) [1382040]
- [netdrv] phy: add proper phy struct device refcounting (Ivan Vecera) [1382040]
- [netdrv] phy: fix mdiobus module safety (Ivan Vecera) [1382040]
- [netdrv] phy: fix of_mdio_find_bus() device refcount leak (Ivan Vecera) [1382040]
- [netdrv] phy: add fixed_phy_update_state() - update state of fixed_phy (Ivan Vecera) [1382040]
- [netdrv] phy: Allow FIXED_PHY to be modular (Ivan Vecera) [1382040]
- [netdrv] phy: export fixed_phy_register() (Ivan Vecera) [1382040]
- [netdrv] phy: provide stub for fixed_phy_set_link_update (Ivan Vecera) [1382040]
- [netdrv] phy: fix sparse warning in fixed.c (Ivan Vecera) [1382040]
- [netdrv] phy: fixed: return an error for Clause 45 over 22 reads (Ivan Vecera) [1382040]
- [netdrv] phy: extend fixed driver with fixed_phy_register() (Ivan Vecera) [1382040]
- [netdrv] phy: decouple PHY id and PHY address in fixed PHY driver (Ivan Vecera) [1382040]
- [netdrv] phy: Ensure the MDIO bus module is held (Ivan Vecera) [1382040]
- [netdrv] phy: Set the driver when registering an MDIO bus device (Ivan Vecera) [1382040]
- [netdrv] mdio_bus: fix devm_mdiobus_alloc_size export (Ivan Vecera) [1382040]
- [netdrv] mdio_bus: implement devm_mdiobus_alloc/devm_mdiobus_free (Ivan Vecera) [1382040]
- [netdrv] phy: allow driver to implement their own aneg_done (Ivan Vecera) [1382040]
- [netdrv] phy: add genphy_aneg_done() (Ivan Vecera) [1382040]
- [netdrv] phy: cleanup 10g code (Ivan Vecera) [1382040]
- [netdrv] phylib: Support attaching to generic 10g driver (Ivan Vecera) [1382040]
- [netdrv] phylib: Add generic 10G driver (Ivan Vecera) [1382040]
- [netdrv] phylib: turn genphy_driver to an array (Ivan Vecera) [1382040]
- [netdrv] phylib: introduce PHY_INTERFACE_MODE_XGMII for 10G PHY (Ivan Vecera) [1382040]
- [netdrv] phylib: Add Clause 45 read/write functions (Ivan Vecera) [1382040]
- [netdrv] phylib: make phy_scan_fixups() static (Ivan Vecera) [1382040]
- [netdrv] phylib: remove unused adjust_state() callback (Ivan Vecera) [1382040]
- [netdrv] phy: kill excess empty lines (Ivan Vecera) [1382040]
- [netdrv] phy: kill excess code (Ivan Vecera) [1382040]
- [netdrv] phy: kill useless local variables (Ivan Vecera) [1382040]
- [netdrv] phy: coding style fixes (Ivan Vecera) [1382040]
- [netdrv] phy: coding style fixes (Ivan Vecera) [1382040]
- [netdrv] phy: IRQ cannot be shared (Ivan Vecera) [1382040]
- [netdrv] phy: fix checkpatch errors (Ivan Vecera) [1382040]
- [netdrv] phy: suspend phydev when going to HALTED (Ivan Vecera) [1382040]
- [netdrv] phy: resume/suspend PHYs on attach/detach (Ivan Vecera) [1382040]
- [netdrv] phy: provide phy_resume/phy_suspend helpers (Ivan Vecera) [1382040]
- [netdrv] phy: consolidate PHY reset in phy_init_hw() (Ivan Vecera) [1382040]
- [netdrv] phy: use phy_init_hw instead of open-coding it (Ivan Vecera) [1382040]
- [netdrv] phy: allow drivers to flag a PHY device as internal (Ivan Vecera) [1382040]
- [netdrv] phy: add phy_mac_interrupt() to use with PHY_IGNORE_INTERRUPT (Ivan Vecera) [1382040]
- [netdrv] phy: fix the use of PHY_IGNORE_INTERRUPT (Ivan Vecera) [1382040]
- [netdrv] phylib: queue work on system_power_efficient_wq (Ivan Vecera) [1382040]

* Wed Mar 08 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-593.el7]
- [fs] fsnotify: Remove fsnotify_duplicate_mark() (Miklos Szeredi) [1427454]
- [fs] fsnotify: Fix possible use-after-free in inode iteration on umount (Miklos Szeredi) [1427454]
- [fs] fsnotify: constify the places working with ->f_path (Miklos Szeredi) [1427454]
- [fs] constify fsnotify_parent() (Miklos Szeredi) [1427454]
- [fs] fsnotify: constify 'data' (Miklos Szeredi) [1427454]
- [fs] fsnotify: constify 'data' passed to ->handle_event() (Miklos Szeredi) [1427454]
- [fs] fsnotify: clean up spinlock assertions (Miklos Szeredi) [1427454]
- [fs] fanotify: fix possible false warning when freeing events (Miklos Szeredi) [1427454]
- [fs] fanotify: use notification_lock instead of access_lock (Miklos Szeredi) [1427454]
- [fs] fsnotify: convert notification_mutex to a spinlock (Miklos Szeredi) [1427454]
- [fs] fsnotify: drop notification_mutex before destroying event (Miklos Szeredi) [1427454]
- [fs] fsnotify: support overlayfs (Miklos Szeredi) [1427454]
- [fs] fsnotify: avoid spurious EMFILE errors from inotify_init() (Miklos Szeredi) [1421964]
- [fs] fsnotify: turn fsnotify reaper thread into a workqueue job (Miklos Szeredi) [1427454]
- [fs] fs/notify/inode_mark.c: use list_next_entry in fsnotify_unmount_inodes (Miklos Szeredi) [1427454]
- [fs] inotify: actually check for invalid bits in sys_inotify_add_watch() (Miklos Szeredi) [1427454]
- [fs] inotify: hide internal kernel bits from fdinfo (Miklos Szeredi) [1427454]
- [fs] fsnotify: get rid of fsnotify_destroy_mark_locked() (Miklos Szeredi) [1427454]
- [fs] fsnotify: remove mark->free_list (Miklos Szeredi) [1427454]
- [fs] fsnotify: document mark locking (Miklos Szeredi) [1427454]
- [fs] fsnotify: fix check in inotify fdinfo printing (Miklos Szeredi) [1427454]
- [fs] notify: optimize inotify/fsnotify code for unwatched files (Miklos Szeredi) [1427454]
- [fs] fsnotify: remove obsolete documentation (Miklos Szeredi) [1427454]
- [fs] notify: don't use module_init for non-modular inotify_user code (Miklos Szeredi) [1427454]
- [fs] fanotify: fix event filtering with FAN_ONDIR set (Miklos Szeredi) [1427454]
- [fs] fanotify: don't set FAN_ONDIR implicitly on a marks ignored mask (Miklos Szeredi) [1427454]
- [fs] fanotify: don't recalculate a marks mask if only the ignored mask changed (Miklos Szeredi) [1427454]
- [fs] fanotify: only destroy mark when both mask and ignored_mask are cleared (Miklos Szeredi) [1427454]
- [fs] sched, fanotify: Deal with nested sleeps (Miklos Szeredi) [1427454]
- [fs] fsnotify: remove destroy_list from fsnotify_mark (Miklos Szeredi) [1427454]
- [fs] fsnotify: unify inode and mount marks handling (Miklos Szeredi) [1427454]
- [fs] sched, inotify: Deal with nested sleeps (Miklos Szeredi) [1427454]
- [fs] fanotify: enable close-on-exec on events' fd when requested in fanotify_init() (Miklos Szeredi) [1427454]
- [fs] fsnotify: don't put user context if it was never assigned (Miklos Szeredi) [1427454]
- [fs] fs/notify/group.c: make fsnotify_final_destroy_group() static (Miklos Szeredi) [1427454]
- [fs] notify: don't show f_handle if exportfs_encode_inode_fh failed (Miklos Szeredi) [1427454]
- [fs] fsnotify/fdinfo: use named constants instead of hardcoded values (Miklos Szeredi) [1427454]
- [fs] inotify: convert use of typedef ctl_table to struct ctl_table (Miklos Szeredi) [1427454]
- [fs] fanotify: check file flags passed in fanotify_init (Miklos Szeredi) [1427454]
- [fs] fs/notify/fanotify/fanotify_user.c: fix FAN_MARK_FLUSH flag checking (Miklos Szeredi) [1427454]
- [fs] fs/notify/mark.c: trivial cleanup (Miklos Szeredi) [1427454]
- [fs] fanotify: fan_mark_flush: avoid having to provide a fake/invalid fd and path (Miklos Szeredi) [1427454]
- [fs] fanotify: move unrelated handling from copy_event_to_user() (Miklos Szeredi) [1427454]
- [fs] fanotify: reorganize loop in fanotify_read() (Miklos Szeredi) [1427454]
- [fs] fsnotify: update comments concerning locking scheme (Miklos Szeredi) [1427454]
- [fs] inotify: fix race when adding a new watch (Miklos Szeredi) [1427454]
- [fs] dnotify: replace dnotify_mark_mutex with mark mutex of dnotify_group (Miklos Szeredi) [1427454]
- [fs] fanotify: put duplicate code for adding vfsmount/inode marks into an own function (Miklos Szeredi) [1427454]
- [fs] fanotify: fix races when adding/removing marks (Miklos Szeredi) [1427454]
- [fs] fanotify: quit wanking with FASYNC in ->release() (Miklos Szeredi) [1427454]
- [fs] devpts: clean up interface to pty drivers (Miklos Szeredi) [1421008]
- [fs] devpts: if initialization failed, don't crash when opening /dev/ptmx (Miklos Szeredi) [1421008]

* Wed Mar 08 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-592.el7]
- [fs] xfs: undo block reservation correctly in xfs_trans_reserve() (Eric Sandeen) [1425557]
- [fs] xfs: reset b_first_retry_time when clear the retry status of xfs_buf_t (Eric Sandeen) [1425557]
- [fs] xfs: clear _XBF_PAGES from buffers when readahead page (Eric Sandeen) [1425557]
- [fs] xfs: don't wrap ID in xfs_dq_get_next_id (Eric Sandeen) [1425557 1418182 1405626]
- [fs] xfs: don't print warnings when xfs_log_force fails (Eric Sandeen) [1425557]
- [fs] xfs: fix max_retries _show and _store functions (Eric Sandeen) [1425557]
- [fs] xfs: ignore leaf attr ichdr.count in verifier during log replay (Eric Sandeen) [1425557]
- [fs] xfs: pass state not whichfork to trace_xfs_extlist (Eric Sandeen) [1425557]
- [fs] xfs: set AGI buffer type in xlog_recover_clear_agi_bucket (Eric Sandeen) [1425557]
- [fs] xfs: fix unbalanced inode reclaim flush locking (Eric Sandeen) [1425557]
- [fs] xfs: check minimum block size for CRC filesystems (Eric Sandeen) [1425557]
- [fs] xfs: fix up xfs_swap_extent_forks inline extent handling (Eric Sandeen) [1425557 1412945]
- [fs] xfs: don't call xfs_sb_quota_from_disk twice (Eric Sandeen) [1425557]
- [fs] xfs: clean up _calc_dquots_per_chunk (Eric Sandeen) [1425557]
- [fs] xfs: normalize "infinite" retries in error configs (Eric Sandeen) [1425557]
- [fs] xfs: fix signed integer overflow (Eric Sandeen) [1425557]
- [fs] xfs: fix superblock inprogress check (Eric Sandeen) [1425557]
- [fs] gfs2: Avoid alignment hole in struct lm_lockname (Robert S Peterson) [1425450]
- [fs] gfs2: Add missing rcu locking for glock lookup (Robert S Peterson) [1425450]
- [fs] nfs: Ignore connections that have cl_rpcclient uninitialized (Benjamin Coddington) [1421557]
- [fs] nfsv4: fix getacl ERANGE for some ACL buffer sizes ("J. Bruce Fields") [1427974]
- [fs] nfsv4: fix getacl head length estimation ("J. Bruce Fields") [1427974]
- [fs] sunrpc: replace generic auth_cred hash with auth-specific function (Frank Sorenson) [1371693]
- [fs] sunrpc: add RPCSEC_GSS hash_cred() function (Frank Sorenson) [1371693]
- [fs] sunrpc: add auth_unix hash_cred() function (Frank Sorenson) [1371693]
- [fs] sunrpc: add generic_auth hash_cred() function (Frank Sorenson) [1371693]
- [fs] sunrpc: add hash_cred() function to rpc_authops struct (Frank Sorenson) [1371693]

* Wed Mar 08 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-591.el7]
- [netdrv] scripts/spelling.txt: add "varible" pattern and fix typo instances (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Invoke softirqs after napi_reschedule (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: remove duplicate device id from PCI table (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: mark the value passed to csum_replace_by_diff as __wsum (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Error handling for link event (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: properly convert le16 value to CPU format (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: convert to cpu from le16 to generate switch_id correctly (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: refactor AQ CMD buffer debug printing (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix Adaptive ITR enabling (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: remove unnecessary call to i40e_update_link_info (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: enable mc magic pkt wakeup during power down (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix disable overflow promiscuous mode (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Save more link abilities when using ethtool (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: avoid race condition when sending filters to firmware for addition (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: allow i40e_update_filter_state to skip broadcast filters (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: don't warn every time we clear an Rx timestamp register (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Save link FEC info from link up event (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add bus number info to i40e_bus_info struct (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Clean up dead code (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf : Changed version from 1.6.25 to 1.6.27 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: update comment explaining where FDIR buffers are freed (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: eliminate i40e_pull_tail() (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Moves skb from i40e_rx_buffer to i40e_ring (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Limit DMA sync of RX buffers to actual packet size (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: don't check params until after checking for client instance (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: add interrupt rate limit verbosity (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: refactor macro INTRL_USEC_TO_REG (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: remove unused function (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Quick refactor to start moving data off stack and into Tx buffer info (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: remove unnecessary __packed (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Deprecating unused macro (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: when adding or removing MAC filters, correctly handle VLANs (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: avoid O(n^2) loop when deleting all filters (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: rename i40e_put_mac_in_vlan and i40e_del_mac_all_vlan (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: no need to check is_vsi_in_vlan before calling i40e_del_mac_all_vlan (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fold the i40e_is_vsi_in_vlan check into i40e_put_mac_in_vlan (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: don't allow i40e_vsi_(add|kill)_vlan to operate when VID<1 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: don't truncate match_method assignment (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: move all updates for VLAN mode into i40e_sync_vsi_filters (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: use (add|rm)_vlan_all_mac helper functions when changing PVID (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: factor out addition/deletion of VLAN per each MAC address (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: delete filter after adding its replacement when converting (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: refactor i40e_update_filter_state to avoid passing aq_err (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: recalculate vsi->active_filters from hash contents (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: defeature support for PTP L4 frame detection on XL710 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: lock service task correctly (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add functions which apply correct PHY access method for read and write operation (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add FEC for 25g (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add support for 25G devices (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: use unsigned printf format specifier for active_filters count (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] Changed version from 1.6.21 to 1.6.25 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Blink LED on 1G BaseT boards (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: remove code to handle dev_addr specially (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: napi_poll must return the work done (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: restore workaround for removing default MAC filter (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: simplify txd use count calculation (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Driver prints log message on link speed change (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: change message to only appear when extra debug info is wanted (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: replace for memcpy with single memcpy call in ethtool (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: set broadcast promiscuous mode for each active VLAN (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix for ethtool Supported link modes (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Pass unknown PHY type for unknown PHYs (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Remove unreachable code (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix panic on SPARC while changing num of desc (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add protocols over MCTP to i40e_aq_discover_capabilities (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix trivial typo in naming of i40e_sync_filters_subtask (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add Clause22 implementation (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: avoid duplicate private flags definitions (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: remove second check of VLAN_N_VID in i40e_vlan_rx_add_vid (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: remove error_param_int label from i40e_vc_config_promiscuous_mode_msg (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Be much more verbose about what we can and cannot offload (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: removed unreachable code (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Implementation of ERROR state for NVM update state machine (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix for division by zero (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: clear mac filter count on reset (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Reorder logic for coalescing RS bits (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add common function for finding VSI by type (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: replace PTP Rx timestamp hang logic (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: use a mutex instead of spinlock in PTP user entry points (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: correct check for reading TSYNINDX from the receive descriptor (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: remove duplicate add/delete adminq command code for filters (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: avoid looping to check whether we're in VLAN mode (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix MAC filters when removing VLANs (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: properly cleanup on allocation failure in i40e_sync_vsi_filters (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: store MAC/VLAN filters in a hash with the MAC Address as key (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: implement __i40e_del_filter and use where applicable (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: When searching all MAC/VLAN filters, ignore removed filters (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: refactor i40e_put_mac_in_vlan to avoid changing f->vlan (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: move i40e_put_mac_in_vlan and i40e_del_mac_all_vlan (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: make use of __dev_uc_sync and __dev_mc_sync (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: drop is_vf and is_netdev fields in struct i40e_mac_filter (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add missing \n to end of dev_err message (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: disable MSI-X interrupts if we cannot reserve enough vectors (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix configure TCs after initial DCB disable (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Clean up handling of msglevel flags and debug parameter (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix bit logic error in failure case (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Changed version from 1.6.19 to 1.6.21 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Removal of workaround for simple MAC address filter deletion (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix for long link down notification time (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Drop redundant Rx descriptor processing code (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix confusing dmesg info for ethtool -L option (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Make struct i40e_stats const (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Changed version from 1.6.16 to 1.6.19 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: fix interrupt affinity bug (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: group base mode VF offload flags (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: reopen client after reset (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Drop code for unsupported flow types (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Remove unused function i40e_vsi_lookup (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Bit test mask correction (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Rewrite Flow Director busy wait loop (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix client interaction (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: avoid NULL pointer dereference and recursive errors on early PCI error (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix sideband flow director vector allocation (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix MSI-X vector redistribution if hw limit is reached (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: check if vectors are already depleted when doing VMDq allocation (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40evf: support queue-specific settings for interrupt moderation (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: don't configure zero-size RSS table (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Strip out debugfs hook for Flow Director filter programming (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Split Flow Director descriptor config into separate function (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Add txring_txq function to match fm10k and ixgbe (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix Flow Director raw_buf cleanup (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Increase minimum number of allocated VSI (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Changed version to 1.6.16 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: removing unreachable code (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: check conflicting ntuple/sideband rules when re-enabling ATR (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: cleanup ATR auto_disable_flags use (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: add encap csum VF offload flag (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix deleting mac filters (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Remove 100 Mbps SGMII support for X722 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Limit TX descriptor count in cases where frag size is greater than 16K (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix for extra byte swap in tunnel setup (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix to check for NULL (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: return correct opcode to VF (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix "dump port" command when NPAR enabled (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix setting user defined RSS hash key (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] ptp_clock: future-proofing drivers against PTP subsystem becoming optional (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix kernel panic on enable/disable LLDP (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Fix indentation (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Remove XSTRINGIFY macro definitions and uses (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: use matching format identifiers (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add support for HMC resource and profile for X722 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix byte ordering in ARP NS code for X722 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: refactor tail_bump check (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: use alloc_workqueue instead of create_singlethread_workqueue (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Expose 'trust' flag to userspace via ndo_get_vf_config (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: remove a stray unlock (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf-Bump version from 1.6.11 to 1.6.12 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Allow RSS Hash set with less than four parameters (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix memory leak (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix lookup table when RSS disabled/enabled (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Don't notify client of VF reset during VF creation (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: don't allow reduction of channels below active FD rules (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix static analysis tool warning (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: reset RX csum error stat with other pf stats (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Reset VLAN filter count when resetting (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix a bug where a client close can be called before an open is complete (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Use list_move instead of list_del/list_add (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] ethernet/intel: Use pci_(request|release)_mem_regions (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Explicitly write platform-specific mac address after PF reset (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: add missing link advertise setting (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf-bump version to 1.6.11 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: refactor Rx filter handling (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Remove device ID 0x37D4 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: remove useless initializer (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix to show correct Advertised Link Modes when link is down (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: avoid null pointer dereference (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: use valid online CPU on q_vector initialization (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: enable VSI broadcast promiscuous mode instead of adding broadcast filter (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Fix i40e_rx_checksum (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Bump version from 1.5.16 to 1.6.4 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: add VSI info to macaddr messages (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: set default VSI without a reset (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Fix RSS to not be limited by the number of CPUs (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Removing unnecessary code which caused supported link mode bug (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix missing DA cable check (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Save PCI state before suspend (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Clean up MSIX IRQs before suspend (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add a call to set the client interface down (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: write HENA for VFs (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: add hw struct local variable (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: add functions to control default VSI (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Move all UDP port notifiers to single function (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix an uninitialized variable bug (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Bump version from 1.5.10 to 1.5.16 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: don't add broadcast filter for VFs (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: properly report Rx packet hash (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: set context to use VSI RSS LUT for SR-IOV (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Correct UDP packet header for non_tunnel-ipv6 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: change Rx hang message into a WARN_ONCE (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Refactor ethtool get_settings (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: lie to the VF (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add vf-true-promisc-support priv flag (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Implement the API function for aq_set_switch_config (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Add support for disabling all link and change bits needed for PHY interactions (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fix misleading indentation (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Test memory before ethtool alloc succeeds (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Remove unused hardware receive descriptor code (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40evf: Drop packet split receive routine (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Refactor receive routine (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Remove reference to ring->dtype (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: Drop packet split receive routine (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Refactor tunnel interpretation (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: Add support for GSO partial with UDP_TUNNEL_CSUM and GRE_CSUM (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: make use of BIT() macro to prevent left shift of signed values (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e/i40evf: fix I40E_MASK signed shift overflow warnings (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: keep VFs trusted by default (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fixup of commit 4e312a9e3b (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fixup of commit f77ccd1220 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: fixup of commit e306fbc5e1 (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40e: remove RHEL-only FCOE message (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]
- [netdrv] i40iw: remove tech-preview (Stefan Assmann) [1374546 1390452 1390449 1385344 1384456 1378964 1371500 1348490 1383521]

* Tue Mar 07 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-590.el7]
- [kernel] acpi / hotplug / pci: Make device_is_managed_by_native_pciehp() public (Myron Stowe) [1418060]
- [pci] acpi / hotplug / pci: Use cached copy of PCI_EXP_SLTCAP_HPC bit (Myron Stowe) [1418060]
- [pci] Unfold conditions to block runtime PM on PCIe ports (Myron Stowe) [1418060]
- [pci] Consolidate conditions to allow runtime PM on PCIe ports (Myron Stowe) [1418060]
- [pci] Activate runtime PM on a PCIe port only if it can suspend (Myron Stowe) [1418060]
- [pci] Speed up algorithm in pci_bridge_d3_update() (Myron Stowe) [1418060]
- [pci] Autosense device removal in pci_bridge_d3_update() (Myron Stowe) [1418060]
- [pci] Don't acquire ref on parent in pci_bridge_d3_update() (Myron Stowe) [1418060]
- [pci] pciehp: Clear attention LED on device add (Myron Stowe) [1418060]
- [pci] Fix bridge_d3 update on device removal (Myron Stowe) [1418060]
- [pci] acpi / hotplug / pci: Runtime resume bridges before bus rescans (Myron Stowe) [1418060]
- [pci] pciehp: Ignore interrupts during D3cold (Myron Stowe) [1418060]
- [pci] Add runtime PM support for PCIe ports (Myron Stowe) [1418060]
- [pci] Power on bridges before scanning new devices (Myron Stowe) [1418060]
- [kernel] pci: Put PCIe ports into D3 during suspend (Myron Stowe) [1418060]
- [pci] Don't clear d3cold_allowed for PCIe ports (Myron Stowe) [1418060]
- [pci] pci / pm: Tune down retryable runtime suspend error messages (Myron Stowe) [1418060]
- [acpi] invoke acpi_device_wakeup() with correct parameters (Myron Stowe) [1418060]
- [pci] Shuffle pci-acpi.c functions to group them logically (Myron Stowe) [1418060]
- [acpi] acpi / pm: Always enable wakeup GPEs when enabling device wakeup (Myron Stowe) [1418060]
- [kernel] acpi / pm: Revork the handling of ACPI device wakeup notifications (Myron Stowe) [1418060]
- [kernel] pm: Create PM workqueue if runtime PM is not configured too (Myron Stowe) [1418060]
- [kernel] acpi: Clean up inclusions of ACPI header files (Myron Stowe) [1418060]
- [kernel] tracing: Fix return value of ftrace_raw_output_prep() (Pratyush Anand) [1365958]
- [kernel] tracing: remove unused ftrace_output_event() prototype (Pratyush Anand) [1365958]
- [kernel] tracing: Fix hwlat kthread migration (Pratyush Anand) [1365958]
- [kernel] tracing: Have max_latency be defined for HWLAT_TRACER as well (Pratyush Anand) [1365958]
- [kernel] tracing: #ifdef out uses of max trace when CONFIG_TRACER_MAX_TRACE is not set (Pratyush Anand) [1365958]
- [kernel] tracing: Add NMI tracing in hwlat detector (Pratyush Anand) [1365958]
- [kernel] tracing: Have hwlat trace migrate across tracing_cpumask CPUs (Pratyush Anand) [1365958]
- [kernel] tracing: Add documentation for hwlat_detector tracer (Pratyush Anand) [1365958]
- [kernel] tracing: Added hardware latency tracer (Pratyush Anand) [1365958]
- [kernel] tracing: Make tracing_cpumask available for all instances (Pratyush Anand) [1365958]
- [kernel] tracing: Set up infrastructure to allow tracers for instances (Pratyush Anand) [1365958]
- [kernel] tracing: Move tracing_max_latency into trace_array (Pratyush Anand) [1365958]
- [kernel] tracing: Pass trace_array to flag_changed callback (Pratyush Anand) [1365958]
- [kernel] tracing: Pass trace_array to set_flag callback (Pratyush Anand) [1365958]
- [kernel] tracing: Add trace_seq_has_overflowed() and trace_handle_return() (Pratyush Anand) [1365958]
- [kernel] tracing: Move raw output code from macro to standalone function (Pratyush Anand) [1365958]
- [kernel] tracing: Add entry->next_cpu to trace_ctxwake_bin() (Pratyush Anand) [1365958]
- [kernel] tracing: Use trace_seq_puts()/trace_seq_putc() where possible (Pratyush Anand) [1365958]
- [kernel] x86/xen/kdump: Replace CONFIG_KEXEC with CONFIG_KEXEC_CORE (Xunlei Pang) [1415443]
- [kernel] revert "x86/panic: Replace CONFIG_KEXEC_CORE with CONFIG_KEXEC" (Xunlei Pang) [1415443]
- [kernel] kexec: move some memembers and definitions within the scope of CONFIG_KEXEC_FILE (Xunlei Pang) [1415443]
- [kernel] kexec: split kexec_load syscall from kexec core code (Xunlei Pang) [1415443]
- [kernel] kexec: split kexec_file syscall code to kexec_file.c (Xunlei Pang) [1415443]
- [kernel] use macros from compiler.h instead of __attribute__((...)) (Xunlei Pang) [1415443]
- [kernel] kexec, kconfig: spell "architecture" properly (Xunlei Pang) [1415443]
- [kernel] kexec: simplify conditional (Xunlei Pang) [1415443]
- [kernel] kexec: remove never used member destination in kimage (Xunlei Pang) [1415443]
- [kernel] kexec: fix a typo in comment (Xunlei Pang) [1415443]
- [kernel] kexec: allocate the kexec control page with KEXEC_CONTROL_MEMORY_GFP (Xunlei Pang) [1415443]
- [kernel] kexec: remove unnecessary KERN_ERR from kexec.c (Xunlei Pang) [1415443]
- [kernel] kexec: remove the unused function parameter (Xunlei Pang) [1415443]
- [kernel] kexec: take the segment adding out of locate_mem_hole functions (Xunlei Pang) [1415443]
- [net] netfilter: conntrack: validate SCTP crc32c in PREROUTING (Davide Caratti) [1353218]
- [net] netfilter: select LIBCRC32C together with SCTP conntrack (Davide Caratti) [1353218]
- [net] netfilter: nat: skip checksum on offload SCTP packets (Davide Caratti) [1401578]
- [net] dccp: fix freeing skb too early for IPV6_RECVPKTINFO (Hannes Frederic Sowa) [1423463] {CVE-2017-6074}
- [scsi] lpfc: Fix eh_deadline setting for sli3 adapters (Ewan Milne) [1366564]
- [scsi] mpt2sas: fix a print at driver exit and change version string (Tomas Henzl) [1417040]
- [scsi] mpt3sas: Updating driver version to v15.100.00.00 (Tomas Henzl) [1417040]
- [scsi] mpt3sas: Fix Firmware fault state 0x2100 during heavy 4K RR FIO stress test (Tomas Henzl) [1417040]
- [scsi] mpt3sas: Fix for Crusader to achieve product targets with SAS devices (Tomas Henzl) [1417040]
- [scsi] mpt3sas: Added print to notify cable running at a degraded speed (Tomas Henzl) [1417040]
- [scsi] mpt3sas: disable ASPM for MPI2 controllers (Tomas Henzl) [1417040]
- [scsi] mpt3sas: Force request partial completion alignment (Tomas Henzl) [1418286]
- [scsi] libfc: Don't have fc_exch_find log errors on a new exchange (Chris Leech) [1378320]
- [net-next] treewide: use is_vlan_dev() helper function (Maurizio Lombardi) [1385134]
- [scsi] bnx2fc: Mark symbols static where possible (Maurizio Lombardi) [1385134]
- [scsi] bnx2fc: Simplify code (Maurizio Lombardi) [1385134]

* Tue Mar 07 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-589.el7]
- [md] dm round robin: revert "use percpu 'repeat_count' and 'current_path'" (Mike Snitzer) [1422567]
- [md] dm rq: cope with DM device destruction while in dm_old_request_fn() (Mike Snitzer) [1412854]
- [x86] ptp_kvm: try to detect hypercall availability (Marcelo Tosatti) [1419783]
- [x86] ptp: add kvm PTP driver (Marcelo Tosatti) [1419783]
- [x86] kvm: x86: add KVM_HC_CLOCK_PAIRING hypercall (Marcelo Tosatti) [1419783]
- [x86] kvmclock: export kvmclock clocksource pointer (Marcelo Tosatti) [1419783]
- [x86] perf/x86/amd/uncore: Update sysfs attributes for Family17h processors (Suravee Suthikulpanit) [1391664 1391662]
- [x86] perf/x86/amd/uncore: Update the number of uncore counters (Suravee Suthikulpanit) [1391664 1391662]
- [x86] perf/x86/amd/uncore: Rename 'L2' to 'LLC' (Suravee Suthikulpanit) [1391664 1391662]
- [fs] binfmt_elf.c:load_elf_binary(): return -EINVAL on zero-length mappings (Bhupesh Sharma) [1415893]
- [kernel] mm: fold arch_randomize_brk into ARCH_HAS_ELF_RANDOMIZE (Bhupesh Sharma) [1415893]
- [fs] mm: split ET_DYN ASLR from mmap ASLR (Bhupesh Sharma) [1415893]
- [s390] redefine randomize_et_dyn for ELF_ET_DYN_BASE (Bhupesh Sharma) [1415893]
- [kernel] mm: expose arch_mmap_rnd when available (Bhupesh Sharma) [1415893]
- [s390] standardize mmap_rnd() usage (Bhupesh Sharma) [1415893]
- [s390] mmap: randomize mmap base for bottom up direction (Bhupesh Sharma) [1415893]
- [powerpc] standardize mmap_rnd() usage (Bhupesh Sharma) [1415893]
- [x86] standardize mmap_rnd() usage (Bhupesh Sharma) [1415893]
- [fs] binfmt_elf.c: fix bug in loading of PIE binaries (Bhupesh Sharma) [1415893]
- [lib] locking/spinlock/debug: Remove spinlock lockup detection code (Waiman Long) [1425209]
- [tools] cpupower: Fix no-rounding MHz frequency output (Prarit Bhargava) [1427742]
- [crypto] mcryptd - Check mcryptd algorithm compatibility (Herbert Xu) [1402133] {CVE-2016-10147}
- [crypto] mcryptd - process CRYPTO_ALG_INTERNAL (Herbert Xu) [1402133] {CVE-2016-10147}
- [crypto] vmx - Fix memory corruption caused by p8_ghash (Gustavo Duarte) [1403693]
- [crypto] ghash-generic - move common definitions to a new header file (Gustavo Duarte) [1403693]
- [crypto] vmx - Increase priority of aes-cbc cipher (Gustavo Duarte) [1403693]
- [crypto] vmx - Fix ABI detection (Gustavo Duarte) [1403693]
- [crypto] vmx - comply with ABIs that specify vrsave as reserved (Gustavo Duarte) [1403693]
- [crypto] vmx - fix null dereference in p8_aes_xts_crypt (Gustavo Duarte) [1391563]
- [crypto] vmx - Fix aes_p8_xts_decrypt build failure (Gustavo Duarte) [1391563]
- [crypto] vmx - Adding asm subroutines for XTS (Gustavo Duarte) [1391563]
- [crypto] vmx - Adding support for XTS (Gustavo Duarte) [1391563]
- [kernel] printk: Do not disable preemption for accessing printk_func (Scott Wood) [1427305]
- [firmware] dmi_scan: add SBMIOS entry and DMI tables (Prarit Bhargava) [1386195]
- [firmware] efi: dmi: List SMBIOS3 table before SMBIOS table (Prarit Bhargava) [1386195]
- [platform] x86: thinkpad_acpi: Initialize local in_tablet_mode and type (Lyude Paul) [1389438]
- [platform] x86: thinkpad_acpi: Add support for X1 Yoga (2016) Tablet Mode (Lyude Paul) [1389438]
- [platform] x86: thinkpad_acpi: Move tablet detection into separate function (Lyude Paul) [1389438]

* Mon Mar 06 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-588.el7]
- [documentation] x86/boot: Fix KASLR and memmap= collision (Baoquan He) [1290840]
- [documentation] x86, boot: Fix warning due to undeclared strlen() (Baoquan He) [1290840]
- [documentation] x86/mm: Refactor KASLR entropy functions (Baoquan He) [1290840]
- [documentation] x86/power/64: Use __pa() for physical address computation (Baoquan He) [1290840]
- [documentation] x86/power/64: Always create temporary identity mapping correctly (Baoquan He) [1290840]
- [documentation] x86/power/64: Do not refer to __PAGE_OFFSET from assembly code (Baoquan He) [1290840]
- [documentation] x86/kaslr, x86/power: Remove x86 hibernation restrictions (Baoquan He) [1290840]
- [documentation] x86/power/64: Fix kernel text mapping corruption during image restoration (Baoquan He) [1290840]
- [documentation] x86/asm, x86/power/hibernate: Use local labels in asm (Baoquan He) [1290840]
- [documentation] x86/doc: Correct limits in Documentation/x86/x86_64/mm.txt (Baoquan He) [1290840]
- [documentation] x86/kaslr: Fix typo in the KASLR_FLAG documentation (Baoquan He) [1290840]
- [x86] 64: Disable the mm track code during boot stage (Baoquan He) [1290840]
- [x86] __force_order doesn't need to be an actual variable (Baoquan He) [1290840]
- [x86] kaslr: Fix boot crash with certain memory configurations (Baoquan He) [1290840]
- [x86] kaslr: Allow randomization below the load address (Baoquan He) [1290840]
- [x86] kaslr: Extend kernel image physical address randomization to addresses larger than 4G (Baoquan He) [1290840]
- [x86] kaslr: Randomize virtual address separately (Baoquan He) [1290840]
- [x86] kaslr: Clarify identity map interface (Baoquan He) [1290840]
- [x86] boot: Refuse to build with data relocations (Baoquan He) [1290840]
- [x86] kaslr: Clarify purpose of each get_random_long() (Baoquan He) [1290840]
- [x86] kaslr: Add virtual address choosing function (Baoquan He) [1290840]
- [x86] kaslr: Return earliest overlap when avoiding regions (Baoquan He) [1290840]
- [x86] kaslr: Add 'struct slot_area' to manage random_addr slots (Baoquan He) [1290840]
- [x86] boot: Add missing file header comments (Baoquan He) [1290840]
- [x86] kaslr: Initialize mapping_info every time (Baoquan He) [1290840]
- [x86] boot: Comment what finalize_identity_maps() does (Baoquan He) [1290840]
- [x86] kaslr: Build identity mappings on demand (Baoquan He) [1290840]
- [x86] boot: Split out kernel_ident_mapping_init() (Baoquan He) [1290840]
- [x86] boot: Clean up indenting for asm/boot.h (Baoquan He) [1290840]
- [x86] boot: Double BOOT_HEAP_SIZE to 64KB (Baoquan He) [1290840]
- [x86] kaslr: Improve comments around the mem_avoid[] logic (Baoquan He) [1290840]
- [x86] boot: Simplify pointer casting in choose_random_location() (Baoquan He) [1290840]
- [x86] kaslr: Consolidate mem_avoid[] entries (Baoquan He) [1290840]
- [x86] boot: Clean up pointer casting (Baoquan He) [1290840]
- [x86] boot: Warn on future overlapping memcpy() use (Baoquan He) [1290840]
- [x86] boot: Extract error reporting functions (Baoquan He) [1290840]
- [x86] boot: Correctly bounds-check relocations (Baoquan He) [1290840]
- [x86] kaslr: Clean up unused code from old 'run_size' and rename it to 'kernel_total_size' (Baoquan He) [1290840]
- [x86] boot: Fix "run_size" calculation (Baoquan He) [1290840]
- [x86] boot: Calculate decompression size during boot not build (Baoquan He) [1290840]
- [x86] boot: Move compressed kernel to the end of the decompression buffer (Baoquan He) [1290840]
- [x86] mm: Page align the '_end' symbol to avoid pfn conversion bugs (Baoquan He) [1290840]
- [x86] kaslr: Handle kernel relocations above 2G correctly (Baoquan He) [1290840]
- [x86] boot: Rename overlapping memcpy() to memmove() (Baoquan He) [1290840]
- [x86] kaslr: Warn when KASLR is disabled (Baoquan He) [1290840]
- [x86] boot: Make memcpy() handle overlaps (Baoquan He) [1290840]
- [x86] boot: Clean up things used by decompressors (Baoquan He) [1290840]
- [x86] kaslr: Drop CONFIG_RANDOMIZE_BASE_MAX_OFFSET (Baoquan He) [1290840]
- [x86] kaslr: Update description for decompressor worst case size (Baoquan He) [1290840]
- [x86] kaslr: Rename "random" to "random_addr" (Baoquan He) [1290840]
- [x86] kaslr: Clarify purpose of kaslr.c (Baoquan He) [1290840]
- [x86] boot: Clarify purpose of functions in misc.c (Baoquan He) [1290840]
- [x86] boot: Rename "real_mode" to "boot_params" (Baoquan He) [1290840]
- [x86] kaslr: Remove unneeded boot_params argument (Baoquan He) [1290840]
- [x86] kaslr: Rename aslr.c to kaslr.c (Baoquan He) [1290840]
- [x86] boot: Don't compile early_serial_console.c when !CONFIG_EARLY_PRINTK (Baoquan He) [1290840]
- [x86] boot: Don't compile aslr.c when !CONFIG_RANDOMIZE_BASE (Baoquan He) [1290840]
- [x86] boot: Use the usual -y -n mechanism for objects in vmlinux (Baoquan He) [1290840]
- [lib] decompressors: use real out buf size for gunzip with kernel (Baoquan He) [1290840]
- [lib] decompressors: fix "no limit" output buffer length (Baoquan He) [1290840]
- [lib] initramfs: support initramfs that is bigger than 2GiB (Baoquan He) [1290840]
- [lib] decompress_inflate.c: include appropriate header file (Baoquan He) [1290840]
- [x86] boot: Add hex output for debugging (Baoquan He) [1290840]
- [x86] kaslr: fix build due to missing ALIGN definition (Baoquan He) [1290840]
- [x86] introduce kaslr_offset() (Baoquan He) [1290840]
- [x86] mm/kaslr: Propagate KASLR status to kernel proper (Baoquan He) [1290840]
- [x86] revert "x86/mm/aslr: Propagate base load address calculation" (Baoquan He) [1290840]
- [x86] asm/boot/64: Use __BOOT_TSS instead of literal $0x20 (Baoquan He) [1290840]
- [x86] mm/aslr: Avoid PAGE_SIZE redefinition for UML subarch (Baoquan He) [1290840]
- [x86] mm/aslr: Propagate base load address calculation (Baoquan He) [1290840]
- [x86] asm/boot: Use already defined KEEP_SEGMENTS macro in head_{32, 64}.S (Baoquan He) [1290840]
- [x86] build: replace Perl script with Shell script (Baoquan He) [1290840]
- [x86] boot: Skip relocs when load address unchanged (Baoquan He) [1290840]
- [x86] Use $(OBJDUMP) instead of plain objdump (Baoquan He) [1290840]
- [x86] kaslr: Handle Gold linker for finding bss/brk (Baoquan He) [1290840]
- [x86] x86-64: Use RIP-relative addressing for most per-CPU accesses (Baoquan He) [1290840]
- [x86] x86-64: Handle PC-relative relocations on per-CPU data (Baoquan He) [1290840]
- [x86] kaslr: Prevent .bss from overlaping initrd (Baoquan He) [1290840]
- [x86] boot: Document intermediates more clearly (Baoquan He) [1290840]
- [x86] boot, kaslr: Fix nuisance warning on 32-bit builds (Baoquan He) [1290840]
- [x86] kaslr: Avoid the setup_data area when picking location (Baoquan He) [1290840]
- [kernel] x86, kaslr: boot-time selectable with hibernation (Baoquan He) [1290840]
- [kernel] pm / hibernate: introduce "nohibernate" boot parameter (Baoquan He) [1290840]
- [x86] kaslr: fix module lock ordering problem (Baoquan He) [1290840]
- [x86] kaslr: randomize module base load address (Baoquan He) [1290840]
- [x86] mm/arch: use NUMA_NO_NODE (Baoquan He) [1290840]
- [x86] kaslr: add missed "static" declarations (Baoquan He) [1290840]
- [x86] kaslr: export offset in VMCOREINFO ELF notes (Baoquan He) [1290840]
- [x86] kaslr: Clarify RANDOMIZE_BASE_MAX_OFFSET (Baoquan He) [1290840]
- [x86] kaslr: Remove unused including <linux/version.h> (Baoquan He) [1290840]
- [x86] kaslr: Use char array to gain sizeof sanity (Baoquan He) [1290840]
- [x86] kaslr: Add a circular multiply for better bit diffusion (Baoquan He) [1290840]
- [x86] kaslr: Mix entropy sources together as needed (Baoquan He) [1290840]
- [x86] relocs: Add percpu fixup for GNU ld 2.23 (Baoquan He) [1290840]
- [x86] boot: Rename get_flags() and check_flags() to *_cpuflags() (Baoquan He) [1290840]
- [x86] kaslr: Raise the maximum virtual address to -1 GiB on x86_64 (Baoquan He) [1290840]
- [x86] kaslr: Report kernel offset on panic (Baoquan He) [1290840]
- [x86] kaslr: Select random position from e820 maps (Baoquan He) [1290840]
- [x86] kaslr: Provide randomness functions (Baoquan He) [1290840]
- [x86] kaslr: Return location from decompress_kernel (Baoquan He) [1290840]
- [x86] boot: Move CPU flags out of cpucheck (Baoquan He) [1290840]
- [x86] relocs: Add more per-cpu gold special cases (Baoquan He) [1290840]
- [x86] mkpiggy.c: Explicitly close the output file (Baoquan He) [1290840]
- [x86] relocs: Move ELF relocation handling to C (Baoquan He) [1290840]

* Mon Mar 06 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-587.el7]
- [kernel] tasklist_lock: Change from rwlock_t to qrwlock_t (Waiman Long) [1241990]
- [kernel] qrwlock: Build wrapper headers and functions on top of qrwlock (Waiman Long) [1241990]
- [kernel] locking/qrwlock: Reduce reader/writer to reader lock transfer latency (Waiman Long) [1241990]
- [kernel] locking/qrwlock: Better optimization for interrupt context readers (Waiman Long) [1241990]
- [kernel] locking/qrwlock: Rename functions to queued_*() (Waiman Long) [1241990]
- [kernel] locking/qrwlock: Don't contend with readers when setting _QW_WAITING (Waiman Long) [1241990]
- [kernel] locking/qrwlock: Rename QUEUE_RWLOCK to QUEUED_RWLOCKS (Waiman Long) [1241990]
- [kernel] x86, locking/rwlocks: Enable qrwlocks on x86 (Waiman Long) [1241990]
- [kernel] locking/rwlocks: Introduce 'qrwlocks' - fair, queued rwlocks (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Block kernel module loading on old kernel (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Handle ticket unlock code in old kernel modules (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Maintain same kABI signature as ticket locks (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Fix double hash race (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Fix spin_unlock_wait() some more (Waiman Long) [1241990]
- [kernel] locking/pvstat: Separate wait_again and spurious wakeup stats (Waiman Long) [1241990]
- [kernel] locking, qspinlock: Fix spin_is_locked() and spin_unlock_wait() (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Fix division by zero in qstat_read() (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Move __ARCH_SPIN_LOCK_UNLOCKED to qspinlock_types.h (Waiman Long) [1241990]
- [kernel] x86/locking: Create stack frame in PV unlock (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Queue node adaptive spinning (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Allow limited lock stealing (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Collect slowpath lock statistics (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock, x86: Optimize the PV unlock code path (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Avoid redundant read of next pointer (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Prefetch the next node cacheline (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Kick the PV CPU unconditionally when _Q_SLOW_VAL (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Fix performance regression under unaccelerated VMs (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Only kick CPU at unlock time (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Order pv_unhash() after cmpxchg() on unlock slowpath (Waiman Long) [1241990]
- [kernel] locking: Clean up pvqspinlock warning (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Fix kernel panic in locking-selftest (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Rename QUEUED_SPINLOCK to QUEUED_SPINLOCKS (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: replace xchg() by the more descriptive set_mb() (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock, x86: Enable PV qspinlock for Xen (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock, x86: Enable PV qspinlock for KVM (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock, x86: Implement the paravirt qspinlock call patching (Waiman Long) [1241990]
- [kernel] locking/pvqspinlock: Implement simple paravirt support for the qspinlock (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Revert to test-and-set on hypervisors (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Use a simple write to grab the lock (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Optimize for smaller NR_CPUS (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Extract out code snippets for the next patch (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Add pending bit (Waiman Long) [1241990]
- [kernel] locking/qspinlock, x86: Enable x86-64 to use queued spinlocks (Waiman Long) [1241990]
- [kernel] locking/qspinlock: Introduce a simple generic 4-byte queued spinlock (Waiman Long) [1241990]
- [kernel] percpu: Make __verify_pcu_ptr handle per cpu pointers to arrays (Waiman Long) [1241990]
- [kernel] compiler: Allow 1- and 2-byte smp_load_acquire() and smp_store_release() (Waiman Long) [1241990]

* Fri Mar 03 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-586.el7]
- [sound] alsa: remove unused dmaengine bits (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: Replace MBI_REG_READ with constant 0x10 (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-midi: correct speed checking (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: correct speed checking (Jaroslav Kysela) [1399503]
- [sound] alsa: pcm: Allow 32 bit sample format in IEC958 channel status helper (Jaroslav Kysela) [1399503]
- [sound] alsa: pcm: add IEC958 channel status helper for hw_params (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5645: set sel_i2s_pre_div1 to 2 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on rt5645 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5645: Add ACPI ID 10EC5640 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5645: add DAC1 soft volume func control (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5645: set RT5645_PRIV_INDEX as volatile (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5645: fix reg-2f default value (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5645: patch reg-0x8a (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rl6347a: Use dev_err for I2C communication error prints (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on ssm4567 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on ssm2518 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on sn95031 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5670: Add missing 10EC5072 ACPI ID (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5670: Enable Braswell platform workaround for Dell Wyse 3040 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5670: increse LDO power (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5670: Enable MCLK detection (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on rt5670 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5670: patch reg-0x8a (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5670: fix HP Playback Volume control (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on rt5651 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5645: polling jd status in all conditions (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5645: Add dmi_system_id "Google Setzer" (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5640: add Mono ADC Capture Switch control (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5640: enable MCLK detection (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt5640: add internal clock source support (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on rt5640 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on rt286 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rt286: set combo jack for Kabylake (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: rl6231: add 19.2M to 4.096M pll preset table (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: fix invalid configuration in Pre-Scalar of FLL (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: correct the function name of register (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: disable sinc filter for high THD of ADC (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: lock longer to avoid playback pop upon resume (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: FLL parameters finetune (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: AD/DA over sampling rate configuration (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: Disable short Frame Sync detection logic (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: fix bug in FLL parameter (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on nau8825 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: fix static check error about semaphone control (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: fix bug in playback when suspend (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: drop redundant idiom when converting integer to boolean (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: jack connection decision with different insertion logic (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: mark pm functions __maybe_unused (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: cross talk suppression measurement function (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: correct typo in biquad filter coefficients (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: non-clock jack detection for power saving at standby (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: add programmable biquad filter control (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: Export I2C module alias information (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: assign DAC Ch to match headset L/R (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: change output power for interrupt (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: reduce standby power consumption (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: improve FLL function for better performance (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: nau8825: support different clock source for FLL function (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on wm98357a (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: hdac_hdmi: fix spelling mistake "montior" -> "monitor" (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: hdac_hdmi: Add device id for Kabylake (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: hdac_hdmi: Increase loglevel of hex dump printed (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: hdac_hdmi: Fix potential NULL dereference (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: hdac_hdmi: Remove the unused 'timeout' variable (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: hdac_hdmi: add link management (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: hdac_hdmi: Potential NULL deref in hdac_hdmi_get_spk_alloc() (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: hdac_hdmi: Register chmap controls and ops (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: hdac_hdmi: Add multichannel support (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: hdac_hdmi: parse eld for channel map capability (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: codec duplicated callback function goes to component on dmic (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: core: Add component pin control functions (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dpcm: Avoid putting stream state to STOP when FE stream is paused (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: Make return type of dpcm_state_string() const char * (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dpcm: print dai_link name of BE other than FE (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dpcm: Don't apply symmetry for BE with hw param fixup (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dpcm: play nice with CODEC<->CODEC links (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: core: fix shift used for second item in snd_soc_get_enum_double (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dapm: Implement stereo mixer control support (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dapm: Support second register for DAPM control updates (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dapm: Fix kcontrol creation for output driver widget (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dapm: Fix value setting for _ENUM_DOUBLE MUX's second channel (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dapm: Fix possible uninitialized variable in snd_soc_dapm_get_volsw() (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dapm: Fix typos in comment (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dapm: Add a dummy snd_pcm_runtime to avoid NULL pointer access (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dapm: Export snd_soc_dapm_new_control (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dapm: Fix to return correct path list in is_connected_ep (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: dapm: support user-defined stop condition in dai_get_connected_widgets (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: compress: Add support for compress dai ops (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: compress: Fix leak of a widget list in soc_compr_open_fe (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: compress: Pass error out of soc_compr_pointer (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: soc-core: adjust for graph on snd_soc_of_parse_audio_simple_widgets (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: soc-core: adjust for graph on snd_soc_of_parse_card_name (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: soc-core: adjust for graph on snd_soc_of_parse_audio_prefix (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: soc-core: snd_soc_get_dai_name() become non static (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: soc-core: adjust for graph on snd_soc_of_parse_audio_routing (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: core: If a platform doesn't have an of_node use parent's node (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: core: Clean up DAPM before the card debugfs (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: Fix leak of rtd in soc_bind_dai_link (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: remove codec duplicated callback function (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: use of_property_read_bool (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: Add kerneldoc comments for snd_soc_find_dai (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: Export snd_soc_find_dai() (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: Define API to find a dai link (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: Fix binding and probing of auxiliary components (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: add Component level suspend/resume (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: core: replace aux_comp_list to component_dev_list (Jaroslav Kysela) [1399503]
- [sound] alsa: bump PCM protocol to 2.0.13 (Jaroslav Kysela) [1399503]
- [sound] alsa: Provide a CLOCK_MONOTONIC_RAW timestamp type (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: ABI - Update physical DAI link configuration for version 5 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: ABI - Rename be_dai_elems to dai_elems in manifest (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: kfree kcontrol->private_value before freeing kcontrol (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: avoid uninitialized kcontrol_type (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Only free TLV for volume mixers of a widget (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Allow a widget to have multiple enum controls (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Check name strings of physical DAI links (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: ABI - Add voice wake up flag for DAI links (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Rename functions & variables for physical DAIs (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: ABI - Rename struct and type for physical DAIs (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Rename the function to create a FE link (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Add support to configure existing physical DAI links (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: ABI - Add flags and private data to PCM (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Only use valid names of PCM for the kernel DAI & DAI link (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Make PCM backward compatible from ABI v4 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Make manifest backward compatible from ABI v4 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Fix error return code in soc_tplg_dapm_widget_create() (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Add support for configuring existing BE DAIs (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Fix memory leak in widget creation (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Check size mismatch of ABI objects before parsing (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Check failure to create a widget (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Set CPU DAI name and enable DPCM by default for FE link (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Support topology file of ABI v4 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: ABI - Define DAI physical PCM data formats (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Reenable use from userspace (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: ABI - Add sig_bits to stream caps (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: ABI - Add the types for BE DAI (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: Set the link ID when creating a FE DAI link (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: topology: ABI - Define types for vendor tuples (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - Cannot adjust speaker's volume on a Dell AIO (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - add sanity check to force the separate stream tags (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - fix Lewisburg audio issue (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/patch_sigmatel: Add AmigaOne X1000 pinconfigs (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Always setup isochronous transfer properties (Jaroslav Kysela) [1399503]
- [sound] alsa: cs46xx: constify snd_pcm_ops structures (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - Add support headphone Mic for ALC221 of HP platform (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - New codec support of ALC1220 (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Make single_cmd option to stop the fallback mechanism (Jaroslav Kysela) [1399503]
- [sound] alsa: usb: Constify snd_rawmidi_ops (Jaroslav Kysela) [1399503]
- [sound] alsa: pci: Constify snd_rawmidi_ops (Jaroslav Kysela) [1399503]
- [sound] alsa: Constify snd_rawmidi_ops (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: Constify snd_rawmidi_ops (Jaroslav Kysela) [1399503]
- [sound] alsa: rawmidi: Add const to snd_rawmidi_ops (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/ca0132 - fix possible NULL pointer use (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - add DP mst verb support (Jaroslav Kysela) [1399503]
- [sound] alsa: vx: Don't try to update capture stream before running (Jaroslav Kysela) [1399503]
- [sound] alsa: vx: Fix possible transfer overflow (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix deadlock of controller device lock at unbinding (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - Add new codec ID ALC299 (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix click noises on Samsung Ativ Book 8 (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Apply ALC269_FIXUP_NO_SHUTUP on HDA_FIXUP_ACT_PROBE (Jaroslav Kysela) [1399503]
- [sound] alsa: mixart: fix a comment typo (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Support both DSD LE/BE Amanero firmware versions (Jaroslav Kysela) [1399503]
- [sound] alsa: cs5535audio: fix unused warnings on resume/suspend (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - adding a new NV HDMI/DP codec ID in the driver (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: Fix race at creating a queue (Jaroslav Kysela) [1399503]
- [sound] alsa: revert "alsa: line6: Only determine control port properties if needed" (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: Don't handle loop timeout at snd_seq_pool_done() (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Add a quirk for Plantronics BT600 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Release FW ctx in cleanup (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr-rt5640: fix settings in internal clock mode (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: test EP_FLAG_RUNNING at urb completion (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Fix irq/process data synchronization (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Apply asus-mode8 fixup to ASUS X71SL (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix up GPIO for ASUS ROG Ranger (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix to fail safely if module not available in path (Jaroslav Kysela) [1399503]
- [sound] alsa: revert "alsa: usb-audio: Fix race at stopping the stream" (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: fallback mechanism if MCLK is not enabled (Jaroslav Kysela) [1399503]
- [sound] alsa: printk/sound: handle more message headers (Jaroslav Kysela) [1399503]
- [sound] alsa: hiface: Fix M2Tech hiFace driver sampling rate change (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Eliminate noise at the start of DSD playback (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Add native DSD support for TEAC 501/503 DAC (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Add QuickCam Communicate Deluxe/S7500 to volume_control_quirks (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: add implicit fb quirk for Axe-Fx II (Jaroslav Kysela) [1399503]
- [sound] alsa: cs46xx: add a new line (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: update bxt_da7219_max98357a to support quad ch dmic capture (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: more tolerant packetsize (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: avoid setting of sample rate multiple times on bus (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Gate the mic jack on HP Z1 Gen3 AiO (Jaroslav Kysela) [1399503]
- [sound] alsa: hda: when comparing pin configurations, ignore assoc in addition to seq (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: save FW version (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: Add sysfs entry in order to store FW version (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Fix race at stopping the stream (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: core: replace codec_dev_list to component_dev_list on Card (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: cht_bsw_rt5672: Use HID translation unit (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Fix crash at suspend/resume without card registration (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Replace kthread with work (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add missing 10EC5672 ACPI ID matching for Cherry Trail (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Fix bogus error return in snd_usb_create_stream() (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Claim pod x3 usb data interface (Jaroslav Kysela) [1399503]
- [sound] alsa: echoaudio: Fix improper return value in function load_asic (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: Make some messages to debug level (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - Add support for headset MIC for ALC622 (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/ca0132 - Add quirk for Alienware 15 R2 2016 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Removed the unused I2S blob structure (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Don't use dma I2S config structure in kernel (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - fix headset-mic problem on a Dell laptop (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - ignore the assoc and seq when comparing pin configurations (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: cht_bsw_rt5645: Fix leftover kmalloc (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: mfld: Make static string arrays 'const 'char * const []' (Jaroslav Kysela) [1399503]
- [sound] alsa: emu10k1: Use workqueue instead of kthread for emu1010 fw polling (Jaroslav Kysela) [1399503]
- [sound] alsa: emu10k1: Simplify firmware loader code (Jaroslav Kysela) [1399503]
- [sound] alsa: emu10k1: Fix emu1010 dock attach check (Jaroslav Kysela) [1399503]
- [sound] alsa: ac97: Fix kernel-doc error with sphinx formatter (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Fix use-after-free of usb_device at disconnect (Jaroslav Kysela) [1399503]
- [sound] alsa: pci: don't opencode IS_REACHABLE() (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytct_rt5640: change default capture settings (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: detect audio routing with CHAN package (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: common: add ACPI package extraction utility (Jaroslav Kysela) [1399503]
- [sound] alsa: oss: don't opencode IS_REACHABLE() (Jaroslav Kysela) [1399503]
- [sound] alsa: rawmidi: don't opencode IS_REACHABLE() (Jaroslav Kysela) [1399503]
- [sound] alsa: opl3: don't opencode IS_REACHABLE() (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix mic regression by ASRock mobo fixup (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - add a new condition to check if it is thinkpad (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Flush pending D0i3 request on suspend (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: remove pci device enabling calls on suspend (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix typo (Jaroslav Kysela) [1399503]
- [sound] alsa: info: Return error for invalid read/write (Jaroslav Kysela) [1399503]
- [sound] alsa: info: Limit the proc text input size (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add D0i3 mode ref counting (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add support for specifying D0i3 configuration (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add support for LPMode (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add D0iX callbacks (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add support for programming D0i3C (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add D0iX IPCs (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add sst_ipc_tx_message_nopm (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add check_dsp_lp_on callback on IPC (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: Add debug information related to FW version (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix to turn off hdmi power on probe failure (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Add quirk for Syntek STK1160 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix a shift wrapping bug (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: Fix time account regression (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix surround output pins for ASRock B150M mobo (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: constify snd_soc_ops structures (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: broadwell: constify snd_soc_ops structures (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: sst-bxt-da7219_max98357a: fix obsoleted initializer for array (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Always acquire runtime pm ref on unload (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: add terminate entry for dmi_system_id tables (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix headset mic detection problem for two Dell laptops (Jaroslav Kysela) [1399503]
- [sound] alsa: asihpi: fix kernel memory disclosure (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Adding a new group of pin cfg into ALC295 pin quirk table (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - allow 40 bit DMA mask for NVidia devices (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: fix a crash in line6_hwdep_write() (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: fix passing wrong pointer in function call of compatibility layer (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix a failure of micmute led when having multi adcs (Jaroslav Kysela) [1399503]
- [sound] alsa: treewide: remove redundant #include <linux/kconfig.h> (Jaroslav Kysela) [1399503]
- [sound] alsa: kthread: kthread worker API cleanup (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: haswell depends on sst-firmware (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Fix POD X3 Live audio input (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: report JACK_LINEOUT event (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Use DPIB to update position for Playback stream (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: fix memory leak of module on error exit path (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: sst-bxt-rt298: fix obsoleted initializers for array (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: sst-bxt-da7219_max98357a: fix obsoleted initializers for array (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Add the top speaker pin config for HP Spectre x360 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add DMIC channel constraint for bxt machine (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Adding one more ALC255 pin definition for headset problem (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-line6: use the same declaration as definition in header for MIDI manufacturer ID (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: boards: Add bdw-rt5677 machine driver (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: remove status, it is shadowing status of a higher scope (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: add missing \n to end of dev_err/dev_dbg messages (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: add missing \n to end of dev_* messages (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add table for module id for quick ref (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Update to use instance ids generated (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Use private instance id of modules in IPC (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add module instance id generation APIs (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Extend DragonFly dB scale quirk to cover other variants (Jaroslav Kysela) [1399503]
- [sound] alsa: ali5451: Fix out-of-bound position reporting (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: snd-usb-line6 depends on CONFIG_SND_HWDEP (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: fix ifnullfree.cocci warnings (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Add hwdep interface to access the POD control messages (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Cleanup podhd initialization (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Only determine control port properties if needed (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Add support for POD X3 Live (only USB ID differs from POD X3) (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Add support for POD X3 (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Allow processing of raw incoming messages (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Distinguish device init (ctrl EP) and MIDI data transfer (int EP) (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Add LINE6_CAP_IN_NEEDS_OUT, a void playback stream during capture (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Allow different channel numbers for in/out (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Support assymetrical in/out configurations (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Add high-speed USB support (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Enable different number of URBs for frame transfers (Jaroslav Kysela) [1399503]
- [sound] alsa: compress: fix some missing and misplaced \n in messages (Jaroslav Kysela) [1399503]
- [sound] alsa: hdac: add missing \n to end of dev_err messages (Jaroslav Kysela) [1399503]
- [sound] alsa: au88x0: Add missing \n to end of dev_err message (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add 32bit support (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: fix to copy from/to user space (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: constify snd_pcm_ops structures (Jaroslav Kysela) [1399503]
- [sound] alsa: pci: constify local structures (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix headset mic detection problem for several Dell laptops (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Skip Realtek SKU check for Lenovo machines (Jaroslav Kysela) [1399503]
- [sound] alsa: rawmidi: Fix possible deadlock with virmidi registration (Jaroslav Kysela) [1399503]
- [sound] alsa: timer: Fix zero-division by continue of uninitialized instance (Jaroslav Kysela) [1399503]
- [sound] alsa: squash lines for simple wrapper functions (Jaroslav Kysela) [1399503]
- [sound] alsa: pcm: Fix avail to return error if stream is suspended (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: fix IOSF_MBI dependency (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: sst: fix to spelling mistake: "susupend" -> "suspend" (Jaroslav Kysela) [1399503]
- [sound] alsa: timer: fix NULL pointer dereference in read()/ioctl() race (Jaroslav Kysela) [1399503]
- [sound] alsa: bt87x: constify snd_pcm_ops structures (Jaroslav Kysela) [1399503]
- [sound] alsa: oxygen: constify snd_pcm_ops structures (Jaroslav Kysela) [1399503]
- [sound] alsa: ad1889: constify snd_pcm_ops structures (Jaroslav Kysela) [1399503]
- [sound] alsa: constify snd_pcm_ops structures (Jaroslav Kysela) [1399503]
- [sound] alsa: cs5535audio: constify snd_pcm_ops structures (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Unload all the loadable modules (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix DMA control config size (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix the inverted logic check (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: check manifest size (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: add a missing star in a memcpy call (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: Fix message handling during drop stream (Jaroslav Kysela) [1399503]
- [sound] alsa: cs46xx: fix typo "seconadry" -> "secondary" (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: initialize whole fields of automatic variable with union type (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Enable subwoofer on Dell Inspiron 7559 (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Add headset mic quirk for Dell Inspiron 5468 (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Add sample rate inquiry quirk for B850V3 CP2114 (Jaroslav Kysela) [1399503]
- [sound] alsa: timer: fix NULL pointer dereference on memory allocation failure (Jaroslav Kysela) [1399503]
- [sound] alsa: timer: fix division by zero after SNDRV_TIMER_IOCTL_CONTINUE (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - fix headset mic detection for MSI MS-B120 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Parse manifest data (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: uapi: intel: skylake: Define vendor specific tokens (Jaroslav Kysela) [1399503]
- [sound] alsa: uapi: Add three missing header files to Kbuild file (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Remove dfw config and associated structures (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Parse vendor tokens to build module data (Jaroslav Kysela) [1399503]
- [sound] alsa: hdspm: fix spelling mistake "Externel" -> "External" (Jaroslav Kysela) [1399503]
- [sound] alsa: compress: Use memdup_user() rather than duplicating its implementation (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: rmove print for failure of kmalloc (Jaroslav Kysela) [1399503]
- [sound] alsa: usb: fine-tune Tenor error compensation value (Jaroslav Kysela) [1399503]
- [sound] alsa: usb: use TEAC UD-H01 quirk for more devices (Jaroslav Kysela) [1399503]
- [sound] alsa: usb: move udh01_fb_quirk setting to quirks.c (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Fix POD sysfs attributes segfault (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Give up on the lock while URBs are released (Jaroslav Kysela) [1399503]
- [sound] alsa: line6: Remove double line6_pcm_release() after failed acquire (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: obsolete change of address limit (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: change ioctl command operation to get data in kernel space (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: add an alternative way to handle ioctl requests (Jaroslav Kysela) [1399503]
- [sound] alsa: seq: add documentation for snd_seq_kernel_client_ctl (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: sst: fix ix spelling mistake: "capablities" -> "capabilites" (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: quirk for Acer Aspire SWS-012 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: fix 0-day warnings (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: log quirks (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: Add quirk for Teclast X98 Air 3G tablet (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add quirks for MinnowBoard MAX (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: add MCLK support (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: add IN3 map (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: default routing and quirks on Baytrail-CR (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: fix dai/clock setup for SSP0 routing (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt56040: additional routing quirks (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: Change DAI link's be_id to a generic id (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: add SSP2_AIF2 routing (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: enable configuration of SSP0 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: add definitions for modem/SSP0 interface (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: auto-detection of Baytrail-CR (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: enable differential mic quirk (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr_rt5640: quirk for mono speaker (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bytcr-rt5640: add Asus T100TAF quirks (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix error return code in skl_probe() (Jaroslav Kysela) [1399503]
- [sound] alsa: usb: caiaq: audio: don't print error when allocating urb fails (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: remove module id query at runtime (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Populate modules after loading (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: modify snd_skl_get_module_info args (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Manage power well properly for resume (Jaroslav Kysela) [1399503]
- [sound] alsa: alsa - hda: Add support for link audio time reporting (Jaroslav Kysela) [1399503]
- [sound] alsa: alsa - hda: Add support for parsing new HDA capabilities (Jaroslav Kysela) [1399503]
- [sound] alsa: alsa - ext hda: remove bus_parse_capabilities (Jaroslav Kysela) [1399503]
- [sound] alsa: convert users to core bus_parse_capabilities (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - move bus_parse_capabilities to core (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Add quirk for ELP HD USB Camera (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Add a sample rate quirk for Creative Live! Cam Socialize HD (VF0610) (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add module processing domain support (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix a comment style (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add library loading support (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: fix noderef.cocci warnings (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add library loading IPCs (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bxt: Parse UUIDs once (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Parse UUIDs once (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: add additional args to module parsing (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: add support for tplg manifest load (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: split fw and dsp initialization (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: modify skl_get_dsp_ops() (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Move modules query to runtime (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix headset mic detection problem for two dell machines (Jaroslav Kysela) [1399503]
- [sound] alsa: hda: Fix krealloc() with __GFP_ZERO usage (Jaroslav Kysela) [1399503]
- [sound] alsa: hda: add AMD Bonaire AZ PCI ID with proper driver caps (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Check list empty while getting module info (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - On-board speaker fixup on ACER Veriton (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - Can't adjust speaker's volume on a Dell AIO (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Delete an unnecessary check before the function call "release_firmware" (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix NULL Pointer exception in dynamic_debug (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Fix quirks code is not called (Jaroslav Kysela) [1399503]
- [sound] alsa: echoaudio: purge contradictions between dimension matrix members and total number of members (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Fix conflicting pcm dev drvdata on haswell (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: board: add kabylake nau88l25_ssm4567 machine id (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: board: add kabylake nau88l25_max98357a machine id (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: kbl: add kabylake additional machine entries (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: reduce machine name for skl_nau88l25_max98357a (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: reduce machine name for skl_nau88l25_ssm4567 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix fw reload failure (Jaroslav Kysela) [1399503]
- [sound] alsa: mixart: don't print an unintialized variable on error (Jaroslav Kysela) [1399503]
- [sound] alsa: ak4114: remove redundant check on err being < 0 (Jaroslav Kysela) [1399503]
- [sound] alsa: ak4117: remove redundant check on err being < 0 (Jaroslav Kysela) [1399503]
- [sound] alsa: hda: add AMD Stoney PCI ID with proper driver caps (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: board: add kabylake machine id (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: add kablake device IDs (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - fix use-after-free after module unload (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Fix sst-dsp dependency on dw stuff (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: statify cht_quirk (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: cht: fix uninit variable warning (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix to use the actual size for TLV control (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add surface3 entry in CHT-RT5645 machine (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: Add quirk for Surface 3 (Jaroslav Kysela) [1399503]
- [sound] alsa: pcm: Free chmap at PCM free callback, too (Jaroslav Kysela) [1399503]
- [sound] alsa: ctl: Stop notification after disconnection (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - add new pin definition in alc225 pin quirk table (Jaroslav Kysela) [1399503]
- [sound] alsa: control: add dimension validator for userspace elements (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek: Add Lenovo L460 to docking unit fixup (Jaroslav Kysela) [1399503]
- [sound] alsa: timer: Fix negative queue usage by racy accesses (Jaroslav Kysela) [1399503]
- [sound] alsa: riptide: Use DIV_ROUND_UP (Jaroslav Kysela) [1399503]
- [sound] alsa: au88x0: Fix calculation in vortex_wtdma_bufshift() (Jaroslav Kysela) [1399503]
- [sound] alsa: echoaudio: Fix memory allocation (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Increase loglevel of debug messages (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: common: increase the loglevel of "FW Poll Status" (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - fix read before array start (Jaroslav Kysela) [1399503]
- [sound] alsa: dummy: Fix a use-after-free at closing (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: atom: fix missing breaks that would cause the wrong operation to execute (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix the headset mic jack detection on Dell machine (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Support multi-core in Broxton (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Support multi-core in Skylake (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add DSP muti-core infrastructure (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Update comment style (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add pm ops for broxton-rt298 machine (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Disable async suspend (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: revert "asoc: intel: Add support for PM ops in bxt-rt298" (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: kconfig: formatting update (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: kconfig: fix build when ACPI is not enabled (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/tegra: iomem fixups for sparse warnings (Jaroslav Kysela) [1399503]
- [sound] alsa: seq_timer: use monotonic times internally (Jaroslav Kysela) [1399503]
- [sound] alsa: ctxfi: Change structure initialisation to C99 style (Jaroslav Kysela) [1399503]
- [sound] alsa: usb-audio: Change structure initialisation to C99 style (Jaroslav Kysela) [1399503]
- [sound] alsa: hda: fix some klockwork scan warnings (Jaroslav Kysela) [1399503]
- [sound] alsa: seq_oss: Change structure initialisation to C99 style (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - ALC891 headset mode for Dell (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Check for module list being NULL (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Initialize module list for Broxton (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add support for PM ops in bxt-rt298 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Update DSP stall bits (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Update FW purge for Broxton (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Enable firmware reload in suspend (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Update ignore suspend for bxt-rt298 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add FE rate & channel constraints for bxt-rt298 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add DMIC 4 channel support for bxt machine (Jaroslav Kysela) [1399503]
- [sound] alsa: compress: Add function to indicate the stream has gone bad (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add DSP firmware manifest parsing (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Report position in pointer query (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Copy the pipe parameter by pipe type (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Set the DSP pipe type (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Create Pipe to widget list in soc probe (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Clean up of driver resources in suspend (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Avoid freeing up of unallocated memory/mcps (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Disable SRAM Retention before D3 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Don't pause stopped pipeline while deleting (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Set the pipe state to paused when paused (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Reset DSP pipe when host/link DMA is reset (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek: Add T560 docking unit fixup (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix headset mic detection problem for Dell machine (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Turn off loopback mixing as default (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add Broxton-P Dialog+Maxim machine driver entry (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add Broxton-P Dialog Maxim machine driver (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: boards: configure DMIC for machine sklnau8825max (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: boards: configure DMIC for machine sklnau8825adi (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Find uuids for Broxton (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Find uuids for Skylake (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add strip extended manifest utility (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Use UUID in binary format (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Strip manifest for Broxton platform (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Strip manifest for Skylake platform (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Don't use local pointer for firmware (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: bxtn: Add Broxton DSP support (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add api to retrieve dmic array info from nhlt (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Use refcap device for mono recording (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add channel constraints for refcap (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: add function stub when ACPI is not enabled (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - Add support for new codecs ALC700/ALC701/ALC703 (Jaroslav Kysela) [1399503]
- [sound] alsa: hda/realtek - ALC256 speaker noise issue (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix headset mic detection problem for one Dell machine (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - Fix headphone noise on Dell XPS 13 9360 (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: add link management (Jaroslav Kysela) [1399503]
- [sound] alsa: hdac: add link pm and ref counting (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: fix up for DAI link's be_id change (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Fix printk formatting (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: Add Broxton-P machine driver (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add more SSP DAIs (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix memory leak in nhlt init (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: boards: remove ignore_suspend for WoV streams (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Suspend PCMs when marked as active suspend (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Prevent sending Set DMA Control IPC if the widget is "On" (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix memory leak during init instance (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Fix the NULL pointer exception in dsp_clean up (Jaroslav Kysela) [1399503]
- [sound] alsa: dmaengine: dw: pass platform data via struct dw_dma_chip (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Update channel map based on runtime params (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: skylake: Add multichannel support for HDMI (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: boards: Update skl_nau88l25_ssm4567 driver to support chmap (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: intel: boards: Update skl_nau88l25_max98357a driver to support chmap (Jaroslav Kysela) [1399503]
- [sound] alsa: asoc: skl_rt286: Fix to support hdmi channel map support (Jaroslav Kysela) [1399503]
- [sound] alsa: hda - add helper to get channels from cap bits (Jaroslav Kysela) [1399503]

* Thu Mar 02 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-585.el7]
- [kernel] locking/mutex: Explicitly mark task as running after wakeup (Gustavo Duarte) [1423397]
- [kernel] sched/core: Fix an SMP ordering race in try_to_wake_up() vs. schedule() (Gustavo Duarte) [1423400]
- [kernel] sched/fair: Fix nohz.next_balance update (Lauro Ramos Venancio) [1420450]
- [kernel] sched: Improve load balancing in the presence of idle CPUs (Lauro Ramos Venancio) [1420450]
- [kernel] sched/fair: Fix stale overloaded status in the busiest group finding logic (Lauro Ramos Venancio) [1420450]
- [kernel] sched: Improve sysbench performance by fixing spurious active migration (Lauro Ramos Venancio) [1420450]
- [kernel] sched: Assign correct scheduling domain to 'sd_llc' (Lauro Ramos Venancio) [1420450]
- [kernel] sched: Avoid NULL dereference on sd_busy (Lauro Ramos Venancio) [1420450]
- [kernel] sched: Remove unnecessary iteration over sched domains to update nr_busy_cpus (Lauro Ramos Venancio) [1420450]
- [kernel] sched: Pass 'struct rq' to rebalance_domains() (Lauro Ramos Venancio) [1420450]
- [kernel] sched: Pass 'struct rq' to nohz_idle_balance() (Lauro Ramos Venancio) [1420450]
- [kernel] sched: Use this_rq() helper (Lauro Ramos Venancio) [1420450]
- [kernel] sched: Fix potential near-infinite distribute_cfs_runtime() loop (Lauro Ramos Venancio) [1399391]
- [kernel] percpu-refcount: fix reference leak during percpu-atomic transition (Jeff Moyer) [1418333]
- [kernel] prctl: take mmap sem for writing to protect against others (Mateusz Guzik) [1374860]
- [fs] proc: read mm's {arg, env}_{start, end} with mmap semaphore taken (Mateusz Guzik) [1374860]
- [fs] vfs: fix put_compat_statfs64() does not handle errors (Larry Woodman) [1366543]
- [mm] hugetlb: don't use reserved during VM_SHARED mapping cow (Larry Woodman) [1385473]
- [mm] filemap: optimize copy_page_to/from_iter_iovec (Mikulas Patocka) [1362715]
- [mm] vma_merge: correct false positive from __vma_unlink->validate_mm_rb (Andrea Arcangeli) [1374548]
- [mm] vma_merge: fix race vm_page_prot race condition against rmap_walk (Andrea Arcangeli) [1374548]
- [mm] fix use-after-free if memory allocation failed in vma_adjust() (Andrea Arcangeli) [1374548]
- [mm] thp: really limit transparent hugepage allocation to local node (Aaron Tomlin) [1425895]
- [mm] mempolicy.c: merge alloc_hugepage_vma to alloc_pages_vma (Aaron Tomlin) [1425895]
- [mm] thp: allocate transparent hugepages on local node (Aaron Tomlin) [1425895]
- [mm] mempolicy: unexport get_vma_policy() and remove its "task" arg (Aaron Tomlin) [1425895]
- [mm] mempolicy: kill do_set_mempolicy()->down_write(&mm->mmap_sem) (Aaron Tomlin) [1425895]
- [mm] mempolicy: fix show_numa_map() vs exec() + do_set_mempolicy() race (Aaron Tomlin) [1425895]
- [mm] mempolicy: introduce __get_vma_policy(), export get_task_policy() (Aaron Tomlin) [1425895]
- [mm] mempolicy: remove the "task" arg of vma_policy_mof() and simplify it (Aaron Tomlin) [1425895]
- [mm] mempolicy: sanitize the usage of get_task_policy() (Aaron Tomlin) [1425895]
- [mm] mempolicy: change get_task_policy() to return default_policy rather than NULL (Aaron Tomlin) [1425895]
- [mm] mempolicy: change alloc_pages_vma() to use mpol_cond_put() (Aaron Tomlin) [1425895]
- [mm] proc/maps: make vm_is_stack() logic namespace-friendly (Aaron Tomlin) [1425895]
- [fs] proc/maps: replace proc_maps_private->pid with "struct inode *inode" (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: update m->version in the main loop in m_start() (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: reintroduce m->version logic (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: introduce m_next_vma() helper (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: simplify m_start() to make it readable (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: kill the suboptimal and confusing m->version logic (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: shift "priv->task = NULL" from m_start() to m_stop() (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: cleanup the "tail_vma" horror in m_next() (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: simplify the vma_stop() logic (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: shift mm_access() from m_start() to proc_maps_open() (Aaron Tomlin) [1425895]
- [fs] proc: introduce proc_mem_open() (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: unify/simplify do_maps_open() and numa_maps_open() (Aaron Tomlin) [1425895]
- [fs] proc/task_mmu.c: don't use task->mm in m_start() and show_*map() (Aaron Tomlin) [1425895]
- [mm] mempolicy.c: parameter doc uniformization (Aaron Tomlin) [1425895]
- [mm] mempolicy: return NULL if node is NUMA_NO_NODE in get_task_policy (Aaron Tomlin) [1425895]

* Thu Mar 02 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-584.el7]
- [hv] make CPU offlining prevention fine-grained (Vitaly Kuznetsov) [1396335]
- [hv] switch to cpuhp state machine for synic init/cleanup (Vitaly Kuznetsov) [1396335]
- [hv] don't reset hv_context.tsc_page on crash (Vitaly Kuznetsov) [1396335]
- [hv] init percpu_list in hv_synic_alloc() (Vitaly Kuznetsov) [1396335]
- [hv] allocate synic pages for all present CPUs (Vitaly Kuznetsov) [1396335]
- [hv] change clockevents unbind tactics (Vitaly Kuznetsov) [1396335]
- [x86] Make sure IDT is page aligned (Lenny Szubowicz) [1422235]
- [drm] virtio-gpu: disable VIRGL with BE kernel (Laurent Vivier) [1413817]
- [s390] topology/sysfs: provide drawer id and siblings attributes (Hendrik Brueckner) [1380774]
- [s390] topology: add drawer scheduling domain level (Hendrik Brueckner) [1380774]
- [scsi] cxgb4i: libcxgbi: cxgb4: add T6 iSCSI completion feature (Sai Vemuri) [1417523]
- [scsi] cxgb4i: libcxgbi: add active open cmd for T6 adapters (Sai Vemuri) [1417523]
- [scsi] cxgb4i: use cxgb4_tp_smt_idx() to get smt_idx (Sai Vemuri) [1417523]
- [block] mtip32xx: set error code on failure (David Milburn) [1384915 1385883]
- [block] mtip32xx: Improvement in code readability when memdup_user() fails (David Milburn) [1384915 1385883]
- [block] mtip32xx: mark symbols static where possible (David Milburn) [1384915 1385883]
- [block] mtip32xx: fix checks for dma mapping errors (David Milburn) [1384915 1385883]
- [iommu] vt-d: Don't over-free page table directories (Myron Stowe) [1418404]
- [netdrv] be2net: Increase skb headroom size to 256 bytes (Ivan Vecera) [1379825]
- [powerpc] eeh: Null check uses of eeh_pe_bus_get (Steve Best) [1427224]
- [powerpc] pseries: Use H_CLEAR_HPT to clear MMU hash table during kexec (Steve Best) [1423396]
- [security] don't crash when selinux is disabled (Miklos Szeredi) [1425499]
- [security] selinux: fix off-by-one in setprocattr (Paul Moore) [1422369] {CVE-2017-2618}

* Thu Mar 02 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-583.el7]
- [netdrv] bnxt_en: Fix bnxt_setup_tc() error message (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Print FEC settings as part of the linkup dmesg (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Do not setup PHY unless driving a single PF (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Allow NETIF_F_NTUPLE to be enabled on VFs (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Retry failed NVM_INSTALL_UPDATE with defragmentation flag (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Update to firmware interface spec 1.7.0 (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: remove useless memset's in drivers get_stats64 (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix RTNL lock usage on bnxt_get_port_module_status() (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix RTNL lock usage on bnxt_update_link() (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix bnxt_reset() in the slow path task (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix "uninitialized variable" bug in TPA code path (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add the ulp_sriov_cfg hooks for bnxt_re RDMA driver (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add support for ethtool -p (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Update to firmware interface spec to 1.6.1 (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Clear TPA flags when BNXT_FLAG_NO_AGG_RINGS is set (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix compiler warnings when CONFIG_RFS_ACCEL is not defined (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Handle no aggregation ring gracefully (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Set default completion ring for async events (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Implement new scheme to reserve tx rings (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Assign additional vnics to VFs (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add new hardware RFS mode (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Refactor code that determines RFS capability (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add function to get vnic capability (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Refactor TPA code path (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix and clarify link_info->advertising (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Improve the IRQ disable sequence during shutdown (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Remove busy poll logic in the driver (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add interface to support RDMA driver (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Refactor the driver registration function with firmware (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Reserve RDMA resources by default (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Improve completion ring allocation for VFs (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Move function reset to bnxt_init_one() (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Enable MSIX early in bnxt_init_one() (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add bnxt_set_max_func_irqs() (Jonathan Toppins) [1382378]
- [netdrv] broadcom: propagate error code (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add PFC statistics (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Implement DCBNL to support host-based DCBX (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Update firmware header file to latest 1.6.0 (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Re-factor bnxt_setup_tc() (Jonathan Toppins) [1382378]
- [netdrv] bnxt: do not busy-poll when link is down (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix a VXLAN vs GENEVE issue (Jonathan Toppins) [1382378]
- [netdrv] bnxt: add a missing rcu synchronization (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add ethtool -n|-N rx-flow-hash support (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add UDP RSS support for 57X1X chips (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Enhance autoneg support (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Update firmware interface spec to 1.5.4 (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix VF virtual link state (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix ring arithmetic in bnxt_setup_tc() (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: do not call napi_hash_add() (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix build error for kernesl without RTC-LIB (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fixed the VF link status after a link state change (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Support for "ethtool -r" command (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Pad TX packets below 52 bytes (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Call firmware to approve the random VF MAC address (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Re-arrange bnxt_hwrm_func_qcaps() (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix ethtool -l|-L inconsistent channel counts (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Added support for Secure Firmware Update (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Update to firmware interface spec 1.5.1 (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Simplify PCI device names and add additinal PCI IDs (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Use RSS flags defined in the bnxt_hsi.h file (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Fix TX push operation on ARM64 (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Log a message, if enabling NTUPLE filtering fails (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Improve ntuple filters by checking destination MAC address (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Remove locking around txr->dev_state (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add BCM58700 PCI device ID for NS2 Nitro (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Workaround Nitro A0 RX hardware bug (part 4) (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Workaround Nitro A0 hardware RX bug (part 3) (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Workaround Nitro A0 hardware RX bug (part 2) (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Workaround Nitro A0 hardware RX bug (part 1) (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add basic support for Nitro in North Star 2 (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: initialize rc to zero to avoid returning garbage (Jonathan Toppins) [1382378]
- [netdrv] bnxt: fix a condition (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Allow statistics DMA to be configurable using ethtool -C (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Assign netdev->dev_port with port ID (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Allow promiscuous mode for VF if default VLAN is enabled (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Increase maximum supported MTU to 9500 (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Enable MRU enables bit when configuring VNIC MRU (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add support for firmware updates for additional processors (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Request firmware reset after successful firwmare update (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add support for updating flash more securely (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Do function reset on the 1st PF open only (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Update firmware spec. to 1.3.0 (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: VF/NPAR should return -EOPNOTSUPP for unsupported ethtool ops (Jonathan Toppins) [1382378]
- [netdrv] bnxt: Move GENEVE support from hard-coded port to using port notifier (Jonathan Toppins) [1382378]
- [netdrv] bnxt: Update drivers to support unified UDP encapsulation offload functions (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Support new ETHTOOL_{G|S}LINKSETTINGS API (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Don't allow autoneg on cards that don't support it (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Handle VF_CFG_CHANGE event from firmware (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add new function bnxt_reset() (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Add function for VF driver to query default VLAN (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Simplify VLAN receive logic (Jonathan Toppins) [1382378]
- [netdrv] bnxt_en: Enable and disable RX CTAG and RX STAG VLAN acceleration together (Jonathan Toppins) [1382378]
- [netdrv] bnxt: Add support for segmentation of tunnels with outer checksums (Jonathan Toppins) [1382378]

* Thu Mar 02 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-582.el7]
- [acpi] tools/power/acpi: Update Intel copyright (Prarit Bhargava) [1425180]
- [acpi] tools/power/acpi: Remove direct kernel source include reference (Prarit Bhargava) [1425180]
- [acpi] acpica: macosx: Fix wrong sem_destroy definition (Prarit Bhargava) [1425180]
- [acpi] acpica: macosx: Fix anonymous semaphore implementation (Prarit Bhargava) [1425180]
- [acpi] tools/power/acpi: fix typo in printk in ec help message (Prarit Bhargava) [1425180]
- [acpi] acpica: Cleanup for all string-to-integer conversions (Prarit Bhargava) [1425180]
- [acpi] acpica: clib: Eliminate acpi_os_XXXFile()/acpi_log_error and link clibrary fxxx()/errno/perror() instead (Prarit Bhargava) [1425180]
- [acpi] acpica: clib: Add -nostdinc support for EFI layer (Prarit Bhargava) [1425180]
- [acpi] acpica: msvc9: Fix <sys/stat.h> inclusion order issue (Prarit Bhargava) [1425180]
- [acpi] acpica: clib: Fix wrong mini C library usage (Prarit Bhargava) [1425180]
- [acpi] acpica: clib/efi: Fix wrong order of standard integer types/IO handles (Prarit Bhargava) [1425180]
- [acpi] acpica: clib: Fix build issues when ACPI_USE_STANDARD_HEADERS is not defined by converting size_t to acpi_size (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Fix a duplicate variable definition (Prarit Bhargava) [1425180]
- [acpi] acpica: osl: Add correct acpi_gbl_debug_timeout export to allow acpiexec to link (Prarit Bhargava) [1425180]
- [acpi] acpica: iasl/disassembler: Add a check for missing filename (Prarit Bhargava) [1425180]
- [acpi] tools/acpi: use CROSS_COMPILE to define prefix (Prarit Bhargava) [1425180]
- [acpi] acpica: Move all ASCII utilities to a common file (Prarit Bhargava) [1425180]
- [acpi] acpica: divergence: remove unwanted spaces for typedef (Prarit Bhargava) [1425180]
- [acpi] tools/power/acpi: close file only if it is open (Prarit Bhargava) [1425180]
- [acpi] acpica: utilities: Update for strtoul64 merger (Prarit Bhargava) [1425180]
- [acpi] acpica: Add support for QNX 6.6 platform (Prarit Bhargava) [1425180]
- [acpi] acpica: getopt: Comment update, no functional change (Prarit Bhargava) [1425180]
- [acpi] acpica: core: Major update for code formatting, no functional changes (Prarit Bhargava) [1425180]
- [acpi] tools/power/acpi: Add userspace AML interface support (Prarit Bhargava) [1425180]
- [acpi] acpica: iasl: General cleanup of the file suffix #defines (Prarit Bhargava) [1425180]
- [acpi] tools/power/acpi: Enable build for EC userspace tool (Prarit Bhargava) [1425180]
- [acpi] tools/power/acpi: Add descend support in ACPI tools Makefile (Prarit Bhargava) [1425180]
- [acpi] acpica: De-macroize calls to standard C library functions (Prarit Bhargava) [1425180]
- [acpi] acpi / acpidump: Update acpidump manual (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Convert the default behavior to dump from /sys/firmware/acpi/tables (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Allow customized tables to be dumped without accessing /dev/mem (Prarit Bhargava) [1425180]
- [acpi] acpica: Add dragon_fly support to unix file mapping file (Prarit Bhargava) [1425180]
- [acpi] acpica: Fix a sscanf format string (Prarit Bhargava) [1425180]
- [acpi] acpica: unix: Cleanup to use ACPI_TO_INTEGER() to calc page offset (Prarit Bhargava) [1425180]
- [acpi] acpica: acpiexec: Do not put STDIN into raw mode unless it is a terminal (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Add ACPI 1.0 RSDP support (Prarit Bhargava) [1425180]
- [acpi] acpica: acpihelp: Add UUID support, restructure some existing files (Prarit Bhargava) [1425180]
- [acpi] acpica: utprint/oslibcfs: cleanup - no functional change (Prarit Bhargava) [1425180]
- [acpi] acpica: osl: Update acpidump to reduce source code differences (Prarit Bhargava) [1425180]
- [acpi] acpica: utilities: Introduce acpi_log_error() to improve portability (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Reduce freopen() invocations to improve portability (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Replace file IOs with new APIs to improve portability (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Remove exit() from generic layer to improve portability (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Add memory/string OSL usage to improve portability (Prarit Bhargava) [1425180]
- [acpi] acpica: common: Enhance acpi_getopt() to improve portability (Prarit Bhargava) [1425180]
- [acpi] acpica: common: Enhance cm_get_file_size() to improve portability (Prarit Bhargava) [1425180]
- [acpi] acpica: application: Enhance ACPI_USAGE_xxx/ACPI_OPTION with acpi_os_printf() to improve portability (Prarit Bhargava) [1425180]
- [acpi] acpica: utilities: Add formatted printing APIs (Prarit Bhargava) [1425180]
- [acpi] acpica: osl: Add portable file IO to improve portability (Prarit Bhargava) [1425180]
- [acpi] acpica: osl: Clean up acpi_os_printf()/acpi_os_vprintf() stubs (Prarit Bhargava) [1425180]
- [acpi] acpica: utilities: Cleanup DEFINE_ACPI_GLOBALS by moving acpi_ut_init_global() from utglobal.c to utinit.c (Prarit Bhargava) [1425180]
- [acpi] acpica: osl: Update environments to improve portability (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Add support for ACPI 1.0 GUID in Linux (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Fix repetitive table dump in -n mode (Prarit Bhargava) [1425180]
- [acpi] acpica: tables: Add new mechanism to skip NULL entries in RSDT and XSDT (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Add support to force using RSDT (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Fix truncated RSDP signature validation (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Fix code issue in invoking fread in the loop (Prarit Bhargava) [1425180]
- [acpi] acpi / tools: Introduce ec_access.c - tool to access the EC (Prarit Bhargava) [1425180]
- [acpi] tools/power/acpi: Minor bugfixes (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Update man page (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Remove old acpidump source (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Update Makefile to build acpidump from ACPICA (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Cleanup tools/power/acpi makefiles (Prarit Bhargava) [1425180]
- [acpi] acpica: Remove bool usage from ACPICA (Prarit Bhargava) [1425180]
- [acpi] Fix x86 regression related to early mapping size limitation (Prarit Bhargava) [1425180]
- [acpi] acpica: tables: Add mechanism to control early table checksum verification (Prarit Bhargava) [1425180]
- [acpi] acpica: Fix buffer allocation issue for generic_serial_bus region accesses (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Add support to generate acpidump release (Prarit Bhargava) [1425180]
- [acpi] acpica: table manager: Split tbinstal.c into two files (Prarit Bhargava) [1425180]
- [acpi] acpica: table manager: Misc cleanup and renames, no functional change (Prarit Bhargava) [1425180]
- [acpi] acpica: tables: Add acpi_install_table() API for early table installation (Prarit Bhargava) [1425180]
- [acpi] acpica: tables: Avoid SSDT installation with acpi_gbl_disable_ssdt_table_load (Prarit Bhargava) [1425180]
- [acpi] acpica: tables: Cleanup ACPI_TABLE_ORIGIN_xxx flags (Prarit Bhargava) [1425180]
- [acpi] acpica: tables: Fix table checksums verification before installation (Prarit Bhargava) [1425180]
- [acpi] acpica: tables: Fix unbalanced table validations (Prarit Bhargava) [1425180]
- [acpi] acpica: tables: Clean up split INSTALLED/VALIDATED table state logics (Prarit Bhargava) [1425180]
- [acpi] acpica: tables: Fix multiple ACPI_FREE()s around acpi_tb_add_table() (Prarit Bhargava) [1425180]
- [acpi] acpica: tables: Fix the issues in handling virtual addressed tables (Prarit Bhargava) [1425180]
- [acpi] acpica: Remove indent divergences to reduce maintenance overhead (Prarit Bhargava) [1425180]
- [acpi] acpica: Add a missing field for debug dump of mutex objects (Prarit Bhargava) [1425180]
- [acpi] acpica: Update use of acpi_os_wait_events_complete interface (Prarit Bhargava) [1425180]
- [acpi] acpica: disassembler: Add decoding of Notify() values (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Update new structures and add missing file (Prarit Bhargava) [1425180]
- [acpi] acpica: disassembler: Add support to decode _HID and _CID values (Prarit Bhargava) [1425180]
- [acpi] acpica: unload operator: Emit a warning if and when it is ever used (Prarit Bhargava) [1425180]
- [acpi] acpica: Update comments for ACPICA name - no functional change (Prarit Bhargava) [1425180]
- [acpi] acpica: utstring: Check array index bound before use (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Remove integer types translation protection (Prarit Bhargava) [1425180]
- [acpi] acpica: acpidump: Add sparse declarators support (Prarit Bhargava) [1425180]
- [acpi] acpica: utilities: Cleanup declarations of the acpi_gbl_debug_file global (Prarit Bhargava) [1425180]
- [acpi] acpica: Cleanup the option of forcing the use of the RSDT (Prarit Bhargava) [1425180]
- [acpi] acpica: Cleanup asmlinkage for ACPICA APIs (Prarit Bhargava) [1425180]
- [acpi] acpica: Update acpidump related header file changes (Prarit Bhargava) [1425180]
- [acpi] acpica: Cleanup exception codes (Prarit Bhargava) [1425180]
- [acpi] Export acpi_os_get*() functions (Prarit Bhargava) [1425180]
- [acpi] acpica: Add new statistics interface (Prarit Bhargava) [1425180]
- [acpi] acpica: Add EXPORT_ACPI_INTERFACES macro to external interface modules (Prarit Bhargava) [1425180]
- [acpi] acpica: Cleanup memory allocation macros and configurability (Prarit Bhargava) [1425180]
- [acpi] acpica: tablemanager: Export acpi_tb_scan_memory_for_rsdp() (Prarit Bhargava) [1425180]
- [acpi] acpica: Export acpi_tb_validate_rsdp() (Prarit Bhargava) [1425180]

* Wed Mar 01 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-581.el7]
- [x86] kvm: vmx: use correct vmcs_read/write for guest segment selector/base (Radim Krcmar) [1420755]
- [x86] kvm: x86: do not save guest-unsupported XSAVE state (Radim Krcmar) [1420755]
- [x86] kvm: x86: fix emulation of "MOV SS, null selector" (Radim Krcmar) [1420755] {CVE-2017-2583}
- [x86] kvm: x86: flush pending lapic jump label updates on module unload (Radim Krcmar) [1420755]
- [kernel] jump_labels: API for flushing deferred jump label updates (Radim Krcmar) [1420755]
- [x86] kvm: x86: reset MMU on KVM_SET_VCPU_EVENTS (Radim Krcmar) [1420755]
- [x86] kvm: x86: check for pic and ioapic presence before use (Radim Krcmar) [1420755]
- [x86] kvm: x86: drop error recovery in em_jmp_far and em_ret_far (Radim Krcmar) [1420755]
- [x86] kvm: x86: fix out-of-bounds access in lapic (Radim Krcmar) [1420755]
- [x86] kvm: x86: fix missed SRCU usage in kvm_lapic_set_vapic_addr (Radim Krcmar) [1420755]
- [x86] kvm: Disable irq while unregistering user notifier (Radim Krcmar) [1420755]
- [x86] kvm: nvmx: VMCLEAR an active shadow VMCS after last use (Radim Krcmar) [1420755]
- [x86] kvm: x86: fix wbinvd_dirty_mask use-after-free (Radim Krcmar) [1420755]
- [x86] kvm: nvmx: Fix kernel panics induced by illegal INVEPT/INVVPID types (Radim Krcmar) [1420755]
- [x86] kvm: x86: memset whole irq_eoi (Radim Krcmar) [1420755]
- [x86] kvm: nvmx: Fix the NMI IDT-vectoring handling (Radim Krcmar) [1420755]
- [x86] kvm: nvmx: postpone VMCS changes on MSR_IA32_APICBASE write (Radim Krcmar) [1420755]
- [x86] kvm: nvmx: fix msr bitmaps to prevent L2 from accessing L0 x2APIC (Radim Krcmar) [1420755]
- [x86] kvm: x86: nvmx: maintain internal copy of current VMCS (Radim Krcmar) [1420755]
- [x86] kvm: vmx: handle PML full VMEXIT that occurs during event delivery (Radim Krcmar) [1420755]
- [virt] kvm: nvmx: Fix memory corruption when using VMCS shadowing (Radim Krcmar) [1420755]
- [virt] kvm: vmx: ensure VMCS is current while enabling PML (Radim Krcmar) [1420755]
- [virt] kvm: nvmx: vmx instructions: fix segment checks when L1 is in long mode (Radim Krcmar) [1420755]
- [virt] kvm: Fix irq route entries exceeding KVM_MAX_IRQ_ROUTES (Radim Krcmar) [1420755]
- [x86] svm: bitwise vs logical op typo (Radim Krcmar) [1420755]
- [virt] kvm: cap halt polling at exactly halt_poll_ns (Radim Krcmar) [1420755]
- [virt] kvm: async_pf: do not warn on page allocation failures (Radim Krcmar) [1420755]
- [x86] kvm: x86: fix conversion of addresses to linear in 32-bit protected mode (Radim Krcmar) [1420755]
- [x86] kvm: x86: only channel 0 of the i8254 is linked to the HPET (Radim Krcmar) [1420755]
- [x86] kvm: vmx: fix the writing POSTED_INTR_NV (Radim Krcmar) [1420755]
- [x86] kvm: x86: correctly print #AC in traces (Radim Krcmar) [1420755]
- [kernel] static_key: WARN on usage before jump_label_init was called (Radim Krcmar) [1420755]
- [x86] kvm: nvmx: check host CR3 on vmentry and vmexit (Ladi Prosek) [1326138]
- [x86] kvm: nvmx: introduce nested_vmx_load_cr3 and call it on vmentry (Ladi Prosek) [1326138]
- [x86] kvm: nvmx: propagate errors from prepare_vmcs02 (Ladi Prosek) [1326138]
- [x86] kvm: nvmx: fix CR3 load if L2 uses PAE paging and EPT (Ladi Prosek) [1326138]
- [x86] kvm: nvmx: support descriptor table exits (Ladi Prosek) [1326138]
- [x86] kvm: nvmx: invvpid handling improvements (Ladi Prosek) [1326138]
- [x86] kvm: vmx: clean up declaration of VPID/EPT invalidation types (Ladi Prosek) [1326138]
- [x86] nvmx: mark ept single context invalidation as supported (Ladi Prosek) [1326138]
- [x86] kvm: x86: drop TSC offsetting kvm_x86_ops to fix KVM_GET/SET_CLOCK (Marcelo Tosatti) [1415766]
- [x86] kvm: x86: do not go through vcpu in __get_kvmclock_ns (Marcelo Tosatti) [1415766]
- [uapi] kvm: kvmclock: let KVM_GET_CLOCK return whether the master clock is in use (Marcelo Tosatti) [1415766]
- [x86] kvm: x86: introduce get_kvmclock_ns (Marcelo Tosatti) [1415766]
- [x86] kvm: x86: initialize kvmclock_offset (Marcelo Tosatti) [1415766]
- [x86] pvclock: introduce seqcount-like API (Marcelo Tosatti) [1415766]
- [x86] pvclock: Get rid of __pvclock_read_cycles in function pvclock_read_flags (Marcelo Tosatti) [1415766]
- [x86] pvclock: Cleanup to remove function pvclock_get_nsec_offset (Marcelo Tosatti) [1415766]

* Wed Mar 01 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-580.el7]
- [crypto] ccp - Fix double add when creating new DMA command (Suravee Suthikulpanit) [1390820 1420977]
- [crypto] ccp - Fix DMA operations when IOMMU is enabled (Suravee Suthikulpanit) [1390820 1420977]
- [crypto] ccp: Do not support CCP crypto API in RHEL7 (Suravee Suthikulpanit) [1390820]
- [dma] dmaengine: Make channel allocation callbacks optional (Suravee Suthikulpanit) [1390820]
- [dma] dmaengine: Rework dma_chan_get (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Fix handling of RSA exponent on a v5 device (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Clean up the LSB slot allocation code (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - remove unneeded code (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - change bitfield type to unsigned ints (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Fix non static symbol warning (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - change type of struct member lsb to signed (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Make syslog errors human-readable (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - clean up data structure (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Fix return value check in ccp_dmaengine_register() (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - use kmem_cache_zalloc instead of kmem_cache_alloc/memset (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - add missing release in ccp_dmaengine_register (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Fix non static symbol warning (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Enable use of the additional CCP (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Enable DMA service on a v5 CCP (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Add support for the RNG in a version 5 CCP (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Let a v5 CCP provide the same function as v3 (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Refactor code to enable checks for queue space (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Refactor code supporting the CCP's RNG (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Refactor the storage block allocation code (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - refactoring: symbol cleanup (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Shorten the fields of the action structure (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Abstract PCI info for the CCP (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Fix non-conforming comment style (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - constify ccp_actions structure (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Ensure all dependencies are specified (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Register the CCP as a DMA resource (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Fix RT breaking #include <linux/rwlock_types.h> (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - fix lock acquisition code (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Add abstraction for device-specific calls (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - CCP versioning support (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Support for multiple CCPs (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Remove check for x86 family and model (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - use to_pci_dev and to_platform_device (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Use precalculated hash from headers (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Use module name in driver structures (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Change references to accelerator to offload (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Replace BUG_ON with WARN_ON and a return code (Suravee Suthikulpanit) [1390820]
- [crypto] drivers - Fix Kconfig selects (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Protect against poorly marked end of sg list (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Remove unused structure field (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Convert calls to their devm_ counterparts (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Update CCP build support (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Updates for checkpatch warnings/errors (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - terminate ccp_support array with empty element (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Check for CCP before registering crypto algs (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Do not sign extend input data to CCP (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Remove "select OF" from Kconfig (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Base AXI DMA cache settings on device tree (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Modify PCI support in prep for arm64 support (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Use pci_enable_msix_range() instead of pci_enable_msix() (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Perform completion callbacks using a tasklet (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Move HMAC calculation down to ccp ops file (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Fix ccp_run_passthru_cmd dma variable assignments (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - CCP device enabled/disabled changes (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Change data length declarations to u64 (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - Remove redundant dev_set_drvdata (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - CCP Kconfig fixes (Suravee Suthikulpanit) [1390820]
- [crypto] crytpo: ccp - fix coccinelle warnings (Suravee Suthikulpanit) [1390820]
- [crypto] crytpo: ccp - CCP device driver build files (Suravee Suthikulpanit) [1390820]
- [crypto] ccp - CCP device driver and interface support (Suravee Suthikulpanit) [1390820]
- [acpi] revert "acpi / apd: Remove CLK_IS_ROOT" (Suravee Suthikulpanit) [1422966]
- [tty] serial: 8250dw: Add device HID for future AMD UART controller (Suravee Suthikulpanit) [1422966]

* Tue Feb 28 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-579.el7]
- [fs] red hat kabi: Added flag signifying the use of file_operations_extend structure (Steve Dickson) [1356123]
- [fs] red hat kabi: Remove the file operations that cause the kABI breakage (Steve Dickson) [1356123]
- [fs] red hat kabi: Add new system call to nfs in a kABI compatible way (Steve Dickson) [1356123]
- [fs] red hat kabi: introduce new calls to file_operations_extend (Steve Dickson) [1356123]
- [fs] red hat kabi: Use #ifndef __GENKSYMS__ to maintain kAPI (Steve Dickson) [1356123]
- [fs] try to clone files first in vfs_copy_file_range (Steve Dickson) [1356123]
- [fs] nfs: Add COPY nfs operation (Steve Dickson) [1356123]
- [fs] nfs: Add nfs_commit_file() (Steve Dickson) [1356123]
- [fs] vfs: pull btrfs clone API to vfs layer (Steve Dickson) [1356123]
- [fs] locks: new locks_mandatory_area calling convention (Steve Dickson) [1356123]
- [fs] locks: make locks_mandatory_area check for file-private locks (Steve Dickson) [1356123]
- [fs] vfs: Add vfs_copy_file_range() support for pagecache copies (Steve Dickson) [1356123]
- [fs] powerpc: Wire up copy_file_range() syscall (Steve Dickson) [1356123]
- [fs] s390: wire up copy_file_range syscall (Steve Dickson) [1356123]
- [fs] x86: add sys_copy_file_range to syscall tables (Steve Dickson) [1356122 1356123]
- [fs] vfs: add copy_file_range syscall and vfs helper (Steve Dickson) [1356123]
- [fs] sunrpc: don't call sleeping functions from the notifier block callbacks (Scott Mayhew) [1422910]
- [fs] lockd: unregister notifier blocks if the service fails to come up completely (Scott Mayhew) [1422910]
- [fs] lockd: Register callbacks on the inetaddr_chain and inet6addr_chain (Scott Mayhew) [1422910]
- [fs] nfsd: Implement the COPY call (Steve Dickson) [1356122]
- [fs] nfsd: implement the NFSv4.2 CLONE operation (Steve Dickson) [1356122]
- [fs] nfs: Don't take a reference on fl->fl_file for LOCK operation (Benjamin Coddington) [1386924]
- [fs] gfs2: mark the journal idle to fix ro mounts (Robert S Peterson) [1213119]
- [fs] auth_gss: fix panic in gss_pipe_downcall() in fips mode (Dave Wysochanski) [1316251]
- [fs] fuse: add support for SEEK_HOLE and SEEK_DATA in lseek (Carlos Maiolino) [1306396]
- [fs] ext4: Fix handling of extended tv_sec (Carlos Maiolino) [1278465]

* Tue Feb 28 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-578.el7]
- [net] fix creation adjacent device symlinks (Adrian Reber) [1412898]
- [net] prevent of emerging cross-namespace symlinks (Adrian Reber) [1412898]
- [netdrv] macvlan: unregister net device when netdev_upper_dev_link() fails (Adrian Reber) [1412898]
- [net] netfilter: nft_range: add the missing NULL pointer check (Phil Sutter) [1418969]
- [net] netfilter: nf_tables: simplify the basic expressions' init routine (Phil Sutter) [1418969]
- [net] netfilter: nf_tables: avoid uninitialized variable warning (Phil Sutter) [1418969]
- [net] netfilter: nft_range: validate operation netlink attribute (Phil Sutter) [1418969]
- [net] netfilter: nf_tables: add range expression (Phil Sutter) [1418969]
- [net] netfilter: nf_tables: remove useless U8_MAX validation (Phil Sutter) [1418969]
- [net] netfilter: nf_tables: fix type mismatch with error return from nft_parse_u32_check (Phil Sutter) [1418969]
- [net] netfilter: nft_exthdr: fix error handling in nft_exthdr_init() (Phil Sutter) [1418969]
- [net] netfilter: nf_tables: underflow in nft_parse_u32_check() (Phil Sutter) [1418969]
- [net] netfilter: nf_tables: validate maximum value of u32 netlink attributes (Phil Sutter) [1418969]
- [net] netfilter: nft_exthdr: Add size check on u8 nft_exthdr attributes (Phil Sutter) [1418969]
- [net] ipv6: Don't use ufo handling on later transformed packets (Jakub Sitnicki) [1388846]
- [net] vxlan: fix oops in dev_fill_metadata_dst (Paolo Abeni) [1423068]
- [net] ip_forward: Drop frames with attached skb->sk (Florian Westphal) [1421006]
- [net] ipv4: ip_forward: perform skb->pkt_type check at the beginning (Florian Westphal) [1421006]
- [lib] rhashtable-test: Get rid of previous workaround (Phil Sutter) [1393817]
- [lib] rhashtable-test: Fix max_size parameter description (Phil Sutter) [1393817]
- [lib] rhashtable-test: allow to retry even if -ENOMEM was returned (Phil Sutter) [1393817]
- [lib] rhashtable-test: retry insert operations (Phil Sutter) [1393817]
- [lib] rhashtable-test: add cond_resched() to thread test (Phil Sutter) [1393817]
- [lib] rhashtable: Add rhlist interface (Phil Sutter) [1393817]
- [lib] rhashtable: fix a memory leak in alloc_bucket_locks() (Phil Sutter) [1393817]
- [lib] rhashtable: add rhashtable_lookup_get_insert_key() (Phil Sutter) [1393817]
- [lib] rhashtable: Remove GFP flag from rhashtable_walk_init (Phil Sutter) [1393817]
- [lib] rhashtable: fix shift by 64 when shrinking (Phil Sutter) [1393817]
- [lib] rhashtable: avoid large lock-array allocations (Phil Sutter) [1393817]
- [lib] rhashtable: accept GFP flags in rhashtable_walk_init (Phil Sutter) [1393817]
- [net] netfilter: built-in NAT support for UDPlite (Davide Caratti) [1357840]
- [net] netfilter: built-in NAT support for SCTP (Davide Caratti) [1357840]
- [net] netfilter: built-in NAT support for DCCP (Davide Caratti) [1357840]
- [net] netfilter: conntrack: built-in support for UDPlite (Davide Caratti) [1387537]
- [net] netfilter: conntrack: built-in support for SCTP (Davide Caratti) [1387537]
- [net] netfilter: conntrack: built-in support for DCCP (Davide Caratti) [1387537]
- [net] netfilter: conntrack: simplify init/uninit of L4 protocol trackers (Davide Caratti) [1387537]
- [net] igmp, mld: Fix memory leak in igmpv3/mld_del_delrec() (Hangbin Liu) [1420972]
- [net] mld: do not remove mld souce list info when set link down (Hangbin Liu) [1383584]
- [net] openvswitch: maintain correct checksum state in conntrack actions (Lance Richardson) [1409558]

* Mon Feb 27 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-577.el7]
- [net] introduce net_device_extended (Jiri Benc) [1382040]
- [net] bonding: update documentation section after dev->trans_start removal (Ivan Vecera) [1382040]
- [net] deprecate dev->trans_start (Ivan Vecera) [1382040]
- [netdrv] replace dev->trans_start update with helper (Ivan Vecera) [1382040]
- [net] netdevice: add helper to update trans_start (Ivan Vecera) [1382040]
- [netdrv] replace dev->trans_start accesses with dev_trans_start (Ivan Vecera) [1382040]
- [net] sched: make dev_trans_start return vlan's real dev trans_start (Ivan Vecera) [1382040]
- [net] ptp: Introduce a high resolution frequency adjustment method (Ivan Vecera) [1382040]
- [net] ipip: Properly mark ipip GRO packets as encapsulated (Ivan Vecera) [1382040]
- [net] introduce csum_replace_by_diff() helper (Ivan Vecera) [1382040]
- [net] ipv6: gro: support sit protocol (Ivan Vecera) [1382040]
- [net] skb_segment() should preserve backpressure (Ivan Vecera) [1382040]
- [net] skb_segment() provides list head and tail (Ivan Vecera) [1382040]
- [net] ipip: Add gro callbacks to ipip offload (Ivan Vecera) [1382040]
- [kernel] list: fix order of arguments for hlist_add_after(_rcu) (Ivan Vecera) [1382040]
- [kernel] list: make hlist_add_after() argument names match hlist_add_after_rcu() (Ivan Vecera) [1382040]
- [net] rtnl: stats - add missing netlink message size checks (Ivan Vecera) [1382040]
- [net] rtnl: info leak in rtnl_fill_vfinfo() (Ivan Vecera) [1382040]
- [net] rtnl: avoid uninitialized data in IFLA_VF_VLAN_LIST handling (Ivan Vecera) [1382040]
- [net] Update API for VF vlan protocol 802.1ad support (Ivan Vecera) [1382040]
- [net] introduce default neigh_construct/destroy ndo calls for L2 upper devices (Ivan Vecera) [1382040]
- [net] add dev arg to ndo_neigh_construct/destroy (Ivan Vecera) [1382040]
- [net] add netdev_lockdep_set_classes() helper (Ivan Vecera) [1382040]
- [documentation] taskstats: fix nl parsing in accounting/getdelays.c (Ivan Vecera) [1382040]
- [net] neigh: align nlattr properly when needed (Ivan Vecera) [1382040]
- [net] rtnl: align nlattr properly when needed (Ivan Vecera) [1382040]
- [net] openvswitch: align nlattr properly when needed (Ivan Vecera) [1382040]
- [net] sock_diag: align nlattr properly when needed (Ivan Vecera) [1382040]
- [fs] quota: use nla_put_u64_64bit() (Ivan Vecera) [1382040]
- [net] macsec: use nla_put_u64_64bit() (Ivan Vecera) [1382040]
- [net] wireless: use nla_put_u64_64bit() (Ivan Vecera) [1382040]
- [net] ieee802154: use nla_put_u64_64bit() (Ivan Vecera) [1382040]
- [net] l2tp: use nla_put_u64_64bit() (Ivan Vecera) [1382040]
- [net] bridge: use nla_put_u64_64bit() (Ivan Vecera) [1382040]
- [net] openvswitch: use nla_put_u64_64bit() (Ivan Vecera) [1382040]
- [net] sched: use nla_put_u64_64bit() (Ivan Vecera) [1382040]
- [net] rtnl: use nla_put_u64_64bit() (Ivan Vecera) [1382040]
- [kernel] taskstats: use the libnl API to align nlattr on 64-bit (Ivan Vecera) [1382040]
- [net] xfrm: align nlattr properly when needed (Ivan Vecera) [1382040]
- [net] libnl: add nla_put_u64_64bit() helper (Ivan Vecera) [1382040]
- [net] libnl: nla_put_msecs(): align on a 64-bit area (Ivan Vecera) [1382040]
- [net] libnl: nla_put_s64(): align on a 64-bit area (Ivan Vecera) [1382040]
- [net] libnl: nla_put_net64(): align on a 64-bit area (Ivan Vecera) [1382040]
- [net] libnl: nla_put_be64(): align on a 64-bit area (Ivan Vecera) [1382040]
- [net] libnl: nla_put_le64(): align on a 64-bit area (Ivan Vecera) [1382040]
- [net] libnl: fix help of _64bit functions (Ivan Vecera) [1382040]
- [net] ip6mr: align RTA_MFC_STATS on 64-bit (Ivan Vecera) [1382040]
- [net] ipmr: align RTA_MFC_STATS on 64-bit (Ivan Vecera) [1382040]
- [net] rtnl: use the new API to align IFLA_STATS* (Ivan Vecera) [1382040]
- [net] libnl: add more helpers to align attributes on 64-bit (Ivan Vecera) [1382040]
- [net] nla_align_64bit() needs to test the right pointer. (Ivan Vecera) [1382040]
- [net] rtnetlink: add new RTM_GETSTATS message to dump link stats (Ivan Vecera) [1382040]
- [net] fix HAVE_EFFICIENT_UNALIGNED_ACCESS typos (Ivan Vecera) [1382040]
- [net] Add helpers for 64-bit aligning netlink attributes. (Ivan Vecera) [1382040]
- [net] Align IFLA_STATS64 attributes properly on architectures that need it. (Ivan Vecera) [1382040]
- [net] rtnetlink: rtnl_fill_stats: avoid an unnecssary stats copy (Ivan Vecera) [1382040]
- [net] sched: do not requeue a NULL skb (Ivan Vecera) [1382040]
- [net] netlink: use nla_get_in_addr and nla_put_in_addr for ipv4 address (Ivan Vecera) [1382040]
- [net] rtnetlink: fix frame size warning in rtnl_fill_ifinfo (Ivan Vecera) [1382040]
- [net] netfilter: nfnetlink_cthelper: Remove 'const' and '&' to avoid warnings (Ivan Vecera) [1382040]
- [net] qdisc: validate skb without holding lock (Ivan Vecera) [1382040]
- [net] netlink: Fix shadow warning on jiffies (Ivan Vecera) [1382040]
- [net] sch_tbf: Fix potential memory leak in tbf_change() (Ivan Vecera) [1382040]
- [net] sch_netem: support of 64bit rates (Ivan Vecera) [1382040]
- [net] sch_netem: more precise length of packets (Ivan Vecera) [1382040]
- [net] sch_tbf: add TBF_BURST/TBF_PBURST attribute (Ivan Vecera) [1382040]
- [net] sch_tbf: use do_div() for 64-bit divide (Ivan Vecera) [1382040]
- [net] sched: tbf: fix the calculation of max_size (Ivan Vecera) [1382040]
- [kernel] taskstats: add nla_nest_cancel() for failure processing between nla_nest_start() and nla_nest_end() (Ivan Vecera) [1382040]
- [net] net_sched: tbf: support of 64bit rates (Ivan Vecera) [1382040]
- [net] netevent/netlink.h: Remove extern from function prototypes (Ivan Vecera) [1382040]
- [net] net_sched: htb: support of 64bit rates (Ivan Vecera) [1382040]
- [net] net_sched: add u64 rate to psched_ratecfg_precompute() (Ivan Vecera) [1382040]
- [net] ipv4: Update parameters for csum_tcpudp_magic to their original types (Ivan Vecera) [1382040]
- [net] tcp: reserve tcp_skb_mss() to tcp stack (Ivan Vecera) [1382040]
- [net] ipvs: properly declare tunnel encapsulation (Ivan Vecera) [1382040]
- [net] sit: use kfree_skb to replace dev_kfree_skb (Ivan Vecera) [1382040]

* Fri Feb 24 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-576.el7]
- [netdrv] cxgb4/cxgb4vf: Allocate more queues for 25G and 100G adapter (Don Dutile) [1385866 1417284]
- [netdrv] mlx5: E-Switch, Handle mode change failures (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: E-Switch, Fix error flow in the SRIOV e-switch init code (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Fix flow counter bulk command out mailbox allocation (Don Dutile) [1385330 1417284]
- [infiniband] ib/rdmavt: Don't vfree a kzalloc'ed memory region (Don Dutile) [1385848 1417284]
- [infiniband] ib/rxe: Fix kmem_cache leak (Don Dutile) [1417284]
- [infiniband] ib/rxe: Fix race condition between requester and completer (Don Dutile) [1417284]
- [infiniband] ib/rxe: Fix duplicate atomic request handling (Don Dutile) [1417284]
- [infiniband] ib/rxe: Fix kernel panic in udp_setup_tunnel (Don Dutile) [1417284]
- [infiniband] ib/mlx5: Set source mac address in FTE (Don Dutile) [1417284]
- [infiniband] ib/mlx5: Enable MAD_IFC commands for IB ports only (Don Dutile) [1417284]
- [infiniband] ib/mlx4: Diagnostic HW counters are not supported in slave mode (Don Dutile) [1385329 1417284]
- [infiniband] ib/mlx4: Use correct subnet-prefix in QP1 mads under SR-IOV (Don Dutile) [1385329 1417284]
- [infiniband] ib/mlx4: Fix code indentation in QP1 MAD flow (Don Dutile) [1385329 1417284]
- [infiniband] ib/mlx4: Fix incorrect MC join state bit-masking on SR-IOV (Don Dutile) [1385329 1417284]
- [infiniband] ib/ipoib: Don't allow MC joins during light MC flush (Don Dutile) [1417284]
- [infiniband] ib/rxe: fix GFP_KERNEL in spinlock context (Don Dutile) [1417284]
- [netdrv] mlx4_en: fix off by one in error handling (Don Dutile) [1385329 1417284]
- [netdrv] mlx4_en: Fix panic on xmit while port is down (Don Dutile) [1385329 1417284]
- [netdrv] mlx4_en: Fixes for DCBX (Don Dutile) [1385329 1417284]
- [netdrv] mlx4_en: Fix the return value of mlx4_en_dcbnl_set_state() (Don Dutile) [1385329 1417284]
- [netdrv] mlx4_en: Fix the return value of mlx4_en_dcbnl_set_all() (Don Dutile) [1385329 1417284]
- [netdrv] mlx5e: Fix parsing of vlan packets when updating lro header (Don Dutile) [1417284]
- [netdrv] mlx5e: Fix global PFC counters replication (Don Dutile) [1417284]
- [netdrv] mlx5e: Prevent casting overflow (Don Dutile) [1417284]
- [netdrv] mlx5e: Move an_disable_cap bit to a new position (Don Dutile) [1417284]
- [netdrv] mlx5e: Fix xmit_more counter race issue (Don Dutile) [1417284]
- [net] xprtrdma: Fix receive buffer accounting (Don Dutile) [1417284]
- [net] xprtrdma: revert 3d4cf35bd4fa ("xprtrdma: Reply buffer exhaustion...") (Don Dutile) [1417284]
- [infiniband] iw_cxgb4: block module unload until all ep resources are released (Don Dutile) [1385866 1417284]
- [infiniband] iw_cxgb4: call dev_put() on l2t allocation failure (Don Dutile) [1385866 1417284]
- [infiniband] ib/hfi1: Rework debugfs to use SRCU (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Make n_krcvqs be an unsigned long integer (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Add QSFP sanity pre-check (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix AHG KDETH Intr shift (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix SGE length for misaligned PIO copy (Don Dutile) [1382806 1417284]
- [infiniband] ib/mlx5: Don't return errors from poll_cq (Don Dutile) [1385330 1417284]
- [infiniband] ib/mlx5: Use TIR number based on selector (Don Dutile) [1385330 1417284]
- [infiniband] ib/mlx5: Simplify code by removing return variable (Don Dutile) [1385330 1417284]
- [infiniband] ib/mlx5: Return EINVAL when caller specifies too many SGEs (Don Dutile) [1385330 1417284]
- [infiniband] ib/mlx4: Don't return errors from poll_cq (Don Dutile) [1417284]
- [infiniband] revert "ib/mlx4: Return EAGAIN for any error in mlx4_ib_poll_one" (Don Dutile) [1417284]
- [infiniband] ib/ipoib: Fix memory corruption in ipoib cm mode connect flow (Don Dutile) [1417284]
- [infiniband] ib/core: Fix use after free in send_leave function (Don Dutile) [1417284]
- [infiniband] ib/cxgb4: Make _free_qp static to silence build warning (Don Dutile) [1385866 1417284]
- [infiniband] ib/isert: Properly release resources on DEVICE_REMOVAL (Don Dutile) [1417284]
- [infiniband] ib/hfi1: Fix the size parameter to find_first_bit (Don Dutile) [1382806 1417284]
- [infiniband] ib/mlx5: Fix the size parameter to find_first_bit (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Increase number of ethtool steering priorities (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Add error prints when validate ETS failed (Don Dutile) [1385330 1417284]
- [netdrv] mlx5e: Fix memory leak if refreshing TIRs fails (Don Dutile) [1417284]
- [netdrv] mlx5e: Add ethtool counter for TX xmit_more (Don Dutile) [1417284]
- [netdrv] mlx5e: Fix ethtool -g/G rx ring parameter report with striding RQ (Don Dutile) [1417284]
- [netdrv] mlx5e: Don't wait for SQ completions on close (Don Dutile) [1417284]
- [netdrv] mlx5e: Don't post fragmented MPWQE when RQ is disabled (Don Dutile) [1417284]
- [netdrv] mlx5e: Don't wait for RQ completions on close (Don Dutile) [1417284]
- [netdrv] mlx5e: Limit UMR length to the device's limitation (Don Dutile) [1417284]
- [infiniband] ib/hfi1: Clean up type used and casting (Don Dutile) [1382806 1417284]
- [infiniband] ib/srpt: Update sport->port_guid with each port refresh (Don Dutile) [1417284]
- [infiniband] ib/mlx5: Remove superfluous include of io-mapping.h (Don Dutile) [1385330 1417284]
- [infiniband] i40iw: Do not set self-referencing pointer to NULL after kfree (Don Dutile) [1417284]
- [infiniband] iw_cxgb4: Fix cxgb4 arm CQ logic w/IB_CQ_REPORT_MISSED_EVENTS (Don Dutile) [1385866 1417284]
- [rdma] ib/core: Use memdup_user() rather than duplicating its implementation (Don Dutile) [1417284]
- [infiniband] ib/qib: Use memdup_user() rather than duplicating its implementation (Don Dutile) [1381986 1417284]
- [infiniband] iw_cxgb4: use the MPA initiator's IRD if < our ORD (Don Dutile) [1385866 1417284]
- [infiniband] iw_cxgb4: limit IRD/ORD advertised to ULP by device max (Don Dutile) [1385866 1417284]
- [infiniband] ib/rdmvat: Fix double vfree() in rvt_create_qp() error path (Don Dutile) [1385848 1417284]
- [infiniband] ib/hfi1: Improve J_KEY generation (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Return invalid field for non-QSFP CableInfo queries (Don Dutile) [1382806 1417284]
- [infiniband] ib/usnic: Fix error return code (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Add missing error code assignment before test (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Using kfree_rcu() to simplify the code (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Validate header in set_armed_active (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Pass packet ptr to set_armed_active (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fetch monitor values on-demand for CableInfo query (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1, ib/qib: Fix qp_stats sleep with rcu read lock held (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Remove duplicated include from affinity.c (Don Dutile) [1382806 1417284]
- [infiniband] ib/isert: fix error return code in isert_alloc_login_buf() (Don Dutile) [1417284]
- [infiniband] ib/core: Fix possible memory leak in cma_resolve_iboe_route() (Don Dutile) [1417284]
- [infiniband] ib/hfi1: Allocate cpu mask on the heap to silence warning (Don Dutile) [1382806 1417284]
- [infiniband] ib/mlx4: Return EAGAIN for any error in mlx4_ib_poll_one (Don Dutile) [1385329 1417284]
- [infiniband] ib/mlx4: Make function use_tunnel_data return void (Don Dutile) [1385329 1417284]
- [netdrv] mlx5: E-Switch, Avoid ACLs in the offloads mode (Don Dutile) [1417284]
- [netdrv] mlx5: E-Switch, Set the send-to-vport rules in the correct table (Don Dutile) [1417284]
- [netdrv] mlx5: E-Switch, Return the correct devlink e-switch mode (Don Dutile) [1417284]
- [netdrv] mlx5e: Retrieve the switchdev id from the firmware only once (Don Dutile) [1417284]
- [netdrv] mlx5: Update last-use statistics for flow rules (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Added missing check of msg length in verifying its signature (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Fix pci error recovery flow (Don Dutile) [1385330 1417284]
- [netdrv] mlx5e: Optimization for MTU change (Don Dutile) [1417284]
- [netdrv] mlx5e: Set port MTU on netdev creation rather on open (Don Dutile) [1417284]
- [netdrv] cxgb4: Fixes resource allocation for ULD's in kdump kernel (Don Dutile) [1385866 1417284]
- [infiniband] Soft RoCE driver (Don Dutile) [1384574 1417284]
- [infiniband] ib/uverbs: Fix race between uverbs_close and remove_one (Don Dutile) [1417284]
- [infiniband] ib/mthca: Clean up error unwind flow in mthca_reset() (Don Dutile) [1417284]
- [infiniband] ib/mthca: NULL arg to pci_dev_put is OK (Don Dutile) [1417284]
- [infiniband] ib/hfi1: NULL arg to sc_return_credits is OK (Don Dutile) [1382806 1417284]
- [infiniband] Use smaller 512 byte messages for portmapper messages (Don Dutile) [1417284]
- [infiniband] ib/ipoib: Report SG feature regardless of HW UD CSUM capability (Don Dutile) [1385329 1417284]
- [infiniband] ib/mlx4: Don't use GFP_ATOMIC for CQ resize struct (Don Dutile) [1385329 1417284]
- [infiniband] ib/hfi1: Expand reported serial number (Don Dutile) [1382806 1417284]
- [uapi] ib/hfi1: Allow for non-double word multiple message sizes for user SDMA (Don Dutile) [1382806 1417284]
- [rdma] ib/rdmavt: Eliminate redundant opcode test in mr ref clear (Don Dutile) [1385848 1417284]
- [infiniband] ib/hfi1: Handle kzalloc failure in init_pervl_scs (Don Dutile) [1382806 1417284]
- [infiniband] ib/qib, ib/hfi1: Fix grh creation in ud loopback (Don Dutile) [1381986 1417284]
- [infiniband] ib/hfi1: Use hdr2sc function to calculate 5-bit SC (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Cleanup UD packet handler (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Rename hfi1_pio_header to hfi1_sdma_header (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Rename struct ahg_ib_header to struct hfi1_ahg_info (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Remove unused elements from struct ahg_ib_header (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Reset QSFP on every run through channel tuning (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Ignore QSFP interrupts until power stabilizes (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Disable external device configuration requests (Don Dutile) [1382806 1417284]
- [rdma] ib/rdmavt, hfi1: Fix NFSoRDMA failure with FRMR enabled (Don Dutile) [1382806 1417284]
- [rdma] ib/hfi1: Add the capability for reserved operations (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix trace message units (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Add sysfs entry to override SDMA interrupt affinity (Don Dutile) [1382806 1417284]
- [lib] cpumask: factor out show_cpumap into separate helper function (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Add static PCIe Gen3 CTLE tuning (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix "suspicious rcu_dereference_check() usage" warnings (Don Dutile) [1382806 1417284]
- [infiniband] ib/rdmavt: Add missing spin_lock_init call for rdi->n_cqs_lock (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Read all firmware versions (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Explain state complete frame details (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Modify the default number of kernel receive conexts (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Add support for extended memory management (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Work request processing for fast register mr and invalidate (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Handle send with invalidate opcode in the RC recv path (Don Dutile) [1382806 1417284]
- [rdma] ib/rdmavt: Handle local operations in post send (Don Dutile) [1382806 1417284]
- [rdma] ib/rdmavt: Add mechanism to invalidate MR keys (Don Dutile) [1382806 1417284]
- [infiniband] ib/rdmavt: Add support for ib_map_mr_sg (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Pull FECN/BECN processing to a common place (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix to fully initialize send context area (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix integrity errors counter value calculation (Don Dutile) [1382806 1417284]
- [infiniband] ib/rdmavt: Use new driver specific post send table (Don Dutile) [1382806 1417284]
- [infiniband] ib/qib: Add qib post send table (Don Dutile) [1381986 1417284]
- [infiniband] ib/hfi1: Add hfi1 post send tables (Don Dutile) [1382806 1417284]
- [rdma] ib/rdmavt: Add data structures and routines for table driven post send (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Correct receive packet handler assignment (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Improve SDMA engine assignment for user SDMA (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Refine user process affinity algorithm (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Reserve and collapse CPU cores for contexts (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Add global structure for affinity assignments (Don Dutile) [1382806 1417284]
- [infiniband] iw_cm: free cm_id resources on the last deref (Don Dutile) [1385866 1417284]
- [infiniband] iw_cxgb4: don't block in destroy_qp awaiting the last deref (Don Dutile) [1385866 1417284]
- [infiniband] iw_cxgb4: explicitly move the qp to ERROR state during flush (Don Dutile) [1385866 1417284]
- [infiniband] iw_cxgb4: stop MPA_REPLY timer when disconnecting (Don Dutile) [1385866 1417284]
- [infiniband] ib/core: Add flow control to the portmapper netlink calls (Don Dutile) [1385866 1417284]
- [infiniband] rdma/cxgb3: Use AF_INET for sin_family field (Don Dutile) [1385866 1417284]
- [infiniband] rdma/iw_cxgb4: Use kfree_skb instead of kfree (Don Dutile) [1385866 1417284]
- [infiniband] ib/mlx5: Fix duplicate const warning (Don Dutile) [1385330 1417284]
- [infiniband] ib/isert: Remove an unused member variable (Don Dutile) [1417284]
- [infiniband] ib/srpt: Simplify srpt_queue_response() (Don Dutile) [1417284]
- [infiniband] ib/srpt: Limit the number of SG elements per work request (Don Dutile) [1417284]
- [rdma] ib/core, rdma rw api: Do not exceed QP SGE send limit (Don Dutile) [1417284]
- [infiniband] ib/core: Make rdma_rw_ctx_init() initialize all used fields (Don Dutile) [1417284]
- [infiniband] ib/hfi1: Add counter to track unsupported packets drop (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Add VL XmitDiscards counters to the opapmaquery (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix trace sparse errors (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Separate tracepoints into specific headers (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix typo (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Remove unnecessary done label in hfi1_write_iter (Don Dutile) [1382806 1417284]
- [rdma] ib/hfi1: Clean up port state structure definition (Don Dutile) [1382806 1417284]
- [netdrv] mlx5_core/health: Remove deprecated create_singlethread_workqueue (Don Dutile) [1385330 1417284]
- [netdrv] mlx4_core: Check device state before unregistering it (Don Dutile) [1385329 1417284]
- [netdrv] mlx5e: Query minimum required header copy during xmit (Don Dutile) [1383787 1417284]
- [netdrv] mlx5e: Check the minimum inline header mode before xmit (Don Dutile) [1383787 1417284]
- [target] libcxgb: add library module for Chelsio drivers (Don Dutile) [1417284]
- [netdrv] mlx5: Use PTR_ERR_OR_ZERO() to simplify the code (Don Dutile) [1385330 1417284]
- [netdrv] mlx4_en: break out tx_desc write into separate function (Don Dutile) [1385329 1417284]
- [net] xprtrdma: fix semicolon.cocci warnings (Don Dutile) [1417284]
- [net] rds: tcp: Enable multipath RDS for TCP (Don Dutile) [1417284]
- [net] rds: tcp: Reduce code duplication in rds_tcp_reset_callbacks() (Don Dutile) [1417284]
- [net] rds: tcp: avoid bad page reference in rds_tcp_listen_data_ready (Don Dutile) [1417284]
- [netdrv] mlx5: E-Switch, Add API to configure rules for the offloaded mode (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: E-Switch, Use two priorities for SRIOV offloads mode (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Introduce bulk reading of flow counters (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Store counters in rbtree instead of list (Don Dutile) [1385330 1417284]
- [net] xprtrdma: No direct data placement with krb5i and krb5p (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Clean up fixup_copy_count accounting (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Update only specific fields in private receive buffer (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Do not update {head, tail}.iov_len in rpcrdma_inline_fixup() (Don Dutile) [1401797 1417284]
- [net] xprtrdma: rpcrdma_inline_fixup() overruns the receive page list (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Chunk list encoders no longer share one rl_segments array (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Place registered MWs on a per-req list (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Release orphaned MRs immediately (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Allocate MRs on demand (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Chunk list encoders must not return zero (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Honor ->send_request API contract (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Reply buffer exhaustion can be catastrophic (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Clean up device capability detection (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Remove rpcrdma_map_one() and friends (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Remove ALLPHYSICAL memory registration mode (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Do not leak an MW during a DMA map failure (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Refactor MR recovery work queues (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Use scatterlist for DMA mapping and unmapping under FMR (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Rename fields in rpcrdma_fmr (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Move init and release helpers (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Create common scatterlist fields in rpcrdma_mw (Don Dutile) [1401797 1417284]
- [net] xprtrdma: Remove FMRs from the unmap list after unmapping (Don Dutile) [1401797 1417284]
- [netdrv] mlx5e: Expose flow control counters to ethtool (Don Dutile) [1383601 1417284]
- [netdrv] mlx5e: Expose RDMA VPort counters to ethtool (Don Dutile) [1383601 1417284]
- [netdrv] mlx5e: Add support to get ethtool flow rules (Don Dutile) [1383601 1417284]
- [netdrv] mlx5e: Support l3/l4 flow type specs in ethtool flow steering (Don Dutile) [1383601 1417284]
- [netdrv] mlx5e: Add ethtool flow steering support (Don Dutile) [1383601 1417284]
- [netdrv] mlx5: Properly remove all steering objects (Don Dutile) [1383601 1417284]
- [netdrv] mlx5: Introduce mlx5_flow_steering structure (Don Dutile) [1383601 1417284]
- [netdrv] mlx5: Refactor mlx5_add_flow_rule (Don Dutile) [1383601 1417284]
- [netdrv] mlx4: Fix some indent inconsistancy (Don Dutile) [1385329 1417284]
- [netdrv] mlx5e: Introduce SRIOV VF representors (Don Dutile) [1383788 1417284]
- [netdrv] mlx5: Add Representors registration API (Don Dutile) [1383788 1417284]
- [netdrv] mlx5e: Add support for multiple profiles (Don Dutile) [1383788 1417284]
- [netdrv] mlx5e: Mark enabled RQTs instances explicitly (Don Dutile) [1383788 1417284]
- [netdrv] mlx5e: TIRs management refactoring (Don Dutile) [1383788 1417284]
- [netdrv] mlx5e: Create NIC global resources only once (Don Dutile) [1417284]
- [netdrv] mlx5e: Add devlink based SRIOV mode changes (Don Dutile) [1383792 1417284]
- [netdrv] mlx5: Add devlink interface (Don Dutile) [1383792 1417284]
- [net] devlink: Add E-Switch mode control (Don Dutile) [1383792 1417284]
- [netdrv] mlx5: E-Switch, Add API to create vport rx rules (Don Dutile) [1383792 1417284]
- [netdrv] mlx5: E-Switch, Add offloads table (Don Dutile) [1383792 1417284]
- [netdrv] mlx5: Introduce offloads steering namespace (Don Dutile) [1383792 1417284]
- [netdrv] mlx5: E-Switch, Add API to create send-to-vport rules (Don Dutile) [1383792 1417284]
- [netdrv] mlx5: E-Switch, Add miss rule for offloads mode (Don Dutile) [1383792 1417284]
- [netdrv] mlx5: E-Switch, Add support for the sriov offloads mode (Don Dutile) [1383792 1417284]
- [netdrv] mlx5: E-Switch, Add operational mode to the SRIOV e-Switch (Don Dutile) [1383792 1417284]
- [net] rds: Do not send a pong to an incoming ping with 0 src port (Don Dutile) [1417284]
- [net] rds: tcp: Simplify reconnect to avoid duelling reconnnect attempts (Don Dutile) [1417284]
- [net] rds: tcp: Hooks to set up a single connection path (Don Dutile) [1417284]
- [net] rds: tcp: make receive path use the rds_conn_path (Don Dutile) [1417284]
- [net] rds: tcp: make ->sk_user_data point to a rds_conn_path (Don Dutile) [1417284]
- [net] rds: tcp: Refactor connection destruction to handle multiple paths (Don Dutile) [1417284]
- [net] rds: tcp: Make rds_tcp_connection track the rds_conn_path (Don Dutile) [1417284]
- [net] rds: tcp: Remove dead logic around c_passive in rds-tcp (Don Dutile) [1417284]
- [net] rds: Rework path specific indirections (Don Dutile) [1417284]
- [netdrv] be2net: signedness bug in be_msix_enable() (Don Dutile) [1417284]
- [netdrv] mlx5e: Report correct auto negotiation and allow toggling (Don Dutile) [1383786 1417284]
- [netdrv] mlx5e: Use new ethtool get/set link ksettings API (Don Dutile) [1417284]
- [netdrv] mlx5e: Add missing 50G baseSR2 link mode (Don Dutile) [1417284]
- [uapi] ethtool: Add 50G baseSR2 link mode (Don Dutile) [1417284]
- [netdrv] mlx5e: Toggle link only after modifying port parameters (Don Dutile) [1383595 1417284]
- [netdrv] mlx5e: Support adaptive RX coalescing (Don Dutile) [1383595 1417284]
- [netdrv] mlx5e: CQE based moderation (Don Dutile) [1383595 1417284]
- [netdrv] mlx5e: Introduce net device priv flags infrastructure (Don Dutile) [1417284]
- [netdrv] mlx5e: Add TXQ set max rate support (Don Dutile) [1383785 1417284]
- [netdrv] mlx5: Rate limit tables support (Don Dutile) [1383785 1417284]
- [netdrv] be2net: Change copyright markings in source files (Don Dutile) [1417284]
- [netdrv] be2net: support asymmetric rx/tx queue counts (Don Dutile) [1417284]
- [netdrv] be2net: fix definition of be_max_eqs() (Don Dutile) [1417284]
- [netdrv] cxgb4vf: Synchronize access to mailbox (Don Dutile) [1385866 1417284]
- [netdrv] mlx4_en: Add DCB PFC support through CEE netlink commands (Don Dutile) [1383796 1417284]
- [infiniband] ib/hfi1: Add device FW version string (Don Dutile) [1382806 1417284]
- [infiniband] ib/core: Export a common fw_ver sysfs entry (Don Dutile) [1417284]
- [infiniband] ib/ipoib: Use new device FW version string (Don Dutile) [1417284]
- [infiniband] ib/usnic: Support device FW version string (Don Dutile) [1417284]
- [infiniband] ib/ocrdma: Support device FW version string (Don Dutile) [1385876 1417284]
- [infiniband] ib/nes: Support device FW version string (Don Dutile) [1417284]
- [infiniband] ib/mthca: Supprot device FW version string (Don Dutile) [1417284]
- [infiniband] ib/mlx5: Support device FW version string (Don Dutile) [1385330 1417284]
- [infiniband] ib/mlx4: Support device FW version string (Don Dutile) [1385329 1417284]
- [infiniband] ib/i40iw: Support device FW version string (Don Dutile) [1417284]
- [infiniband] ib/cxgb4: Support device FW version string (Don Dutile) [1385866 1417284]
- [infiniband] ib/cxgb3: Support device FW version string (Don Dutile) [1385866 1417284]
- [rdma] ib/core: Add get FW version string to the core (Don Dutile) [1417284]
- [netdrv] {net, ib}/mlx5: Refactor internal SRQ API (Don Dutile) [1385330 1417284]
- [netdrv] ib/mlx5: Fix MODIFY_QP command input structure (Don Dutile) [1385330 1417284]
- [infiniband] ib/mlx5: Report mlx5 TSO capabilities when querying device (Don Dutile) [1384619 1417284]
- [infiniband] ib/mlx5: Enable flow steering for IPv6 traffic (Don Dutile) [1384580 1417284]
- [uapi] ib/core: Add IPv6 support to flow steering (Don Dutile) [1384580 1417284]
- [netdrv] ib/mlx5: Reset flow support for IB kernel ULPs (Don Dutile) [1384614 1417284]
- [infiniband] ib/mlx5: Implements disassociate_ucontext API (Don Dutile) [1385330 1417284]
- [infiniband] ib/mlx5: Add RSS QP support (Don Dutile) [1384576 1417284]
- [uapi] ib/uverbs: Extend create QP to get RWQ indirection table (Don Dutile) [1384576 1417284]
- [rdma] ib/core: Extend create QP to get indirection table (Don Dutile) [1384576 1417284]
- [infiniband] ib/mlx5: Add Receive Work Queue Indirection table operations (Don Dutile) [1384576 1417284]
- [uapi] ib/uverbs: Introduce RWQ Indirection table (Don Dutile) [1384576 1417284]
- [rdma] ib/core: Introduce Receive Work Queue indirection table (Don Dutile) [1384576 1417284]
- [infiniband] ib/mlx5: Add receive Work Queue verbs (Don Dutile) [1384576 1417284]
- [uapi] ib/uverbs: Add WQ support (Don Dutile) [1384576 1417284]
- [rdma] ib/core: Introduce Work Queue object and its verbs (Don Dutile) [1384576 1417284]
- [netdrv] mlx5: Export required core functions to support RSS (Don Dutile) [1384576 1417284]
- [infiniband] rdma/iw_cxgb4: Low resource fixes for Completion queue (Don Dutile) [1385866 1417284]
- [infiniband] rdma/iw_cxgb4: Low resource fixes for Memory registration (Don Dutile) [1385866 1417284]
- [infiniband] rdma/cxgb4: Configure 0B MRs to match HW implementation (Don Dutile) [1385866 1417284]
- [infiniband] rdma/iw_cxgb4: Low resource fixes for connection manager (Don Dutile) [1385866 1417284]
- [netdrv] rdma/iw_cxgb4: Add missing error codes for act open cmd (Don Dutile) [1385866 1417284]
- [infiniband] rdma/iw_cxgb4: clean up c4iw_reject_cr() (Don Dutile) [1385866 1417284]
- [infiniband] rdma/iw_cxgb4: allocate enough space for debugfs "qps" dump (Don Dutile) [1385866 1417284]
- [infiniband] rdma/iw_cxgb4: only read markers_enabled mod param once (Don Dutile) [1385866 1417284]
- [net] rds: tcp: Fix non static symbol warnings (Don Dutile) [1417284]
- [netdrv] mlx5_en: Replace ndo_add/del_vxlan_port with ndo_add/del_udp_enc_port (Don Dutile) [1385330 1417284]
- [netdrv] mlx4_en: Replace ndo_add/del_vxlan_port with ndo_add/del_udp_enc_port (Don Dutile) [1385329 1417284]
- [netdrv] benet: Replace ndo_add/del_vxlan_port with ndo_add/del_udp_enc_port (Don Dutile) [1417284]
- [netdrv] cxgb4/cxgb4vf: Synchronize all MAC addresses (Don Dutile) [1385866 1417284]
- [netdrv] cxgb4: Enable SR-IOV configuration via PCI sysfs interface (Don Dutile) [1385866 1417284]
- [netdrv] cxgb4: Force cxgb4 driver as MASTER in kdump kernel (Don Dutile) [1385866 1417284]
- [net] rds: Update rds_conn_destroy to be MP capable (Don Dutile) [1417284]
- [net] rds: Update rds_conn_shutdown to work with rds_conn_path (Don Dutile) [1417284]
- [net] rds: Initialize all RDS_MPATH_WORKERS in __rds_conn_create (Don Dutile) [1417284]
- [net] rds: Add rds_conn_path_error() (Don Dutile) [1417284]
- [net] rds: update rds-info related functions to traverse multiple conn_paths (Don Dutile) [1417284]
- [net] rds: Add rds_conn_path_connect_if_down() for MP-aware callers (Don Dutile) [1417284]
- [net] rds: Make rds_send_pong() take a rds_conn_path argument (Don Dutile) [1417284]
- [net] rds: Extract rds_conn_path from i_conn_path in rds_send_drop_to() for MP-capable transports (Don Dutile) [1417284]
- [net] rds: fix possible double free on sock tear down (Don Dutile) [1417284]
- [net] rds: Pass rds_conn_path to rds_send_xmit() (Don Dutile) [1417284]
- [net] rds: Make rds_send_queue_rm() rds_conn_path aware (Don Dutile) [1417284]
- [net] rds: Remove stale function rds_send_get_message() (Don Dutile) [1417284]
- [net] rds: Add rds_send_path_drop_acked() (Don Dutile) [1417284]
- [net] rds: Add rds_send_path_reset() (Don Dutile) [1417284]
- [net] rds: rds_inc_path_init() helper function for MP capable transports (Don Dutile) [1417284]
- [net] rds: recv path gets the conn_path from rds_incoming for MP capable transports (Don Dutile) [1417284]
- [net] rds: add t_mp_capable bit to be set by MP capable transports (Don Dutile) [1417284]
- [net] rds: split out connection specific state from rds_connection to rds_conn_path (Don Dutile) [1417284]
- [net] rds: call rds_conn_drop instead of open code it at rds_connect_complete (Don Dutile) [1417284]
- [net] rds: rds_cong_queue_updates needs to defer the congestion update transmission (Don Dutile) [1417284]
- [net] rds: ib: Remove deprecated create_workqueue (Don Dutile) [1417284]
- [netdrv] {net,ib}/mlx5: mlx5_ifc updates (Don Dutile) [1385330 1417284]
- [netdrv] mlx4_en: fix ethtool -x (Don Dutile) [1385329 1417284]
- [netdrv] mlx4_en: mlx4_en_netpoll() should schedule TX, not RX (Don Dutile) [1385329 1417284]
- [infiniband] ib/hfi1: Correct issues with sc5 computation (Don Dutile) [1382806 1417284]
- [netdrv] mlx5e: Fix del vxlan port command buffer memset (Don Dutile) [1417284]
- [netdrv] mlx5e: start/stop all tx queues upon open/close netdev (Don Dutile) [1417284]
- [netdrv] mlx5e: Fix TX Timeout to detect queues stuck on BQL (Don Dutile) [1417284]
- [netdrv] cxgb4: update latest firmware version supported (Don Dutile) [1385866 1417284]
- [netdrv] mlx5: Avoid setting unused var when modifying vport node GUID (Don Dutile) [1385330 1417284]
- [net] rds: fix rds_tcp_init() error path (Don Dutile) [1417284]
- [netdrv] mlx5e: Validate BW weight values of ETS (Don Dutile) [1417284]
- [netdrv] mlx5e: Fix select queue callback (Don Dutile) [1417284]
- [netdrv] mlx5e: Copy all L2 headers into inline segment (Don Dutile) [1417284]
- [netdrv] mlx5e: Handle RQ flush in error cases (Don Dutile) [1417284]
- [netdrv] mlx5e: Implement ndo_tx_timeout callback (Don Dutile) [1417284]
- [netdrv] mlx5e: Timeout if SQ doesn't flush during close (Don Dutile) [1417284]
- [netdrv] mlx5: Add timeout handle to commands with callback (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Fix potential deadlock in command mode change (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Use ktime_get_ns() (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Fix wait_vital for VFs and remove fixed sleep (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Fix incorrect page count when in internal error (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Avoid calling sleeping function by the health poll thread (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Fix teardown errors that happen in pci error handler (Don Dutile) [1385330 1417284]
- [netdrv] mlx5e: Reorganize ethtool statistics (Don Dutile) [1417284]
- [netdrv] mlx5e: Fix number of PFC counters reported to ethtool (Don Dutile) [1417284]
- [netdrv] mlx5e: Prevent adding the same vxlan port (Don Dutile) [1417284]
- [netdrv] mlx5e: Check for BlueFlame capability before allocating SQ uar (Don Dutile) [1417284]
- [netdrv] mlx5e: Change enum to better reflect usage (Don Dutile) [1417284]
- [netdrv] mlx5: Add ConnectX-5 PCIe 4.0 to list of supported devices (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Update command strings (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: use mlx5_buf_alloc_node instead of mlx5_buf_alloc in mlx5_wq_ll_create (Don Dutile) [1385330 1417284]
- [infiniband] ib/srpt: Reduce QP buffer size (Don Dutile) [1417284]
- [rdma] ib/rdmavt: Correct qp_priv_alloc() return value test (Don Dutile) [1385848 1417284]
- [infiniband] ib/hfi1: Don't zero out qp->s_ack_queue in rvt_reset_qp (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix deadlock with txreq allocation slow path (Don Dutile) [1382806 1417284]
- [infiniband] ib/mlx4: Prevent cross page boundary allocation (Don Dutile) [1385329 1417284]
- [infiniband] ib/mlx4: Fix memory leak if QP creation failed (Don Dutile) [1385329 1417284]
- [infiniband] ib/mlx4: Verify port number in flow steering create flow (Don Dutile) [1385329 1417284]
- [infiniband] ib/mlx4: Fix error flow when sending mads under SRIOV (Don Dutile) [1385329 1417284]
- [infiniband] ib/mlx4: Fix the SQ size of an RC QP (Don Dutile) [1385329 1417284]
- [netdrv] ib/mlx5: Fix post send fence logic (Don Dutile) [1385330 1417284]
- [infiniband] ib/core: Fix false search of the IB_SA_WELL_KNOWN_GUID (Don Dutile) [1417284]
- [infiniband] ib/core: Fix no default GIDs when netdevice reregisters (Don Dutile) [1417284]
- [netdrv] mlx4_en: Avoid unregister_netdev at shutdown flow (Don Dutile) [1385329 1417284]
- [net] rds: fix coding style issues (Don Dutile) [1417284]
- [net] rds: tcp: rds_tcp_accept_one() should transition socket from RESETTING to UP (Don Dutile) [1417284]
- [infiniband] ib/hfi1: Send a pkey change event on driver pkey update (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Remove FULL_MGMT_P_KEY from pkey table at link up (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix potential buffer overflow (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix potential NULL ptr dereference (Don Dutile) [1382806 1417284]
- [infiniband] ib/qib: Prevent context loss (Don Dutile) [1381986 1417284]
- [infiniband] ib/hfi1: Prevent context loss (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Increase packet egress timeout (Don Dutile) [1382806 1417284]
- [infiniband] ib/rdmavt: Correct warning during QPN allocation (Don Dutile) [1385848 1417284]
- [infiniband] ib/rdmavt: Correct required callback functions for MODIFY_QP (Don Dutile) [1385848 1417284]
- [infiniband] ib/hfi1: Fix credit return threshold adjustment (Don Dutile) [1382806 1417284]
- [infiniband] ib/cma: Make the code easier to verify (Don Dutile) [1417284]
- [infiniband] ib/mlx4: Properly initialize GRH TClass and FlowLabel in AHs (Don Dutile) [1385329 1417284]
- [netdrv] mlx4e: Do not attempt to offload VXLAN ports that are unrecognized (Don Dutile) [1385329 1417284]
- [netdrv] mlx4_en: initialize cmd.context_lock spinlock earlier (Don Dutile) [1385329 1417284]
- [netdrv] mlx5: E-Switch, always set mc_promisc for allmulti vports (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: E-Switch, Fix vport enable flow (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: E-Switch, Use the correct error check on returned pointers (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: E-Switch, Use the correct free() function (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Fix flow steering NIC capabilities check (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Fix E-Switch flow steering capabilities check (Don Dutile) [1385330 1417284]
- [netdrv] mlx5: Fix MLX5_CMD_OP_MAX to be defined correctly (Don Dutile) [1385330 1417284]
- [netdrv] cxgb4: Add device id of T540-BT adapter (Don Dutile) [1385866 1417284]
- [net] rds: tcp: fix race windows in send-path quiescence by rds_tcp_accept_one() (Don Dutile) [1417284]
- [net] rds: tcp: Retransmit half-sent datagrams when switching sockets in rds_tcp_reset_callbacks (Don Dutile) [1417284]
- [net] rds: tcp: Add/use rds_tcp_reset_callbacks to reset tcp socket safely (Don Dutile) [1417284]
- [infiniband] ib/ipoib: Don't update neigh validity for unresolved entries (Don Dutile) [1417284]
- [infiniband] ib/ipoib: Disable bottom half when dealing with device address (Don Dutile) [1417284]
- [infiniband] ib/ipoib: Fix race between ipoib_remove_one to sysfs functions (Don Dutile) [1417284]
- [infiniband] ib/hfi1: Suppress sparse warnings (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Use bit 0 instead of bit 1 (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: Fix indentation (Don Dutile) [1382806 1417284]
- [infiniband] ib/rdmavt: Annotate rvt_reset_qp() (Don Dutile) [1385848 1417284]
- [infiniband] ib/mad: Fix indentation (Don Dutile) [1417284]
- [infiniband] rdma/core: Fix indentation (Don Dutile) [1417284]
- [infiniband] ib/usnic: Remove unused DMA attributes (Don Dutile) [1417284]
- [infiniband] ib/core: fix an error code in ib_core_init() (Don Dutile) [1417284]
- [infiniband] ib/hfi1: Avoid large frame size warning (Don Dutile) [1382806 1417284]
- [infiniband] ib/hfi1: fix some indenting (Don Dutile) [1382806 1417284]
- [net] rds: fix an infoleak in rds_inc_info_copy (Don Dutile) [1417284]
- [infiniband] ib/ipoib: Allow setting the device address (Don Dutile) [1417284]
- [infiniband] ib/ipoib: Support SendOnlyFullMember MCG for SendOnly join (Don Dutile) [1417284]
- [infiniband] ib/core: Support new type of join-state for multicast (Don Dutile) [1417284]
- [net] rds: tcp: Avoid rds connection churn from rogue SYNs (Don Dutile) [1417284]
- [net] rds: tcp: rds_tcp_accept_worker() must exit gracefully when terminating rds-tcp (Don Dutile) [1417284]
- [net] rds: tcp: block BH in TCP callbacks (Don Dutile) [1417284]
- [net] xprtrdma: Remove qplock (Don Dutile) [1417284]
- [net] xprtrdma: Faster server reboot recovery (Don Dutile) [1417284]
- [net] xprtrdma: Remove ro_unmap() from all registration modes (Don Dutile) [1417284]
- [net] xprtrdma: Add ro_unmap_safe memreg method (Don Dutile) [1417284]
- [net] xprtrdma: Refactor __fmr_dma_unmap() (Don Dutile) [1417284]
- [net] xprtrdma: Move fr_xprt and fr_worker to struct rpcrdma_mw (Don Dutile) [1417284]
- [net] xprtrdma: Refactor the FRWR recovery worker (Don Dutile) [1417284]
- [net] xprtrdma: Reset MRs in frwr_op_unmap_sync() (Don Dutile) [1417284]
- [net] xprtrdma: Save I/O direction in struct rpcrdma_frwr (Don Dutile) [1417284]
- [net] xprtrdma: Rename rpcrdma_frwr::sg and sg_nents (Don Dutile) [1417284]
- [net] xprtrdma: Use core ib_drain_qp() API (Don Dutile) [1417284]
- [net] xprtrdma: Allow Read list and Reply chunk simultaneously (Don Dutile) [1417284]
- [net] xprtrdma: Update comments in rpcrdma_marshal_req() (Don Dutile) [1417284]
- [net] xprtrdma: Avoid using Write list for small NFS READ requests (Don Dutile) [1417284]
- [net] xprtrdma: Prevent inline overflow (Don Dutile) [1417284]
- [net] xprtrdma: Limit number of RDMA segments in RPC-over-RDMA headers (Don Dutile) [1417284]
- [net] xprtrdma: Bound the inline threshold values (Don Dutile) [1417284]
- [net] sunrpc: Advertise maximum backchannel payload size (Don Dutile) [1417284]
- [netdrv] mlx5_core: Flow counters infrastructure (Don Dutile) [1385330 1417284]
- [netdrv] mlx5_core: Introduce flow steering destination of type counter (Don Dutile) [1385330 1417284]
- [netdrv] mlx5_core: Firmware commands to support flow counters (Don Dutile) [1385330 1417284]
- [netdrv] mlx5_core: Use a macro in mlx5_command_str() (Don Dutile) [1385330 1417284]
- [infiniband] rdma/nes: replace custom print_hex_dump() (Don Dutile) [1417284]
- [infiniband] ib/nes: Deinline nes_free_qp_mem, save 1072 bytes (Don Dutile) [1417284]
- [infiniband] rdma/nes: Adding queue drain functions (Don Dutile) [1417284]
- [infiniband] rdma/nes: Fix for passing a valid QP pointer to the user space library (Don Dutile) [1417284]
- [infiniband] ib/ipoib: Add readout of statistics using ethtool (Don Dutile) [1417284]
- [infiniband] ulp/ipoib: remove pkey_mutex (Don Dutile) [1417284]
- [infiniband] iw_cxgb4: Convert a __force cast (Don Dutile) [1385866 1417284]
- [net] svcrdma: Generalize svc_rdma_xdr_decode_req() (Don Dutile) [1417284]
- [net] svcrdma: Eliminate code duplication in svc_rdma_recvfrom() (Don Dutile) [1417284]
- [net] svcrdma: Drain QP before freeing svcrdma_xprt (Don Dutile) [1417284]
- [net] svcrdma: Post Receives only for forward channel requests (Don Dutile) [1417284]
- [net] svcrdma: svc_rdma_put_context() is invoked twice in Send error path (Don Dutile) [1417284]
- [net] svcrdma: Support IPv6 with NFS/RDMA (Don Dutile) [1417284]
- [infiniband] ib/isert: convert to the generic RDMA READ/WRITE API (Don Dutile) [1417284]
- [infiniband] ib/srpt: convert to the generic RDMA READ/WRITE API (Don Dutile) [1417284]
- [target] enhance and export target_alloc_sgl/target_free_sgl (Don Dutile) [1417284]
- [target] ensure se_cmd->t_prot_sg is allocated when required (Don Dutile) [1417284]
- [netdrv] mlx5e: Enable CQE compression when PCI is slower than link (Don Dutile) [1383356 1417284]
- [netdrv] mlx5e: Expand WQE stride when CQE compression is enabled (Don Dutile) [1383356 1417284]
- [netdrv] mlx5e: CQE compression (Don Dutile) [1383356 1417284]
- [netdrv] mlx5: Fix merge errors (Don Dutile) [1385330 1417284]
- [netdrv] cxgb4: Reset dcb state machine and tx queue prio only if dcb is enabled (Don Dutile) [1385866 1417284]
- [netdrv] i40e: constify i40e_client_ops structure (Don Dutile) [1417284]
- [netdrv]  replace dev->trans_start accesses with dev_trans_start (Don Dutile) [1417284]
- [netdrv] mlx5: E-Switch, Implement trust vf ndo (Don Dutile) [1383280 1417284]
- [netdrv] mlx5: E-Switch, Implement promiscuous rx modes vf request handling (Don Dutile) [1383280 1417284]
- [netdrv] mlx5: E-Switch, Add promiscuous and allmulti FDB flowtable groups (Don Dutile) [1383280 1417284]
- [netdrv] mlx5: E-Switch, Use vport event handler for vport cleanup (Don Dutile) [1383280 1417284]
- [netdrv] mlx5: E-Switch, Enable/disable ACL tables on demand (Don Dutile) [1383290 1417284]
- [netdrv] mlx5: E-Switch, Vport ingress/egress ACLs rules for spoofchk (Don Dutile) [1383290 1417284]
- [netdrv] mlx5: E-Switch, Vport ingress/egress ACLs rules for VST mode (Don Dutile) [1383290 1417284]
- [netdrv] mlx5: E-Switch, Introduce VST vport ingress/egress ACLs (Don Dutile) [1383290 1417284]
- [netdrv] mlx5: E-Switch, Fix error flow memory leak (Don Dutile) [1383290 1417284]
- [netdrv] mlx5: E-Switch, Replace vport spin lock with synchronize_irq() (Don Dutile) [1383290 1417284]
- [netdrv] mlx5: Flow steering, Add vport ACL support (Don Dutile) [1383290 1417284]
- [netdrv] mlx5e: Fix aRFS compilation dependency (Don Dutile) [1385330 1417284]
- [netdrv] cxgb4: Check for firmware errors in the mailbox command loop (Don Dutile) [1385866 1417284]
- [netdrv] cxgb4: Don't sleep when mbox cmd is issued from interrupt context (Don Dutile) [1385866 1417284]
- [netdrv] mlx5e: Fix IPv6 tunnel checksum offload (Don Dutile) [1417284]
- [netdrv] mlx5e: Add support for UDP tunnel segmentation with outer checksum offload (Don Dutile) [1417284]
- [netdrv] mlx4_en: Add support for UDP tunnel segmentation with outer checksum offload (Don Dutile) [1385329 1417284]
- [netdrv] mlx5e: Enabling aRFS mechanism (Don Dutile) [1383273 1417284]
- [netdrv] mlx5e: Add accelerated RFS support (Don Dutile) [1383273 1417284]
- [netdrv] mlx5e: Create aRFS flow tables (Don Dutile) [1383273 1417284]
- [netdrv] mlx5: Initializing CPU reverse mapping (Don Dutile) [1383273 1417284]
- [netdrv] mlx5e: Split the main flow steering table (Don Dutile) [1383273 1417284]
- [netdrv] mlx5e: Refactor mlx5e flow steering structs (Don Dutile) [1383273 1417284]
- [netdrv] mlx5: Support different attributes for priorities in namespace (Don Dutile) [1383273 1417284]
- [netdrv] mlx5: Add user chosen levels when allocating flow tables (Don Dutile) [1383273 1417284]
- [netdrv] mlx5e: Introduce tc offload support (Don Dutile) [1417284]
- [netdrv] mlx5: Set number of allowed levels in priority (Don Dutile) [1383273 1417284]
- [netdrv] mlx5: Introduce modify flow rule destination (Don Dutile) [1383273 1417284]
- [netdrv] mlx5e: Direct TIR per RQ (Don Dutile) [1383273 1417284]
- [netdrv] cxgb4: Add support to enable logging of firmware mailbox commands (Don Dutile) [1385866 1417284]
- [infiniband] rdma/i40iw: Adding queue drain functions (Don Dutile) [1417284]
- [infiniband] treewide: Fix typos in printk (Don Dutile) [1417284]
- [infiniband] rdma/nes: remove use of NETDEV_TX_LOCKED (Don Dutile) [1417284]
- [netdrv] cxgb4: Decode link down reason code obtained from firmware (Don Dutile) [1385866 1417284]
- [netdrv] cxgb4: DCB message handler needs to use correct portid to netdev mapping (Don Dutile) [1385866 1417284]
- [netdrv] cxgb4: Refactor t4_port_init function (Don Dutile) [1385866 1417284]
- [netdrv] cxgb4: Properly decode port module type (Don Dutile) [1385866 1417284]
- [netdrv] cxgb4: Avoids race and deadlock while freeing tx descriptor (Don Dutile) [1385866 1417284]
- [netdrv] cxgb4: Add llseek operation for flash debugfs entry (Don Dutile) [1385866 1417284]
- [netdrv] cxgb4: add new routine to get adapter info (Don Dutile) [1385866 1417284]
- [scsi] rename SCSI_MAX_{SG, SG_CHAIN}_SEGMENTS (Don Dutile) [1417284]
- [netdrv] cxgb3: fix out of bounds read (Don Dutile) [1385866 1417284]
- [infiniband] rdma/nes: don't leak skb if carrier down (Don Dutile) [1417284]
- [infiniband] iw_cxgb4: handle draining an idle qp (Don Dutile) [1385866 1417284]
- [infiniband] iw_cxgb3: initialize ibdev.iwcm->ifname for port mapping (Don Dutile) [1385866 1417284]
- [infiniband] iw_cxgb4: initialize ibdev.iwcm->ifname for port mapping (Don Dutile) [1385866 1417284]
- [infiniband] iser-target: Use ib_drain_qp (Don Dutile) [1417284]
- [infiniband] ib_srpt: fix a WARN_ON() message (Don Dutile) [1417284]
- [infiniband] iw_cxgb3: support for iWARP port mapping (Don Dutile) [1385866 1417284]
- [infiniband] iw_nes: remove port mapper related code (Don Dutile) [1417284]
- [infiniband] rdma/nes: Report the actual address of the remote connecting peer (Don Dutile) [1417284]
- [infiniband] rdma/nes: Add support for iWARP Port Mapper user space service (Don Dutile) [1417284]
- [infiniband] rdma/nes: Fix error return code (Don Dutile) [1417284]
- [net] xprtrdma: Use new CQ API for RPC-over-RDMA client send CQs (Don Dutile) [1417284]
- [net] xprtrdma: Use an anonymous union in struct rpcrdma_mw (Don Dutile) [1417284]
- [net] xprtrdma: Use new CQ API for RPC-over-RDMA client receive CQs (Don Dutile) [1417284]
- [net] xprtrdma: Serialize credit accounting again (Don Dutile) [1417284]
- [net] xprtrdma: Properly handle RDMA_ERROR replies (Don Dutile) [1417284]
- [net] xprtrdma: Do not wait if ib_post_send() fails (Don Dutile) [1417284]
- [net] xprtrdma: Segment head and tail XDR buffers on page boundaries (Don Dutile) [1417284]
- [net] xprtrdma: Clean up dprintk format string containing a newline (Don Dutile) [1417284]
- [net] xprtrdma: Clean up physical_op_map() (Don Dutile) [1417284]
- [infiniband] iser-target: Kill the ->isert_cmd back pointer in struct iser_tx_desc (Don Dutile) [1417284]
- [infiniband] iser-target: Kill struct isert_rdma_wr (Don Dutile) [1417284]
- [infiniband] iser-target: Convert to new CQ API (Don Dutile) [1417284]
- [infiniband] iser-target: Split and properly type the login buffer (Don Dutile) [1417284]
- [infiniband] iser-target: Remove ISER_RECV_DATA_SEG_LEN (Don Dutile) [1417284]
- [infiniband] iser-target: Remove impossible condition from isert_wait_conn (Don Dutile) [1417284]
- [infiniband] iser-target: Remove redundant wait in release_conn (Don Dutile) [1417284]
- [infiniband] iser-target: Rework connection termination (Don Dutile) [1417284]
- [infiniband] iser-target: Separate flows for np listeners and connections cma events (Don Dutile) [1417284]
- [infiniband] iser-target: Add new state ISER_CONN_BOUND to isert_conn (Don Dutile) [1417284]
- [infiniband] iser-target: Fix identification of login rx descriptor type (Don Dutile) [1417284]
- [infiniband] iser: Accept arbitrary sg lists mapping if the device supports it (Don Dutile) [1417284]
- [infiniband] ib/ocrdma: Skip using unneeded intermediate variable (Don Dutile) [1385876 1417284]
- [infiniband] ib/ocrdma: Skip using unneeded intermediate variable (Don Dutile) [1385876 1417284]
- [infiniband] ib/ocrdma: Delete unnecessary variable initialisations in 11 functions (Don Dutile) [1385876 1417284]
- [infiniband] ib/ipoib: Add handling for sending of skb with many frags (Don Dutile) [1417284]
- [net] svcrdma: Use new CQ API for RPC-over-RDMA server send CQs (Don Dutile) [1417284]
- [net] svcrdma: Use new CQ API for RPC-over-RDMA server receive CQs (Don Dutile) [1417284]
- [net] svcrdma: Remove close_out exit path (Don Dutile) [1417284]
- [net] svcrdma: Hook up the logic to return ERR_CHUNK (Don Dutile) [1417284]
- [net] rpcrdma: Add RPCRDMA_HDRLEN_ERR (Don Dutile) [1417284]
- [net] svcrdma: Close connection when a send error occurs (Don Dutile) [1417284]
- [net] svcrdma: Do not send Write chunk XDR pad with inline content (Don Dutile) [1417284]
- [net] svcrdma: Do not write xdr_buf::tail in a Write chunk (Don Dutile) [1417284]
- [net] svcrdma: Find client-provided write and reply chunks once per reply (Don Dutile) [1417284]
- [infiniband] ib/srpt: Fix wait list processing (Don Dutile) [1417284]
- [infiniband] ib/srpt: Introduce srpt_process_wait_list() (Don Dutile) [1417284]
- [infiniband] ib/srpt: Log out all initiators if a port is disabled (Don Dutile) [1417284]
- [infiniband] ib/srpt: Fix srpt_write_pending() (Don Dutile) [1417284]
- [infiniband] ib/srpt: Detect session shutdown reliably (Don Dutile) [1417284]
- [infiniband] ib/srpt: Use a mutex to protect the channel list (Don Dutile) [1417284]
- [infiniband] ib/srpt: Log private data associated with REJ (Don Dutile) [1417284]
- [infiniband] ib/srpt: Eliminate srpt_find_channel() (Don Dutile) [1417284]
- [infiniband] ib/srpt: Inline trivial CM callback functions (Don Dutile) [1417284]
- [infiniband] ib/srpt: Fix how aborted commands are processed (Don Dutile) [1417284]
- [infiniband] ib/srpt: Fix srpt_handle_cmd() error paths (Don Dutile) [1417284]
- [infiniband] ib/srpt: Fix srpt_close_session() (Don Dutile) [1417284]
- [infiniband] ib/srpt: Simplify srpt_shutdown_session() (Don Dutile) [1417284]
- [infiniband] ib/srpt: Simplify channel state management (Don Dutile) [1417284]
- [infiniband] ib/srpt: Use scsilun_to_int() (Don Dutile) [1417284]
- [infiniband] ib/srpt: Introduce target_reverse_dma_direction() (Don Dutile) [1417284]
- [infiniband] ib/srpt: Inline srpt_get_ch_state() (Don Dutile) [1417284]
- [infiniband] ib/srpt: Inline srpt_sdev_name() (Don Dutile) [1417284]
- [infiniband] ib/srpt: Add parentheses around sizeof argument (Don Dutile) [1417284]
- [infiniband] nes: handling failed allocation when creating workqueue (Don Dutile) [1417284]
- [infiniband] ib/mlx4: Use boottime (Don Dutile) [1385329 1417284]
- [infiniband] ib/iser: Use ib_drain_sq() (Don Dutile) [1417284]
- [netdrv] mlx4: use new ETHTOOL_G/SSETTINGS API (Don Dutile) [1385329 1417284]
- [infiniband] usnic: use __ethtool_get_ksettings (Don Dutile) [1417284]
- [infiniband] usnic: use __ethtool_get_settings (Don Dutile) [1417284]
- [infiniband] usnic: remove unused call to ethtool_ops::get_settings (Don Dutile) [1417284]
- [infiniband] rdma/nes: Replace LRO with GRO (Don Dutile) [1417284]
- [infiniband] treewide: Fix typo in printk (Don Dutile) [1417284]

* Thu Feb 23 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-575.el7]
- [tools] tools/power turbostat: RHEL Add additional RAPL features to Intel processors (Prarit Bhargava) [1422076]
- [tools] power turbostat: remove obsolete -M, -m, -C, -c options (Prarit Bhargava) [1422076]
- [tools] power turbostat: Make extensible via the --add parameter (Prarit Bhargava) [1422076]
- [tools] power turbostat: line up headers when -M is used (Prarit Bhargava) [1422076]
- [tools] power turbostat: fix SKX PKG_CSTATE_LIMIT decoding (Prarit Bhargava) [1422076]
- [tools] power turbostat: fix error case overflow read of slm_freq_table[] (Prarit Bhargava) [1422076]
- [tools] power turbostat: Allocate correct amount of fd and irq entries (Prarit Bhargava) [1422076]
- [tools] power turbostat: switch to tab delimited output (Prarit Bhargava) [1422076]
- [tools] power turbostat: Gracefully handle ACPI S3 (Prarit Bhargava) [1422076]
- [tools] power turbostat: tidy up output on Joule counter overflow (Prarit Bhargava) [1422076]
- [tools] turbostat: allow user to alter DESTDIR and PREFIX (Prarit Bhargava) [1422076]
- [tools] power turbostat: work around RC6 counter wrap (Prarit Bhargava) [1422076]
- [tools] power turbostat: print IRTL MSRs (Prarit Bhargava) [1422076]
- [tools] power turbostat: SGX state should print only if --debug (Prarit Bhargava) [1422076]
- [tools] power turbostat: bugfix: TDP MSRs print bits fixing (Prarit Bhargava) [1422076]
- [tools] power turbostat: correct output for MSR_NHM_SNB_PKG_CST_CFG_CTL dump (Prarit Bhargava) [1422076]
- [tools] power turbostat: call __cpuid() instead of __get_cpuid() (Prarit Bhargava) [1422076]
- [tools] power turbostat: indicate SMX and SGX support (Prarit Bhargava) [1422076]
- [tools] power turbostat: detect and work around syscall jitter (Prarit Bhargava) [1422076]
- [tools] power turbostat: show GFXrc6 (Prarit Bhargava) [1422076]
- [tools] power turbostat: show GFXMHz (Prarit Bhargava) [1422076]
- [tools] power turbostat: show IRQs per CPU (Prarit Bhargava) [1422076]
- [tools] power turbostat: make fewer systems calls (Prarit Bhargava) [1422076]
- [tools] power turbostat: add --out option for saving output in a file (Prarit Bhargava) [1422076]
- [tools] power turbostat: re-name "Busy" field to "Busy" (Prarit Bhargava) [1422076]
- [tools] power turbostat: decode more CPUID fields (Prarit Bhargava) [1422076]
- [tools] power turbostat: CPUID(0x16) leaf shows base, max, and bus frequency (Prarit Bhargava) [1422076]
- [tools] power turbostat: decode HWP registers (Prarit Bhargava) [1422076]
- [tools] power turbostat: Decode MSR_MISC_PWR_MGMT (Prarit Bhargava) [1422076]
- [tools] power turbostat: fix various build warnings (Prarit Bhargava) [1422076]
- [tools] power turbostat: allow sub-sec intervals (Prarit Bhargava) [1422076]

* Thu Feb 23 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-574.el7]
- [netdrv] nfp: add to redhat build configuration (John Linville) [1377767]
- [netdrv] nfp: fix error return code in nfp_net_netdev_open() (John Linville) [1377767]
- [netdrv] nfp: don't pad frames on receive (John Linville) [1377767]
- [netdrv] nfp: drop support for old firmware ABIs (John Linville) [1377767]
- [netdrv] nfp: remove linux/version.h includes (John Linville) [1377767]
- [netdrv] nfp: check idx is -ENOSPC before using it is an index (John Linville) [1377767]
- [netdrv] nfp: implement ethtool .get_link() callback (John Linville) [1377767]
- [netdrv] nfp: remove unused parameter from nfp_net_write_mac_addr() (John Linville) [1377767]
- [netdrv] nfp: correct name of control BAR define (John Linville) [1377767]
- [netdrv] nfp: Replace ndo_add/del_vxlan_port with ndo_add/del_udp_enc_port (John Linville) [1377767]
- [netdrv] nfp: use correct index to mask link state irq (John Linville) [1377767]
- [netdrv] nfp: add async reconfiguration mechanism (John Linville) [1377767]
- [netdrv] nfp: remove buggy RX buffer length validation (John Linville) [1377767]
- [netdrv] nfp: remove unused suspicious mask defines (John Linville) [1377767]
- [netdrv] nfp: correct names of constants in comments (John Linville) [1377767]
- [netdrv] nfp: remove unnecessary static (John Linville) [1377767]
- [netdrv] nfp: check the right pointer for errors (John Linville) [1377767]
- [netdrv] nfp: allow ring size reconfiguration at runtime (John Linville) [1377767]
- [netdrv] nfp: pass ring count as function parameter (John Linville) [1377767]
- [netdrv] nfp: convert .ndo_change_mtu() to prepare/commit paradigm (John Linville) [1377767]
- [netdrv] nfp: propagate list buffer size in struct rx_ring (John Linville) [1377767]
- [netdrv] nfp: sync ring state during FW reconfiguration (John Linville) [1377767]
- [netdrv] nfp: slice .ndo_open() and .ndo_stop() up (John Linville) [1377767]
- [netdrv] nfp: move filling ring information to FW config (John Linville) [1377767]
- [netdrv] nfp: preallocate RX buffers early in .ndo_open (John Linville) [1377767]
- [netdrv] nfp: reorganize initial filling of RX rings (John Linville) [1377767]
- [netdrv] nfp: cleanup tx ring flush and rename to reset (John Linville) [1377767]
- [netdrv] nfp: allocate ring SW structs dynamically (John Linville) [1377767]
- [netdrv] nfp: make *x_ring_init do all the init (John Linville) [1377767]
- [netdrv] nfp: break up nfp_net_{alloc|free}_rings (John Linville) [1377767]
- [netdrv] nfp: move link state interrupt request/free calls (John Linville) [1377767]
- [netdrv] nfp: correct RX buffer length calculation (John Linville) [1377767]
- [netdrv] nfp: call netif_carrier_off() during init (John Linville) [1377767]
- [netdrv] nfp: clear ring delayed kick counters (John Linville) [1377767]
- [netdrv] net: Rename NETIF_F_ALL_CSUM to NETIF_F_CSUM_MASK (John Linville) [1377767]
- [netdrv] net: add driver for Netronome NFP4000/NFP6000 NIC VFs (John Linville) [1377767]

* Wed Feb 22 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-573.el7]
- [net] mac80211: fix legacy and invalid rx-rate report (Stanislaw Gruszka) [1411078]
- [pci] msi: Simplify PCI MSI code by initializing msi_desc.nvec_used earlier (Prarit Bhargava) [1417650]
- [x86] perf/x86/intel/rapl: Make package handling more robust (Jiri Olsa) [1418688]
- [x86] perf/x86/intel/rapl: Convert to hotplug state machine (Jiri Olsa) [1418688]
- [x86] perf/x86: Set pmu->module in Intel PMU modules (Jiri Olsa) [1418688]
- [x86] kvm: vmx: enable guest access to LMCE related MSRs (Paul Lai) [1402102]
- [x86] kvm: vmx: validate individual bits of guest MSR_IA32_FEATURE_CONTROL (Paul Lai) [1402102]
- [x86] kvm: vmx: move msr_ia32_feature_control to vcpu_vmx (Paul Lai) [1402102]
- [x86] pci: vmd: Use x86_vector_domain as parent domain (Myron Stowe) [1395404]
- [x86] asm/irq: Stop relying on magic JMP behavior for early_idt_handlers (Prarit Bhargava) [1422146]
- [s390] scsi: zfcp: fix use-after-free by not tracing WKA port open/close on failed send (Hendrik Brueckner) [1421749]
- [s390] scsi: zfcp: fix rport unblock race with LUN recovery (Hendrik Brueckner) [1421750]
- [s390] scsi: zfcp: do not trace pure benign residual HBA responses at default level (Hendrik Brueckner) [1421751]
- [s390] scsi: zfcp: fix use-after-"free" in FC ingress path after TMF (Hendrik Brueckner) [1421752]
- [block] Copy a user iovec if it includes gaps (Jeff Moyer) [1421263]
- [tools] toops: Sync tools/include/uapi/linux/perf_event.h with the kernel (Jiri Olsa) [1391242]
- [tools] perf record: Add clockid parameter (Jiri Olsa) [1391242]
- [kernel] perf: Add per event clockid support (Jiri Olsa) [1391242 1404539]
- [kernel] perf: Pass the event to arch_perf_update_userpage() (Jiri Olsa) [1391242]
- [kernel] time: Introduce tk_fast_raw (Jiri Olsa) [1391242]
- [kernel] time: Parametrize all tk_fast_mono users (Jiri Olsa) [1391242]
- [kernel] timekeeping: Pass readout base to update_fast_timekeeper() (Jiri Olsa) [1391242]
- [kernel] timekeeping: Provide fast and NMI safe access to CLOCK_MONOTONIC (Jiri Olsa) [1391242]
- [kernel] seqcount: Add raw_write_seqcount_latch() (Jiri Olsa) [1391242]
- [kernel] audit: consistently record PIDs with task_tgid_nr() (Richard Guy Briggs) [1379453]
- [kernel] audit: Simplify and correct audit_log_capset (Richard Guy Briggs) [1379453]
- [kernel] audit: log module name on init_module (Richard Guy Briggs) [1382500]
- [crypto] rsa - add .gitignore for crypto/*.-asn1.[ch] files (Prarit Bhargava) [1422663]
- [netdrv] iwlwifi: mvm: fix txq aggregation bug (Stanislaw Gruszka) [1362524]
- [powerpc] Convert cmp to cmpd in idle enter sequence (Steve Best) [1418770]
- [powerpc] powerpc/vdso64: Use double word compare on pointers (Steve Best) [1418770]

* Tue Feb 21 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-572.el7]
- [net] ipv6: Don't unset flowi6_proto in ipxip6_tnl_xmit() (Jakub Sitnicki) [1369158]
- [net] ipv6: fix 4in6 tunnel receive path (Jakub Sitnicki) [1369158]
- [net] gre6: add Kconfig dependency for NET_IPGRE_DEMUX (Jakub Sitnicki) [1369158]
- [net] ip6_tunnel: Account for tunnel header in tunnel MTU (Jakub Sitnicki) [1369158]
- [net] gre: use nla_get_be32() to extract flowinfo (Jakub Sitnicki) [1369158]
- [net] ip6_gre: fix flowi6_proto value in ip6gre_xmit_other() (Jakub Sitnicki) [1369158]
- [net] gre: set inner_protocol on xmit (Jakub Sitnicki) [1369158]
- [net] gre: fix error handler (Jakub Sitnicki) [1369158]
- [net] ipv4: Add ability to have GRE ignore DF bit in IPv4 payloads (Jakub Sitnicki) [1369158]
- [net] ip6gre: Allow live link address change (Jakub Sitnicki) [1369158]
- [net] ip6_gre: Set flowi6_proto as IPPROTO_GRE in xmit path. (Jakub Sitnicki) [1369158]
- [net] ip6_gre: Fix MTU setting for ip6gretap (Jakub Sitnicki) [1369158]
- [net] gre: do not keep the GRE header around in collect medata mode (Jakub Sitnicki) [1369158]
- [net] gre: Fix wrong tpi->proto in WCCP (Jakub Sitnicki) [1369158]
- [net] ip6_gre: Fix get_size calculation for gre6 tunnel (Jakub Sitnicki) [1369158]
- [net] ip6_gre: Use correct flags for reading TUNNEL_SEQ (Jakub Sitnicki) [1369158]
- [net] ip6_gre: Set inner protocol correctly in __gre6_xmit (Jakub Sitnicki) [1369158]
- [net] ip6_gre: Fix MTU setting (Jakub Sitnicki) [1369158]
- [net] gre6: Fix flag translations (Jakub Sitnicki) [1369158]
- [net] gre: receive also TEB packets for lwtunnels (Jakub Sitnicki) [1369158]
- [net] gre: move iptunnel_pull_header down to ipgre_rcv (Jakub Sitnicki) [1369158]
- [net] gre: change gre_parse_header to return the header length (Jakub Sitnicki) [1369158]
- [net] gre: remove superfluous pskb_may_pull (Jakub Sitnicki) [1369158]
- [net] gre6: Cleanup GREv6 transmit path, call common GRE functions (Jakub Sitnicki) [1369158]
- [net] ipv6: Generic tunnel cleanup (Jakub Sitnicki) [1369158]
- [net] gre: Create common functions for transmit (Jakub Sitnicki) [1369158]
- [net] ipv6: Create ip6_tnl_xmit (Jakub Sitnicki) [1369158]
- [net] gre6: Cleanup GREv6 receive path, call common GRE functions (Jakub Sitnicki) [1369158]
- [net] gre: Move utility functions to common headers (Jakub Sitnicki) [1369158]
- [net] ipv6: Cleanup IPv6 tunnel receive path (Jakub Sitnicki) [1369158]
- [net] ip6gre: Add support for GSO (Jakub Sitnicki) [1369158]
- [net] gre: Add support for GRO/GSO of IPv6 GRE traffic (Jakub Sitnicki) [1369158]
- [net] ip6gre: Add support for basic offloads offloads excluding GSO (Jakub Sitnicki) [1369158]
- [net] ip6gretap: Fix MTU to allow for Ethernet header (Jakub Sitnicki) [1369158]
- [net] gre: clear IFF_TX_SKB_SHARING (Jakub Sitnicki) [1369158]
- [net] gre6: allow to update all parameters via rtnl (Jakub Sitnicki) [1369158]
- [net] ip6_gre: Reduce log level in ip6gre_err() to debug (Jakub Sitnicki) [1369158]
- [net] gre: use be16 variants of netlink functions (Jakub Sitnicki) [1369158]
- [net] ip6_gre: fix endianness errors in ip6gre_err (Jakub Sitnicki) [1369158]
- [net] gre: allow live address change (Jakub Sitnicki) [1369158]
- [net] gre: Set inner mac header in gro complete (Jakub Sitnicki) [1369158]
- [net] gre: Fix typo in returning flags in netlink (Jakub Sitnicki) [1369158]
- [net] ip6gre: add a rtnl link alias for ip6gretap (Jakub Sitnicki) [1369158]
- [net] gre: allow changing mac address when device is up (Jakub Sitnicki) [1369158]
- [net] ip6_gre: don't allow to remove the fb_tunnel_dev (Jakub Sitnicki) [1369158]
- [net] gre: use icmp_hdr() to get inner ip header (Jakub Sitnicki) [1369158]
- [net] ipv6: Fix the upper MTU limit in GRE tunnel (Jakub Sitnicki) [1369158]
- [net] geneve: avoid use-after-free of skb->data (Sabrina Dubroca) [1326309]
- [net] vxlan: Add new UDP encapsulation offload type for VXLAN-GPE (Sabrina Dubroca) [1326309]
- [net] Merge VXLAN and GENEVE push notifiers into a single notifier (Sabrina Dubroca) [1326309]
- [net] Combine GENEVE and VXLAN port notifiers into single functions (Sabrina Dubroca) [1326309]
- [net] vxlan/geneve: Include udp_tunnel.h in vxlan/geneve.h and fixup includes (Sabrina Dubroca) [1326309]
- [net] geneve: fix max_mtu setting (Sabrina Dubroca) [1326309]
- [net] geneve: fix tx_errors statistics (Sabrina Dubroca) [1326309]
- [net] geneve: testing the wrong variable in geneve6_build_skb() (Sabrina Dubroca) [1326309]
- [net] ip_tunnel_core: iptunnel_handle_offloads returns int and doesn't free skb (Sabrina Dubroca) [1326309]
- [net] geneve: make access to tunnel options similar to vxlan (Sabrina Dubroca) [1326309]
- [net] Optimize local checksum offload (Sabrina Dubroca) [1326318]
- [net] documentation/networking: more accurate LCO explanation (Sabrina Dubroca) [1326318]
- [net] documentation/networking: add checksum-offloads.txt to explain LCO (Sabrina Dubroca) [1326318]
- [net] ip_tunnel: remove 'csum_help' argument to iptunnel_handle_offloads (Sabrina Dubroca) [1326318]
- [net] gre: Implement LCO for GRE over IPv4 (Sabrina Dubroca) [1326318]
- [net] vxlan: enable local checksum offload (Sabrina Dubroca) [1326318]
- [net] enable LCO for udp_tunnel_handle_offloads() users (Sabrina Dubroca) [1326318]
- [net] udp: always set up for CHECKSUM_PARTIAL offload (Sabrina Dubroca) [1326318]
- [net] local checksum offload for encapsulation (Sabrina Dubroca) [1326318]
- [net] gso: Support partial splitting at the frag_list pointer (Eric Garver) [1405429]
- [net] Add support for IP ID mangling TSO in cases that require encapsulation (Eric Garver) [1405429]
- [net] Fix netdev_fix_features so that TSO_MANGLEID is only available with TSO (Eric Garver) [1405429]
- [net] gso: Only allow GSO_PARTIAL if we can checksum the inner protocol (Eric Garver) [1405429]
- [net] gso: Do not perform partial GSO if number of partial segments is 1 or less (Eric Garver) [1405429]
- [net] gso: Reload iph after pskb_may_pull (Eric Garver) [1326353]
- [net] relax expensive skb_unclone() in iptunnel_handle_offloads() (Eric Garver) [1326353]
- [net] documentation: Add documentation for TSO and GSO features (Eric Garver) [1326353]
- [net] gso: Support partial segmentation offload (Eric Garver) [1326353]
- [net] gro: Add support for TCP with fixed IPv4 ID field, limit tunnel IP ID values (Eric Garver) [1326353]
- [net] gso: Add GSO type for fixed IPv4 ID (Eric Garver) [1326353]
- [net] ethtool: Add support for toggling any of the GSO offloads (Eric Garver) [1326353]
- [net] Reset encap_level to avoid resetting features on inner IP headers (Eric Garver) [1326353]
- [net] bridge: update max_gso_segs and max_gso_size (Eric Garver) [1326353]
- [net] rtnetlink: add IFLA_GSO_MAX_SEGS and IFLA_GSO_MAX_SIZE attributes (Eric Garver) [1326353]
- [net] bridge: reset bridge mtu after deleting an interface (Eric Garver) [1326353]
- [net] gso/udp: Use skb->len instead of udph->len to determine length of original skb (Eric Garver) [1326353]
- [net] gso: Provide software checksum of tunneled UDP fragmentation offload (Eric Garver) [1326353]
- [net] Allow tunnels to use inner checksum offloads with outer checksums needed (Eric Garver) [1326353]
- [net] udp: Use uh->len instead of skb->len to compute checksum in segmentation (Eric Garver) [1326353]
- [net] udp: Clean up the use of flags in UDP segmentation offload (Eric Garver) [1326353]
- [net] gre: Use inner_proto to obtain inner header protocol (Eric Garver) [1326353]
- [net] gre: Use GSO flags to determine csum need instead of GRE flags (Eric Garver) [1326353]
- [net] Move skb_has_shared_frag check out of GRE code and into segmentation (Eric Garver) [1326353]
- [net] Store checksum result for offloaded GSO checksums (Eric Garver) [1326353]
- [net] Update remote checksum segmentation to support use of GSO checksum (Eric Garver) [1326353]
- [net] Move GSO csum into SKB_GSO_CB (Eric Garver) [1326353]
- [net] fix two sparse errors (Eric Garver) [1326353]
- [net] Drop unecessary enc_features variable from tunnel segmentation functions (Eric Garver) [1326353]

* Mon Feb 20 2017 Rafael Aquini <aquini@redhat.com> [3.10.0-571.el7]
- [vhost] vsock: lookup and setup guest_cid inside vhost_vsock_lock (Stefan Hajnoczi) [1291282]
- [net] vsock/virtio: fix src/dst cid format (Stefan Hajnoczi) [1291282]
- [net] vsock/virtio: mark an internal function static (Stefan Hajnoczi) [1291282]
- [net] vsock/virtio: add a missing __le annotation (Stefan Hajnoczi) [1291282]
- [vhost] vhost-vsock: fix orphan connection reset (Stefan Hajnoczi) [1291282]
- [vhost] vhost-vsock: remove unused vq variable (Stefan Hajnoczi) [1291282]
- [net] vsock: add loopback to virtio_transport (Stefan Hajnoczi) [1291282]
- [net] vsock: Don't dec ack backlog twice for rejected connections (Stefan Hajnoczi) [1291282]
- [net] vhost/vsock: drop space available check for TX vq (Stefan Hajnoczi) [1291282]
- [vhost] vsock: fix vhost virtio_vsock_pkt use-after-free (Stefan Hajnoczi) [1291282]
- [vhost] vsock: Use kvfree() (Stefan Hajnoczi) [1291282]
- [net] vsock: Add Makefile and Kconfig (Stefan Hajnoczi) [1291282]
- [maintainers] vsock: Introduce vhost_vsock.ko (Stefan Hajnoczi) [1291282]
- [maintainers] vsock: Introduce virtio_transport.ko (Stefan Hajnoczi) [1291282]
- [uapi] vsock: Introduce virtio_vsock_common.ko (Stefan Hajnoczi) [1291282]
- [net] vsock: defer sock removal to transports (Stefan Hajnoczi) [1291282]
- [net] vsock: transport-specific vsock_transport functions (Stefan Hajnoczi) [1291282]
- [net] vsock: make listener child lock ordering explicit (Stefan Hajnoczi) [1291282]
- [net] vsock: do not disconnect socket when peer has shutdown SEND only (Stefan Hajnoczi) [1291282]
- [net] af_vsock: Shrink the area influenced by prepa