Name: kernel
Summary: The Linux Kernel
Version: 3.10.106_1.2.2.29.VCA
Release: 1
License: GPL
Group: System Environment/Kernel
Vendor: The Linux Community
URL: http://www.kernel.org
Source: kernel-3.10.106_1.2.2.29.VCA.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{PACKAGE_VERSION}-root
Provides:  kernel-3.10.106-1.2.2.29.VCA
%define __spec_install_post /usr/lib/rpm/brp-compress || :
%define debug_package %{nil}

%description
The Linux Kernel, the operating system core itself

%package headers
Summary: Header files for the Linux kernel for use by glibc
Group: Development/System
Obsoletes: kernel-headers
Provides: kernel-headers = %{version}
%description headers
Kernel-headers includes the C header files that specify the interface
between the Linux kernel and userspace libraries and programs.  The
header files define structures and constants that are needed for
building most standard programs and are also needed for rebuilding the
glibc package.

%package devel
Summary: Development package for building kernel modules to match the 3.10.106_1.2.2.29.VCA kernel
Group: System Environment/Kernel
AutoReqProv: no
%description -n kernel-devel
This package provides kernel headers and makefiles sufficient to build modules
against the 3.10.106_1.2.2.29.VCA kernel package.

%prep
%setup -q

%build
make clean && make %{?_smp_mflags}

%install
%ifarch ia64
mkdir -p $RPM_BUILD_ROOT/boot/efi $RPM_BUILD_ROOT/lib/modules
mkdir -p $RPM_BUILD_ROOT/lib/firmware
%else
mkdir -p $RPM_BUILD_ROOT/boot $RPM_BUILD_ROOT/lib/modules
mkdir -p $RPM_BUILD_ROOT/lib/firmware
%endif
mkdir -p $RPM_BUILD_ROOT/lib/firmware/3.10.106-1.2.2.29.VCA
INSTALL_MOD_PATH=$RPM_BUILD_ROOT make %{?_smp_mflags} KBUILD_SRC= mod-fw= modules_install
INSTALL_FW_PATH=$RPM_BUILD_ROOT/lib/firmware/3.10.106-1.2.2.29.VCA
make INSTALL_FW_PATH=$INSTALL_FW_PATH firmware_install
%ifarch ia64
cp $KBUILD_IMAGE $RPM_BUILD_ROOT/boot/efi/vmlinuz-3.10.106-1.2.2.29.VCA
ln -s efi/vmlinuz-3.10.106-1.2.2.29.VCA $RPM_BUILD_ROOT/boot/
%else
%ifarch ppc64
cp vmlinux arch/powerpc/boot
cp arch/powerpc/boot/$KBUILD_IMAGE $RPM_BUILD_ROOT/boot/vmlinuz-3.10.106-1.2.2.29.VCA
%else
cp $KBUILD_IMAGE $RPM_BUILD_ROOT/boot/vmlinuz-3.10.106-1.2.2.29.VCA
%endif
%endif
make %{?_smp_mflags} INSTALL_HDR_PATH=$RPM_BUILD_ROOT/usr KBUILD_SRC= headers_install
cp System.map $RPM_BUILD_ROOT/boot/System.map-3.10.106-1.2.2.29.VCA
cp .config $RPM_BUILD_ROOT/boot/config-3.10.106-1.2.2.29.VCA
%ifnarch ppc64
cp vmlinux vmlinux.orig
bzip2 -9 vmlinux
mv vmlinux.bz2 $RPM_BUILD_ROOT/boot/vmlinux-3.10.106-1.2.2.29.VCA.bz2
mv vmlinux.orig vmlinux
%endif
rm -f $RPM_BUILD_ROOT/lib/modules/3.10.106-1.2.2.29.VCA/{build,source}
mkdir -p $RPM_BUILD_ROOT/usr/src/kernels/3.10.106-1.2.2.29.VCA
EXCLUDES="--exclude SCCS --exclude BitKeeper --exclude .svn --exclude CVS --exclude .pc --exclude .hg --exclude .git --exclude .tmp_versions --exclude=*vmlinux* --exclude=*.o --exclude=*.ko --exclude=*.cmd --exclude=Documentation --exclude=firmware --exclude .config.old --exclude .missing-syscalls.d"
tar $EXCLUDES -cf- . | (cd $RPM_BUILD_ROOT/usr/src/kernels/3.10.106-1.2.2.29.VCA;tar xvf -)
cd $RPM_BUILD_ROOT/lib/modules/3.10.106-1.2.2.29.VCA
ln -sf /usr/src/kernels/3.10.106-1.2.2.29.VCA build
ln -sf /usr/src/kernels/3.10.106-1.2.2.29.VCA source

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ -x /sbin/installkernel -a -r /boot/vmlinuz-3.10.106-1.2.2.29.VCA -a -r /boot/System.map-3.10.106-1.2.2.29.VCA ]; then
cp /boot/vmlinuz-3.10.106-1.2.2.29.VCA /boot/vmlinuz-3.10.106-1.2.2.29.VCA-rpm
cp /boot/System.map-3.10.106-1.2.2.29.VCA /boot/System.map-3.10.106-1.2.2.29.VCA-rpm
rm -f /boot/vmlinuz-3.10.106-1.2.2.29.VCA /boot/System.map-3.10.106-1.2.2.29.VCA
/sbin/installkernel 3.10.106-1.2.2.29.VCA /boot/vmlinuz-3.10.106-1.2.2.29.VCA-rpm /boot/System.map-3.10.106-1.2.2.29.VCA-rpm
rm -f /boot/vmlinuz-3.10.106-1.2.2.29.VCA-rpm /boot/System.map-3.10.106-1.2.2.29.VCA-rpm
fi

%files
%defattr (-, root, root)
%dir /lib/modules
/lib/modules/3.10.106-1.2.2.29.VCA
%exclude /lib/modules/3.10.106-1.2.2.29.VCA/build
%exclude /lib/modules/3.10.106-1.2.2.29.VCA/source
/lib/firmware/3.10.106-1.2.2.29.VCA
/boot/*

%files headers
%defattr (-, root, root)
/usr/include

%files devel
%defattr (-, root, root)
/usr/src/kernels/3.10.106-1.2.2.29.VCA
/lib/modules/3.10.106-1.2.2.29.VCA/build
/lib/modules/3.10.106-1.2.2.29.VCA/source

