'-------------------------------------------------------------------------------------------------'
' Copyright  2015, Intel Corporation.
' 
' DetectIntelAuthenticate.vbs
' 
' This VBScript runs the Authenticate_PreCheck.exe tool (via the .bat file) and saves the output
' in the CIMv2 namespace on the host platform. Other tools and scripts can then query this data
' using WQL queries. It is recommended to run this script periodically to update the status
' of the Intel Authenticate entries in the CIMv2 namespace.
' ------------------------------------------------------------------------------------------------'

Option Explicit

Wscript.Echo  "==============Starting Script============ " & NOW

Dim objWMIService, oShell, moniker, fileOs, Override, WmiService, programs, tempObj
Dim ns, cls, ret, path
Dim KeyName, Supported, LastExitCode, Output, isClientInstalled, isEngineInstalled

Set oShell = WScript.CreateObject("WScript.Shell")
ns = oShell.ExpandEnvironmentStrings("%MFA_NAMESPACE%")
cls = oShell.ExpandEnvironmentStrings("%MFA_CLASS%")
LastExitCode = oShell.ExpandEnvironmentStrings("%DISCOVERY_EXIT_STATUS%")
Override = oShell.ExpandEnvironmentStrings("%OVERRIDE_OLD_WMI_CLASS%")
If ns = "%MFA_NAMESPACE%" Then
 ns = "root\CIMV2"
End If
If cls = "%MFA_CLASS%" Then
 cls = "Intel_Authenticate"
End If
If LastExitCode = "%DISCOVERY_EXIT_STATUS%"  Then
 LastExitCode = 0
End If
isClientInstalled = false
isEngineInstalled = false
Set fileOs  = CreateObject("Scripting.FileSystemObject")

Wscript.Echo "==============Save data=====================" 
ret = ""
moniker = "winmgmts:" _
   & "{" _
   & "impersonationLevel=impersonate," _
   & "authenticationLevel=PktPrivacy"_
   & "}" _
   & "!\\" _
   & ".\" _
   & ns
Wscript.Echo "moniker=" &moniker
Set WmiService = GetObject(moniker)
if override = "Override" then
    WmiService.delete cls
end if
Set objWMIService = WmiService.Get
objWMIService.Path_.Class = cls
objWMIService.Properties_.Add "KeyName", 8
objWMIService.Properties_.Add "Supported", 11
objWMIService.Properties_.Add "LastExitCode", 20
objWMIService.Properties_.Add "Output", 8
objWMIService.Properties_.Add "isClientInstalled", 11
objWMIService.Properties_.Add "isEngineInstalled", 11
objWMIService.Properties_("KeyName").Qualifiers_.add "key", true 
ret = objWMIService.Put_()

Set programs = WmiService.ExecQuery("Select * from Win32_Product where Name LIKE '%Intel Authenticate%'",,48)

For Each tempObj in programs
	If tempObj.Name = "Intel Authenticate" Then
		Wscript.Echo "Intel Authenticate found."
		isClientInstalled = true
		isEngineInstalled = true
	End If
	If tempObj.Name = "Intel Authenticate: Engine" Then
		Wscript.Echo "Intel Authenticate Engine found."
		isEngineInstalled = true
	End If
Next



if "" <> ret Then
    KeyName = "Authenticate_PreCheck"
    ' Platform Discovery
    path = oShell.CurrentDirectory & "\Authenticate_Check.exe"
    if (not fileOs.FileExists(path)) Then
		WScript.Echo(path &" file could not been found, will not perform platform discovery.")
		WSCript.Quit(-2)
	else
		WScript.Echo("Authenticate_Check.exe file was found, running Authenticate check.")
        call Authenticate_PreCheck(path)
    End If
else
	WScript.Echo("Failed to create WMI class.")
	WSCript.Quit(-1)
End If

WSCript.Quit(0)

Function SaveData()
    Dim classInst, ins, pos, i
    dim dataSize
    if "" = KeyName then 
        exit function
    end if
    Wscript.Echo "********* Adding pre check info to Intel_IPT_MFA class *********"
    Wscript.Echo "Namespace: " & ns
    Wscript.Echo "Class: " & cls
    Wscript.Echo "Attribute KeyName(Key): " & KeyName
    Wscript.Echo "Attribute LastExitCode: " & LastExitCode
    Set classInst = GetObject(Moniker & ":" & cls) 
    Set ins = classInst.SpawnInstance_ 
    ins.KeyName = KeyName
    ins.LastExitCode = LastExitCode
    ins.Output = Output
    ins.Supported = (0 = LastExitCode)
    ins.isClientInstalled = isClientInstalled
    ins.isEngineInstalled = isEngineInstalled
    ins.Put_() 
    Wscript.Echo "******************************************************"
end Function

Function Authenticate_PreCheck (exec)
    Dim xmlDoc, retExcec, dataL, i, j, xml
    dim fields, software, hardware, framework
    Set retExcec = oShell.exec(exec & " /PreCheck")
    While (0 = retExcec.Status)
        Wscript.Sleep 1000
    wend
    Output = retExcec.StdOut.ReadAll
	if Output <> "" then
		WScript.Echo Output
	end if
    LastExitCode = retExcec.ExitCode
    SaveData 
end Function
