/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api;

import com.intel.stl.api.CertsDescription;
import com.intel.stl.api.ICertsAssistant;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.Utils;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.STLMessages;
import java.util.ArrayList;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DefaultCertsAssistant
implements ICertsAssistant {
    public static final int MAX_TRIES = 5;
    public static final long TIME_OUT = 30000L;
    private CertsDescription currentCerts;
    private KeyManagerFactory kmf;
    private TrustManagerFactory tmf;
    private JPanel certPanel;
    private JTextField keyFileField;
    private JPasswordField keyPwdField;
    private JTextField trustFileField;
    private JPasswordField trustPwdField;

    @Override
    public SSLEngine getSSLEngine(SubnetDescription subnet) throws Exception {
        HostInfo host = subnet.getCurrentFE();
        return this.getSSLEngine(host);
    }

    @Override
    public SSLEngine getSSLEngine(HostInfo host) throws Exception {
        String hostname = host.getHost();
        int port = host.getPort();
        KeyManagerFactory kmf = this.getKeyManagerFactory(host);
        TrustManagerFactory tmf = this.getTrustManagerFactory(host);
        SSLEngine engine = Utils.createSSLEngine(hostname, port, kmf, tmf);
        return engine;
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory(SubnetDescription subnet) {
        if (subnet == null) {
            return null;
        }
        return this.getKeyManagerFactory(subnet.getCurrentFE());
    }

    public KeyManagerFactory getKeyManagerFactory(HostInfo host) {
        CertsDescription certs = host.getCertsDescription();
        if (certs == null) {
            return null;
        }
        this.checkCerts(certs);
        return this.kmf;
    }

    @Override
    public TrustManagerFactory getTrustManagerFactory(SubnetDescription subnet) {
        if (subnet == null) {
            return null;
        }
        return this.getTrustManagerFactory(subnet.getCurrentFE());
    }

    public TrustManagerFactory getTrustManagerFactory(HostInfo host) {
        CertsDescription certs = host.getCertsDescription();
        if (certs == null) {
            return null;
        }
        this.checkCerts(certs);
        return this.tmf;
    }

    @Override
    public void clearSubnetFactories(SubnetDescription subnet) {
        CertsDescription certs;
        if (subnet != null && (certs = subnet.getCurrentFE().getCertsDescription()) != null && certs.equals(this.currentCerts)) {
            this.kmf = null;
            this.tmf = null;
        }
    }

    private synchronized void checkCerts(CertsDescription certs) {
        if (!certs.equals(this.currentCerts)) {
            this.showPanel(certs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPanel(CertsDescription certs) {
        this.kmf = null;
        this.tmf = null;
        final Exchanger<Object> xchgr = new Exchanger<Object>();
        ArrayList<Exception> errors = new ArrayList<Exception>();
        final AtomicReference<CertsDescription> currCerts = new AtomicReference<CertsDescription>(certs);
        for (int tries = 5; tries > 0; --tries) {
            if (!errors.isEmpty() || !currCerts.get().hasPwds()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CertsDescription newCerts = DefaultCertsAssistant.this.getNewCerts((CertsDescription)currCerts.get());
                        try {
                            xchgr.exchange(newCerts, 30000L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (TimeoutException e) {
                            e.printStackTrace();
                        }
                    }
                });
                try {
                    currCerts.set(xchgr.exchange(null));
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (currCerts.get() == null) {
                System.out.println("Certs is null");
                return;
            }
            errors.clear();
            KeyManagerFactory kmf = null;
            try {
                this.kmf = kmf = Utils.createKeyManagerFactory(currCerts.get().getKeyStoreFile(), currCerts.get().getKeyStorePwd());
            }
            catch (Exception e) {
                errors.add(e);
                this.showErrorMessage(e);
            }
            finally {
                currCerts.get().clearKeyPwd();
            }
            TrustManagerFactory tmf = null;
            try {
                this.tmf = tmf = Utils.createTrustManagerFactory(currCerts.get().getTrustStoreFile(), currCerts.get().getTrustStorePwd());
            }
            catch (Exception e) {
                errors.add(e);
                this.showErrorMessage(e);
            }
            finally {
                currCerts.get().clearTrustPwd();
            }
            if (!errors.isEmpty() || kmf == null || tmf == null) continue;
            this.currentCerts = currCerts.get();
            break;
        }
    }

    private void showErrorMessage(final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, StringUtils.getErrorMessage(e), "Error", 0);
            }
        });
    }

    private CertsDescription getNewCerts(CertsDescription certs) {
        JPanel panel = this.getCertPanel(certs);
        Object[] options = new String[]{"OK", "Cancel"};
        int option = JOptionPane.showOptionDialog(null, panel, STLMessages.STL61001_CERT_CONF.getDescription(), 1, -1, null, options, options[0]);
        if (option == 0) {
            CertsDescription newCerts = new CertsDescription(this.keyFileField.getText(), this.trustFileField.getText());
            newCerts.setKeyStorePwd(this.keyPwdField.getPassword());
            newCerts.setTrustStorePwd(this.trustPwdField.getPassword());
            return newCerts;
        }
        return null;
    }

    private JPanel getCertPanel(CertsDescription certs) {
        if (this.certPanel == null) {
            this.certPanel = new JPanel();
            BoxLayout layout = new BoxLayout(this.certPanel, 1);
            this.certPanel.setLayout(layout);
            JLabel label = new JLabel(STLMessages.STL61002_KEY_STORE_LOC.getDescription());
            this.certPanel.add(label);
            this.keyFileField = new JTextField();
            this.certPanel.add(this.keyFileField);
            label = new JLabel(STLMessages.STL61003_KEY_STORE_PWD.getDescription());
            this.certPanel.add(label);
            this.keyPwdField = new JPasswordField();
            this.certPanel.add(this.keyPwdField);
            label = new JLabel(STLMessages.STL61004_TRUST_STORE_LOC.getDescription());
            this.certPanel.add(label);
            this.trustFileField = new JTextField();
            this.certPanel.add(this.trustFileField);
            label = new JLabel(STLMessages.STL61005_TRUST_STORE_PWD.getDescription());
            this.certPanel.add(label);
            this.trustPwdField = new JPasswordField();
            this.certPanel.add(this.trustPwdField);
        }
        if (certs != null) {
            this.keyFileField.setText(certs.getKeyStoreFile());
            this.trustFileField.setText(certs.getTrustStoreFile());
        }
        return this.certPanel;
    }
}

