/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.configuration.EventRuleAction;
import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.api.subnet.SubnetDescription;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class EventRule
implements Serializable {
    static final long serialVersionUID = 1L;
    private String eventName = null;
    private List<String> eventSourceVector = null;
    private EventType eventType = null;
    private NoticeSeverity eventSeverity = null;
    private List<EventRuleAction> eventActions = null;
    private boolean eventEnabled = false;
    private Set<SubnetDescription> eventSubnets = null;
    private int lid = 0;
    private short portNum = 0;
    private int commandId = 0;
    private String message = null;

    public EventRule() {
        this.eventSourceVector = new Vector<String>();
    }

    public EventRule(EventType evtType, NoticeSeverity evtSeverity, List<EventRuleAction> evtActionList) {
        this.eventType = evtType;
        this.eventSeverity = evtSeverity;
        this.eventActions = evtActionList;
    }

    public EventRule(EventRule eventRule) {
        this(eventRule.getEventType(), eventRule.getEventSeverity(), eventRule.getEventActions());
    }

    public void setEventSourceVector(List<String> eventsource) {
        this.eventSourceVector = eventsource;
    }

    public void setEventType(EventType eventType, int command) {
        this.eventType = eventType;
        this.setCommandId(eventType, command);
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventSeverity(NoticeSeverity eventSeverity) {
        this.eventSeverity = eventSeverity;
    }

    public NoticeSeverity getEventSeverity() {
        return this.eventSeverity;
    }

    public void setEventActions(List<EventRuleAction> eventActions) {
        this.eventActions = eventActions;
    }

    public List<EventRuleAction> getEventActions() {
        return this.eventActions;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventEnabled(boolean enabled) {
        this.eventEnabled = enabled;
    }

    public void setEventSubnets(Set<SubnetDescription> eventSubnets) {
        this.eventSubnets = eventSubnets;
    }

    public Set<SubnetDescription> getEventSubnets() {
        return this.eventSubnets;
    }

    public boolean isEventEnabled() {
        return this.eventEnabled;
    }

    private void setCommandId(EventType eventType, int command) {
        this.commandId = command;
        this.eventType = eventType;
    }

    public void setCommandId(int command) {
        this.commandId = command;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public void setLID(int lid) {
        this.lid = lid;
    }

    public int getLID() {
        return this.lid;
    }

    public void setPortNum(short portNum) {
        this.portNum = portNum;
    }

    public short getPortNum() {
        return this.portNum;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getEventSourceVector() {
        return this.eventSourceVector;
    }

    public void addEventSource(String eventSource) {
        this.eventSourceVector.add(eventSource);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventName == null ? 0 : this.eventName.toLowerCase().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventRule)) {
            return false;
        }
        EventRule other = (EventRule)obj;
        return !(this.eventName == null ? other.eventName != null : !this.eventName.equalsIgnoreCase(other.eventName));
    }

    public String toString() {
        String actions = new String();
        Iterator<EventRuleAction> it = this.eventActions.iterator();
        while (it.hasNext()) {
            actions = actions + it.next().name();
            if (!it.hasNext()) continue;
            actions = actions + ",";
        }
        return "EventRule [type=" + this.eventType.name() + ", class=" + this.eventType.getEventClass().name() + ", severity=" + this.eventSeverity.name() + ", actions=" + actions + "]";
    }
}

