/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum LinkInitReason {
    NONE(0),
    LINKUP(1),
    FLAPPING(2),
    OUTSIDE_POLICY(8),
    QUARANTINED(9),
    INSUFIC_CAPABILITY(10);

    private static final Map<Byte, LinkInitReason> linkInitReasonMap;
    private final byte code;

    private LinkInitReason(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static LinkInitReason getLinkInitReason(byte code) {
        LinkInitReason res = linkInitReasonMap.get(code);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Unsupported LinkInitReason " + StringUtils.byteHexString(code));
    }

    static {
        linkInitReasonMap = new HashMap<Byte, LinkInitReason>(){
            private static final long serialVersionUID = 1L;
            {
                for (LinkInitReason ldr : LinkInitReason.values()) {
                    this.put(ldr.code, ldr);
                }
            }
        };
    }
}

