/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum LinkSpeedMask {
    STL_LINK_SPEED_NOP(0, 0.0f),
    STL_LINK_SPEED_12_5G(1, 12.5f),
    STL_LINK_SPEED_25G(2, 25.78125f);

    private final short val;
    private final float speedInGb;

    private LinkSpeedMask(short inval, float speedInGb) {
        this.val = inval;
        this.speedInGb = speedInGb;
    }

    public short getSpeedMask() {
        return this.val;
    }

    public float getSpeedInGb() {
        return this.speedInGb;
    }

    public static LinkSpeedMask getLinkSpeedMask(short inval) {
        for (LinkSpeedMask spd : LinkSpeedMask.values()) {
            if (spd.getSpeedMask() != inval) continue;
            return spd;
        }
        throw new IllegalArgumentException("Unsupported Link Speed " + StringUtils.shortHexString(inval));
    }

    public static List<LinkSpeedMask> getSpeedMasks(short inval) {
        if (inval == LinkSpeedMask.STL_LINK_SPEED_NOP.val) {
            return Collections.singletonList(STL_LINK_SPEED_NOP);
        }
        ArrayList<LinkSpeedMask> res = new ArrayList<LinkSpeedMask>();
        for (LinkSpeedMask mask : LinkSpeedMask.values()) {
            if (mask == STL_LINK_SPEED_NOP || (inval & mask.getSpeedMask()) != mask.getSpeedMask()) continue;
            res.add(mask);
        }
        return res;
    }
}

