/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.Arrays;

public enum PortLinkMode {
    NOP(0),
    STL(4);

    private final byte mode;

    private PortLinkMode(byte mode) {
        this.mode = mode;
    }

    public byte getMode() {
        return this.mode;
    }

    public static PortLinkMode getPortLinkMode(byte mode) {
        for (PortLinkMode plm : PortLinkMode.values()) {
            if (plm.getMode() != mode) continue;
            return plm;
        }
        throw new IllegalArgumentException("Unsupported PortLinkMode " + StringUtils.byteHexString(mode));
    }

    public static PortLinkMode[] getPortLinkModes(byte mode) {
        if (PortLinkMode.isNoneSupported(mode)) {
            return new PortLinkMode[]{NOP};
        }
        PortLinkMode[] portLinkModes = PortLinkMode.values();
        PortLinkMode[] modes = new PortLinkMode[portLinkModes.length];
        int numModes = 0;
        for (PortLinkMode plm : portLinkModes) {
            if (plm == NOP || (plm.mode & mode) != plm.mode) continue;
            modes[numModes] = plm;
            ++numModes;
        }
        return Arrays.copyOf(modes, numModes);
    }

    public static boolean isNoneSupported(byte mode) {
        return mode == PortLinkMode.NOP.mode;
    }
}

